/* RTEMS Multiprocessor for quad-core GR740 system */

/* Set using compiler options */
#ifndef NODE_NUMBER
#error NODE_NUMBER is not defined.. can be set by compiler -D switch
#endif

#include <rtems.h>
/* configuration information */

#define CONFIGURE_INIT

#include <bsp.h> /* for device driver prototypes */

rtems_task Init( rtems_task_argument argument);	/* forward declaration needed */

/* Configure nodes uniquely depending on "NODE_NUMBER" */
#include "config_amp.c"

#include <stdio.h>
#include <stdlib.h>

extern int LEON3_Cpu_Index;
int nodeid;
#if (NODE_NUMBER == 1)
 #define NODE_STARTED node_started_1
#elif (NODE_NUMBER == 2)
 #define NODE_STARTED node_started_2
#elif (NODE_NUMBER == 3)
 #define NODE_STARTED node_started_3
 #elif (NODE_NUMBER == 4)
 #define NODE_STARTED node_started_4
#else
 #error no such node number
#endif
int NODE_STARTED = 0;

#ifdef CONFIGURE_MP_APPLICATION
/* Override default SHM configuration */
shm_config_table BSP_shm_cfgtbl = 
{
	.base = (void *)SHM_START,
	.length = SHM_SIZE
};
#endif

rtems_task Init(
  rtems_task_argument ignored
)
{
	nodeid = LEON3_Cpu_Index;

	NODE_STARTED = 1;

#if (NODE_NUMBER == 1)
	/* Wake the other 3 CPUs by writing to IRQ multiprocessor register */
	*(volatile unsigned long *)0xff905010 = 0x2;
	*(volatile unsigned long *)0xff906010 = 0x4;
	*(volatile unsigned long *)0xff907010 = 0x8;

	printf("NODE[%d]: is Up on RTEMS node %d!\n", nodeid, NODE_NUMBER);

	while ( 1 ) {
		printf( "NODE[%d]: SLEEPING 5s\n", nodeid);
		sleep(5);
	}
#else
	while ( 1 ) {
		sleep(5);
	}
#endif
}
