/*
 *  Authors: Ralf Corsepius (corsepiu@faw.uni-ulm.de) and
 *           Bernd Becker (becker@faw.uni-ulm.de)
 *
 *  COPYRIGHT (c) 1997-1998, FAW Ulm, Germany
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 *
 *  COPYRIGHT (c) 1998.
 *  On-Line Applications Research Corporation (OAR).
 *
 *  The license and distribution terms for this file may be
 *  found in the file LICENSE in this distribution or at
 *  http://www.rtems.com/license/LICENSE.
 *
 *  $Id: start.S,v 1.6 2004/04/16 21:51:30 ralf Exp $
 */

#include <rtems/asm.h>

	BEGIN_CODE
	PUBLIC(start)
SYM (start):
        ! install the stack pointer
	mov.l	stack_k,r15

	! zero out bss
	mov.l	edata_k,r0
	mov.l	end_k,r1
	mov	#0,r2
0:
	mov.l	r2,@r0
	add	#4,r0
	cmp/ge	r0,r1
	bt	0b

	! copy the vector table from rom to ram
	mov.l   vects_k,r0   	! vectab
	mov	#0,r1		! address of boot vector table
	mov     #0,r2		! number of bytes copied
	mov.w   vects_size,r3   ! size of entries in vectab
1:
	mov.l   @r1+,r4
	mov.l   r4,@r0
	add     #4,r0
	add     #1,r2
	cmp/hi  r3,r2
	bf      1b

	mov.l   vects_k,r0   	! update vbr to point to vectab
	ldc     r0,vbr

	! call the mainline
	mov #0,r4		! argc
	mov.l main_k,r0
	jsr @r0
	mov #0,r5		! argv

	! call exit
	mov	r0,r4
	mov.l	exit_k,r0
	jsr	@r0
	or	r0,r0

	END_CODE

	.align 2
stack_k:
	.long	SYM(stack)
edata_k:
	.long	SYM(edata)
end_k:
	.long	SYM(end)
main_k:
	.long	SYM(boot_card)
exit_k:
	.long	SYM(exit)

vects_k:
	.long	SYM(vectab)
vects_size:
	.word	255

#ifdef __ELF__
	.section .stack,"aw"
#else
	.section .stack
#endif
SYM(stack):
	.long	0xdeaddead
