/*
 *  $Id: barrierattrinit.c,v 1.1 2006/11/15 14:08:48 joel Exp $
 */

#if HAVE_CONFIG_H
#include "config.h"
#endif

#include <pthread.h>
#include <errno.h>

#include <rtems/system.h>

/*PAGE
 *
 *  Barrier Attributes Initialization
 */

int pthread_barrierattr_init(
  pthread_barrierattr_t *attr
)
{
  if ( !attr )
    return EINVAL;

  attr->is_initialized = TRUE;
  attr->process_shared = PTHREAD_PROCESS_PRIVATE;
  return 0;
}
