/* Memory failover routine for NGMP / FTDDR2SPA
 *
 * Author: Magnus Hjorth, Aeroflex Gaisler
 * Contact: support@gaisler.com
 */

/* This routine is meant to be attached to the RTEMS memory scrubber 
 * driver as a custom event handler, see memscrubr_set_errfunc in
 * memscrub_rtems.h
 *
 * When the regeneration threshold is reached, the code performs a 
 * memory probe to see if any of the byte lanes are permanently 
 * damaged. If not, then the normal scrubbing continues. 
 *
 * If there is a permanent error, the code switching routine is 
 * perfomed as described in the FTDDR2SPA IP core manual.
 *
 * After the switching, the routine will check the memory after 
 * each completed scrub run to see if the memory has healed. In
 * that case, a reversed switch is performed. 
 */

#ifndef FAILOVER_H_INCLUDED
#define FAILOVER_H_INCLUDED

#include "memscrub_rtems.h"

/* See the memscrubr_errfunc type declaration in memscrub_rtems.h.
 * ptr should be a pointer to a struct failover_data */
int failover_errfunc(int event, unsigned long *addr, 
		     unsigned long *msgout,
		     void *ptr, struct memscrubr_meminfo *info);

/* Flags for options field */
#define FAILOVER_PROBEALWAYS 1 /* Probe after every scrubber iteration */

struct failover_data {
  int state;
  void *edacregs;
  int options;
  unsigned long testbuf[3];
};

void failover_parse_message(unsigned long msg, int *oldstate, int *newstate, 
			    int *badparts);

#endif
