/*  Driver Manager Configuration file.
 *
 *  COPYRIGHT (c) 2009.
 *  Aeroflex Gaisler AB
 *
 *  The configuration consist of an array with function pointers that
 *  register one or more drivers that will be used by the Driver Manger.
 * 
 *  The Functions are called in the order they are declared.
 *
 *
 *  The license and distribution terms for this file may be
 *  found in the file LICENSE in this distribution or at
 *  http://www.rtems.com/license/LICENSE.
 *
 */


#ifndef _DRIVER_MANAGER_CONFDEFS_H_
#define _DRIVER_MANAGER_CONFDEFS_H_

#include <drvmgr/drvmgr.h>

#ifdef __cplusplus
extern "C" {
#endif

extern struct rtems_drvmgr_drv_reg_func rtems_drvmgr_drivers[];

#ifdef CONFIGURE_INIT

/*** AMBA Plug & Play Drivers ***/
#define DRIVER_AMBAPP_GAISLER_GRETH_REG {greth_register_drv}
extern void greth_register_drv (void);

#define DRIVER_AMBAPP_GAISLER_GRSPW_REG {grspw_register_drv}
extern void grspw_register_drv (void);

#define DRIVER_AMBAPP_GAISLER_GRCAN_REG {grcan_register_drv}
extern void grcan_register_drv (void);

#define DRIVER_AMBAPP_GAISLER_OCCAN_REG {occan_register_drv}
extern void occan_register_drv (void);

#define DRIVER_AMBAPP_GAISLER_B1553BRM_REG {b1553brm_register_drv}
extern void b1553brm_register_drv (void);

#define DRIVER_AMBAPP_GAISLER_B1553RT_REG {b1553rt_register_drv}
extern void b1553rt_register_drv (void);

#define DRIVER_AMBAPP_GAISLER_GRTM_REG {grtm_register_drv}
extern void grtm_register_drv (void);

#define DRIVER_AMBAPP_GAISLER_GRTC_REG {grtc_register_drv}
extern void grtc_register_drv (void);

#define DRIVER_AMBAPP_GAISLER_APBUART_REG {apbuart_register_drv}
extern void apbuart_register_drv(void);

#define DRIVER_AMBAPP_MCTRL_REG {mctrl_register_drv}
extern void mctrl_register_drv(void);

#define DRIVER_AMBAPP_GAISLER_PCIF_REG {pcif_register_drv}
extern void pcif_register_drv(void);

#define DRIVER_AMBAPP_GAISLER_GRPCI_REG {grpci_register_drv}
extern void grpci_register_drv(void);

#define DRIVER_AMBAPP_GAISLER_PCITRACE_REG {pcitrace_register_drv}
extern void pcitrace_register_drv(void);

#define DRIVER_AMBAPP_GAISLER_SPICTRL_REG {spictrl_register_drv}
extern void spictrl_register_drv(void);

#define DRIVER_AMBAPP_GAISLER_I2CMST_REG {i2cmst_register_drv}
extern void i2cmst_register_drv(void);

#define DRIVER_AMBAPP_GAISLER_GRGPIO_REG {grgpio_register_drv}
extern void grgpio_register_drv(void);

#define DRIVER_AMBAPP_GAISLER_GRPWM_REG {grpwm_register_drv}
extern void grpwm_register_drv(void);

#define DRIVER_AMBAPP_GAISLER_GRADCDAC_REG {gradcdac_register_drv}
extern void gradcdac_register_drv(void);

/*** LEON2 AMBA Hard coded bus Drivers ***/
#define DRIVER_LEON2_AT697PCI_REG {at697pci_register_drv}
extern void at697pci_register_drv(void);

#define DRIVER_LEON2_AMBAPP_REG {ambapp_leon2_register}
extern void ambapp_leon2_register(void);


/*** PCI Bus Drivers (PCI Target drivers) */
#define DRIVER_PCI_GR_RASTA_ADCDAC {gr_rasta_adcdac_register_drv}
extern void gr_rasta_adcdac_register_drv(void);

#define DRIVER_PCI_GR_RASTA_IO {gr_rasta_io_register_drv}
extern void gr_rasta_io_register_drv(void);

#define DRIVER_PCI_GR_RASTA_TMTC {gr_rasta_tmtc_register_drv}
extern void gr_rasta_tmtc_register_drv(void);

#define DRIVER_PCI_GR_701 {gr701_register_drv}
extern void gr701_register_drv(void);


/* CONFIGURE DRIVER MANAGER */
struct rtems_drvmgr_drv_reg_func rtems_drvmgr_drivers[] =
{
	/*** AMBA Plug & Play Drivers ***/
#ifdef CONFIGURE_DRIVER_AMBAPP_GAISLER_GRETH
	DRIVER_AMBAPP_GAISLER_GRETH_REG,
#endif
#ifdef CONFIGURE_DRIVER_AMBAPP_GAISLER_GRSPW
	DRIVER_AMBAPP_GAISLER_GRSPW_REG,
#endif
#ifdef CONFIGURE_DRIVER_AMBAPP_GAISLER_GRCAN
	DRIVER_AMBAPP_GAISLER_GRCAN_REG,
#endif
#ifdef CONFIGURE_DRIVER_AMBAPP_GAISLER_OCCAN
	DRIVER_AMBAPP_GAISLER_OCCAN_REG,
#endif
#ifdef CONFIGURE_DRIVER_AMBAPP_GAISLER_B1553BRM
	DRIVER_AMBAPP_GAISLER_B1553BRM_REG,
#endif
#ifdef CONFIGURE_DRIVER_AMBAPP_GAISLER_B1553RT
	DRIVER_AMBAPP_GAISLER_B1553RT_REG,
#endif
#ifdef CONFIGURE_DRIVER_AMBAPP_GAISLER_GRTM
	DRIVER_AMBAPP_GAISLER_GRTM_REG,
#endif
#ifdef CONFIGURE_DRIVER_AMBAPP_GAISLER_GRTC
	DRIVER_AMBAPP_GAISLER_GRTC_REG,
#endif
#ifdef CONFIGURE_DRIVER_AMBAPP_GAISLER_APBUART
	DRIVER_AMBAPP_GAISLER_APBUART_REG,
#endif
#ifdef CONFIGURE_DRIVER_AMBAPP_GAISLER_PCIF
	DRIVER_AMBAPP_GAISLER_PCIF_REG,
#endif
#ifdef CONFIGURE_DRIVER_AMBAPP_GAISLER_GRPCI
	DRIVER_AMBAPP_GAISLER_GRPCI_REG,
#endif
#ifdef CONFIGURE_DRIVER_AMBAPP_MCTRL
	DRIVER_AMBAPP_MCTRL_REG,
#endif
#ifdef CONFIGURE_DRIVER_AMBAPP_GAISLER_PCITRACE
	DRIVER_AMBAPP_GAISLER_PCITRACE_REG,
#endif
#ifdef CONFIGURE_DRIVER_AMBAPP_GAISLER_SPICTRL
	DRIVER_AMBAPP_GAISLER_SPICTRL_REG,
#endif
#ifdef CONFIGURE_DRIVER_AMBAPP_GAISLER_I2CMST
	DRIVER_AMBAPP_GAISLER_I2CMST_REG,
#endif
#ifdef CONFIGURE_DRIVER_AMBAPP_GAISLER_GRGPIO
	DRIVER_AMBAPP_GAISLER_GRGPIO_REG,
#endif
#ifdef CONFIGURE_DRIVER_AMBAPP_GAISLER_GRPWM
	DRIVER_AMBAPP_GAISLER_GRPWM_REG,
#endif
#ifdef CONFIGURE_DRIVER_AMBAPP_GAISLER_GRADCDAC
	DRIVER_AMBAPP_GAISLER_GRADCDAC_REG,
#endif

	/*** LEON2 AMBA Drivers ***/
#ifdef CONFIGURE_DRIVER_LEON2_AT697PCI
	DRIVER_LEON2_AT697PCI_REG,
#endif
#ifdef CONFIGURE_DRIVER_LEON2_AMBAPP
	DRIVER_LEON2_AMBAPP_REG,
#endif

	/*** PCI Target Drivers ***/
#ifdef CONFIGURE_DRIVER_PCI_GR_RASTA_ADCDAC
	DRIVER_PCI_GR_RASTA_ADCDAC,
#endif
#ifdef CONFIGURE_DRIVER_PCI_GR_RASTA_IO
	DRIVER_PCI_GR_RASTA_IO,
#endif
#ifdef CONFIGURE_DRIVER_PCI_GR_RASTA_TMTC
	DRIVER_PCI_GR_RASTA_TMTC,
#endif
#ifdef CONFIGURE_DRIVER_PCI_GR_701
	DRIVER_PCI_GR_701,
#endif

/* Macros for adding custom drivers without needing to recompile
 * kernel.
 */
#ifdef CONFIGURE_DRIVER_CUSTOM1
	DRIVER_CUSTOM1_REG,
#endif
#ifdef CONFIGURE_DRIVER_CUSTOM2
	DRIVER_CUSTOM2_REG,
#endif
#ifdef CONFIGURE_DRIVER_CUSTOM3
	DRIVER_CUSTOM3_REG,
#endif
#ifdef CONFIGURE_DRIVER_CUSTOM4
	DRIVER_CUSTOM4_REG,
#endif
#ifdef CONFIGURE_DRIVER_CUSTOM5
	DRIVER_CUSTOM5_REG,
#endif

	/* End list with NULL */
	{NULL}
};

#endif /* CONFIGURE_INIT */

#ifdef __cplusplus
}
#endif

#endif /* _DRIVER_MANAGER_CONFDEFS_H_ */
