#ifndef __GRSPW_ROUTER_LIB_H__
#define __GRSPW_ROUTER_LIB_H__

/* Include Linux GRSPW-ROUTER Driver definitions */
#include <bsp/grspw_router.h>

void *router_init(char *path);

/* Get Hardware information about router */
int router_hwinfo_get(void *p, struct router_hw_info *hwinfo);

/* Configure Router. Leave field NULL in order to skip configuration
 */
int router_set_config(
	void *p,
	struct router_config *cfg,
	struct router_ps *ps,
	struct router_routes *routes);
/* Get current Router Configuration. Leave field NULL in order to skip
 * configuration read.
 */
int router_get_config(
	void *p,
	struct router_config *cfg,
	struct router_ps *ps,
	struct router_routes *routes);

/* Set Configuration Write Enable */
int router_set_we(void *p, int we);

/* Set/Get Port Control/Status */
int router_port_ioc(void *p, struct router_port *opts);

/* Read Port Control and/or Port Status register */
int router_port_get(void *p, int port, unsigned int *ctrl, unsigned int *sts);
/* Write Port Control Register */
int routerl_port_ctrl(void *p, int port, unsigned int ctrl);
/* Write Port Status Register */
int router_port_sts(void *p, int port, unsigned int sts);

/* Set/Clear Router Configuration/Status Register */
int router_set_cfgsts(void *p, unsigned int cfgsts);
/* Get Router Configuration/Status Register */
int router_get_cfgsts(void *p, unsigned int *cfgsts);

/* Get Current Time-Code */
int router_get_tc(void *p, unsigned char *tc);

/* Set Instance ID */
int router_set_instance(void *p, unsigned char iid);

/* Set SpaceWire Link Initialization Clock Divisor */
int router_set_idiv(void *p, unsigned char idiv);

/* Set Timer Prescaler */
int router_set_tpresc(void *p, unsigned int prescaler);
/* Set Timer Reload Value for a specific port */
int router_set_treload(void *p, int port, unsigned int reload);

/* Set routing table */
int router_set_routes(void *p, struct router_routes *routes);
/* Get routing table */
int router_get_routes(void *p, struct router_routes *routes);

/* Set Psort Setup */
int router_set_ps(void *p, struct router_ps *ps);
/* Get Port Setup */
int router_get_ps(void *p, struct router_ps *ps);

/* Print Router Hardware Information */
void router_print_hwinfo(struct router_hw_info *hwinfo);

#endif

