"\n"
"\t\t\twhen others => \tpatched_data <= DSCART_IO;\n"
"\t\tend case;\n"
"\tend process;\n"
"\n"
"\t-- dataswitcher\n"
"\tprocess (DSSLOT_RESET, DSSLOT_ROMCS, DSSLOT_EEPCS, DSSLOT_IO, DSCART_IO, patched_data)\n"
"\tbegin\n"
"\t\tDSSLOT_IO <= (others => 'Z');\t\t\t\t-- default is high impedance\n"
"\t\tDSCART_IO <= (others => 'Z');\t\t\t\t-- default is high impedance\n"
"\n"
"\t\tif (DSSLOT_RESET='1') then\t\t\t\t\t-- if not reset\n"
"\t\t\tif (DSSLOT_ROMCS='0') then\t\t\t\t-- ROM is selected\n"
"\t\t\t\tif (is_command) then\t\t\t\t-- is command byte\n"
"\t\t\t\t\tDSCART_IO <= DSSLOT_IO;\t\t\t-- from DS to cartridge\n"
"\t\t\t\telse\t\t\t\t\t\t\t\t-- is data byte\n"
"\t\t\t\t\tif (patch_en) then\t\t\t\t-- patch enabled\n"
"\t\t\t\t\t\tDSSLOT_IO <= patched_data;\n"
"\t\t\t\t\telse\n"
"\t\t\t\t\t\tDSSLOT_IO <= DSCART_IO;\n"
"\t\t\t\t\tend if;\n"
"\t\t\t\tend if;\n"
"\t\t\telsif (DSSLOT_EEPCS='0') then\t\t\t-- EEPROM is selected\n"
"\t\t\t\tDSCART_IO(7) <= DSSLOT_IO(7);\t\t-- pass serial data\n"
"\t\t\t\tDSSLOT_IO(6) <= DSCART_IO(6);\t\t-- pass serial data in opposite direction\n"
"\t\t\tend if;\n"
"\t\tend if;\n"
"\tend process;\n"
"\n"
"\t-- patch_en\n"
"\tprocess (DSSLOT_RESET, DSSLOT_CLK)\n"
"\tbegin\n"
"\t\tif (DSSLOT_RESET='0') then\n"
"\t\t\tpatch_en <= true;\t\t\t\t\t\t-- patch header\n"
"\t\telsif (rising_edge(DSSLOT_CLK)) then\n"
"\t\t\tif (is_command) then\n"
"\t\t\t\tif (DSCART_IO(5) = '1') then\t\t-- detect 3C command, assume other command bytes are 00\n"
"\t\t\t\t\tpatch_en <= false;\t\t\t\t-- do not patch other data\n"
"\t\t\t\tend if;\n"
"\t\t\tend if;\n"
"\t\tend if;\n"
"\tend process;\n"
"\n"
"\t-- cmddata_cnt, is_command\n"
"\tprocess (DSSLOT_ROMCS, DSSLOT_CLK)\n"
"\tbegin\n"
"\t\tif (DSSLOT_ROMCS='1') then\n"
"\t\t\tcmddata_cnt <= 0;\t\t\t\t\t\t-- new transfer\n"
"\t\t\tis_command <= true;\t\t\t\t\t\t-- start with command\n"
"\t\telsif (rising_edge(DSSLOT_CLK)) then\n"
"\t\t\tif (cmddata_cnt mod 8 = 7) then\n"
"\t\t\t\tis_command <= false;\t\t\t\t-- next byte is data\n"
"\t\t\tend if;\n"
"\t\t\tcmddata_cnt <= cmddata_cnt + 1;\t\t\t-- next byte\n"
"\t\tend if;\n"
"\tend process;\n"
"\n"
"end architecture;\n"
