#!/bin/bash

set -e

# get common RCC defines
. ./common.sh

#BSPS_STD_UP="erc32 leon2std leon3std"
# leon3_flat disabled
RTEMSDIR=`ls -d1 rcc-* | head -1`
REL_VER=`echo $RTEMSDIR | sed 's/^rcc-//g'`

if [ "$RCC_TOOLCHAIN" = "llvm" ]; then
    SELECTED_TARGET_CC=${TARGET}-clang
    SELECTED_TARGET_CXX=${TARGET}-clang++
    BSPS_UP="leon3 leon3_sf gr712rc gr740 ut700"
    BSPS_STD_UP=""
    BSPS_SMP="leon3_smp gr712rc_smp gr740_smp"
else
    # note: uses defaults set by newlib when these are empty.
    SELECTED_TARGET_CC=${TARGET}-gcc
    SELECTED_TARGET_CXX=
    BSPS_UP="leon3 leon3_sf gr712rc gr740 ut699 ut700"
    BSPS_STD_UP="at697f"
    BSPS_SMP="leon3_smp gr712rc_smp gr740_smp"
fi
BSPS_MP="gr712rc_mp gr740_mp"

echo BSPS_UP: $BSPS_UP
echo BSPS_STD_UP: $BSPS_STD_UP
echo BSPS_SMP: $BSPS_SMP
echo BSPS_MP: $BSPS_MP
echo RTEMSDIR: $RTEMSDIR
echo TARGET: $TARGET
echo INST: $INST
echo COMPILER: $SELECTED_TARGET_CC

export PATH=$INST/bin:$PATH
automake --version
autoconf --version

cd $RTEMSDIR
./bootstrap -c
./bootstrap -H
./bootstrap
cd ..

rm -rf build-up build-std-up build-smp build-mp
mkdir build-up build-std-up build-smp build-mp

# Build Single-core BSPs first
cd build-up
echo $SRCDIR/$RTEMSDIR/configure --prefix=$INST \
	--target=$TARGET --disable-itron --disable-tests --enable-cxx \
        --disable-docs --enable-drvmgr --enable-sparc-fpu \
	--enable-rtemsbsp="$BSPS_UP" \
        CC_FOR_TARGET=$SELECTED_TARGET_CC \
        CC_FOR_HOST=$SELECTED_TARGET_CC \
        CXX_FOR_TARGET=$SELECTED_TARGET_CXX \
        CXX_FOR_HOST=$SELECTED_TARGET_CXX \
	RCC_VERSION=\"$REL_VER\"

$SRCDIR/$RTEMSDIR/configure --prefix=$INST \
	--target=$TARGET --disable-itron --disable-tests --enable-cxx \
        --disable-docs --enable-drvmgr --enable-sparc-fpu \
	--enable-rtemsbsp="$BSPS_UP" \
        CC_FOR_TARGET=$SELECTED_TARGET_CC \
        CC_FOR_HOST=$SELECTED_TARGET_CC \
        CXX_FOR_TARGET=$SELECTED_TARGET_CXX \
        CXX_FOR_HOST=$SELECTED_TARGET_CXX \
	RCC_VERSION=\"$REL_VER\"

make all -j8
make install -j8

# Build standard configuration (no driver manager) single-core BSPs
if [ -n "$BSPS_STD_UP" ]; then
  cd ../build-std-up
  echo $SRCDIR/$RTEMSDIR/configure --prefix=$INST \
        --target=$TARGET --disable-itron --disable-tests --enable-cxx \
        --disable-docs --enable-sparc-fpu \
        --enable-rtemsbsp="$BSPS_STD_UP" \
        CC_FOR_TARGET=$SELECTED_TARGET_CC \
        CC_FOR_HOST=$SELECTED_TARGET_CC \
        CXX_FOR_TARGET=$SELECTED_TARGET_CXX \
        CXX_FOR_HOST=$SELECTED_TARGET_CXX \
        RCC_VERSION=\"$REL_VER\"

  $SRCDIR/$RTEMSDIR/configure --prefix=$INST \
        --target=$TARGET --disable-itron --disable-tests --enable-cxx \
        --disable-docs --enable-sparc-fpu \
        --enable-rtemsbsp="$BSPS_STD_UP" \
        CC_FOR_TARGET=$SELECTED_TARGET_CC \
        CC_FOR_HOST=$SELECTED_TARGET_CC \
        CXX_FOR_TARGET=$SELECTED_TARGET_CXX \
        CXX_FOR_HOST=$SELECTED_TARGET_CXX \
        RCC_VERSION=\"$REL_VER\"

  make all -j8
  make install -j8
fi

# Build multi-core SMP BSPs
cd ../build-smp
echo $SRCDIR/$RTEMSDIR/configure --prefix=$INST \
	--target=$TARGET --disable-itron --disable-tests --enable-cxx \
        --disable-docs --enable-drvmgr --enable-sparc-fpu \
	--enable-smp \
	--enable-rtemsbsp="$BSPS_SMP" \
        CC_FOR_TARGET=$SELECTED_TARGET_CC \
        CC_FOR_HOST=$SELECTED_TARGET_CC \
        CXX_FOR_TARGET=$SELECTED_TARGET_CXX \
        CXX_FOR_HOST=$SELECTED_TARGET_CXX \
	RCC_VERSION=\"$REL_VER\"

$SRCDIR/$RTEMSDIR/configure --prefix=$INST \
	--target=$TARGET --disable-itron --disable-tests --enable-cxx \
        --disable-docs --enable-drvmgr --enable-sparc-fpu \
	--enable-smp \
	--enable-rtemsbsp="$BSPS_SMP" \
        CC_FOR_TARGET=$SELECTED_TARGET_CC \
        CC_FOR_HOST=$SELECTED_TARGET_CC \
        CXX_FOR_TARGET=$SELECTED_TARGET_CXX \
        CXX_FOR_HOST=$SELECTED_TARGET_CXX \
	RCC_VERSION=\"$REL_VER\"

make all -j8
make install -j8

# Build multi-core AMP BSPs
if [ -n "$BSPS_MP" ]; then
  cd ../build-mp
  echo $SRCDIR/$RTEMSDIR/configure --prefix=$INST \
        --target=$TARGET --disable-itron --disable-tests --enable-cxx \
        --disable-docs --enable-drvmgr --enable-sparc-fpu \
	--enable-multiprocessing \
        --enable-rtemsbsp="$BSPS_MP" \
        CC_FOR_TARGET=$SELECTED_TARGET_CC \
        CC_FOR_HOST=$SELECTED_TARGET_CC \
        CXX_FOR_TARGET=$SELECTED_TARGET_CXX \
        CXX_FOR_HOST=$SELECTED_TARGET_CXX \
        RCC_VERSION=\"$REL_VER\"

  $SRCDIR/$RTEMSDIR/configure --prefix=$INST \
        --target=$TARGET --disable-itron --disable-tests --enable-cxx \
        --disable-docs --enable-drvmgr --enable-sparc-fpu \
	--enable-multiprocessing \
        --enable-rtemsbsp="$BSPS_MP" \
        CC_FOR_TARGET=$SELECTED_TARGET_CC \
        CC_FOR_HOST=$SELECTED_TARGET_CC \
        CXX_FOR_TARGET=$SELECTED_TARGET_CXX \
        CXX_FOR_HOST=$SELECTED_TARGET_CXX \
        RCC_VERSION=\"$REL_VER\"

  make all -j8
  make install -j8
fi
