/* SPDX-License-Identifier: BSD-2-Clause */

/*
 * Copyright (C) 2021 Jan Sommer, German Aerospace Center (DLR)
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef LIBBSP_ARM_XILINX_AXI_SPI_REGS_H
#define LIBBSP_ARM_XILINX_AXI_SPI_REGS_H

#include <bsp/utility.h>

typedef struct {
    uint32_t reserved1[7];
    uint32_t globalirq;
#define XILINX_AXI_SPI_GLOBAL_IRQ_ENABLE BSP_BIT32(31)
    uint32_t irqstatus;
    uint32_t reserved2;
    uint32_t irqenable;
#define XILINX_AXI_SPI_IRQ_CMD_ERR BSP_BIT32(13)
#define XILINX_AXI_SPI_IRQ_LOOP_ERR BSP_BIT32(12)
#define XILINX_AXI_SPI_IRQ_MSB_ERR BSP_BIT32(11)
#define XILINX_AXI_SPI_IRQ_SLV_ERR BSP_BIT32(10)
#define XILINX_AXI_SPI_IRQ_CPOL_CPHA_ERR BSP_BIT32(9)
#define XILINX_AXI_SPI_IRQ_RXNEMPTY BSP_BIT32(8)
#define XILINX_AXI_SPI_IRQ_CS_MODE BSP_BIT32(7)
#define XILINX_AXI_SPI_IRQ_TXHALF BSP_BIT32(6)
#define XILINX_AXI_SPI_IRQ_RXOVR BSP_BIT32(5)
#define XILINX_AXI_SPI_IRQ_RXFULL BSP_BIT32(4)
#define XILINX_AXI_SPI_IRQ_TXUF BSP_BIT32(3)
#define XILINX_AXI_SPI_IRQ_TXEMPTY BSP_BIT32(2)
#define XILINX_AXI_SPI_IRQ_SLV_MODF BSP_BIT32(1)
#define XILINX_AXI_SPI_IRQ_MODF BSP_BIT32(0)
    uint32_t reserved3[5];
    uint32_t reset;
#define XILINX_AXI_SPI_RESET 0x0000000a
    uint32_t reserved4[7];
    uint32_t control;
#define XILINX_AXI_SPI_CONTROL_LSBFIRST BSP_BIT32(9)
#define XILINX_AXI_SPI_CONTROL_MST_TRANS_INHIBIT BSP_BIT32(8)
#define XILINX_AXI_SPI_CONTROL_MANUAL_CS BSP_BIT32(7)
#define XILINX_AXI_SPI_CONTROL_RX_FIFO_RESET BSP_BIT32(6)
#define XILINX_AXI_SPI_CONTROL_TX_FIFO_RESET BSP_BIT32(5)
#define XILINX_AXI_SPI_CONTROL_CPHA BSP_BIT32(4)
#define XILINX_AXI_SPI_CONTROL_CPOL BSP_BIT32(3)
#define XILINX_AXI_SPI_CONTROL_MSTREN BSP_BIT32(2)
#define XILINX_AXI_SPI_CONTROL_SPIEN BSP_BIT32(1)
#define XILINX_AXI_SPI_CONTROL_LOOP BSP_BIT32(0)
    uint32_t status;
#define XILINX_AXI_SPI_STATUS_CMD_ERR BSP_BIT32(10)
#define XILINX_AXI_SPI_STATUS_LOOP_ERR BSP_BIT32(9)
#define XILINX_AXI_SPI_STATUS_MSB_ERR BSP_BIT32(8)
#define XILINX_AXI_SPI_STATUS_SLV_ERR BSP_BIT32(7)
#define XILINX_AXI_SPI_STATUS_CPOL_CPHA_ERR BSP_BIT32(6)
#define XILINX_AXI_SPI_STATUS_SLV_MODE BSP_BIT32(5)
#define XILINX_AXI_SPI_STATUS_MODF BSP_BIT32(4)
#define XILINX_AXI_SPI_STATUS_TXFULL BSP_BIT32(3)
#define XILINX_AXI_SPI_STATUS_TXEMPTY BSP_BIT32(2)
#define XILINX_AXI_SPI_STATUS_RXFULL BSP_BIT32(1)
#define XILINX_AXI_SPI_STATUS_RXEMPTY BSP_BIT32(0)
    uint32_t txdata;
    uint32_t rxdata;
    uint32_t cs;
    uint32_t tx_fifo_len;
    uint32_t rx_fifo_len;
} xilinx_axi_spi;

#endif /* LIBBSP_ARM_XILINX_AXI_SPI_REGS_H */
