/* The header file is generated by make_header.py from EMACM.json */
/* Current script's version can be found at: */
/* https://github.com/AoLaD/rtems-tms570-utils/tree/headers/headers/python */

/*
 * Copyright (c) 2014-2015, Premysl Houdek <kom541000@gmail.com>
 *
 * Czech Technical University in Prague
 * Zikova 1903/4
 * 166 36 Praha 6
 * Czech Republic
 *
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice, this
 *    list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * The views and conclusions contained in the software and documentation are those
 * of the authors and should not be interpreted as representing official policies,
 * either expressed or implied, of the FreeBSD Project.
*/
#ifndef LIBBSP_ARM_TMS570_EMACM
#define LIBBSP_ARM_TMS570_EMACM

#include <bsp/utility.h>

typedef struct{
  uint32_t TXREVID;           /*Transmit Revision ID Register*/
  uint32_t TXCONTROL;         /*Transmit Control Register*/
  uint32_t TXTEARDOWN;        /*Transmit Teardown Register*/
  uint8_t reserved1 [4];
  uint32_t RXREVID;           /*Receive Revision ID Register*/
  uint32_t RXCONTROL;         /*Receive Control Register*/
  uint32_t RXTEARDOWN;        /*Receive Teardown Register*/
  uint8_t reserved2 [100];
  uint32_t TXINTSTATRAW;      /*Transmit Interrupt Status (Unmasked) Register*/
  uint32_t TXINTSTATMASKED;   /*Transmit Interrupt Status (Masked) Register*/
  uint32_t TXINTMASKSET;      /*Transmit Interrupt Mask Set Register*/
  uint32_t TXINTMASKCLEAR;    /*Transmit Interrupt Clear Register*/
  uint32_t MACINVECTOR;       /*MAC Input Vector Register*/
  uint32_t MACEOIVECTOR;      /*MAC End Of Interrupt Vector Register*/
  uint8_t reserved3 [8];
  uint32_t RXINTSTATRAW;      /*Receive Interrupt Status (Unmasked) Register*/
  uint32_t RXINTSTATMASKED;   /*Receive Interrupt Status (Masked) Register*/
  uint32_t RXINTMASKSET;      /*Receive Interrupt Mask Set Register*/
  uint32_t RXINTMASKCLEAR;    /*Receive Interrupt Mask Clear Register*/
  uint32_t MACINTSTATRAW;     /*MAC Interrupt Status (Unmasked) Register*/
  uint32_t MACINTSTATMASKED;  /*MAC Interrupt Status (Masked) Register*/
  uint32_t MACINTMASKSET;     /*MAC Interrupt Mask Set Register*/
  uint32_t MACINTMASKCLEAR;   /*MAC Interrupt Mask Clear Register*/
  uint8_t reserved4 [64];
  uint32_t RXMBPENABLE;       /*Receive Multicast/Broadcast/Promiscuous Channel Enable*/
  uint32_t RXUNICASTSET;      /*Receive Unicast Enable Set Register*/
  uint32_t RXUNICASTCLEAR;    /*Receive Unicast Clear Register*/
  uint32_t RXMAXLEN;          /*Receive Maximum Length Register*/
  uint32_t RXBUFFEROFFSET;    /*Receive Buffer Offset Register*/
  uint32_t RXFILTERLOWTHRESH; /*Receive Filter Low Priority Frame Threshold Register*/
  uint8_t reserved5 [8];
  uint32_t RXFLOWTHRESH[8];   /*Receive Channel Flow Control Threshold Register*/
  uint32_t RXFREEBUFFER[8];   /*Receive Channel Free Buffer Count Register*/
  uint32_t MACCONTROL;        /*MAC Control Register*/
  uint32_t MACSTATUS;         /*MAC Status Register*/
  uint32_t EMCONTROL;         /*Emulation Control Register*/
  uint32_t FIFOCONTROL;       /*FIFO Control Register*/
  uint32_t MACCONFIG;         /*MAC Configuration Register*/
  uint32_t SOFTRESET;         /*Soft Reset Register*/
  uint8_t reserved6 [88];
  uint32_t MACSRCADDRLO;      /*MAC Source Address Low Bytes Register*/
  uint32_t MACSRCADDRHI;      /*MAC Source Address High Bytes Register*/
  uint32_t MACHASH1;          /*MAC Hash Address Register 1*/
  uint32_t MACHASH2;          /*MAC Hash Address Register 2*/
  uint32_t BOFFTEST;          /*Back Off Test Register*/
  uint32_t TPACETEST;         /*Transmit Pacing Algorithm Test Register*/
  uint32_t RXPAUSE;           /*Receive Pause Timer Register*/
  uint32_t TXPAUSE;           /*Transmit Pause Timer Register*/
  uint8_t reserved7 [784];
  uint32_t MACADDRLO;         /*MAC Address Low Bytes Register*/
  uint32_t MACADDRHI;         /*MAC Address High Bytes Register*/
  uint32_t MACINDEX;          /*MAC Index Register*/
  uint8_t reserved8 [244];
  uint32_t TXHDP[8];          /*Transmit Channel DMA Head Descriptor Pointer Register*/
  uint32_t RXHDP[8];          /*Receive Channel DMA Head Descriptor Pointer Register*/
  uint32_t TXCP[8];           /*Transmit Channel Completion Pointer Register*/
  uint32_t RXCP[8];           /*Receive Channel Completion Pointer Register*/
} tms570_emacm_t;


/*--------------------TMS570_EMACM_TXREVID--------------------*/
/* field: TXREV - Transmit module revision */
/* Whole 32 bits */

/*-------------------TMS570_EMACM_TXCONTROL-------------------*/
/* field: TXEN - Transmit enable */
#define TMS570_EMACM_TXCONTROL_TXEN BSP_BIT32(0)


/*------------------TMS570_EMACM_TXTEARDOWN------------------*/
/* field: TXTDNCH - Transmit teardown channel. */
#define TMS570_EMACM_TXTEARDOWN_TXTDNCH(val) BSP_FLD32(val,0, 2)
#define TMS570_EMACM_TXTEARDOWN_TXTDNCH_GET(reg) BSP_FLD32GET(reg,0, 2)
#define TMS570_EMACM_TXTEARDOWN_TXTDNCH_SET(reg,val) BSP_FLD32SET(reg, val,0, 2)


/*--------------------TMS570_EMACM_RXREVID--------------------*/
/* field: RXREV - Receive module revision */
/* Whole 32 bits */

/*-------------------TMS570_EMACM_RXCONTROL-------------------*/
/* field: RXEN - Receive enable */
#define TMS570_EMACM_RXCONTROL_RXEN BSP_BIT32(0)


/*------------------TMS570_EMACM_RXTEARDOWN------------------*/
/* field: RXTDNCH - Receive teardown channel. */
#define TMS570_EMACM_RXTEARDOWN_RXTDNCH(val) BSP_FLD32(val,0, 2)
#define TMS570_EMACM_RXTEARDOWN_RXTDNCH_GET(reg) BSP_FLD32GET(reg,0, 2)
#define TMS570_EMACM_RXTEARDOWN_RXTDNCH_SET(reg,val) BSP_FLD32SET(reg, val,0, 2)


/*-----------------TMS570_EMACM_TXINTSTATRAW-----------------*/
/* field: TX7PEND - TX7PEND raw interrupt read (before mask) */
#define TMS570_EMACM_TXINTSTATRAW_TX7PEND BSP_BIT32(7)

/* field: TX6PEND - TX6PEND raw interrupt read (before mask) */
#define TMS570_EMACM_TXINTSTATRAW_TX6PEND BSP_BIT32(6)

/* field: TX5PEND - TX5PEND raw interrupt read (before mask) */
#define TMS570_EMACM_TXINTSTATRAW_TX5PEND BSP_BIT32(5)

/* field: TX4PEND - X4PEND raw interrupt read (before mask) */
#define TMS570_EMACM_TXINTSTATRAW_TX4PEND BSP_BIT32(4)

/* field: TX3PEND - TX3PEND raw interrupt read (before mask) */
#define TMS570_EMACM_TXINTSTATRAW_TX3PEND BSP_BIT32(3)

/* field: TX2PEND - TX2PEND raw interrupt read (before mask) */
#define TMS570_EMACM_TXINTSTATRAW_TX2PEND BSP_BIT32(2)

/* field: TX1PEND - TX1PEND raw interrupt read (before mask) */
#define TMS570_EMACM_TXINTSTATRAW_TX1PEND BSP_BIT32(1)

/* field: TX0PEND - TX0PEND raw interrupt read (before mask) */
#define TMS570_EMACM_TXINTSTATRAW_TX0PEND BSP_BIT32(0)


/*----------------TMS570_EMACM_TXINTSTATMASKED----------------*/
/* field: TX7PEND - TX7PEND masked interrupt read */
#define TMS570_EMACM_TXINTSTATMASKED_TX7PEND BSP_BIT32(7)

/* field: TX6PEND - TX6PEND masked interrupt read */
#define TMS570_EMACM_TXINTSTATMASKED_TX6PEND BSP_BIT32(6)

/* field: TX5PEND - TX5PEND masked interrupt read */
#define TMS570_EMACM_TXINTSTATMASKED_TX5PEND BSP_BIT32(5)

/* field: TX4PEND - TX4PEND masked interrupt read */
#define TMS570_EMACM_TXINTSTATMASKED_TX4PEND BSP_BIT32(4)

/* field: TX3PEND - TX3PEND masked interrupt read */
#define TMS570_EMACM_TXINTSTATMASKED_TX3PEND BSP_BIT32(3)

/* field: TX2PEND - TX2PEND masked interrupt read */
#define TMS570_EMACM_TXINTSTATMASKED_TX2PEND BSP_BIT32(2)

/* field: TX1PEND - TX1PEND masked interrupt read */
#define TMS570_EMACM_TXINTSTATMASKED_TX1PEND BSP_BIT32(1)

/* field: TX0PEND - TX0PEND masked interrupt read */
#define TMS570_EMACM_TXINTSTATMASKED_TX0PEND BSP_BIT32(0)


/*-----------------TMS570_EMACM_TXINTMASKSET-----------------*/
/* field: TX7MASK - Transmit channel 7 interrupt mask set bit. Write 1 to enable interrupt, a write of 0 has no effect. */
#define TMS570_EMACM_TXINTMASKSET_TX7MASK BSP_BIT32(7)

/* field: TX6MASK - Transmit channel 6 interrupt mask set bit. Write 1 to enable interrupt, a write of 0 has no effect. */
#define TMS570_EMACM_TXINTMASKSET_TX6MASK BSP_BIT32(6)

/* field: TX5MASK - Transmit channel 5 interrupt mask set bit. Write 1 to enable interrupt, a write of 0 has no effect. */
#define TMS570_EMACM_TXINTMASKSET_TX5MASK BSP_BIT32(5)

/* field: TX4MASK - Transmit channel 4 interrupt mask set bit. Write 1 to enable interrupt, a write of 0 has no effect. */
#define TMS570_EMACM_TXINTMASKSET_TX4MASK BSP_BIT32(4)

/* field: TX3MASK - Transmit channel 3 interrupt mask set bit. Write 1 to enable interrupt, a write of 0 has no effect. */
#define TMS570_EMACM_TXINTMASKSET_TX3MASK BSP_BIT32(3)

/* field: TX2MASK - Transmit channel 2 interrupt mask set bit. Write 1 to enable interrupt, a write of 0 has no effect. */
#define TMS570_EMACM_TXINTMASKSET_TX2MASK BSP_BIT32(2)

/* field: TX1MASK - Transmit channel 1 interrupt mask set bit. Write 1 to enable interrupt, a write of 0 has no effect. */
#define TMS570_EMACM_TXINTMASKSET_TX1MASK BSP_BIT32(1)

/* field: TX0MASK - Transmit channel 0 interrupt mask set bit. Write 1 to enable interrupt, a write of 0 has no effect. */
#define TMS570_EMACM_TXINTMASKSET_TX0MASK BSP_BIT32(0)


/*----------------TMS570_EMACM_TXINTMASKCLEAR----------------*/
/* field: TX7MASK - Transmit channel 7 interrupt mask clear bit. Write 1 to disable interrupt, a write of 0 has no effect. */
#define TMS570_EMACM_TXINTMASKCLEAR_TX7MASK BSP_BIT32(7)

/* field: TX6MASK - Transmit channel 6 interrupt mask clear bit. Write 1 to disable interrupt, a write of 0 has no effect. */
#define TMS570_EMACM_TXINTMASKCLEAR_TX6MASK BSP_BIT32(6)

/* field: TX5MASK - Transmit channel 5 interrupt mask clear bit. Write 1 to disable interrupt, a write of 0 has no effect. */
#define TMS570_EMACM_TXINTMASKCLEAR_TX5MASK BSP_BIT32(5)

/* field: TX4MASK - Transmit channel 4 interrupt mask clear bit. Write 1 to disable interrupt, a write of 0 has no effect. */
#define TMS570_EMACM_TXINTMASKCLEAR_TX4MASK BSP_BIT32(4)

/* field: TX3MASK - Transmit channel 3 interrupt mask clear bit. Write 1 to disable interrupt, a write of 0 has no effect. */
#define TMS570_EMACM_TXINTMASKCLEAR_TX3MASK BSP_BIT32(3)

/* field: TX2MASK - Transmit channel 2 interrupt mask clear bit. Write 1 to disable interrupt, a write of 0 has no effect. */
#define TMS570_EMACM_TXINTMASKCLEAR_TX2MASK BSP_BIT32(2)

/* field: TX1MASK - Transmit channel 1 interrupt mask clear bit. Write 1 to disable interrupt, a write of 0 has no effect. */
#define TMS570_EMACM_TXINTMASKCLEAR_TX1MASK BSP_BIT32(1)

/* field: TX0MASK - Transmit channel 0 interrupt mask clear bit. Write 1 to disable interrupt, a write of 0 has no effect. */
#define TMS570_EMACM_TXINTMASKCLEAR_TX0MASK BSP_BIT32(0)


/*------------------TMS570_EMACM_MACINVECTOR------------------*/
/* field: STATPEND - EMAC module statistics interrupt (STATPEND) pending status bit */
#define TMS570_EMACM_MACINVECTOR_STATPEND BSP_BIT32(27)

/* field: HOSTPEND - EMAC module host error interrupt (HOSTPEND) pending status bit */
#define TMS570_EMACM_MACINVECTOR_HOSTPEND BSP_BIT32(26)

/* field: LINKINT0 - MDIO module USERPHYSEL0 (LINKINT0) status bit */
#define TMS570_EMACM_MACINVECTOR_LINKINT0 BSP_BIT32(25)

/* field: USERINT0 - MDIO module USERACCESS0 (USERINT0) status bit */
#define TMS570_EMACM_MACINVECTOR_USERINT0 BSP_BIT32(24)

/* field: TXPEND - Transmit channels 0-7 interrupt (TXnPEND) pending status. Bit 16 is TX0PEND. */
#define TMS570_EMACM_MACINVECTOR_TXPEND(val) BSP_FLD32(val,16, 23)
#define TMS570_EMACM_MACINVECTOR_TXPEND_GET(reg) BSP_FLD32GET(reg,16, 23)
#define TMS570_EMACM_MACINVECTOR_TXPEND_SET(reg,val) BSP_FLD32SET(reg, val,16, 23)

/* field: RXTHRESHPEND - Receive channels 0-7 interrupt (RXnTHRESHPEND) pending status. */
#define TMS570_EMACM_MACINVECTOR_RXTHRESHPEND(val) BSP_FLD32(val,8, 15)
#define TMS570_EMACM_MACINVECTOR_RXTHRESHPEND_GET(reg) BSP_FLD32GET(reg,8, 15)
#define TMS570_EMACM_MACINVECTOR_RXTHRESHPEND_SET(reg,val) BSP_FLD32SET(reg, val,8, 15)

/* field: RXPEND - Receive channels 0-7 interrupt (RXnPEND) pending status bit. Bit 0 is RX0PEND. */
#define TMS570_EMACM_MACINVECTOR_RXPEND(val) BSP_FLD32(val,0, 7)
#define TMS570_EMACM_MACINVECTOR_RXPEND_GET(reg) BSP_FLD32GET(reg,0, 7)
#define TMS570_EMACM_MACINVECTOR_RXPEND_SET(reg,val) BSP_FLD32SET(reg, val,0, 7)


/*-----------------TMS570_EMACM_MACEOIVECTOR-----------------*/
/* field: INTVECT - Acknowledge EMAC Control Module Interrupts */
#define TMS570_EMACM_MACEOIVECTOR_INTVECT(val) BSP_FLD32(val,0, 4)
#define TMS570_EMACM_MACEOIVECTOR_INTVECT_GET(reg) BSP_FLD32GET(reg,0, 4)
#define TMS570_EMACM_MACEOIVECTOR_INTVECT_SET(reg,val) BSP_FLD32SET(reg, val,0, 4)


/*-----------------TMS570_EMACM_RXINTSTATRAW-----------------*/
/* field: RX7THRESHPEND - RX7THRESHPEND raw interrupt read (before mask) */
#define TMS570_EMACM_RXINTSTATRAW_RX7THRESHPEND BSP_BIT32(15)

/* field: RX6THRESHPEND - RX6THRESHPEND raw interrupt read (before mask) */
#define TMS570_EMACM_RXINTSTATRAW_RX6THRESHPEND BSP_BIT32(14)

/* field: RX5THRESHPEND - RX5THRESHPEND raw interrupt read (before mask) */
#define TMS570_EMACM_RXINTSTATRAW_RX5THRESHPEND BSP_BIT32(13)

/* field: RX4THRESHPEND - RX4THRESHPEND raw interrupt read (before mask) */
#define TMS570_EMACM_RXINTSTATRAW_RX4THRESHPEND BSP_BIT32(12)

/* field: RX3THRESHPEND - RX3THRESHPEND raw interrupt read (before mask) */
#define TMS570_EMACM_RXINTSTATRAW_RX3THRESHPEND BSP_BIT32(11)

/* field: RX2THRESHPEND - RX2THRESHPEND raw interrupt read (before mask) */
#define TMS570_EMACM_RXINTSTATRAW_RX2THRESHPEND BSP_BIT32(10)

/* field: RX1THRESHPEND - RX1THRESHPEND raw interrupt read (before mask) */
#define TMS570_EMACM_RXINTSTATRAW_RX1THRESHPEND BSP_BIT32(9)

/* field: RX0THRESHPEND - RX0THRESHPEND raw interrupt read (before mask) */
#define TMS570_EMACM_RXINTSTATRAW_RX0THRESHPEND BSP_BIT32(8)

/* field: RX7PEND - RX7PEND raw interrupt read (before mask) */
#define TMS570_EMACM_RXINTSTATRAW_RX7PEND BSP_BIT32(7)

/* field: RX6PEND - RX6PEND raw interrupt read (before mask) */
#define TMS570_EMACM_RXINTSTATRAW_RX6PEND BSP_BIT32(6)

/* field: RX5PEND - RX5PEND raw interrupt read (before mask) */
#define TMS570_EMACM_RXINTSTATRAW_RX5PEND BSP_BIT32(5)

/* field: RX4PEND - RX4PEND raw interrupt read (before mask) */
#define TMS570_EMACM_RXINTSTATRAW_RX4PEND BSP_BIT32(4)

/* field: RX3PEND - RX3PEND raw interrupt read (before mask) */
#define TMS570_EMACM_RXINTSTATRAW_RX3PEND BSP_BIT32(3)

/* field: RX2PEND - RX2PEND raw interrupt read (before mask) */
#define TMS570_EMACM_RXINTSTATRAW_RX2PEND BSP_BIT32(2)

/* field: RX1PEND - RX1PEND raw interrupt read (before mask) */
#define TMS570_EMACM_RXINTSTATRAW_RX1PEND BSP_BIT32(1)

/* field: RX0PEND - RX0PEND raw interrupt read (before mask) */
#define TMS570_EMACM_RXINTSTATRAW_RX0PEND BSP_BIT32(0)


/*----------------TMS570_EMACM_RXINTSTATMASKED----------------*/
/* field: RX7THRESHPEND - RX7THRESHPEND masked interrupt read */
#define TMS570_EMACM_RXINTSTATMASKED_RX7THRESHPEND BSP_BIT32(15)

/* field: RX6THRESHPEND - RX6THRESHPEND masked interrupt read */
#define TMS570_EMACM_RXINTSTATMASKED_RX6THRESHPEND BSP_BIT32(14)

/* field: RX5THRESHPEND - RX5THRESHPEND masked interrupt read */
#define TMS570_EMACM_RXINTSTATMASKED_RX5THRESHPEND BSP_BIT32(13)

/* field: RX4THRESHPEND - RX4THRESHPEND masked interrupt read */
#define TMS570_EMACM_RXINTSTATMASKED_RX4THRESHPEND BSP_BIT32(12)

/* field: RX3THRESHPEND - RX3THRESHPEND masked interrupt read */
#define TMS570_EMACM_RXINTSTATMASKED_RX3THRESHPEND BSP_BIT32(11)

/* field: RX2THRESHPEND - RX2THRESHPEND masked interrupt read */
#define TMS570_EMACM_RXINTSTATMASKED_RX2THRESHPEND BSP_BIT32(10)

/* field: RX1THRESHPEND - RX1THRESHPEND masked interrupt read */
#define TMS570_EMACM_RXINTSTATMASKED_RX1THRESHPEND BSP_BIT32(9)

/* field: RX0THRESHPEND - RX0THRESHPEND masked interrupt read */
#define TMS570_EMACM_RXINTSTATMASKED_RX0THRESHPEND BSP_BIT32(8)

/* field: RX7PEND - RX7PEND masked interrupt read */
#define TMS570_EMACM_RXINTSTATMASKED_RX7PEND BSP_BIT32(7)

/* field: RX6PEND - RX6PEND masked interrupt read */
#define TMS570_EMACM_RXINTSTATMASKED_RX6PEND BSP_BIT32(6)

/* field: RX5PEND - RX5PEND masked interrupt read */
#define TMS570_EMACM_RXINTSTATMASKED_RX5PEND BSP_BIT32(5)

/* field: RX4PEND - RX4PEND masked interrupt read */
#define TMS570_EMACM_RXINTSTATMASKED_RX4PEND BSP_BIT32(4)

/* field: RX3PEND - RX3PEND masked interrupt read */
#define TMS570_EMACM_RXINTSTATMASKED_RX3PEND BSP_BIT32(3)

/* field: RX2PEND - RX2PEND masked interrupt read */
#define TMS570_EMACM_RXINTSTATMASKED_RX2PEND BSP_BIT32(2)

/* field: RX1PEND - RX1PEND masked interrupt read */
#define TMS570_EMACM_RXINTSTATMASKED_RX1PEND BSP_BIT32(1)

/* field: RX0PEND - RX0PEND masked interrupt read */
#define TMS570_EMACM_RXINTSTATMASKED_RX0PEND BSP_BIT32(0)


/*-----------------TMS570_EMACM_RXINTMASKSET-----------------*/
/* field: RX7THRESHMASK - Receive channel 7 threshold mask set bit. Write 1 to enable interrupt; a write of 0 has no effect. */
#define TMS570_EMACM_RXINTMASKSET_RX7THRESHMASK BSP_BIT32(15)

/* field: RX6THRESHMASK - Receive channel 6 threshold mask set bit. Write 1 to enable interrupt; a write of 0 has no effect. */
#define TMS570_EMACM_RXINTMASKSET_RX6THRESHMASK BSP_BIT32(14)

/* field: RX5THRESHMASK - Receive channel 5 threshold mask set bit. Write 1 to enable interrupt; a write of 0 has no effect. */
#define TMS570_EMACM_RXINTMASKSET_RX5THRESHMASK BSP_BIT32(13)

/* field: RX4THRESHMASK - Receive channel 4 threshold mask set bit. Write 1 to enable interrupt; a write of 0 has no effect. */
#define TMS570_EMACM_RXINTMASKSET_RX4THRESHMASK BSP_BIT32(12)

/* field: RX3THRESHMASK - Receive channel 3 threshold mask set bit. Write 1 to enable interrupt; a write of 0 has no effect. */
#define TMS570_EMACM_RXINTMASKSET_RX3THRESHMASK BSP_BIT32(11)

/* field: RX2THRESHMASK - Receive channel 2 threshold mask set bit. Write 1 to enable interrupt; a write of 0 has no effect. */
#define TMS570_EMACM_RXINTMASKSET_RX2THRESHMASK BSP_BIT32(10)

/* field: RX1THRESHMASK - Receive channel 1 threshold mask set bit. Write 1 to enable interrupt; a write of 0 has no effect. */
#define TMS570_EMACM_RXINTMASKSET_RX1THRESHMASK BSP_BIT32(9)

/* field: RX0THRESHMASK - Receive channel 0 threshold mask set bit. Write 1 to enable interrupt; a write of 0 has no effect. */
#define TMS570_EMACM_RXINTMASKSET_RX0THRESHMASK BSP_BIT32(8)

/* field: RX7MASK - Receive channel 7 mask set bit. Write 1 to enable interrupt; a write of 0 has no effect. */
#define TMS570_EMACM_RXINTMASKSET_RX7MASK BSP_BIT32(7)

/* field: RX6MASK - Receive channel 6 mask set bit. Write 1 to enable interrupt; a write of 0 has no effect. */
#define TMS570_EMACM_RXINTMASKSET_RX6MASK BSP_BIT32(6)

/* field: RX5MASK - Receive channel 5 mask set bit. Write 1 to enable interrupt; a write of 0 has no effect. */
#define TMS570_EMACM_RXINTMASKSET_RX5MASK BSP_BIT32(5)

/* field: RX4MASK - Receive channel 4 mask set bit. Write 1 to enable interrupt; a write of 0 has no effect. */
#define TMS570_EMACM_RXINTMASKSET_RX4MASK BSP_BIT32(4)

/* field: RX3MASK - Receive channel 3 mask set bit. Write 1 to enable interrupt; a write of 0 has no effect. */
#define TMS570_EMACM_RXINTMASKSET_RX3MASK BSP_BIT32(3)

/* field: RX2MASK - Receive channel 2 mask set bit. Write 1 to enable interrupt; a write of 0 has no effect. */
#define TMS570_EMACM_RXINTMASKSET_RX2MASK BSP_BIT32(2)

/* field: RX1MASK - Receive channel 1 mask set bit. Write 1 to enable interrupt; a write of 0 has no effect. */
#define TMS570_EMACM_RXINTMASKSET_RX1MASK BSP_BIT32(1)

/* field: RX0MASK - Receive channel 0 mask set bit. Write 1 to enable interrupt; a write of 0 has no effect. */
#define TMS570_EMACM_RXINTMASKSET_RX0MASK BSP_BIT32(0)


/*----------------TMS570_EMACM_RXINTMASKCLEAR----------------*/
/* field: RX7THRESHMASK - Receive channel 7 threshold mask clear bit. */
#define TMS570_EMACM_RXINTMASKCLEAR_RX7THRESHMASK BSP_BIT32(15)

/* field: RX6THRESHMASK - Receive channel 6 threshold mask clear bit. */
#define TMS570_EMACM_RXINTMASKCLEAR_RX6THRESHMASK BSP_BIT32(14)

/* field: RX5THRESHMASK - Receive channel 5 threshold mask clear bit. */
#define TMS570_EMACM_RXINTMASKCLEAR_RX5THRESHMASK BSP_BIT32(13)

/* field: RX4THRESHMASK - Receive channel 4 threshold mask clear bit. */
#define TMS570_EMACM_RXINTMASKCLEAR_RX4THRESHMASK BSP_BIT32(12)

/* field: RX3THRESHMASK - Receive channel 3 threshold mask clear bit. */
#define TMS570_EMACM_RXINTMASKCLEAR_RX3THRESHMASK BSP_BIT32(11)

/* field: RX2THRESHMASK - Receive channel 2 threshold mask clear bit. */
#define TMS570_EMACM_RXINTMASKCLEAR_RX2THRESHMASK BSP_BIT32(10)

/* field: RX1THRESHMASK - Receive channel 1 threshold mask clear bit. */
#define TMS570_EMACM_RXINTMASKCLEAR_RX1THRESHMASK BSP_BIT32(9)

/* field: RX0THRESHMASK - Receive channel 0 threshold mask clear bit. */
#define TMS570_EMACM_RXINTMASKCLEAR_RX0THRESHMASK BSP_BIT32(8)

/* field: RX7MASK - Receive channel 7 mask clear bit. Write 1 to disable interrupt; a write of 0 has no effect. */
#define TMS570_EMACM_RXINTMASKCLEAR_RX7MASK BSP_BIT32(7)

/* field: RX6MASK - Receive channel 6 mask clear bit. Write 1 to disable interrupt; a write of 0 has no effect. */
#define TMS570_EMACM_RXINTMASKCLEAR_RX6MASK BSP_BIT32(6)

/* field: RX5MASK - Receive channel 5 mask clear bit. Write 1 to disable interrupt; a write of 0 has no effect. */
#define TMS570_EMACM_RXINTMASKCLEAR_RX5MASK BSP_BIT32(5)

/* field: RX4MASK - Receive channel 4 mask clear bit. Write 1 to disable interrupt; a write of 0 has no effect. */
#define TMS570_EMACM_RXINTMASKCLEAR_RX4MASK BSP_BIT32(4)

/* field: RX3MASK - Receive channel 3 mask clear bit. Write 1 to disable interrupt; a write of 0 has no effect. */
#define TMS570_EMACM_RXINTMASKCLEAR_RX3MASK BSP_BIT32(3)

/* field: RX2MASK - Receive channel 2 mask clear bit. Write 1 to disable interrupt; a write of 0 has no effect. */
#define TMS570_EMACM_RXINTMASKCLEAR_RX2MASK BSP_BIT32(2)

/* field: RX1MASK - Receive channel 1 mask clear bit. Write 1 to disable interrupt; a write of 0 has no effect. */
#define TMS570_EMACM_RXINTMASKCLEAR_RX1MASK BSP_BIT32(1)

/* field: RX0MASK - Receive channel 0 mask clear bit. Write 1 to disable interrupt; a write of 0 has no effect. */
#define TMS570_EMACM_RXINTMASKCLEAR_RX0MASK BSP_BIT32(0)


/*-----------------TMS570_EMACM_MACINTSTATRAW-----------------*/
/* field: HOSTPEND - Host pending interrupt (HOSTPEND); raw interrupt read (before mask). */
#define TMS570_EMACM_MACINTSTATRAW_HOSTPEND BSP_BIT32(1)

/* field: STATPEND - Statistics pending interrupt (STATPEND); raw interrupt read (before mask). */
#define TMS570_EMACM_MACINTSTATRAW_STATPEND BSP_BIT32(0)


/*---------------TMS570_EMACM_MACINTSTATMASKED---------------*/
/* field: HOSTPEND - Host pending interrupt (HOSTPEND); masked interrupt read. */
#define TMS570_EMACM_MACINTSTATMASKED_HOSTPEND BSP_BIT32(1)

/* field: STATPEND - Statistics pending interrupt (STATPEND); masked interrupt read. */
#define TMS570_EMACM_MACINTSTATMASKED_STATPEND BSP_BIT32(0)


/*-----------------TMS570_EMACM_MACINTMASKSET-----------------*/
/* field: HOSTMASK - Host error interrupt mask set bit. Write 1 to enable interrupt, a write of 0 has no effect. */
#define TMS570_EMACM_MACINTMASKSET_HOSTMASK BSP_BIT32(1)

/* field: STATMASK - Statistics interrupt mask set bit. Write 1 to enable interrupt, a write of 0 has no effect. */
#define TMS570_EMACM_MACINTMASKSET_STATMASK BSP_BIT32(0)


/*----------------TMS570_EMACM_MACINTMASKCLEAR----------------*/
/* field: HOSTMASK - Host error interrupt mask clear bit. Write 1 to disable interrupt, a write of 0 has no effect. */
#define TMS570_EMACM_MACINTMASKCLEAR_HOSTMASK BSP_BIT32(1)

/* field: STATMASK - Statistics interrupt mask clear bit. Write 1 to disable interrupt, a write of 0 has no effect. */
#define TMS570_EMACM_MACINTMASKCLEAR_STATMASK BSP_BIT32(0)


/*------------------TMS570_EMACM_RXMBPENABLE------------------*/
/* field: RXPASSCRC - Pass receive CRC enable bit */
#define TMS570_EMACM_RXMBPENABLE_RXPASSCRC BSP_BIT32(30)

/* field: RXQOSEN - Receive quality of service enable bit */
#define TMS570_EMACM_RXMBPENABLE_RXQOSEN BSP_BIT32(29)

/* field: RXNOCHAIN - Receive no buffer chaining bit */
#define TMS570_EMACM_RXMBPENABLE_RXNOCHAIN BSP_BIT32(28)

/* field: RXCMFEN - Receive copy MAC control frames enable bit. */
#define TMS570_EMACM_RXMBPENABLE_RXCMFEN BSP_BIT32(24)

/* field: RXCSFEN - Receive copy short frames enable bit. */
#define TMS570_EMACM_RXMBPENABLE_RXCSFEN BSP_BIT32(23)

/* field: RXCEFEN - Receive copy error frames enable bit. */
#define TMS570_EMACM_RXMBPENABLE_RXCEFEN BSP_BIT32(22)

/* field: RXCAFEN - Receive copy all frames enable bit. */
#define TMS570_EMACM_RXMBPENABLE_RXCAFEN BSP_BIT32(21)

/* field: RXPROMCH - Receive promiscuous channel select */
#define TMS570_EMACM_RXMBPENABLE_RXPROMCH(val) BSP_FLD32(val,16, 18)
#define TMS570_EMACM_RXMBPENABLE_RXPROMCH_GET(reg) BSP_FLD32GET(reg,16, 18)
#define TMS570_EMACM_RXMBPENABLE_RXPROMCH_SET(reg,val) BSP_FLD32SET(reg, val,16, 18)

/* field: RXBROADEN - Receive broadcast enable. */
#define TMS570_EMACM_RXMBPENABLE_RXBROADEN BSP_BIT32(13)

/* field: RXBROADCH - Receive broadcast channel select */
#define TMS570_EMACM_RXMBPENABLE_RXBROADCH(val) BSP_FLD32(val,8, 10)
#define TMS570_EMACM_RXMBPENABLE_RXBROADCH_GET(reg) BSP_FLD32GET(reg,8, 10)
#define TMS570_EMACM_RXMBPENABLE_RXBROADCH_SET(reg,val) BSP_FLD32SET(reg, val,8, 10)

/* field: RXMULTEN - RX multicast enable. */
#define TMS570_EMACM_RXMBPENABLE_RXMULTEN BSP_BIT32(5)


/*-----------------TMS570_EMACM_RXUNICASTSET-----------------*/
/* field: RXCH7EN - Receive channel 7 unicast enable set bit. Write 1 to set the enable, a write of 0 has no effect. */
#define TMS570_EMACM_RXUNICASTSET_RXCH7EN BSP_BIT32(7)

/* field: RXCH6EN - Receive channel 6 unicast enable set bit. Write 1 to set the enable, a write of 0 has no effect. */
#define TMS570_EMACM_RXUNICASTSET_RXCH6EN BSP_BIT32(6)

/* field: RXCH5EN - Receive channel 5 unicast enable set bit. Write 1 to set the enable, a write of 0 has no effect. */
#define TMS570_EMACM_RXUNICASTSET_RXCH5EN BSP_BIT32(5)

/* field: RXCH4EN - Receive channel 4 unicast enable set bit. Write 1 to set the enable, a write of 0 has no effect. */
#define TMS570_EMACM_RXUNICASTSET_RXCH4EN BSP_BIT32(4)

/* field: RXCH3EN - Receive channel 3 unicast enable set bit. Write 1 to set the enable, a write of 0 has no effect. */
#define TMS570_EMACM_RXUNICASTSET_RXCH3EN BSP_BIT32(3)

/* field: RXCH2EN - Receive channel 2 unicast enable set bit. Write 1 to set the enable, a write of 0 has no effect. */
#define TMS570_EMACM_RXUNICASTSET_RXCH2EN BSP_BIT32(2)

/* field: RXCH1EN - Receive channel 1 unicast enable set bit. Write 1 to set the enable, a write of 0 has no effect. */
#define TMS570_EMACM_RXUNICASTSET_RXCH1EN BSP_BIT32(1)

/* field: RXCH0EN - Receive channel 0 unicast enable set bit. Write 1 to set the enable, a write of 0 has no effect. */
#define TMS570_EMACM_RXUNICASTSET_RXCH0EN BSP_BIT32(0)


/*----------------TMS570_EMACM_RXUNICASTCLEAR----------------*/
/* field: RXCH7EN - Receive channel 7 unicast enable clear bit. Write 1 to clear the enable, a write of 0 has no effect. */
#define TMS570_EMACM_RXUNICASTCLEAR_RXCH7EN BSP_BIT32(7)

/* field: RXCH6EN - Receive channel 6 unicast enable clear bit. Write 1 to clear the enable, a write of 0 has no effect. */
#define TMS570_EMACM_RXUNICASTCLEAR_RXCH6EN BSP_BIT32(6)

/* field: RXCH5EN - Receive channel 5 unicast enable clear bit. Write 1 to clear the enable, a write of 0 has no effect. */
#define TMS570_EMACM_RXUNICASTCLEAR_RXCH5EN BSP_BIT32(5)

/* field: RXCH4EN - Receive channel 4 unicast enable clear bit. Write 1 to clear the enable, a write of 0 has no effect. */
#define TMS570_EMACM_RXUNICASTCLEAR_RXCH4EN BSP_BIT32(4)

/* field: RXCH3EN - Receive channel 3 unicast enable clear bit. Write 1 to clear the enable, a write of 0 has no effect. */
#define TMS570_EMACM_RXUNICASTCLEAR_RXCH3EN BSP_BIT32(3)

/* field: RXCH2EN - Receive channel 2 unicast enable clear bit. Write 1 to clear the enable, a write of 0 has no effect. */
#define TMS570_EMACM_RXUNICASTCLEAR_RXCH2EN BSP_BIT32(2)

/* field: RXCH1EN - Receive channel 1 unicast enable clear bit. Write 1 to clear the enable, a write of 0 has no effect. */
#define TMS570_EMACM_RXUNICASTCLEAR_RXCH1EN BSP_BIT32(1)

/* field: RXCH0EN - Receive channel 0 unicast enable clear bit. Write 1 to clear the enable, a write of 0 has no effect. */
#define TMS570_EMACM_RXUNICASTCLEAR_RXCH0EN BSP_BIT32(0)


/*-------------------TMS570_EMACM_RXMAXLEN-------------------*/
/* field: RXMAXLEN - Receive maximum frame length. These bits determine the maximum length of a received frame. */
#define TMS570_EMACM_RXMAXLEN_RXMAXLEN(val) BSP_FLD32(val,0, 15)
#define TMS570_EMACM_RXMAXLEN_RXMAXLEN_GET(reg) BSP_FLD32GET(reg,0, 15)
#define TMS570_EMACM_RXMAXLEN_RXMAXLEN_SET(reg,val) BSP_FLD32SET(reg, val,0, 15)


/*----------------TMS570_EMACM_RXBUFFEROFFSET----------------*/
/* field: RXBUFFEROFFSET - Receive buffer offset value. */
#define TMS570_EMACM_RXBUFFEROFFSET_RXBUFFEROFFSET(val) BSP_FLD32(val,0, 15)
#define TMS570_EMACM_RXBUFFEROFFSET_RXBUFFEROFFSET_GET(reg) BSP_FLD32GET(reg,0, 15)
#define TMS570_EMACM_RXBUFFEROFFSET_RXBUFFEROFFSET_SET(reg,val) BSP_FLD32SET(reg, val,0, 15)


/*---------------TMS570_EMACM_RXFILTERLOWTHRESH---------------*/
/* field: RXFILTERTHRESH - Receive filter low threshold. */
#define TMS570_EMACM_RXFILTERLOWTHRESH_RXFILTERTHRESH(val) BSP_FLD32(val,0, 7)
#define TMS570_EMACM_RXFILTERLOWTHRESH_RXFILTERTHRESH_GET(reg) BSP_FLD32GET(reg,0, 7)
#define TMS570_EMACM_RXFILTERLOWTHRESH_RXFILTERTHRESH_SET(reg,val) BSP_FLD32SET(reg, val,0, 7)


/*-----------------TMS570_EMACM_RXFLOWTHRESH-----------------*/
/* field: RXnFLOWTHRESH - Receive flow threshold. */
#define TMS570_EMACM_RXFLOWTHRESH_RXnFLOWTHRESH(val) BSP_FLD32(val,0, 7)
#define TMS570_EMACM_RXFLOWTHRESH_RXnFLOWTHRESH_GET(reg) BSP_FLD32GET(reg,0, 7)
#define TMS570_EMACM_RXFLOWTHRESH_RXnFLOWTHRESH_SET(reg,val) BSP_FLD32SET(reg, val,0, 7)


/*-----------------TMS570_EMACM_RXFREEBUFFER-----------------*/
/* field: RXnFREEBUF - Receive free buffer count. These bits contain the count of free buffers available. */
#define TMS570_EMACM_RXFREEBUFFER_RXnFREEBUF(val) BSP_FLD32(val,0, 15)
#define TMS570_EMACM_RXFREEBUFFER_RXnFREEBUF_GET(reg) BSP_FLD32GET(reg,0, 15)
#define TMS570_EMACM_RXFREEBUFFER_RXnFREEBUF_SET(reg,val) BSP_FLD32SET(reg, val,0, 15)


/*------------------TMS570_EMACM_MACCONTROL------------------*/
/* field: RMIISPEED - RMII interface transmit and receive speed select. */
#define TMS570_EMACM_MACCONTROL_RMIISPEED BSP_BIT32(15)

/* field: RXOFFLENBLOCK - Receive offset / length word write block. */
#define TMS570_EMACM_MACCONTROL_RXOFFLENBLOCK BSP_BIT32(14)

/* field: RXOWNERSHIP - Receive ownership write bit value. */
#define TMS570_EMACM_MACCONTROL_RXOWNERSHIP BSP_BIT32(13)

/* field: CMDIDLE - Command Idle bit */
#define TMS570_EMACM_MACCONTROL_CMDIDLE BSP_BIT32(11)

/* field: TXSHORTGAPEN - Transmit Short Gap Enable */
#define TMS570_EMACM_MACCONTROL_TXSHORTGAPEN BSP_BIT32(10)

/* field: TXPTYPE - Transmit queue priority type */
#define TMS570_EMACM_MACCONTROL_TXPTYPE BSP_BIT32(9)

/* field: TXPACE - Transmit pacing enable bit */
#define TMS570_EMACM_MACCONTROL_TXPACE BSP_BIT32(6)

/* field: GMIIEN - GMII enable bit */
#define TMS570_EMACM_MACCONTROL_GMIIEN BSP_BIT32(5)

/* field: TXFLOWEN - Transmit flow control enable bit. */
#define TMS570_EMACM_MACCONTROL_TXFLOWEN BSP_BIT32(4)

/* field: RXBUFFERFLOWEN - Receive buffer flow control enable bit */
#define TMS570_EMACM_MACCONTROL_RXBUFFERFLOWEN BSP_BIT32(3)

/* field: LOOPBACK - Loopback mode. The loopback mode forces internal full-duplex mode regardless of the FULLDUPLEX bit. */
#define TMS570_EMACM_MACCONTROL_LOOPBACK BSP_BIT32(1)

/* field: FULLDUPLEX - Full duplex mode. */
#define TMS570_EMACM_MACCONTROL_FULLDUPLEX BSP_BIT32(0)


/*-------------------TMS570_EMACM_MACSTATUS-------------------*/
/* field: IDLE - EMAC idle bit. This bit is cleared to 0 at reset; one clock after reset, it goes to 1. */
#define TMS570_EMACM_MACSTATUS_IDLE BSP_BIT32(31)

/* field: TXERRCODE - Transmit host error code. These bits indicate that EMAC detected transmit DMA related host errors. */
#define TMS570_EMACM_MACSTATUS_TXERRCODE(val) BSP_FLD32(val,20, 23)
#define TMS570_EMACM_MACSTATUS_TXERRCODE_GET(reg) BSP_FLD32GET(reg,20, 23)
#define TMS570_EMACM_MACSTATUS_TXERRCODE_SET(reg,val) BSP_FLD32SET(reg, val,20, 23)

/* field: TXERRCH - Transmit host error channel. These bits indicate which transmit channel the host error occurred on. */
#define TMS570_EMACM_MACSTATUS_TXERRCH(val) BSP_FLD32(val,16, 18)
#define TMS570_EMACM_MACSTATUS_TXERRCH_GET(reg) BSP_FLD32GET(reg,16, 18)
#define TMS570_EMACM_MACSTATUS_TXERRCH_SET(reg,val) BSP_FLD32SET(reg, val,16, 18)

/* field: RXERRCODE - Receive host error code. These bits indicate that EMAC detected receive DMA related host errors. */
#define TMS570_EMACM_MACSTATUS_RXERRCODE(val) BSP_FLD32(val,12, 15)
#define TMS570_EMACM_MACSTATUS_RXERRCODE_GET(reg) BSP_FLD32GET(reg,12, 15)
#define TMS570_EMACM_MACSTATUS_RXERRCODE_SET(reg,val) BSP_FLD32SET(reg, val,12, 15)

/* field: RXERRCH - Receive host error channel. These bits indicate which receive channel the host error occurred on. */
#define TMS570_EMACM_MACSTATUS_RXERRCH(val) BSP_FLD32(val,8, 10)
#define TMS570_EMACM_MACSTATUS_RXERRCH_GET(reg) BSP_FLD32GET(reg,8, 10)
#define TMS570_EMACM_MACSTATUS_RXERRCH_SET(reg,val) BSP_FLD32SET(reg, val,8, 10)

/* field: RXQOSACT - Receive Quality of Service (QOS) active bit. */
#define TMS570_EMACM_MACSTATUS_RXQOSACT BSP_BIT32(2)

/* field: RXFLOWACT - Receive flow control active bit. */
#define TMS570_EMACM_MACSTATUS_RXFLOWACT BSP_BIT32(1)

/* field: TXFLOWACT - Transmit flow control active bit. */
#define TMS570_EMACM_MACSTATUS_TXFLOWACT BSP_BIT32(0)


/*-------------------TMS570_EMACM_EMCONTROL-------------------*/
/* field: SOFT - Emulation soft bit. */
#define TMS570_EMACM_EMCONTROL_SOFT BSP_BIT32(1)

/* field: FREE - Emulation free bit. */
#define TMS570_EMACM_EMCONTROL_FREE BSP_BIT32(0)


/*------------------TMS570_EMACM_FIFOCONTROL------------------*/
/* field: TXCELLTHRESH - Transmit FIFO cell threshold. */
#define TMS570_EMACM_FIFOCONTROL_TXCELLTHRESH(val) BSP_FLD32(val,0, 1)
#define TMS570_EMACM_FIFOCONTROL_TXCELLTHRESH_GET(reg) BSP_FLD32GET(reg,0, 1)
#define TMS570_EMACM_FIFOCONTROL_TXCELLTHRESH_SET(reg,val) BSP_FLD32SET(reg, val,0, 1)


/*-------------------TMS570_EMACM_MACCONFIG-------------------*/
/* field: TXCELLDEPTH - Transmit cell depth. These bits indicate the number of cells in the transmit FIFO. */
#define TMS570_EMACM_MACCONFIG_TXCELLDEPTH(val) BSP_FLD32(val,24, 31)
#define TMS570_EMACM_MACCONFIG_TXCELLDEPTH_GET(reg) BSP_FLD32GET(reg,24, 31)
#define TMS570_EMACM_MACCONFIG_TXCELLDEPTH_SET(reg,val) BSP_FLD32SET(reg, val,24, 31)

/* field: RXCELLDEPTH - Receive cell depth. These bits indicate the number of cells in the receive FIFO. */
#define TMS570_EMACM_MACCONFIG_RXCELLDEPTH(val) BSP_FLD32(val,16, 23)
#define TMS570_EMACM_MACCONFIG_RXCELLDEPTH_GET(reg) BSP_FLD32GET(reg,16, 23)
#define TMS570_EMACM_MACCONFIG_RXCELLDEPTH_SET(reg,val) BSP_FLD32SET(reg, val,16, 23)

/* field: ADDRESSTYPE - Address type */
#define TMS570_EMACM_MACCONFIG_ADDRESSTYPE(val) BSP_FLD32(val,8, 15)
#define TMS570_EMACM_MACCONFIG_ADDRESSTYPE_GET(reg) BSP_FLD32GET(reg,8, 15)
#define TMS570_EMACM_MACCONFIG_ADDRESSTYPE_SET(reg,val) BSP_FLD32SET(reg, val,8, 15)

/* field: MACCFIG - MAC configuration value */
#define TMS570_EMACM_MACCONFIG_MACCFIG(val) BSP_FLD32(val,0, 7)
#define TMS570_EMACM_MACCONFIG_MACCFIG_GET(reg) BSP_FLD32GET(reg,0, 7)
#define TMS570_EMACM_MACCONFIG_MACCFIG_SET(reg,val) BSP_FLD32SET(reg, val,0, 7)


/*-------------------TMS570_EMACM_SOFTRESET-------------------*/
/* field: SOFTRESET - Software reset. Writing a 1 to this bit causes the EMAC logic to be reset. */
#define TMS570_EMACM_SOFTRESET_SOFTRESET BSP_BIT32(0)


/*-----------------TMS570_EMACM_MACSRCADDRLO-----------------*/
/* field: MACSRCADDR0 - MAC source address lower 8-0 bits (byte 0) */
#define TMS570_EMACM_MACSRCADDRLO_MACSRCADDR0(val) BSP_FLD32(val,8, 15)
#define TMS570_EMACM_MACSRCADDRLO_MACSRCADDR0_GET(reg) BSP_FLD32GET(reg,8, 15)
#define TMS570_EMACM_MACSRCADDRLO_MACSRCADDR0_SET(reg,val) BSP_FLD32SET(reg, val,8, 15)

/* field: MACSRCADDR1 - MAC source address bits 15-8 (byte 1) */
#define TMS570_EMACM_MACSRCADDRLO_MACSRCADDR1(val) BSP_FLD32(val,0, 7)
#define TMS570_EMACM_MACSRCADDRLO_MACSRCADDR1_GET(reg) BSP_FLD32GET(reg,0, 7)
#define TMS570_EMACM_MACSRCADDRLO_MACSRCADDR1_SET(reg,val) BSP_FLD32SET(reg, val,0, 7)


/*-----------------TMS570_EMACM_MACSRCADDRHI-----------------*/
/* field: MACSRCADDR2 - MAC source address bits 23-16 (byte 2) */
#define TMS570_EMACM_MACSRCADDRHI_MACSRCADDR2(val) BSP_FLD32(val,24, 31)
#define TMS570_EMACM_MACSRCADDRHI_MACSRCADDR2_GET(reg) BSP_FLD32GET(reg,24, 31)
#define TMS570_EMACM_MACSRCADDRHI_MACSRCADDR2_SET(reg,val) BSP_FLD32SET(reg, val,24, 31)

/* field: MACSRCADDR3 - MAC source address bits 31-24 (byte 3) */
#define TMS570_EMACM_MACSRCADDRHI_MACSRCADDR3(val) BSP_FLD32(val,16, 23)
#define TMS570_EMACM_MACSRCADDRHI_MACSRCADDR3_GET(reg) BSP_FLD32GET(reg,16, 23)
#define TMS570_EMACM_MACSRCADDRHI_MACSRCADDR3_SET(reg,val) BSP_FLD32SET(reg, val,16, 23)

/* field: MACSRCADDR4 - MAC source address bits 39-32 (byte 4) */
#define TMS570_EMACM_MACSRCADDRHI_MACSRCADDR4(val) BSP_FLD32(val,8, 15)
#define TMS570_EMACM_MACSRCADDRHI_MACSRCADDR4_GET(reg) BSP_FLD32GET(reg,8, 15)
#define TMS570_EMACM_MACSRCADDRHI_MACSRCADDR4_SET(reg,val) BSP_FLD32SET(reg, val,8, 15)

/* field: MACSRCADDR5 - MAC source address bits 47-40 (byte 5) */
#define TMS570_EMACM_MACSRCADDRHI_MACSRCADDR5(val) BSP_FLD32(val,0, 7)
#define TMS570_EMACM_MACSRCADDRHI_MACSRCADDR5_GET(reg) BSP_FLD32GET(reg,0, 7)
#define TMS570_EMACM_MACSRCADDRHI_MACSRCADDR5_SET(reg,val) BSP_FLD32SET(reg, val,0, 7)


/*-------------------TMS570_EMACM_MACHASH1-------------------*/
/* field: MACHASH1 - Least-significant 32 bits of the hash table corresponding to hash values 0 to 31. */
/* Whole 32 bits */

/*-------------------TMS570_EMACM_MACHASH2-------------------*/
/* field: MACHASH2 - Most-significant 32 bits of the hash table corresponding to hash values 32 to 63. */
/* Whole 32 bits */

/*-------------------TMS570_EMACM_BOFFTEST-------------------*/
/* field: RNDNUM - Backoff random number generator. */
#define TMS570_EMACM_BOFFTEST_RNDNUM(val) BSP_FLD32(val,16, 25)
#define TMS570_EMACM_BOFFTEST_RNDNUM_GET(reg) BSP_FLD32GET(reg,16, 25)
#define TMS570_EMACM_BOFFTEST_RNDNUM_SET(reg,val) BSP_FLD32SET(reg, val,16, 25)

/* field: COLLCOUNT - Collision count. These bits indicate the number of collisions the current frame has experienced. */
#define TMS570_EMACM_BOFFTEST_COLLCOUNT(val) BSP_FLD32(val,12, 15)
#define TMS570_EMACM_BOFFTEST_COLLCOUNT_GET(reg) BSP_FLD32GET(reg,12, 15)
#define TMS570_EMACM_BOFFTEST_COLLCOUNT_SET(reg,val) BSP_FLD32SET(reg, val,12, 15)

/* field: TXBACKOFF - Backoff count. */
#define TMS570_EMACM_BOFFTEST_TXBACKOFF(val) BSP_FLD32(val,0, 9)
#define TMS570_EMACM_BOFFTEST_TXBACKOFF_GET(reg) BSP_FLD32GET(reg,0, 9)
#define TMS570_EMACM_BOFFTEST_TXBACKOFF_SET(reg,val) BSP_FLD32SET(reg, val,0, 9)


/*-------------------TMS570_EMACM_TPACETEST-------------------*/
/* field: PACEVAL - Pacing register current value. A nonzero value in this field indicates that transmit pacing is active. */
#define TMS570_EMACM_TPACETEST_PACEVAL(val) BSP_FLD32(val,0, 4)
#define TMS570_EMACM_TPACETEST_PACEVAL_GET(reg) BSP_FLD32GET(reg,0, 4)
#define TMS570_EMACM_TPACETEST_PACEVAL_SET(reg,val) BSP_FLD32SET(reg, val,0, 4)


/*--------------------TMS570_EMACM_RXPAUSE--------------------*/
/* field: PAUSETIMER - Receive pause timer value. */
#define TMS570_EMACM_RXPAUSE_PAUSETIMER(val) BSP_FLD32(val,0, 15)
#define TMS570_EMACM_RXPAUSE_PAUSETIMER_GET(reg) BSP_FLD32GET(reg,0, 15)
#define TMS570_EMACM_RXPAUSE_PAUSETIMER_SET(reg,val) BSP_FLD32SET(reg, val,0, 15)


/*--------------------TMS570_EMACM_TXPAUSE--------------------*/
/* field: PAUSETIMER - Transmit pause timer value. */
#define TMS570_EMACM_TXPAUSE_PAUSETIMER(val) BSP_FLD32(val,0, 15)
#define TMS570_EMACM_TXPAUSE_PAUSETIMER_GET(reg) BSP_FLD32GET(reg,0, 15)
#define TMS570_EMACM_TXPAUSE_PAUSETIMER_SET(reg,val) BSP_FLD32SET(reg, val,0, 15)


/*-------------------TMS570_EMACM_MACADDRLO-------------------*/
/* field: VALID - Address valid bit. */
#define TMS570_EMACM_MACADDRLO_VALID BSP_BIT32(20)

/* field: MATCHFILT - Match or filter bit */
#define TMS570_EMACM_MACADDRLO_MATCHFILT BSP_BIT32(19)

/* field: CHANNEL - Channel select. Determines which receive channel a valid address match will be transferred to. */
#define TMS570_EMACM_MACADDRLO_CHANNEL(val) BSP_FLD32(val,16, 18)
#define TMS570_EMACM_MACADDRLO_CHANNEL_GET(reg) BSP_FLD32GET(reg,16, 18)
#define TMS570_EMACM_MACADDRLO_CHANNEL_SET(reg,val) BSP_FLD32SET(reg, val,16, 18)

/* field: MACADDR0 - MAC address lower 8-0 bits (byte 0) */
#define TMS570_EMACM_MACADDRLO_MACADDR0(val) BSP_FLD32(val,8, 15)
#define TMS570_EMACM_MACADDRLO_MACADDR0_GET(reg) BSP_FLD32GET(reg,8, 15)
#define TMS570_EMACM_MACADDRLO_MACADDR0_SET(reg,val) BSP_FLD32SET(reg, val,8, 15)

/* field: MACADDR1 - MAC address bits 15-8 (byte 1) */
#define TMS570_EMACM_MACADDRLO_MACADDR1(val) BSP_FLD32(val,0, 7)
#define TMS570_EMACM_MACADDRLO_MACADDR1_GET(reg) BSP_FLD32GET(reg,0, 7)
#define TMS570_EMACM_MACADDRLO_MACADDR1_SET(reg,val) BSP_FLD32SET(reg, val,0, 7)


/*-------------------TMS570_EMACM_MACADDRHI-------------------*/
/* field: MACADDR2 - MAC source address bits 23-16 (byte 2) */
#define TMS570_EMACM_MACADDRHI_MACADDR2(val) BSP_FLD32(val,24, 31)
#define TMS570_EMACM_MACADDRHI_MACADDR2_GET(reg) BSP_FLD32GET(reg,24, 31)
#define TMS570_EMACM_MACADDRHI_MACADDR2_SET(reg,val) BSP_FLD32SET(reg, val,24, 31)

/* field: MACADDR3 - MAC source address bits 31-24 (byte 3) */
#define TMS570_EMACM_MACADDRHI_MACADDR3(val) BSP_FLD32(val,16, 23)
#define TMS570_EMACM_MACADDRHI_MACADDR3_GET(reg) BSP_FLD32GET(reg,16, 23)
#define TMS570_EMACM_MACADDRHI_MACADDR3_SET(reg,val) BSP_FLD32SET(reg, val,16, 23)

/* field: MACADDR4 - MAC source address bits 39-32 (byte 4) */
#define TMS570_EMACM_MACADDRHI_MACADDR4(val) BSP_FLD32(val,8, 15)
#define TMS570_EMACM_MACADDRHI_MACADDR4_GET(reg) BSP_FLD32GET(reg,8, 15)
#define TMS570_EMACM_MACADDRHI_MACADDR4_SET(reg,val) BSP_FLD32SET(reg, val,8, 15)

/* field: MACADDR5 - MAC source address bits 47-40 (byte 5). Bit 40 is the group bit. It is forced to 0 and read as 0. */
#define TMS570_EMACM_MACADDRHI_MACADDR5(val) BSP_FLD32(val,0, 7)
#define TMS570_EMACM_MACADDRHI_MACADDR5_GET(reg) BSP_FLD32GET(reg,0, 7)
#define TMS570_EMACM_MACADDRHI_MACADDR5_SET(reg,val) BSP_FLD32SET(reg, val,0, 7)


/*-------------------TMS570_EMACM_MACINDEX-------------------*/
/* field: MACINDEX - MAC address index. All eight addresses share the upper 40 bits. */
#define TMS570_EMACM_MACINDEX_MACINDEX(val) BSP_FLD32(val,0, 2)
#define TMS570_EMACM_MACINDEX_MACINDEX_GET(reg) BSP_FLD32GET(reg,0, 2)
#define TMS570_EMACM_MACINDEX_MACINDEX_SET(reg,val) BSP_FLD32SET(reg, val,0, 2)


/*---------------------TMS570_EMACM_TXHDP---------------------*/
/* field: TXnHDP - Transmit channel n DMA Head Descriptor pointer. */
/* Whole 32 bits */

/*---------------------TMS570_EMACM_RXHDP---------------------*/
/* field: RXnHDP - Receive channel n DMA Head Descriptor pointer. */
/* Whole 32 bits */

/*---------------------TMS570_EMACM_TXCP---------------------*/
/* field: TXnCP - Transmit channel n completion pointer register is written by the host with the buffer descriptor */
/* Whole 32 bits */

/*---------------------TMS570_EMACM_RXCP---------------------*/
/* field: RXnCP - Receive channel n completion pointer register is written by the host with the buffer descriptor */
/* Whole 32 bits */


#endif /* LIBBSP_ARM_TMS570_EMACM */
