/**
 *  @file
 *
 *  @brief Change Directory
 *  @ingroup libcsupport
 */

/*
 *  COPYRIGHT (c) 1989-2011.
 *  On-Line Applications Research Corporation (OAR).
 *
 *  Modifications to support reference counting in the file system are
 *  Copyright (c) 2012 embedded brains GmbH.
 *
 *  The license and distribution terms for this file may be
 *  found in the file LICENSE in this distribution or at
 *  http://www.rtems.org/license/LICENSE.
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <unistd.h>

#include <rtems/libio_.h>

/**
 *  compatible with SVr4, 4.4BSD and X/OPEN - Change Directory
 */
int fchdir( int fd )
{
  int rv = 0;
  rtems_libio_t *iop;
  struct stat st;
  rtems_filesystem_location_info_t loc;

  st.st_mode = 0;
  st.st_uid = 0;
  st.st_gid = 0;

  LIBIO_GET_IOP( fd, iop );

  rtems_filesystem_instance_lock( &iop->pathinfo );
  rv = (*iop->pathinfo.handlers->fstat_h)( &iop->pathinfo, &st );
  if ( rv == 0 ) {
    bool access_ok = rtems_filesystem_check_access(
      RTEMS_FS_PERMS_EXEC,
      st.st_mode,
      st.st_uid,
      st.st_gid
    );

    if ( access_ok ) {
      rtems_filesystem_location_clone( &loc, &iop->pathinfo );
    } else {
      errno = EACCES;
      rv = -1;
    }
  }
  rtems_filesystem_instance_unlock( &iop->pathinfo );
  rtems_libio_iop_drop( iop );

  if ( rv == 0 ) {
    rv = rtems_filesystem_chdir( &loc );
  }

  return rv;
}
