/**
 * @file
 *
 * @ingroup POSIXAPI
 *
 * @brief Function returns the ID of the Calling Thread 
 */

/*
 *  16.1.6 Get Calling Thread's ID, p1003.1c/Draft 10, p. 152
 *
 *  COPYRIGHT (c) 1989-1999.
 *  On-Line Applications Research Corporation (OAR).
 *
 *  The license and distribution terms for this file may be
 *  found in the file LICENSE in this distribution or at
 *  http://www.rtems.org/license/LICENSE.
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <pthread.h>

#include <rtems/score/percpu.h>
#include <rtems/score/thread.h>

pthread_t pthread_self( void )
{
  return _Thread_Get_executing()->Object.id;
}
