/*
 * Copyright (c) 2015 embedded brains GmbH.  All rights reserved.
 *
 *  embedded brains GmbH
 *  Dornierstr. 4
 *  82178 Puchheim
 *  Germany
 *  <rtems@embedded-brains.de>
 *
 * The license and distribution terms for this file may be
 * found in the file LICENSE in this distribution or at
 * http://www.rtems.org/license/LICENSE.
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <rtems/score/threadimpl.h>

void _Thread_Entry_adaptor_pointer( Thread_Control *executing )
{
  const Thread_Entry_pointer *pointer = &executing->Start.Entry.Kinds.Pointer;

  executing->Wait.return_argument = ( *pointer->entry )( pointer->argument );
}
