/*
* @file
* @brief pthread_setcancelstate() API Conformance Test
*/

/*
* COPYRIGHT (c) 1989-2009.
* On-Line Applications Research Corporation (OAR).
*
* The license and distribution terms for this file may be
* found in the file LICENSE in this distribution or at
* http://www.rtems.org/license/LICENSE.
*/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <pthread.h>

#ifndef _POSIX_THREADS
#error "rtems is supposed to have pthread_setcancelstate"
#endif

int test( void );
void init_routine( void );

void init_routine( void )
{
}

int test( void )
{
  int         state;
  int         oldstate;
  int         result;

  state = PTHREAD_CANCEL_ENABLE;
  state = PTHREAD_CANCEL_DISABLE;

  result = pthread_setcancelstate( state, &oldstate );

  return result;
}
