"-- standard libraries\n"
"library IEEE;\n"
"use IEEE.STD_LOGIC_1164.ALL;\n"
"use IEEE.STD_LOGIC_ARITH.ALL;\n"
"use IEEE.STD_LOGIC_UNSIGNED.ALL;\n"
"\n"
"entity PassMe is\n"
"\tport\n"
"\t(\n"
"\t\tDSSLOT_CLK\t\t: in std_logic;\n"
"\t\tDSSLOT_ROMCS\t: in std_logic;\n"
"\t\tDSSLOT_RESET\t: in std_logic;\n"
"\t\tDSSLOT_EEPCS\t: in std_logic;\n"
"\t\tDSSLOT_IRQ\t\t: out std_logic;\n"
"\t\tDSSLOT_IO\t\t: inout std_logic_vector(7 downto 0);\n"
"\t\t\n"
"\t\tDSCART_CLK\t\t: out std_logic;\n"
"\t\tDSCART_ROMCS\t: out std_logic;\n"
"\t\tDSCART_RESET\t: out std_logic;\n"
"\t\tDSCART_EEPCS\t: out std_logic;\n"
"\t\tDSCART_IRQ \t\t: in std_logic;\n"
"\t\tDSCART_IO \t\t: inout std_logic_vector(7 downto 0);\n"
"\t\t\n"
"\t\tLED0 \t\t\t: out std_logic\n"
"\t);\n"
"end entity;\n"
"\n"
"architecture rtl of passme is\n"
"\n"
"\t-- removes Xilinx mapping errors\n"
"\tattribute CLOCK_BUFFER : string;\n"
"\tattribute CLOCK_BUFFER of DSSLOT_CLK: signal is \"ibuf\";\n"
"\tattribute CLOCK_BUFFER of DSCART_CLK: signal is \"obuf\";\n"
"\n"
"\tsignal is_command\t\t: boolean;\n"
"\tsignal cmddata_cnt \t\t: natural range 0 to 511;\t\t-- 8 + 504\n"
"\tsignal patched_data\t\t: std_logic_vector(7 downto 0);\n"
"\tsignal patch_en\t\t\t: boolean;\n"
"\n"
"begin\n"
"\n"
"\t-- direct passthrough\n"
"\tDSCART_CLK <= DSSLOT_CLK;\n"
"\tDSCART_ROMCS <= DSSLOT_ROMCS;\n"
"\tDSCART_RESET <= DSSLOT_RESET;\n"
"\tDSSLOT_IRQ <= DSCART_IRQ;\n"
"\tDSCART_EEPCS <= DSSLOT_EEPCS;\n"
"\n"
"\t-- activity LED\n"
"\tLED0 <= not DSSLOT_ROMCS;\n"
"\n"
"\t-- patch\n"
"\tprocess (cmddata_cnt)\n"
"\tbegin\n"
"\t\tcase (cmddata_cnt - 8) is\n"
