@c
@c  COPYRIGHT (c) 1988-2008.
@c  On-Line Applications Research Corporation (OAR).
@c  All rights reserved.
@c
@c  $Id$
@c

@chapter Makefiles

This chapter discusses the Makefiles associated with a BSP.  It does not 
describe the process of configuring, building, and installing RTEMS.  
This chapter will not provide detailed information about this process.
Nonetheless, it is important to remember that the general process consists
of four phases as shown here:

@ifset use-ascii
@example
@group
@itemize @bullet
@item bootstrap
@item configure
@item build
@item install
@end itemize
@end group
@end example
@end ifset

@ifset use-tex
@image{Developer-User-Timeline,6in,,Developer User Timeline,.png}
@c      @image{FILENAME[, WIDTH[, HEIGHT[, ALTTEXT[, EXTENSION]]]]}
@end ifset

@ifset use-html
@html
<center>
<IMG SRC="Developer-User-Timeline.png" WIDTH=800 ALT="Developer User Timeline">
</center>
@end html
@end ifset


During the bootstrap phase, you are using the @code{configure.ac} and
@code{Makefile.am} files as input to GNU autoconf and automake to
generate a variety of files.  This is done by running the @code{bootstrap}
script found at the top of the RTEMS source tree.  

During the configure phase, a number of files are generated.  These 
generated files are tailored for the specific host/target combination
by the configure script.  This set of files includes the Makefiles used
to actually compile and install RTEMS.

During the build phase, the source files are compiled into object files
and libraries are built.

During the install phase, the libraries, header files, and other support
files are copied to the BSP specific installation point.  After installation
is successfully completed, the files generated by the configure and build
phases may be removed.

@section Makefiles Used During The BSP Building Process

RTEMS uses the @b{GNU automake} and @b{GNU autoconf} automatic
configuration package.  Consequently, there are a number of
automatically generated files in each directory in the RTEMS
source tree.  The @code{bootstrap} script found in the top level
directory of the RTEMS source tree is executed to produce the
automatically generated files.  That script must be run from
a directory with a @code{configure.ac} file in it.  The @code{bootstrap}
command is usually invoked in one of the following manners:

@itemize @bullet
@item @code{bootstrap} to regenerate all files that are generated by
autoconf and automake.
@item @code{bootstrap -c} to remove all files generated by autoconf and
automake.
@item @code{bootstrap -p} to regenerate @code{preinstall.am} files.
@end itemize

There is a file named @code{Makefile.am} in each directory of
a BSP.  This file is used by @b{automake} to produce the file named
@code{Makefile.in} which is also found in each directory of a BSP.
When modifying a @code{Makefile.am}, you can probably find examples of
anything you need to do in one of the BSPs.


The configure process specializes the @code{Makefile.in} files at the time that RTEMS
is configured for a specific development host and target.  Makefiles
are automatically generated from the @code{Makefile.in} files.  It is
necessary for the BSP developer to provide the @code{Makefile.am}
files and generate the @code{Makefile.in} files.  Most of the
time, it is possible to copy the @code{Makefile.am} from another
similar directory and edit it.

The @code{Makefile} files generated are processed when configuring
and building RTEMS for a given BSP.

The BSP developer is responsible for generating @code{Makefile.am} 
files which properly build all the files associated with their BSP.
Most BSPs will only have a single @code{Makefile.am} which details
the set of source files to build to compose the BSP support library
along with the set of include files that are to be installed.  

This single @code{Makefile.am} at the top of the BSP tree specifies
the set of header files to install.  This fragment from the SPARC/ERC32
BSP results in four header files being installed.

@example
include_HEADERS = include/bsp.h
include_HEADERS += include/tm27.h
include_HEADERS += include/erc32.h
include_HEADERS += include/coverhd.h
@end example

When adding new include files, you will be adding to the set of
@code{include_HEADERS}.  When you finish editing the @code{Makefile.am}
file, do not forget to run @code{bootstrap -p} to regenerate the
@code{preinstall.am}.

The @code{Makefile.am} also specifies which source files to build.
By convention, logical components within the BSP each assign their
source files to a unique variable.  These variables which define
the source files are collected into a single variable which instructs
the GNU autotools that we are building @code{libbsp.a}.  This fragment
from the SPARC/ERC32 BSP shows how the startup related, miscellaneous
support code, and the console device driver source is managed
in the @code{Makefile.am}.

@example
startup_SOURCES = ../../sparc/shared/bspclean.c ../../shared/bsplibc.c \
    ../../shared/bsppredriverhook.c \
    ../../shared/bsppost.c ../../sparc/shared/bspstart.c \
    ../../shared/bootcard.c ../../shared/sbrk.c startup/setvec.c \
    startup/spurious.c startup/erc32mec.c startup/boardinit.S
clock_SOURCES = clock/ckinit.c
...
noinst_LIBRARIES = libbsp.a
libbsp_a_SOURCES = $(startup_SOURCES) $(console_SOURCES) ...
@end example

When adding new files to an existing directory, do not forget to add
the new files to the list of files to be built in the corresponding
@code{XXX_SOURCES} variable in the @code{Makefile.am} and run
@code{bootstrap}.

Some BSPs use code that is built in @code{libcpu}.  If you BSP does
this, then you will need to make sure the objects are pulled into your
BSP library.  The following from the SPARC/ERC32 BSP pulls in the cache,
register window management and system call support code from the directory
corresponding to its @code{RTEMS_CPU} model.

@example
libbsp_a_LIBADD  = ../../../libcpu/@@RTEMS_CPU@@/cache.rel \
    ../../../libcpu/@@RTEMS_CPU@@/reg_win.rel \
    ../../../libcpu/@@RTEMS_CPU@@/syscall.rel
@end example

@b{NOTE:} The @code{Makefile.am} files are ONLY processed by
@code{bootstrap} and the resulting @code{Makefile.in} files are only
processed during the configure process of a RTEMS build. Therefore,
when developing a BSP and adding a new file to a @code{Makefile.am},
the already generated @code{Makefile} will not automatically
include the new references unless you configured RTEMS with the
@code{--enable-maintainer-mode} option.  Otherwise, the new file not
being be taken into account!

@section Creating a New BSP Make Customization File

When building a BSP or an application using that BSP, it is necessary
to tailor the compilation arguments to account for compiler flags, use
custom linker scripts, include the RTEMS libraries, etc..  The BSP
must be built using this information.  Later, once the BSP is installed
with the toolset, this same information must be used when building the
application.  So a BSP must include a build configuration file.  The
configuration file is @code{make/custom/BSP.cfg}.

The configuration file is taken into account when building one's
application using the RTEMS template Makefiles (@code{make/templates}).
These application template Makefiles have been included with the
RTEMS source distribution since the early 1990's.  However there is
a desire in the RTEMS user community to move all provided examples to
GNU autoconf. They are included in the 4.9 release series and used for
all examples provided with RTEMS. There is no definite time table for
obsoleting them.  You are free to use these but be warned they have
fallen out of favor with many in the RTEMS community and may disappear
in the future.

The following is a slightly shortened version of the make customization
file for the gen68340 BSP.  The original source for this file can be
found in the @code{make/custom} directory.

@example
# The RTEMS CPU Family and Model
RTEMS_CPU=m68k
RTEMS_CPU_MODEL=m68340

include $(RTEMS_ROOT)/make/custom/default.cfg

# This is the actual bsp directory used during the build process.
RTEMS_BSP_FAMILY=gen68340

# This contains the compiler options necessary to select the CPU model
# and (hopefully) optimize for it.
CPU_CFLAGS = -mcpu=cpu32

# optimize flag: typically -O2
CFLAGS_OPTIMIZE_V = -O2 -g -fomit-frame-pointer
@end example

The make customization files have generally grown simpler and simpler
with each RTEMS release.  Beginning in the 4.9 release series, the rules
for linking an RTEMS application are shared by all BSPs.  Only BSPs which
need to perform a transformation from linked ELF file to a downloadable
format have any additional actions for program link time. In 4.8 and
older, every BSP specified the "make executable" or @code{make-exe}
rule and duplicated the same actions.

It is generally easier to copy a @code{make/custom} file from a
BSP similar to the one being developed.

