/*
 *  COPYRIGHT (c) 1989-2009.
 *  On-Line Applications Research Corporation (OAR).
 *
 *  The license and distribution terms for this file may be
 *  found in the file LICENSE in this distribution or at
 *  http://www.rtems.com/license/LICENSE.
 *
 *  $Id$
 */

#include "tmacros.h"

rtems_task Init(
  rtems_task_argument ignored
)
{
  puts( "\n\n*** TEST COVERAGE MARKERS ***" );

  puts( "Init - If coverage enabled, call coverage marker methods" );
  #if defined(RTEMS_COVERAGE)
    start_coverage();
    end_coverage();
  #endif

  puts( "*** END OF TEST COVERAGE MARKERS ***" );
  rtems_test_exit(0);
}

/* configuration information */

#define CONFIGURE_APPLICATION_NEEDS_CONSOLE_DRIVER
#define CONFIGURE_APPLICATION_DOES_NOT_NEED_CLOCK_DRIVER

#define CONFIGURE_MAXIMUM_TASKS         1
#define CONFIGURE_RTEMS_INIT_TASKS_TABLE

#define CONFIGURE_INIT
#include <rtems/confdefs.h>

/* global variables */
