@c
@c COPYRIGHT (c) 1988-2002.
@c On-Line Applications Research Corporation (OAR).
@c All rights reserved.
@c
@c $Id$
@c

@chapter Services Provided by the Math Library (libm)

@section Introduction

This section lists the routines that provided by the Newlib Math Library
(libm).

@section Standard Math Functions (math.h)

@itemize @bullet
@item @code{acos} - Arccosine 
@item @code{acosh} - Inverse hyperbolic cosine 
@item @code{asin} - Arcsine 
@item @code{asinh} - Inverse hyperbolic sine 
@item @code{atan} - Arctangent 
@item @code{atan2} - Arctangent of y/x 
@item @code{atanh} - Inverse hyperbolic tangent 
@item @code{jN} - Bessel functions (jN and yN) 
@item @code{cbrt} - Cube root 
@item @code{copysign} - Sign of Y and magnitude of X 
@item @code{cosh} - Hyperbolic cosine 
@item @code{erf} - Error function (erf and erfc) 
@item @code{exp} - Exponential 
@item @code{expm1} - Exponential of x and - 1 
@item @code{fabs} - Absolute value (magnitude) 
@item @code{floor} - Floor and ceiling (floor and ceil) 
@item @code{fmod} - Floating-point remainder (modulo) 
@item @code{frexp} - Split floating-point number 
@item @code{gamma} - Logarithmic gamma function 
@item @code{hypot} - Distance from origin 
@item @code{ilogb} - Get exponent 
@item @code{infinity} - Floating infinity 
@item @code{isnan} - Check type of number 
@item @code{ldexp} - Load exponent 
@item @code{log} - Natural logarithms 
@item @code{log10} - Base 10 logarithms 
@item @code{log1p} - Log of 1 + X 
@item @code{matherr} - Modifiable math error handler 
@item @code{modf} - Split fractional and integer parts 
@item @code{nan} - Floating Not a Number 
@item @code{nextafter} - Get next representable number 
@item @code{pow} - X to the power Y 
@item @code{remainder} - remainder of X divided by Y 
@item @code{scalbn} - scalbn 
@item @code{sin} - Sine or cosine (sin and cos) 
@item @code{sinh} - Hyperbolic sine 
@item @code{sqrt} - Positive square root 
@item @code{tan} - Tangent 
@item @code{tanh} - Hyperbolic tangent 
@end itemize
