dnl
dnl $Id: check-multiprocessing.m4,v 1.11.4.1 2004/08/18 07:23:00 ralf Exp $
dnl

AC_DEFUN([RTEMS_CHECK_MULTIPROCESSING],
[dnl
AC_REQUIRE([RTEMS_ENABLE_MULTILIB])dnl
AC_REQUIRE([RTEMS_ENV_RTEMSBSP])dnl
AC_REQUIRE([RTEMS_TOP])dnl
AC_REQUIRE([RTEMS_CHECK_CPU])dnl
AC_REQUIRE([RTEMS_ENABLE_MULTIPROCESSING])dnl
AC_REQUIRE([RTEMS_BSP_ALIAS])dnl

AC_CACHE_CHECK([if wanting multiprocessing],
  [rtems_cv_want_multiprocessing],
  [
    AS_IF([test x"$multilib" = x"no"],
      [# no cpukit
       rtems_cv_want_multiprocessing="$enable_multiprocessing"
      ],[
#HACK: Should check for RTEMS_MULTIPROCESSING in cpuopts.h, instead
       rtems_cv_want_multiprocessing="$enable_multiprocessing"
      ])
  ])

AS_IF([test "$rtems_cv_want_multiprocessing" = "yes"],
[
  AC_CACHE_CHECK([whether BSP supports multiprocessing],
  [rtems_cv_HAS_MP],[
    if test -d "$srcdir/${RTEMS_TOPdir}/c/src/lib/libbsp/${RTEMS_CPU}/${RTEMS_BSP_FAMILY}/shmsupp"; then
        rtems_cv_HAS_MP="yes" ;
    else
        rtems_cv_HAS_MP="no";
    fi
  ])
if test $rtems_cv_HAS_MP = "no"; then
AC_MSG_ERROR([multiprocessing requested but not supported])
fi
if test ${RTEMS_BSP_FAMILY} = "leon2"; then
	 rtems_cv_HAS_MP="no";
fi	
if test ${RTEMS_BSP_FAMILY} = "erc32"; then
	 rtems_cv_HAS_MP="no";
fi	
],[rtems_cv_HAS_MP="no";])

AC_SUBST(HAS_MP,[$rtems_cv_HAS_MP])
])
