--
--  TMTEST / SPECIFICATION
--
--  DESCRIPTION:
--
--  This package is the specification for Test 8 of the RTEMS
--  Timing Test Suite.
--
--  DEPENDENCIES: 
--
--  
--
--  COPYRIGHT (c) 1989-1997.
--  On-Line Applications Research Corporation (OAR).
--
--  The license and distribution terms for this file may in
--  the file LICENSE in this distribution or at
--  http://www.rtems.com/license/LICENSE.
--
--  $Id: tmtest.ads,v 1.3.4.2 2003/09/04 18:43:38 joel Exp $
--

with TIMER_DRIVER;
with RTEMS;

package TMTEST is

   TASK_ID   : RTEMS.ID;

--
--  The following variable is set to the execution time returned
--  by the timer.
--

   END_TIME  : RTEMS.UNSIGNED32;

--
--  INIT
--
--  DESCRIPTION:
--
--  This RTEMS task initializes the application.
--

   procedure INIT (
      ARGUMENT : in     RTEMS.TASK_ARGUMENT
   );

--
--  TEST_INIT
--
--  DESCRIPTION:
--
--  This subprogram performs test initialization.
--

   procedure TEST_INIT;

--
--  TEST_TASK
--
--  DESCRIPTION:
--
--  This RTEMS task is responsible for measuring and reporting the
--  following directive execution times:
--
--    + TASK_SET_PRIORITY to obtain the current priority
--    + TASK_SET_PRIORITY which does not require a context switch
--    + TASK_MODE to obtain the current mode
--    + TASK_MODE which does not require a reschedule
--    + TASK_MODE which does require a reschedule
--    + TASK_MODE which causes a preemption *** TEST_TASK1 executes 
--    + TASK_SET_NOTE
--    + TASK_GET_NOTE
--    + CLOCK_SET
--    + CLOCK_GET
--

   procedure TEST_TASK (
      ARGUMENT : in     RTEMS.TASK_ARGUMENT
   );

--
--  TEST_TASK2
--
--  DESCRIPTION:
--
--  This RTEMS task is responsible for measuring and reporting the
--  following directive execution times:
--
--    + TASK_MODE which results in a preemption
--

   procedure TEST_TASK1 (
      ARGUMENT : in     RTEMS.TASK_ARGUMENT
   );

end TMTEST;
