/*  set_vector
 *
 *  This routine installs an interrupt vector on the target Board/CPU.
 *  This routine is allowed to be as board dependent as necessary.
 *
 *  INPUT:
 *    handler - interrupt handler entry point
 *    vector  - vector number
 *    type    - 0 indicates raw hardware connect
 *              1 indicates RTEMS interrupt connect
 *
 *  RETURNS:
 *    address of previous interrupt handler
 *
 *  COPYRIGHT (c) 1989-1999.
 *  On-Line Applications Research Corporation (OAR).
 *
 *  The license and distribution terms for this file may be
 *  found in the file LICENSE in this distribution or at
 *  http://www.rtems.com/license/LICENSE.
 *
 *  $Id: setvec.c,v 1.6.6.1 2003/09/04 18:43:42 joel Exp $
 */

#include <rtems.h>
#include <bsp.h>

#ifndef lint
static char _sccsid[] = "@(#)setvec.c 06/30/96     1.2\n";
#endif

no_cpu_isr_entry set_vector(                    /* returns old vector */
  rtems_isr_entry     handler,                  /* isr routine        */
  rtems_vector_number vector,                   /* vector number      */
  int                 type                      /* RTEMS or RAW intr  */
)
{
  no_cpu_isr_entry previous_isr;

  if ( type )
    rtems_interrupt_catch( handler, vector, (rtems_isr_entry *) &previous_isr );
  else {
    /* XXX: install non-RTEMS ISR as "raw" interupt */
/* JRS just to link 9/22/2000 */
#if 0
    _settrap( vector, handler );
#else
     ;
#endif
  }
  return previous_isr;
}

