/*
 * Real Time Clock (MK48T08) for RTEMS on MVME162
 *
 *  Author:
 *    COPYRIGHT (C) 1997
 *    by Katsutoshi Shibuya - BU Denken Co.,Ltd. - Sapporo - JAPAN
 *    ALL RIGHTS RESERVED
 *
 *  The license and distribution terms for this file may be
 *  found in the file LICENSE in this distribution or at
 *  http://www.rtems.com/license/LICENSE.
 *
 *  This material is a part of the MVME162 Board Support Package
 *  for the RTEMS executive. Its licensing policies are those of the
 *  RTEMS above.
 *
 *  $Id: tod.h,v 1.1.10.1 2003/09/04 18:44:40 joel Exp $
 */


#ifndef TOD_H
#define TOD_H

#ifdef __cplusplus
extern "C" {
#endif

extern void setRealTimeToRTEMS();
/* Read real time from RTC and set it to RTEMS' clock manager */

extern void setRealTimeFromRTEMS();
/* Read time from RTEMS' clock manager and set it to RTC */

extern int checkRealTime();
/* Return the difference between RTC and RTEMS' clock manager time in minutes.
   If the difference is greater than 1 day, this returns 9999. */

#ifdef __cplusplus
}
#endif

#endif
