/*
 *  LEON3 Opencores Ethernet MAC Configuration Information
 *
 *  COPYRIGHT (c) 2004.
 *  Gaisler Research
 *
 *  The license and distribution terms for this file may be
 *  found in the file LICENSE in this distribution or at
 *  http://www.rtems.com/license/LICENSE.
 *
 *  leon_open_eth.c,v 1.1.2.1 2005/10/05 19:26:00 joel Exp
 */


#include <bsp.h>
#include <libchip/greth.h>
/*#if (GRETH_DEBUG & GRETH_DEBUG_PRINT_REGISTERS)*/
#include <stdio.h>
#include <amba.h>
/*#endif*/

/*
 * Default sizes of transmit and receive descriptor areas
 */
#define RDA_COUNT     32
#define TDA_COUNT     32

greth_configuration_t leon2_greth_configuration; 

int rtems_leon2_greth_driver_attach(
  struct rtems_bsdnet_ifconfig *config,
  int attach
)
{
  amba_apb_device dev;
  
  /* Scan LEON2 AMBA PnP bus if not already done */
  leon2_ambapp_init();
  
  /* Scan for MAC AHB slave interface */
  if ( amba_find_apbslv(&leon2_ambapp,VENDOR_GAISLER,GAISLER_ETHMAC,&dev) != 1 ){
    printk("GRETH not found\n\r");
    return 0;
  }

  /* clear control register and reset NIC */
  *(volatile int *) dev.start = 0;
  *(volatile int *) dev.start = GRETH_CTRL_RST;
  *(volatile int *) dev.start = 0;
  leon2_greth_configuration.base_address = dev.start;
  leon2_greth_configuration.vector = dev.irq+0x10;
  leon2_greth_configuration.txd_count = TDA_COUNT;
  leon2_greth_configuration.rxd_count = RDA_COUNT;
  if (rtems_greth_driver_attach( config, &leon2_greth_configuration )) {
    LEON_Clear_interrupt(leon2_greth_configuration.vector);
    LEON_Unmask_interrupt(leon2_greth_configuration.vector);
  }
  return 0;
}
