/*===============================================================*\
| Project: RTEMS remote gdb over serial line                      |
+-----------------------------------------------------------------+
| File: serdbg.c                                                  |
+-----------------------------------------------------------------+
|                    Copyright (c) 2002 IMD                       |
|      Ingenieurbuero fuer Microcomputertechnik Th. Doerfler      |
|               <Thomas.Doerfler@imd-systems.de>                  |
|                       all rights reserved                       |
+-----------------------------------------------------------------+
| this file contains intialization and utility functions to add   |
| a gdb remote debug stub to an RTEMS system                      |
|                                                                 |
+-----------------------------------------------------------------+
|   date                      history                        ID   |
| ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ |
| 04.04.02  creation                                         doe  |
\*===============================================================*/
/* 
 * $Id: serdbg.c,v 1.1.4.1 2003/07/08 08:38:15 ralf Exp $
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <rtems.h>
#include <stdio.h>
#include <string.h>
#include <fcntl.h>
#include <errno.h>
#include <serdbg.h>


/*=========================================================================*\
| Function:                                                                 |
\*-------------------------------------------------------------------------*/
int serdbg_init_dbg
(
/*-------------------------------------------------------------------------*\
| Purpose:                                                                  |
|   initialize remote gdb session over serial line                          |
+---------------------------------------------------------------------------+
| Input Parameters:                                                         |
\*-------------------------------------------------------------------------*/
 void
)
/*-------------------------------------------------------------------------*\
| Return Value:                                                             |
|    rtems_status_code                                                      |
\*=========================================================================*/
{
  static boolean is_initialized = FALSE;

  rtems_status_code rc = RTEMS_SUCCESSFUL;
  extern void set_debug_traps(void);
  extern void breakpoint(void);

  if (is_initialized) {
    return RTEMS_SUCCESSFUL;
  }
  is_initialized = TRUE;
  /* 
   * try to open serial device
   */
  if (rc == RTEMS_SUCCESSFUL) {
    if ((serdbg_conf.open_io != NULL) && 
	(0 > serdbg_conf.open_io(serdbg_conf.devname,serdbg_conf.baudrate))) {
      fprintf(stderr,
	      "remote_gdb_init: cannot open device %s "
	      "for gdb connection:%s\n",serdbg_conf.devname,strerror(errno));
      rc = RTEMS_IO_ERROR;
    }
  }
  /*
   * initialize gdb stub
   */
  if (rc == RTEMS_SUCCESSFUL) {
    set_debug_traps();
  }
  /*
   * now activate gdb stub
   */
  if ((rc == RTEMS_SUCCESSFUL) && 
      !serdbg_conf.skip_init_bkpt) {
    breakpoint();
  }

  /*
   * return to original function
   * this may be already unter gdb control
   */
  return rc;
}

