/*
 *  $Id: seminit.c,v 1.6 2002/01/04 18:28:24 joel Exp $
 */

#if HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdarg.h>

#include <errno.h>
#include <fcntl.h>
#include <pthread.h>
#include <semaphore.h>
#include <limits.h>

#include <rtems/system.h>
#include <rtems/score/object.h>
#include <rtems/posix/semaphore.h>
#include <rtems/posix/time.h>
#include <rtems/seterr.h>

/*PAGE
 *
 *  11.2.1 Initialize an Unnamed Semaphore, P1003.1b-1993, p.219
 */

int sem_init(
  sem_t         *sem,
  int            pshared,
  unsigned int   value
)
{
  int                        status;
  POSIX_Semaphore_Control   *the_semaphore;

  if ( !sem )
    rtems_set_errno_and_return_minus_one( EINVAL );
    
  status = _POSIX_Semaphore_Create_support(
    NULL,
    pshared,
    value,
    &the_semaphore
  );
    
  if ( status != -1 )
    *sem = the_semaphore->Object.id;

  return status;
}
