/*  mips64orion.h
 *
 *  Author:     Craig Lebakken <craigl@transition.com>
 *
 *  COPYRIGHT (c) 1996 by Transition Networks Inc.
 *
 *  To anyone who acknowledges that this file is provided "AS IS"
 *  without any express or implied warranty:
 *      permission to use, copy, modify, and distribute this file
 *      for any purpose is hereby granted without fee, provided that
 *      the above copyright notice and this notice appears in all
 *      copies, and that the name of Transition Networks not be used in
 *      advertising or publicity pertaining to distribution of the
 *      software without specific, written prior permission.
 *      Transition Networks makes no representations about the suitability
 *      of this software for any purpose.
 *
 *  Derived from source copyrighted as follows:
 *
 *  COPYRIGHT (c) 1989-1999.
 *  On-Line Applications Research Corporation (OAR).
 *
 *  The license and distribution terms for this file may be
 *  found in the file LICENSE in this distribution or at
 *  http://www.rtems.com/license/LICENSE.
 *
 *  $Id: mips64orion.h,v 1.4.4.1 2003/09/04 18:47:32 joel Exp $
 */
/* @(#)mips64orion.h       08/29/96     1.3 */

#ifndef _INCLUDE_MIPS64ORION_h
#define _INCLUDE_MIPS64ORION_h

#ifdef __cplusplus
extern "C" {
#endif

/*
 *  This file contains the information required to build
 *  RTEMS for a particular member of the "no cpu"
 *  family when executing in protected mode.  It does
 *  this by setting variables to indicate which implementation
 *  dependent features are present in a particular member
 *  of the family.
 */
 
#if defined(rtems_multilib)
/*
 *  Figure out all CPU Model Feature Flags based upon compiler 
 *  predefines. 
 */

#define CPU_MODEL_NAME  "rtems_multilib"
#define MIPS64ORION_HAS_FPU     1

#elif defined(R4650)
 
#define CPU_MODEL_NAME  "R4650"
#define MIPS64ORION_HAS_FPU     1
 
#elif defined(R4600)
 
#define CPU_MODEL_NAME  "R4600"
#define MIPS64ORION_HAS_FPU     1

#else
 
#error "Unsupported CPU Model"
 
#endif

/*
 *  Define the name of the CPU family.
 */

#define CPU_NAME "MIPS R46xxx"

#ifdef __cplusplus
}
#endif

#endif /* ! _INCLUDE_MIPS64ORION_h */
/* end of include file */
