/*
 * Copyright (c) 1998,1999,2000 Ralf Corsepius (corsepiu@faw.uni-ulm.de)
 *
 * See the file COPYING for copyright notice.
 */

#include <stdio.h>
#include <string.h>	/* strcmp, strerror */
#include <errno.h>
#include <getopt.h>

#include "sci.h"

static void usage( FILE* ofile, char *prog )
{
  fprintf( ofile, "Usage: %s [options] driver\n", prog );
  fprintf( ofile, "\nOptions:\n" );
  fprintf( ofile, "Processor frequency (default 20MHz):\n") ;
  fprintf( ofile, "\t-M Phi      .. processor frequency [MHz]\n" );
  fprintf( ofile, "\t-K Phi      .. processor frequency [KHz]\n" );
  fprintf( ofile, "\t-H Phi      .. processor frequency [Hz]\n" );
  fprintf( ofile, "Driver:\n" );
  fprintf( ofile, "\tsci         .. bitrate table for sci\n" );

  fprintf( ofile, "\nWritten by Ralf Corsepius <corsepiu@faw.uni-ulm.de>\n" );
  fprintf( ofile, "\nCopyright (c) 1998,1999,2000\tRalf Corsepius\n" );
}

#if HAVE_GETOPT_LONG
#define NOARG   0
#define HASARG  1
#define OPTARG  2

static struct option long_options[] =
{
  { "version",  	NOARG,  NULL, 'v' },
  { "help",     	NOARG,  NULL, 'h' },
  { "mega-hertz",       HASARG, NULL, 'M' },
  { "kilo-hertz",       HASARG, NULL, 'K' },
  { "hertz",  		HASARG, NULL, 'H' },
  { 0, 0, 0, 0 }
};
#endif

static void shgen_header( FILE *file )
{
  fprintf( file, 
    "/*\n * DO NOT EDIT - this file is automatically generated by shgen %s\n",
    VERSION );
  fprintf( file,
    " * Copyright (c) 1998,1999,2000 Ralf Corsepius (corsepiu@faw.uni-ulm.de)\n */\n" );
  fprintf( file, 
    "\n/* This file is not copyrighted */\n\n" );
}

int main( int argc, char *argv[] )
{
  double 	Phi = 20000000.0 ;

#if HAVE_GETOPT_LONG  
  int option_index = 0 ;
  while( ( optopt = getopt_long( argc, argv, "M:K:H:hv",
      long_options, &option_index ) ) > 0 )
#else
  while ( ( optopt = getopt( argc, argv, "M:K:H:hv" ) ) > 0 )
#endif
  {
    switch ( optopt )
    {
    case 'M' :
      sscanf( optarg, "%lf", &Phi ); 
      Phi = Phi * 1000000.0;
      break ;
    case 'K' :
      sscanf( optarg, "%lf", &Phi ); 
      Phi = Phi * 1000.0;
      break ;
    case 'H' :
      sscanf( optarg, "%lf", &Phi );
      break ;
    case 'h' :
      usage( stdout, argv[0] );
      exit(0);
    case 'v' :
      fprintf( stdout, "%s version %s\n", argv[0], VERSION );
      exit(0);
    default  :
      usage( stderr, argv[0] );
      exit(1);
      break ;
    }
  }

  if ( argc - optind != 1 )
  {
    fprintf( stderr, "%s: Missing argument: driver\n", argv[0] );
    exit(1);
  }
  
  shgen_header( stdout );
      
  if ( strcmp( argv[optind], "sci" ) == 0 )
  {
    shgen_gensci( stdout, Phi );
  }
  else
  {
    fprintf( stderr, "%s: Invalid argument: driver\n", argv[0] );
    exit(1);
  }
      
  return 0 ;
}
