--
--  SPTEST / SPECIFICATION
--
--  DESCRIPTION:
--
--  This package is the specification for Test 7 of the RTEMS
--  Single Processor Test Suite.
--
--  DEPENDENCIES: 
--
--  
--
--  COPYRIGHT (c) 1989-1997.
--  On-Line Applications Research Corporation (OAR).
--
--  The license and distribution terms for this file may in
--  the file LICENSE in this distribution or at
--  http://www.rtems.com/license/LICENSE.
--
--  $Id: sptest.ads,v 1.7 2003/09/04 18:50:39 joel Exp $
--

with RTEMS;

package SPTEST is

--
--  These arrays contain the IDs and NAMEs of all RTEMS tasks created
--  by this test.
--

   TASK_ID   : array ( RTEMS.UNSIGNED32 range 1 .. 4 ) of RTEMS.ID;
   TASK_NAME : array ( RTEMS.UNSIGNED32 range 1 .. 4 ) of RTEMS.NAME;

--
--  These arrays contain the IDs and NAMEs of all RTEMS extensions created
--  by this test.
--
 
   EXTENSION_ID   : array ( RTEMS.UNSIGNED32 range 1 .. 3 ) of RTEMS.ID;
   EXTENSION_NAME : array ( RTEMS.UNSIGNED32 range 1 .. 3 ) of RTEMS.NAME;
 
--
--  INIT
--
--  DESCRIPTION:
--
--  This RTEMS task initializes the application.
--

   procedure INIT (
      ARGUMENT : in     RTEMS.TASK_ARGUMENT
   );

--
--  TASK_1
--
--  DESCRIPTION:
--
--  This RTEMS task tests some of the capabilities of the Task Manager.
--

   procedure TASK_1 (
      ARGUMENT : in     RTEMS.TASK_ARGUMENT
   );

--
--  TASK_2
--
--  DESCRIPTION:
--
--  This RTEMS task tests some of the capabilities of the Task Manager.
--

   procedure TASK_2 (
      ARGUMENT : in     RTEMS.TASK_ARGUMENT
   );

--
--  TASK_3
--
--  DESCRIPTION:
--
--  This RTEMS task tests some of the capabilities of the Task Manager.
--

   procedure TASK_3 (
      ARGUMENT : in     RTEMS.TASK_ARGUMENT
   );

--
--  TASK_4
--
--  DESCRIPTION:
--
--  This RTEMS task tests the Message Queue Manager.
--

   procedure TASK_4 (
      ARGUMENT : in     RTEMS.TASK_ARGUMENT
   );

--
--  TASK_CREATE_EXTENSION
--
--  DESCRIPTION:
--
--  This subprogram is the TASK_CREATE extension for this test.
--

   procedure TASK_CREATE_EXTENSION (
      UNUSED       : in     RTEMS.TCB_POINTER;
      CREATED_TASK : in     RTEMS.TCB_POINTER
   );

--
--  TASK_DELETE_EXTENSION
--
--  DESCRIPTION:
--
--  This subprogram is the TASK_DELETE extension for this test.
--

   procedure TASK_DELETE_EXTENSION (
      RUNNING_TASK : in     RTEMS.TCB_POINTER;
      DELETED_TASK : in     RTEMS.TCB_POINTER
   );

--
--  TASK_RESTART_EXTENSION
--
--  DESCRIPTION:
--
--  This subprogram is the TASK_RESTART extension for this test.
--

   procedure TASK_RESTART_EXTENSION (
      UNUSED         : in     RTEMS.TCB_POINTER;
      RESTARTED_TASK : in     RTEMS.TCB_POINTER
   );

--
--  TASK_START_EXTENSION
--
--  DESCRIPTION:
--
--  This subprogram is the TASK_START extension for this test.
--

   procedure TASK_START_EXTENSION (
      UNUSED       : in     RTEMS.TCB_POINTER;
      STARTED_TASK : in     RTEMS.TCB_POINTER
   );

--
--  TASK_EXIT_EXTENSION
--
--  DESCRIPTION:
--
--  This subprogram is the TASK_EXIT extension for this test.
--  It is invoked when a RTEMS task exits from its entry point.
--

   procedure TASK_EXIT_EXTENSION (
      RUNNING_TASK : in     RTEMS.TCB_POINTER
   );

--
--  This is the User Extension Table for this test.
--

   EXTENSIONS : aliased RTEMS.EXTENSIONS_TABLE :=
   (
        SPTEST.TASK_CREATE_EXTENSION'ACCESS,         -- Task create
        SPTEST.TASK_START_EXTENSION'ACCESS,          -- Task start
        SPTEST.TASK_RESTART_EXTENSION'ACCESS,        -- Task restart
        SPTEST.TASK_DELETE_EXTENSION'ACCESS,         -- Task delete
        NULL,                                        -- Task switch
        NULL,                                        -- Task post switch
        NULL,                                        -- Task begin
        SPTEST.TASK_EXIT_EXTENSION'ACCESS,           -- Task exitted
        NULL                                         -- Fatal error
   );

end SPTEST;
