/*  coverhd.h
 *
 *  This include file has defines to represent the overhead associated
 *  with calling a particular directive from C.  These are used in the
 *  Timing Test Suite to ignore the overhead required to pass arguments
 *  to directives.  On some CPUs and/or target boards, this overhead
 *  is significant and makes it difficult to distinguish internal
 *  RTEMS execution time from that used to call the directive.
 *  This file should be updated after running the C overhead timing
 *  test.  Once this update has been performed, the RTEMS Time Test
 *  Suite should be rebuilt to account for these overhead times in the
 *  timing results.
 *
 *  NOTE:  If these are all zero, then the times reported include
 *         all calling overhead including passing of arguments.
 *
 *  COPYRIGHT (c) 1989-1998.
 *  On-Line Applications Research Corporation (OAR).
 *
 *  The license and distribution terms for this file may be
 *  found in the file LICENSE in this distribution or at
 *  http://www.rtems.com/license/LICENSE.
 *
 *  $Id: coverhd.h,v 1.6 2006/03/17 10:11:37 ralf Exp $
 */

#ifndef __COVERHD_h
#define __COVERHD_h

#ifdef __cplusplus
extern "C" {
#endif

#if ( defined(mbx821_001) || defined(mbx821_001b) || defined(mbx860_001b) )
#if defined( INSTRUCTION_CACHE_ENABLE )
/*
 * 50 MHz processor, cache enabled.
 */
#define CALLING_OVERHEAD_INITIALIZE_EXECUTIVE      0
#define CALLING_OVERHEAD_SHUTDOWN_EXECUTIVE        0
#define CALLING_OVERHEAD_TASK_CREATE               1
#define CALLING_OVERHEAD_TASK_IDENT                0
#define CALLING_OVERHEAD_TASK_START                0
#define CALLING_OVERHEAD_TASK_RESTART              0
#define CALLING_OVERHEAD_TASK_DELETE               0
#define CALLING_OVERHEAD_TASK_SUSPEND              0
#define CALLING_OVERHEAD_TASK_RESUME               0
#define CALLING_OVERHEAD_TASK_SET_PRIORITY         0
#define CALLING_OVERHEAD_TASK_MODE                 0
#define CALLING_OVERHEAD_TASK_GET_NOTE             0
#define CALLING_OVERHEAD_TASK_SET_NOTE             0
#define CALLING_OVERHEAD_TASK_WAKE_WHEN            1
#define CALLING_OVERHEAD_TASK_WAKE_AFTER           0
#define CALLING_OVERHEAD_INTERRUPT_CATCH           0
#define CALLING_OVERHEAD_CLOCK_GET                 1
#define CALLING_OVERHEAD_CLOCK_SET                 1
#define CALLING_OVERHEAD_CLOCK_TICK                0

#define CALLING_OVERHEAD_TIMER_CREATE              0
#define CALLING_OVERHEAD_TIMER_IDENT               0
#define CALLING_OVERHEAD_TIMER_DELETE              0
#define CALLING_OVERHEAD_TIMER_FIRE_AFTER          0
#define CALLING_OVERHEAD_TIMER_FIRE_WHEN           1
#define CALLING_OVERHEAD_TIMER_RESET               0
#define CALLING_OVERHEAD_TIMER_CANCEL              0
#define CALLING_OVERHEAD_SEMAPHORE_CREATE          0
#define CALLING_OVERHEAD_SEMAPHORE_IDENT           0
#define CALLING_OVERHEAD_SEMAPHORE_DELETE          0
#define CALLING_OVERHEAD_SEMAPHORE_OBTAIN          0
#define CALLING_OVERHEAD_SEMAPHORE_RELEASE         0
#define CALLING_OVERHEAD_MESSAGE_QUEUE_CREATE      0
#define CALLING_OVERHEAD_MESSAGE_QUEUE_IDENT       0
#define CALLING_OVERHEAD_MESSAGE_QUEUE_DELETE      0
#define CALLING_OVERHEAD_MESSAGE_QUEUE_SEND        0
#define CALLING_OVERHEAD_MESSAGE_QUEUE_URGENT      0
#define CALLING_OVERHEAD_MESSAGE_QUEUE_BROADCAST   0
#define CALLING_OVERHEAD_MESSAGE_QUEUE_RECEIVE     0
#define CALLING_OVERHEAD_MESSAGE_QUEUE_FLUSH       0

#define CALLING_OVERHEAD_EVENT_SEND                0
#define CALLING_OVERHEAD_EVENT_RECEIVE             0
#define CALLING_OVERHEAD_SIGNAL_CATCH              0
#define CALLING_OVERHEAD_SIGNAL_SEND               0
#define CALLING_OVERHEAD_PARTITION_CREATE          1
#define CALLING_OVERHEAD_PARTITION_IDENT           0
#define CALLING_OVERHEAD_PARTITION_DELETE          0
#define CALLING_OVERHEAD_PARTITION_GET_BUFFER      0
#define CALLING_OVERHEAD_PARTITION_RETURN_BUFFER   0
#define CALLING_OVERHEAD_REGION_CREATE             1
#define CALLING_OVERHEAD_REGION_IDENT              0
#define CALLING_OVERHEAD_REGION_DELETE             0
#define CALLING_OVERHEAD_REGION_GET_SEGMENT        0
#define CALLING_OVERHEAD_REGION_RETURN_SEGMENT     0
#define CALLING_OVERHEAD_PORT_CREATE               0
#define CALLING_OVERHEAD_PORT_IDENT                0
#define CALLING_OVERHEAD_PORT_DELETE               0
#define CALLING_OVERHEAD_PORT_EXTERNAL_TO_INTERNAL 0
#define CALLING_OVERHEAD_PORT_INTERNAL_TO_EXTERNAL 0

#define CALLING_OVERHEAD_IO_INITIALIZE             0
#define CALLING_OVERHEAD_IO_OPEN                   0
#define CALLING_OVERHEAD_IO_CLOSE                  0
#define CALLING_OVERHEAD_IO_READ                   0
#define CALLING_OVERHEAD_IO_WRITE                  0
#define CALLING_OVERHEAD_IO_CONTROL                0
#define CALLING_OVERHEAD_FATAL_ERROR_OCCURRED      0
#define CALLING_OVERHEAD_RATE_MONOTONIC_CREATE     0
#define CALLING_OVERHEAD_RATE_MONOTONIC_IDENT      0
#define CALLING_OVERHEAD_RATE_MONOTONIC_DELETE     0
#define CALLING_OVERHEAD_RATE_MONOTONIC_CANCEL     0
#define CALLING_OVERHEAD_RATE_MONOTONIC_PERIOD     0
#define CALLING_OVERHEAD_MULTIPROCESSING_ANNOUNCE  0

#else
/*
 * 50 MHz processor, cache disabled.
 */
#define CALLING_OVERHEAD_INITIALIZE_EXECUTIVE      4
#define CALLING_OVERHEAD_SHUTDOWN_EXECUTIVE        4
#define CALLING_OVERHEAD_TASK_CREATE               7
#define CALLING_OVERHEAD_TASK_IDENT                6
#define CALLING_OVERHEAD_TASK_START                5
#define CALLING_OVERHEAD_TASK_RESTART              5
#define CALLING_OVERHEAD_TASK_DELETE               4
#define CALLING_OVERHEAD_TASK_SUSPEND              4
#define CALLING_OVERHEAD_TASK_RESUME               4
#define CALLING_OVERHEAD_TASK_SET_PRIORITY         5
#define CALLING_OVERHEAD_TASK_MODE                 5
#define CALLING_OVERHEAD_TASK_GET_NOTE             5
#define CALLING_OVERHEAD_TASK_SET_NOTE             5
#define CALLING_OVERHEAD_TASK_WAKE_WHEN           19
#define CALLING_OVERHEAD_TASK_WAKE_AFTER           4
#define CALLING_OVERHEAD_INTERRUPT_CATCH           5
#define CALLING_OVERHEAD_CLOCK_GET                20
#define CALLING_OVERHEAD_CLOCK_SET                19
#define CALLING_OVERHEAD_CLOCK_TICK                3

#define CALLING_OVERHEAD_TIMER_CREATE              5
#define CALLING_OVERHEAD_TIMER_IDENT               4
#define CALLING_OVERHEAD_TIMER_DELETE              5
#define CALLING_OVERHEAD_TIMER_FIRE_AFTER          6
#define CALLING_OVERHEAD_TIMER_FIRE_WHEN          21
#define CALLING_OVERHEAD_TIMER_RESET               4
#define CALLING_OVERHEAD_TIMER_CANCEL              4
#define CALLING_OVERHEAD_SEMAPHORE_CREATE          6
#define CALLING_OVERHEAD_SEMAPHORE_IDENT           4
#define CALLING_OVERHEAD_SEMAPHORE_DELETE          6
#define CALLING_OVERHEAD_SEMAPHORE_OBTAIN          5
#define CALLING_OVERHEAD_SEMAPHORE_RELEASE         4
#define CALLING_OVERHEAD_MESSAGE_QUEUE_CREATE      6
#define CALLING_OVERHEAD_MESSAGE_QUEUE_IDENT       6
#define CALLING_OVERHEAD_MESSAGE_QUEUE_DELETE      4
#define CALLING_OVERHEAD_MESSAGE_QUEUE_SEND        5
#define CALLING_OVERHEAD_MESSAGE_QUEUE_URGENT      5
#define CALLING_OVERHEAD_MESSAGE_QUEUE_BROADCAST   5
#define CALLING_OVERHEAD_MESSAGE_QUEUE_RECEIVE     6
#define CALLING_OVERHEAD_MESSAGE_QUEUE_FLUSH       5

#define CALLING_OVERHEAD_EVENT_SEND                5
#define CALLING_OVERHEAD_EVENT_RECEIVE             5
#define CALLING_OVERHEAD_SIGNAL_CATCH              4
#define CALLING_OVERHEAD_SIGNAL_SEND               5
#define CALLING_OVERHEAD_PARTITION_CREATE          7
#define CALLING_OVERHEAD_PARTITION_IDENT           6
#define CALLING_OVERHEAD_PARTITION_DELETE          4
#define CALLING_OVERHEAD_PARTITION_GET_BUFFER      5
#define CALLING_OVERHEAD_PARTITION_RETURN_BUFFER   5
#define CALLING_OVERHEAD_REGION_CREATE             7
#define CALLING_OVERHEAD_REGION_IDENT              5
#define CALLING_OVERHEAD_REGION_DELETE             4
#define CALLING_OVERHEAD_REGION_GET_SEGMENT        6
#define CALLING_OVERHEAD_REGION_RETURN_SEGMENT     5
#define CALLING_OVERHEAD_PORT_CREATE               6
#define CALLING_OVERHEAD_PORT_IDENT                5
#define CALLING_OVERHEAD_PORT_DELETE               4
#define CALLING_OVERHEAD_PORT_EXTERNAL_TO_INTERNAL 6
#define CALLING_OVERHEAD_PORT_INTERNAL_TO_EXTERNAL 6

#define CALLING_OVERHEAD_IO_INITIALIZE             6
#define CALLING_OVERHEAD_IO_OPEN                   6
#define CALLING_OVERHEAD_IO_CLOSE                  6
#define CALLING_OVERHEAD_IO_READ                   6
#define CALLING_OVERHEAD_IO_WRITE                  6
#define CALLING_OVERHEAD_IO_CONTROL                6
#define CALLING_OVERHEAD_FATAL_ERROR_OCCURRED      4
#define CALLING_OVERHEAD_RATE_MONOTONIC_CREATE     5
#define CALLING_OVERHEAD_RATE_MONOTONIC_IDENT      5
#define CALLING_OVERHEAD_RATE_MONOTONIC_DELETE     4
#define CALLING_OVERHEAD_RATE_MONOTONIC_CANCEL     4
#define CALLING_OVERHEAD_RATE_MONOTONIC_PERIOD     5
#define CALLING_OVERHEAD_MULTIPROCESSING_ANNOUNCE  3

#endif /* defined( INSTRUCTION_CACHE_ENABLE ) */

#else
#if defined( INSTRUCTION_CACHE_ENABLE )
/*
 * 40 MHz processor, cache enabled.
 */
#define CALLING_OVERHEAD_INITIALIZE_EXECUTIVE      0
#define CALLING_OVERHEAD_SHUTDOWN_EXECUTIVE        1
#define CALLING_OVERHEAD_TASK_CREATE               1
#define CALLING_OVERHEAD_TASK_IDENT                0
#define CALLING_OVERHEAD_TASK_START                0
#define CALLING_OVERHEAD_TASK_RESTART              0
#define CALLING_OVERHEAD_TASK_DELETE               0
#define CALLING_OVERHEAD_TASK_SUSPEND              0
#define CALLING_OVERHEAD_TASK_RESUME               0
#define CALLING_OVERHEAD_TASK_SET_PRIORITY         0
#define CALLING_OVERHEAD_TASK_MODE                 0
#define CALLING_OVERHEAD_TASK_GET_NOTE             0
#define CALLING_OVERHEAD_TASK_SET_NOTE             0
#define CALLING_OVERHEAD_TASK_WAKE_WHEN            1
#define CALLING_OVERHEAD_TASK_WAKE_AFTER           0
#define CALLING_OVERHEAD_INTERRUPT_CATCH           0
#define CALLING_OVERHEAD_CLOCK_GET                 1
#define CALLING_OVERHEAD_CLOCK_SET                 1
#define CALLING_OVERHEAD_CLOCK_TICK                0

#define CALLING_OVERHEAD_TIMER_CREATE              0
#define CALLING_OVERHEAD_TIMER_IDENT               0
#define CALLING_OVERHEAD_TIMER_DELETE              0
#define CALLING_OVERHEAD_TIMER_FIRE_AFTER          0
#define CALLING_OVERHEAD_TIMER_FIRE_WHEN           1
#define CALLING_OVERHEAD_TIMER_RESET               0
#define CALLING_OVERHEAD_TIMER_CANCEL              0
#define CALLING_OVERHEAD_SEMAPHORE_CREATE          0
#define CALLING_OVERHEAD_SEMAPHORE_IDENT           0
#define CALLING_OVERHEAD_SEMAPHORE_DELETE          0
#define CALLING_OVERHEAD_SEMAPHORE_OBTAIN          0
#define CALLING_OVERHEAD_SEMAPHORE_RELEASE         0
#define CALLING_OVERHEAD_MESSAGE_QUEUE_CREATE      0
#define CALLING_OVERHEAD_MESSAGE_QUEUE_IDENT       0
#define CALLING_OVERHEAD_MESSAGE_QUEUE_DELETE      0
#define CALLING_OVERHEAD_MESSAGE_QUEUE_SEND        0
#define CALLING_OVERHEAD_MESSAGE_QUEUE_URGENT      0
#define CALLING_OVERHEAD_MESSAGE_QUEUE_BROADCAST   0
#define CALLING_OVERHEAD_MESSAGE_QUEUE_RECEIVE     0
#define CALLING_OVERHEAD_MESSAGE_QUEUE_FLUSH       0

#define CALLING_OVERHEAD_EVENT_SEND                0
#define CALLING_OVERHEAD_EVENT_RECEIVE             0
#define CALLING_OVERHEAD_SIGNAL_CATCH              0
#define CALLING_OVERHEAD_SIGNAL_SEND               0
#define CALLING_OVERHEAD_PARTITION_CREATE          1
#define CALLING_OVERHEAD_PARTITION_IDENT           0
#define CALLING_OVERHEAD_PARTITION_DELETE          0
#define CALLING_OVERHEAD_PARTITION_GET_BUFFER      0
#define CALLING_OVERHEAD_PARTITION_RETURN_BUFFER   0
#define CALLING_OVERHEAD_REGION_CREATE             1
#define CALLING_OVERHEAD_REGION_IDENT              0
#define CALLING_OVERHEAD_REGION_DELETE             0
#define CALLING_OVERHEAD_REGION_GET_SEGMENT        0
#define CALLING_OVERHEAD_REGION_RETURN_SEGMENT     0
#define CALLING_OVERHEAD_PORT_CREATE               2
#define CALLING_OVERHEAD_PORT_IDENT                0
#define CALLING_OVERHEAD_PORT_DELETE               0
#define CALLING_OVERHEAD_PORT_EXTERNAL_TO_INTERNAL 0
#define CALLING_OVERHEAD_PORT_INTERNAL_TO_EXTERNAL 0

#define CALLING_OVERHEAD_IO_INITIALIZE             0
#define CALLING_OVERHEAD_IO_OPEN                   0
#define CALLING_OVERHEAD_IO_CLOSE                  0
#define CALLING_OVERHEAD_IO_READ                   0
#define CALLING_OVERHEAD_IO_WRITE                  0
#define CALLING_OVERHEAD_IO_CONTROL                0
#define CALLING_OVERHEAD_FATAL_ERROR_OCCURRED      0
#define CALLING_OVERHEAD_RATE_MONOTONIC_CREATE     0
#define CALLING_OVERHEAD_RATE_MONOTONIC_IDENT      0
#define CALLING_OVERHEAD_RATE_MONOTONIC_DELETE     0
#define CALLING_OVERHEAD_RATE_MONOTONIC_CANCEL     0
#define CALLING_OVERHEAD_RATE_MONOTONIC_PERIOD     0
#define CALLING_OVERHEAD_MULTIPROCESSING_ANNOUNCE  0

#else
/*
 * 40 MHz processor, cache disabled.
 */
#define CALLING_OVERHEAD_INITIALIZE_EXECUTIVE      4
#define CALLING_OVERHEAD_SHUTDOWN_EXECUTIVE        3
#define CALLING_OVERHEAD_TASK_CREATE               6
#define CALLING_OVERHEAD_TASK_IDENT                5
#define CALLING_OVERHEAD_TASK_START                5
#define CALLING_OVERHEAD_TASK_RESTART              4
#define CALLING_OVERHEAD_TASK_DELETE               4
#define CALLING_OVERHEAD_TASK_SUSPEND              4
#define CALLING_OVERHEAD_TASK_RESUME               4
#define CALLING_OVERHEAD_TASK_SET_PRIORITY         5
#define CALLING_OVERHEAD_TASK_MODE                 4
#define CALLING_OVERHEAD_TASK_GET_NOTE             5
#define CALLING_OVERHEAD_TASK_SET_NOTE             5
#define CALLING_OVERHEAD_TASK_WAKE_WHEN           17
#define CALLING_OVERHEAD_TASK_WAKE_AFTER           3
#define CALLING_OVERHEAD_INTERRUPT_CATCH           5
#define CALLING_OVERHEAD_CLOCK_GET                17
#define CALLING_OVERHEAD_CLOCK_SET                17
#define CALLING_OVERHEAD_CLOCK_TICK                3

#define CALLING_OVERHEAD_TIMER_CREATE              4
#define CALLING_OVERHEAD_TIMER_IDENT               4
#define CALLING_OVERHEAD_TIMER_DELETE              5
#define CALLING_OVERHEAD_TIMER_FIRE_AFTER          5
#define CALLING_OVERHEAD_TIMER_FIRE_WHEN          19
#define CALLING_OVERHEAD_TIMER_RESET               4
#define CALLING_OVERHEAD_TIMER_CANCEL              4
#define CALLING_OVERHEAD_SEMAPHORE_CREATE          6
#define CALLING_OVERHEAD_SEMAPHORE_IDENT           4
#define CALLING_OVERHEAD_SEMAPHORE_DELETE          5
#define CALLING_OVERHEAD_SEMAPHORE_OBTAIN          5
#define CALLING_OVERHEAD_SEMAPHORE_RELEASE         4
#define CALLING_OVERHEAD_MESSAGE_QUEUE_CREATE      5
#define CALLING_OVERHEAD_MESSAGE_QUEUE_IDENT       5
#define CALLING_OVERHEAD_MESSAGE_QUEUE_DELETE      4
#define CALLING_OVERHEAD_MESSAGE_QUEUE_SEND        4
#define CALLING_OVERHEAD_MESSAGE_QUEUE_URGENT      4
#define CALLING_OVERHEAD_MESSAGE_QUEUE_BROADCAST   5
#define CALLING_OVERHEAD_MESSAGE_QUEUE_RECEIVE     5
#define CALLING_OVERHEAD_MESSAGE_QUEUE_FLUSH       4

#define CALLING_OVERHEAD_EVENT_SEND                5
#define CALLING_OVERHEAD_EVENT_RECEIVE             5
#define CALLING_OVERHEAD_SIGNAL_CATCH              4
#define CALLING_OVERHEAD_SIGNAL_SEND               4
#define CALLING_OVERHEAD_PARTITION_CREATE          6
#define CALLING_OVERHEAD_PARTITION_IDENT           5
#define CALLING_OVERHEAD_PARTITION_DELETE          4
#define CALLING_OVERHEAD_PARTITION_GET_BUFFER      5
#define CALLING_OVERHEAD_PARTITION_RETURN_BUFFER   5
#define CALLING_OVERHEAD_REGION_CREATE             6
#define CALLING_OVERHEAD_REGION_IDENT              5
#define CALLING_OVERHEAD_REGION_DELETE             4
#define CALLING_OVERHEAD_REGION_GET_SEGMENT        6
#define CALLING_OVERHEAD_REGION_RETURN_SEGMENT     5
#define CALLING_OVERHEAD_PORT_CREATE               6
#define CALLING_OVERHEAD_PORT_IDENT                5
#define CALLING_OVERHEAD_PORT_DELETE               4
#define CALLING_OVERHEAD_PORT_EXTERNAL_TO_INTERNAL 5
#define CALLING_OVERHEAD_PORT_INTERNAL_TO_EXTERNAL 5

#define CALLING_OVERHEAD_IO_INITIALIZE             5
#define CALLING_OVERHEAD_IO_OPEN                   5
#define CALLING_OVERHEAD_IO_CLOSE                  5
#define CALLING_OVERHEAD_IO_READ                   5
#define CALLING_OVERHEAD_IO_WRITE                  5
#define CALLING_OVERHEAD_IO_CONTROL                5
#define CALLING_OVERHEAD_FATAL_ERROR_OCCURRED      3
#define CALLING_OVERHEAD_RATE_MONOTONIC_CREATE     4
#define CALLING_OVERHEAD_RATE_MONOTONIC_IDENT      5
#define CALLING_OVERHEAD_RATE_MONOTONIC_DELETE     4
#define CALLING_OVERHEAD_RATE_MONOTONIC_CANCEL     4
#define CALLING_OVERHEAD_RATE_MONOTONIC_PERIOD     4
#define CALLING_OVERHEAD_MULTIPROCESSING_ANNOUNCE  3

#endif /* defined( INSTRUCTION_CACHE_ENABLE ) */

#endif

#ifdef __cplusplus
}
#endif

#endif
