/*
 *  ERC32 Idle thread body
 *
 *  The idle thread is active when RTEMS has nothing to schedule.
 *  The ERC32 CPU can be put into power down mode by writing to
 *  power down register.
 *
 *  Developed as part of the port of RTEMS to the ERC32 implementation
 *  of the SPARC by On-Line Applications Research Corporation (OAR)
 *  under contract to the European Space Agency (ESA).
 *
 *  COPYRIGHT (c) 1995. European Space Agency.
 *
 *  This terms of the RTEMS license apply to this file.
 *
 */

#include <bsp.h>

/* IDLE BODY: ERC32 power-down function */

void _BSP_Thread_Idle_body( void )
{
  while (1) {
    ERC32_MEC.Power_Down = 0;   /* value is irrelevant */
  }
}
