/*
 *  LEON2 Idle thread body
 *
 *  The idle thread is active when RTEMS has nothing to schedule.
 *  The LEON2 CPU can be put into power down mode by writing the
 *  power down register.
 *
 *  COPYRIGHT (c) 1989-1998.
 *  On-Line Applications Research Corporation (OAR).
 *
 *  The license and distribution terms for this file may be
 *  found in the file LICENSE in this distribution or at
 *  http://www.rtems.com/license/LICENSE.
 *
 *  Ported to LEON implementation of the SPARC by On-Line Applications
 *  Research Corporation (OAR) under contract to the European Space 
 *  Agency (ESA).
 *
 *  LEON modifications of respective RTEMS file: COPYRIGHT (c) 1995. 
 *  European Space Agency.
 *
 */

#include <bsp.h>

/* IDLE BODY: LEON2 specific power-down function */

void _BSP_Thread_Idle_body( void )
{
  while (1) {
    LEON_REG.Power_Down = LEON_REG.Power_Down;   /* make sure on load follows store to power-down reg */
  }
}
