/*
 *  AMBA Plag & Play Bus Driver
 *
 *  This driver hook performs bus scanning.
 *
 *  COPYRIGHT (c) 2004.
 *  Gaisler Research
 *
 *  The license and distribution terms for this file may be
 *  found in the file LICENSE in this distribution or at
 *  http://www.rtems.com/license/LICENSE.
 *
 *  $Id: amba.c,v 1.6 2007/09/06 15:22:42 joel Exp $
 */

#include <bsp.h>

/* Structure containing address to devices found on the Amba Plug&Play bus */
amba_confarea_type amba_conf;

/* Pointers to Interrupt Controller configuration registers */
volatile LEON3_IrqCtrl_Regs_Map *LEON3_IrqCtrl_Regs;

/* GRLIB extended IRQ controller register */
extern void bsp_leon3_ext_irq_register(int irq);

int LEON3_Cpu_Index = 0;

/*
 *  bsp_leon3_predriver_hook
 *
 *  BSP predriver hook.  Called just before drivers are initialized.
 *  Used to scan system bus. Probes for AHB masters, AHB slaves and 
 *  APB slaves. Addresses to configuration areas of the AHB masters,
 *  AHB slaves, APB slaves and APB master are storeds in 
 *  amba_ahb_masters, amba_ahb_slaves and amba.
 */

unsigned int getasr17();

asm(" .text  \n"
    "getasr17:   \n"
    "retl \n"
    "mov %asr17, %o0\n"
);


extern rtems_configuration_table Configuration;

void bsp_leon3_predriver_hook(void)
{
  int i;
  unsigned int tmp;
  amba_apb_device dev;

	/* next field must be NULL, we clear all structure */
	memset(&amba_conf, 0, sizeof(amba_conf));

	/* Scan the AMBA Plug&Play info at the default LEON3 area */
	amba_scan(&amba_conf,LEON3_IO_AREA,NULL);

  /* Find LEON3 Interrupt controler */
  i = amba_find_apbslv(&amba_conf,VENDOR_GAISLER,GAISLER_IRQMP,&dev);
  if ( i > 0 ){
    /* Found APB IRQ_MP Interrupt Controller */
    LEON3_IrqCtrl_Regs = (volatile LEON3_IrqCtrl_Regs_Map *) dev.start;
    if (Configuration.User_multiprocessing_table != NULL) {	
	    tmp = getasr17();
     	LEON3_Cpu_Index = (tmp >> 28) & 3;
    }
    if ( (LEON3_IrqCtrl_Regs->mpstat >> 16) & 0xf ) {
      /* Extended IRQ controller available */
      bsp_leon3_ext_irq_register((LEON3_IrqCtrl_Regs->mpstat >> 16) & 0xf);
    }
  }
  
  /* find GP Timer */
  i = amba_find_apbslv(&amba_conf,VENDOR_GAISLER,GAISLER_GPTIMER,&dev);
  if ( i > 0 ){
    LEON3_Timer_Regs = (volatile LEON3_Timer_Regs_Map *) dev.start;
  }

}
