#
# Please send bugfixes or comments to
# 	http://www.rtems.org/bugzilla
#

%define _prefix			/opt/rtems-4.8
%define _infodir		%{_prefix}/info
%define _mandir			%{_prefix}/man

%ifos cygwin cygwin32 mingw mingw32
%define _exeext .exe
%else
%define _exeext %{nil}
%endif


%define gcc_pkgvers 3.4.4
%define gcc_version 3.4.4
%define gcc_rpmvers %{expand:%(echo "3.4.4" | tr - _ )}


Name:         	rtems-4.8-i686-pc-cygwin-gcc
Summary:      	i686-pc-cygwin gcc

Group:	      	Development/Tools
Version:        %{gcc_rpmvers}
Release:      	0.20080312.1%{?dist}
License:      	GPL
URL:		http://gcc.gnu.org
BuildRoot:	%{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)

%define _use_internal_dependency_generator 0

%if "%{gcc_version}" >= "4.2.0"
BuildRequires:	flex bison
%endif

BuildRequires:	texinfo >= 4.2
BuildRequires:	rtems-4.8-i686-pc-cygwin-binutils
BuildRequires:	rtems-4.8-i686-pc-cygwin-sys-root

Requires:	rtems-4.8-i686-pc-cygwin-binutils
Requires:	rtems-4.8-i686-pc-cygwin-sys-root
Requires:	rtems-4.8-i686-pc-cygwin-w32api


%if "%{gcc_version}" >= "3.4"
%define gcclib %{_libdir}/gcc
%define gccexec %{_libexecdir}/gcc
%else
%define gcclib %{_libdir}/gcc-lib
%define gccexec %{_libdir}/gcc-lib
%endif

Source0: 	ftp://ftp.gnu.org/gnu/gcc/gcc-%{gcc_version}/gcc-core-%{gcc_pkgvers}.tar.bz2
%{?_without_sources:NoSource:	0}

Source1: 	ftp://ftp.gnu.org/gnu/gcc/gcc-%{gcc_version}/gcc-g++-%{gcc_pkgvers}.tar.bz2
%{?_without_sources:NoSource:	1}


# Cygwin patch from
# ftp://cygwin.com/pub/cygwin/release/gcc/gcc-core/gcc-core-3.4.4-3-src.tar.bz2
Source60: gcc-3.4.4-3.patch


%description
Cross gcc for i686-pc-cygwin.

%prep
%setup -c -T -n %{name}-%{version}

%setup -q -T -D -n %{name}-%{version} -a0
%{?PATCH0:%patch0 -p0}

%setup -q -T -D -n %{name}-%{version} -a1
%{?PATCH1:%patch1 -p0}






# cygwin patches can't be directly applied through rpm
cd gcc-%{gcc_pkgvers}
patch -p1 -t < %{SOURCE60} || true
cd ..

  # Fix timestamps
  cd gcc-%{gcc_pkgvers}
  contrib/gcc_update --touch
  cd ..
%build
  mkdir -p build

  cd build

  languages="c"
  languages="$languages,c++"
  export PATH="%{_bindir}:${PATH}"

  CC="%{__cc} ${RPM_OPT_FLAGS}" \
  ../gcc-%{gcc_pkgvers}/configure \
    --prefix=%{_prefix} \
    --bindir=%{_bindir} \
    --exec_prefix=%{_exec_prefix} \
    --includedir=%{_includedir} \
    --libdir=%{_libdir} \
    --libexecdir=%{_libexecdir} \
    --mandir=%{_mandir} \
    --infodir=%{_infodir} \
    --datadir=%{_datadir} \
    --build=%_build --host=%_host \
    --target=i686-pc-cygwin \
    --disable-libstdcxx-pch \
    --with-gnu-as --with-gnu-ld --verbose \
    --with-newlib \
    --with-system-zlib \
    --disable-nls --without-included-gettext \
    --disable-win32-registry \
    --enable-version-specific-runtime-libs \
    --enable-threads \
    --with-sysroot=%{_exec_prefix}/i686-pc-cygwin/sys-root \
    --enable-languages="$languages" $optargs

%if "%_host" != "%_build"
  # Bug in gcc-3.2.1:
  # Somehow, gcc doesn't get syslimits.h right for Cdn-Xs
  mkdir -p gcc/include
  cp ../gcc-%{gcc_pkgvers}/gcc/gsyslimits.h gcc/include/syslimits.h
%endif

  make %{?_smp_mflags} all
  cd ..

%install
  export PATH="%{_bindir}:${PATH}"
  rm -rf $RPM_BUILD_ROOT

  cd build

  make DESTDIR=$RPM_BUILD_ROOT install
  cd ..


%if "%{gcc_version}" <= "4.1.2"
# Misplaced header file
  if test -f $RPM_BUILD_ROOT%{_includedir}/mf-runtime.h; then
    mv $RPM_BUILD_ROOT%{_includedir}/mf-runtime.h \
      $RPM_BUILD_ROOT%{gcclib}/i686-pc-cygwin/%{gcc_version}/include/
  fi
%endif

  # host library
  rm -f  ${RPM_BUILD_ROOT}%{_libdir}/libiberty.a

  # We use the version from binutils
  rm -f $RPM_BUILD_ROOT%{_bindir}/i686-pc-cygwin-c++filt%{_exeext}


# Conflict with a native GCC's infos
  rm -rf $RPM_BUILD_ROOT%{_infodir}

# Conflict with a native GCC's man pages
  rm -rf $RPM_BUILD_ROOT%{_mandir}/man7


%if "%{gcc_version}" >= "3.4"
  # Bug in gcc-3.4.0pre
  rm -f $RPM_BUILD_ROOT%{_bindir}/i686-pc-cygwin-i686-pc-cygwin-gcjh%{_exeext}
%endif

%if "%{gcc_version}" >= "3.3"
  # Bug in gcc-3.3.x/gcc-3.4.x: Despite we don't need fixincludes, it installs
  # the fixinclude-install-tools
  rm -rf ${RPM_BUILD_ROOT}%{gcclib}/i686-pc-cygwin/%{gcc_version}/install-tools
  rm -rf ${RPM_BUILD_ROOT}%{gccexec}/i686-pc-cygwin/%{gcc_version}/install-tools
%endif

  # Collect multilib subdirectories
  f=`build/gcc/xgcc -Bbuild/gcc/ --print-multi-lib | sed -e 's,;.*$,,'`


  rm -f dirs ;
  echo "%defattr(-,root,root,-)" >> dirs
  echo "%dir %{_prefix}" >> dirs
  echo "%dir %{_libdir}" >> dirs
%if "%{gcc_version}" >= "3.4"
  echo "%dir %{_libexecdir}" >> dirs
%endif
  echo "%dir %{gcclib}" >> dirs
  echo "%dir %{gcclib}/i686-pc-cygwin" >> dirs

  TGTDIR="%{gcclib}/i686-pc-cygwin/%{gcc_version}"
  for i in $f; do
    case $i in
    \.) echo "%dir ${TGTDIR}" >> dirs
      ;;
    *)  echo "%dir ${TGTDIR}/$i" >> dirs
      ;;
    esac
  done

  # Collect files to go into different packages
  cp dirs build/files.gcc
  cp dirs build/files.g77
  cp dirs build/files.gfortran
  cp dirs build/files.objc
  cp dirs build/files.gcj
  cp dirs build/files.g++

  TGTDIR="%{gcclib}/i686-pc-cygwin/%{gcc_version}"
  f=`find ${RPM_BUILD_ROOT}${TGTDIR} ! -type d -print | sed -e "s,^$RPM_BUILD_ROOT,,g"`;
  for i in $f; do
    case $i in
    *lib*.la) rm ${RPM_BUILD_ROOT}/$i ;; # ignore: gcc produces bogus libtool libs
    *f771) ;;
    *f951) ;;
    *cc1) ;;
    *cc1obj) ;;
    *cc1plus) ;; # ignore: explicitly put into rpm elsewhere
    *collect2) ;;
    *libobjc*) echo "$i" >> build/files.objc ;;
    *include/objc*) ;;
    *include/g++*);;
    *include/c++*);;
    *adainclude*);;
    *adalib*);;
    *gnat1);;
    *jc1) ;;
    *jvgenmain) ;;
    */libgfortran*.*) echo "$i" >> build/files.gfortran ;;
    */libstdc++.*) echo "$i" >> build/files.g++ ;;
    */libsupc++.*) echo "$i" >> build/files.g++ ;;
    *) echo "$i" >> build/files.gcc ;;
    esac
  done

  TGTDIR="%{_exec_prefix}/i686-pc-cygwin/lib"
  f=`find ${RPM_BUILD_ROOT}${TGTDIR} ! -type d -print | sed -e "s,^$RPM_BUILD_ROOT,,g"`;
  for i in $f; do
    case $i in
    *lib*.la) rm ${RPM_BUILD_ROOT}/$i;; # ignore - gcc produces bogus libtool libs
    *libiberty.a) rm ${RPM_BUILD_ROOT}/$i ;; # ignore - GPL'ed
# all other files belong to newlib
    *) echo "$i" >> build/files.newlib ;; 
    esac
  done
# Extract %%__os_install_post into os_install_post~
cat << \EOF > os_install_post~
%__os_install_post
EOF

# Generate customized brp-*scripts
cat os_install_post~ | while read a x y; do
case $a in
# Prevent brp-strip* from trying to handle foreign binaries
*/brp-strip*)
  b=$(basename $a)
  sed -e 's,find $RPM_BUILD_ROOT,find $RPM_BUILD_ROOT%_bindir $RPM_BUILD_ROOT%_libexecdir,' $a > $b
  chmod a+x $b
  ;;
# Fix up brp-compress to handle %%_prefix != /usr
*/brp-compress*)
  b=$(basename $a)
  sed -e 's,\./usr/,.%{_prefix}/,g' < $a > $b
  chmod a+x $b
  ;;
esac
done

sed -e 's,^[ ]*/usr/lib/rpm.*/brp-strip,./brp-strip,' \
  -e 's,^[ ]*/usr/lib/rpm.*/brp-compress,./brp-compress,' \
< os_install_post~ > os_install_post 
%define __os_install_post . ./os_install_post


cat << EOF > %{_builddir}/%{name}-%{gcc_rpmvers}/find-provides
#!/bin/sh
grep -E -v '^${RPM_BUILD_ROOT}%{_exec_prefix}/i686-pc-cygwin/(lib|include|sys-root)' \
  | grep -v '^${RPM_BUILD_ROOT}%{gcclib}/i686-pc-cygwin/' | %__find_provides
EOF
chmod +x %{_builddir}/%{name}-%{gcc_rpmvers}/find-provides
%define __find_provides %{_builddir}/%{name}-%{gcc_rpmvers}/find-provides

cat << EOF > %{_builddir}/%{name}-%{gcc_rpmvers}/find-requires
#!/bin/sh
grep -E -v '^${RPM_BUILD_ROOT}%{_exec_prefix}/i686-pc-cygwin/(lib|include|sys-root)' \
  | grep -v '^${RPM_BUILD_ROOT}%{gcclib}/i686-pc-cygwin/' | %__find_requires
EOF
chmod +x %{_builddir}/%{name}-%{gcc_rpmvers}/find-requires
%define __find_requires %{_builddir}/%{name}-%{gcc_rpmvers}/find-requires

%clean
  rm -rf $RPM_BUILD_ROOT

# ==============================================================
# rtems-4.8-i686-pc-cygwin-gcc
# ==============================================================
# %package -n rtems-4.8-i686-pc-cygwin-gcc
# Summary:        GNU cc compiler for i686-pc-cygwin
# Group:          Development/Tools
# Version:        %{gcc_rpmvers}
# Requires:       rtems-4.8-i686-pc-cygwin-binutils
# Requires:       rtems-4.8-i686-pc-cygwin-newlib = %{newlib_version}-%{release}
# License:	GPL

# %if %build_infos
# Requires:      rtems-4.8-gcc-common
# %endif

%description -n rtems-4.8-i686-pc-cygwin-gcc
GNU cc compiler for i686-pc-cygwin.

%files -n rtems-4.8-i686-pc-cygwin-gcc -f build/files.gcc
%defattr(-,root,root)
%dir %{_mandir}
%dir %{_mandir}/man1
%{_mandir}/man1/i686-pc-cygwin-gcc.1*
%if "%{gcc_version}" >= "3.4"
%{_mandir}/man1/i686-pc-cygwin-cpp.1*
%{_mandir}/man1/i686-pc-cygwin-gcov.1*
%endif

%dir %{_bindir}
%{_bindir}/i686-pc-cygwin-cpp%{_exeext}
%{_bindir}/i686-pc-cygwin-gcc%{_exeext}
%if "%{gcc_version}" >= "3.3"
%{_bindir}/i686-pc-cygwin-gcc-%{gcc_version}%{_exeext}
%endif
%{_bindir}/i686-pc-cygwin-gcov%{_exeext}
%{_bindir}/i686-pc-cygwin-gccbug

%dir %{gcclib}/i686-pc-cygwin/%{gcc_version}/include
%if "%{gcc_version}" > "4.0.3"
%if "i686-pc-cygwin" != "bfin-rtems4.8"
%if "i686-pc-cygwin" != "avr-rtems4.8"
%dir %{gcclib}/i686-pc-cygwin/%{gcc_version}/include/ssp
%endif
%endif
%endif

%dir %{gccexec}
%dir %{gccexec}/i686-pc-cygwin
%dir %{gccexec}/i686-pc-cygwin/%{gcc_version}
%{gccexec}/i686-pc-cygwin/%{gcc_version}/cc1%{_exeext}
%{gccexec}/i686-pc-cygwin/%{gcc_version}/collect2%{_exeext}

# ==============================================================
# rtems-4.8-i686-pc-cygwin-gcc-c++
# ==============================================================
%package -n rtems-4.8-i686-pc-cygwin-gcc-c++
Summary:	GCC c++ compiler for i686-pc-cygwin
Group:		Development/Tools
Version:        %{gcc_rpmvers}
License:	GPL

Provides:	rtems-4.8-i686-pc-cygwin-c++ = %{gcc_rpmvers}-%{release}
Obsoletes:	rtems-4.8-i686-pc-cygwin-c++ < %{gcc_rpmvers}-%{release}

Requires:       rtems-4.8-i686-pc-cygwin-gcc = %{gcc_rpmvers}-%{release}

%description -n rtems-4.8-i686-pc-cygwin-gcc-c++
GCC c++ compiler for i686-pc-cygwin.

%files -n rtems-4.8-i686-pc-cygwin-gcc-c++ -f build/files.g++
%defattr(-,root,root)
%{_mandir}/man1/i686-pc-cygwin-g++.1*

%{_bindir}/i686-pc-cygwin-c++%{_exeext}
%{_bindir}/i686-pc-cygwin-g++%{_exeext}

%dir %{gccexec}
%dir %{gccexec}/i686-pc-cygwin
%dir %{gccexec}/i686-pc-cygwin/%{gcc_version}
%{gccexec}/i686-pc-cygwin/%{gcc_version}/cc1plus%{_exeext}

%dir %{gcclib}/i686-pc-cygwin/%{gcc_version}/include
%if "%{gcc_version}" >= "3.2"
%{gcclib}/i686-pc-cygwin/%{gcc_version}/include/c++
%else
%{gcclib}/i686-pc-cygwin/%{gcc_version}/include/g++
%endif



