#
# Please send bugfixes or comments to
# 	http://www.rtems.org/bugzilla
#

%define _prefix			/opt/rtems-4.8
%define _infodir		%{_prefix}/info
%define _mandir			%{_prefix}/man

%ifos cygwin cygwin32 mingw mingw32
%define _exeext .exe
%else
%define _exeext %{nil}
%endif

%define zlib_version 1.2.3-2
%define zlib_rpmvers %{expand:%(echo 1.2.3-2 | tr - _)} 

Name:         rtems-4.8-i686-pc-cygwin-zlib
Release:      0.20070724.1%{?dist}
License:      GPL
Group:        Development/Tools

BuildRoot:	%{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)
BuildArch:	noarch

Version:      	%zlib_rpmvers
Summary:      	Cygwin zlib Libraries

Source0:	ftp://cygwin.com/pub/cygwin/release/zlib/zlib-%{zlib_version}.tar.bz2
%{?_without_sources:NoSource:	0}

%description
Cygwin zlib libraries.

%prep
%setup -c -q

%build
  rm -rf i686-pc-cygwin

  # Setup sys-root (Usable for gcc >= 3.4)
  mkdir -p i686-pc-cygwin/sys-root
  ( cd i686-pc-cygwin/sys-root ; %{__tar} xvjf %{SOURCE0})

%install
  rm -rf $RPM_BUILD_ROOT
  mkdir -p $RPM_BUILD_ROOT%{_prefix}
  cp -a i686-pc-cygwin $RPM_BUILD_ROOT%{_prefix}


# Extract %%__os_install_post into os_install_post~
cat << \EOF > os_install_post~
%__os_install_post
EOF

# Generate customized brp-*scripts
cat os_install_post~ | while read a x y; do
case $a in
# Prevent brp-strip* from trying to handle foreign binaries
*/brp-strip*)
  b=$(basename $a)
  sed -e 's,find $RPM_BUILD_ROOT,find $RPM_BUILD_ROOT%_bindir $RPM_BUILD_ROOT%_libexecdir,' $a > $b
  chmod a+x $b
  ;;
# Fix up brp-compress to handle %%_prefix != /usr
*/brp-compress*)
  b=$(basename $a)
  sed -e 's,\./usr/,.%{_prefix}/,g' < $a > $b
  chmod a+x $b
  ;;
esac
done

sed -e 's,^[ ]*/usr/lib/rpm.*/brp-strip,./brp-strip,' \
  -e 's,^[ ]*/usr/lib/rpm.*/brp-compress,./brp-compress,' \
< os_install_post~ > os_install_post 
%define __os_install_post . ./os_install_post


cat << EOF > %{_builddir}/%{name}-%{zlib_rpmvers}/find-provides
#!/bin/sh
grep -E -v '^${RPM_BUILD_ROOT}%{_exec_prefix}/i686-pc-cygwin/(lib|include|sys-root)' \
  | grep -v '^${RPM_BUILD_ROOT}%{gcclib}/i686-pc-cygwin/' | %__find_provides
EOF
chmod +x %{_builddir}/%{name}-%{zlib_rpmvers}/find-provides
%define __find_provides %{_builddir}/%{name}-%{zlib_rpmvers}/find-provides

cat << EOF > %{_builddir}/%{name}-%{zlib_rpmvers}/find-requires
#!/bin/sh
grep -E -v '^${RPM_BUILD_ROOT}%{_exec_prefix}/i686-pc-cygwin/(lib|include|sys-root)' \
  | grep -v '^${RPM_BUILD_ROOT}%{gcclib}/i686-pc-cygwin/' | %__find_requires
EOF
chmod +x %{_builddir}/%{name}-%{zlib_rpmvers}/find-requires
%define __find_requires %{_builddir}/%{name}-%{zlib_rpmvers}/find-requires

%clean
  rm -rf $RPM_BUILD_ROOT

%files
%defattr(-,root,root,-)
%dir %{_prefix}/i686-pc-cygwin
%{_prefix}/i686-pc-cygwin/sys-root


