/*
 *  3.3.2 Send a Signal to a Process, P1003.1b-1993, p. 68
 *
 *  COPYRIGHT (c) 1989-1999.
 *  On-Line Applications Research Corporation (OAR).
 *
 *  The license and distribution terms for this file may be
 *  found in the file LICENSE in this distribution or at
 *  http://www.rtems.com/license/LICENSE.
 *
 *  $Id: kill.c,v 1.5 2004/04/15 13:24:47 ralf Exp $
 */

#if HAVE_CONFIG_H
#include "config.h"
#endif

#include <pthread.h>
#include <errno.h>

#include <rtems/system.h>
#include <rtems/posix/pthread.h>
#include <rtems/posix/psignal.h>

int kill(
  pid_t pid,
  int   sig
)
{
  return killinfo( pid, sig, NULL );
}

/*
 *  _kill_r
 *
 *  This is the Newlib dependent reentrant version of kill().
 */

#if defined(RTEMS_NEWLIB)

#include <reent.h>

int _kill_r(
  struct _reent *ptr,
  pid_t          pid,
  int            sig
)
{
  return kill( pid, sig );
}
#endif
