/*
 *  Object Handler
 *
 *
 *  COPYRIGHT (c) 1989-1999.
 *  On-Line Applications Research Corporation (OAR).
 *
 *  The license and distribution terms for this file may be
 *  found in the file LICENSE in this distribution or at
 *  http://www.rtems.com/license/LICENSE.
 *
 *  $Id: objectcomparenameraw.c,v 1.8 2005/01/27 05:57:05 ralf Exp $
 */

#if HAVE_CONFIG_H
#include "config.h"
#endif

#include <rtems/system.h>
#include <rtems/score/address.h>
#include <rtems/score/chain.h>
#include <rtems/score/object.h>
#if defined(RTEMS_MULTIPROCESSING)
#include <rtems/score/objectmp.h>
#endif
#include <rtems/score/thread.h>
#include <rtems/score/wkspace.h>
#include <rtems/score/sysstate.h>
#include <rtems/score/isr.h>

/*PAGE
 *
 *  _Objects_Compare_name_raw
 *
 *  XXX
 */

boolean _Objects_Compare_name_raw(
  void       *name_1,
  void       *name_2,
  uint16_t    length
)
{
#if 0
  uint32_t   *name_1_p = (uint32_t   *) name_1;
  uint32_t   *name_2_p = (uint32_t   *) name_2;
  uint32_t    tmp_length = length / OBJECTS_NAME_ALIGNMENT;
#endif

  if ( name_1 == name_2 )
    return TRUE;
  return FALSE;

#if 0
  while ( tmp_length-- )
    if ( *name_1_p++ != *name_2_p++ )
      return FALSE;

  return TRUE;
#endif
}
