/*
 * A collection of hacks, glue, and patches to
 * provide a `UNIX-like' environment to ttcp.
 *
 * Some of the code here may migrate to the libc
 * support routines some day.  Some of the more sleazy
 * hacks should never make it outside this file!
 * 
 * This program may be distributed and used for any purpose.
 * I ask only that you:
 *      1. Leave this author information intact.
 *      2. Document any changes you make.
 *
 * W. Eric Norum
 * Saskatchewan Accelerator Laboratory
 * University of Saskatchewan
 * Saskatoon, Saskatchewan, CANADA
 * eric@skatter.usask.ca
 *
 *  rtems_ttcp.c,v 1.7 1999/04/01 18:19:08 joel Exp
 */


/*
 * RTEMS configuration/initialization
 * 
 * This program may be distributed and used for any purpose.
 * I ask only that you:
 *	1. Leave this author information intact.
 *	2. Document any changes you make.
 *
 * W. Eric Norum
 * Saskatchewan Accelerator Laboratory
 * University of Saskatchewan
 * Saskatoon, Saskatchewan, CANADA
 * eric@skatter.usask.ca
 *
 *  init.c,v 1.8 2003/01/28 22:21:21 joel Exp
 */

#include <bsp.h>

#define CONFIGURE_TEST_NEEDS_CONSOLE_DRIVER
#define CONFIGURE_TEST_NEEDS_CLOCK_DRIVER
#define CONFIGURE_RTEMS_INIT_TASKS_TABLE
#define CONFIGURE_LIBIO_MAXIMUM_FILE_DESCRIPTORS 20
#define CONFIGURE_USE_IMFS_AS_BASE_FILESYSTEM

#define CONFIGURE_EXECUTIVE_RAM_SIZE	(1024*1024)
#define CONFIGURE_MAXIMUM_SEMAPHORES	20
#define CONFIGURE_MAXIMUM_TASKS		20

#define CONFIGURE_MICROSECONDS_PER_TICK	10000

#define CONFIGURE_INIT_TASK_STACK_SIZE	(64*1024)
#define CONFIGURE_INIT_TASK_PRIORITY	100
#define CONFIGURE_INIT_TASK_INITIAL_MODES (RTEMS_PREEMPT | \
                                           RTEMS_NO_TIMESLICE | \
                                           RTEMS_NO_ASR | \
                                           RTEMS_INTERRUPT_LEVEL(0))

#define CONFIGURE_INIT
rtems_task Init (rtems_task_argument argument);

#include <confdefs.h>

#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <rtems.h>
#include <rtems/rtems_bsdnet.h>
#include <rtems/error.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <sys/time.h>

#include "networkconfig.h"
/*
 * RTEMS Startup Task
 */

rtems_task
Init (rtems_task_argument ignored)
{
        rtems_bsdnet_initialize_network ();
	test_network ();
	exit (0);
}
/*
 * Glue between UNIX-style ttcp code and RTEMS
 */
int rtems_ttcp_main (int argc, char **argv);

static int
select(int nfds, fd_set *readfds, fd_set *writefds, fd_set *exceptfds, struct timeval *timeout)
{
	rtems_panic ("select()");
}

static void
(*signal(int sig, void (*func)()))()
{
	return 0;;
}

#define _SYS_RESOURCE_H_
#define	RUSAGE_SELF	0		/* calling process */
#define	RUSAGE_CHILDREN	-1		/* terminated child processes */
struct rusage {
	struct timeval ru_utime;	/* user time used */
	struct timeval ru_stime;	/* system time used */
	int ru_maxrss;		/* maximum resident set size */
	int ru_ixrss;		/* currently 0 */
	int ru_idrss;		/* integral resident set size */
	int ru_isrss;		/* currently 0 */
	int ru_minflt;		/* page faults not requiring physical I/O */
	int ru_majflt;		/* page faults requiring physical I/O */
	int ru_nswap;		/* swaps */
	int ru_inblock;		/* block input operations */
	int ru_oublock;		/* block output operations */
	int ru_msgsnd;		/* messages sent */
	int ru_msgrcv;		/* messages received */
	int ru_nsignals;	/* signals received */
	int ru_nvcsw;		/* voluntary context switches */
	int ru_nivcsw;		/* involuntary context switches */
};
int
getrusage(int ignored, struct rusage *ru)
{
	rtems_clock_time_value now;
	static struct rusage nullUsage;

	rtems_clock_get (RTEMS_CLOCK_GET_TIME_VALUE, &now);
	*ru = nullUsage;
	ru->ru_stime.tv_sec  = now.seconds;
	ru->ru_stime.tv_usec = now.microseconds;
	ru->ru_utime.tv_sec  = 0;
	ru->ru_utime.tv_usec = 0;
	return 0;
}

static void
rtems_ttcp_exit (int code)
{
	rtems_task_wake_after( RTEMS_MILLISECONDS_TO_TICKS(1000) );
	rtems_bsdnet_show_mbuf_stats ();
	rtems_bsdnet_show_if_stats ();
	rtems_bsdnet_show_ip_stats ();
	rtems_bsdnet_show_tcp_stats ();
	exit (code);
}

/*
 * Task to run UNIX ttcp command
 */
char *__progname;
static void
ttcpTask (rtems_task_argument arg)
{
	int code;
	int argc;
	char arg0[10];
	char *argv[20];
	char linebuf[200];

	for (;;) {
		char *cp;

		/*
		 * Set up first argument
		 */
		argc = 1;
		strcpy (arg0, "ttcp");
		argv[0] = __progname = arg0;

#if (defined (WRITE_TEST_ONLY))
		strcpy (linebuf, "-s -t crux");
#elif (defined (READ_TEST_ONLY))
		strcpy (linebuf, "9999");
#else
		/*
		 * Read a line
		 */
		printf (">>> %s ", argv[0]);
		fflush (stdout);
		fgets (linebuf, sizeof linebuf, stdin);
#endif

		/*
		 * Break line into arguments
		 */
		cp = linebuf;
		for (;;) {
			while (isspace (*cp))
				*cp++ = '\0';
			if (*cp == '\0')
				break;
			if (argc >= ((sizeof argv / sizeof argv[0]) - 1)) {
				printf ("Too many arguments.\n");
				argc = 0;
				break;
			}
			argv[argc++] = cp;
			while (!isspace (*cp)) {
				if (*cp == '\0')
					break;
				cp++;
			}
		}
		if (argc > 1) {
			argv[argc] = NULL;
			break;
		}
		printf ("You must give some arguments!\n");
		printf ("At the very least, you must provide\n");
		printf ("         -r\n");
		printf ("or\n");
		printf ("         -t destination.internet.address\n");
	}
	code = rtems_ttcp_main (argc, argv);
	rtems_ttcp_exit (code);
}

/*
 * Test network throughput
 */
test_network (void)
{
	rtems_id tid;
	rtems_status_code sc;
	rtems_time_of_day now;
	rtems_task_priority my_priority;

	/*
	 * Set up time-of-day clock
	 */
	now.year = 1997;
	now.month = 1;
	now.day = 1;
	now.hour = 0;
	now.minute = 0;
	now.second = 0;
	now.ticks = 0;
	sc = rtems_clock_set (&now);
	if (sc != RTEMS_SUCCESSFUL) {
		printf ("Can't set date/time; %s\n", rtems_status_text (sc));
		return;
	}

	/*
	 * Spawn test task
	 */
	rtems_task_set_priority (RTEMS_SELF, RTEMS_CURRENT_PRIORITY, &my_priority);
	sc = rtems_task_create (rtems_build_name ('T', 'T', 'C', 'P'),
			my_priority,
			64*1024,
			RTEMS_PREEMPT|RTEMS_NO_TIMESLICE|RTEMS_NO_ASR|RTEMS_INTERRUPT_LEVEL(0),
			RTEMS_NO_FLOATING_POINT|RTEMS_LOCAL,
			&tid);
	if (sc != RTEMS_SUCCESSFUL) {
		printf ("Can't create task; %s\n", rtems_status_text (sc));
		return;
	}
	sc = rtems_task_start (tid, ttcpTask, 0);
	if (sc != RTEMS_SUCCESSFUL) {
		printf ("Can't start task; %s\n", rtems_status_text (sc));
		return;
	}
	rtems_task_suspend (RTEMS_SELF);
}

#define main		rtems_ttcp_main
#define exit(code)	close(sockfd),rtems_ttcp_exit(code)


#define BSD43


/* Copyright (c) 2000 Miller Puckette.
* For information on usage and redistribution, and for a DISCLAIMER OF ALL
* WARRANTIES, see the file, "LICENSE.txt," in the Pd distribution.  */

/* the "pdreceive" command.  This is a standalone program that receives messages
from Pd via the netsend/netreceive ("FUDI") protocol, and copies them to
standard output. */

#include <stdio.h>
#include <signal.h>
#include <ctype.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netinet/tcp.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <sys/time.h>		/* struct timeval */

#if defined(SYSV)
#include <sys/times.h>
#include <sys/param.h>
struct rusage {
    struct timeval ru_utime, ru_stime;
};
#define RUSAGE_SELF 0
#else
#include <sys/resource.h>
#endif
#define SOCKET_ERROR -1

typedef struct _fdpoll
{
    int fdp_fd;
    char *fdp_inbuf;
    int fdp_inhead;
    int fdp_intail;
    int fdp_udp;
} t_fdpoll;

static int nfdpoll;
static t_fdpoll *fdpoll;
static int maxfd;
static int sockfd;
static int protocol;

static void sockerror(char *s);
static void x_closesocket(int fd);
static void dopoll(void);
#define BUFSIZE 4096

int main(int argc, char **argv)
{
    int portno;
    struct sockaddr_in server;
    int nretry = 10;
    if (argc < 2 || sscanf(argv[1], "%d", &portno) < 1 || portno <= 0)
        goto usage;
    if (argc >= 3)
    {
        if (!strcmp(argv[2], "tcp"))
            protocol = SOCK_STREAM;
        else if (!strcmp(argv[2], "udp"))
            protocol = SOCK_DGRAM;
        else goto usage;
    }
    else protocol = SOCK_STREAM;
    sockfd = socket(AF_INET, protocol, 0);
    if (sockfd < 0)
    {
        sockerror("socket()");
        exit(1);
    }
    maxfd = sockfd + 1;
    server.sin_family = AF_INET;
    server.sin_addr.s_addr = INADDR_ANY;

        /* assign client port number */
    server.sin_port = htons((unsigned short)portno);

        /* name the socket */
    if (bind(sockfd, (struct sockaddr *)&server, sizeof(server)) < 0)
    {
        sockerror("bind");
        x_closesocket(sockfd);
        return (0);
    }
    if (protocol == SOCK_STREAM)
    {
        if (listen(sockfd, 5) < 0)
        {
            sockerror("listen");
            x_closesocket(sockfd);
            exit(1);
        }
    }
        /* now loop forever selecting on sockets */
    while (1)
        dopoll();

usage:
    fprintf(stderr, "usage: pdreceive <portnumber> [udp|tcp]\n");
    fprintf(stderr, "(default is tcp)\n");
    exit(1);
}

static void addport(int fd)
{
    int nfd = nfdpoll;
    t_fdpoll *fp;
    fdpoll = (t_fdpoll *)realloc(fdpoll,
        (nfdpoll+1) * sizeof(t_fdpoll));
    fp = fdpoll + nfdpoll;
    fp->fdp_fd = fd;
    nfdpoll++;
    if (fd >= maxfd) maxfd = fd + 1;
    fp->fdp_inhead = fp->fdp_intail = 0;
    if (!(fp->fdp_inbuf = malloc(BUFSIZE)))
    {
        fprintf(stderr, "out of memory");
        exit(1);
    }
    printf("number_connected %d;\n", nfdpoll);
}

static void rmport(t_fdpoll *x)
{
    int nfd = nfdpoll;
    int i, size = nfdpoll * sizeof(t_fdpoll);
    t_fdpoll *fp;
    for (i = nfdpoll, fp = fdpoll; i--; fp++)
    {
        if (fp == x)
        {
            x_closesocket(fp->fdp_fd);
            free(fp->fdp_inbuf);
            while (i--)
            {
                fp[0] = fp[1];
                fp++;
            }
            fdpoll = (t_fdpoll *)realloc(fdpoll,
                (nfdpoll-1) * sizeof(t_fdpoll));
            nfdpoll--;
            printf("number_connected %d;\n", nfdpoll);
            return;
        }
    }
    fprintf(stderr, "warning: item removed from poll list but not found");
}

static void doconnect(void)
{
    int fd = accept(sockfd, 0, 0);
    if (fd < 0)
        perror("accept");
    else addport(fd);
}

static void udpread(void)
{
    char buf[BUFSIZE];
    int ret = recv(sockfd, buf, BUFSIZE, 0);
    if (ret < 0)
    {
        sockerror("recv (udp)");
        x_closesocket(sockfd);
        exit(1);
    }
    else if (ret > 0)
    {
        if (write(1, buf, ret) < ret)
        {
            perror("write");
            exit(1);
        }
    }
}

static int tcpmakeoutput(t_fdpoll *x)
{
    char messbuf[BUFSIZE+1], *bp = messbuf;
    int indx;
    int inhead = x->fdp_inhead;
    int intail = x->fdp_intail;
    char *inbuf = x->fdp_inbuf;
    if (intail == inhead)
        return (0);
    for (indx = intail; indx != inhead; indx = (indx+1)&(BUFSIZE-1))
    {
            /* search for a semicolon.   */
        char c = *bp++ = inbuf[indx];
        if (c == ';')
        {
            intail = (indx+1)&(BUFSIZE-1);
            if (inbuf[intail] == '\n')
                intail = (intail+1)&(BUFSIZE-1);
            *bp++ = '\n';
            write(1, messbuf, bp - messbuf);
            x->fdp_inhead = inhead;
            x->fdp_intail = intail;
            return (1);
        }
    }
    return (0);
}

static void tcpread(t_fdpoll *x)
{
    int readto =
        (x->fdp_inhead >= x->fdp_intail ? BUFSIZE : x->fdp_intail-1);
    int ret;

        /* the input buffer might be full.  If so, drop the whole thing */
    if (readto == x->fdp_inhead)
    {
        fprintf(stderr, "pd: dropped message from gui\n");
        x->fdp_inhead = x->fdp_intail = 0;
        readto = BUFSIZE;
    }
    else
    {
        ret = recv(x->fdp_fd, x->fdp_inbuf + x->fdp_inhead,
            readto - x->fdp_inhead, 0);
        if (ret < 0)
        {
            sockerror("recv (tcp)");
            rmport(x);
        }
        else if (ret == 0)
             rmport(x);
        else
        {
            x->fdp_inhead += ret;
            if (x->fdp_inhead >= BUFSIZE)
                x->fdp_inhead = 0;
            while (tcpmakeoutput(x))
                ;
        }
    }
}

static void dopoll(void)
{
    int i;
    t_fdpoll *fp;
    fd_set readset, writeset, exceptset;
    FD_ZERO(&writeset);
    FD_ZERO(&readset);
    FD_ZERO(&exceptset);

    FD_SET(sockfd, &readset);
    if (protocol == SOCK_STREAM)
    {
        for (fp = fdpoll, i = nfdpoll; i--; fp++)
            FD_SET(fp->fdp_fd, &readset);
    }
    if (select(maxfd+1, &readset, &writeset, &exceptset, 0) < 0)
    {
        perror("select");
        exit(1);
    }
    if (protocol == SOCK_STREAM)
    {
        for (i = 0; i < nfdpoll; i++)
            if (FD_ISSET(fdpoll[i].fdp_fd, &readset))
                tcpread(&fdpoll[i]);
        if (FD_ISSET(sockfd, &readset))
            doconnect();
    }
    else
    {
        if (FD_ISSET(sockfd, &readset))
            udpread();
    }
}


static void sockerror(char *s)
{
    int err = errno;
    fprintf(stderr, "%s: %s (%d)\n", s, strerror(err), err);
}

static void x_closesocket(int fd)
{
    close(fd);
}
