# ================================================================================================
# Copyright (C) 2024, Frontgrade Gaisler AB - All rights reserved
#
# Author: Adria Oliveira - Frontgrade Gaisler AB
# Filename: gr-start.tcl
#
# DISCLAIMER:
# THIS CODE, AND ALL ACCOMPANYING FILES, DATA AND MATERIALS,
# ARE DISTRIBUTED "AS IS" AND WITH NO WARRANTIES OF ANY KIND,
# WHETHER EXPRESS OR IMPLIED. Good data processing procedure dictates
# that any program be thoroughly tested with non-critical data
# before relying on it. The user must assume the entire risk of
# using the program. THIS DISCLAIMER OF WARRANTY CONSTITUTES AN
# ESSENTIAL PART OF THE AGREEMENT. 
# ================================================================================================

# ================================================================================================
# INSTRUCTIONS
#  
# Usage: <GRMON4> -uart <UART> -c gr-start.tcl
# Or run the ../run_ctrl_ei.sh
#
# Ctrl+C finishes the test loop
#
# This script is configured by default to use the GR-CPCI-KU060 board featuring a GR716B (SETUP II).
# Note that if the setup with GR-CPCI-KU060 board + GR716B board + TC board (SETUP I) is used, the
# fpgaei_ctrl.tcl must be loaded to use the CRAM error injection.
# 
# ================================================================================================

# ================================================================================================
# DEBUG TIP
#
# In case the script crashes, type the commands
# grmon> flush
# grmon> puts $errorInfo
# ================================================================================================

# clear old variables
catch {unset script_path}

# global variables
global script_path

# scripts
set script_list [list \
        gr-log.tcl \
        grscrub-ctrl.tcl \
        grscrub-ei.tcl \
    ]
    #fpgaei_ctrl.tcl \ ; # used for FPGA_EI FW
    #grscrub-ei.tcl \  ; # used for EI with GRSCRUB itself

# load the scripts
proc load_script {script_name {same_folder 1}} {
    global script_path
    
    foreach v $script_name {
        set load_script $script_path
        if {$same_folder == 1} {
            append load_script "/" $v
        } else {
            set load_script $v
        }
        source $load_script
    }
}

namespace eval gr {
    # debug flags
    set ECHO   1
    set DRYRUN 0
    set RUN_ID 0

    set EI_EN 0 ; # set it to 1 only if FPGA_EI FW is being used

    # System status
    # 0 - not configured
    # 1 - configured
    set SYS_STAT 0

    # high-level procedures
    proc cmd_gr {args} {
        gr_sys {*}$args
    }

    proc get_ei_stat {} {
        variable EI_EN

        return $EI_EN
    }

    proc get_echo {} {
        variable ECHO

        return $ECHO
    }

    proc get_dryrun {} {
        variable DRYRUN

        return $DRYRUN
    }

    proc set_stat { {stat} } {
        variable SYS_STAT

        set SYS_STAT $stat
    }

    proc get_stat {} {
        variable SYS_STAT

        return $SYS_STAT
    }

    proc set_runid { {id} } {
        variable RUN_ID

        set RUN_ID $id
        puts [format "\ntest_control - SUBRUN_ID set to $RUN_ID"]
    }

    proc get_runid {} {
        variable RUN_ID

        return $RUN_ID
    }

    proc init_config { {id} } {
        set_runid $id
        set_stat 1
        puts [format "\n\ntest_control- System configured!!!"]
        # cmd_gr menu
    }

    namespace ensemble create -map {
        {set}    {cmd_gr}
        {echo}   {get_echo}
        {dryrun} {get_dryrun}
        {bn}     {get_bn}
        {bndef}  {get_bn_def}
        {runid}  {set_runid}
        {grunid} {get_runid}
        {init}   {init_config}
        {status} {get_stat}
        {eistat} {get_ei_stat}
    }
}

# ================================================================================================
# main

set script_path [file dirname [file normalize [info script]]]
puts $script_path
puts [info script]

load_script $script_list

puts [format "\n\ngr-start - ATTENTION: DO INIT CONFIGURATION"]
puts [format "\nTYPE: gr init <subrun_id>"]



