# GAISLER_LICENSE
# ---------------------------------------------------------------------------
# File:        grscrub_crc32_main.py
# Author:      Adria Barros de Oliveira - Frontgrade Gaisler
# 
# Description: 
#   Python3 script for computing the CRC32 codes for GRSCRUB usage.
#   The CRC32 is computed as per GRSCRUB and each CRC32 code is related 
#   to the respective CRAM frame.
#   This script may be used in case the Golden CRC mode of GRSCRUB cannot
#   be employed due to setup restrictions. 
#
# To execute:
#   $python3 grscrub_crc32_main.py -f <files_format> <bit_file> <mask_file>
#
#   <files_format>: txt - the input files are in text with hexa words  
#                         (format 0x00000000), a 32-bit word per line.
#                   bin/bit - the input files are binary (.bin, .bit, .msk)
#   <bit_file>: bitstream file 
#               if txt format: one word per line (format 0x00000000).
#               if binary format: original bitstream file without modification.
#   <mask_file>: mask file
#               if txt format: one word per line (format 0x00000000).
#               if binary format: original mask file without modification.
#   Note that the bistream and mask file must be synchronized and with  
#   header (as provided by the systhesis tool).
#
# Output:
#   Select the output file path and name in the configurations below.
#   The output file is in a txt format with the CRC32 codes per line.
#   The codes are related to the CRAM frames sequentially.
#
# DISCLAIMER:
# THIS CODE, AND ALL ACCOMPANYING FILES, DATA AND MATERIALS,
# ARE DISTRIBUTED "AS IS" AND WITH NO WARRANTIES OF ANY KIND,
# WHETHER EXPRESS OR IMPLIED. Good data processing procedure dictates
# that any program be thoroughly tested with non-critical data
# before relying on it. The user must assume the entire risk of
# using the program. THIS DISCLAIMER OF WARRANTY CONSTITUTES AN
# ESSENTIAL PART OF THE AGREEMENT. 
# ---------------------------------------------------------------------------

#############################################################################
# imports
#############################################################################
import sys
from grscrub_crc32_class import grscrub_crc32


#############################################################################
# configurations
#############################################################################

debug_level  = 1 # 0 - log disabled; otherwise - log enabled (2 - verbose)
frame_length = 123 # number of words per CRAM frame
output_name  = "./grscrub_crc32_codes"


#############################################################################
# main
#############################################################################
def main(argv):

    if len(argv) != 4:
        print ("Usage: python3 grscrub_crc32_main.py -f <files_format> <bit_file> <mask_file>")
        sys.exit()
    
    file_format = argv[1]
    bit_file    = argv[2]
    mask_file   = argv[3]

    gr = grscrub_crc32(debug_level)
    gr.setOutputName(output_name)
    gr.setInputFormat(file_format)
    gr.setBitFile(bit_file)
    gr.setMaskFile(mask_file)
    gr.setFrameLen(frame_length)
    gr.processCRC32()

    


#############################################################################
# entry point
#############################################################################

if __name__ == '__main__':
    main(sys.argv[1:])