############################
## Script to load required data to the SPI Flash memory
## Notes: 
## Updated paths and file names as needed
## Update the enabled data load
## Update the memory addresses as needed 
## In case of loading individual files and using erase: 
### Note that SPIM is configured to 128KB-sector and the erase is per full sector 
### So first erase the sectors to be used, then load. BUT DO NOT ERASE THE ENTIRE MEMORY!
##
## DISCLAIMER:
## THIS CODE, AND ALL ACCOMPANYING FILES, DATA AND MATERIALS,
## ARE DISTRIBUTED "AS IS" AND WITH NO WARRANTIES OF ANY KIND,
## WHETHER EXPRESS OR IMPLIED. Good data processing procedure dictates
## that any program be thoroughly tested with non-critical data
## before relying on it. The user must assume the entire risk of
## using the program. THIS DISCLAIMER OF WARRANTY CONSTITUTES AN
## ESSENTIAL PART OF THE AGREEMENT. 
############################

# Path to the scripts top folder
set DATA_PATH ./../

# Enable data to be loaded
set BIT_EN 0
set MSK_EN 0
set MAP_EN 0
set CRC_EN 0

# Set SPI Flash memory addresses (SPIM0)
set LOADAD_BIT 0x10D00006
set LOADAD_MSK 0x12500006
set LOADAD_MAP 0x13D00000
set LOADAD_CRC 0x13F00000

# Fix SPIM 4-byte addr and scaler
wmem 0xfff00100 0x131003
wmem 0xfff00104 0x0000000c

spim flash detect

# Load BIT data
if {$BIT_EN} {
    spim flash load -erase $DATA_PATH/DUT/dut_bitstream.bit $LOADAD_BIT
    verify -max 10 $DATA_PATH/DUT/dut_bitstream.bit $LOADAD_BIT
}

# Load MSK data
if {$MSK_EN} {
    spim flash load -erase $DATA_PATH/DUT/dut_bitstream.msk $LOADAD_MSK
    verify -max 10 $DATA_PATH/DUT/dut_bitstream.msk $LOADAD_MSK
}

# Load MAP data
if {$MAP_EN} {
    spim flash load -erase $DATA_PATH/ku060_map/ku060_map_dump0x13D.srec $LOADAD_MAP
    verify -max 10 $DATA_PATH/ku060_map/ku060_map_dump0x13D.srec $LOADAD_MAP
}

# Load CRC data
if {$CRC_EN} {
    spim flash load -erase $DATA_PATH/DUT/grscrub_crc32_codes.bin $LOADAD_CRC
    verify -max 10 $DATA_PATH/DUT/grscrub_crc32_codes.bin $LOADAD_CRC
}
