/*****************************************************************************/
/*   This file is a part of the GRLIB VHDL IP LIBRARY */
/*   Copyright (C) 2004 GAISLER RESEARCH */

/*   This program is free software; you can redistribute it and/or modify */
/*   it under the terms of the GNU General Public License as published by */
/*   the Free Software Foundation; either version 2 of the License, or */
/*   (at your option) any later version. */

/*   See the file COPYING for the full details of the license. */
/*****************************************************************************/

struct dmachanregs 
{
   volatile int ctrl;
   volatile int rxmaxlen;
   volatile int txdesc;
   volatile int rxdesc;
   volatile int addr;
   volatile int unused[3];
};

struct spwregs 
{
   volatile int ctrl;
   volatile int status;
   volatile int nodeaddr;
   volatile int clkdiv;
   volatile int destkey;
   volatile int timereg;
   volatile int timer;
   volatile int unused;
   struct dmachanregs dma[4];
};

struct txdescriptor 
{
   volatile int ctrl;
   volatile int haddr;
   volatile int dlen;
   volatile int daddr;
};

struct rxstatus 
{
   int truncated;
   int dcrcerr;
   int hcrcerr;
   int eep;
};

struct rxdescriptor 
{
   volatile int ctrl;
   volatile int daddr;
};

struct dmachanvar
{
  int    nospill;
  int    rxmaxlen;
  int    rxpnt;
  int    rxchkpnt;
  int    txpnt;
  int    txchkpnt;
  int    addr;
  int    mask;
  struct txdescriptor *txd;
  struct rxdescriptor *rxd;  
};

struct spwvars
{
   struct spwregs *regs;
   int    rmap;
   int    rxunaligned;
   int    rmapcrc;
   int    timetxen;
   int    timerxen;
   int    ver;
   int    khz;
   int    dmachan;
   int    clkdiv;
   int    clkdivs;
   int    timer;
   int    dc;
   int    nodeaddr;
   int    mask;
   int    destkey;
   int    port;
   struct dmachanvar dma[4];
};

static unsigned char RMAP_CRCTable[256] = {
    0x00, 0x91, 0xe3, 0x72, 0x07, 0x96, 0xe4, 0x75,
    0x0e, 0x9f, 0xed, 0x7c, 0x09, 0x98, 0xea, 0x7b,
    0x1c, 0x8d, 0xff, 0x6e, 0x1b, 0x8a, 0xf8, 0x69,
    0x12, 0x83, 0xf1, 0x60, 0x15, 0x84, 0xf6, 0x67,
    0x38, 0xa9, 0xdb, 0x4a, 0x3f, 0xae, 0xdc, 0x4d,
    0x36, 0xa7, 0xd5, 0x44, 0x31, 0xa0, 0xd2, 0x43,
    0x24, 0xb5, 0xc7, 0x56, 0x23, 0xb2, 0xc0, 0x51,
    0x2a, 0xbb, 0xc9, 0x58, 0x2d, 0xbc, 0xce, 0x5f,
    0x70, 0xe1, 0x93, 0x02, 0x77, 0xe6, 0x94, 0x05,
    0x7e, 0xef, 0x9d, 0x0c, 0x79, 0xe8, 0x9a, 0x0b,
    0x6c, 0xfd, 0x8f, 0x1e, 0x6b, 0xfa, 0x88, 0x19,
    0x62, 0xf3, 0x81, 0x10, 0x65, 0xf4, 0x86, 0x17,
    0x48, 0xd9, 0xab, 0x3a, 0x4f, 0xde, 0xac, 0x3d,
    0x46, 0xd7, 0xa5, 0x34, 0x41, 0xd0, 0xa2, 0x33,
    0x54, 0xc5, 0xb7, 0x26, 0x53, 0xc2, 0xb0, 0x21,
    0x5a, 0xcb, 0xb9, 0x28, 0x5d, 0xcc, 0xbe, 0x2f,
    0xe0, 0x71, 0x03, 0x92, 0xe7, 0x76, 0x04, 0x95,
    0xee, 0x7f, 0x0d, 0x9c, 0xe9, 0x78, 0x0a, 0x9b,
    0xfc, 0x6d, 0x1f, 0x8e, 0xfb, 0x6a, 0x18, 0x89,
    0xf2, 0x63, 0x11, 0x80, 0xf5, 0x64, 0x16, 0x87,
    0xd8, 0x49, 0x3b, 0xaa, 0xdf, 0x4e, 0x3c, 0xad,
    0xd6, 0x47, 0x35, 0xa4, 0xd1, 0x40, 0x32, 0xa3,
    0xc4, 0x55, 0x27, 0xb6, 0xc3, 0x52, 0x20, 0xb1,
    0xca, 0x5b, 0x29, 0xb8, 0xcd, 0x5c, 0x2e, 0xbf,
    0x90, 0x01, 0x73, 0xe2, 0x97, 0x06, 0x74, 0xe5,
    0x9e, 0x0f, 0x7d, 0xec, 0x99, 0x08, 0x7a, 0xeb,
    0x8c, 0x1d, 0x6f, 0xfe, 0x8b, 0x1a, 0x68, 0xf9,
    0x82, 0x13, 0x61, 0xf0, 0x85, 0x14, 0x66, 0xf7,
    0xa8, 0x39, 0x4b, 0xda, 0xaf, 0x3e, 0x4c, 0xdd,
    0xa6, 0x37, 0x45, 0xd4, 0xa1, 0x30, 0x42, 0xd3,
    0xb4, 0x25, 0x57, 0xc6, 0xb3, 0x22, 0x50, 0xc1,
    0xba, 0x2b, 0x59, 0xc8, 0xbd, 0x2c, 0x5e, 0xcf,
};

unsigned char rmap_crc_calc(unsigned char *data, unsigned int len);

int spw_init(struct spwvars *spw);

int spw_linkStatus(struct spwvars *spw);

int wait_running(struct spwvars *spw);

/*sets node specific parameters in the spwvars structure */
int spw_setparam(int nodeaddr, int clkdiv, int destkey,
                 int timetxen, int timerxen, int spwadr, 
                 int khz, struct spwvars *spw, int port, int clkdivs);

int spw_setparam_dma(int dmachan, int addr, int mask, int nospill, int rxmaxlen, struct spwvars *spw);

/*set new transmit descriptor pointer*/
int set_txdesc(int dmachan, int pnt, struct spwvars *spw);

/*set new receive descriptor pointer*/
int set_rxdesc(int dmachan, int pnt, struct spwvars *spw);

/*disable spacewire link*/
void spw_disable(struct spwvars *spw);

/*enable spacewire link*/
void spw_enable(struct spwvars *spw);

/*start spacewire link*/
void spw_start(struct spwvars *spw);

/*stop spacewire link*/
void spw_stop(struct spwvars *spw);

/*set clock divisor value. returns 1 if the clockdiv parameter is illegal,
0 when operation completes successfully*/
int spw_setclockdiv(struct spwvars *spw);

/*set node address, returns 1 if the nodeaddr parameter is illegal,
0 when operation completes successfully*/
int spw_set_nodeadr(struct spwvars *spw);

int spw_set_chanadr(int dmachan, struct spwvars *spw);


/*set maximum receive packet length, returns 1 if the nodeaddr parameter is illegal,
0 when operation completes successfully*/
int spw_set_rxmaxlength(int dmachan, struct spwvars *spw);

/*Transmits hsize bytes from hbuf and dsize bytes from dbuf.returns 0 on success. 
/*1 if there are no free buffers. 2 if there was an illegal parameter value.*/
int spw_tx(int dmachan, int hcrc, int dcrc, int skipcrcsize, int hsize, char *hbuf, int dsize, char *dbuf, struct spwvars *spw);

/*Receives one packet to buf. This function only initializes a descriptor, spw_checkrx should
be used to poll when a packet has arrived*/
int spw_rx(int dmachan, char *buf, struct spwvars *spw);

/*Polls receiver descriptor. Returns 0 if no packet has been received,
1 if packet has been received. Then size contains the number of 
bytes received. rxs contains som status bits such as crc errors, 
eep termination etc*/
int spw_checkrx(int dmachan, int *size, struct rxstatus *rxs, struct spwvars *spw);

/*Polls transmitter descriptor, returns 0 if packet has not been transmitted,
  1 if packet was correctly transmitted and 2 if an error occured*/
int spw_checktx(int dmachan, struct spwvars *spw);

/*Send time-code*/
void send_time(struct spwvars *spw);

int send_time_exp(int ctrl, int time, struct spwvars *spw);

/*Check if time-code has been received*/
int check_time(struct spwvars *spw);

/* Get the current time-code count value */
int get_time(struct spwvars *spw);

/* Get the current time-code ctrl value */
int get_time_ctrl(struct spwvars *spw);

/*Reset GRSPW*/
void spw_reset(struct spwvars *spw);

/*Enable hardware RMAP*/
void spw_rmapen(struct spwvars *spw);

/*Disable hardware RMAP*/
void spw_rmapdis(struct spwvars *spw);

int spw_setdestkey(struct spwvars *spw);

void spw_setsepaddr(int dmachan, struct spwvars *spw);

void spw_disablesepaddr(int dmachan, struct spwvars *spw);

void spw_enablerx(int dmachan, struct spwvars *spw);

void spw_disablerx(int dmachan, struct spwvars *spw);

void spw_disable_promiscuous(struct spwvars *spw);

void spw_enable_promiscuous(struct spwvars *spw);

/*-- RMAP --*/

enum rmap_type {writecmd, readcmd, rmwcmd, writerep, readrep, rmwrep};
enum sel_type {no = 0, yes = 1};

struct rmap_pkt 
{
   enum rmap_type type;
   enum sel_type verify;
   enum sel_type ack;
   enum sel_type incr;
   int destaddr;
   int destkey;
   int srcaddr;
   int tid;
   int addr;
   int len;
   int status;
   int dstspalen;
   char *dstspa;
   int srcspalen;
   char *srcspa;
};

int build_rmap_hdr(struct rmap_pkt *pkt, char *hdr, int *size, int autocrc);
