#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "spwapi.h"

/* loop count to wait for RMAP response (at least 50)*/
#define SPWRX_WAIT -1

/* grspw parameters */
#include "spwboot_master.h"
#include "spwboot_target.h"

/* data to send by RMAP */
#if (GR740 == 1)
#include "spwboot_rmap_GR740.h"
#else
#include "spwboot_rmap.h"
#endif

#include "spwboot_rmap_img.h"

#ifndef SPWBOOT_M_APBADDR
#define SPWBOOT_M_APBADDR 0x80000c00
#endif

/* do not touch reset and disconnect timeouts */
#define AHBFREQ 0

#ifndef SPWBOOT_M_CLKDIV
#define SPWBOOT_M_CLKDIV 9
#endif

#ifndef SPWBOOT_M_CLKDIVS
#define SPWBOOT_M_CLKDIVS 9
#endif

/* target default destination key */
#ifndef SPWBOOT_T_DESTKEY 
#define SPWBOOT_T_DESTKEY 0
#endif

/* default node address */
#ifndef SPWBOOT_T_NADDR
#define SPWBOOT_T_NADDR 0xfe
#endif

const char * lsStr[] = {"Error-reset", "Error-wait", "Ready", "Started", "Connecting", "Run"};

inline void flush_dcache() {
    asm volatile(" sta %g0, [%g0] 0x11");
}

/* buf: data buffer with CRC
   len: data length (without CRC)
*/
int rmap_send_data (int addr, char* buf, int len, struct spwvars *spw) {
    static unsigned int transID = 5;
    unsigned int rTransID;
    int  k, nLoop;
    int  tmp, ret=0;
    int  rxSize;
    unsigned char rxHdr[32]; memset (rxHdr, 0, 32);
    unsigned char txHdr[64];
    struct rmap_pkt cmd;
    int hdrSize;
    struct rxstatus rxs;
    memset(&rxs, 0, sizeof(struct rxstatus)  );

#if (GR740 == 1)
    /* GR740: first AMBA port at address 9 */
    char dstspa = 9;
    /* GR740: first SpW port at address 1 */
    char srcspa = GR740_SPWPORT;
#endif

    cmd.incr     = yes;
    cmd.type     = writecmd;
    cmd.verify   = no;
    cmd.ack      = yes;
    cmd.destaddr = SPWBOOT_T_NADDR;
    cmd.destkey  = SPWBOOT_T_DESTKEY;
    cmd.srcaddr  = 0x14;
    cmd.tid      = transID;
    cmd.addr     = addr;
    cmd.len      = len;
    cmd.status   = 0;
#if (GR740 == 1)
    cmd.dstspalen = 1;
    cmd.dstspa = &dstspa;
    cmd.srcspalen = 1;
    cmd.srcspa = &srcspa;
#else
    cmd.dstspalen = 0;
    cmd.dstspa = (char *)NULL;
    cmd.srcspalen = 0;
    cmd.srcspa = (char *)NULL;
#endif

    if (build_rmap_hdr(&cmd, txHdr, &hdrSize, 1)) {
	printf("RMAP cmd build failed\n");
	return 2;
    }

    nLoop = SPWRX_WAIT;
    while ((tmp = spw_rx(0, rxHdr, spw)) && nLoop) {
	nLoop--;
	for (k = 0; k < 64; k++) {}
    }
    if (tmp) {
	printf ("spw_rx failed: %d\n", tmp);
	ret = 3;
    }
    /* send buffer with CRC */
    if (tmp = spw_tx(0, 0, 0, 0, hdrSize, txHdr, len+1, buf, spw)) {
	printf("Transmission failed (spw_tx %d)\n", tmp);
	return 4;
    }

    while (!(tmp = spw_checktx(0, spw))) {
	for (k = 0; k < 64; k++) {}
    }
    if (tmp != 1) {
	printf("Error in transmit (spw_checktx %d)\n", tmp);
	return 5;
    }

    nLoop = SPWRX_WAIT;
    while ((tmp = spw_checkrx(0, &rxSize, &rxs, spw)) && nLoop) {
	nLoop--;
	for (k = 0; k < 64; k++) {}
    }
    if (tmp) {
	printf ("spw_checkrx failed: %d\n", tmp);
	ret = 6;
    }

    flush_dcache(); /* cache snooping may not be available */

    if (rxs.truncated) {
	printf("Received packet truncated\n");
	ret = 7;
    }
    if(rxs.eep) {
	printf("Received packet terminated with eep\n");
	ret = 8;
    }
    if(rxs.hcrcerr) {
	printf("Received packet header crc error detected\n");
	ret = 9;
    }
    if(rxs.dcrcerr) {
	printf("Received packet data crc error detected\n");
	ret = 10;
    }

    rTransID = (rxHdr[5] << 8) | rxHdr[6];
    if (transID != rTransID) {
	printf("transID %04x!=%04x rTransID)\n",  transID, rTransID);
	ret = 11;
    }
    if(rxHdr[3] != 0)
	printf("Reply status: %d\n", rxHdr[3]);
    transID++;
    return ret;
}

int rmap_send_word_crc(int addr, int val, struct spwvars *spw) {
    unsigned char sbuf[5];
    *((int*) sbuf) = val;
    sbuf[4] = rmap_crc_calc(sbuf, 4);
    return rmap_send_data(addr, sbuf, 4, spw);
}

int main(void) 
{
    int  tmp, i;
    struct spwvars spw;

    /*Initalize link*/
    if (spw_setparam(0x14, SPWBOOT_M_CLKDIV, 0x0, 1, 1, SPWBOOT_M_APBADDR, AHBFREQ, &spw, 0, SPWBOOT_M_CLKDIVS) ) {
	printf("Illegal parameters to spacewire\n");
	exit(1);
    }

    /* spw_setparam_dma(int dmachan, int addr, int mask, int nospill, int rxmaxlen, struct spwvars *spw)  */
    spw_setparam_dma(0, 0x14, 0x0, 1, 0x100000, &spw);

    /*reset link*/
    spw_reset(&spw);

    tmp = spw_linkStatus(&spw);
    printf("rst SPW link: %s (%d)\n", lsStr[tmp], tmp);
    tmp = spw_linkStatus(&spw);
    printf("rst SPW link: %s (%d)\n", lsStr[tmp], tmp);

    /*initialize link*/
    tmp = spw_init(&spw);
    if (tmp) {
	printf("Link initialization failed: %d\n", tmp);
    }

    /** push rmap data **/

    /* stage 1 */
    printf("******stage 1*******\n");
    for (i=0; i<SPWBOOT_NCFGWORDS_S1; i++) {
    	tmp = rmap_send_word_crc(spwboot_config_addr_s1[i], spwboot_config_data_s1[i], &spw);
    }

    printf("\n******stage 2*******\n");
    for (i=0; i<SPWBOOT_NSECTIONS; i++) {
	if (spwboot_sectiondata[i])
	    tmp = rmap_send_data(spwboot_sectionaddr[i], (char*) spwboot_sectiondata[i], spwboot_sectionsize[i], &spw);
	else {
	    printf ("clearing %x\n", spwboot_sectionsize[i]);
	    char* zeroes = (char*) calloc(spwboot_sectionsize[i]+1, 1);
	    tmp = rmap_send_data(spwboot_sectionaddr[i], zeroes, spwboot_sectionsize[i], &spw);
	    free (zeroes);
	}
    }

    /* stage 3 */
    printf("\n******stage 3*******\n");
    for (i=0; i<SPWBOOT_NCFGWORDS_S3; i++) {
    	tmp = rmap_send_word_crc(spwboot_config_addr_s3[i], spwboot_config_data_s3[i], &spw);
    }
 
}
