proc spwboot_master_gen {spwLink} {
    set filename "spwboot_master.h"
    set fp [open $filename "w"]
    set lSys [silent info sys]

    if {[expr [set ::[set spwLink]::status] >> 21] != 5} {
	puts "Warning: $spwLink link down. The interfaces must be in run state to produce correct results. Check clock divisor registers and the physical connection.\n"
    }
    set apbAddr [format "0x%X" [set ::[set spwLink]::pnp::apb::start]]

    puts $fp "/* generated header file */"
    puts $fp "#define SPWBOOT_M_APBADDR $apbAddr"
    puts $fp "#define SPWBOOT_M_CLKDIV [format "0x%X" [expr [set ::[set spwLink]::clkdiv] & 0xFF]]"
    puts $fp "#define SPWBOOT_M_CLKDIVS [format "0x%X" [expr [expr [set ::[set spwLink]::clkdiv] >> 8] & 0xFF]]"

    close $fp
}

# top entry to generate target-relevant header files
proc spwboot_target_gen {spwLink} {
    set filename "spwboot_target.h"
    set fp [open $filename "w"]
    set lSys [silent info sys]

    if {[expr [set ::[set spwLink]::status] >> 21] != 5} {
	puts "Warning: $spwLink link down. The interfaces must be in run state to produce correct results. Check clock divisor registers and the physical connection.\n"
    }
    set apbAddr [format "0x%X" [set ::[set spwLink]::pnp::apb::start]]

    set targetNaddrReg [format "0x%X" [expr $apbAddr + 0x8]]
    set targetKeyReg [format "0x%X" [expr $apbAddr + 0x10]]
    set targetNaddr [format "0x%X" [silent mem $targetNaddrReg 4]]
    set targetKey [format "0x%X" [silent mem $targetKeyReg 4]]

    puts $fp "/* generated header file */"
    puts $fp "#define SPWBOOT_T_CLKDIV [format "0x%X" [expr [set ::[set spwLink]::clkdiv] & 0xFF]]"
    puts $fp "#define SPWBOOT_T_CLKDIVS [format "0x%X" [expr [expr [set ::[set spwLink]::clkdiv] >> 8] & 0xFF]]"

    puts $fp "#define SPWBOOT_T_APBADDR [format "0x%X" $apbAddr]"
    puts $fp "#define SPWBOOT_T_NADDR [format "0x%X" $targetNaddr]"
    puts $fp "#define SPWBOOT_T_DESTKEY [format "0x%X" $targetKey]"

    close $fp

    rmap_gen
}

# Read memory at memAddr and append to address and data lists
# memAddr: Address to read out and save into the header files
# comment: Comment
proc save_word {memAddr {comment ""}} {
    upvar lAddr lA
    upvar lData lD
    set xmemAddr [format "0x%08X" $memAddr]
    set readData [format "0x%08X" [silent mem $xmemAddr 4]]
    lappend lA "$xmemAddr /* val:$readData $comment */"
    lappend lD $readData
}

#use data literal instead of reading from memory
proc write_word {memAddr memData {comment ""}} {
    upvar lAddr lA
    upvar lData lD
    set xmemAddr [format "0x%08X" $memAddr]
    set readData [format "0x%08X" $memData]
    lappend lA "$xmemAddr /* val:$readData $comment */"
    lappend lD $readData
}

proc writeCArray {thefp constName lArray {comment ""}} {
    if {[string length $comment] > 0} {
	puts $thefp "\n${comment}"
    }
    puts $thefp "static const int ${constName}\[\] = \{"
    foreach element $lArray {
	puts $thefp "${element},"
    }
    puts $thefp "\};"
}

#generate RMAP configuration words
proc rmap_gen {} {
    #generated include file to replay boot with master RMAP application
    set incFname "spwboot_rmap.h"
    set mkFname "spwboot.mk"

    set incFp [open $incFname "w"]
    set mkFp [open $mkFname "w"]
    set lSys [silent info sys]
    set lAddr [list]
    set lData [list]

    #find DSU ahb address
    set dsuBase $::dsu0::pnp::ahb::0::start
    if {0x90000000 != [format 0x%x $dsuBase]} {
	puts [format "DSU base address set to 0x%08X!" ${dsuBase}]
    }

    #put processor in debug mode
    write_word [expr $dsuBase + 0x24] 0xffff "enable debug"
    #put processor in debug mode
    write_word [expr $dsuBase + 0x00] 0x204 "Clear error, break on watch"
    #put processor in debug mode
    write_word [expr $dsuBase + 0x20] 0xffff "debug mode"

    #disable cache
    write_word [expr $dsuBase + 0x400024] 0x2 "set ASI 0x02"
    write_word [expr $dsuBase + 0x700000] 0x0 "disable caches"

    #disable mmu
    write_word [expr $dsuBase + 0x400024] 0x19 "set ASI 0x19"
    write_word [expr $dsuBase + 0x700000] 0x0 "disable mmu"

    write_word [expr $dsuBase + 0x400024] 0x0 "set ASI 0x0"

    #find memory controllers
    set memArea 0
    set lSys [silent info sys]
    if {"mctrl0" in $lSys} {
	set memArea $::mctrl0::pnp::ahb::2::start

	set mCfg $::mctrl0::pnp::apb::start
	save_word [expr $mCfg + 0x0] ""
	save_word [expr $mCfg + 0x4] ""
	save_word [expr $mCfg + 0x8] ""
    } elseif {"ddr2spa0" in $lSys} {
	set memArea $::ddr2spa0::pnp::ahb::0::start

	set ddrCfg $::ddr2spa0::pnp::ahb::1::start
	save_word [expr $ddrCfg + 0x0] ""
	save_word [expr $ddrCfg + 0x8] ""
	save_word [expr $ddrCfg + 0xc] ""

    } else {
	puts "#no supported mem controllers found!"
    }

    #save stage 1 (pre application load) accesses
    set nbCfgAddrs [llength $lAddr]
    if {$nbCfgAddrs != [llength $lData]} {
	puts "ERROR: addr and data array length differ!\n"
    }
    puts $incFp "/* generated header file */"
    puts $incFp "#define SPWBOOT_NCFGWORDS_S1 $nbCfgAddrs"
    writeCArray $incFp "spwboot_config_addr_s1" $lAddr "/* Array of write addresses*/"
    writeCArray $incFp "spwboot_config_data_s1" $lData "/* Array of write data*/"

    #clear lists
    set lAddr [list]
    set lData [list]
    
    puts $mkFp "# generated include file"
    puts -nonewline $mkFp "MKPROM_ARGS="

    #find uart0
    if {"uart0" in $lSys} {
	set uartCfg $::uart0::pnp::apb::start
	puts -nonewline $mkFp "-uart [format "0x%08X" $uartCfg] "
    }

    if {"irqmp0" in $lSys} {
	set irqCfg $::irqmp0::pnp::apb::start
	puts -nonewline $mkFp "-irqmp [format "0x%08X" $irqCfg] "
    }
    
    if {"gptimer0" in $lSys} {
    	set gptCfg $::gptimer0::pnp::apb::start
	puts -nonewline $mkFp "-gpt [format "0x%08X" $gptCfg] "
    } else {
    	puts "GPTIMER not found"
    }
    puts $mkFp ""
    close $mkFp

    lappend lAddr [format "0x%08X /* Set PC */" [expr $dsuBase + 0x400010]]
    lappend lData "REMOTE_ENTRYPOINT /* Set PC */"
    
    lappend lAddr [format "0x%08X /* Set nPC */" [expr $dsuBase + 0x400014]]
    lappend lData "REMOTE_ENTRYPOINT + 4 /* Set nPC */"


    write_word $dsuBase 0x200 "clear ERROR"
    write_word [expr $dsuBase + 0x20] 0xfffc "clear BREAK NOW"

    set nbCfgAddrs [llength $lAddr]
    if {$nbCfgAddrs != [llength $lData]} {
	puts "ERROR: addr and data array length differ!\n"
    }

    puts $incFp "#define SPWBOOT_NCFGWORDS_S3 $nbCfgAddrs"
    writeCArray $incFp "spwboot_config_addr_s3" $lAddr "/* Array of write addresses*/"
    writeCArray $incFp "spwboot_config_data_s3" $lData "/* Array of write data*/"
    close $incFp
}

# GR740 target-relevant header files.
proc spwboot_target_gen_GR740 {spwPort} {
    set filename "spwboot_target.h"
    set fp [open $filename "w"]
    
    if { [expr [set ::grcg0::enable] & 0x4] != 4} {
	puts "SpW router clock gated. Make sure GPIO[11] is low at reset. (FP-S2-4 down position)"
    }
    if {[expr [expr [set ::[set spwPort]] >> 12] & 0x7] != 5} {
	puts "Warning: $spwPort link down.\n"
    }

    puts $fp "/* generated header file */"
    puts $fp "#define SPWBOOT_T_NADDR 0xfe"
    puts $fp "#define SPWBOOT_T_DESTKEY 0"

    close $fp

#discover SDCFG1 register. May be commented and edited manually
#for settings different from GRMON initialization
    set sdcfgFname "GR740_SDCFG1.h"
    set SDCFG1 [silent mem 0xffe00000 4]
    set sdcfgFp [open $sdcfgFname "w"]
    puts $sdcfgFp "/* generated header file */"
    puts $sdcfgFp "#define SDCFG1_VAL [format "0x%08X" $SDCFG1]"
    close $sdcfgFp

#discover peripherals initialized by MKPROM
    set mkFname "spwboot.mk"
    set mkFp [open $mkFname "w"]
    
    puts $mkFp "# generated header file"
    puts -nonewline $mkFp "MKPROM_ARGS="
    set lSys [silent info sys]

    #find uart0
    if {"uart0" in $lSys} {
	set uartCfg $::uart0::pnp::apb::start
	puts -nonewline $mkFp "-uart [format "0x%08X" $uartCfg] "
    }

    if {"irqmp0" in $lSys} {
	set irqCfg $::irqmp0::pnp::apb::start
	puts -nonewline $mkFp "-irqmp [format "0x%08X" $irqCfg] "
    }
    
    if {"gptimer0" in $lSys} {
    	set gptCfg $::gptimer0::pnp::apb::start
	puts -nonewline $mkFp "-gpt [format "0x%08X" $gptCfg] "
    } else {
    	puts "GPTIMER not found"
    }
    puts $mkFp ""
    close $mkFp
}
