/* This header file is not generated. It is relevant for the GR740 target. */
#include "GR740_SDCFG1.h"

#define SPWBOOT_NCFGWORDS_S1 6

/* Array of write addresses*/
static const int spwboot_config_addr_s1[] = {
    /* MP status register. Power down all processors. 0x0000000F */
    0xFF904010,
    /* SDCFG2. Enable 2T signaling (bit 15). Common for current GR740 development boards. 0x40008000 */
    0xffe00004,
    /* MUXCFG. Enable EDAC. 0x00000001 */
    0xffe00020,
    /* SDCTRL1, with disabled refresh (bit 31). Disables SDRAM controller too. Default value 0x7ea087a4 */
    0xffe00000,
    /* SDCTRL1, enable and initialize. Default value 0xfea087a4 */
    0xffe00000,
    /* Turn off and invalidate L2 cache. 0x0000000D */
    0xF0000008,
};

/* Array of write data*/
static const int spwboot_config_data_s1[] = {
    0x0000000F,
    0x40008000,
    0x00000001,
    SDCFG1_VAL & 0x7FFFFFFF,
    SDCFG1_VAL | 0x80000000,
    0x0000000D,
};


#define SPWBOOT_NCFGWORDS_S3 2

/* Array of write addresses*/
static const int spwboot_config_addr_s3[] = {
    /* Processor 0 reset address register */
    0xff904200,
    /* Processor boot register. Reset and start processor 0 */
    0xff904240
};

/* Array of write data*/
static const int spwboot_config_data_s3[] = {
    REMOTE_ENTRYPOINT /* Set reset start address */,
    0x00000001
};
