
create_clock -period 20.000 -name CLK_EXT_XTAL -waveform {0.000 10.000} [get_ports CLK_EXT_XTAL]

set_property PACKAGE_PIN G10 [get_ports CLK_EXT_XTAL]
set_property IOSTANDARD LVCMOS18 [get_ports CLK_EXT_XTAL]

set_property PACKAGE_PIN AK11 [get_ports reset]
set_property IOSTANDARD LVCMOS18 [get_ports reset]

#Switches
set_property PACKAGE_PIN E13 [get_ports {switch[0]}]
set_property PACKAGE_PIN F12 [get_ports {switch[1]}]
set_property PACKAGE_PIN H13 [get_ports {switch[2]}]
set_property PACKAGE_PIN J13 [get_ports {switch[3]}]
set_property PACKAGE_PIN K12 [get_ports {switch[4]}]
set_property PACKAGE_PIN L12 [get_ports {switch[5]}]
set_property PACKAGE_PIN K13 [get_ports {switch[6]}]
set_property PACKAGE_PIN L13 [get_ports {switch[7]}]

#GPIOs
set_property PACKAGE_PIN AM11 [get_ports {gpio[0]}]
set_property PACKAGE_PIN AN11 [get_ports {gpio[1]}]
set_property PACKAGE_PIN AM12 [get_ports {gpio[2]}]
set_property PACKAGE_PIN AN12 [get_ports {gpio[3]}]
set_property PACKAGE_PIN AK12 [get_ports {gpio[4]}]
set_property PACKAGE_PIN AL12 [get_ports {gpio[5]}]
set_property PACKAGE_PIN AK13 [get_ports {gpio[6]}]
set_property PACKAGE_PIN AL13 [get_ports {gpio[7]}]
set_property PACKAGE_PIN AE13 [get_ports {gpio[8]}]
set_property PACKAGE_PIN AF13 [get_ports {gpio[9]}]
set_property PACKAGE_PIN AH13 [get_ports {gpio[10]}]
set_property PACKAGE_PIN AJ13 [get_ports {gpio[11]}]
set_property PACKAGE_PIN AE12 [get_ports {gpio[12]}]
set_property PACKAGE_PIN AF12 [get_ports {gpio[13]}]
set_property PACKAGE_PIN AD11 [get_ports {gpio[14]}]
set_property PACKAGE_PIN AE11 [get_ports {gpio[15]}]

# SPI Master Interface 
set_property PACKAGE_PIN AP13 [get_ports {spi_miso}] 
set_property PACKAGE_PIN AN13 [get_ports {spi_mosi}] 
set_property PACKAGE_PIN AP10 [get_ports {spi_sel[0]}]    
set_property PACKAGE_PIN AP11 [get_ports {spi_sel[1]}]     
set_property PACKAGE_PIN AH12 [get_ports {spi_sel[2]}]     
set_property PACKAGE_PIN AG12 [get_ports {spi_sck}]     

#GPIO LEDs
set_property PACKAGE_PIN F10 [get_ports {led[0]}]
set_property PACKAGE_PIN L9  [get_ports {led[1]}]
set_property PACKAGE_PIN H11 [get_ports {led[2]}]
set_property PACKAGE_PIN G11 [get_ports {led[3]}]
set_property PACKAGE_PIN H12 [get_ports {led[4]}]
set_property PACKAGE_PIN G12 [get_ports {led[5]}]
set_property PACKAGE_PIN K11 [get_ports {led[6]}]
set_property PACKAGE_PIN J11 [get_ports {led[7]}]

#Error LED
set_property PACKAGE_PIN J9 [get_ports {led[8]}]

#Active Debug LED
set_property PACKAGE_PIN H9 [get_ports {led[9]}]

set_property PACKAGE_PIN AE32 [get_ports {sd_data[0]}]
set_property PACKAGE_PIN AF32 [get_ports {sd_data[1]}]
set_property PACKAGE_PIN AE33 [get_ports {sd_data[2]}]
set_property PACKAGE_PIN AF34 [get_ports {sd_data[3]}]
set_property PACKAGE_PIN AD31 [get_ports {sd_data[4]}]
set_property PACKAGE_PIN AC32 [get_ports {sd_data[5]}]
set_property PACKAGE_PIN AE31 [get_ports {sd_data[6]}]
set_property PACKAGE_PIN AB32 [get_ports {sd_data[7]}]
set_property PACKAGE_PIN AB30 [get_ports {sd_data[8]}]
set_property PACKAGE_PIN AB31 [get_ports {sd_data[9]}]
set_property PACKAGE_PIN AC34 [get_ports {sd_data[10]}]
set_property PACKAGE_PIN AD34 [get_ports {sd_data[11]}]
set_property PACKAGE_PIN AA29 [get_ports {sd_data[12]}]
set_property PACKAGE_PIN AB29 [get_ports {sd_data[13]}]
set_property PACKAGE_PIN AA34 [get_ports {sd_data[14]}]
set_property PACKAGE_PIN AB34 [get_ports {sd_data[15]}]
set_property PACKAGE_PIN AC33 [get_ports {sd_data[16]}]
set_property PACKAGE_PIN AD33 [get_ports {sd_data[17]}]
set_property PACKAGE_PIN AA33 [get_ports {sd_data[18]}]
set_property PACKAGE_PIN W33 [get_ports {sd_data[19]}]
set_property PACKAGE_PIN Y33 [get_ports {sd_data[20]}]
set_property PACKAGE_PIN W30 [get_ports {sd_data[21]}]
set_property PACKAGE_PIN Y30 [get_ports {sd_data[22]}]
set_property PACKAGE_PIN V33 [get_ports {sd_data[23]}]
set_property PACKAGE_PIN W34 [get_ports {sd_data[24]}]
set_property PACKAGE_PIN Y31 [get_ports {sd_data[25]}]
set_property PACKAGE_PIN Y32 [get_ports {sd_data[26]}]
set_property PACKAGE_PIN U34 [get_ports {sd_data[27]}]
set_property PACKAGE_PIN V34 [get_ports {sd_data[28]}]
set_property PACKAGE_PIN V31 [get_ports {sd_data[29]}]
set_property PACKAGE_PIN W31 [get_ports {sd_data[30]}]
set_property PACKAGE_PIN V32 [get_ports {sd_data[31]}]
set_property IOSTANDARD LVCMOS18 [get_ports sd_data*]
set_property PACKAGE_PIN Y21 [get_ports {sd_ba[0]}]
set_property PACKAGE_PIN W21 [get_ports {sd_ba[1]}]
set_property IOSTANDARD LVCMOS18 [get_ports sd_ba*]
set_property PACKAGE_PIN V21 [get_ports sd_csn]
set_property PACKAGE_PIN T23 [get_ports sd_casn]
set_property PACKAGE_PIN T22 [get_ports sd_rasn]
set_property PACKAGE_PIN V23 [get_ports sd_wen]
set_property IOSTANDARD LVCMOS18 [get_ports sd_csn]
set_property IOSTANDARD LVCMOS18 [get_ports sd_casn]
set_property IOSTANDARD LVCMOS18 [get_ports sd_rasn]
set_property IOSTANDARD LVCMOS18 [get_ports sd_wen]
set_property IOSTANDARD LVCMOS18 [get_ports sd_dqm*]
set_property PACKAGE_PIN W23 [get_ports {sd_clk[0]}]
set_property PACKAGE_PIN AA24 [get_ports {sd_clk[1]}]
set_property PACKAGE_PIN Y23 [get_ports {sd_clk[2]}]

set_property PACKAGE_PIN AD30 [get_ports {sd_clkfb[0]}]
set_property PACKAGE_PIN AC31 [get_ports {sd_clkfb[1]}]
set_property PACKAGE_PIN AA32 [get_ports {sd_clkfb[2]}]
set_property IOSTANDARD LVCMOS18 [get_ports sd_clkfb*]
set_property PACKAGE_PIN AE8 [get_ports {sr_add[0]}]
set_property PACKAGE_PIN AF8 [get_ports {sr_add[1]}]
set_property PACKAGE_PIN AD10 [get_ports {sr_add[2]}]
set_property PACKAGE_PIN AE10 [get_ports {sr_add[3]}]
set_property PACKAGE_PIN AD9 [get_ports {sr_add[4]}]
set_property PACKAGE_PIN AD8 [get_ports {sr_add[5]}]
set_property PACKAGE_PIN AH9 [get_ports {sr_add[6]}]
set_property PACKAGE_PIN AH8 [get_ports {sr_add[7]}]
set_property PACKAGE_PIN AJ10 [get_ports {sr_add[8]}]
set_property PACKAGE_PIN AL10 [get_ports {sr_add[9]}]
set_property PACKAGE_PIN AM10 [get_ports {sr_add[10]}]
set_property PACKAGE_PIN AN9 [get_ports {sr_add[11]}]
set_property PACKAGE_PIN AP9 [get_ports {sr_add[12]}]
set_property PACKAGE_PIN AK10 [get_ports {sr_add[13]}]
set_property PACKAGE_PIN AL9 [get_ports {sr_add[14]}]
set_property PACKAGE_PIN AN8 [get_ports {sr_add[15]}]
set_property PACKAGE_PIN AP8 [get_ports {sr_add[16]}]
set_property PACKAGE_PIN AJ9 [get_ports {sr_add[17]}]
set_property PACKAGE_PIN AJ8 [get_ports {sr_add[18]}]
set_property PACKAGE_PIN AK8 [get_ports {sr_add[19]}]
set_property PACKAGE_PIN AL8 [get_ports {sr_add[20]}]
set_property PACKAGE_PIN AM9 [get_ports {sr_add[21]}]
set_property IOSTANDARD LVCMOS18 [get_ports sr_add*]
set_property PACKAGE_PIN K23 [get_ports {sr_data[0]}]
set_property PACKAGE_PIN M25 [get_ports {sr_data[1]}]
set_property PACKAGE_PIN M26 [get_ports {sr_data[2]}]
set_property PACKAGE_PIN N24 [get_ports {sr_data[3]}]
set_property PACKAGE_PIN M24 [get_ports {sr_data[4]}]
set_property PACKAGE_PIN N23 [get_ports {sr_data[5]}]
set_property PACKAGE_PIN P26 [get_ports {sr_data[6]}]
set_property PACKAGE_PIN N26 [get_ports {sr_data[7]}]
set_property PACKAGE_PIN P24 [get_ports {sr_data[8]}]
set_property PACKAGE_PIN P25 [get_ports {sr_data[9]}]
set_property PACKAGE_PIN T27 [get_ports {sr_data[10]}]
set_property PACKAGE_PIN R27 [get_ports {sr_data[11]}]
set_property PACKAGE_PIN T24 [get_ports {sr_data[12]}]
set_property PACKAGE_PIN T25 [get_ports {sr_data[13]}]
set_property PACKAGE_PIN R25 [get_ports {sr_data[14]}]
set_property PACKAGE_PIN R26 [get_ports {sr_data[15]}]
set_property PACKAGE_PIN R23 [get_ports {sr_data[16]}]
set_property PACKAGE_PIN P23 [get_ports {sr_data[17]}]
set_property PACKAGE_PIN N27 [get_ports {sr_data[18]}]
set_property PACKAGE_PIN N22 [get_ports {sr_data[19]}]
set_property PACKAGE_PIN M22 [get_ports {sr_data[20]}]
set_property PACKAGE_PIN P20 [get_ports {sr_data[21]}]
set_property PACKAGE_PIN P21 [get_ports {sr_data[22]}]
set_property PACKAGE_PIN R21 [get_ports {sr_data[23]}]
set_property PACKAGE_PIN R22 [get_ports {sr_data[24]}]
set_property PACKAGE_PIN M20 [get_ports {sr_data[25]}]
set_property PACKAGE_PIN L20 [get_ports {sr_data[26]}]
set_property PACKAGE_PIN N21 [get_ports {sr_data[27]}]
set_property PACKAGE_PIN M21 [get_ports {sr_data[28]}]
set_property PACKAGE_PIN K20 [get_ports {sr_data[29]}]
set_property PACKAGE_PIN K21 [get_ports {sr_data[30]}]
set_property PACKAGE_PIN K22 [get_ports {sr_data[31]}]
set_property IOSTANDARD LVCMOS18 [get_ports sr_data*]
set_property PACKAGE_PIN AG9 [get_ports sr_oen]
set_property PACKAGE_PIN AF9 [get_ports sr_wen]
set_property PACKAGE_PIN AG10 [get_ports sr_csn0]
set_property IOSTANDARD LVCMOS18 [get_ports sr_oen]
set_property IOSTANDARD LVCMOS18 [get_ports sr_wen]
set_property IOSTANDARD LVCMOS18 [get_ports sr_csn0]
set_property PACKAGE_PIN AJ11 [get_ports rom_oen]
set_property PACKAGE_PIN AH11 [get_ports rom_wen]
set_property PACKAGE_PIN AG11 [get_ports rom_csn]
set_property IOSTANDARD LVCMOS18 [get_ports rom_oen]
set_property IOSTANDARD LVCMOS18 [get_ports rom_wen]
set_property IOSTANDARD LVCMOS18 [get_ports rom_csn]

set_property IOSTANDARD LVCMOS18 [get_ports sd_add*]
set_property IOSTANDARD LVCMOS18 [get_ports sd_data*]
set_property IOSTANDARD LVCMOS18 [get_ports sd_ba*]
set_property IOSTANDARD LVCMOS18 [get_ports sd_dqm*]
set_property IOSTANDARD LVCMOS18 [get_ports sd_clk*]
set_property IOSTANDARD LVCMOS18 [get_ports sd_clkfb*]
set_property IOSTANDARD LVCMOS18 [get_ports sr_add*]
set_property IOSTANDARD LVCMOS18 [get_ports sr_data*]

#LEDs
set_property IOSTANDARD LVCMOS18 [get_ports {led*}]

set_property IOSTANDARD LVCMOS18 [get_ports {spi_*}]

set_property IOSTANDARD LVCMOS18 [get_ports {gpio*}]

set_property IOSTANDARD LVCMOS18 [get_ports {switch*}]

create_interface SD_RAM
set_property INTERFACE SD_RAM [get_ports { sd_dqm[3] sd_dqm[2] sd_dqm[1] sd_dqm[0] sd_ba[1] sd_ba[0] sd_clk[2] sd_clk[1] sd_clk[0] sd_clkfb[2] sd_clkfb[1] sd_clkfb[0] sd_data[31] sd_data[30] sd_data[29] sd_data[28] sd_data[27] sd_data[26] sd_data[25] sd_data[24] sd_data[23] sd_data[22] sd_data[21] sd_data[20] sd_data[19] sd_data[18] sd_data[17] sd_data[16] sd_data[15] sd_data[14] sd_data[13] sd_data[12] sd_data[11] sd_data[10] sd_data[9] sd_data[8] sd_data[7] sd_data[6] sd_data[5] sd_data[4] sd_data[3] sd_data[2] sd_data[1] sd_data[0] sd_add[12] sd_add[11] sd_add[10] sd_add[9] sd_add[8] sd_add[7] sd_add[6] sd_add[5] sd_add[4] sd_add[3] sd_add[2] sd_add[1] sd_add[0] sd_casn sd_csn sd_rasn sd_wen }]
create_interface SRAM
set_property INTERFACE SRAM [get_ports { sr_add[21] sr_add[20] sr_add[19] sr_add[18] sr_add[17] sr_add[16] sr_add[15] sr_add[14] sr_add[13] sr_add[12] sr_add[11] sr_add[10] sr_add[9] sr_add[8] sr_add[7] sr_add[6] sr_add[5] sr_add[4] sr_add[3] sr_add[2] sr_add[1] sr_add[0] sr_data[31] sr_data[30] sr_data[29] sr_data[28] sr_data[27] sr_data[26] sr_data[25] sr_data[24] sr_data[23] sr_data[22] sr_data[21] sr_data[20] sr_data[19] sr_data[18] sr_data[17] sr_data[16] sr_data[15] sr_data[14] sr_data[13] sr_data[12] sr_data[11] sr_data[10] sr_data[9] sr_data[8] sr_data[7] sr_data[6] sr_data[5] sr_data[4] sr_data[3] sr_data[2] sr_data[1] sr_data[0] sr_wen sr_oen sr_csn0 }]
create_interface CAN
set_property IOSTANDARD LVCMOS18 [get_ports dsu_out]
set_property IOSTANDARD LVCMOS18 [get_ports dsu_in]
create_interface LED
create_interface Debug_UART
set_property INTERFACE Debug_UART [get_ports { dsu_in dsu_out }]
create_interface APB_UART
set_property INTERFACE APB_UART [get_ports { uart_in uart_ou}]
set_property IOSTANDARD LVCMOS18 [get_ports uart_ou]
set_property IOSTANDARD LVCMOS18 [get_ports uart_in]

create_interface Serial_SPI_flash
create_interface ROM
set_property INTERFACE ROM [get_ports { rom_csn rom_oen rom_wen }]
create_interface Spacewire
create_interface I2C
create_interface PWM
create_interface MISC
create_interface SPI

set_property PACKAGE_PIN K8 [get_ports dsu_in]
set_property PACKAGE_PIN L8 [get_ports dsu_out]

set_property PACKAGE_PIN E10 [get_ports uart_in]
set_property PACKAGE_PIN C9 [get_ports uart_ou]

set_property PACKAGE_PIN V22 [get_ports {sd_dqm[0]}]
set_property PACKAGE_PIN U22 [get_ports {sd_dqm[1]}]
set_property PACKAGE_PIN U21 [get_ports {sd_dqm[2]}]
set_property PACKAGE_PIN Y25 [get_ports {sd_dqm[3]}]
set_property IOSTANDARD LVCMOS18 [get_ports sd_dqm*]



set_property PACKAGE_PIN W28 [get_ports {sd_add[4]}]

set_property IOSTANDARD LVCMOS18 [get_ports sd_cke]
set_property DRIVE 12 [get_ports sd_cke]
set_property SLEW SLOW [get_ports sd_cke]
set_property PACKAGE_PIN W25 [get_ports sd_cke]

set_property DRIVE 12 [get_ports {sd_add[0]}]
set_property DRIVE 12 [get_ports {sd_add[1]}]
set_property DRIVE 12 [get_ports {sd_add[2]}]
set_property DRIVE 12 [get_ports {sd_add[3]}]
set_property DRIVE 12 [get_ports {sd_add[4]}]
set_property DRIVE 12 [get_ports {sd_add[5]}]
set_property DRIVE 12 [get_ports {sd_add[6]}]
set_property DRIVE 12 [get_ports {sd_add[7]}]
set_property DRIVE 12 [get_ports {sd_add[8]}]
set_property DRIVE 12 [get_ports {sd_add[9]}]
set_property DRIVE 12 [get_ports {sd_add[10]}]
set_property DRIVE 12 [get_ports {sd_add[11]}]
set_property DRIVE 12 [get_ports {sd_add[12]}]
set_property SLEW SLOW [get_ports {sd_add[0]}]
set_property SLEW SLOW [get_ports {sd_add[1]}]
set_property SLEW SLOW [get_ports {sd_add[2]}]
set_property SLEW SLOW [get_ports {sd_add[3]}]
set_property SLEW SLOW [get_ports {sd_add[4]}]
set_property SLEW SLOW [get_ports {sd_add[5]}]
set_property SLEW SLOW [get_ports {sd_add[6]}]
set_property SLEW SLOW [get_ports {sd_add[7]}]
set_property SLEW SLOW [get_ports {sd_add[8]}]
set_property SLEW SLOW [get_ports {sd_add[9]}]
set_property SLEW SLOW [get_ports {sd_add[10]}]
set_property SLEW SLOW [get_ports {sd_add[11]}]
set_property SLEW SLOW [get_ports {sd_add[12]}]
set_property PACKAGE_PIN V27 [get_ports {sd_add[0]}]
set_property PACKAGE_PIN U29 [get_ports {sd_add[12]}]
set_property PACKAGE_PIN W26 [get_ports {sd_add[11]}]
set_property PACKAGE_PIN V26 [get_ports {sd_add[10]}]
set_property PACKAGE_PIN W29 [get_ports {sd_add[9]}]
set_property PACKAGE_PIN V29 [get_ports {sd_add[8]}]
set_property PACKAGE_PIN U27 [get_ports {sd_add[7]}]
set_property PACKAGE_PIN U26 [get_ports {sd_add[6]}]
set_property PACKAGE_PIN Y28 [get_ports {sd_add[5]}]
set_property PACKAGE_PIN U25 [get_ports {sd_add[3]}]
set_property PACKAGE_PIN U24 [get_ports {sd_add[2]}]
set_property PACKAGE_PIN V28 [get_ports {sd_add[1]}]

create_interface SWITCH

set_property BITSTREAM.CONFIG.SPI_BUSWIDTH 4 [current_design]
set_property BITSTREAM.CONFIG.CONFIGRATE 40 [current_design]
set_property CONFIG_VOLTAGE 3.3 [current_design]
set_property CFGBVS VCCO [current_design]


set_property BITSTREAM.CONFIG.SPI_FALL_EDGE YES [current_design]
set_property CONFIG_MODE SPIx4 [current_design]

