-- megafunction wizard: %DDR2 SDRAM Controller with UniPHY v15.0%
-- GENERATION: XML
-- uniphy.vhd

-- Generated using ACDS version 15.0 145

library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.numeric_std.all;

entity uniphy is
	port (
		pll_ref_clk         : in    std_logic                      := '0';             --      pll_ref_clk.clk
		global_reset_n      : in    std_logic                      := '0';             --     global_reset.reset_n
		soft_reset_n        : in    std_logic                      := '0';             --       soft_reset.reset_n
		afi_clk             : out   std_logic;                                         --          afi_clk.clk
		afi_half_clk        : out   std_logic;                                         --     afi_half_clk.clk
		afi_reset_n         : out   std_logic;                                         --        afi_reset.reset_n
		afi_reset_export_n  : out   std_logic;                                         -- afi_reset_export.reset_n
		mem_a               : out   std_logic_vector(13 downto 0);                     --           memory.mem_a
		mem_ba              : out   std_logic_vector(2 downto 0);                      --                 .mem_ba
		mem_ck              : out   std_logic_vector(1 downto 0);                      --                 .mem_ck
		mem_ck_n            : out   std_logic_vector(1 downto 0);                      --                 .mem_ck_n
		mem_cke             : out   std_logic_vector(0 downto 0);                      --                 .mem_cke
		mem_cs_n            : out   std_logic_vector(0 downto 0);                      --                 .mem_cs_n
		mem_dm              : out   std_logic_vector(7 downto 0);                      --                 .mem_dm
		mem_ras_n           : out   std_logic_vector(0 downto 0);                      --                 .mem_ras_n
		mem_cas_n           : out   std_logic_vector(0 downto 0);                      --                 .mem_cas_n
		mem_we_n            : out   std_logic_vector(0 downto 0);                      --                 .mem_we_n
		mem_dq              : inout std_logic_vector(63 downto 0)  := (others => '0'); --                 .mem_dq
		mem_dqs             : inout std_logic_vector(7 downto 0)   := (others => '0'); --                 .mem_dqs
		mem_dqs_n           : inout std_logic_vector(7 downto 0)   := (others => '0'); --                 .mem_dqs_n
		mem_odt             : out   std_logic_vector(0 downto 0);                      --                 .mem_odt
		afi_addr            : in    std_logic_vector(13 downto 0)  := (others => '0'); --              afi.afi_addr
		afi_ba              : in    std_logic_vector(2 downto 0)   := (others => '0'); --                 .afi_ba
		afi_cke             : in    std_logic_vector(0 downto 0)   := (others => '0'); --                 .afi_cke
		afi_cs_n            : in    std_logic_vector(0 downto 0)   := (others => '0'); --                 .afi_cs_n
		afi_ras_n           : in    std_logic_vector(0 downto 0)   := (others => '0'); --                 .afi_ras_n
		afi_we_n            : in    std_logic_vector(0 downto 0)   := (others => '0'); --                 .afi_we_n
		afi_cas_n           : in    std_logic_vector(0 downto 0)   := (others => '0'); --                 .afi_cas_n
		afi_odt             : in    std_logic_vector(0 downto 0)   := (others => '0'); --                 .afi_odt
		afi_dqs_burst       : in    std_logic_vector(7 downto 0)   := (others => '0'); --                 .afi_dqs_burst
		afi_wdata_valid     : in    std_logic_vector(7 downto 0)   := (others => '0'); --                 .afi_wdata_valid
		afi_wdata           : in    std_logic_vector(127 downto 0) := (others => '0'); --                 .afi_wdata
		afi_dm              : in    std_logic_vector(15 downto 0)  := (others => '0'); --                 .afi_dm
		afi_rdata           : out   std_logic_vector(127 downto 0);                    --                 .afi_rdata
		afi_rdata_en        : in    std_logic_vector(0 downto 0)   := (others => '0'); --                 .afi_rdata_en
		afi_rdata_en_full   : in    std_logic_vector(0 downto 0)   := (others => '0'); --                 .afi_rdata_en_full
		afi_rdata_valid     : out   std_logic_vector(0 downto 0);                      --                 .afi_rdata_valid
		afi_mem_clk_disable : in    std_logic_vector(1 downto 0)   := (others => '0'); --                 .afi_mem_clk_disable
		afi_init_req        : in    std_logic                      := '0';             --                 .afi_init_req
		afi_cal_req         : in    std_logic                      := '0';             --                 .afi_cal_req
		afi_wlat            : out   std_logic_vector(5 downto 0);                      --                 .afi_wlat
		afi_rlat            : out   std_logic_vector(5 downto 0);                      --                 .afi_rlat
		afi_cal_success     : out   std_logic;                                         --                 .afi_cal_success
		afi_cal_fail        : out   std_logic;                                         --                 .afi_cal_fail
		oct_rdn             : in    std_logic                      := '0';             --              oct.rdn
		oct_rup             : in    std_logic                      := '0'              --                 .rup
	);
end entity uniphy;

architecture rtl of uniphy is
	component uniphy_0002 is
		port (
			pll_ref_clk         : in    std_logic                      := 'X';             -- clk
			global_reset_n      : in    std_logic                      := 'X';             -- reset_n
			soft_reset_n        : in    std_logic                      := 'X';             -- reset_n
			afi_clk             : out   std_logic;                                         -- clk
			afi_half_clk        : out   std_logic;                                         -- clk
			afi_reset_n         : out   std_logic;                                         -- reset_n
			afi_reset_export_n  : out   std_logic;                                         -- reset_n
			mem_a               : out   std_logic_vector(13 downto 0);                     -- mem_a
			mem_ba              : out   std_logic_vector(2 downto 0);                      -- mem_ba
			mem_ck              : out   std_logic_vector(1 downto 0);                      -- mem_ck
			mem_ck_n            : out   std_logic_vector(1 downto 0);                      -- mem_ck_n
			mem_cke             : out   std_logic_vector(0 downto 0);                      -- mem_cke
			mem_cs_n            : out   std_logic_vector(0 downto 0);                      -- mem_cs_n
			mem_dm              : out   std_logic_vector(7 downto 0);                      -- mem_dm
			mem_ras_n           : out   std_logic_vector(0 downto 0);                      -- mem_ras_n
			mem_cas_n           : out   std_logic_vector(0 downto 0);                      -- mem_cas_n
			mem_we_n            : out   std_logic_vector(0 downto 0);                      -- mem_we_n
			mem_dq              : inout std_logic_vector(63 downto 0)  := (others => 'X'); -- mem_dq
			mem_dqs             : inout std_logic_vector(7 downto 0)   := (others => 'X'); -- mem_dqs
			mem_dqs_n           : inout std_logic_vector(7 downto 0)   := (others => 'X'); -- mem_dqs_n
			mem_odt             : out   std_logic_vector(0 downto 0);                      -- mem_odt
			afi_addr            : in    std_logic_vector(13 downto 0)  := (others => 'X'); -- afi_addr
			afi_ba              : in    std_logic_vector(2 downto 0)   := (others => 'X'); -- afi_ba
			afi_cke             : in    std_logic_vector(0 downto 0)   := (others => 'X'); -- afi_cke
			afi_cs_n            : in    std_logic_vector(0 downto 0)   := (others => 'X'); -- afi_cs_n
			afi_ras_n           : in    std_logic_vector(0 downto 0)   := (others => 'X'); -- afi_ras_n
			afi_we_n            : in    std_logic_vector(0 downto 0)   := (others => 'X'); -- afi_we_n
			afi_cas_n           : in    std_logic_vector(0 downto 0)   := (others => 'X'); -- afi_cas_n
			afi_odt             : in    std_logic_vector(0 downto 0)   := (others => 'X'); -- afi_odt
			afi_dqs_burst       : in    std_logic_vector(7 downto 0)   := (others => 'X'); -- afi_dqs_burst
			afi_wdata_valid     : in    std_logic_vector(7 downto 0)   := (others => 'X'); -- afi_wdata_valid
			afi_wdata           : in    std_logic_vector(127 downto 0) := (others => 'X'); -- afi_wdata
			afi_dm              : in    std_logic_vector(15 downto 0)  := (others => 'X'); -- afi_dm
			afi_rdata           : out   std_logic_vector(127 downto 0);                    -- afi_rdata
			afi_rdata_en        : in    std_logic_vector(0 downto 0)   := (others => 'X'); -- afi_rdata_en
			afi_rdata_en_full   : in    std_logic_vector(0 downto 0)   := (others => 'X'); -- afi_rdata_en_full
			afi_rdata_valid     : out   std_logic_vector(0 downto 0);                      -- afi_rdata_valid
			afi_mem_clk_disable : in    std_logic_vector(1 downto 0)   := (others => 'X'); -- afi_mem_clk_disable
			afi_init_req        : in    std_logic                      := 'X';             -- afi_init_req
			afi_cal_req         : in    std_logic                      := 'X';             -- afi_cal_req
			afi_wlat            : out   std_logic_vector(5 downto 0);                      -- afi_wlat
			afi_rlat            : out   std_logic_vector(5 downto 0);                      -- afi_rlat
			afi_cal_success     : out   std_logic;                                         -- afi_cal_success
			afi_cal_fail        : out   std_logic;                                         -- afi_cal_fail
			oct_rdn             : in    std_logic                      := 'X';             -- rdn
			oct_rup             : in    std_logic                      := 'X'              -- rup
		);
	end component uniphy_0002;

begin

	uniphy_inst : component uniphy_0002
		port map (
			pll_ref_clk         => pll_ref_clk,         --      pll_ref_clk.clk
			global_reset_n      => global_reset_n,      --     global_reset.reset_n
			soft_reset_n        => soft_reset_n,        --       soft_reset.reset_n
			afi_clk             => afi_clk,             --          afi_clk.clk
			afi_half_clk        => afi_half_clk,        --     afi_half_clk.clk
			afi_reset_n         => afi_reset_n,         --        afi_reset.reset_n
			afi_reset_export_n  => afi_reset_export_n,  -- afi_reset_export.reset_n
			mem_a               => mem_a,               --           memory.mem_a
			mem_ba              => mem_ba,              --                 .mem_ba
			mem_ck              => mem_ck,              --                 .mem_ck
			mem_ck_n            => mem_ck_n,            --                 .mem_ck_n
			mem_cke             => mem_cke,             --                 .mem_cke
			mem_cs_n            => mem_cs_n,            --                 .mem_cs_n
			mem_dm              => mem_dm,              --                 .mem_dm
			mem_ras_n           => mem_ras_n,           --                 .mem_ras_n
			mem_cas_n           => mem_cas_n,           --                 .mem_cas_n
			mem_we_n            => mem_we_n,            --                 .mem_we_n
			mem_dq              => mem_dq,              --                 .mem_dq
			mem_dqs             => mem_dqs,             --                 .mem_dqs
			mem_dqs_n           => mem_dqs_n,           --                 .mem_dqs_n
			mem_odt             => mem_odt,             --                 .mem_odt
			afi_addr            => afi_addr,            --              afi.afi_addr
			afi_ba              => afi_ba,              --                 .afi_ba
			afi_cke             => afi_cke,             --                 .afi_cke
			afi_cs_n            => afi_cs_n,            --                 .afi_cs_n
			afi_ras_n           => afi_ras_n,           --                 .afi_ras_n
			afi_we_n            => afi_we_n,            --                 .afi_we_n
			afi_cas_n           => afi_cas_n,           --                 .afi_cas_n
			afi_odt             => afi_odt,             --                 .afi_odt
			afi_dqs_burst       => afi_dqs_burst,       --                 .afi_dqs_burst
			afi_wdata_valid     => afi_wdata_valid,     --                 .afi_wdata_valid
			afi_wdata           => afi_wdata,           --                 .afi_wdata
			afi_dm              => afi_dm,              --                 .afi_dm
			afi_rdata           => afi_rdata,           --                 .afi_rdata
			afi_rdata_en        => afi_rdata_en,        --                 .afi_rdata_en
			afi_rdata_en_full   => afi_rdata_en_full,   --                 .afi_rdata_en_full
			afi_rdata_valid     => afi_rdata_valid,     --                 .afi_rdata_valid
			afi_mem_clk_disable => afi_mem_clk_disable, --                 .afi_mem_clk_disable
			afi_init_req        => afi_init_req,        --                 .afi_init_req
			afi_cal_req         => afi_cal_req,         --                 .afi_cal_req
			afi_wlat            => afi_wlat,            --                 .afi_wlat
			afi_rlat            => afi_rlat,            --                 .afi_rlat
			afi_cal_success     => afi_cal_success,     --                 .afi_cal_success
			afi_cal_fail        => afi_cal_fail,        --                 .afi_cal_fail
			oct_rdn             => oct_rdn,             --              oct.rdn
			oct_rup             => oct_rup              --                 .rup
		);

end architecture rtl; -- of uniphy
-- Retrieval info: <?xml version="1.0"?>
--<!--
--	Generated by Altera MegaWizard Launcher Utility version 1.0
--	************************************************************
--	THIS IS A WIZARD-GENERATED FILE. DO NOT EDIT THIS FILE!
--	************************************************************
--	Copyright (C) 1991-2015 Altera Corporation
--	Any megafunction design, and related net list (encrypted or decrypted),
--	support information, device programming or simulation file, and any other
--	associated documentation or information provided by Altera or a partner
--	under Altera's Megafunction Partnership Program may be used only to
--	program PLD devices (but not masked PLD devices) from Altera.  Any other
--	use of such megafunction design, net list, support information, device
--	programming or simulation file, or any other related documentation or
--	information is prohibited for any other purpose, including, but not
--	limited to modification, reverse engineering, de-compiling, or use with
--	any other silicon devices, unless such use is explicitly licensed under
--	a separate agreement with Altera or a megafunction partner.  Title to
--	the intellectual property, including patents, copyrights, trademarks,
--	trade secrets, or maskworks, embodied in any such megafunction design,
--	net list, support information, device programming or simulation file, or
--	any other related documentation or information provided by Altera or a
--	megafunction partner, remains with Altera, the megafunction partner, or
--	their respective licensors.  No other licenses, including any licenses
--	needed under any third party's intellectual property, are provided herein.
---->
-- Retrieval info: <instance entity-name="altera_mem_if_ddr2_emif" version="15.0" >
-- Retrieval info: 	<generic name="RATE" value="Full" />
-- Retrieval info: 	<generic name="MEM_CLK_FREQ" value="333.3333" />
-- Retrieval info: 	<generic name="USE_MEM_CLK_FREQ" value="false" />
-- Retrieval info: 	<generic name="FORCE_DQS_TRACKING" value="AUTO" />
-- Retrieval info: 	<generic name="FORCE_SHADOW_REGS" value="AUTO" />
-- Retrieval info: 	<generic name="MRS_MIRROR_PING_PONG_ATSO" value="false" />
-- Retrieval info: 	<generic name="MEM_VENDOR" value="Micron" />
-- Retrieval info: 	<generic name="MEM_FORMAT" value="UNBUFFERED" />
-- Retrieval info: 	<generic name="DISCRETE_FLY_BY" value="true" />
-- Retrieval info: 	<generic name="DEVICE_DEPTH" value="1" />
-- Retrieval info: 	<generic name="MEM_MIRROR_ADDRESSING" value="0" />
-- Retrieval info: 	<generic name="MEM_CLK_FREQ_MAX" value="400.0" />
-- Retrieval info: 	<generic name="MEM_ROW_ADDR_WIDTH" value="14" />
-- Retrieval info: 	<generic name="MEM_COL_ADDR_WIDTH" value="10" />
-- Retrieval info: 	<generic name="MEM_DQ_WIDTH" value="64" />
-- Retrieval info: 	<generic name="MEM_DQ_PER_DQS" value="8" />
-- Retrieval info: 	<generic name="MEM_BANKADDR_WIDTH" value="3" />
-- Retrieval info: 	<generic name="MEM_IF_DM_PINS_EN" value="true" />
-- Retrieval info: 	<generic name="MEM_IF_DQSN_EN" value="true" />
-- Retrieval info: 	<generic name="MEM_NUMBER_OF_DIMMS" value="1" />
-- Retrieval info: 	<generic name="MEM_NUMBER_OF_RANKS_PER_DIMM" value="1" />
-- Retrieval info: 	<generic name="MEM_NUMBER_OF_RANKS_PER_DEVICE" value="1" />
-- Retrieval info: 	<generic name="MEM_RANK_MULTIPLICATION_FACTOR" value="1" />
-- Retrieval info: 	<generic name="MEM_CK_WIDTH" value="2" />
-- Retrieval info: 	<generic name="MEM_CS_WIDTH" value="1" />
-- Retrieval info: 	<generic name="MEM_CLK_EN_WIDTH" value="1" />
-- Retrieval info: 	<generic name="ALTMEMPHY_COMPATIBLE_MODE" value="false" />
-- Retrieval info: 	<generic name="NEXTGEN" value="true" />
-- Retrieval info: 	<generic name="MEM_IF_BOARD_BASE_DELAY" value="10" />
-- Retrieval info: 	<generic name="MEM_IF_SIM_VALID_WINDOW" value="0" />
-- Retrieval info: 	<generic name="MEM_GUARANTEED_WRITE_INIT" value="false" />
-- Retrieval info: 	<generic name="MEM_VERBOSE" value="true" />
-- Retrieval info: 	<generic name="PINGPONGPHY_EN" value="false" />
-- Retrieval info: 	<generic name="DUPLICATE_AC" value="false" />
-- Retrieval info: 	<generic name="REFRESH_BURST_VALIDATION" value="false" />
-- Retrieval info: 	<generic name="AP_MODE_EN" value="0" />
-- Retrieval info: 	<generic name="AP_MODE" value="false" />
-- Retrieval info: 	<generic name="MEM_BL" value="4" />
-- Retrieval info: 	<generic name="MEM_BT" value="Sequential" />
-- Retrieval info: 	<generic name="MEM_ASR" value="Manual" />
-- Retrieval info: 	<generic name="MEM_SRT" value="2x refresh rate" />
-- Retrieval info: 	<generic name="MEM_PD" value="Fast exit" />
-- Retrieval info: 	<generic name="MEM_DRV_STR" value="Full" />
-- Retrieval info: 	<generic name="MEM_DLL_EN" value="true" />
-- Retrieval info: 	<generic name="MEM_RTT_NOM" value="50" />
-- Retrieval info: 	<generic name="MEM_ATCL" value="0" />
-- Retrieval info: 	<generic name="MEM_TCL" value="6" />
-- Retrieval info: 	<generic name="MEM_AUTO_LEVELING_MODE" value="true" />
-- Retrieval info: 	<generic name="MEM_USER_LEVELING_MODE" value="Leveling" />
-- Retrieval info: 	<generic name="MEM_INIT_EN" value="false" />
-- Retrieval info: 	<generic name="MEM_INIT_FILE" value="" />
-- Retrieval info: 	<generic name="DAT_DATA_WIDTH" value="32" />
-- Retrieval info: 	<generic name="TIMING_TIS" value="375" />
-- Retrieval info: 	<generic name="TIMING_TIH" value="500" />
-- Retrieval info: 	<generic name="TIMING_TDS" value="250" />
-- Retrieval info: 	<generic name="TIMING_TDH" value="300" />
-- Retrieval info: 	<generic name="TIMING_TDQSQ" value="200" />
-- Retrieval info: 	<generic name="TIMING_TQHS" value="300" />
-- Retrieval info: 	<generic name="TIMING_TDQSCK" value="350" />
-- Retrieval info: 	<generic name="TIMING_TDQSCKDS" value="450" />
-- Retrieval info: 	<generic name="TIMING_TDQSCKDM" value="900" />
-- Retrieval info: 	<generic name="TIMING_TDQSCKDL" value="1200" />
-- Retrieval info: 	<generic name="TIMING_TDQSS" value="0.25" />
-- Retrieval info: 	<generic name="TIMING_TDQSH" value="0.35" />
-- Retrieval info: 	<generic name="TIMING_TDSH" value="0.2" />
-- Retrieval info: 	<generic name="TIMING_TDSS" value="0.2" />
-- Retrieval info: 	<generic name="MEM_TINIT_US" value="200" />
-- Retrieval info: 	<generic name="MEM_TMRD_CK" value="5" />
-- Retrieval info: 	<generic name="MEM_TRAS_NS" value="40.0" />
-- Retrieval info: 	<generic name="MEM_TRCD_NS" value="15.0" />
-- Retrieval info: 	<generic name="MEM_TRP_NS" value="15.0" />
-- Retrieval info: 	<generic name="MEM_TREFI_US" value="7.8" />
-- Retrieval info: 	<generic name="MEM_TRFC_NS" value="127.5" />
-- Retrieval info: 	<generic name="CFG_TCCD_NS" value="2.5" />
-- Retrieval info: 	<generic name="MEM_TWR_NS" value="15.0" />
-- Retrieval info: 	<generic name="MEM_TWTR" value="3" />
-- Retrieval info: 	<generic name="MEM_TFAW_NS" value="37.5" />
-- Retrieval info: 	<generic name="MEM_TRRD_NS" value="7.5" />
-- Retrieval info: 	<generic name="MEM_TRTP_NS" value="7.5" />
-- Retrieval info: 	<generic name="SYS_INFO_DEVICE_FAMILY" value="Stratix IV" />
-- Retrieval info: 	<generic name="PARSE_FRIENDLY_DEVICE_FAMILY_PARAM_VALID" value="false" />
-- Retrieval info: 	<generic name="PARSE_FRIENDLY_DEVICE_FAMILY_PARAM" value="" />
-- Retrieval info: 	<generic name="DEVICE_FAMILY_PARAM" value="" />
-- Retrieval info: 	<generic name="SPEED_GRADE" value="2" />
-- Retrieval info: 	<generic name="IS_ES_DEVICE" value="false" />
-- Retrieval info: 	<generic name="DISABLE_CHILD_MESSAGING" value="false" />
-- Retrieval info: 	<generic name="HARD_EMIF" value="false" />
-- Retrieval info: 	<generic name="HHP_HPS" value="false" />
-- Retrieval info: 	<generic name="HHP_HPS_VERIFICATION" value="false" />
-- Retrieval info: 	<generic name="HHP_HPS_SIMULATION" value="false" />
-- Retrieval info: 	<generic name="HPS_PROTOCOL" value="DEFAULT" />
-- Retrieval info: 	<generic name="CUT_NEW_FAMILY_TIMING" value="true" />
-- Retrieval info: 	<generic name="POWER_OF_TWO_BUS" value="false" />
-- Retrieval info: 	<generic name="SOPC_COMPAT_RESET" value="false" />
-- Retrieval info: 	<generic name="AVL_MAX_SIZE" value="8" />
-- Retrieval info: 	<generic name="BYTE_ENABLE" value="true" />
-- Retrieval info: 	<generic name="ENABLE_CTRL_AVALON_INTERFACE" value="true" />
-- Retrieval info: 	<generic name="CTL_DEEP_POWERDN_EN" value="false" />
-- Retrieval info: 	<generic name="CTL_SELF_REFRESH_EN" value="false" />
-- Retrieval info: 	<generic name="AUTO_POWERDN_EN" value="false" />
-- Retrieval info: 	<generic name="AUTO_PD_CYCLES" value="0" />
-- Retrieval info: 	<generic name="CTL_USR_REFRESH_EN" value="false" />
-- Retrieval info: 	<generic name="CTL_AUTOPCH_EN" value="false" />
-- Retrieval info: 	<generic name="CTL_ZQCAL_EN" value="false" />
-- Retrieval info: 	<generic name="ADDR_ORDER" value="0" />
-- Retrieval info: 	<generic name="CTL_LOOK_AHEAD_DEPTH" value="4" />
-- Retrieval info: 	<generic name="CONTROLLER_LATENCY" value="5" />
-- Retrieval info: 	<generic name="CFG_REORDER_DATA" value="false" />
-- Retrieval info: 	<generic name="STARVE_LIMIT" value="10" />
-- Retrieval info: 	<generic name="CTL_CSR_ENABLED" value="false" />
-- Retrieval info: 	<generic name="CTL_CSR_CONNECTION" value="INTERNAL_JTAG" />
-- Retrieval info: 	<generic name="CTL_ECC_ENABLED" value="false" />
-- Retrieval info: 	<generic name="CTL_HRB_ENABLED" value="false" />
-- Retrieval info: 	<generic name="CTL_ECC_AUTO_CORRECTION_ENABLED" value="false" />
-- Retrieval info: 	<generic name="MULTICAST_EN" value="false" />
-- Retrieval info: 	<generic name="CTL_DYNAMIC_BANK_ALLOCATION" value="false" />
-- Retrieval info: 	<generic name="CTL_DYNAMIC_BANK_NUM" value="4" />
-- Retrieval info: 	<generic name="DEBUG_MODE" value="false" />
-- Retrieval info: 	<generic name="ENABLE_BURST_MERGE" value="false" />
-- Retrieval info: 	<generic name="CTL_ENABLE_BURST_INTERRUPT" value="true" />
-- Retrieval info: 	<generic name="CTL_ENABLE_BURST_TERMINATE" value="true" />
-- Retrieval info: 	<generic name="LOCAL_ID_WIDTH" value="8" />
-- Retrieval info: 	<generic name="WRBUFFER_ADDR_WIDTH" value="6" />
-- Retrieval info: 	<generic name="MAX_PENDING_WR_CMD" value="8" />
-- Retrieval info: 	<generic name="MAX_PENDING_RD_CMD" value="16" />
-- Retrieval info: 	<generic name="USE_MM_ADAPTOR" value="true" />
-- Retrieval info: 	<generic name="USE_AXI_ADAPTOR" value="false" />
-- Retrieval info: 	<generic name="HCX_COMPAT_MODE" value="false" />
-- Retrieval info: 	<generic name="CTL_CMD_QUEUE_DEPTH" value="8" />
-- Retrieval info: 	<generic name="CTL_CSR_READ_ONLY" value="1" />
-- Retrieval info: 	<generic name="CFG_DATA_REORDERING_TYPE" value="INTER_BANK" />
-- Retrieval info: 	<generic name="NUM_OF_PORTS" value="1" />
-- Retrieval info: 	<generic name="ENABLE_BONDING" value="false" />
-- Retrieval info: 	<generic name="ENABLE_USER_ECC" value="false" />
-- Retrieval info: 	<generic name="AVL_DATA_WIDTH_PORT" value="32,32,32,32,32,32" />
-- Retrieval info: 	<generic name="PRIORITY_PORT" value="1,1,1,1,1,1" />
-- Retrieval info: 	<generic name="WEIGHT_PORT" value="0,0,0,0,0,0" />
-- Retrieval info: 	<generic name="CPORT_TYPE_PORT" value="Bidirectional,Bidirectional,Bidirectional,Bidirectional,Bidirectional,Bidirectional" />
-- Retrieval info: 	<generic name="ENABLE_EMIT_BFM_MASTER" value="false" />
-- Retrieval info: 	<generic name="FORCE_SEQUENCER_TCL_DEBUG_MODE" value="false" />
-- Retrieval info: 	<generic name="ENABLE_SEQUENCER_MARGINING_ON_BY_DEFAULT" value="false" />
-- Retrieval info: 	<generic name="REF_CLK_FREQ" value="50.0" />
-- Retrieval info: 	<generic name="REF_CLK_FREQ_PARAM_VALID" value="false" />
-- Retrieval info: 	<generic name="REF_CLK_FREQ_MIN_PARAM" value="0.0" />
-- Retrieval info: 	<generic name="REF_CLK_FREQ_MAX_PARAM" value="0.0" />
-- Retrieval info: 	<generic name="PLL_DR_CLK_FREQ_PARAM" value="0.0" />
-- Retrieval info: 	<generic name="PLL_DR_CLK_FREQ_SIM_STR_PARAM" value="" />
-- Retrieval info: 	<generic name="PLL_DR_CLK_PHASE_PS_PARAM" value="0" />
-- Retrieval info: 	<generic name="PLL_DR_CLK_PHASE_PS_SIM_STR_PARAM" value="" />
-- Retrieval info: 	<generic name="PLL_DR_CLK_MULT_PARAM" value="0" />
-- Retrieval info: 	<generic name="PLL_DR_CLK_DIV_PARAM" value="0" />
-- Retrieval info: 	<generic name="PLL_MEM_CLK_FREQ_PARAM" value="0.0" />
-- Retrieval info: 	<generic name="PLL_MEM_CLK_FREQ_SIM_STR_PARAM" value="" />
-- Retrieval info: 	<generic name="PLL_MEM_CLK_PHASE_PS_PARAM" value="0" />
-- Retrieval info: 	<generic name="PLL_MEM_CLK_PHASE_PS_SIM_STR_PARAM" value="" />
-- Retrieval info: 	<generic name="PLL_MEM_CLK_MULT_PARAM" value="0" />
-- Retrieval info: 	<generic name="PLL_MEM_CLK_DIV_PARAM" value="0" />
-- Retrieval info: 	<generic name="PLL_AFI_CLK_FREQ_PARAM" value="0.0" />
-- Retrieval info: 	<generic name="PLL_AFI_CLK_FREQ_SIM_STR_PARAM" value="" />
-- Retrieval info: 	<generic name="PLL_AFI_CLK_PHASE_PS_PARAM" value="0" />
-- Retrieval info: 	<generic name="PLL_AFI_CLK_PHASE_PS_SIM_STR_PARAM" value="" />
-- Retrieval info: 	<generic name="PLL_AFI_CLK_MULT_PARAM" value="0" />
-- Retrieval info: 	<generic name="PLL_AFI_CLK_DIV_PARAM" value="0" />
-- Retrieval info: 	<generic name="PLL_WRITE_CLK_FREQ_PARAM" value="0.0" />
-- Retrieval info: 	<generic name="PLL_WRITE_CLK_FREQ_SIM_STR_PARAM" value="" />
-- Retrieval info: 	<generic name="PLL_WRITE_CLK_PHASE_PS_PARAM" value="0" />
-- Retrieval info: 	<generic name="PLL_WRITE_CLK_PHASE_PS_SIM_STR_PARAM" value="" />
-- Retrieval info: 	<generic name="PLL_WRITE_CLK_MULT_PARAM" value="0" />
-- Retrieval info: 	<generic name="PLL_WRITE_CLK_DIV_PARAM" value="0" />
-- Retrieval info: 	<generic name="PLL_ADDR_CMD_CLK_FREQ_PARAM" value="0.0" />
-- Retrieval info: 	<generic name="PLL_ADDR_CMD_CLK_FREQ_SIM_STR_PARAM" value="" />
-- Retrieval info: 	<generic name="PLL_ADDR_CMD_CLK_PHASE_PS_PARAM" value="0" />
-- Retrieval info: 	<generic name="PLL_ADDR_CMD_CLK_PHASE_PS_SIM_STR_PARAM" value="" />
-- Retrieval info: 	<generic name="PLL_ADDR_CMD_CLK_MULT_PARAM" value="0" />
-- Retrieval info: 	<generic name="PLL_ADDR_CMD_CLK_DIV_PARAM" value="0" />
-- Retrieval info: 	<generic name="PLL_AFI_HALF_CLK_FREQ_PARAM" value="0.0" />
-- Retrieval info: 	<generic name="PLL_AFI_HALF_CLK_FREQ_SIM_STR_PARAM" value="" />
-- Retrieval info: 	<generic name="PLL_AFI_HALF_CLK_PHASE_PS_PARAM" value="0" />
-- Retrieval info: 	<generic name="PLL_AFI_HALF_CLK_PHASE_PS_SIM_STR_PARAM" value="" />
-- Retrieval info: 	<generic name="PLL_AFI_HALF_CLK_MULT_PARAM" value="0" />
-- Retrieval info: 	<generic name="PLL_AFI_HALF_CLK_DIV_PARAM" value="0" />
-- Retrieval info: 	<generic name="PLL_NIOS_CLK_FREQ_PARAM" value="0.0" />
-- Retrieval info: 	<generic name="PLL_NIOS_CLK_FREQ_SIM_STR_PARAM" value="" />
-- Retrieval info: 	<generic name="PLL_NIOS_CLK_PHASE_PS_PARAM" value="0" />
-- Retrieval info: 	<generic name="PLL_NIOS_CLK_PHASE_PS_SIM_STR_PARAM" value="" />
-- Retrieval info: 	<generic name="PLL_NIOS_CLK_MULT_PARAM" value="0" />
-- Retrieval info: 	<generic name="PLL_NIOS_CLK_DIV_PARAM" value="0" />
-- Retrieval info: 	<generic name="PLL_CONFIG_CLK_FREQ_PARAM" value="0.0" />
-- Retrieval info: 	<generic name="PLL_CONFIG_CLK_FREQ_SIM_STR_PARAM" value="" />
-- Retrieval info: 	<generic name="PLL_CONFIG_CLK_PHASE_PS_PARAM" value="0" />
-- Retrieval info: 	<generic name="PLL_CONFIG_CLK_PHASE_PS_SIM_STR_PARAM" value="" />
-- Retrieval info: 	<generic name="PLL_CONFIG_CLK_MULT_PARAM" value="0" />
-- Retrieval info: 	<generic name="PLL_CONFIG_CLK_DIV_PARAM" value="0" />
-- Retrieval info: 	<generic name="PLL_P2C_READ_CLK_FREQ_PARAM" value="0.0" />
-- Retrieval info: 	<generic name="PLL_P2C_READ_CLK_FREQ_SIM_STR_PARAM" value="" />
-- Retrieval info: 	<generic name="PLL_P2C_READ_CLK_PHASE_PS_PARAM" value="0" />
-- Retrieval info: 	<generic name="PLL_P2C_READ_CLK_PHASE_PS_SIM_STR_PARAM" value="" />
-- Retrieval info: 	<generic name="PLL_P2C_READ_CLK_MULT_PARAM" value="0" />
-- Retrieval info: 	<generic name="PLL_P2C_READ_CLK_DIV_PARAM" value="0" />
-- Retrieval info: 	<generic name="PLL_C2P_WRITE_CLK_FREQ_PARAM" value="0.0" />
-- Retrieval info: 	<generic name="PLL_C2P_WRITE_CLK_FREQ_SIM_STR_PARAM" value="" />
-- Retrieval info: 	<generic name="PLL_C2P_WRITE_CLK_PHASE_PS_PARAM" value="0" />
-- Retrieval info: 	<generic name="PLL_C2P_WRITE_CLK_PHASE_PS_SIM_STR_PARAM" value="" />
-- Retrieval info: 	<generic name="PLL_C2P_WRITE_CLK_MULT_PARAM" value="0" />
-- Retrieval info: 	<generic name="PLL_C2P_WRITE_CLK_DIV_PARAM" value="0" />
-- Retrieval info: 	<generic name="PLL_HR_CLK_FREQ_PARAM" value="0.0" />
-- Retrieval info: 	<generic name="PLL_HR_CLK_FREQ_SIM_STR_PARAM" value="" />
-- Retrieval info: 	<generic name="PLL_HR_CLK_PHASE_PS_PARAM" value="0" />
-- Retrieval info: 	<generic name="PLL_HR_CLK_PHASE_PS_SIM_STR_PARAM" value="" />
-- Retrieval info: 	<generic name="PLL_HR_CLK_MULT_PARAM" value="0" />
-- Retrieval info: 	<generic name="PLL_HR_CLK_DIV_PARAM" value="0" />
-- Retrieval info: 	<generic name="PLL_AFI_PHY_CLK_FREQ_PARAM" value="0.0" />
-- Retrieval info: 	<generic name="PLL_AFI_PHY_CLK_FREQ_SIM_STR_PARAM" value="" />
-- Retrieval info: 	<generic name="PLL_AFI_PHY_CLK_PHASE_PS_PARAM" value="0" />
-- Retrieval info: 	<generic name="PLL_AFI_PHY_CLK_PHASE_PS_SIM_STR_PARAM" value="" />
-- Retrieval info: 	<generic name="PLL_AFI_PHY_CLK_MULT_PARAM" value="0" />
-- Retrieval info: 	<generic name="PLL_AFI_PHY_CLK_DIV_PARAM" value="0" />
-- Retrieval info: 	<generic name="PLL_CLK_PARAM_VALID" value="false" />
-- Retrieval info: 	<generic name="ENABLE_EXTRA_REPORTING" value="false" />
-- Retrieval info: 	<generic name="NUM_EXTRA_REPORT_PATH" value="10" />
-- Retrieval info: 	<generic name="ENABLE_ISS_PROBES" value="false" />
-- Retrieval info: 	<generic name="CALIB_REG_WIDTH" value="8" />
-- Retrieval info: 	<generic name="USE_SEQUENCER_BFM" value="false" />
-- Retrieval info: 	<generic name="PLL_SHARING_MODE" value="None" />
-- Retrieval info: 	<generic name="NUM_PLL_SHARING_INTERFACES" value="1" />
-- Retrieval info: 	<generic name="EXPORT_AFI_HALF_CLK" value="false" />
-- Retrieval info: 	<generic name="ABSTRACT_REAL_COMPARE_TEST" value="false" />
-- Retrieval info: 	<generic name="INCLUDE_BOARD_DELAY_MODEL" value="false" />
-- Retrieval info: 	<generic name="INCLUDE_MULTIRANK_BOARD_DELAY_MODEL" value="false" />
-- Retrieval info: 	<generic name="USE_FAKE_PHY" value="false" />
-- Retrieval info: 	<generic name="FORCE_MAX_LATENCY_COUNT_WIDTH" value="0" />
-- Retrieval info: 	<generic name="ENABLE_NON_DESTRUCTIVE_CALIB" value="false" />
-- Retrieval info: 	<generic name="ENABLE_DELAY_CHAIN_WRITE" value="false" />
-- Retrieval info: 	<generic name="TRACKING_ERROR_TEST" value="false" />
-- Retrieval info: 	<generic name="TRACKING_WATCH_TEST" value="false" />
-- Retrieval info: 	<generic name="MARGIN_VARIATION_TEST" value="false" />
-- Retrieval info: 	<generic name="AC_ROM_USER_ADD_0" value="0_0000_0000_0000" />
-- Retrieval info: 	<generic name="AC_ROM_USER_ADD_1" value="0_0000_0000_1000" />
-- Retrieval info: 	<generic name="TREFI" value="35100" />
-- Retrieval info: 	<generic name="REFRESH_INTERVAL" value="15000" />
-- Retrieval info: 	<generic name="ENABLE_NON_DES_CAL_TEST" value="false" />
-- Retrieval info: 	<generic name="TRFC" value="350" />
-- Retrieval info: 	<generic name="ENABLE_NON_DES_CAL" value="false" />
-- Retrieval info: 	<generic name="EXTRA_SETTINGS" value="" />
-- Retrieval info: 	<generic name="MEM_DEVICE" value="MISSING_MODEL" />
-- Retrieval info: 	<generic name="FORCE_SYNTHESIS_LANGUAGE" value="" />
-- Retrieval info: 	<generic name="FORCED_NUM_WRITE_FR_CYCLE_SHIFTS" value="0" />
-- Retrieval info: 	<generic name="SEQUENCER_TYPE" value="NIOS" />
-- Retrieval info: 	<generic name="ADVERTIZE_SEQUENCER_SW_BUILD_FILES" value="false" />
-- Retrieval info: 	<generic name="FORCED_NON_LDC_ADDR_CMD_MEM_CK_INVERT" value="false" />
-- Retrieval info: 	<generic name="PHY_ONLY" value="true" />
-- Retrieval info: 	<generic name="SEQ_MODE" value="0" />
-- Retrieval info: 	<generic name="ADVANCED_CK_PHASES" value="false" />
-- Retrieval info: 	<generic name="COMMAND_PHASE" value="0.0" />
-- Retrieval info: 	<generic name="MEM_CK_PHASE" value="0.0" />
-- Retrieval info: 	<generic name="P2C_READ_CLOCK_ADD_PHASE" value="0.0" />
-- Retrieval info: 	<generic name="C2P_WRITE_CLOCK_ADD_PHASE" value="0.0" />
-- Retrieval info: 	<generic name="ACV_PHY_CLK_ADD_FR_PHASE" value="0.0" />
-- Retrieval info: 	<generic name="PLL_LOCATION" value="Top_Bottom" />
-- Retrieval info: 	<generic name="SKIP_MEM_INIT" value="true" />
-- Retrieval info: 	<generic name="READ_DQ_DQS_CLOCK_SOURCE" value="INVERTED_DQS_BUS" />
-- Retrieval info: 	<generic name="DQ_INPUT_REG_USE_CLKN" value="false" />
-- Retrieval info: 	<generic name="DQS_DQSN_MODE" value="DIFFERENTIAL" />
-- Retrieval info: 	<generic name="AFI_DEBUG_INFO_WIDTH" value="32" />
-- Retrieval info: 	<generic name="CALIBRATION_MODE" value="Skip" />
-- Retrieval info: 	<generic name="NIOS_ROM_DATA_WIDTH" value="32" />
-- Retrieval info: 	<generic name="READ_FIFO_SIZE" value="8" />
-- Retrieval info: 	<generic name="PHY_CSR_ENABLED" value="false" />
-- Retrieval info: 	<generic name="PHY_CSR_CONNECTION" value="INTERNAL_JTAG" />
-- Retrieval info: 	<generic name="USER_DEBUG_LEVEL" value="0" />
-- Retrieval info: 	<generic name="TIMING_BOARD_DERATE_METHOD" value="AUTO" />
-- Retrieval info: 	<generic name="TIMING_BOARD_CK_CKN_SLEW_RATE" value="2.0" />
-- Retrieval info: 	<generic name="TIMING_BOARD_AC_SLEW_RATE" value="1.0" />
-- Retrieval info: 	<generic name="TIMING_BOARD_DQS_DQSN_SLEW_RATE" value="2.0" />
-- Retrieval info: 	<generic name="TIMING_BOARD_DQ_SLEW_RATE" value="1.0" />
-- Retrieval info: 	<generic name="TIMING_BOARD_TIS" value="0.0" />
-- Retrieval info: 	<generic name="TIMING_BOARD_TIH" value="0.0" />
-- Retrieval info: 	<generic name="TIMING_BOARD_TDS" value="0.0" />
-- Retrieval info: 	<generic name="TIMING_BOARD_TDH" value="0.0" />
-- Retrieval info: 	<generic name="TIMING_BOARD_ISI_METHOD" value="AUTO" />
-- Retrieval info: 	<generic name="TIMING_BOARD_AC_EYE_REDUCTION_SU" value="0.0" />
-- Retrieval info: 	<generic name="TIMING_BOARD_AC_EYE_REDUCTION_H" value="0.0" />
-- Retrieval info: 	<generic name="TIMING_BOARD_DQ_EYE_REDUCTION" value="0.0" />
-- Retrieval info: 	<generic name="TIMING_BOARD_DELTA_DQS_ARRIVAL_TIME" value="0.0" />
-- Retrieval info: 	<generic name="TIMING_BOARD_READ_DQ_EYE_REDUCTION" value="0.0" />
-- Retrieval info: 	<generic name="TIMING_BOARD_DELTA_READ_DQS_ARRIVAL_TIME" value="0.0" />
-- Retrieval info: 	<generic name="PACKAGE_DESKEW" value="false" />
-- Retrieval info: 	<generic name="AC_PACKAGE_DESKEW" value="false" />
-- Retrieval info: 	<generic name="TIMING_BOARD_MAX_CK_DELAY" value="0.6" />
-- Retrieval info: 	<generic name="TIMING_BOARD_MAX_DQS_DELAY" value="0.6" />
-- Retrieval info: 	<generic name="TIMING_BOARD_SKEW_CKDQS_DIMM_MIN" value="-0.01" />
-- Retrieval info: 	<generic name="TIMING_BOARD_SKEW_CKDQS_DIMM_MAX" value="0.01" />
-- Retrieval info: 	<generic name="TIMING_BOARD_SKEW_BETWEEN_DIMMS" value="0.05" />
-- Retrieval info: 	<generic name="TIMING_BOARD_SKEW_WITHIN_DQS" value="0.02" />
-- Retrieval info: 	<generic name="TIMING_BOARD_SKEW_BETWEEN_DQS" value="0.02" />
-- Retrieval info: 	<generic name="TIMING_BOARD_DQ_TO_DQS_SKEW" value="0.0" />
-- Retrieval info: 	<generic name="TIMING_BOARD_AC_SKEW" value="0.02" />
-- Retrieval info: 	<generic name="TIMING_BOARD_AC_TO_CK_SKEW" value="0.6" />
-- Retrieval info: 	<generic name="ENABLE_EXPORT_SEQ_DEBUG_BRIDGE" value="false" />
-- Retrieval info: 	<generic name="CORE_DEBUG_CONNECTION" value="EXPORT" />
-- Retrieval info: 	<generic name="ADD_EXTERNAL_SEQ_DEBUG_NIOS" value="false" />
-- Retrieval info: 	<generic name="ED_EXPORT_SEQ_DEBUG" value="false" />
-- Retrieval info: 	<generic name="ADD_EFFICIENCY_MONITOR" value="false" />
-- Retrieval info: 	<generic name="ENABLE_ABS_RAM_MEM_INIT" value="false" />
-- Retrieval info: 	<generic name="ABS_RAM_MEM_INIT_FILENAME" value="meminit" />
-- Retrieval info: 	<generic name="DLL_SHARING_MODE" value="None" />
-- Retrieval info: 	<generic name="NUM_DLL_SHARING_INTERFACES" value="1" />
-- Retrieval info: 	<generic name="OCT_SHARING_MODE" value="None" />
-- Retrieval info: 	<generic name="NUM_OCT_SHARING_INTERFACES" value="1" />
-- Retrieval info: 	<generic name="AUTO_DEVICE" value="Unknown" />
-- Retrieval info: 	<generic name="AUTO_DEVICE_SPEEDGRADE" value="Unknown" />
-- Retrieval info: </instance>
-- IPFS_FILES : uniphy.vho
-- RELATED_FILES: uniphy.vhd, uniphy_0002.v, uniphy_pll0.sv, uniphy_p0_clock_pair_generator.v, uniphy_p0_read_valid_selector.v, uniphy_p0_addr_cmd_datapath.v, uniphy_p0_reset.v, uniphy_p0_acv_ldc.v, uniphy_p0_memphy.sv, uniphy_p0_reset_sync.v, uniphy_p0_new_io_pads.v, uniphy_p0_fr_cycle_shifter.v, uniphy_p0_fr_cycle_extender.v, uniphy_p0_read_datapath.sv, uniphy_p0_write_datapath.v, uniphy_p0_simple_ddio_out.sv, uniphy_p0_phy_csr.sv, uniphy_p0_iss_probe.v, uniphy_p0_addr_cmd_pads.v, uniphy_p0_flop_mem.v, uniphy_p0.sv, uniphy_p0_altdqdqs.v, altdq_dqs2_ddio_3reg_stratixiv.sv, afi_mux_ddrx.v, uniphy_s0.v, altera_mem_if_sequencer_rst.sv, altera_mem_if_sequencer_cpu_no_ifdef_params_synth_cpu_inst.v, altera_mem_if_sequencer_cpu_no_ifdef_params_synth_cpu_inst_test_bench.v, sequencer_scc_mgr.sv, sequencer_scc_siii_wrapper.sv, sequencer_scc_siii_phase_decode.v, sequencer_scc_sv_wrapper.sv, sequencer_scc_sv_phase_decode.v, sequencer_scc_acv_wrapper.sv, sequencer_scc_acv_phase_decode.v, sequencer_scc_reg_file.v, sequencer_reg_file.sv, sequencer_phy_mgr.sv, sequencer_data_mgr.sv, rw_manager_ddr2.v, rw_manager_ac_ROM_reg.v, rw_manager_bitcheck.v, rw_manager_core.sv, rw_manager_data_broadcast.v, rw_manager_data_decoder.v, rw_manager_datamux.v, rw_manager_di_buffer.v, rw_manager_di_buffer_wrap.v, rw_manager_dm_decoder.v, rw_manager_generic.sv, rw_manager_inst_ROM_reg.v, rw_manager_jumplogic.v, rw_manager_lfsr72.v, rw_manager_lfsr36.v, rw_manager_lfsr12.v, rw_manager_pattern_fifo.v, rw_manager_ram.v, rw_manager_ram_csr.v, rw_manager_read_datapath.v, rw_manager_write_decoder.v, rw_manager_ac_ROM_no_ifdef_params.v, rw_manager_inst_ROM_no_ifdef_params.v, altera_mem_if_sequencer_mem_no_ifdef_params.sv, uniphy_s0_mm_interconnect_0.v, uniphy_s0_irq_mapper.sv, altera_merlin_master_translator.sv, altera_merlin_slave_translator.sv, altera_merlin_master_agent.sv, altera_merlin_slave_agent.sv, altera_merlin_burst_uncompressor.sv, altera_avalon_sc_fifo.v, uniphy_s0_mm_interconnect_0_router.sv, uniphy_s0_mm_interconnect_0_router_001.sv, uniphy_s0_mm_interconnect_0_router_002.sv, uniphy_s0_mm_interconnect_0_router_005.sv, uniphy_s0_mm_interconnect_0_cmd_demux.sv, uniphy_s0_mm_interconnect_0_cmd_demux_001.sv, altera_merlin_arbitrator.sv, uniphy_s0_mm_interconnect_0_cmd_mux.sv, uniphy_s0_mm_interconnect_0_cmd_mux_003.sv, uniphy_s0_mm_interconnect_0_rsp_demux_003.sv, uniphy_s0_mm_interconnect_0_rsp_mux.sv, uniphy_s0_mm_interconnect_0_rsp_mux_001.sv, uniphy_s0_mm_interconnect_0_avalon_st_adapter.v, uniphy_s0_mm_interconnect_0_avalon_st_adapter_error_adapter_0.sv, altera_mem_if_oct_stratixiv.sv, altera_mem_if_dll_stratixiv.sv
