-- megafunction wizard: %DDR2 SDRAM Controller with UniPHY v13.1%
-- GENERATION: XML
-- ddr2ctrl.vhd

-- Generated using ACDS version 13.1 162 at 2014.03.03.20:01:23

library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.numeric_std.all;

entity ddr2ctrl is
	port (
		pll_ref_clk        : in    std_logic                      := '0';             --      pll_ref_clk.clk
		global_reset_n     : in    std_logic                      := '0';             --     global_reset.reset_n
		soft_reset_n       : in    std_logic                      := '0';             --       soft_reset.reset_n
		afi_clk            : out   std_logic;                                         --          afi_clk.clk
		afi_half_clk       : out   std_logic;                                         --     afi_half_clk.clk
		afi_reset_n        : out   std_logic;                                         --        afi_reset.reset_n
		afi_reset_export_n : out   std_logic;                                         -- afi_reset_export.reset_n
		mem_a              : out   std_logic_vector(13 downto 0);                     --           memory.mem_a
		mem_ba             : out   std_logic_vector(2 downto 0);                      --                 .mem_ba
		mem_ck             : out   std_logic_vector(1 downto 0);                      --                 .mem_ck
		mem_ck_n           : out   std_logic_vector(1 downto 0);                      --                 .mem_ck_n
		mem_cke            : out   std_logic_vector(0 downto 0);                      --                 .mem_cke
		mem_cs_n           : out   std_logic_vector(0 downto 0);                      --                 .mem_cs_n
		mem_dm             : out   std_logic_vector(7 downto 0);                      --                 .mem_dm
		mem_ras_n          : out   std_logic_vector(0 downto 0);                      --                 .mem_ras_n
		mem_cas_n          : out   std_logic_vector(0 downto 0);                      --                 .mem_cas_n
		mem_we_n           : out   std_logic_vector(0 downto 0);                      --                 .mem_we_n
		mem_dq             : inout std_logic_vector(63 downto 0)  := (others => '0'); --                 .mem_dq
		mem_dqs            : inout std_logic_vector(7 downto 0)   := (others => '0'); --                 .mem_dqs
		mem_dqs_n          : inout std_logic_vector(7 downto 0)   := (others => '0'); --                 .mem_dqs_n
		mem_odt            : out   std_logic_vector(0 downto 0);                      --                 .mem_odt
		avl_ready          : out   std_logic;                                         --              avl.waitrequest_n
		avl_burstbegin     : in    std_logic                      := '0';             --                 .beginbursttransfer
		avl_addr           : in    std_logic_vector(24 downto 0)  := (others => '0'); --                 .address
		avl_rdata_valid    : out   std_logic;                                         --                 .readdatavalid
		avl_rdata          : out   std_logic_vector(255 downto 0);                    --                 .readdata
		avl_wdata          : in    std_logic_vector(255 downto 0) := (others => '0'); --                 .writedata
		avl_be             : in    std_logic_vector(31 downto 0)  := (others => '0'); --                 .byteenable
		avl_read_req       : in    std_logic                      := '0';             --                 .read
		avl_write_req      : in    std_logic                      := '0';             --                 .write
		avl_size           : in    std_logic_vector(3 downto 0)   := (others => '0'); --                 .burstcount
		local_init_done    : out   std_logic;                                         --           status.local_init_done
		local_cal_success  : out   std_logic;                                         --                 .local_cal_success
		local_cal_fail     : out   std_logic;                                         --                 .local_cal_fail
		oct_rdn            : in    std_logic                      := '0';             --              oct.rdn
		oct_rup            : in    std_logic                      := '0'              --                 .rup
	);
end entity ddr2ctrl;

architecture rtl of ddr2ctrl is
	component ddr2ctrl_0002 is
		port (
			pll_ref_clk        : in    std_logic                      := 'X';             -- clk
			global_reset_n     : in    std_logic                      := 'X';             -- reset_n
			soft_reset_n       : in    std_logic                      := 'X';             -- reset_n
			afi_clk            : out   std_logic;                                         -- clk
			afi_half_clk       : out   std_logic;                                         -- clk
			afi_reset_n        : out   std_logic;                                         -- reset_n
			afi_reset_export_n : out   std_logic;                                         -- reset_n
			mem_a              : out   std_logic_vector(13 downto 0);                     -- mem_a
			mem_ba             : out   std_logic_vector(2 downto 0);                      -- mem_ba
			mem_ck             : out   std_logic_vector(1 downto 0);                      -- mem_ck
			mem_ck_n           : out   std_logic_vector(1 downto 0);                      -- mem_ck_n
			mem_cke            : out   std_logic_vector(0 downto 0);                      -- mem_cke
			mem_cs_n           : out   std_logic_vector(0 downto 0);                      -- mem_cs_n
			mem_dm             : out   std_logic_vector(7 downto 0);                      -- mem_dm
			mem_ras_n          : out   std_logic_vector(0 downto 0);                      -- mem_ras_n
			mem_cas_n          : out   std_logic_vector(0 downto 0);                      -- mem_cas_n
			mem_we_n           : out   std_logic_vector(0 downto 0);                      -- mem_we_n
			mem_dq             : inout std_logic_vector(63 downto 0)  := (others => 'X'); -- mem_dq
			mem_dqs            : inout std_logic_vector(7 downto 0)   := (others => 'X'); -- mem_dqs
			mem_dqs_n          : inout std_logic_vector(7 downto 0)   := (others => 'X'); -- mem_dqs_n
			mem_odt            : out   std_logic_vector(0 downto 0);                      -- mem_odt
			avl_ready          : out   std_logic;                                         -- waitrequest_n
			avl_burstbegin     : in    std_logic                      := 'X';             -- beginbursttransfer
			avl_addr           : in    std_logic_vector(24 downto 0)  := (others => 'X'); -- address
			avl_rdata_valid    : out   std_logic;                                         -- readdatavalid
			avl_rdata          : out   std_logic_vector(255 downto 0);                    -- readdata
			avl_wdata          : in    std_logic_vector(255 downto 0) := (others => 'X'); -- writedata
			avl_be             : in    std_logic_vector(31 downto 0)  := (others => 'X'); -- byteenable
			avl_read_req       : in    std_logic                      := 'X';             -- read
			avl_write_req      : in    std_logic                      := 'X';             -- write
			avl_size           : in    std_logic_vector(3 downto 0)   := (others => 'X'); -- burstcount
			local_init_done    : out   std_logic;                                         -- local_init_done
			local_cal_success  : out   std_logic;                                         -- local_cal_success
			local_cal_fail     : out   std_logic;                                         -- local_cal_fail
			oct_rdn            : in    std_logic                      := 'X';             -- rdn
			oct_rup            : in    std_logic                      := 'X'              -- rup
		);
	end component ddr2ctrl_0002;

begin

	ddr2ctrl_inst : component ddr2ctrl_0002
		port map (
			pll_ref_clk        => pll_ref_clk,        --      pll_ref_clk.clk
			global_reset_n     => global_reset_n,     --     global_reset.reset_n
			soft_reset_n       => soft_reset_n,       --       soft_reset.reset_n
			afi_clk            => afi_clk,            --          afi_clk.clk
			afi_half_clk       => afi_half_clk,       --     afi_half_clk.clk
			afi_reset_n        => afi_reset_n,        --        afi_reset.reset_n
			afi_reset_export_n => afi_reset_export_n, -- afi_reset_export.reset_n
			mem_a              => mem_a,              --           memory.mem_a
			mem_ba             => mem_ba,             --                 .mem_ba
			mem_ck             => mem_ck,             --                 .mem_ck
			mem_ck_n           => mem_ck_n,           --                 .mem_ck_n
			mem_cke            => mem_cke,            --                 .mem_cke
			mem_cs_n           => mem_cs_n,           --                 .mem_cs_n
			mem_dm             => mem_dm,             --                 .mem_dm
			mem_ras_n          => mem_ras_n,          --                 .mem_ras_n
			mem_cas_n          => mem_cas_n,          --                 .mem_cas_n
			mem_we_n           => mem_we_n,           --                 .mem_we_n
			mem_dq             => mem_dq,             --                 .mem_dq
			mem_dqs            => mem_dqs,            --                 .mem_dqs
			mem_dqs_n          => mem_dqs_n,          --                 .mem_dqs_n
			mem_odt            => mem_odt,            --                 .mem_odt
			avl_ready          => avl_ready,          --              avl.waitrequest_n
			avl_burstbegin     => avl_burstbegin,     --                 .beginbursttransfer
			avl_addr           => avl_addr,           --                 .address
			avl_rdata_valid    => avl_rdata_valid,    --                 .readdatavalid
			avl_rdata          => avl_rdata,          --                 .readdata
			avl_wdata          => avl_wdata,          --                 .writedata
			avl_be             => avl_be,             --                 .byteenable
			avl_read_req       => avl_read_req,       --                 .read
			avl_write_req      => avl_write_req,      --                 .write
			avl_size           => avl_size,           --                 .burstcount
			local_init_done    => local_init_done,    --           status.local_init_done
			local_cal_success  => local_cal_success,  --                 .local_cal_success
			local_cal_fail     => local_cal_fail,     --                 .local_cal_fail
			oct_rdn            => oct_rdn,            --              oct.rdn
			oct_rup            => oct_rup             --                 .rup
		);

end architecture rtl; -- of ddr2ctrl
-- Retrieval info: <?xml version="1.0"?>
--<!--
--	Generated by Altera MegaWizard Launcher Utility version 1.0
--	************************************************************
--	THIS IS A WIZARD-GENERATED FILE. DO NOT EDIT THIS FILE!
--	************************************************************
--	Copyright (C) 1991-2014 Altera Corporation
--	Any megafunction design, and related net list (encrypted or decrypted),
--	support information, device programming or simulation file, and any other
--	associated documentation or information provided by Altera or a partner
--	under Altera's Megafunction Partnership Program may be used only to
--	program PLD devices (but not masked PLD devices) from Altera.  Any other
--	use of such megafunction design, net list, support information, device
--	programming or simulation file, or any other related documentation or
--	information is prohibited for any other purpose, including, but not
--	limited to modification, reverse engineering, de-compiling, or use with
--	any other silicon devices, unless such use is explicitly licensed under
--	a separate agreement with Altera or a megafunction partner.  Title to
--	the intellectual property, including patents, copyrights, trademarks,
--	trade secrets, or maskworks, embodied in any such megafunction design,
--	net list, support information, device programming or simulation file, or
--	any other related documentation or information provided by Altera or a
--	megafunction partner, remains with Altera, the megafunction partner, or
--	their respective licensors.  No other licenses, including any licenses
--	needed under any third party's intellectual property, are provided herein.
---->
-- Retrieval info: <instance entity-name="altera_mem_if_ddr2_emif" version="13.1" >
-- Retrieval info: 	<generic name="RATE" value="Half" />
-- Retrieval info: 	<generic name="MEM_CLK_FREQ" value="400.0" />
-- Retrieval info: 	<generic name="USE_MEM_CLK_FREQ" value="false" />
-- Retrieval info: 	<generic name="FORCE_DQS_TRACKING" value="AUTO" />
-- Retrieval info: 	<generic name="FORCE_SHADOW_REGS" value="AUTO" />
-- Retrieval info: 	<generic name="MRS_MIRROR_PING_PONG_ATSO" value="false" />
-- Retrieval info: 	<generic name="MEM_VENDOR" value="Micron" />
-- Retrieval info: 	<generic name="MEM_FORMAT" value="UNBUFFERED" />
-- Retrieval info: 	<generic name="DISCRETE_FLY_BY" value="true" />
-- Retrieval info: 	<generic name="DEVICE_DEPTH" value="1" />
-- Retrieval info: 	<generic name="MEM_MIRROR_ADDRESSING" value="0" />
-- Retrieval info: 	<generic name="MEM_CLK_FREQ_MAX" value="400.0" />
-- Retrieval info: 	<generic name="MEM_ROW_ADDR_WIDTH" value="14" />
-- Retrieval info: 	<generic name="MEM_COL_ADDR_WIDTH" value="10" />
-- Retrieval info: 	<generic name="MEM_DQ_WIDTH" value="64" />
-- Retrieval info: 	<generic name="MEM_DQ_PER_DQS" value="8" />
-- Retrieval info: 	<generic name="MEM_BANKADDR_WIDTH" value="3" />
-- Retrieval info: 	<generic name="MEM_IF_DM_PINS_EN" value="true" />
-- Retrieval info: 	<generic name="MEM_IF_DQSN_EN" value="true" />
-- Retrieval info: 	<generic name="MEM_NUMBER_OF_DIMMS" value="1" />
-- Retrieval info: 	<generic name="MEM_NUMBER_OF_RANKS_PER_DIMM" value="1" />
-- Retrieval info: 	<generic name="MEM_NUMBER_OF_RANKS_PER_DEVICE" value="1" />
-- Retrieval info: 	<generic name="MEM_RANK_MULTIPLICATION_FACTOR" value="1" />
-- Retrieval info: 	<generic name="MEM_CK_WIDTH" value="2" />
-- Retrieval info: 	<generic name="MEM_CS_WIDTH" value="1" />
-- Retrieval info: 	<generic name="MEM_CLK_EN_WIDTH" value="1" />
-- Retrieval info: 	<generic name="ALTMEMPHY_COMPATIBLE_MODE" value="false" />
-- Retrieval info: 	<generic name="NEXTGEN" value="true" />
-- Retrieval info: 	<generic name="MEM_IF_BOARD_BASE_DELAY" value="10" />
-- Retrieval info: 	<generic name="MEM_IF_SIM_VALID_WINDOW" value="0" />
-- Retrieval info: 	<generic name="MEM_GUARANTEED_WRITE_INIT" value="false" />
-- Retrieval info: 	<generic name="MEM_VERBOSE" value="true" />
-- Retrieval info: 	<generic name="PINGPONGPHY_EN" value="false" />
-- Retrieval info: 	<generic name="REFRESH_BURST_VALIDATION" value="false" />
-- Retrieval info: 	<generic name="MEM_BL" value="8" />
-- Retrieval info: 	<generic name="MEM_BT" value="Sequential" />
-- Retrieval info: 	<generic name="MEM_ASR" value="Manual" />
-- Retrieval info: 	<generic name="MEM_SRT" value="2x refresh rate" />
-- Retrieval info: 	<generic name="MEM_PD" value="Fast exit" />
-- Retrieval info: 	<generic name="MEM_DRV_STR" value="Full" />
-- Retrieval info: 	<generic name="MEM_DLL_EN" value="true" />
-- Retrieval info: 	<generic name="MEM_RTT_NOM" value="50" />
-- Retrieval info: 	<generic name="MEM_ATCL" value="0" />
-- Retrieval info: 	<generic name="MEM_TCL" value="6" />
-- Retrieval info: 	<generic name="MEM_AUTO_LEVELING_MODE" value="true" />
-- Retrieval info: 	<generic name="MEM_USER_LEVELING_MODE" value="Leveling" />
-- Retrieval info: 	<generic name="MEM_INIT_EN" value="false" />
-- Retrieval info: 	<generic name="MEM_INIT_FILE" value="" />
-- Retrieval info: 	<generic name="DAT_DATA_WIDTH" value="32" />
-- Retrieval info: 	<generic name="TIMING_TIS" value="375" />
-- Retrieval info: 	<generic name="TIMING_TIH" value="500" />
-- Retrieval info: 	<generic name="TIMING_TDS" value="250" />
-- Retrieval info: 	<generic name="TIMING_TDH" value="300" />
-- Retrieval info: 	<generic name="TIMING_TDQSQ" value="200" />
-- Retrieval info: 	<generic name="TIMING_TQHS" value="300" />
-- Retrieval info: 	<generic name="TIMING_TDQSCK" value="350" />
-- Retrieval info: 	<generic name="TIMING_TDQSCKDS" value="450" />
-- Retrieval info: 	<generic name="TIMING_TDQSCKDM" value="900" />
-- Retrieval info: 	<generic name="TIMING_TDQSCKDL" value="1200" />
-- Retrieval info: 	<generic name="TIMING_TDQSS" value="0.25" />
-- Retrieval info: 	<generic name="TIMING_TDQSH" value="0.35" />
-- Retrieval info: 	<generic name="TIMING_TDSH" value="0.2" />
-- Retrieval info: 	<generic name="TIMING_TDSS" value="0.2" />
-- Retrieval info: 	<generic name="MEM_TINIT_US" value="200" />
-- Retrieval info: 	<generic name="MEM_TMRD_CK" value="5" />
-- Retrieval info: 	<generic name="MEM_TRAS_NS" value="40.0" />
-- Retrieval info: 	<generic name="MEM_TRCD_NS" value="15.0" />
-- Retrieval info: 	<generic name="MEM_TRP_NS" value="15.0" />
-- Retrieval info: 	<generic name="MEM_TREFI_US" value="7.8" />
-- Retrieval info: 	<generic name="MEM_TRFC_NS" value="127.5" />
-- Retrieval info: 	<generic name="CFG_TCCD_NS" value="2.5" />
-- Retrieval info: 	<generic name="MEM_TWR_NS" value="15.0" />
-- Retrieval info: 	<generic name="MEM_TWTR" value="3" />
-- Retrieval info: 	<generic name="MEM_TFAW_NS" value="37.5" />
-- Retrieval info: 	<generic name="MEM_TRRD_NS" value="7.5" />
-- Retrieval info: 	<generic name="MEM_TRTP_NS" value="7.5" />
-- Retrieval info: 	<generic name="SYS_INFO_DEVICE_FAMILY" value="Stratix IV" />
-- Retrieval info: 	<generic name="PARSE_FRIENDLY_DEVICE_FAMILY_PARAM_VALID" value="false" />
-- Retrieval info: 	<generic name="PARSE_FRIENDLY_DEVICE_FAMILY_PARAM" value="" />
-- Retrieval info: 	<generic name="DEVICE_FAMILY_PARAM" value="" />
-- Retrieval info: 	<generic name="SPEED_GRADE" value="2" />
-- Retrieval info: 	<generic name="IS_ES_DEVICE" value="false" />
-- Retrieval info: 	<generic name="DISABLE_CHILD_MESSAGING" value="false" />
-- Retrieval info: 	<generic name="HARD_EMIF" value="false" />
-- Retrieval info: 	<generic name="HHP_HPS" value="false" />
-- Retrieval info: 	<generic name="HHP_HPS_VERIFICATION" value="false" />
-- Retrieval info: 	<generic name="HHP_HPS_SIMULATION" value="false" />
-- Retrieval info: 	<generic name="HPS_PROTOCOL" value="DEFAULT" />
-- Retrieval info: 	<generic name="CUT_NEW_FAMILY_TIMING" value="true" />
-- Retrieval info: 	<generic name="POWER_OF_TWO_BUS" value="false" />
-- Retrieval info: 	<generic name="SOPC_COMPAT_RESET" value="false" />
-- Retrieval info: 	<generic name="AVL_MAX_SIZE" value="8" />
-- Retrieval info: 	<generic name="BYTE_ENABLE" value="true" />
-- Retrieval info: 	<generic name="ENABLE_CTRL_AVALON_INTERFACE" value="true" />
-- Retrieval info: 	<generic name="CTL_DEEP_POWERDN_EN" value="false" />
-- Retrieval info: 	<generic name="CTL_SELF_REFRESH_EN" value="false" />
-- Retrieval info: 	<generic name="AUTO_POWERDN_EN" value="false" />
-- Retrieval info: 	<generic name="AUTO_PD_CYCLES" value="0" />
-- Retrieval info: 	<generic name="CTL_USR_REFRESH_EN" value="false" />
-- Retrieval info: 	<generic name="CTL_AUTOPCH_EN" value="false" />
-- Retrieval info: 	<generic name="CTL_ZQCAL_EN" value="false" />
-- Retrieval info: 	<generic name="ADDR_ORDER" value="0" />
-- Retrieval info: 	<generic name="CTL_LOOK_AHEAD_DEPTH" value="4" />
-- Retrieval info: 	<generic name="CONTROLLER_LATENCY" value="5" />
-- Retrieval info: 	<generic name="CFG_REORDER_DATA" value="false" />
-- Retrieval info: 	<generic name="STARVE_LIMIT" value="10" />
-- Retrieval info: 	<generic name="CTL_CSR_ENABLED" value="false" />
-- Retrieval info: 	<generic name="CTL_CSR_CONNECTION" value="INTERNAL_JTAG" />
-- Retrieval info: 	<generic name="CTL_ECC_ENABLED" value="false" />
-- Retrieval info: 	<generic name="CTL_HRB_ENABLED" value="false" />
-- Retrieval info: 	<generic name="CTL_ECC_AUTO_CORRECTION_ENABLED" value="false" />
-- Retrieval info: 	<generic name="MULTICAST_EN" value="false" />
-- Retrieval info: 	<generic name="CTL_DYNAMIC_BANK_ALLOCATION" value="false" />
-- Retrieval info: 	<generic name="CTL_DYNAMIC_BANK_NUM" value="4" />
-- Retrieval info: 	<generic name="DEBUG_MODE" value="false" />
-- Retrieval info: 	<generic name="ENABLE_BURST_MERGE" value="false" />
-- Retrieval info: 	<generic name="CTL_ENABLE_BURST_INTERRUPT" value="true" />
-- Retrieval info: 	<generic name="CTL_ENABLE_BURST_TERMINATE" value="true" />
-- Retrieval info: 	<generic name="LOCAL_ID_WIDTH" value="8" />
-- Retrieval info: 	<generic name="WRBUFFER_ADDR_WIDTH" value="6" />
-- Retrieval info: 	<generic name="MAX_PENDING_WR_CMD" value="8" />
-- Retrieval info: 	<generic name="MAX_PENDING_RD_CMD" value="16" />
-- Retrieval info: 	<generic name="USE_MM_ADAPTOR" value="true" />
-- Retrieval info: 	<generic name="USE_AXI_ADAPTOR" value="false" />
-- Retrieval info: 	<generic name="HCX_COMPAT_MODE" value="false" />
-- Retrieval info: 	<generic name="CTL_CMD_QUEUE_DEPTH" value="8" />
-- Retrieval info: 	<generic name="CTL_CSR_READ_ONLY" value="1" />
-- Retrieval info: 	<generic name="CFG_DATA_REORDERING_TYPE" value="INTER_BANK" />
-- Retrieval info: 	<generic name="NUM_OF_PORTS" value="1" />
-- Retrieval info: 	<generic name="ENABLE_BONDING" value="false" />
-- Retrieval info: 	<generic name="ENABLE_USER_ECC" value="false" />
-- Retrieval info: 	<generic name="AVL_DATA_WIDTH_PORT" value="32,32,32,32,32,32" />
-- Retrieval info: 	<generic name="PRIORITY_PORT" value="1,1,1,1,1,1" />
-- Retrieval info: 	<generic name="WEIGHT_PORT" value="0,0,0,0,0,0" />
-- Retrieval info: 	<generic name="CPORT_TYPE_PORT" value="Bidirectional,Bidirectional,Bidirectional,Bidirectional,Bidirectional,Bidirectional" />
-- Retrieval info: 	<generic name="ENABLE_EMIT_BFM_MASTER" value="false" />
-- Retrieval info: 	<generic name="FORCE_SEQUENCER_TCL_DEBUG_MODE" value="false" />
-- Retrieval info: 	<generic name="ENABLE_SEQUENCER_MARGINING_ON_BY_DEFAULT" value="false" />
-- Retrieval info: 	<generic name="REF_CLK_FREQ" value="50.0" />
-- Retrieval info: 	<generic name="REF_CLK_FREQ_PARAM_VALID" value="false" />
-- Retrieval info: 	<generic name="REF_CLK_FREQ_MIN_PARAM" value="0.0" />
-- Retrieval info: 	<generic name="REF_CLK_FREQ_MAX_PARAM" value="0.0" />
-- Retrieval info: 	<generic name="PLL_DR_CLK_FREQ_PARAM" value="0.0" />
-- Retrieval info: 	<generic name="PLL_DR_CLK_FREQ_SIM_STR_PARAM" value="" />
-- Retrieval info: 	<generic name="PLL_DR_CLK_PHASE_PS_PARAM" value="0" />
-- Retrieval info: 	<generic name="PLL_DR_CLK_PHASE_PS_SIM_STR_PARAM" value="" />
-- Retrieval info: 	<generic name="PLL_DR_CLK_MULT_PARAM" value="0" />
-- Retrieval info: 	<generic name="PLL_DR_CLK_DIV_PARAM" value="0" />
-- Retrieval info: 	<generic name="PLL_MEM_CLK_FREQ_PARAM" value="0.0" />
-- Retrieval info: 	<generic name="PLL_MEM_CLK_FREQ_SIM_STR_PARAM" value="" />
-- Retrieval info: 	<generic name="PLL_MEM_CLK_PHASE_PS_PARAM" value="0" />
-- Retrieval info: 	<generic name="PLL_MEM_CLK_PHASE_PS_SIM_STR_PARAM" value="" />
-- Retrieval info: 	<generic name="PLL_MEM_CLK_MULT_PARAM" value="0" />
-- Retrieval info: 	<generic name="PLL_MEM_CLK_DIV_PARAM" value="0" />
-- Retrieval info: 	<generic name="PLL_AFI_CLK_FREQ_PARAM" value="0.0" />
-- Retrieval info: 	<generic name="PLL_AFI_CLK_FREQ_SIM_STR_PARAM" value="" />
-- Retrieval info: 	<generic name="PLL_AFI_CLK_PHASE_PS_PARAM" value="0" />
-- Retrieval info: 	<generic name="PLL_AFI_CLK_PHASE_PS_SIM_STR_PARAM" value="" />
-- Retrieval info: 	<generic name="PLL_AFI_CLK_MULT_PARAM" value="0" />
-- Retrieval info: 	<generic name="PLL_AFI_CLK_DIV_PARAM" value="0" />
-- Retrieval info: 	<generic name="PLL_WRITE_CLK_FREQ_PARAM" value="0.0" />
-- Retrieval info: 	<generic name="PLL_WRITE_CLK_FREQ_SIM_STR_PARAM" value="" />
-- Retrieval info: 	<generic name="PLL_WRITE_CLK_PHASE_PS_PARAM" value="0" />
-- Retrieval info: 	<generic name="PLL_WRITE_CLK_PHASE_PS_SIM_STR_PARAM" value="" />
-- Retrieval info: 	<generic name="PLL_WRITE_CLK_MULT_PARAM" value="0" />
-- Retrieval info: 	<generic name="PLL_WRITE_CLK_DIV_PARAM" value="0" />
-- Retrieval info: 	<generic name="PLL_ADDR_CMD_CLK_FREQ_PARAM" value="0.0" />
-- Retrieval info: 	<generic name="PLL_ADDR_CMD_CLK_FREQ_SIM_STR_PARAM" value="" />
-- Retrieval info: 	<generic name="PLL_ADDR_CMD_CLK_PHASE_PS_PARAM" value="0" />
-- Retrieval info: 	<generic name="PLL_ADDR_CMD_CLK_PHASE_PS_SIM_STR_PARAM" value="" />
-- Retrieval info: 	<generic name="PLL_ADDR_CMD_CLK_MULT_PARAM" value="0" />
-- Retrieval info: 	<generic name="PLL_ADDR_CMD_CLK_DIV_PARAM" value="0" />
-- Retrieval info: 	<generic name="PLL_AFI_HALF_CLK_FREQ_PARAM" value="0.0" />
-- Retrieval info: 	<generic name="PLL_AFI_HALF_CLK_FREQ_SIM_STR_PARAM" value="" />
-- Retrieval info: 	<generic name="PLL_AFI_HALF_CLK_PHASE_PS_PARAM" value="0" />
-- Retrieval info: 	<generic name="PLL_AFI_HALF_CLK_PHASE_PS_SIM_STR_PARAM" value="" />
-- Retrieval info: 	<generic name="PLL_AFI_HALF_CLK_MULT_PARAM" value="0" />
-- Retrieval info: 	<generic name="PLL_AFI_HALF_CLK_DIV_PARAM" value="0" />
-- Retrieval info: 	<generic name="PLL_NIOS_CLK_FREQ_PARAM" value="0.0" />
-- Retrieval info: 	<generic name="PLL_NIOS_CLK_FREQ_SIM_STR_PARAM" value="" />
-- Retrieval info: 	<generic name="PLL_NIOS_CLK_PHASE_PS_PARAM" value="0" />
-- Retrieval info: 	<generic name="PLL_NIOS_CLK_PHASE_PS_SIM_STR_PARAM" value="" />
-- Retrieval info: 	<generic name="PLL_NIOS_CLK_MULT_PARAM" value="0" />
-- Retrieval info: 	<generic name="PLL_NIOS_CLK_DIV_PARAM" value="0" />
-- Retrieval info: 	<generic name="PLL_CONFIG_CLK_FREQ_PARAM" value="0.0" />
-- Retrieval info: 	<generic name="PLL_CONFIG_CLK_FREQ_SIM_STR_PARAM" value="" />
-- Retrieval info: 	<generic name="PLL_CONFIG_CLK_PHASE_PS_PARAM" value="0" />
-- Retrieval info: 	<generic name="PLL_CONFIG_CLK_PHASE_PS_SIM_STR_PARAM" value="" />
-- Retrieval info: 	<generic name="PLL_CONFIG_CLK_MULT_PARAM" value="0" />
-- Retrieval info: 	<generic name="PLL_CONFIG_CLK_DIV_PARAM" value="0" />
-- Retrieval info: 	<generic name="PLL_P2C_READ_CLK_FREQ_PARAM" value="0.0" />
-- Retrieval info: 	<generic name="PLL_P2C_READ_CLK_FREQ_SIM_STR_PARAM" value="" />
-- Retrieval info: 	<generic name="PLL_P2C_READ_CLK_PHASE_PS_PARAM" value="0" />
-- Retrieval info: 	<generic name="PLL_P2C_READ_CLK_PHASE_PS_SIM_STR_PARAM" value="" />
-- Retrieval info: 	<generic name="PLL_P2C_READ_CLK_MULT_PARAM" value="0" />
-- Retrieval info: 	<generic name="PLL_P2C_READ_CLK_DIV_PARAM" value="0" />
-- Retrieval info: 	<generic name="PLL_C2P_WRITE_CLK_FREQ_PARAM" value="0.0" />
-- Retrieval info: 	<generic name="PLL_C2P_WRITE_CLK_FREQ_SIM_STR_PARAM" value="" />
-- Retrieval info: 	<generic name="PLL_C2P_WRITE_CLK_PHASE_PS_PARAM" value="0" />
-- Retrieval info: 	<generic name="PLL_C2P_WRITE_CLK_PHASE_PS_SIM_STR_PARAM" value="" />
-- Retrieval info: 	<generic name="PLL_C2P_WRITE_CLK_MULT_PARAM" value="0" />
-- Retrieval info: 	<generic name="PLL_C2P_WRITE_CLK_DIV_PARAM" value="0" />
-- Retrieval info: 	<generic name="PLL_HR_CLK_FREQ_PARAM" value="0.0" />
-- Retrieval info: 	<generic name="PLL_HR_CLK_FREQ_SIM_STR_PARAM" value="" />
-- Retrieval info: 	<generic name="PLL_HR_CLK_PHASE_PS_PARAM" value="0" />
-- Retrieval info: 	<generic name="PLL_HR_CLK_PHASE_PS_SIM_STR_PARAM" value="" />
-- Retrieval info: 	<generic name="PLL_HR_CLK_MULT_PARAM" value="0" />
-- Retrieval info: 	<generic name="PLL_HR_CLK_DIV_PARAM" value="0" />
-- Retrieval info: 	<generic name="PLL_AFI_PHY_CLK_FREQ_PARAM" value="0.0" />
-- Retrieval info: 	<generic name="PLL_AFI_PHY_CLK_FREQ_SIM_STR_PARAM" value="" />
-- Retrieval info: 	<generic name="PLL_AFI_PHY_CLK_PHASE_PS_PARAM" value="0" />
-- Retrieval info: 	<generic name="PLL_AFI_PHY_CLK_PHASE_PS_SIM_STR_PARAM" value="" />
-- Retrieval info: 	<generic name="PLL_AFI_PHY_CLK_MULT_PARAM" value="0" />
-- Retrieval info: 	<generic name="PLL_AFI_PHY_CLK_DIV_PARAM" value="0" />
-- Retrieval info: 	<generic name="PLL_CLK_PARAM_VALID" value="false" />
-- Retrieval info: 	<generic name="ENABLE_EXTRA_REPORTING" value="false" />
-- Retrieval info: 	<generic name="NUM_EXTRA_REPORT_PATH" value="10" />
-- Retrieval info: 	<generic name="ENABLE_ISS_PROBES" value="false" />
-- Retrieval info: 	<generic name="CALIB_REG_WIDTH" value="8" />
-- Retrieval info: 	<generic name="USE_SEQUENCER_BFM" value="false" />
-- Retrieval info: 	<generic name="DEFAULT_FAST_SIM_MODEL" value="true" />
-- Retrieval info: 	<generic name="PLL_SHARING_MODE" value="None" />
-- Retrieval info: 	<generic name="NUM_PLL_SHARING_INTERFACES" value="1" />
-- Retrieval info: 	<generic name="EXPORT_AFI_HALF_CLK" value="false" />
-- Retrieval info: 	<generic name="ABSTRACT_REAL_COMPARE_TEST" value="false" />
-- Retrieval info: 	<generic name="INCLUDE_BOARD_DELAY_MODEL" value="false" />
-- Retrieval info: 	<generic name="INCLUDE_MULTIRANK_BOARD_DELAY_MODEL" value="false" />
-- Retrieval info: 	<generic name="USE_FAKE_PHY" value="false" />
-- Retrieval info: 	<generic name="FORCE_MAX_LATENCY_COUNT_WIDTH" value="0" />
-- Retrieval info: 	<generic name="ENABLE_NON_DESTRUCTIVE_CALIB" value="false" />
-- Retrieval info: 	<generic name="TRACKING_ERROR_TEST" value="false" />
-- Retrieval info: 	<generic name="TRACKING_WATCH_TEST" value="false" />
-- Retrieval info: 	<generic name="MARGIN_VARIATION_TEST" value="false" />
-- Retrieval info: 	<generic name="EXTRA_SETTINGS" value="" />
-- Retrieval info: 	<generic name="MEM_DEVICE" value="MISSING_MODEL" />
-- Retrieval info: 	<generic name="FORCE_SYNTHESIS_LANGUAGE" value="" />
-- Retrieval info: 	<generic name="FORCED_NUM_WRITE_FR_CYCLE_SHIFTS" value="0" />
-- Retrieval info: 	<generic name="SEQUENCER_TYPE" value="NIOS" />
-- Retrieval info: 	<generic name="ADVERTIZE_SEQUENCER_SW_BUILD_FILES" value="false" />
-- Retrieval info: 	<generic name="FORCED_NON_LDC_ADDR_CMD_MEM_CK_INVERT" value="false" />
-- Retrieval info: 	<generic name="PHY_ONLY" value="false" />
-- Retrieval info: 	<generic name="SEQ_MODE" value="0" />
-- Retrieval info: 	<generic name="ADVANCED_CK_PHASES" value="false" />
-- Retrieval info: 	<generic name="COMMAND_PHASE" value="0.0" />
-- Retrieval info: 	<generic name="MEM_CK_PHASE" value="0.0" />
-- Retrieval info: 	<generic name="P2C_READ_CLOCK_ADD_PHASE" value="0.0" />
-- Retrieval info: 	<generic name="C2P_WRITE_CLOCK_ADD_PHASE" value="0.0" />
-- Retrieval info: 	<generic name="ACV_PHY_CLK_ADD_FR_PHASE" value="0.0" />
-- Retrieval info: 	<generic name="PLL_LOCATION" value="Top_Bottom" />
-- Retrieval info: 	<generic name="SKIP_MEM_INIT" value="true" />
-- Retrieval info: 	<generic name="READ_DQ_DQS_CLOCK_SOURCE" value="INVERTED_DQS_BUS" />
-- Retrieval info: 	<generic name="DQ_INPUT_REG_USE_CLKN" value="false" />
-- Retrieval info: 	<generic name="DQS_DQSN_MODE" value="DIFFERENTIAL" />
-- Retrieval info: 	<generic name="AFI_DEBUG_INFO_WIDTH" value="32" />
-- Retrieval info: 	<generic name="CALIBRATION_MODE" value="Skip" />
-- Retrieval info: 	<generic name="NIOS_ROM_DATA_WIDTH" value="32" />
-- Retrieval info: 	<generic name="READ_FIFO_SIZE" value="8" />
-- Retrieval info: 	<generic name="PHY_CSR_ENABLED" value="false" />
-- Retrieval info: 	<generic name="PHY_CSR_CONNECTION" value="INTERNAL_JTAG" />
-- Retrieval info: 	<generic name="USER_DEBUG_LEVEL" value="1" />
-- Retrieval info: 	<generic name="TIMING_BOARD_DERATE_METHOD" value="AUTO" />
-- Retrieval info: 	<generic name="TIMING_BOARD_CK_CKN_SLEW_RATE" value="2.0" />
-- Retrieval info: 	<generic name="TIMING_BOARD_AC_SLEW_RATE" value="1.0" />
-- Retrieval info: 	<generic name="TIMING_BOARD_DQS_DQSN_SLEW_RATE" value="2.0" />
-- Retrieval info: 	<generic name="TIMING_BOARD_DQ_SLEW_RATE" value="1.0" />
-- Retrieval info: 	<generic name="TIMING_BOARD_TIS" value="0.0" />
-- Retrieval info: 	<generic name="TIMING_BOARD_TIH" value="0.0" />
-- Retrieval info: 	<generic name="TIMING_BOARD_TDS" value="0.0" />
-- Retrieval info: 	<generic name="TIMING_BOARD_TDH" value="0.0" />
-- Retrieval info: 	<generic name="TIMING_BOARD_ISI_METHOD" value="AUTO" />
-- Retrieval info: 	<generic name="TIMING_BOARD_AC_EYE_REDUCTION_SU" value="0.0" />
-- Retrieval info: 	<generic name="TIMING_BOARD_AC_EYE_REDUCTION_H" value="0.0" />
-- Retrieval info: 	<generic name="TIMING_BOARD_DQ_EYE_REDUCTION" value="0.0" />
-- Retrieval info: 	<generic name="TIMING_BOARD_DELTA_DQS_ARRIVAL_TIME" value="0.0" />
-- Retrieval info: 	<generic name="TIMING_BOARD_READ_DQ_EYE_REDUCTION" value="0.0" />
-- Retrieval info: 	<generic name="TIMING_BOARD_DELTA_READ_DQS_ARRIVAL_TIME" value="0.0" />
-- Retrieval info: 	<generic name="PACKAGE_DESKEW" value="false" />
-- Retrieval info: 	<generic name="AC_PACKAGE_DESKEW" value="false" />
-- Retrieval info: 	<generic name="TIMING_BOARD_MAX_CK_DELAY" value="0.6" />
-- Retrieval info: 	<generic name="TIMING_BOARD_MAX_DQS_DELAY" value="0.6" />
-- Retrieval info: 	<generic name="TIMING_BOARD_SKEW_CKDQS_DIMM_MIN" value="-0.01" />
-- Retrieval info: 	<generic name="TIMING_BOARD_SKEW_CKDQS_DIMM_MAX" value="0.01" />
-- Retrieval info: 	<generic name="TIMING_BOARD_SKEW_BETWEEN_DIMMS" value="0.05" />
-- Retrieval info: 	<generic name="TIMING_BOARD_SKEW_WITHIN_DQS" value="0.02" />
-- Retrieval info: 	<generic name="TIMING_BOARD_SKEW_BETWEEN_DQS" value="0.02" />
-- Retrieval info: 	<generic name="TIMING_BOARD_DQ_TO_DQS_SKEW" value="0.0" />
-- Retrieval info: 	<generic name="TIMING_BOARD_AC_SKEW" value="0.02" />
-- Retrieval info: 	<generic name="TIMING_BOARD_AC_TO_CK_SKEW" value="0.6" />
-- Retrieval info: 	<generic name="ENABLE_EXPORT_SEQ_DEBUG_BRIDGE" value="false" />
-- Retrieval info: 	<generic name="CORE_DEBUG_CONNECTION" value="EXPORT" />
-- Retrieval info: 	<generic name="ADD_EXTERNAL_SEQ_DEBUG_NIOS" value="false" />
-- Retrieval info: 	<generic name="ED_EXPORT_SEQ_DEBUG" value="false" />
-- Retrieval info: 	<generic name="ADD_EFFICIENCY_MONITOR" value="false" />
-- Retrieval info: 	<generic name="ENABLE_ABS_RAM_MEM_INIT" value="false" />
-- Retrieval info: 	<generic name="ABS_RAM_MEM_INIT_FILENAME" value="meminit" />
-- Retrieval info: 	<generic name="DLL_SHARING_MODE" value="None" />
-- Retrieval info: 	<generic name="NUM_DLL_SHARING_INTERFACES" value="1" />
-- Retrieval info: 	<generic name="OCT_SHARING_MODE" value="None" />
-- Retrieval info: 	<generic name="NUM_OCT_SHARING_INTERFACES" value="1" />
-- Retrieval info: 	<generic name="AUTO_DEVICE" value="Unknown" />
-- Retrieval info: </instance>
-- IPFS_FILES : ddr2ctrl.vho
-- RELATED_FILES: ddr2ctrl.vhd, ddr2ctrl_0002.v, ddr2ctrl_pll0.sv, ddr2ctrl_p0_clock_pair_generator.v, ddr2ctrl_p0_read_valid_selector.v, ddr2ctrl_p0_addr_cmd_datapath.v, ddr2ctrl_p0_reset.v, ddr2ctrl_p0_acv_ldc.v, ddr2ctrl_p0_memphy.sv, ddr2ctrl_p0_reset_sync.v, ddr2ctrl_p0_new_io_pads.v, ddr2ctrl_p0_fr_cycle_shifter.v, ddr2ctrl_p0_fr_cycle_extender.v, ddr2ctrl_p0_read_datapath.sv, ddr2ctrl_p0_write_datapath.v, ddr2ctrl_p0_simple_ddio_out.sv, ddr2ctrl_p0_phy_csr.sv, ddr2ctrl_p0_iss_probe.v, ddr2ctrl_p0_addr_cmd_pads.v, ddr2ctrl_p0_flop_mem.v, ddr2ctrl_p0.sv, ddr2ctrl_p0_altdqdqs.v, altdq_dqs2_ddio_3reg_stratixiv.sv, afi_mux_ddrx.v, ddr2ctrl_s0.v, ddr2ctrl_s0_mm_interconnect_0_rsp_xbar_mux_002.sv, ddr2ctrl_s0_mm_interconnect_0_rsp_xbar_mux_001.sv, ddr2ctrl_s0_mm_interconnect_0_rsp_xbar_mux.sv, ddr2ctrl_s0_mm_interconnect_0_rsp_xbar_demux_005.sv, ddr2ctrl_s0_mm_interconnect_0_rsp_xbar_demux_003.sv, ddr2ctrl_s0_mm_interconnect_0_cmd_xbar_mux_005.sv, ddr2ctrl_s0_mm_interconnect_0_cmd_xbar_mux_003.sv, ddr2ctrl_s0_mm_interconnect_0_cmd_xbar_mux.sv, altera_merlin_arbitrator.sv, ddr2ctrl_s0_mm_interconnect_0_cmd_xbar_demux_002.sv, ddr2ctrl_s0_mm_interconnect_0_cmd_xbar_demux_001.sv, ddr2ctrl_s0_mm_interconnect_0_cmd_xbar_demux.sv, altera_merlin_reorder_memory.sv, altera_merlin_traffic_limiter.sv, ddr2ctrl_s0_mm_interconnect_0_id_router_005.sv, ddr2ctrl_s0_mm_interconnect_0_id_router_003.sv, ddr2ctrl_s0_mm_interconnect_0_id_router.sv, ddr2ctrl_s0_mm_interconnect_0_addr_router_002.sv, ddr2ctrl_s0_mm_interconnect_0_addr_router_001.sv, ddr2ctrl_s0_mm_interconnect_0_addr_router.sv, altera_merlin_burst_uncompressor.sv, altera_merlin_slave_agent.sv, altera_merlin_master_agent.sv, ddr2ctrl_s0_irq_mapper.sv, ddr2ctrl_s0_mm_interconnect_0.v, altera_avalon_mm_bridge.v, altera_mem_if_sequencer_mem_no_ifdef_params.sv, rw_manager_inst_ROM_no_ifdef_params.v, rw_manager_ac_ROM_no_ifdef_params.v, rw_manager_write_decoder.v, rw_manager_read_datapath.v, rw_manager_ram_csr.v, rw_manager_ram.v, rw_manager_pattern_fifo.v, rw_manager_lfsr12.v, rw_manager_lfsr36.v, rw_manager_lfsr72.v, rw_manager_jumplogic.v, rw_manager_inst_ROM_reg.v, rw_manager_generic.sv, rw_manager_dm_decoder.v, rw_manager_di_buffer_wrap.v, rw_manager_di_buffer.v, rw_manager_datamux.v, rw_manager_data_decoder.v, rw_manager_data_broadcast.v, rw_manager_core.sv, rw_manager_bitcheck.v, rw_manager_ac_ROM_reg.v, rw_manager_ddr2.v, sequencer_data_mgr.sv, sequencer_phy_mgr.sv, sequencer_reg_file.sv, sequencer_scc_reg_file.v, sequencer_scc_acv_phase_decode.v, sequencer_scc_acv_wrapper.sv, sequencer_scc_sv_phase_decode.v, sequencer_scc_sv_wrapper.sv, sequencer_scc_siii_phase_decode.v, sequencer_scc_siii_wrapper.sv, sequencer_scc_mgr.sv, altera_mem_if_sequencer_cpu_no_ifdef_params_synth_cpu_inst_test_bench.v, altera_mem_if_sequencer_cpu_no_ifdef_params_synth_cpu_inst.v, altera_mem_if_sequencer_rst.sv, ddr2ctrl_dmaster.v, ddr2ctrl_c0.v, altera_mem_if_oct_stratixiv.sv, altera_mem_if_dll_stratixiv.sv, ddr2ctrl_mm_interconnect_0.v, altera_avalon_st_jtag_interface.v, altera_jtag_dc_streaming.v, altera_jtag_sld_node.v, altera_jtag_streaming.v, altera_pli_streaming.v, altera_avalon_st_clock_crosser.v, altera_avalon_st_pipeline_base.v, altera_avalon_st_idle_remover.v, altera_avalon_st_idle_inserter.v, ddr2ctrl_dmaster_timing_adt.v, altera_avalon_sc_fifo.v, altera_avalon_st_bytes_to_packets.v, altera_avalon_st_packets_to_bytes.v, altera_avalon_packets_to_master.v, ddr2ctrl_dmaster_b2p_adapter.v, ddr2ctrl_dmaster_p2b_adapter.v, altera_reset_controller.v, altera_reset_synchronizer.v, alt_mem_ddrx_addr_cmd.v, alt_mem_ddrx_addr_cmd_wrap.v, alt_mem_ddrx_ddr2_odt_gen.v, alt_mem_ddrx_ddr3_odt_gen.v, alt_mem_ddrx_lpddr2_addr_cmd.v, alt_mem_ddrx_odt_gen.v, alt_mem_ddrx_rdwr_data_tmg.v, alt_mem_ddrx_arbiter.v, alt_mem_ddrx_burst_gen.v, alt_mem_ddrx_cmd_gen.v, alt_mem_ddrx_csr.v, alt_mem_ddrx_buffer.v, alt_mem_ddrx_buffer_manager.v, alt_mem_ddrx_burst_tracking.v, alt_mem_ddrx_dataid_manager.v, alt_mem_ddrx_fifo.v, alt_mem_ddrx_list.v, alt_mem_ddrx_rdata_path.v, alt_mem_ddrx_wdata_path.v, alt_mem_ddrx_define.iv, alt_mem_ddrx_ecc_decoder.v, alt_mem_ddrx_ecc_decoder_32_syn.v, alt_mem_ddrx_ecc_decoder_64_syn.v, alt_mem_ddrx_ecc_encoder.v, alt_mem_ddrx_ecc_encoder_32_syn.v, alt_mem_ddrx_ecc_encoder_64_syn.v, alt_mem_ddrx_ecc_encoder_decoder_wrapper.v, alt_mem_ddrx_axi_st_converter.v, alt_mem_ddrx_input_if.v, alt_mem_ddrx_rank_timer.v, alt_mem_ddrx_sideband.v, alt_mem_ddrx_tbp.v, alt_mem_ddrx_timing_param.v, alt_mem_ddrx_controller.v, alt_mem_ddrx_controller_st_top.v, alt_mem_if_nextgen_ddr2_controller_core.sv, alt_mem_ddrx_mm_st_converter.v, altera_merlin_master_translator.sv, altera_merlin_slave_translator.sv

