#
# Clocks
#
# 50 MHz main system clock (generated by internal PLL)
create_clock -name {clkm} -period 20 [get_nets clkm]

# Arbitrarily assign a 10 MHz clock signal on the dedicated JTAG clock pin.
# In practice this clock is completely asynchronous to clkm since it is
# provided by an external debugger/USB-serial converter. And there is an
# internal clock-domain crossing between the clkm and tck clock domains.
# But simply marking the clock domains as asynchronous with a constraint is
# not appropriate because that simply ignores timing between the domains and
# it has been observed that (without timing constraints) Radiant will
# occasionally place the AHBJTAG far enough away from the JTAG macro that the
# routing delay is too large and causes the clock-domain crossing to become
# unreliable.
#
# An alternative could be set_max_delay, but the results were not encouraging.
# Instead we enforce a reasonable timing constraint by setting the TCK frequency
# to be a submultiple of the clkm frequency. In the absence of other constraints,
# Synplify will consider tck and clkm synchronous and find that the worst-case
# separation of two clock edges is one clkm-period and will constrain propagation
# delays to be roughly within one clkm-period in both directions. This should be
# sufficient to make the AHBJTAG clock-domain transition reliable. However, if the
# clkm-frequency is changed, it is important to update the tck-constraint as well
# to keep the tck-frequency a submultiple of the clkm-frequency.
create_clock -name {tck} -period 100 [get_ports tck]

#
# Inputs/Outputs
#
#
# Registers
#
#
# Multicycle Path
#
#
# False Path
#
#
# Attributes
#
#define_global_attribute          syn_useioff {1}
#
# Other Constraints
#

