-- megafunction wizard: %LPDDR2 SDRAM Controller with UniPHY v13.0%
-- GENERATION: XML
-- lpddr2ctrl1.vhd

-- Generated using ACDS version 13.0sp1 232 at 2013.09.05.17:05:47

library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.numeric_std.all;

entity lpddr2ctrl1 is
	port (
		pll_ref_clk               : in    std_logic                     := '0';             --      pll_ref_clk.clk
		global_reset_n            : in    std_logic                     := '0';             --     global_reset.reset_n
		soft_reset_n              : in    std_logic                     := '0';             --       soft_reset.reset_n
		afi_clk                   : out   std_logic;                                        --          afi_clk.clk
		afi_half_clk              : out   std_logic;                                        --     afi_half_clk.clk
		afi_reset_n               : out   std_logic;                                        --        afi_reset.reset_n
		afi_reset_export_n        : out   std_logic;                                        -- afi_reset_export.reset_n
		mem_ca                    : out   std_logic_vector(9 downto 0);                     --           memory.mem_ca
		mem_ck                    : out   std_logic_vector(0 downto 0);                     --                 .mem_ck
		mem_ck_n                  : out   std_logic_vector(0 downto 0);                     --                 .mem_ck_n
		mem_cke                   : out   std_logic_vector(0 downto 0);                     --                 .mem_cke
		mem_cs_n                  : out   std_logic_vector(0 downto 0);                     --                 .mem_cs_n
		mem_dm                    : out   std_logic_vector(1 downto 0);                     --                 .mem_dm
		mem_dq                    : inout std_logic_vector(15 downto 0) := (others => '0'); --                 .mem_dq
		mem_dqs                   : inout std_logic_vector(1 downto 0)  := (others => '0'); --                 .mem_dqs
		mem_dqs_n                 : inout std_logic_vector(1 downto 0)  := (others => '0'); --                 .mem_dqs_n
		avl_ready                 : out   std_logic;                                        --              avl.waitrequest_n
		avl_burstbegin            : in    std_logic                     := '0';             --                 .beginbursttransfer
		avl_addr                  : in    std_logic_vector(24 downto 0) := (others => '0'); --                 .address
		avl_rdata_valid           : out   std_logic;                                        --                 .readdatavalid
		avl_rdata                 : out   std_logic_vector(63 downto 0);                    --                 .readdata
		avl_wdata                 : in    std_logic_vector(63 downto 0) := (others => '0'); --                 .writedata
		avl_be                    : in    std_logic_vector(7 downto 0)  := (others => '0'); --                 .byteenable
		avl_read_req              : in    std_logic                     := '0';             --                 .read
		avl_write_req             : in    std_logic                     := '0';             --                 .write
		avl_size                  : in    std_logic_vector(2 downto 0)  := (others => '0'); --                 .burstcount
		local_init_done           : out   std_logic;                                        --           status.local_init_done
		local_cal_success         : out   std_logic;                                        --                 .local_cal_success
		local_cal_fail            : out   std_logic;                                        --                 .local_cal_fail
		oct_rzqin                 : in    std_logic                     := '0';             --              oct.rzqin
		pll_mem_clk               : out   std_logic;                                        --      pll_sharing.pll_mem_clk
		pll_write_clk             : out   std_logic;                                        --                 .pll_write_clk
		pll_write_clk_pre_phy_clk : out   std_logic;                                        --                 .pll_write_clk_pre_phy_clk
		pll_addr_cmd_clk          : out   std_logic;                                        --                 .pll_addr_cmd_clk
		pll_locked                : out   std_logic;                                        --                 .pll_locked
		pll_avl_clk               : out   std_logic;                                        --                 .pll_avl_clk
		pll_config_clk            : out   std_logic;                                        --                 .pll_config_clk
		pll_mem_phy_clk           : out   std_logic;                                        --                 .pll_mem_phy_clk
		afi_phy_clk               : out   std_logic;                                        --                 .afi_phy_clk
		pll_avl_phy_clk           : out   std_logic                                         --                 .pll_avl_phy_clk
	);
end entity lpddr2ctrl1;

architecture rtl of lpddr2ctrl1 is
	component lpddr2ctrl1_0002 is
		port (
			pll_ref_clk               : in    std_logic                     := 'X';             -- clk
			global_reset_n            : in    std_logic                     := 'X';             -- reset_n
			soft_reset_n              : in    std_logic                     := 'X';             -- reset_n
			afi_clk                   : out   std_logic;                                        -- clk
			afi_half_clk              : out   std_logic;                                        -- clk
			afi_reset_n               : out   std_logic;                                        -- reset_n
			afi_reset_export_n        : out   std_logic;                                        -- reset_n
			mem_ca                    : out   std_logic_vector(9 downto 0);                     -- mem_ca
			mem_ck                    : out   std_logic_vector(0 downto 0);                     -- mem_ck
			mem_ck_n                  : out   std_logic_vector(0 downto 0);                     -- mem_ck_n
			mem_cke                   : out   std_logic_vector(0 downto 0);                     -- mem_cke
			mem_cs_n                  : out   std_logic_vector(0 downto 0);                     -- mem_cs_n
			mem_dm                    : out   std_logic_vector(1 downto 0);                     -- mem_dm
			mem_dq                    : inout std_logic_vector(15 downto 0) := (others => 'X'); -- mem_dq
			mem_dqs                   : inout std_logic_vector(1 downto 0)  := (others => 'X'); -- mem_dqs
			mem_dqs_n                 : inout std_logic_vector(1 downto 0)  := (others => 'X'); -- mem_dqs_n
			avl_ready                 : out   std_logic;                                        -- waitrequest_n
			avl_burstbegin            : in    std_logic                     := 'X';             -- beginbursttransfer
			avl_addr                  : in    std_logic_vector(24 downto 0) := (others => 'X'); -- address
			avl_rdata_valid           : out   std_logic;                                        -- readdatavalid
			avl_rdata                 : out   std_logic_vector(63 downto 0);                    -- readdata
			avl_wdata                 : in    std_logic_vector(63 downto 0) := (others => 'X'); -- writedata
			avl_be                    : in    std_logic_vector(7 downto 0)  := (others => 'X'); -- byteenable
			avl_read_req              : in    std_logic                     := 'X';             -- read
			avl_write_req             : in    std_logic                     := 'X';             -- write
			avl_size                  : in    std_logic_vector(2 downto 0)  := (others => 'X'); -- burstcount
			local_init_done           : out   std_logic;                                        -- local_init_done
			local_cal_success         : out   std_logic;                                        -- local_cal_success
			local_cal_fail            : out   std_logic;                                        -- local_cal_fail
			oct_rzqin                 : in    std_logic                     := 'X';             -- rzqin
			pll_mem_clk               : out   std_logic;                                        -- pll_mem_clk
			pll_write_clk             : out   std_logic;                                        -- pll_write_clk
			pll_write_clk_pre_phy_clk : out   std_logic;                                        -- pll_write_clk_pre_phy_clk
			pll_addr_cmd_clk          : out   std_logic;                                        -- pll_addr_cmd_clk
			pll_locked                : out   std_logic;                                        -- pll_locked
			pll_avl_clk               : out   std_logic;                                        -- pll_avl_clk
			pll_config_clk            : out   std_logic;                                        -- pll_config_clk
			pll_mem_phy_clk           : out   std_logic;                                        -- pll_mem_phy_clk
			afi_phy_clk               : out   std_logic;                                        -- afi_phy_clk
			pll_avl_phy_clk           : out   std_logic                                         -- pll_avl_phy_clk
		);
	end component lpddr2ctrl1_0002;

begin

	lpddr2ctrl1_inst : component lpddr2ctrl1_0002
		port map (
			pll_ref_clk               => pll_ref_clk,               --      pll_ref_clk.clk
			global_reset_n            => global_reset_n,            --     global_reset.reset_n
			soft_reset_n              => soft_reset_n,              --       soft_reset.reset_n
			afi_clk                   => afi_clk,                   --          afi_clk.clk
			afi_half_clk              => afi_half_clk,              --     afi_half_clk.clk
			afi_reset_n               => afi_reset_n,               --        afi_reset.reset_n
			afi_reset_export_n        => afi_reset_export_n,        -- afi_reset_export.reset_n
			mem_ca                    => mem_ca,                    --           memory.mem_ca
			mem_ck                    => mem_ck,                    --                 .mem_ck
			mem_ck_n                  => mem_ck_n,                  --                 .mem_ck_n
			mem_cke                   => mem_cke,                   --                 .mem_cke
			mem_cs_n                  => mem_cs_n,                  --                 .mem_cs_n
			mem_dm                    => mem_dm,                    --                 .mem_dm
			mem_dq                    => mem_dq,                    --                 .mem_dq
			mem_dqs                   => mem_dqs,                   --                 .mem_dqs
			mem_dqs_n                 => mem_dqs_n,                 --                 .mem_dqs_n
			avl_ready                 => avl_ready,                 --              avl.waitrequest_n
			avl_burstbegin            => avl_burstbegin,            --                 .beginbursttransfer
			avl_addr                  => avl_addr,                  --                 .address
			avl_rdata_valid           => avl_rdata_valid,           --                 .readdatavalid
			avl_rdata                 => avl_rdata,                 --                 .readdata
			avl_wdata                 => avl_wdata,                 --                 .writedata
			avl_be                    => avl_be,                    --                 .byteenable
			avl_read_req              => avl_read_req,              --                 .read
			avl_write_req             => avl_write_req,             --                 .write
			avl_size                  => avl_size,                  --                 .burstcount
			local_init_done           => local_init_done,           --           status.local_init_done
			local_cal_success         => local_cal_success,         --                 .local_cal_success
			local_cal_fail            => local_cal_fail,            --                 .local_cal_fail
			oct_rzqin                 => oct_rzqin,                 --              oct.rzqin
			pll_mem_clk               => pll_mem_clk,               --      pll_sharing.pll_mem_clk
			pll_write_clk             => pll_write_clk,             --                 .pll_write_clk
			pll_write_clk_pre_phy_clk => pll_write_clk_pre_phy_clk, --                 .pll_write_clk_pre_phy_clk
			pll_addr_cmd_clk          => pll_addr_cmd_clk,          --                 .pll_addr_cmd_clk
			pll_locked                => pll_locked,                --                 .pll_locked
			pll_avl_clk               => pll_avl_clk,               --                 .pll_avl_clk
			pll_config_clk            => pll_config_clk,            --                 .pll_config_clk
			pll_mem_phy_clk           => pll_mem_phy_clk,           --                 .pll_mem_phy_clk
			afi_phy_clk               => afi_phy_clk,               --                 .afi_phy_clk
			pll_avl_phy_clk           => pll_avl_phy_clk            --                 .pll_avl_phy_clk
		);

end architecture rtl; -- of lpddr2ctrl1
-- Retrieval info: <?xml version="1.0"?>
--<!--
--	Generated by Altera MegaWizard Launcher Utility version 1.0
--	************************************************************
--	THIS IS A WIZARD-GENERATED FILE. DO NOT EDIT THIS FILE!
--	************************************************************
--	Copyright (C) 1991-2013 Altera Corporation
--	Any megafunction design, and related net list (encrypted or decrypted),
--	support information, device programming or simulation file, and any other
--	associated documentation or information provided by Altera or a partner
--	under Altera's Megafunction Partnership Program may be used only to
--	program PLD devices (but not masked PLD devices) from Altera.  Any other
--	use of such megafunction design, net list, support information, device
--	programming or simulation file, or any other related documentation or
--	information is prohibited for any other purpose, including, but not
--	limited to modification, reverse engineering, de-compiling, or use with
--	any other silicon devices, unless such use is explicitly licensed under
--	a separate agreement with Altera or a megafunction partner.  Title to
--	the intellectual property, including patents, copyrights, trademarks,
--	trade secrets, or maskworks, embodied in any such megafunction design,
--	net list, support information, device programming or simulation file, or
--	any other related documentation or information provided by Altera or a
--	megafunction partner, remains with Altera, the megafunction partner, or
--	their respective licensors.  No other licenses, including any licenses
--	needed under any third party's intellectual property, are provided herein.
---->
-- Retrieval info: <instance entity-name="altera_mem_if_lpddr2_emif" version="13.0" >
-- Retrieval info: 	<generic name="MEM_VENDOR" value="Micron" />
-- Retrieval info: 	<generic name="MEM_FORMAT" value="DISCRETE" />
-- Retrieval info: 	<generic name="DISCRETE_FLY_BY" value="true" />
-- Retrieval info: 	<generic name="DEVICE_DEPTH" value="1" />
-- Retrieval info: 	<generic name="MEM_MIRROR_ADDRESSING" value="0" />
-- Retrieval info: 	<generic name="MEM_CLK_FREQ_MAX" value="400.0" />
-- Retrieval info: 	<generic name="MEM_ROW_ADDR_WIDTH" value="14" />
-- Retrieval info: 	<generic name="MEM_COL_ADDR_WIDTH" value="10" />
-- Retrieval info: 	<generic name="MEM_DQ_WIDTH" value="16" />
-- Retrieval info: 	<generic name="MEM_DQ_PER_DQS" value="8" />
-- Retrieval info: 	<generic name="MEM_BANKADDR_WIDTH" value="3" />
-- Retrieval info: 	<generic name="MEM_IF_DM_PINS_EN" value="true" />
-- Retrieval info: 	<generic name="MEM_IF_DQSN_EN" value="true" />
-- Retrieval info: 	<generic name="MEM_NUMBER_OF_DIMMS" value="1" />
-- Retrieval info: 	<generic name="MEM_NUMBER_OF_RANKS_PER_DIMM" value="1" />
-- Retrieval info: 	<generic name="MEM_NUMBER_OF_RANKS_PER_DEVICE" value="1" />
-- Retrieval info: 	<generic name="MEM_RANK_MULTIPLICATION_FACTOR" value="1" />
-- Retrieval info: 	<generic name="MEM_CK_WIDTH" value="1" />
-- Retrieval info: 	<generic name="MEM_CS_WIDTH" value="1" />
-- Retrieval info: 	<generic name="MEM_CLK_EN_WIDTH" value="1" />
-- Retrieval info: 	<generic name="ALTMEMPHY_COMPATIBLE_MODE" value="false" />
-- Retrieval info: 	<generic name="NEXTGEN" value="true" />
-- Retrieval info: 	<generic name="MEM_IF_BOARD_BASE_DELAY" value="10" />
-- Retrieval info: 	<generic name="MEM_IF_SIM_VALID_WINDOW" value="0" />
-- Retrieval info: 	<generic name="MEM_GUARANTEED_WRITE_INIT" value="false" />
-- Retrieval info: 	<generic name="MEM_VERBOSE" value="true" />
-- Retrieval info: 	<generic name="PINGPONGPHY_EN" value="false" />
-- Retrieval info: 	<generic name="REFRESH_BURST_VALIDATION" value="false" />
-- Retrieval info: 	<generic name="MEM_BL" value="8" />
-- Retrieval info: 	<generic name="MEM_BT" value="Sequential" />
-- Retrieval info: 	<generic name="MEM_DRV_STR" value="40" />
-- Retrieval info: 	<generic name="MEM_DLL_EN" value="true" />
-- Retrieval info: 	<generic name="MEM_ATCL" value="0" />
-- Retrieval info: 	<generic name="MEM_TCL" value="7" />
-- Retrieval info: 	<generic name="MEM_AUTO_LEVELING_MODE" value="true" />
-- Retrieval info: 	<generic name="MEM_USER_LEVELING_MODE" value="Leveling" />
-- Retrieval info: 	<generic name="MEM_INIT_EN" value="false" />
-- Retrieval info: 	<generic name="MEM_INIT_FILE" value="" />
-- Retrieval info: 	<generic name="DAT_DATA_WIDTH" value="32" />
-- Retrieval info: 	<generic name="TIMING_TIS" value="290" />
-- Retrieval info: 	<generic name="TIMING_TIH" value="290" />
-- Retrieval info: 	<generic name="TIMING_TDS" value="270" />
-- Retrieval info: 	<generic name="TIMING_TDH" value="270" />
-- Retrieval info: 	<generic name="TIMING_TDQSQ" value="240" />
-- Retrieval info: 	<generic name="TIMING_TQHS" value="280" />
-- Retrieval info: 	<generic name="TIMING_TDQSCK" value="5500" />
-- Retrieval info: 	<generic name="TIMING_TDQSCKDS" value="450" />
-- Retrieval info: 	<generic name="TIMING_TDQSCKDM" value="900" />
-- Retrieval info: 	<generic name="TIMING_TDQSCKDL" value="1200" />
-- Retrieval info: 	<generic name="TIMING_TDQSS" value="1.0" />
-- Retrieval info: 	<generic name="TIMING_TDQSH" value="0.4" />
-- Retrieval info: 	<generic name="TIMING_TDSH" value="0.2" />
-- Retrieval info: 	<generic name="TIMING_TDSS" value="0.2" />
-- Retrieval info: 	<generic name="MEM_TINIT_US" value="200" />
-- Retrieval info: 	<generic name="MEM_TMRD_CK" value="2" />
-- Retrieval info: 	<generic name="MEM_TRAS_NS" value="70.0" />
-- Retrieval info: 	<generic name="MEM_TRCD_NS" value="18.0" />
-- Retrieval info: 	<generic name="MEM_TRP_NS" value="18.0" />
-- Retrieval info: 	<generic name="MEM_TREFI_US" value="3.9" />
-- Retrieval info: 	<generic name="MEM_TRFC_NS" value="60.0" />
-- Retrieval info: 	<generic name="CFG_TCCD_NS" value="2.5" />
-- Retrieval info: 	<generic name="MEM_TWR_NS" value="15.0" />
-- Retrieval info: 	<generic name="MEM_TWTR" value="2" />
-- Retrieval info: 	<generic name="MEM_TFAW_NS" value="50.0" />
-- Retrieval info: 	<generic name="MEM_TRRD_NS" value="10.0" />
-- Retrieval info: 	<generic name="MEM_TRTP_NS" value="7.5" />
-- Retrieval info: 	<generic name="RATE" value="Half" />
-- Retrieval info: 	<generic name="MEM_CLK_FREQ" value="300.0" />
-- Retrieval info: 	<generic name="USE_MEM_CLK_FREQ" value="false" />
-- Retrieval info: 	<generic name="FORCE_DQS_TRACKING" value="AUTO" />
-- Retrieval info: 	<generic name="FORCE_SHADOW_REGS" value="AUTO" />
-- Retrieval info: 	<generic name="MRS_MIRROR_PING_PONG_ATSO" value="false" />
-- Retrieval info: 	<generic name="SYS_INFO_DEVICE_FAMILY" value="Cyclone V" />
-- Retrieval info: 	<generic name="PARSE_FRIENDLY_DEVICE_FAMILY_PARAM_VALID" value="false" />
-- Retrieval info: 	<generic name="PARSE_FRIENDLY_DEVICE_FAMILY_PARAM" value="" />
-- Retrieval info: 	<generic name="DEVICE_FAMILY_PARAM" value="" />
-- Retrieval info: 	<generic name="SPEED_GRADE" value="7" />
-- Retrieval info: 	<generic name="IS_ES_DEVICE" value="false" />
-- Retrieval info: 	<generic name="DISABLE_CHILD_MESSAGING" value="false" />
-- Retrieval info: 	<generic name="HARD_EMIF" value="false" />
-- Retrieval info: 	<generic name="HHP_HPS" value="false" />
-- Retrieval info: 	<generic name="HHP_HPS_VERIFICATION" value="false" />
-- Retrieval info: 	<generic name="HHP_HPS_SIMULATION" value="false" />
-- Retrieval info: 	<generic name="HPS_PROTOCOL" value="DEFAULT" />
-- Retrieval info: 	<generic name="CUT_NEW_FAMILY_TIMING" value="true" />
-- Retrieval info: 	<generic name="POWER_OF_TWO_BUS" value="false" />
-- Retrieval info: 	<generic name="SOPC_COMPAT_RESET" value="false" />
-- Retrieval info: 	<generic name="AVL_MAX_SIZE" value="4" />
-- Retrieval info: 	<generic name="BYTE_ENABLE" value="true" />
-- Retrieval info: 	<generic name="ENABLE_CTRL_AVALON_INTERFACE" value="true" />
-- Retrieval info: 	<generic name="CTL_DEEP_POWERDN_EN" value="false" />
-- Retrieval info: 	<generic name="CTL_SELF_REFRESH_EN" value="false" />
-- Retrieval info: 	<generic name="AUTO_POWERDN_EN" value="false" />
-- Retrieval info: 	<generic name="AUTO_PD_CYCLES" value="0" />
-- Retrieval info: 	<generic name="CTL_USR_REFRESH_EN" value="false" />
-- Retrieval info: 	<generic name="CTL_AUTOPCH_EN" value="false" />
-- Retrieval info: 	<generic name="CTL_ZQCAL_EN" value="false" />
-- Retrieval info: 	<generic name="ADDR_ORDER" value="0" />
-- Retrieval info: 	<generic name="CTL_LOOK_AHEAD_DEPTH" value="4" />
-- Retrieval info: 	<generic name="CONTROLLER_LATENCY" value="5" />
-- Retrieval info: 	<generic name="CFG_REORDER_DATA" value="true" />
-- Retrieval info: 	<generic name="STARVE_LIMIT" value="10" />
-- Retrieval info: 	<generic name="CTL_CSR_ENABLED" value="false" />
-- Retrieval info: 	<generic name="CTL_CSR_CONNECTION" value="INTERNAL_JTAG" />
-- Retrieval info: 	<generic name="CTL_ECC_ENABLED" value="false" />
-- Retrieval info: 	<generic name="CTL_HRB_ENABLED" value="false" />
-- Retrieval info: 	<generic name="CTL_ECC_AUTO_CORRECTION_ENABLED" value="false" />
-- Retrieval info: 	<generic name="MULTICAST_EN" value="false" />
-- Retrieval info: 	<generic name="CTL_DYNAMIC_BANK_ALLOCATION" value="false" />
-- Retrieval info: 	<generic name="CTL_DYNAMIC_BANK_NUM" value="4" />
-- Retrieval info: 	<generic name="DEBUG_MODE" value="false" />
-- Retrieval info: 	<generic name="ENABLE_BURST_MERGE" value="false" />
-- Retrieval info: 	<generic name="CTL_ENABLE_BURST_INTERRUPT" value="false" />
-- Retrieval info: 	<generic name="CTL_ENABLE_BURST_TERMINATE" value="false" />
-- Retrieval info: 	<generic name="LOCAL_ID_WIDTH" value="8" />
-- Retrieval info: 	<generic name="WRBUFFER_ADDR_WIDTH" value="6" />
-- Retrieval info: 	<generic name="MAX_PENDING_WR_CMD" value="8" />
-- Retrieval info: 	<generic name="MAX_PENDING_RD_CMD" value="16" />
-- Retrieval info: 	<generic name="USE_MM_ADAPTOR" value="true" />
-- Retrieval info: 	<generic name="USE_AXI_ADAPTOR" value="false" />
-- Retrieval info: 	<generic name="HCX_COMPAT_MODE" value="false" />
-- Retrieval info: 	<generic name="CTL_CMD_QUEUE_DEPTH" value="8" />
-- Retrieval info: 	<generic name="CTL_CSR_READ_ONLY" value="1" />
-- Retrieval info: 	<generic name="CFG_DATA_REORDERING_TYPE" value="INTER_BANK" />
-- Retrieval info: 	<generic name="NUM_OF_PORTS" value="1" />
-- Retrieval info: 	<generic name="ENABLE_BONDING" value="false" />
-- Retrieval info: 	<generic name="ENABLE_USER_ECC" value="false" />
-- Retrieval info: 	<generic name="AVL_DATA_WIDTH_PORT" value="32,32,32,32,32,32" />
-- Retrieval info: 	<generic name="PRIORITY_PORT" value="1,1,1,1,1,1" />
-- Retrieval info: 	<generic name="WEIGHT_PORT" value="0,0,0,0,0,0" />
-- Retrieval info: 	<generic name="CPORT_TYPE_PORT" value="Bidirectional,Bidirectional,Bidirectional,Bidirectional,Bidirectional,Bidirectional" />
-- Retrieval info: 	<generic name="ENABLE_EMIT_BFM_MASTER" value="false" />
-- Retrieval info: 	<generic name="FORCE_SEQUENCER_TCL_DEBUG_MODE" value="false" />
-- Retrieval info: 	<generic name="ENABLE_SEQUENCER_MARGINING_ON_BY_DEFAULT" value="false" />
-- Retrieval info: 	<generic name="REF_CLK_FREQ" value="125.0" />
-- Retrieval info: 	<generic name="REF_CLK_FREQ_PARAM_VALID" value="false" />
-- Retrieval info: 	<generic name="REF_CLK_FREQ_MIN_PARAM" value="0.0" />
-- Retrieval info: 	<generic name="REF_CLK_FREQ_MAX_PARAM" value="0.0" />
-- Retrieval info: 	<generic name="PLL_DR_CLK_FREQ_PARAM" value="0.0" />
-- Retrieval info: 	<generic name="PLL_DR_CLK_FREQ_SIM_STR_PARAM" value="" />
-- Retrieval info: 	<generic name="PLL_DR_CLK_PHASE_PS_PARAM" value="0" />
-- Retrieval info: 	<generic name="PLL_DR_CLK_PHASE_PS_SIM_STR_PARAM" value="" />
-- Retrieval info: 	<generic name="PLL_DR_CLK_MULT_PARAM" value="0" />
-- Retrieval info: 	<generic name="PLL_DR_CLK_DIV_PARAM" value="0" />
-- Retrieval info: 	<generic name="PLL_MEM_CLK_FREQ_PARAM" value="0.0" />
-- Retrieval info: 	<generic name="PLL_MEM_CLK_FREQ_SIM_STR_PARAM" value="" />
-- Retrieval info: 	<generic name="PLL_MEM_CLK_PHASE_PS_PARAM" value="0" />
-- Retrieval info: 	<generic name="PLL_MEM_CLK_PHASE_PS_SIM_STR_PARAM" value="" />
-- Retrieval info: 	<generic name="PLL_MEM_CLK_MULT_PARAM" value="0" />
-- Retrieval info: 	<generic name="PLL_MEM_CLK_DIV_PARAM" value="0" />
-- Retrieval info: 	<generic name="PLL_AFI_CLK_FREQ_PARAM" value="0.0" />
-- Retrieval info: 	<generic name="PLL_AFI_CLK_FREQ_SIM_STR_PARAM" value="" />
-- Retrieval info: 	<generic name="PLL_AFI_CLK_PHASE_PS_PARAM" value="0" />
-- Retrieval info: 	<generic name="PLL_AFI_CLK_PHASE_PS_SIM_STR_PARAM" value="" />
-- Retrieval info: 	<generic name="PLL_AFI_CLK_MULT_PARAM" value="0" />
-- Retrieval info: 	<generic name="PLL_AFI_CLK_DIV_PARAM" value="0" />
-- Retrieval info: 	<generic name="PLL_WRITE_CLK_FREQ_PARAM" value="0.0" />
-- Retrieval info: 	<generic name="PLL_WRITE_CLK_FREQ_SIM_STR_PARAM" value="" />
-- Retrieval info: 	<generic name="PLL_WRITE_CLK_PHASE_PS_PARAM" value="0" />
-- Retrieval info: 	<generic name="PLL_WRITE_CLK_PHASE_PS_SIM_STR_PARAM" value="" />
-- Retrieval info: 	<generic name="PLL_WRITE_CLK_MULT_PARAM" value="0" />
-- Retrieval info: 	<generic name="PLL_WRITE_CLK_DIV_PARAM" value="0" />
-- Retrieval info: 	<generic name="PLL_ADDR_CMD_CLK_FREQ_PARAM" value="0.0" />
-- Retrieval info: 	<generic name="PLL_ADDR_CMD_CLK_FREQ_SIM_STR_PARAM" value="" />
-- Retrieval info: 	<generic name="PLL_ADDR_CMD_CLK_PHASE_PS_PARAM" value="0" />
-- Retrieval info: 	<generic name="PLL_ADDR_CMD_CLK_PHASE_PS_SIM_STR_PARAM" value="" />
-- Retrieval info: 	<generic name="PLL_ADDR_CMD_CLK_MULT_PARAM" value="0" />
-- Retrieval info: 	<generic name="PLL_ADDR_CMD_CLK_DIV_PARAM" value="0" />
-- Retrieval info: 	<generic name="PLL_AFI_HALF_CLK_FREQ_PARAM" value="0.0" />
-- Retrieval info: 	<generic name="PLL_AFI_HALF_CLK_FREQ_SIM_STR_PARAM" value="" />
-- Retrieval info: 	<generic name="PLL_AFI_HALF_CLK_PHASE_PS_PARAM" value="0" />
-- Retrieval info: 	<generic name="PLL_AFI_HALF_CLK_PHASE_PS_SIM_STR_PARAM" value="" />
-- Retrieval info: 	<generic name="PLL_AFI_HALF_CLK_MULT_PARAM" value="0" />
-- Retrieval info: 	<generic name="PLL_AFI_HALF_CLK_DIV_PARAM" value="0" />
-- Retrieval info: 	<generic name="PLL_NIOS_CLK_FREQ_PARAM" value="0.0" />
-- Retrieval info: 	<generic name="PLL_NIOS_CLK_FREQ_SIM_STR_PARAM" value="" />
-- Retrieval info: 	<generic name="PLL_NIOS_CLK_PHASE_PS_PARAM" value="0" />
-- Retrieval info: 	<generic name="PLL_NIOS_CLK_PHASE_PS_SIM_STR_PARAM" value="" />
-- Retrieval info: 	<generic name="PLL_NIOS_CLK_MULT_PARAM" value="0" />
-- Retrieval info: 	<generic name="PLL_NIOS_CLK_DIV_PARAM" value="0" />
-- Retrieval info: 	<generic name="PLL_CONFIG_CLK_FREQ_PARAM" value="0.0" />
-- Retrieval info: 	<generic name="PLL_CONFIG_CLK_FREQ_SIM_STR_PARAM" value="" />
-- Retrieval info: 	<generic name="PLL_CONFIG_CLK_PHASE_PS_PARAM" value="0" />
-- Retrieval info: 	<generic name="PLL_CONFIG_CLK_PHASE_PS_SIM_STR_PARAM" value="" />
-- Retrieval info: 	<generic name="PLL_CONFIG_CLK_MULT_PARAM" value="0" />
-- Retrieval info: 	<generic name="PLL_CONFIG_CLK_DIV_PARAM" value="0" />
-- Retrieval info: 	<generic name="PLL_P2C_READ_CLK_FREQ_PARAM" value="0.0" />
-- Retrieval info: 	<generic name="PLL_P2C_READ_CLK_FREQ_SIM_STR_PARAM" value="" />
-- Retrieval info: 	<generic name="PLL_P2C_READ_CLK_PHASE_PS_PARAM" value="0" />
-- Retrieval info: 	<generic name="PLL_P2C_READ_CLK_PHASE_PS_SIM_STR_PARAM" value="" />
-- Retrieval info: 	<generic name="PLL_P2C_READ_CLK_MULT_PARAM" value="0" />
-- Retrieval info: 	<generic name="PLL_P2C_READ_CLK_DIV_PARAM" value="0" />
-- Retrieval info: 	<generic name="PLL_C2P_WRITE_CLK_FREQ_PARAM" value="0.0" />
-- Retrieval info: 	<generic name="PLL_C2P_WRITE_CLK_FREQ_SIM_STR_PARAM" value="" />
-- Retrieval info: 	<generic name="PLL_C2P_WRITE_CLK_PHASE_PS_PARAM" value="0" />
-- Retrieval info: 	<generic name="PLL_C2P_WRITE_CLK_PHASE_PS_SIM_STR_PARAM" value="" />
-- Retrieval info: 	<generic name="PLL_C2P_WRITE_CLK_MULT_PARAM" value="0" />
-- Retrieval info: 	<generic name="PLL_C2P_WRITE_CLK_DIV_PARAM" value="0" />
-- Retrieval info: 	<generic name="PLL_HR_CLK_FREQ_PARAM" value="0.0" />
-- Retrieval info: 	<generic name="PLL_HR_CLK_FREQ_SIM_STR_PARAM" value="" />
-- Retrieval info: 	<generic name="PLL_HR_CLK_PHASE_PS_PARAM" value="0" />
-- Retrieval info: 	<generic name="PLL_HR_CLK_PHASE_PS_SIM_STR_PARAM" value="" />
-- Retrieval info: 	<generic name="PLL_HR_CLK_MULT_PARAM" value="0" />
-- Retrieval info: 	<generic name="PLL_HR_CLK_DIV_PARAM" value="0" />
-- Retrieval info: 	<generic name="PLL_AFI_PHY_CLK_FREQ_PARAM" value="0.0" />
-- Retrieval info: 	<generic name="PLL_AFI_PHY_CLK_FREQ_SIM_STR_PARAM" value="" />
-- Retrieval info: 	<generic name="PLL_AFI_PHY_CLK_PHASE_PS_PARAM" value="0" />
-- Retrieval info: 	<generic name="PLL_AFI_PHY_CLK_PHASE_PS_SIM_STR_PARAM" value="" />
-- Retrieval info: 	<generic name="PLL_AFI_PHY_CLK_MULT_PARAM" value="0" />
-- Retrieval info: 	<generic name="PLL_AFI_PHY_CLK_DIV_PARAM" value="0" />
-- Retrieval info: 	<generic name="PLL_CLK_PARAM_VALID" value="false" />
-- Retrieval info: 	<generic name="ENABLE_EXTRA_REPORTING" value="false" />
-- Retrieval info: 	<generic name="NUM_EXTRA_REPORT_PATH" value="10" />
-- Retrieval info: 	<generic name="ENABLE_ISS_PROBES" value="false" />
-- Retrieval info: 	<generic name="CALIB_REG_WIDTH" value="8" />
-- Retrieval info: 	<generic name="USE_SEQUENCER_BFM" value="false" />
-- Retrieval info: 	<generic name="DEFAULT_FAST_SIM_MODEL" value="true" />
-- Retrieval info: 	<generic name="PLL_SHARING_MODE" value="None" />
-- Retrieval info: 	<generic name="NUM_PLL_SHARING_INTERFACES" value="1" />
-- Retrieval info: 	<generic name="EXPORT_AFI_HALF_CLK" value="false" />
-- Retrieval info: 	<generic name="ABSTRACT_REAL_COMPARE_TEST" value="false" />
-- Retrieval info: 	<generic name="INCLUDE_BOARD_DELAY_MODEL" value="false" />
-- Retrieval info: 	<generic name="INCLUDE_MULTIRANK_BOARD_DELAY_MODEL" value="false" />
-- Retrieval info: 	<generic name="USE_FAKE_PHY" value="false" />
-- Retrieval info: 	<generic name="FORCE_MAX_LATENCY_COUNT_WIDTH" value="0" />
-- Retrieval info: 	<generic name="ENABLE_NON_DESTRUCTIVE_CALIB" value="false" />
-- Retrieval info: 	<generic name="TRACKING_ERROR_TEST" value="false" />
-- Retrieval info: 	<generic name="TRACKING_WATCH_TEST" value="false" />
-- Retrieval info: 	<generic name="MARGIN_VARIATION_TEST" value="false" />
-- Retrieval info: 	<generic name="EXTRA_SETTINGS" value="" />
-- Retrieval info: 	<generic name="MEM_DEVICE" value="MISSING_MODEL" />
-- Retrieval info: 	<generic name="FORCE_SYNTHESIS_LANGUAGE" value="" />
-- Retrieval info: 	<generic name="FORCED_NUM_WRITE_FR_CYCLE_SHIFTS" value="0" />
-- Retrieval info: 	<generic name="SEQUENCER_TYPE" value="NIOS" />
-- Retrieval info: 	<generic name="ADVERTIZE_SEQUENCER_SW_BUILD_FILES" value="false" />
-- Retrieval info: 	<generic name="FORCED_NON_LDC_ADDR_CMD_MEM_CK_INVERT" value="false" />
-- Retrieval info: 	<generic name="PHY_ONLY" value="false" />
-- Retrieval info: 	<generic name="SEQ_MODE" value="0" />
-- Retrieval info: 	<generic name="ADVANCED_CK_PHASES" value="false" />
-- Retrieval info: 	<generic name="COMMAND_PHASE" value="0.0" />
-- Retrieval info: 	<generic name="MEM_CK_PHASE" value="0.0" />
-- Retrieval info: 	<generic name="P2C_READ_CLOCK_ADD_PHASE" value="0.0" />
-- Retrieval info: 	<generic name="C2P_WRITE_CLOCK_ADD_PHASE" value="0.0" />
-- Retrieval info: 	<generic name="ACV_PHY_CLK_ADD_FR_PHASE" value="0.0" />
-- Retrieval info: 	<generic name="PLL_LOCATION" value="Top_Bottom" />
-- Retrieval info: 	<generic name="SKIP_MEM_INIT" value="false" />
-- Retrieval info: 	<generic name="READ_DQ_DQS_CLOCK_SOURCE" value="INVERTED_DQS_BUS" />
-- Retrieval info: 	<generic name="DQ_INPUT_REG_USE_CLKN" value="false" />
-- Retrieval info: 	<generic name="DQS_DQSN_MODE" value="DIFFERENTIAL" />
-- Retrieval info: 	<generic name="AFI_DEBUG_INFO_WIDTH" value="32" />
-- Retrieval info: 	<generic name="CALIBRATION_MODE" value="Full" />
-- Retrieval info: 	<generic name="NIOS_ROM_DATA_WIDTH" value="32" />
-- Retrieval info: 	<generic name="READ_FIFO_SIZE" value="8" />
-- Retrieval info: 	<generic name="PHY_CSR_ENABLED" value="false" />
-- Retrieval info: 	<generic name="PHY_CSR_CONNECTION" value="INTERNAL_JTAG" />
-- Retrieval info: 	<generic name="USER_DEBUG_LEVEL" value="0" />
-- Retrieval info: 	<generic name="TIMING_BOARD_DERATE_METHOD" value="AUTO" />
-- Retrieval info: 	<generic name="TIMING_BOARD_CK_CKN_SLEW_RATE" value="2.0" />
-- Retrieval info: 	<generic name="TIMING_BOARD_AC_SLEW_RATE" value="1.0" />
-- Retrieval info: 	<generic name="TIMING_BOARD_DQS_DQSN_SLEW_RATE" value="2.0" />
-- Retrieval info: 	<generic name="TIMING_BOARD_DQ_SLEW_RATE" value="1.0" />
-- Retrieval info: 	<generic name="TIMING_BOARD_TIS" value="0.0" />
-- Retrieval info: 	<generic name="TIMING_BOARD_TIH" value="0.0" />
-- Retrieval info: 	<generic name="TIMING_BOARD_TDS" value="0.0" />
-- Retrieval info: 	<generic name="TIMING_BOARD_TDH" value="0.0" />
-- Retrieval info: 	<generic name="TIMING_BOARD_ISI_METHOD" value="AUTO" />
-- Retrieval info: 	<generic name="TIMING_BOARD_AC_EYE_REDUCTION_SU" value="0.0" />
-- Retrieval info: 	<generic name="TIMING_BOARD_AC_EYE_REDUCTION_H" value="0.0" />
-- Retrieval info: 	<generic name="TIMING_BOARD_DQ_EYE_REDUCTION" value="0.0" />
-- Retrieval info: 	<generic name="TIMING_BOARD_DELTA_DQS_ARRIVAL_TIME" value="0.0" />
-- Retrieval info: 	<generic name="PACKAGE_DESKEW" value="false" />
-- Retrieval info: 	<generic name="AC_PACKAGE_DESKEW" value="false" />
-- Retrieval info: 	<generic name="TIMING_BOARD_MAX_CK_DELAY" value="0.6" />
-- Retrieval info: 	<generic name="TIMING_BOARD_MAX_DQS_DELAY" value="0.6" />
-- Retrieval info: 	<generic name="TIMING_BOARD_SKEW_CKDQS_DIMM_MIN" value="-0.01" />
-- Retrieval info: 	<generic name="TIMING_BOARD_SKEW_CKDQS_DIMM_MAX" value="0.01" />
-- Retrieval info: 	<generic name="TIMING_BOARD_SKEW_BETWEEN_DIMMS" value="0.05" />
-- Retrieval info: 	<generic name="TIMING_BOARD_SKEW_WITHIN_DQS" value="0.02" />
-- Retrieval info: 	<generic name="TIMING_BOARD_SKEW_BETWEEN_DQS" value="0.02" />
-- Retrieval info: 	<generic name="TIMING_BOARD_DQ_TO_DQS_SKEW" value="0.0" />
-- Retrieval info: 	<generic name="TIMING_BOARD_AC_SKEW" value="0.02" />
-- Retrieval info: 	<generic name="TIMING_BOARD_AC_TO_CK_SKEW" value="0.0" />
-- Retrieval info: 	<generic name="ENABLE_EXPORT_SEQ_DEBUG_BRIDGE" value="false" />
-- Retrieval info: 	<generic name="CORE_DEBUG_CONNECTION" value="EXPORT" />
-- Retrieval info: 	<generic name="ADD_EXTERNAL_SEQ_DEBUG_NIOS" value="false" />
-- Retrieval info: 	<generic name="ED_EXPORT_SEQ_DEBUG" value="false" />
-- Retrieval info: 	<generic name="ADD_EFFICIENCY_MONITOR" value="false" />
-- Retrieval info: 	<generic name="ENABLE_ABS_RAM_MEM_INIT" value="false" />
-- Retrieval info: 	<generic name="ABS_RAM_MEM_INIT_FILENAME" value="meminit" />
-- Retrieval info: 	<generic name="DLL_SHARING_MODE" value="None" />
-- Retrieval info: 	<generic name="NUM_DLL_SHARING_INTERFACES" value="1" />
-- Retrieval info: 	<generic name="OCT_SHARING_MODE" value="None" />
-- Retrieval info: 	<generic name="NUM_OCT_SHARING_INTERFACES" value="1" />
-- Retrieval info: 	<generic name="AUTO_DEVICE" value="Unknown" />
-- Retrieval info: </instance>
-- IPFS_FILES : lpddr2ctrl1.vho
-- RELATED_FILES: lpddr2ctrl1.vhd, lpddr2ctrl1_0002.v, lpddr2ctrl1_pll0.sv, lpddr2ctrl1_p0_clock_pair_generator.v, lpddr2ctrl1_p0_read_valid_selector.v, lpddr2ctrl1_p0_addr_cmd_datapath.v, lpddr2ctrl1_p0_reset.v, lpddr2ctrl1_p0_acv_ldc.v, lpddr2ctrl1_p0_memphy.sv, lpddr2ctrl1_p0_reset_sync.v, lpddr2ctrl1_p0_new_io_pads.v, lpddr2ctrl1_p0_fr_cycle_shifter.v, lpddr2ctrl1_p0_fr_cycle_extender.v, lpddr2ctrl1_p0_read_datapath.sv, lpddr2ctrl1_p0_write_datapath.v, lpddr2ctrl1_p0_simple_ddio_out.sv, lpddr2ctrl1_p0_phy_csr.sv, lpddr2ctrl1_p0_iss_probe.v, lpddr2ctrl1_p0_flop_mem.v, lpddr2ctrl1_p0_addr_cmd_pads.v, lpddr2ctrl1_p0.sv, lpddr2ctrl1_p0_altdqdqs.v, altdq_dqs2_acv_cyclonev_lpddr2.sv, afi_mux_lpddr2.v, lpddr2ctrl1_s0.v, rw_manager_bitcheck.v, rw_manager_datamux.v, lpddr2ctrl1_s0_id_router.sv, altera_merlin_traffic_limiter.sv, lpddr2ctrl1_s0_cmd_xbar_demux_001.sv, sequencer_trk_mgr.sv, lpddr2ctrl1_s0_addr_router_002.sv, sequencer_scc_sv_wrapper.sv, lpddr2ctrl1_s0_rsp_xbar_demux_003.sv, rw_manager_ac_ROM_reg.v, altera_merlin_burst_uncompressor.sv, rw_manager_read_datapath.v, rw_manager_lfsr12.v, rw_manager_lfsr36.v, rw_manager_data_broadcast.v, altera_avalon_mm_bridge.v, lpddr2ctrl1_s0_irq_mapper.sv, rw_manager_lfsr72.v, sequencer_reg_file.sv, rw_manager_di_buffer_wrap.v, rw_manager_jumplogic.v, altera_merlin_slave_agent.sv, altera_merlin_slave_translator.sv, altera_mem_if_sequencer_mem_no_ifdef_params.sv, lpddr2ctrl1_s0_cmd_xbar_mux.sv, sequencer_data_mgr.sv, sequencer_scc_reg_file.v, rw_manager_ram.v, rw_manager_lpddr2.v, rw_manager_ram_csr.v, rw_manager_generic.sv, altera_avalon_sc_fifo.v, altera_avalon_st_pipeline_base.v, lpddr2ctrl1_s0_id_router_003.sv, lpddr2ctrl1_s0_rsp_xbar_mux_003.sv, rw_manager_write_decoder.v, sequencer_scc_acv_wrapper.sv, rw_manager_ac_ROM_no_ifdef_params.v, lpddr2ctrl1_s0_id_router_001.sv, rw_manager_core.sv, sequencer_phy_mgr.sv, lpddr2ctrl1_s0_cmd_xbar_demux_003.sv, sequencer_scc_acv_phase_decode.v, lpddr2ctrl1_s0_addr_router.sv, sequencer_scc_siii_phase_decode.v, lpddr2ctrl1_s0_cmd_xbar_demux.sv, lpddr2ctrl1_s0_rsp_xbar_demux.sv, altera_mem_if_sequencer_cpu_cv_synth_cpu_inst.v, rw_manager_dm_decoder.v, lpddr2ctrl1_s0_addr_router_001.sv, rw_manager_inst_ROM_reg.v, rw_manager_data_decoder.v, sequencer_scc_mgr.sv, sequencer_scc_siii_wrapper.sv, lpddr2ctrl1_s0_rsp_xbar_mux.sv, altera_merlin_master_translator.sv, altera_mem_if_sequencer_cpu_cv_synth_cpu_inst_test_bench.v, lpddr2ctrl1_s0_addr_router_003.sv, lpddr2ctrl1_s0_id_router_002.sv, rw_manager_di_buffer.v, rw_manager_pattern_fifo.v, altera_merlin_master_agent.sv, altera_merlin_arbitrator.sv, sequencer_scc_sv_phase_decode.v, rw_manager_inst_ROM_no_ifdef_params.v, altera_mem_if_sequencer_rst.sv, lpddr2ctrl1_c0.v, altera_mem_if_oct_cyclonev.sv, altera_mem_if_dll_cyclonev.sv, alt_mem_ddrx_addr_cmd.v, alt_mem_ddrx_addr_cmd_wrap.v, alt_mem_ddrx_ddr2_odt_gen.v, alt_mem_ddrx_ddr3_odt_gen.v, alt_mem_ddrx_lpddr2_addr_cmd.v, alt_mem_ddrx_odt_gen.v, alt_mem_ddrx_rdwr_data_tmg.v, alt_mem_ddrx_arbiter.v, alt_mem_ddrx_burst_gen.v, alt_mem_ddrx_cmd_gen.v, alt_mem_ddrx_csr.v, alt_mem_ddrx_buffer.v, alt_mem_ddrx_buffer_manager.v, alt_mem_ddrx_burst_tracking.v, alt_mem_ddrx_dataid_manager.v, alt_mem_ddrx_fifo.v, alt_mem_ddrx_list.v, alt_mem_ddrx_rdata_path.v, alt_mem_ddrx_wdata_path.v, alt_mem_ddrx_define.iv, alt_mem_ddrx_ecc_decoder.v, alt_mem_ddrx_ecc_decoder_32_syn.v, alt_mem_ddrx_ecc_decoder_64_syn.v, alt_mem_ddrx_ecc_encoder.v, alt_mem_ddrx_ecc_encoder_32_syn.v, alt_mem_ddrx_ecc_encoder_64_syn.v, alt_mem_ddrx_ecc_encoder_decoder_wrapper.v, alt_mem_ddrx_axi_st_converter.v, alt_mem_ddrx_input_if.v, alt_mem_ddrx_rank_timer.v, alt_mem_ddrx_sideband.v, alt_mem_ddrx_tbp.v, alt_mem_ddrx_timing_param.v, alt_mem_ddrx_controller.v, alt_mem_ddrx_controller_st_top.v, alt_mem_if_nextgen_lpddr2_controller_core.sv, alt_mem_ddrx_mm_st_converter.v

