------------------------------------------------------------------------------
--  This file is a part of the GRLIB VHDL IP LIBRARY
--  Copyright (C) 2015, Cobham Gaisler AB - all rights reserved.
--
-- ANY USE OR REDISTRIBUTION IN PART OR IN WHOLE MUST BE HANDLED IN 
-- ACCORDANCE WITH THE GAISLER LICENSE AGREEMENT AND MUST BE APPROVED 
-- IN ADVANCE IN WRITING.
------------------------------------------------------------------------------


library ieee, cycloneiii;
library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;
use cycloneiii.cycloneiii_components.all;
library altera;
use altera.altera_primitives_components.all;

entity grlfpw_0_cycloneiii is
port(
  rst :  in std_logic;
  clk :  in std_logic;
  holdn :  in std_logic;
  cpi_flush :  in std_logic;
  cpi_exack :  in std_logic;
  cpi_a_rs1 : in std_logic_vector(4 downto 0);
  cpi_d_pc : in std_logic_vector(31 downto 0);
  cpi_d_inst : in std_logic_vector(31 downto 0);
  cpi_d_cnt : in std_logic_vector(1 downto 0);
  cpi_d_trap :  in std_logic;
  cpi_d_annul :  in std_logic;
  cpi_d_pv :  in std_logic;
  cpi_a_pc : in std_logic_vector(31 downto 0);
  cpi_a_inst : in std_logic_vector(31 downto 0);
  cpi_a_cnt : in std_logic_vector(1 downto 0);
  cpi_a_trap :  in std_logic;
  cpi_a_annul :  in std_logic;
  cpi_a_pv :  in std_logic;
  cpi_e_pc : in std_logic_vector(31 downto 0);
  cpi_e_inst : in std_logic_vector(31 downto 0);
  cpi_e_cnt : in std_logic_vector(1 downto 0);
  cpi_e_trap :  in std_logic;
  cpi_e_annul :  in std_logic;
  cpi_e_pv :  in std_logic;
  cpi_m_pc : in std_logic_vector(31 downto 0);
  cpi_m_inst : in std_logic_vector(31 downto 0);
  cpi_m_cnt : in std_logic_vector(1 downto 0);
  cpi_m_trap :  in std_logic;
  cpi_m_annul :  in std_logic;
  cpi_m_pv :  in std_logic;
  cpi_x_pc : in std_logic_vector(31 downto 0);
  cpi_x_inst : in std_logic_vector(31 downto 0);
  cpi_x_cnt : in std_logic_vector(1 downto 0);
  cpi_x_trap :  in std_logic;
  cpi_x_annul :  in std_logic;
  cpi_x_pv :  in std_logic;
  cpi_lddata : in std_logic_vector(31 downto 0);
  cpi_dbg_enable :  in std_logic;
  cpi_dbg_write :  in std_logic;
  cpi_dbg_fsr :  in std_logic;
  cpi_dbg_addr : in std_logic_vector(4 downto 0);
  cpi_dbg_data : in std_logic_vector(31 downto 0);
  cpo_data : out std_logic_vector(31 downto 0);
  cpo_exc :  out std_logic;
  cpo_cc : out std_logic_vector(1 downto 0);
  cpo_ccv :  out std_logic;
  cpo_ldlock :  out std_logic;
  cpo_holdn :  out std_logic;
  cpo_dbg_data : out std_logic_vector(31 downto 0);
  rfi1_rd1addr : out std_logic_vector(3 downto 0);
  rfi1_rd2addr : out std_logic_vector(3 downto 0);
  rfi1_wraddr : out std_logic_vector(3 downto 0);
  rfi1_wrdata : out std_logic_vector(31 downto 0);
  rfi1_ren1 :  out std_logic;
  rfi1_ren2 :  out std_logic;
  rfi1_wren :  out std_logic;
  rfi2_rd1addr : out std_logic_vector(3 downto 0);
  rfi2_rd2addr : out std_logic_vector(3 downto 0);
  rfi2_wraddr : out std_logic_vector(3 downto 0);
  rfi2_wrdata : out std_logic_vector(31 downto 0);
  rfi2_ren1 :  out std_logic;
  rfi2_ren2 :  out std_logic;
  rfi2_wren :  out std_logic;
  rfo1_data1 : in std_logic_vector(31 downto 0);
  rfo1_data2 : in std_logic_vector(31 downto 0);
  rfo2_data1 : in std_logic_vector(31 downto 0);
  rfo2_data2 : in std_logic_vector(31 downto 0));
end grlfpw_0_cycloneiii;

architecture beh of grlfpw_0_cycloneiii is
  signal devclrn : std_logic := '1';
  signal devpor : std_logic := '1';
  signal devoe : std_logic := '0';
  signal \GRLFPC20.FPI.OP2_X\ : std_logic_vector(63 downto 32);
  signal \GRLFPC20.R.FSR.RD\ : std_logic_vector(1 downto 0);
  signal \GRLFPC20.R.STATE\ : std_logic_vector(1 downto 0);
  signal \GRLFPC20.R.X.SEQERR\ : std_logic_vector(0 to 0);
  signal \GRLFPC20.R.I.INST\ : std_logic_vector(31 downto 0);
  signal \GRLFPC20.R.FSR.TEM\ : std_logic_vector(4 downto 0);
  signal \GRLFPC20.R.I.EXC\ : std_logic_vector(5 downto 0);
  signal \GRLFPC20.R.FSR.AEXC\ : std_logic_vector(4 downto 0);
  signal \GRLFPC20.R.A.RS1\ : std_logic_vector(4 downto 0);
  signal \GRLFPC20.R.A.RS2\ : std_logic_vector(4 downto 0);
  signal \GRLFPC20.R.X.RDD\ : std_logic_vector(0 to 0);
  signal \GRLFPC20.R.I.PC\ : std_logic_vector(31 downto 2);
  signal \GRLFPC20.R.FSR.CEXC\ : std_logic_vector(4 downto 0);
  signal \GRLFPC20.R.FSR.FTT\ : std_logic_vector(2 downto 0);
  signal \GRLFPC20.R.I.CC\ : std_logic_vector(1 downto 0);
  signal \GRLFPC20.R.I.RES\ : std_logic_vector(63 downto 0);
  signal \GRLFPC20.COMB.V.I.RES_6_X\ : std_logic_vector(63 to 63);
  signal \GRLFPC20.COMB.V.I.RES_1\ : std_logic_vector(63 to 63);
  signal \GRLFPC20.R.A.RF1REN\ : std_logic_vector(2 downto 1);
  signal \GRLFPC20.R.A.RF2REN\ : std_logic_vector(2 downto 1);
  signal \GRLFPC20.R.A.SEQERR\ : std_logic_vector(0 to 0);
  signal \GRLFPC20.R.E.SEQERR\ : std_logic_vector(0 to 0);
  signal \GRLFPC20.R.M.SEQERR\ : std_logic_vector(0 to 0);
  signal \GRLFPC20.R.A.RDD\ : std_logic_vector(0 to 0);
  signal \GRLFPC20.R.E.RDD\ : std_logic_vector(0 to 0);
  signal \GRLFPC20.R.M.RDD\ : std_logic_vector(0 to 0);
  signal \GRLFPC20.R.I.EXC_0\ : std_logic_vector(1 to 1);
  signal \GRLFPC20.COMB.RS2_1\ : std_logic_vector(4 downto 0);
  signal \GRLFPC20.COMB.V.E.STDATA_1_0_X\ : std_logic_vector(31 downto 2);
  signal \GRLFPC20.COMB.V.E.STDATA_1_1\ : std_logic_vector(31 downto 2);
  signal \GRLFPC20.COMB.RS1_1\ : std_logic_vector(4 downto 0);
  signal \GRLFPC20.COMB.V.FSR.FCC_1\ : std_logic_vector(1 downto 0);
  signal \GRLFPC20.COMB.V.FSR.CEXC_1\ : std_logic_vector(4 downto 0);
  signal \GRLFPC20.COMB.V.FSR.CEXC_1_1_X\ : std_logic_vector(4 downto 0);
  signal \GRLFPC20.COMB.V.FSR.CEXC_1_2\ : std_logic_vector(4 downto 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\ : std_logic_vector(16 downto 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.PCTRL\ : std_logic_vector(8 downto 1);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN2_DIVMULTV\ : std_logic_vector(0 to 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\ : std_logic_vector(85 downto 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\ : std_logic_vector(377 downto 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_MUX_15\ : std_logic_vector(51 downto 30);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.MIXOIN\ : std_logic_vector(0 to 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_X\ : std_logic_vector(83 downto 81);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19\ : std_logic_vector(80 downto 61);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.CTRLXERSHFT.MIXOIN_3\ : std_logic_vector(57 downto 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\ : std_logic_vector(113 downto 61);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZXBUS\ : std_logic_vector(57 downto 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.4.CI_54_V\ : std_logic_vector(3 downto 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.29.CI_29_V\ : std_logic_vector(3 downto 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.42.CI_16_V\ : std_logic_vector(3 downto 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.41.CI_17_V\ : std_logic_vector(3 downto 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.10.CI_48_V\ : std_logic_vector(3 downto 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.47.CI_11_V\ : std_logic_vector(3 downto 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.34.CI_24_V\ : std_logic_vector(3 downto 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.35.CI_23_V\ : std_logic_vector(3 downto 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.14.CI_44_V\ : std_logic_vector(3 downto 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.25.CI_33_V\ : std_logic_vector(3 downto 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.7.CI_51_V\ : std_logic_vector(3 downto 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.19.CI_39_V\ : std_logic_vector(3 downto 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.45.CI_13_V\ : std_logic_vector(3 downto 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.37.CI_21_V\ : std_logic_vector(3 downto 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.12.CI_46_V\ : std_logic_vector(3 downto 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.3.CI_55_V\ : std_logic_vector(2 downto 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.36.CI_22_V\ : std_logic_vector(3 downto 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.15.CI_43_V\ : std_logic_vector(3 downto 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.16.CI_42_V\ : std_logic_vector(3 downto 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.17.CI_41_V\ : std_logic_vector(3 downto 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.31.CI_27_V\ : std_logic_vector(3 downto 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.50.CI_8_V\ : std_logic_vector(3 downto 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.43.CI_15_V\ : std_logic_vector(3 downto 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.22.CI_36_V\ : std_logic_vector(3 downto 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.23.CI_35_V\ : std_logic_vector(3 downto 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.53.CI_5_V\ : std_logic_vector(3 downto 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.32.CI_26_V\ : std_logic_vector(3 downto 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.18.CI_40_V\ : std_logic_vector(3 downto 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.20.CI_38_V\ : std_logic_vector(3 downto 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.39.CI_19_V\ : std_logic_vector(3 downto 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.6.CI_52_V\ : std_logic_vector(3 downto 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.21.CI_37_V\ : std_logic_vector(3 downto 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.48.CI_10_V\ : std_logic_vector(3 downto 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.54.CI_4_V\ : std_logic_vector(3 downto 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.51.CI_7_V\ : std_logic_vector(3 downto 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.52.CI_6_V\ : std_logic_vector(3 downto 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.5.CI_53_V\ : std_logic_vector(3 downto 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.8.CI_50_V\ : std_logic_vector(3 downto 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.27.CI_31_V\ : std_logic_vector(3 downto 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.28.CI_30_V\ : std_logic_vector(3 downto 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.11.CI_47_V\ : std_logic_vector(3 downto 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.49.CI_9_V\ : std_logic_vector(3 downto 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.30.CI_28_V\ : std_logic_vector(3 downto 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.24.CI_34_V\ : std_logic_vector(3 downto 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.38.CI_20_V\ : std_logic_vector(3 downto 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.40.CI_18_V\ : std_logic_vector(3 downto 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.33.CI_25_V\ : std_logic_vector(3 downto 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.44.CI_14_V\ : std_logic_vector(3 downto 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.46.CI_12_V\ : std_logic_vector(3 downto 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.9.CI_49_V\ : std_logic_vector(3 downto 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.13.CI_45_V\ : std_logic_vector(3 downto 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.26.CI_32_V\ : std_logic_vector(3 downto 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.EXPXBUS_3\ : std_logic_vector(12 downto 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.GRFPUELOC_0\ : std_logic_vector(0 to 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.GRFPUELOC\ : std_logic_vector(12 downto 1);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH\ : std_logic_vector(257 downto 58);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.PCTRL_NEW_12_32\ : std_logic_vector(75 to 75);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.54.SI_61_1.SUM_0_A2\ : std_logic_vector(0 to 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.53.SI_118_1.SUM\ : std_logic_vector(0 to 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SXC.SCTRL_NEW\ : std_logic_vector(10 downto 3);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_4\ : std_logic_vector(57 downto 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_5\ : std_logic_vector(57 downto 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.CTRLXERSHFT.SUMIN_5\ : std_logic_vector(57 downto 1);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN8_TEMP_U\ : std_logic_vector(0 to 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_MUX_7\ : std_logic_vector(62 downto 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_MUX_7_0_A2\ : std_logic_vector(19 to 19);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_MUX_14\ : std_logic_vector(62 downto 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_2\ : std_logic_vector(257 downto 237);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_2\ : std_logic_vector(57 downto 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN2_MIXOIN_25\ : std_logic_vector(0 to 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_41\ : std_logic_vector(257 downto 250);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_GRFPUF_0\ : std_logic_vector(3 downto 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_M3\ : std_logic_vector(83 downto 61);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_8_1.SUM_0\ : std_logic_vector(0 to 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23_1.SUM_0_A2\ : std_logic_vector(0 to 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_8_1.SUM_0_A2\ : std_logic_vector(0 to 0);
  signal \GRLFPC20.COMB.V.A.RF1REN_1\ : std_logic_vector(2 to 2);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH_118\ : std_logic_vector(6 to 6);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH_134\ : std_logic_vector(2 to 2);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH_0\ : std_logic_vector(8 downto 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_16\ : std_logic_vector(56 downto 10);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_10\ : std_logic_vector(57 downto 1);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_M0\ : std_logic_vector(115 downto 58);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_M1\ : std_logic_vector(115 downto 58);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_M2\ : std_logic_vector(112 downto 58);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES\ : std_logic_vector(57 downto 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES_0\ : std_logic_vector(57 downto 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26\ : std_logic_vector(55 downto 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_3\ : std_logic_vector(54 downto 3);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_0\ : std_logic_vector(57 downto 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_1\ : std_logic_vector(22 downto 3);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\ : std_logic_vector(57 downto 1);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\ : std_logic_vector(3 downto 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\ : std_logic_vector(57 downto 10);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_0\ : std_logic_vector(56 downto 5);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_1\ : std_logic_vector(55 downto 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_2\ : std_logic_vector(55 downto 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_1299_V\ : std_logic_vector(2 downto 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.WQSCTRL\ : std_logic_vector(68 to 68);
  signal \GRLFPC20.COMB.WRADDR_6_X\ : std_logic_vector(4 downto 0);
  signal \GRLFPC20.COMB.RS1_1_0_X\ : std_logic_vector(4 downto 0);
  signal \GRLFPC20.COMB.WRDATA_4_X\ : std_logic_vector(62 downto 0);
  signal \GRLFPC20.COMB.DBGDATA_4_0_X\ : std_logic_vector(31 downto 0);
  signal \GRLFPC20.WRDATA_0_X\ : std_logic_vector(63 downto 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.S_8\ : std_logic_vector(57 downto 2);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8\ : std_logic_vector(55 downto 2);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN8_TEMP_2\ : std_logic_vector(0 to 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_SUB\ : std_logic_vector(0 to 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.EXTEND.TEMP\ : std_logic_vector(1 downto 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_MUX_10\ : std_logic_vector(62 downto 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_MUX_13\ : std_logic_vector(62 downto 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_MUX_9\ : std_logic_vector(62 downto 7);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_MUX_3\ : std_logic_vector(62 downto 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_MUX_6\ : std_logic_vector(61 downto 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.WQSTSETS\ : std_logic_vector(9 downto 3);
  signal \GRLFPC20.FPI.OP1_X\ : std_logic_vector(63 downto 32);
  signal \GRLFPC20.COMB.V.FSR.FCC_1_0_X\ : std_logic_vector(1 downto 0);
  signal \GRLFPC20.COMB.V.FSR.FCC_1_1_X\ : std_logic_vector(1 downto 0);
  signal \GRLFPC20.COMB.V.FSR.AEXC_7_I_M\ : std_logic_vector(4 downto 0);
  signal \GRLFPC20.COMB.V.A.RF1REN_1_1_X\ : std_logic_vector(1 to 1);
  signal \GRLFPC20.COMB.RF1REN_1_0\ : std_logic_vector(1 to 1);
  signal \GRLFPC20.COMB.RF2REN_1_0\ : std_logic_vector(1 to 1);
  signal \GRLFPC20.COMB.RF1REN_1_0_X\ : std_logic_vector(2 to 2);
  signal \GRLFPC20.COMB.RF2REN_1_0_X\ : std_logic_vector(2 to 2);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.STATUS\ : std_logic_vector(6 downto 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.RESULT\ : std_logic_vector(4 to 4);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH_2\ : std_logic_vector(0 to 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.RESULT_0\ : std_logic_vector(1 to 1);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.PCTRL_NEW_12_27\ : std_logic_vector(75 to 75);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.EXPYBUS\ : std_logic_vector(9 downto 5);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_0\ : std_logic_vector(244 downto 115);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1\ : std_logic_vector(257 downto 232);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_33\ : std_logic_vector(244 downto 237);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.TOPBITSIN\ : std_logic_vector(8 downto 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.COUNTSUCCESSIVEZERO_M11\ : std_logic_vector(2 downto 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.EXPYBUS_0\ : std_logic_vector(4 to 4);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.EXPYBUS_2\ : std_logic_vector(9 downto 6);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.EXPYBUS_2_1\ : std_logic_vector(9 to 9);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_20\ : std_logic_vector(57 downto 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.COUNTSUCCESSIVEZERO_M2\ : std_logic_vector(2 downto 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL_1\ : std_logic_vector(3 downto 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.EXPXBUS_2\ : std_logic_vector(9 downto 4);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.COUNTSUCCESSIVEZERO_M14\ : std_logic_vector(3 downto 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.S_8\ : std_logic_vector(57 downto 2);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.COUNTSUCCESSIVEZERO_M12\ : std_logic_vector(2 downto 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.COUNTSUCCESSIVEZERO_M13\ : std_logic_vector(3 downto 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.COUNTSUCCESSIVEZERO_M8\ : std_logic_vector(1 downto 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.COUNTSUCCESSIVEZERO_M5\ : std_logic_vector(1 downto 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.PCTRL_NEW_12_18\ : std_logic_vector(75 to 75);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.PCTRL_NEW_12_21\ : std_logic_vector(75 to 75);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.PCTRL_NEW_12_25\ : std_logic_vector(75 to 75);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.PCTRL_NEW_12_15\ : std_logic_vector(75 to 75);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.SELECTQUOBITS.NOTDIVC\ : std_logic_vector(1 downto 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.PCTRL_NEW_12_3\ : std_logic_vector(75 to 75);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.PCTRL_NEW_12_6\ : std_logic_vector(75 to 75);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.PCTRL_NEW_12_9\ : std_logic_vector(75 to 75);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.PCTRL_NEW_12_14\ : std_logic_vector(75 to 75);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.PCTRL_NEW_12_12\ : std_logic_vector(75 to 75);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL_I_M_0\ : std_logic_vector(12 to 12);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_WQSTSETS\ : std_logic_vector(0 to 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH_125\ : std_logic_vector(4 to 4);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.CTRLXERSHFT.SUMIN_5_0\ : std_logic_vector(3 to 3);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.SUM\ : std_logic_vector(2 downto 1);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULLSBLOGIC.TEMP\ : std_logic_vector(0 to 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.SUM_I\ : std_logic_vector(0 to 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN2_MIXOIN_19_U\ : std_logic_vector(0 to 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN2_MIXOIN_9\ : std_logic_vector(0 to 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN2_MIXOIN\ : std_logic_vector(0 to 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULLSBLOGIC.TEMP_2\ : std_logic_vector(0 to 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.NOTSRRES\ : std_logic_vector(2 to 2);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.CI_114_1.SUM_0_A2\ : std_logic_vector(0 to 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULLSBLOGIC.TEMP_0\ : std_logic_vector(0 to 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_T_3\ : std_logic_vector(0 to 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.SELECTQUOBITS.QUOBITS\ : std_logic_vector(0 to 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_14\ : std_logic_vector(142 downto 141);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.2.CI_56_V\ : std_logic_vector(1 downto 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_MUX_1\ : std_logic_vector(59 downto 11);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_MUX_2\ : std_logic_vector(58 downto 11);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_MUX_5\ : std_logic_vector(62 downto 1);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_MUX_4\ : std_logic_vector(57 downto 2);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_MUX_6_0_A2\ : std_logic_vector(18 to 18);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_MUX_8\ : std_logic_vector(59 downto 12);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_MUX_11\ : std_logic_vector(62 downto 23);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_MUX_12\ : std_logic_vector(24 downto 23);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_1_X\ : std_logic_vector(25 downto 23);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_0\ : std_logic_vector(57 downto 1);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.PCTRL_NEW_12_30_S\ : std_logic_vector(75 to 75);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.PCTRL_NEW_12_30_D_0\ : std_logic_vector(75 to 75);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.PCTRL_NEW_12_30_D_0_D\ : std_logic_vector(75 to 75);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.SCTRL_39_IV\ : std_logic_vector(0 to 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.WQSCTRL_1_0\ : std_logic_vector(67 to 67);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.PCTRL_NEW_12_31_D\ : std_logic_vector(75 to 75);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.PCTRL_NEW_12_30_D_0_D_0\ : std_logic_vector(75 to 75);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.PCTRL_NEW_12_15_D\ : std_logic_vector(75 to 75);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.PCTRL_I_M_0\ : std_logic_vector(8 downto 2);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.PCTRL_NEW_12_31_S_0\ : std_logic_vector(75 to 75);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.WQSTSETS_4\ : std_logic_vector(6 downto 5);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.WQSTSETS_5\ : std_logic_vector(6 downto 5);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.WQSTSETS_0\ : std_logic_vector(4 downto 3);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.EXTEND.TEMP_1\ : std_logic_vector(1 downto 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.PCTRL_NEW_1\ : std_logic_vector(77 to 77);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL_I_M_1\ : std_logic_vector(13 to 13);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.SCTRL_39_IV_0\ : std_logic_vector(0 to 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.PCTRL_NEW_12_32_0\ : std_logic_vector(75 to 75);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.SI_1_0_A2\ : std_logic_vector(56 to 56);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.CI_114_1.SUM_5_0_A2\ : std_logic_vector(0 to 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_2\ : std_logic_vector(1 to 1);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.PCTRL_NEW_12_31\ : std_logic_vector(75 to 75);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\ : std_logic_vector(3 downto 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_1\ : std_logic_vector(0 to 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_4\ : std_logic_vector(3 to 3);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_3\ : std_logic_vector(2 to 2);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.SI_0_A2\ : std_logic_vector(56 to 56);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.PCTRL_NEW\ : std_logic_vector(77 to 77);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN8_TEMP_2_A\ : std_logic_vector(0 to 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_MUX_13_A\ : std_logic_vector(57 downto 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_MUX_10_A\ : std_logic_vector(58 downto 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_MUX_6_A\ : std_logic_vector(58 downto 3);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_MUX_3_A\ : std_logic_vector(56 downto 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_20_A\ : std_logic_vector(25 downto 3);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_A\ : std_logic_vector(54 downto 18);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_A\ : std_logic_vector(233 downto 113);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_MUX_7_A\ : std_logic_vector(48 downto 39);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.EXPXBUS_3_A\ : std_logic_vector(3 downto 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_0_A\ : std_logic_vector(57 downto 56);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES_0_A\ : std_logic_vector(32 downto 29);
  signal \GRLFPC20.COMB.V.FSR.CEXC_1_2_A_X\ : std_logic_vector(4 downto 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SXC.SCTRL_NEW_A\ : std_logic_vector(10 downto 8);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6_A\ : std_logic_vector(15 to 15);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.EXTEND.TEMP_1_A\ : std_logic_vector(1 to 1);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN2_MIXOIN_A\ : std_logic_vector(0 to 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_16_A\ : std_logic_vector(54 downto 21);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL_A\ : std_logic_vector(3 to 3);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL_I_M_0_A\ : std_logic_vector(12 to 12);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_4_A\ : std_logic_vector(56 to 56);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.EXPYBUS_2_RETI\ : std_logic_vector(6 to 6);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL_REP1\ : std_logic_vector(2 to 2);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL_REP2\ : std_logic_vector(2 to 2);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_I\ : std_logic_vector(78 to 78);
  signal CPO_DATAZ : std_logic_vector(31 downto 0);
  signal CPO_CCZ : std_logic_vector(1 downto 0);
  signal CPO_DBG_DATAZ : std_logic_vector(31 downto 0);
  signal RFI1_WRDATAZ : std_logic_vector(31 downto 0);
  signal RFI2_RD1ADDRZ : std_logic_vector(3 downto 0);
  signal RFI2_RD2ADDRZ : std_logic_vector(3 downto 0);
  signal RFI2_WRADDRZ : std_logic_vector(3 downto 0);
  signal RFI2_WRDATAZ : std_logic_vector(31 downto 0);
  signal CLK_INTERNAL : std_logic ;
  signal CPI_FLUSH_INTERNAL : std_logic ;
  signal CPI_EXACK_INTERNAL : std_logic ;
  signal CPI_A_RS1_INTERNAL : std_logic ;
  signal CPI_A_RS1_INTERNAL_0 : std_logic ;
  signal CPI_A_RS1_INTERNAL_1 : std_logic ;
  signal CPI_A_RS1_INTERNAL_2 : std_logic ;
  signal CPI_A_RS1_INTERNAL_3 : std_logic ;
  signal CPI_D_PC_INTERNAL : std_logic ;
  signal CPI_D_PC_INTERNAL_0 : std_logic ;
  signal CPI_D_PC_INTERNAL_1 : std_logic ;
  signal CPI_D_PC_INTERNAL_2 : std_logic ;
  signal CPI_D_PC_INTERNAL_3 : std_logic ;
  signal CPI_D_PC_INTERNAL_4 : std_logic ;
  signal CPI_D_PC_INTERNAL_5 : std_logic ;
  signal CPI_D_PC_INTERNAL_6 : std_logic ;
  signal CPI_D_PC_INTERNAL_7 : std_logic ;
  signal CPI_D_PC_INTERNAL_8 : std_logic ;
  signal CPI_D_PC_INTERNAL_9 : std_logic ;
  signal CPI_D_PC_INTERNAL_10 : std_logic ;
  signal CPI_D_PC_INTERNAL_11 : std_logic ;
  signal CPI_D_PC_INTERNAL_12 : std_logic ;
  signal CPI_D_PC_INTERNAL_13 : std_logic ;
  signal CPI_D_PC_INTERNAL_14 : std_logic ;
  signal CPI_D_PC_INTERNAL_15 : std_logic ;
  signal CPI_D_PC_INTERNAL_16 : std_logic ;
  signal CPI_D_PC_INTERNAL_17 : std_logic ;
  signal CPI_D_PC_INTERNAL_18 : std_logic ;
  signal CPI_D_PC_INTERNAL_19 : std_logic ;
  signal CPI_D_PC_INTERNAL_20 : std_logic ;
  signal CPI_D_PC_INTERNAL_21 : std_logic ;
  signal CPI_D_PC_INTERNAL_22 : std_logic ;
  signal CPI_D_PC_INTERNAL_23 : std_logic ;
  signal CPI_D_PC_INTERNAL_24 : std_logic ;
  signal CPI_D_PC_INTERNAL_25 : std_logic ;
  signal CPI_D_PC_INTERNAL_26 : std_logic ;
  signal CPI_D_PC_INTERNAL_27 : std_logic ;
  signal CPI_D_PC_INTERNAL_28 : std_logic ;
  signal CPI_D_PC_INTERNAL_29 : std_logic ;
  signal CPI_D_PC_INTERNAL_30 : std_logic ;
  signal CPI_D_INST_INTERNAL : std_logic ;
  signal CPI_D_INST_INTERNAL_0 : std_logic ;
  signal CPI_D_INST_INTERNAL_1 : std_logic ;
  signal CPI_D_INST_INTERNAL_2 : std_logic ;
  signal CPI_D_INST_INTERNAL_3 : std_logic ;
  signal CPI_D_INST_INTERNAL_4 : std_logic ;
  signal CPI_D_INST_INTERNAL_5 : std_logic ;
  signal CPI_D_INST_INTERNAL_6 : std_logic ;
  signal CPI_D_INST_INTERNAL_7 : std_logic ;
  signal CPI_D_INST_INTERNAL_8 : std_logic ;
  signal CPI_D_INST_INTERNAL_9 : std_logic ;
  signal CPI_D_INST_INTERNAL_10 : std_logic ;
  signal CPI_D_INST_INTERNAL_11 : std_logic ;
  signal CPI_D_INST_INTERNAL_12 : std_logic ;
  signal CPI_D_INST_INTERNAL_13 : std_logic ;
  signal CPI_D_INST_INTERNAL_14 : std_logic ;
  signal CPI_D_INST_INTERNAL_15 : std_logic ;
  signal CPI_D_INST_INTERNAL_16 : std_logic ;
  signal CPI_D_INST_INTERNAL_17 : std_logic ;
  signal CPI_D_INST_INTERNAL_18 : std_logic ;
  signal CPI_D_INST_INTERNAL_19 : std_logic ;
  signal CPI_D_INST_INTERNAL_20 : std_logic ;
  signal CPI_D_INST_INTERNAL_21 : std_logic ;
  signal CPI_D_INST_INTERNAL_22 : std_logic ;
  signal CPI_D_INST_INTERNAL_23 : std_logic ;
  signal CPI_D_INST_INTERNAL_24 : std_logic ;
  signal CPI_D_INST_INTERNAL_25 : std_logic ;
  signal CPI_D_INST_INTERNAL_26 : std_logic ;
  signal CPI_D_INST_INTERNAL_27 : std_logic ;
  signal CPI_D_INST_INTERNAL_28 : std_logic ;
  signal CPI_D_INST_INTERNAL_29 : std_logic ;
  signal CPI_D_INST_INTERNAL_30 : std_logic ;
  signal CPI_D_CNT_INTERNAL : std_logic ;
  signal CPI_D_CNT_INTERNAL_0 : std_logic ;
  signal CPI_D_TRAP_INTERNAL : std_logic ;
  signal CPI_D_ANNUL_INTERNAL : std_logic ;
  signal CPI_D_PV_INTERNAL : std_logic ;
  signal CPI_A_PC_INTERNAL : std_logic ;
  signal CPI_A_PC_INTERNAL_0 : std_logic ;
  signal CPI_A_PC_INTERNAL_1 : std_logic ;
  signal CPI_A_PC_INTERNAL_2 : std_logic ;
  signal CPI_A_PC_INTERNAL_3 : std_logic ;
  signal CPI_A_PC_INTERNAL_4 : std_logic ;
  signal CPI_A_PC_INTERNAL_5 : std_logic ;
  signal CPI_A_PC_INTERNAL_6 : std_logic ;
  signal CPI_A_PC_INTERNAL_7 : std_logic ;
  signal CPI_A_PC_INTERNAL_8 : std_logic ;
  signal CPI_A_PC_INTERNAL_9 : std_logic ;
  signal CPI_A_PC_INTERNAL_10 : std_logic ;
  signal CPI_A_PC_INTERNAL_11 : std_logic ;
  signal CPI_A_PC_INTERNAL_12 : std_logic ;
  signal CPI_A_PC_INTERNAL_13 : std_logic ;
  signal CPI_A_PC_INTERNAL_14 : std_logic ;
  signal CPI_A_PC_INTERNAL_15 : std_logic ;
  signal CPI_A_PC_INTERNAL_16 : std_logic ;
  signal CPI_A_PC_INTERNAL_17 : std_logic ;
  signal CPI_A_PC_INTERNAL_18 : std_logic ;
  signal CPI_A_PC_INTERNAL_19 : std_logic ;
  signal CPI_A_PC_INTERNAL_20 : std_logic ;
  signal CPI_A_PC_INTERNAL_21 : std_logic ;
  signal CPI_A_PC_INTERNAL_22 : std_logic ;
  signal CPI_A_PC_INTERNAL_23 : std_logic ;
  signal CPI_A_PC_INTERNAL_24 : std_logic ;
  signal CPI_A_PC_INTERNAL_25 : std_logic ;
  signal CPI_A_PC_INTERNAL_26 : std_logic ;
  signal CPI_A_PC_INTERNAL_27 : std_logic ;
  signal CPI_A_PC_INTERNAL_28 : std_logic ;
  signal CPI_A_PC_INTERNAL_29 : std_logic ;
  signal CPI_A_PC_INTERNAL_30 : std_logic ;
  signal CPI_A_INST_INTERNAL : std_logic ;
  signal CPI_A_INST_INTERNAL_0 : std_logic ;
  signal CPI_A_INST_INTERNAL_1 : std_logic ;
  signal CPI_A_INST_INTERNAL_2 : std_logic ;
  signal CPI_A_INST_INTERNAL_3 : std_logic ;
  signal CPI_A_INST_INTERNAL_4 : std_logic ;
  signal CPI_A_INST_INTERNAL_5 : std_logic ;
  signal CPI_A_INST_INTERNAL_6 : std_logic ;
  signal CPI_A_INST_INTERNAL_7 : std_logic ;
  signal CPI_A_INST_INTERNAL_8 : std_logic ;
  signal CPI_A_INST_INTERNAL_9 : std_logic ;
  signal CPI_A_INST_INTERNAL_10 : std_logic ;
  signal CPI_A_INST_INTERNAL_11 : std_logic ;
  signal CPI_A_INST_INTERNAL_12 : std_logic ;
  signal CPI_A_INST_INTERNAL_13 : std_logic ;
  signal CPI_A_INST_INTERNAL_14 : std_logic ;
  signal CPI_A_INST_INTERNAL_15 : std_logic ;
  signal CPI_A_INST_INTERNAL_16 : std_logic ;
  signal CPI_A_INST_INTERNAL_17 : std_logic ;
  signal CPI_A_INST_INTERNAL_18 : std_logic ;
  signal CPI_A_INST_INTERNAL_19 : std_logic ;
  signal CPI_A_INST_INTERNAL_20 : std_logic ;
  signal CPI_A_INST_INTERNAL_21 : std_logic ;
  signal CPI_A_INST_INTERNAL_22 : std_logic ;
  signal CPI_A_INST_INTERNAL_23 : std_logic ;
  signal CPI_A_INST_INTERNAL_24 : std_logic ;
  signal CPI_A_INST_INTERNAL_25 : std_logic ;
  signal CPI_A_INST_INTERNAL_26 : std_logic ;
  signal CPI_A_INST_INTERNAL_27 : std_logic ;
  signal CPI_A_INST_INTERNAL_28 : std_logic ;
  signal CPI_A_INST_INTERNAL_29 : std_logic ;
  signal CPI_A_INST_INTERNAL_30 : std_logic ;
  signal CPI_A_CNT_INTERNAL : std_logic ;
  signal CPI_A_CNT_INTERNAL_0 : std_logic ;
  signal CPI_A_TRAP_INTERNAL : std_logic ;
  signal CPI_A_ANNUL_INTERNAL : std_logic ;
  signal CPI_A_PV_INTERNAL : std_logic ;
  signal CPI_E_PC_INTERNAL : std_logic ;
  signal CPI_E_PC_INTERNAL_0 : std_logic ;
  signal CPI_E_PC_INTERNAL_1 : std_logic ;
  signal CPI_E_PC_INTERNAL_2 : std_logic ;
  signal CPI_E_PC_INTERNAL_3 : std_logic ;
  signal CPI_E_PC_INTERNAL_4 : std_logic ;
  signal CPI_E_PC_INTERNAL_5 : std_logic ;
  signal CPI_E_PC_INTERNAL_6 : std_logic ;
  signal CPI_E_PC_INTERNAL_7 : std_logic ;
  signal CPI_E_PC_INTERNAL_8 : std_logic ;
  signal CPI_E_PC_INTERNAL_9 : std_logic ;
  signal CPI_E_PC_INTERNAL_10 : std_logic ;
  signal CPI_E_PC_INTERNAL_11 : std_logic ;
  signal CPI_E_PC_INTERNAL_12 : std_logic ;
  signal CPI_E_PC_INTERNAL_13 : std_logic ;
  signal CPI_E_PC_INTERNAL_14 : std_logic ;
  signal CPI_E_PC_INTERNAL_15 : std_logic ;
  signal CPI_E_PC_INTERNAL_16 : std_logic ;
  signal CPI_E_PC_INTERNAL_17 : std_logic ;
  signal CPI_E_PC_INTERNAL_18 : std_logic ;
  signal CPI_E_PC_INTERNAL_19 : std_logic ;
  signal CPI_E_PC_INTERNAL_20 : std_logic ;
  signal CPI_E_PC_INTERNAL_21 : std_logic ;
  signal CPI_E_PC_INTERNAL_22 : std_logic ;
  signal CPI_E_PC_INTERNAL_23 : std_logic ;
  signal CPI_E_PC_INTERNAL_24 : std_logic ;
  signal CPI_E_PC_INTERNAL_25 : std_logic ;
  signal CPI_E_PC_INTERNAL_26 : std_logic ;
  signal CPI_E_PC_INTERNAL_27 : std_logic ;
  signal CPI_E_PC_INTERNAL_28 : std_logic ;
  signal CPI_E_PC_INTERNAL_29 : std_logic ;
  signal CPI_E_PC_INTERNAL_30 : std_logic ;
  signal CPI_E_INST_INTERNAL : std_logic ;
  signal CPI_E_INST_INTERNAL_0 : std_logic ;
  signal CPI_E_INST_INTERNAL_1 : std_logic ;
  signal CPI_E_INST_INTERNAL_2 : std_logic ;
  signal CPI_E_INST_INTERNAL_3 : std_logic ;
  signal CPI_E_INST_INTERNAL_4 : std_logic ;
  signal CPI_E_INST_INTERNAL_5 : std_logic ;
  signal CPI_E_INST_INTERNAL_6 : std_logic ;
  signal CPI_E_INST_INTERNAL_7 : std_logic ;
  signal CPI_E_INST_INTERNAL_8 : std_logic ;
  signal CPI_E_INST_INTERNAL_9 : std_logic ;
  signal CPI_E_INST_INTERNAL_10 : std_logic ;
  signal CPI_E_INST_INTERNAL_11 : std_logic ;
  signal CPI_E_INST_INTERNAL_12 : std_logic ;
  signal CPI_E_INST_INTERNAL_13 : std_logic ;
  signal CPI_E_INST_INTERNAL_14 : std_logic ;
  signal CPI_E_INST_INTERNAL_15 : std_logic ;
  signal CPI_E_INST_INTERNAL_16 : std_logic ;
  signal CPI_E_INST_INTERNAL_17 : std_logic ;
  signal CPI_E_INST_INTERNAL_18 : std_logic ;
  signal CPI_E_INST_INTERNAL_19 : std_logic ;
  signal CPI_E_INST_INTERNAL_20 : std_logic ;
  signal CPI_E_INST_INTERNAL_21 : std_logic ;
  signal CPI_E_INST_INTERNAL_22 : std_logic ;
  signal CPI_E_INST_INTERNAL_23 : std_logic ;
  signal CPI_E_INST_INTERNAL_24 : std_logic ;
  signal CPI_E_INST_INTERNAL_25 : std_logic ;
  signal CPI_E_INST_INTERNAL_26 : std_logic ;
  signal CPI_E_INST_INTERNAL_27 : std_logic ;
  signal CPI_E_INST_INTERNAL_28 : std_logic ;
  signal CPI_E_INST_INTERNAL_29 : std_logic ;
  signal CPI_E_INST_INTERNAL_30 : std_logic ;
  signal CPI_E_CNT_INTERNAL : std_logic ;
  signal CPI_E_CNT_INTERNAL_0 : std_logic ;
  signal CPI_E_TRAP_INTERNAL : std_logic ;
  signal CPI_E_ANNUL_INTERNAL : std_logic ;
  signal CPI_E_PV_INTERNAL : std_logic ;
  signal CPI_M_PC_INTERNAL : std_logic ;
  signal CPI_M_PC_INTERNAL_0 : std_logic ;
  signal CPI_M_PC_INTERNAL_1 : std_logic ;
  signal CPI_M_PC_INTERNAL_2 : std_logic ;
  signal CPI_M_PC_INTERNAL_3 : std_logic ;
  signal CPI_M_PC_INTERNAL_4 : std_logic ;
  signal CPI_M_PC_INTERNAL_5 : std_logic ;
  signal CPI_M_PC_INTERNAL_6 : std_logic ;
  signal CPI_M_PC_INTERNAL_7 : std_logic ;
  signal CPI_M_PC_INTERNAL_8 : std_logic ;
  signal CPI_M_PC_INTERNAL_9 : std_logic ;
  signal CPI_M_PC_INTERNAL_10 : std_logic ;
  signal CPI_M_PC_INTERNAL_11 : std_logic ;
  signal CPI_M_PC_INTERNAL_12 : std_logic ;
  signal CPI_M_PC_INTERNAL_13 : std_logic ;
  signal CPI_M_PC_INTERNAL_14 : std_logic ;
  signal CPI_M_PC_INTERNAL_15 : std_logic ;
  signal CPI_M_PC_INTERNAL_16 : std_logic ;
  signal CPI_M_PC_INTERNAL_17 : std_logic ;
  signal CPI_M_PC_INTERNAL_18 : std_logic ;
  signal CPI_M_PC_INTERNAL_19 : std_logic ;
  signal CPI_M_PC_INTERNAL_20 : std_logic ;
  signal CPI_M_PC_INTERNAL_21 : std_logic ;
  signal CPI_M_PC_INTERNAL_22 : std_logic ;
  signal CPI_M_PC_INTERNAL_23 : std_logic ;
  signal CPI_M_PC_INTERNAL_24 : std_logic ;
  signal CPI_M_PC_INTERNAL_25 : std_logic ;
  signal CPI_M_PC_INTERNAL_26 : std_logic ;
  signal CPI_M_PC_INTERNAL_27 : std_logic ;
  signal CPI_M_PC_INTERNAL_28 : std_logic ;
  signal CPI_M_PC_INTERNAL_29 : std_logic ;
  signal CPI_M_PC_INTERNAL_30 : std_logic ;
  signal CPI_M_INST_INTERNAL : std_logic ;
  signal CPI_M_INST_INTERNAL_0 : std_logic ;
  signal CPI_M_INST_INTERNAL_1 : std_logic ;
  signal CPI_M_INST_INTERNAL_2 : std_logic ;
  signal CPI_M_INST_INTERNAL_3 : std_logic ;
  signal CPI_M_INST_INTERNAL_4 : std_logic ;
  signal CPI_M_INST_INTERNAL_5 : std_logic ;
  signal CPI_M_INST_INTERNAL_6 : std_logic ;
  signal CPI_M_INST_INTERNAL_7 : std_logic ;
  signal CPI_M_INST_INTERNAL_8 : std_logic ;
  signal CPI_M_INST_INTERNAL_9 : std_logic ;
  signal CPI_M_INST_INTERNAL_10 : std_logic ;
  signal CPI_M_INST_INTERNAL_11 : std_logic ;
  signal CPI_M_INST_INTERNAL_12 : std_logic ;
  signal CPI_M_INST_INTERNAL_13 : std_logic ;
  signal CPI_M_INST_INTERNAL_14 : std_logic ;
  signal CPI_M_INST_INTERNAL_15 : std_logic ;
  signal CPI_M_INST_INTERNAL_16 : std_logic ;
  signal CPI_M_INST_INTERNAL_17 : std_logic ;
  signal CPI_M_INST_INTERNAL_18 : std_logic ;
  signal CPI_M_INST_INTERNAL_19 : std_logic ;
  signal CPI_M_INST_INTERNAL_20 : std_logic ;
  signal CPI_M_INST_INTERNAL_21 : std_logic ;
  signal CPI_M_INST_INTERNAL_22 : std_logic ;
  signal CPI_M_INST_INTERNAL_23 : std_logic ;
  signal CPI_M_INST_INTERNAL_24 : std_logic ;
  signal CPI_M_INST_INTERNAL_25 : std_logic ;
  signal CPI_M_INST_INTERNAL_26 : std_logic ;
  signal CPI_M_INST_INTERNAL_27 : std_logic ;
  signal CPI_M_INST_INTERNAL_28 : std_logic ;
  signal CPI_M_INST_INTERNAL_29 : std_logic ;
  signal CPI_M_INST_INTERNAL_30 : std_logic ;
  signal CPI_M_CNT_INTERNAL : std_logic ;
  signal CPI_M_CNT_INTERNAL_0 : std_logic ;
  signal CPI_M_TRAP_INTERNAL : std_logic ;
  signal CPI_M_ANNUL_INTERNAL : std_logic ;
  signal CPI_M_PV_INTERNAL : std_logic ;
  signal CPI_X_PC_INTERNAL : std_logic ;
  signal CPI_X_PC_INTERNAL_0 : std_logic ;
  signal CPI_X_PC_INTERNAL_1 : std_logic ;
  signal CPI_X_PC_INTERNAL_2 : std_logic ;
  signal CPI_X_PC_INTERNAL_3 : std_logic ;
  signal CPI_X_PC_INTERNAL_4 : std_logic ;
  signal CPI_X_PC_INTERNAL_5 : std_logic ;
  signal CPI_X_PC_INTERNAL_6 : std_logic ;
  signal CPI_X_PC_INTERNAL_7 : std_logic ;
  signal CPI_X_PC_INTERNAL_8 : std_logic ;
  signal CPI_X_PC_INTERNAL_9 : std_logic ;
  signal CPI_X_PC_INTERNAL_10 : std_logic ;
  signal CPI_X_PC_INTERNAL_11 : std_logic ;
  signal CPI_X_PC_INTERNAL_12 : std_logic ;
  signal CPI_X_PC_INTERNAL_13 : std_logic ;
  signal CPI_X_PC_INTERNAL_14 : std_logic ;
  signal CPI_X_PC_INTERNAL_15 : std_logic ;
  signal CPI_X_PC_INTERNAL_16 : std_logic ;
  signal CPI_X_PC_INTERNAL_17 : std_logic ;
  signal CPI_X_PC_INTERNAL_18 : std_logic ;
  signal CPI_X_PC_INTERNAL_19 : std_logic ;
  signal CPI_X_PC_INTERNAL_20 : std_logic ;
  signal CPI_X_PC_INTERNAL_21 : std_logic ;
  signal CPI_X_PC_INTERNAL_22 : std_logic ;
  signal CPI_X_PC_INTERNAL_23 : std_logic ;
  signal CPI_X_PC_INTERNAL_24 : std_logic ;
  signal CPI_X_PC_INTERNAL_25 : std_logic ;
  signal CPI_X_PC_INTERNAL_26 : std_logic ;
  signal CPI_X_PC_INTERNAL_27 : std_logic ;
  signal CPI_X_PC_INTERNAL_28 : std_logic ;
  signal CPI_X_PC_INTERNAL_29 : std_logic ;
  signal CPI_X_PC_INTERNAL_30 : std_logic ;
  signal CPI_X_INST_INTERNAL : std_logic ;
  signal CPI_X_INST_INTERNAL_0 : std_logic ;
  signal CPI_X_INST_INTERNAL_1 : std_logic ;
  signal CPI_X_INST_INTERNAL_2 : std_logic ;
  signal CPI_X_INST_INTERNAL_3 : std_logic ;
  signal CPI_X_INST_INTERNAL_4 : std_logic ;
  signal CPI_X_INST_INTERNAL_5 : std_logic ;
  signal CPI_X_INST_INTERNAL_6 : std_logic ;
  signal CPI_X_INST_INTERNAL_7 : std_logic ;
  signal CPI_X_INST_INTERNAL_8 : std_logic ;
  signal CPI_X_INST_INTERNAL_9 : std_logic ;
  signal CPI_X_INST_INTERNAL_10 : std_logic ;
  signal CPI_X_INST_INTERNAL_11 : std_logic ;
  signal CPI_X_INST_INTERNAL_12 : std_logic ;
  signal CPI_X_INST_INTERNAL_13 : std_logic ;
  signal CPI_X_INST_INTERNAL_14 : std_logic ;
  signal CPI_X_INST_INTERNAL_15 : std_logic ;
  signal CPI_X_INST_INTERNAL_16 : std_logic ;
  signal CPI_X_INST_INTERNAL_17 : std_logic ;
  signal CPI_X_INST_INTERNAL_18 : std_logic ;
  signal CPI_X_INST_INTERNAL_19 : std_logic ;
  signal CPI_X_INST_INTERNAL_20 : std_logic ;
  signal CPI_X_INST_INTERNAL_21 : std_logic ;
  signal CPI_X_INST_INTERNAL_22 : std_logic ;
  signal CPI_X_INST_INTERNAL_23 : std_logic ;
  signal CPI_X_INST_INTERNAL_24 : std_logic ;
  signal CPI_X_INST_INTERNAL_25 : std_logic ;
  signal CPI_X_INST_INTERNAL_26 : std_logic ;
  signal CPI_X_INST_INTERNAL_27 : std_logic ;
  signal CPI_X_INST_INTERNAL_28 : std_logic ;
  signal CPI_X_INST_INTERNAL_29 : std_logic ;
  signal CPI_X_INST_INTERNAL_30 : std_logic ;
  signal CPI_X_CNT_INTERNAL : std_logic ;
  signal CPI_X_CNT_INTERNAL_0 : std_logic ;
  signal CPI_X_TRAP_INTERNAL : std_logic ;
  signal CPI_X_ANNUL_INTERNAL : std_logic ;
  signal CPI_X_PV_INTERNAL : std_logic ;
  signal CPI_LDDATA_INTERNAL : std_logic ;
  signal CPI_LDDATA_INTERNAL_0 : std_logic ;
  signal CPI_LDDATA_INTERNAL_1 : std_logic ;
  signal CPI_LDDATA_INTERNAL_2 : std_logic ;
  signal CPI_LDDATA_INTERNAL_3 : std_logic ;
  signal CPI_LDDATA_INTERNAL_4 : std_logic ;
  signal CPI_LDDATA_INTERNAL_5 : std_logic ;
  signal CPI_LDDATA_INTERNAL_6 : std_logic ;
  signal CPI_LDDATA_INTERNAL_7 : std_logic ;
  signal CPI_LDDATA_INTERNAL_8 : std_logic ;
  signal CPI_LDDATA_INTERNAL_9 : std_logic ;
  signal CPI_LDDATA_INTERNAL_10 : std_logic ;
  signal CPI_LDDATA_INTERNAL_11 : std_logic ;
  signal CPI_LDDATA_INTERNAL_12 : std_logic ;
  signal CPI_LDDATA_INTERNAL_13 : std_logic ;
  signal CPI_LDDATA_INTERNAL_14 : std_logic ;
  signal CPI_LDDATA_INTERNAL_15 : std_logic ;
  signal CPI_LDDATA_INTERNAL_16 : std_logic ;
  signal CPI_LDDATA_INTERNAL_17 : std_logic ;
  signal CPI_LDDATA_INTERNAL_18 : std_logic ;
  signal CPI_LDDATA_INTERNAL_19 : std_logic ;
  signal CPI_LDDATA_INTERNAL_20 : std_logic ;
  signal CPI_LDDATA_INTERNAL_21 : std_logic ;
  signal CPI_LDDATA_INTERNAL_22 : std_logic ;
  signal CPI_LDDATA_INTERNAL_23 : std_logic ;
  signal CPI_LDDATA_INTERNAL_24 : std_logic ;
  signal CPI_LDDATA_INTERNAL_25 : std_logic ;
  signal CPI_LDDATA_INTERNAL_26 : std_logic ;
  signal CPI_LDDATA_INTERNAL_27 : std_logic ;
  signal CPI_LDDATA_INTERNAL_28 : std_logic ;
  signal CPI_LDDATA_INTERNAL_29 : std_logic ;
  signal CPI_LDDATA_INTERNAL_30 : std_logic ;
  signal CPI_DBG_ENABLE_INTERNAL : std_logic ;
  signal CPI_DBG_WRITE_INTERNAL : std_logic ;
  signal CPI_DBG_ADDR_INTERNAL_0 : std_logic ;
  signal CPI_DBG_ADDR_INTERNAL_1 : std_logic ;
  signal CPI_DBG_ADDR_INTERNAL_2 : std_logic ;
  signal CPI_DBG_ADDR_INTERNAL_3 : std_logic ;
  signal CPI_DBG_DATA_INTERNAL : std_logic ;
  signal CPI_DBG_DATA_INTERNAL_0 : std_logic ;
  signal CPI_DBG_DATA_INTERNAL_1 : std_logic ;
  signal CPI_DBG_DATA_INTERNAL_2 : std_logic ;
  signal CPI_DBG_DATA_INTERNAL_3 : std_logic ;
  signal CPI_DBG_DATA_INTERNAL_4 : std_logic ;
  signal CPI_DBG_DATA_INTERNAL_5 : std_logic ;
  signal CPI_DBG_DATA_INTERNAL_6 : std_logic ;
  signal CPI_DBG_DATA_INTERNAL_7 : std_logic ;
  signal CPI_DBG_DATA_INTERNAL_8 : std_logic ;
  signal CPI_DBG_DATA_INTERNAL_9 : std_logic ;
  signal CPI_DBG_DATA_INTERNAL_10 : std_logic ;
  signal CPI_DBG_DATA_INTERNAL_11 : std_logic ;
  signal CPI_DBG_DATA_INTERNAL_12 : std_logic ;
  signal CPI_DBG_DATA_INTERNAL_13 : std_logic ;
  signal CPI_DBG_DATA_INTERNAL_14 : std_logic ;
  signal CPI_DBG_DATA_INTERNAL_15 : std_logic ;
  signal CPI_DBG_DATA_INTERNAL_16 : std_logic ;
  signal CPI_DBG_DATA_INTERNAL_17 : std_logic ;
  signal CPI_DBG_DATA_INTERNAL_18 : std_logic ;
  signal CPI_DBG_DATA_INTERNAL_19 : std_logic ;
  signal CPI_DBG_DATA_INTERNAL_20 : std_logic ;
  signal CPI_DBG_DATA_INTERNAL_21 : std_logic ;
  signal CPI_DBG_DATA_INTERNAL_22 : std_logic ;
  signal CPI_DBG_DATA_INTERNAL_23 : std_logic ;
  signal CPI_DBG_DATA_INTERNAL_24 : std_logic ;
  signal CPI_DBG_DATA_INTERNAL_25 : std_logic ;
  signal CPI_DBG_DATA_INTERNAL_26 : std_logic ;
  signal CPI_DBG_DATA_INTERNAL_27 : std_logic ;
  signal CPI_DBG_DATA_INTERNAL_28 : std_logic ;
  signal CPI_DBG_DATA_INTERNAL_29 : std_logic ;
  signal CPI_DBG_DATA_INTERNAL_30 : std_logic ;
  signal RFO1_DATA1_INTERNAL : std_logic ;
  signal RFO1_DATA1_INTERNAL_0 : std_logic ;
  signal RFO1_DATA1_INTERNAL_1 : std_logic ;
  signal RFO1_DATA1_INTERNAL_2 : std_logic ;
  signal RFO1_DATA1_INTERNAL_3 : std_logic ;
  signal RFO1_DATA1_INTERNAL_4 : std_logic ;
  signal RFO1_DATA1_INTERNAL_5 : std_logic ;
  signal RFO1_DATA1_INTERNAL_6 : std_logic ;
  signal RFO1_DATA1_INTERNAL_7 : std_logic ;
  signal RFO1_DATA1_INTERNAL_8 : std_logic ;
  signal RFO1_DATA1_INTERNAL_9 : std_logic ;
  signal RFO1_DATA1_INTERNAL_10 : std_logic ;
  signal RFO1_DATA1_INTERNAL_11 : std_logic ;
  signal RFO1_DATA1_INTERNAL_12 : std_logic ;
  signal RFO1_DATA1_INTERNAL_13 : std_logic ;
  signal RFO1_DATA1_INTERNAL_14 : std_logic ;
  signal RFO1_DATA1_INTERNAL_15 : std_logic ;
  signal RFO1_DATA1_INTERNAL_16 : std_logic ;
  signal RFO1_DATA1_INTERNAL_17 : std_logic ;
  signal RFO1_DATA1_INTERNAL_18 : std_logic ;
  signal RFO1_DATA1_INTERNAL_19 : std_logic ;
  signal RFO1_DATA1_INTERNAL_20 : std_logic ;
  signal RFO1_DATA1_INTERNAL_21 : std_logic ;
  signal RFO1_DATA1_INTERNAL_22 : std_logic ;
  signal RFO1_DATA1_INTERNAL_23 : std_logic ;
  signal RFO1_DATA1_INTERNAL_24 : std_logic ;
  signal RFO1_DATA1_INTERNAL_25 : std_logic ;
  signal RFO1_DATA1_INTERNAL_26 : std_logic ;
  signal RFO1_DATA1_INTERNAL_27 : std_logic ;
  signal RFO1_DATA1_INTERNAL_28 : std_logic ;
  signal RFO1_DATA1_INTERNAL_29 : std_logic ;
  signal RFO1_DATA1_INTERNAL_30 : std_logic ;
  signal RFO1_DATA2_INTERNAL : std_logic ;
  signal RFO1_DATA2_INTERNAL_0 : std_logic ;
  signal RFO1_DATA2_INTERNAL_1 : std_logic ;
  signal RFO1_DATA2_INTERNAL_2 : std_logic ;
  signal RFO1_DATA2_INTERNAL_3 : std_logic ;
  signal RFO1_DATA2_INTERNAL_4 : std_logic ;
  signal RFO1_DATA2_INTERNAL_5 : std_logic ;
  signal RFO1_DATA2_INTERNAL_6 : std_logic ;
  signal RFO1_DATA2_INTERNAL_7 : std_logic ;
  signal RFO1_DATA2_INTERNAL_8 : std_logic ;
  signal RFO1_DATA2_INTERNAL_9 : std_logic ;
  signal RFO1_DATA2_INTERNAL_10 : std_logic ;
  signal RFO1_DATA2_INTERNAL_11 : std_logic ;
  signal RFO1_DATA2_INTERNAL_12 : std_logic ;
  signal RFO1_DATA2_INTERNAL_13 : std_logic ;
  signal RFO1_DATA2_INTERNAL_14 : std_logic ;
  signal RFO1_DATA2_INTERNAL_15 : std_logic ;
  signal RFO1_DATA2_INTERNAL_16 : std_logic ;
  signal RFO1_DATA2_INTERNAL_17 : std_logic ;
  signal RFO1_DATA2_INTERNAL_18 : std_logic ;
  signal RFO1_DATA2_INTERNAL_19 : std_logic ;
  signal RFO1_DATA2_INTERNAL_20 : std_logic ;
  signal RFO1_DATA2_INTERNAL_21 : std_logic ;
  signal RFO1_DATA2_INTERNAL_22 : std_logic ;
  signal RFO1_DATA2_INTERNAL_23 : std_logic ;
  signal RFO1_DATA2_INTERNAL_24 : std_logic ;
  signal RFO1_DATA2_INTERNAL_25 : std_logic ;
  signal RFO1_DATA2_INTERNAL_26 : std_logic ;
  signal RFO1_DATA2_INTERNAL_27 : std_logic ;
  signal RFO1_DATA2_INTERNAL_28 : std_logic ;
  signal RFO1_DATA2_INTERNAL_29 : std_logic ;
  signal RFO1_DATA2_INTERNAL_30 : std_logic ;
  signal RFO2_DATA1_INTERNAL : std_logic ;
  signal RFO2_DATA1_INTERNAL_0 : std_logic ;
  signal RFO2_DATA1_INTERNAL_1 : std_logic ;
  signal RFO2_DATA1_INTERNAL_2 : std_logic ;
  signal RFO2_DATA1_INTERNAL_3 : std_logic ;
  signal RFO2_DATA1_INTERNAL_4 : std_logic ;
  signal RFO2_DATA1_INTERNAL_5 : std_logic ;
  signal RFO2_DATA1_INTERNAL_6 : std_logic ;
  signal RFO2_DATA1_INTERNAL_7 : std_logic ;
  signal RFO2_DATA1_INTERNAL_8 : std_logic ;
  signal RFO2_DATA1_INTERNAL_9 : std_logic ;
  signal RFO2_DATA1_INTERNAL_10 : std_logic ;
  signal RFO2_DATA1_INTERNAL_11 : std_logic ;
  signal RFO2_DATA1_INTERNAL_12 : std_logic ;
  signal RFO2_DATA1_INTERNAL_13 : std_logic ;
  signal RFO2_DATA1_INTERNAL_14 : std_logic ;
  signal RFO2_DATA1_INTERNAL_15 : std_logic ;
  signal RFO2_DATA1_INTERNAL_16 : std_logic ;
  signal RFO2_DATA1_INTERNAL_17 : std_logic ;
  signal RFO2_DATA1_INTERNAL_18 : std_logic ;
  signal RFO2_DATA1_INTERNAL_19 : std_logic ;
  signal RFO2_DATA1_INTERNAL_20 : std_logic ;
  signal RFO2_DATA1_INTERNAL_21 : std_logic ;
  signal RFO2_DATA1_INTERNAL_22 : std_logic ;
  signal RFO2_DATA1_INTERNAL_23 : std_logic ;
  signal RFO2_DATA1_INTERNAL_24 : std_logic ;
  signal RFO2_DATA1_INTERNAL_25 : std_logic ;
  signal RFO2_DATA1_INTERNAL_26 : std_logic ;
  signal RFO2_DATA1_INTERNAL_27 : std_logic ;
  signal RFO2_DATA1_INTERNAL_28 : std_logic ;
  signal RFO2_DATA1_INTERNAL_29 : std_logic ;
  signal RFO2_DATA1_INTERNAL_30 : std_logic ;
  signal RFO2_DATA2_INTERNAL : std_logic ;
  signal RFO2_DATA2_INTERNAL_0 : std_logic ;
  signal RFO2_DATA2_INTERNAL_1 : std_logic ;
  signal RFO2_DATA2_INTERNAL_2 : std_logic ;
  signal RFO2_DATA2_INTERNAL_3 : std_logic ;
  signal RFO2_DATA2_INTERNAL_4 : std_logic ;
  signal RFO2_DATA2_INTERNAL_5 : std_logic ;
  signal RFO2_DATA2_INTERNAL_6 : std_logic ;
  signal RFO2_DATA2_INTERNAL_7 : std_logic ;
  signal RFO2_DATA2_INTERNAL_8 : std_logic ;
  signal RFO2_DATA2_INTERNAL_9 : std_logic ;
  signal RFO2_DATA2_INTERNAL_10 : std_logic ;
  signal RFO2_DATA2_INTERNAL_11 : std_logic ;
  signal RFO2_DATA2_INTERNAL_12 : std_logic ;
  signal RFO2_DATA2_INTERNAL_13 : std_logic ;
  signal RFO2_DATA2_INTERNAL_14 : std_logic ;
  signal RFO2_DATA2_INTERNAL_15 : std_logic ;
  signal RFO2_DATA2_INTERNAL_16 : std_logic ;
  signal RFO2_DATA2_INTERNAL_17 : std_logic ;
  signal RFO2_DATA2_INTERNAL_18 : std_logic ;
  signal RFO2_DATA2_INTERNAL_19 : std_logic ;
  signal RFO2_DATA2_INTERNAL_20 : std_logic ;
  signal RFO2_DATA2_INTERNAL_21 : std_logic ;
  signal RFO2_DATA2_INTERNAL_22 : std_logic ;
  signal RFO2_DATA2_INTERNAL_23 : std_logic ;
  signal RFO2_DATA2_INTERNAL_24 : std_logic ;
  signal RFO2_DATA2_INTERNAL_25 : std_logic ;
  signal RFO2_DATA2_INTERNAL_26 : std_logic ;
  signal RFO2_DATA2_INTERNAL_27 : std_logic ;
  signal RFO2_DATA2_INTERNAL_28 : std_logic ;
  signal RFO2_DATA2_INTERNAL_29 : std_logic ;
  signal RFO2_DATA2_INTERNAL_30 : std_logic ;
  signal GND : std_logic ;
  signal VCC : std_logic ;
  signal \GRLFPC20.FPI.START\ : std_logic ;
  signal \GRLFPC20.FPI.RST_0_G0_X\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_ADD3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_ADD4\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_ADD5\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_ADD6\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_ADD7\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_ADD8\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_ADD9\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_ADD10\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_ADD11\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_ADD12\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_ADD13\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_ADD14\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_ADD15\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_ADD16\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_ADD17\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_ADD18\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_ADD19\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_ADD20\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_ADD21\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_ADD22\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_ADD23\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_ADD24\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_ADD25\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_ADD26\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_ADD27\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_ADD28\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_ADD29\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_ADD30\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_ADD31\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_ADD32\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_ADD33\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_ADD34\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_ADD35\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_ADD36\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_ADD37\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_ADD38\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_ADD39\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_ADD40\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_ADD41\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_ADD42\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_ADD43\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_ADD44\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_ADD45\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_ADD46\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_ADD47\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_ADD48\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_ADD49\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_ADD50\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_ADD51\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_ADD52\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_ADD53\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_ADD54\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUE_ADD0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUE_ADD1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUE_ADD2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUE_ADD3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUE_ADD4\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUE_ADD5\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUE_ADD6\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUE_ADD7\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUE_ADD8\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUE_ADD9\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUE_ADD10\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.SIGNRESULT\ : std_logic ;
  signal \GRLFPC20.R.I.EXEC\ : std_logic ;
  signal \GRLFPC20.R.MK.BUSY\ : std_logic ;
  signal \GRLFPC20.R.X.LD\ : std_logic ;
  signal \GRLFPC20.R.X.AFSR\ : std_logic ;
  signal \GRLFPC20.R.X.FPOP\ : std_logic ;
  signal \GRLFPC20.R.A.RS1D\ : std_logic ;
  signal \GRLFPC20.R.A.RS2D\ : std_logic ;
  signal \GRLFPC20.R.A.AFQ\ : std_logic ;
  signal \GRLFPC20.R.MK.RST\ : std_logic ;
  signal \GRLFPC20.R.MK.RST2\ : std_logic ;
  signal \GRLFPC20.R.MK.HOLDN1\ : std_logic ;
  signal \GRLFPC20.R.E.FPOP\ : std_logic ;
  signal \GRLFPC20.R.M.FPOP\ : std_logic ;
  signal \GRLFPC20.R.A.ST\ : std_logic ;
  signal \GRLFPC20.R.A.AFSR\ : std_logic ;
  signal \GRLFPC20.R.MK.HOLDN2\ : std_logic ;
  signal \GRLFPC20.R.I.V\ : std_logic ;
  signal \GRLFPC20.R.M.LD\ : std_logic ;
  signal \GRLFPC20.R.E.LD\ : std_logic ;
  signal \GRLFPC20.R.A.LD\ : std_logic ;
  signal \GRLFPC20.R.A.FPOP\ : std_logic ;
  signal \GRLFPC20.R.MK.LDOP\ : std_logic ;
  signal \GRLFPC20.R.M.AFQ\ : std_logic ;
  signal \GRLFPC20.R.M.AFSR\ : std_logic ;
  signal \GRLFPC20.R.E.AFQ\ : std_logic ;
  signal \GRLFPC20.R.E.AFSR\ : std_logic ;
  signal \GRLFPC20.R.X.AFQ\ : std_logic ;
  signal \GRLFPC20.R.A.MOV\ : std_logic ;
  signal \GRLFPC20.R.I.RDD\ : std_logic ;
  signal \GRLFPC20.R.MK.BUSY2\ : std_logic ;
  signal \GRLFPC20.R.FSR.NONSTD\ : std_logic ;
  signal \GRLFPC20.COMB.RS2D_1_IV\ : std_logic ;
  signal \GRLFPC20.COMB.V.MK.RST_1_0_G0\ : std_logic ;
  signal \GRLFPC20.RIN.MK.LDOP_X\ : std_logic ;
  signal \GRLFPC20.R.MK.HOLDN1_0_0_G0_X\ : std_logic ;
  signal \GRLFPC20.R.MK.BUSY_0_0_G0\ : std_logic ;
  signal \GRLFPC20.R.MK.BUSY2_0_0_G0_X\ : std_logic ;
  signal \GRLFPC20.R.I.EXC_2_0_0__G0\ : std_logic ;
  signal \GRLFPC20.R.I.EXC_2_0_2__G0\ : std_logic ;
  signal \GRLFPC20.R.I.EXC_2_0_3__G0\ : std_logic ;
  signal \GRLFPC20.R.I.EXC_2_0_5__G0\ : std_logic ;
  signal \GRLFPC20.COMB.V.FSR.CEXC_1_SN_M3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_SCTRL_NEW_0_0__G0_I_M2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_ADD0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_ADD1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_ADD2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_ADD55\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_ADD56\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_ADD57\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUE_ADD11\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUE_ADD12\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SXC.SCTRL_NEW_4_0_2__G0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SXC.SCTRL_NEW_5_0_1__G0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SXC.SCTRL_NEW_6_0_0__G0_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.0.TRFWWBASICCELL.CIN_4\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.GRFPUE_ADD0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.GRFPUE_ADD1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.GRFPUE_ADD2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.GRFPUE_ADD3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.GRFPUE_ADD4\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.GRFPUE_ADD5\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.GRFPUE_ADD6\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.GRFPUE_ADD7\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.GRFPUE_ADD8\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.GRFPUE_ADD9\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.GRFPUE_ADD10\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.GRFPUE_ADD11\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.GRFPUE_ADD12\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.PCTRL_NEW_2_0_65__G0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.PCTRL_NEW_18_0_74__G0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SXC.RNDMODESELECT.TEMP\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_0_374__G0_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_0_375__G0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_0_114__G0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SXC.SCTRL_NEW_0_7__G0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.MULTIPLEXORMULXFF.RESULT_1_IV_0_3__G0_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.CI_2_SUM0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_0_62__ROM\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_0__ROM_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_0__ROM_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_0__ROM_3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_0__ROM_4\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_0__ROM_5\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_0__ROM_6\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_0__ROM_8\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_0__ROM_9\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_0__ROM_17\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_0__ROM_22\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_0__ROM_26\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_0__ROM_27\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_0__ROM_29\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_0__ROM_30\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_0__ROM_34\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_0__ROM_36\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_0__ROM_44\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_0__ROM_47\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_0__ROM_50\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_0__ROM_55\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_1_0_62__ROM\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_1_0__ROM_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_1_0__ROM_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_1_0__ROM_3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_1_0__ROM_4\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_1_0__ROM_5\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_1_0__ROM_6\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_1_0__ROM_7\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_1_0__ROM_8\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_1_0__ROM_9\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_1_0__ROM_10\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_1_0__ROM_11\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_1_0__ROM_12\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_1_0__ROM_13\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_1_0__ROM_14\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_1_0__ROM_20\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_1_0__ROM_22\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_1_0__ROM_25\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_1_0__ROM_26\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_1_0__ROM_27\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_1_0__ROM_28\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_1_0__ROM_29\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_1_0__ROM_30\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_1_0__ROM_33\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_1_0__ROM_34\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_1_0__ROM_36\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_1_0__ROM_42\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_1_0__ROM_43\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_1_0__ROM_45\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_1_0__ROM_48\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_2_0__ROM_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_2_0__ROM_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_2_0__ROM_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_2_0__ROM_3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_2_0__ROM_4\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_2_0__ROM_5\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_2_0__ROM_6\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_2_0__ROM_7\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_2_0__ROM_8\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_2_0__ROM_10\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_2_0__ROM_13\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_2_0__ROM_14\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_2_0__ROM_25\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_2_0__ROM_30\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_2_0__ROM_33\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_2_0__ROM_34\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_2_0__ROM_36\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_2_0__ROM_42\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_2_0__ROM_44\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_2_0__ROM_48\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_2_0__ROM_49\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_2_0__ROM_50\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_2_0__ROM_55\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_3_0_62__ROM\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_3_0__ROM_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_3_0__ROM_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_3_0__ROM_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_3_0__ROM_3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_3_0__ROM_4\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_3_0__ROM_5\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_3_0__ROM_6\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_3_0__ROM_7\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_3_0__ROM_8\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_3_0__ROM_9\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_3_0__ROM_10\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_3_0__ROM_12\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_3_0__ROM_13\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_3_0__ROM_25\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_3_0__ROM_27\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_3_0__ROM_28\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_3_0__ROM_29\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_3_0__ROM_30\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_3_0__ROM_33\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_3_0__ROM_34\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_3_0__ROM_36\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_3_0__ROM_37\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_3_0__ROM_38\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_3_0__ROM_42\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_3_0__ROM_43\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_3_0__ROM_44\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_3_0__ROM_47\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_3_0__ROM_48\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_3_0__ROM_50\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_3_0__ROM_55\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_3_0__ROM_57\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_3_0__ROM_61\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_4_0__ROM_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_4_0__ROM_3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_4_0__ROM_4\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_4_0__ROM_5\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_4_0__ROM_6\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_4_0__ROM_7\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_4_0__ROM_8\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_4_0__ROM_9\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_4_0__ROM_10\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_4_0__ROM_14\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_4_0__ROM_21\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_4_0__ROM_25\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_4_0__ROM_27\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_4_0__ROM_28\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_4_0__ROM_30\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_4_0__ROM_33\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_4_0__ROM_34\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_4_0__ROM_35\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_4_0__ROM_42\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_4_0__ROM_43\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_4_0__ROM_44\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_4_0__ROM_46\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_4_0__ROM_48\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_4_0__ROM_50\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_4_0__ROM_55\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_4_0__ROM_56\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_4_0__ROM_57\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_4_0__ROM_58\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_4_0__ROM_61\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_5_0__ROM_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_5_0__ROM_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_5_0__ROM_3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_5_0__ROM_4\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_5_0__ROM_5\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_5_0__ROM_6\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_5_0__ROM_8\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_5_0__ROM_9\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_5_0__ROM_12\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_5_0__ROM_14\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_5_0__ROM_16\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_5_0__ROM_19\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_5_0__ROM_25\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_5_0__ROM_27\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_5_0__ROM_28\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_5_0__ROM_29\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_5_0__ROM_30\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_5_0__ROM_31\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_5_0__ROM_34\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_5_0__ROM_35\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_5_0__ROM_36\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_5_0__ROM_37\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_5_0__ROM_42\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_5_0__ROM_44\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_5_0__ROM_48\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_5_0__ROM_49\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_5_0__ROM_50\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_5_0__ROM_54\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_5_0__ROM_55\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_5_0__ROM_56\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_5_0__ROM_57\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_5_0__ROM_58\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_5_0__ROM_59\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_5_0__ROM_60\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_5_0__ROM_61\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_6_0__ROM_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_6_0__ROM_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_6_0__ROM_3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_6_0__ROM_4\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_6_0__ROM_6\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_6_0__ROM_7\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_6_0__ROM_8\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_6_0__ROM_9\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_6_0__ROM_10\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_6_0__ROM_14\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_6_0__ROM_19\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_6_0__ROM_25\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_6_0__ROM_28\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_6_0__ROM_29\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_6_0__ROM_30\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_6_0__ROM_34\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_6_0__ROM_37\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_6_0__ROM_42\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_6_0__ROM_43\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_6_0__ROM_44\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_6_0__ROM_48\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_6_0__ROM_50\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_6_0__ROM_54\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_6_0__ROM_55\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_6_0__ROM_57\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_7_0__ROM_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_7_0__ROM_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_7_0__ROM_3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_7_0__ROM_4\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_7_0__ROM_5\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_7_0__ROM_6\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_7_0__ROM_7\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_7_0__ROM_8\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_7_0__ROM_9\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_7_0__ROM_10\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_7_0__ROM_13\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_7_0__ROM_27\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_7_0__ROM_29\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_7_0__ROM_30\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_7_0__ROM_34\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_7_0__ROM_36\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_7_0__ROM_37\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_7_0__ROM_42\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_7_0__ROM_43\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_7_0__ROM_44\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_7_0__ROM_49\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_7_0__ROM_50\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_7_0__ROM_55\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_7_0__ROM_57\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_7_0__ROM_59\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_7_0__ROM_61\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_8_0__ROM_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_8_0__ROM_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_8_0__ROM_3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_8_0__ROM_4\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_8_0__ROM_5\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_8_0__ROM_7\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_8_0__ROM_8\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_8_0__ROM_9\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_8_0__ROM_10\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_8_0__ROM_12\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_8_0__ROM_13\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_8_0__ROM_14\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_8_0__ROM_17\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_8_0__ROM_19\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_8_0__ROM_22\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_8_0__ROM_25\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_8_0__ROM_27\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_8_0__ROM_28\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_8_0__ROM_29\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_8_0__ROM_30\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_8_0__ROM_31\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_8_0__ROM_32\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_8_0__ROM_34\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_8_0__ROM_44\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_8_0__ROM_46\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_8_0__ROM_48\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_8_0__ROM_50\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_8_0__ROM_52\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_8_0__ROM_53\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_8_0__ROM_54\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_8_0__ROM_55\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_8_0__ROM_56\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_8_0__ROM_57\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_9_0_62__ROM\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_9_0__ROM_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_9_0__ROM_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_9_0__ROM_3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_9_0__ROM_4\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_9_0__ROM_5\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_9_0__ROM_6\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_9_0__ROM_7\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_9_0__ROM_8\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_9_0__ROM_9\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_9_0__ROM_10\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_9_0__ROM_11\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_9_0__ROM_12\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_9_0__ROM_13\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_9_0__ROM_14\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_9_0__ROM_15\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_9_0__ROM_22\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_9_0__ROM_25\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_9_0__ROM_27\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_9_0__ROM_28\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_9_0__ROM_30\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_9_0__ROM_31\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_9_0__ROM_34\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_9_0__ROM_35\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_9_0__ROM_41\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_9_0__ROM_42\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_9_0__ROM_43\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_9_0__ROM_44\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_9_0__ROM_46\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_9_0__ROM_48\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_9_0__ROM_49\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_9_0__ROM_50\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_9_0__ROM_54\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_9_0__ROM_55\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_9_0__ROM_56\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_9_0__ROM_57\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_9_0__ROM_58\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_9_0__ROM_61\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_10_0_62__ROM\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_10_0__ROM_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_10_0__ROM_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_10_0__ROM_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_10_0__ROM_3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_10_0__ROM_4\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_10_0__ROM_5\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_10_0__ROM_6\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_10_0__ROM_7\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_10_0__ROM_8\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_10_0__ROM_9\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_10_0__ROM_10\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_10_0__ROM_11\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_10_0__ROM_12\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_10_0__ROM_13\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_10_0__ROM_14\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_10_0__ROM_17\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_10_0__ROM_22\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_10_0__ROM_25\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_10_0__ROM_29\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_10_0__ROM_30\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_10_0__ROM_31\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_10_0__ROM_32\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_10_0__ROM_34\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_10_0__ROM_42\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_10_0__ROM_43\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_10_0__ROM_44\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_10_0__ROM_54\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_10_0__ROM_55\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_11_0_62__ROM\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_11_0__ROM_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_11_0__ROM_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_11_0__ROM_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_11_0__ROM_3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_11_0__ROM_4\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_11_0__ROM_5\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_11_0__ROM_6\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_11_0__ROM_7\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_11_0__ROM_8\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_11_0__ROM_9\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_11_0__ROM_10\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_11_0__ROM_11\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_11_0__ROM_12\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_11_0__ROM_13\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_11_0__ROM_14\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_11_0__ROM_22\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_11_0__ROM_24\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_11_0__ROM_25\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_11_0__ROM_28\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_11_0__ROM_29\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_11_0__ROM_30\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_11_0__ROM_34\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_11_0__ROM_36\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_11_0__ROM_42\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_11_0__ROM_43\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_11_0__ROM_48\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_11_0__ROM_50\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_11_0__ROM_54\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_11_0__ROM_55\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_11_0__ROM_56\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_12_0__ROM_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_12_0__ROM_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_12_0__ROM_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_12_0__ROM_3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_12_0__ROM_4\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_12_0__ROM_5\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_12_0__ROM_6\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_12_0__ROM_9\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_12_0__ROM_10\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_12_0__ROM_11\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_12_0__ROM_12\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_12_0__ROM_13\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_12_0__ROM_14\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_12_0__ROM_17\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_12_0__ROM_25\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_12_0__ROM_27\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_12_0__ROM_29\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_12_0__ROM_30\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_12_0__ROM_33\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_12_0__ROM_34\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_12_0__ROM_36\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_12_0__ROM_42\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_12_0__ROM_43\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_12_0__ROM_48\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_12_0__ROM_50\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_12_0__ROM_54\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_12_0__ROM_55\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_12_0__ROM_56\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_12_0__ROM_57\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_13_0__ROM_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_13_0__ROM_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_13_0__ROM_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_13_0__ROM_3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_13_0__ROM_4\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_13_0__ROM_5\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_13_0__ROM_6\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_13_0__ROM_7\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_13_0__ROM_8\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_13_0__ROM_9\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_13_0__ROM_10\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_13_0__ROM_13\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_13_0__ROM_30\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_13_0__ROM_34\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_13_0__ROM_36\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_13_0__ROM_42\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_13_0__ROM_43\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_13_0__ROM_55\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_13_0__ROM_56\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_13_0__ROM_57\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_14_0_62__ROM\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_14_0__ROM_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_14_0__ROM_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_14_0__ROM_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_14_0__ROM_3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_14_0__ROM_4\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_14_0__ROM_5\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_14_0__ROM_6\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_14_0__ROM_7\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_14_0__ROM_8\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_14_0__ROM_9\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_14_0__ROM_10\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_14_0__ROM_11\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_14_0__ROM_12\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_14_0__ROM_13\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_14_0__ROM_14\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_14_0__ROM_22\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_14_0__ROM_24\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_14_0__ROM_25\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_14_0__ROM_27\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_14_0__ROM_28\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_14_0__ROM_29\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_14_0__ROM_30\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_14_0__ROM_31\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_14_0__ROM_34\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_14_0__ROM_35\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_14_0__ROM_43\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_14_0__ROM_44\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_14_0__ROM_48\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_14_0__ROM_50\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_14_0__ROM_55\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_14_0__ROM_57\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_15_0_62__ROM\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_15_0__ROM_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_15_0__ROM_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_15_0__ROM_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_15_0__ROM_3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_15_0__ROM_4\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_15_0__ROM_5\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_15_0__ROM_6\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_15_0__ROM_7\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_15_0__ROM_8\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_15_0__ROM_9\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_15_0__ROM_10\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_15_0__ROM_11\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_15_0__ROM_13\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_15_0__ROM_14\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_15_0__ROM_18\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_15_0__ROM_22\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_15_0__ROM_25\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_15_0__ROM_27\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_15_0__ROM_28\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_15_0__ROM_29\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_15_0__ROM_30\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_15_0__ROM_34\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_15_0__ROM_42\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_15_0__ROM_43\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_15_0__ROM_45\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_15_0__ROM_50\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_15_0__ROM_56\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23_1.CO0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_SN_M4\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_SN_M3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_173__G0_I\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_172__G0_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_SN_M3_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.STARTSHFT.UN3_NOTRESETORUNIMP\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_M2S2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.UN38_PCTRL_NEW_I_0_G0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.UN33_PCTRL_NEW_I_0_G0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.MULTIPLEXORMULXFF.RESULT_1_IV_I_0_7__G0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.MULTIPLEXORMULXFF.RESULT_1_IV_I_0_6__G0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.MULTIPLEXORMULXFF.RESULT_1_IV_I_0_5__G0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.MULTIPLEXORMULXFF.RESULT_1_IV_I_0_4__G0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.MULTIPLEXORMULXFF.RESULT_1_IV_I_0_2__G0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.MULTIPLEXORMULXFF.RESULT_1_IV_I_0_1__G0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.MULTIPLEXORMULXFF.RESULT_1_IV_I_0_0__G0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.SCTRL_38_IV_I_0_0__G0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.SCTRL_I_0_0__G0_0_M2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.48.CI_10_ADD0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.48.CI_10_ADD1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.48.CI_10_ADD2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.48.CI_10_ADD3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.49.CI_9_ADD0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.49.CI_9_ADD1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.49.CI_9_ADD2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.49.CI_9_ADD3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.50.CI_8_ADD0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.50.CI_8_ADD1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.50.CI_8_ADD2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.50.CI_8_ADD3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.51.CI_7_ADD0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.51.CI_7_ADD1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.51.CI_7_ADD2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.51.CI_7_ADD3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.52.CI_6_ADD0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.52.CI_6_ADD1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.52.CI_6_ADD2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.52.CI_6_ADD3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.53.CI_5_ADD0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.53.CI_5_ADD1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.53.CI_5_ADD2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.53.CI_5_ADD3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.54.CI_4_ADD0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.54.CI_4_ADD1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.54.CI_4_ADD2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.54.CI_4_ADD3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.33.CI_25_ADD0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.33.CI_25_ADD1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.33.CI_25_ADD2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.33.CI_25_ADD3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.34.CI_24_ADD0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.34.CI_24_ADD1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.34.CI_24_ADD2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.34.CI_24_ADD3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.35.CI_23_ADD0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.35.CI_23_ADD1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.35.CI_23_ADD2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.35.CI_23_ADD3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.36.CI_22_ADD0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.36.CI_22_ADD1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.36.CI_22_ADD2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.36.CI_22_ADD3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.37.CI_21_ADD0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.37.CI_21_ADD1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.37.CI_21_ADD2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.37.CI_21_ADD3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.38.CI_20_ADD0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.38.CI_20_ADD1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.38.CI_20_ADD2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.38.CI_20_ADD3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.39.CI_19_ADD0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.39.CI_19_ADD1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.39.CI_19_ADD2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.39.CI_19_ADD3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.40.CI_18_ADD0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.40.CI_18_ADD1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.40.CI_18_ADD2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.40.CI_18_ADD3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.41.CI_17_ADD0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.41.CI_17_ADD1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.41.CI_17_ADD2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.41.CI_17_ADD3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.42.CI_16_ADD0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.42.CI_16_ADD1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.42.CI_16_ADD2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.42.CI_16_ADD3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.43.CI_15_ADD0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.43.CI_15_ADD1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.43.CI_15_ADD2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.43.CI_15_ADD3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.44.CI_14_ADD0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.44.CI_14_ADD1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.44.CI_14_ADD2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.44.CI_14_ADD3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.45.CI_13_ADD0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.45.CI_13_ADD1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.45.CI_13_ADD2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.45.CI_13_ADD3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.46.CI_12_ADD0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.46.CI_12_ADD1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.46.CI_12_ADD2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.46.CI_12_ADD3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.47.CI_11_ADD0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.47.CI_11_ADD1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.47.CI_11_ADD2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.47.CI_11_ADD3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.18.CI_40_ADD0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.18.CI_40_ADD1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.18.CI_40_ADD2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.18.CI_40_ADD3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.19.CI_39_ADD0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.19.CI_39_ADD1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.19.CI_39_ADD2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.19.CI_39_ADD3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.20.CI_38_ADD0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.20.CI_38_ADD1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.20.CI_38_ADD2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.20.CI_38_ADD3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.21.CI_37_ADD0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.21.CI_37_ADD1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.21.CI_37_ADD2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.21.CI_37_ADD3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.22.CI_36_ADD0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.22.CI_36_ADD1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.22.CI_36_ADD2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.22.CI_36_ADD3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.23.CI_35_ADD0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.23.CI_35_ADD1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.23.CI_35_ADD2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.23.CI_35_ADD3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.24.CI_34_ADD0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.24.CI_34_ADD1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.24.CI_34_ADD2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.24.CI_34_ADD3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.25.CI_33_ADD0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.25.CI_33_ADD1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.25.CI_33_ADD2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.25.CI_33_ADD3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.26.CI_32_ADD0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.26.CI_32_ADD1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.26.CI_32_ADD2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.26.CI_32_ADD3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.27.CI_31_ADD0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.27.CI_31_ADD1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.27.CI_31_ADD2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.27.CI_31_ADD3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.28.CI_30_ADD0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.28.CI_30_ADD1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.28.CI_30_ADD2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.28.CI_30_ADD3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.29.CI_29_ADD0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.29.CI_29_ADD1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.29.CI_29_ADD2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.29.CI_29_ADD3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.30.CI_28_ADD0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.30.CI_28_ADD1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.30.CI_28_ADD2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.30.CI_28_ADD3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.31.CI_27_ADD0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.31.CI_27_ADD1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.31.CI_27_ADD2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.31.CI_27_ADD3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.32.CI_26_ADD0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.32.CI_26_ADD1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.32.CI_26_ADD2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.32.CI_26_ADD3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.3.CI_55_ADD0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.3.CI_55_ADD1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.3.CI_55_ADD2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.3.CI_55_ADD3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.4.CI_54_ADD0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.4.CI_54_ADD1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.4.CI_54_ADD2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.4.CI_54_ADD3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.5.CI_53_ADD0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.5.CI_53_ADD1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.5.CI_53_ADD2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.5.CI_53_ADD3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.6.CI_52_ADD0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.6.CI_52_ADD1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.6.CI_52_ADD2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.6.CI_52_ADD3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.7.CI_51_ADD0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.7.CI_51_ADD1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.7.CI_51_ADD2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.7.CI_51_ADD3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.8.CI_50_ADD0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.8.CI_50_ADD1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.8.CI_50_ADD2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.8.CI_50_ADD3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.9.CI_49_ADD0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.9.CI_49_ADD1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.9.CI_49_ADD2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.9.CI_49_ADD3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.10.CI_48_ADD0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.10.CI_48_ADD1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.10.CI_48_ADD2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.10.CI_48_ADD3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.11.CI_47_ADD0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.11.CI_47_ADD1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.11.CI_47_ADD2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.11.CI_47_ADD3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.12.CI_46_ADD0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.12.CI_46_ADD1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.12.CI_46_ADD2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.12.CI_46_ADD3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.13.CI_45_ADD0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.13.CI_45_ADD1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.13.CI_45_ADD2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.13.CI_45_ADD3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.14.CI_44_ADD0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.14.CI_44_ADD1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.14.CI_44_ADD2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.14.CI_44_ADD3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.15.CI_43_ADD0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.15.CI_43_ADD1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.15.CI_43_ADD2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.15.CI_43_ADD3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.16.CI_42_ADD0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.16.CI_42_ADD1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.16.CI_42_ADD2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.16.CI_42_ADD3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.17.CI_41_ADD0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.17.CI_41_ADD1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.17.CI_41_ADD2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.17.CI_41_ADD3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.17.CI_41_CARRY_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.17.CI_41_CARRY_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.17.CI_41_CARRY_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.16.CI_42_CARRY_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.16.CI_42_CARRY_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.16.CI_42_CARRY_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.15.CI_43_CARRY_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.15.CI_43_CARRY_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.15.CI_43_CARRY_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.14.CI_44_CARRY_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.14.CI_44_CARRY_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.14.CI_44_CARRY_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.13.CI_45_CARRY_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.13.CI_45_CARRY_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.13.CI_45_CARRY_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.12.CI_46_CARRY_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.12.CI_46_CARRY_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.12.CI_46_CARRY_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.11.CI_47_CARRY_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.11.CI_47_CARRY_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.11.CI_47_CARRY_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.10.CI_48_CARRY_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.10.CI_48_CARRY_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.10.CI_48_CARRY_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.9.CI_49_CARRY_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.9.CI_49_CARRY_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.9.CI_49_CARRY_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.8.CI_50_CARRY_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.8.CI_50_CARRY_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.8.CI_50_CARRY_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.7.CI_51_CARRY_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.7.CI_51_CARRY_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.7.CI_51_CARRY_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.6.CI_52_CARRY_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.6.CI_52_CARRY_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.6.CI_52_CARRY_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.5.CI_53_CARRY_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.5.CI_53_CARRY_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.5.CI_53_CARRY_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.4.CI_54_CARRY_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.4.CI_54_CARRY_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.4.CI_54_CARRY_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.3.CI_55_CARRY_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.3.CI_55_CARRY_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.3.CI_55_CARRY_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.32.CI_26_CARRY_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.32.CI_26_CARRY_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.32.CI_26_CARRY_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.31.CI_27_CARRY_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.31.CI_27_CARRY_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.31.CI_27_CARRY_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.30.CI_28_CARRY_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.30.CI_28_CARRY_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.30.CI_28_CARRY_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.29.CI_29_CARRY_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.29.CI_29_CARRY_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.29.CI_29_CARRY_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.28.CI_30_CARRY_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.28.CI_30_CARRY_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.28.CI_30_CARRY_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.27.CI_31_CARRY_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.27.CI_31_CARRY_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.27.CI_31_CARRY_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.26.CI_32_CARRY_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.26.CI_32_CARRY_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.26.CI_32_CARRY_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.25.CI_33_CARRY_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.25.CI_33_CARRY_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.25.CI_33_CARRY_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.24.CI_34_CARRY_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.24.CI_34_CARRY_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.24.CI_34_CARRY_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.23.CI_35_CARRY_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.23.CI_35_CARRY_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.23.CI_35_CARRY_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.22.CI_36_CARRY_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.22.CI_36_CARRY_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.22.CI_36_CARRY_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.21.CI_37_CARRY_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.21.CI_37_CARRY_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.21.CI_37_CARRY_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.20.CI_38_CARRY_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.20.CI_38_CARRY_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.20.CI_38_CARRY_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.19.CI_39_CARRY_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.19.CI_39_CARRY_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.19.CI_39_CARRY_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.18.CI_40_CARRY_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.18.CI_40_CARRY_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.18.CI_40_CARRY_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.47.CI_11_CARRY_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.47.CI_11_CARRY_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.47.CI_11_CARRY_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.46.CI_12_CARRY_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.46.CI_12_CARRY_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.46.CI_12_CARRY_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.45.CI_13_CARRY_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.45.CI_13_CARRY_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.45.CI_13_CARRY_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.44.CI_14_CARRY_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.44.CI_14_CARRY_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.44.CI_14_CARRY_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.43.CI_15_CARRY_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.43.CI_15_CARRY_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.43.CI_15_CARRY_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.42.CI_16_CARRY_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.42.CI_16_CARRY_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.42.CI_16_CARRY_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.41.CI_17_CARRY_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.41.CI_17_CARRY_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.41.CI_17_CARRY_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.40.CI_18_CARRY_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.40.CI_18_CARRY_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.40.CI_18_CARRY_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.39.CI_19_CARRY_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.39.CI_19_CARRY_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.39.CI_19_CARRY_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.38.CI_20_CARRY_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.38.CI_20_CARRY_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.38.CI_20_CARRY_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.37.CI_21_CARRY_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.37.CI_21_CARRY_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.37.CI_21_CARRY_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.36.CI_22_CARRY_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.36.CI_22_CARRY_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.36.CI_22_CARRY_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.35.CI_23_CARRY_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.35.CI_23_CARRY_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.35.CI_23_CARRY_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.34.CI_24_CARRY_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.34.CI_24_CARRY_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.34.CI_24_CARRY_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.33.CI_25_CARRY_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.33.CI_25_CARRY_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.33.CI_25_CARRY_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.54.CI_4_CARRY_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.54.CI_4_CARRY_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.54.CI_4_CARRY_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.53.CI_5_CARRY_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.53.CI_5_CARRY_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.53.CI_5_CARRY_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.52.CI_6_CARRY_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.52.CI_6_CARRY_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.52.CI_6_CARRY_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.51.CI_7_CARRY_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.51.CI_7_CARRY_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.51.CI_7_CARRY_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.50.CI_8_CARRY_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.50.CI_8_CARRY_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.50.CI_8_CARRY_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.49.CI_9_CARRY_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.49.CI_9_CARRY_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.49.CI_9_CARRY_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.48.CI_10_CARRY_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.48.CI_10_CARRY_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.48.CI_10_CARRY_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUE_CARRY_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUE_CARRY_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUE_CARRY_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUE_CARRY_3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUE_CARRY_4\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUE_CARRY_5\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUE_CARRY_6\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUE_CARRY_7\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUE_CARRY_8\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUE_CARRY_9\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUE_CARRY_10\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUE_CARRY_11\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_4\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_5\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_6\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_7\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_8\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_9\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_10\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_11\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_12\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_13\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_14\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_15\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_16\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_17\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_18\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_19\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_20\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_21\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_22\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_23\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_24\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_25\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_26\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_27\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_28\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_29\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_30\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_31\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_32\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_33\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_34\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_35\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_36\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_37\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_38\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_39\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_40\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_41\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_42\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_43\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_44\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_45\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_46\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_47\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_48\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_49\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_50\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_51\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_52\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_53\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_54\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_55\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_56\ : std_logic ;
  signal N_10418 : std_logic ;
  signal N_10419 : std_logic ;
  signal N_10421 : std_logic ;
  signal N_10422 : std_logic ;
  signal N_10423 : std_logic ;
  signal N_10424 : std_logic ;
  signal N_10425 : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.GRFPUE_CARRY_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.GRFPUE_CARRY_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.GRFPUE_CARRY_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.GRFPUE_CARRY_3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.GRFPUE_CARRY_4\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.GRFPUE_CARRY_5\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.GRFPUE_CARRY_6\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.GRFPUE_CARRY_7\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.GRFPUE_CARRY_8\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.GRFPUE_CARRY_9\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.GRFPUE_CARRY_10\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.GRFPUE_CARRY_11\ : std_logic ;
  signal \GRLFPC20.V.STATE_0_SQMUXA_1_X\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.PCTRL_NEW_11_0_69__G0_I_O4\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.PCTRL_NEW_6_0_67__G3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.PCTRL_NEW_2_0_65__G3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_46__G2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_41__G3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_41__G4\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_21__G2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_20__G2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_9__G3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_9__G4\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_0_319__G3_0_X2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_0_318__G3_0_X2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_0_316__G3_0_X2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_0_315__G3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.54.SI_117_SUM1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_0_258__G3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_112__G1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_112__G2_X\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_111__G1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_111__G2_X\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_110__G1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_110__G2_X\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_109__G1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_109__G2_X\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_108__G1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_108__G2_X\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_107__G1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_107__G2_X\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_106__G1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_106__G2_X\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_105__G1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_105__G2_X\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_104__G1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_104__G2_X\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_103__G1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_103__G2_X\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_102__G1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_102__G2_X\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_101__G1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_101__G2_X\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_100__G1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_100__G2_X\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_99__G1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_99__G2_X\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_98__G1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_98__G2_X\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_97__G1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_97__G2_X\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_96__G1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_96__G2_X\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_95__G1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_95__G2_X\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_94__G1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_94__G2_X\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_93__G1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_93__G2_X\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_92__G1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_92__G2_X\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_91__G1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_91__G2_X\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_90__G1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_90__G2_X\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_89__G1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_89__G2_X\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_88__G1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_88__G2_X\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_87__G1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_87__G2_X\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_86__G1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_86__G2_X\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_85__G1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_85__G2_X\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_84__G1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_84__G2_X\ : std_logic ;
  signal \GRLFPC20.R.I.V_1_0_G3\ : std_logic ;
  signal \GRLFPC20.R.A.RDD_0_0_0__G1_0\ : std_logic ;
  signal \GRLFPC20.R.A.SEQERR_0_0_0__G1\ : std_logic ;
  signal \GRLFPC20.R.A.ST_0_0_G1\ : std_logic ;
  signal \GRLFPC20.R.A.LD_0_0_G1\ : std_logic ;
  signal \GRLFPC20.R.A.FPOP_0_0_G1\ : std_logic ;
  signal \GRLFPC20.R.A.AFSR_0_0_G1\ : std_logic ;
  signal \GRLFPC20.R.A.AFQ_0_0_G1\ : std_logic ;
  signal \GRLFPC20.COMB.RS1D_1_U\ : std_logic ;
  signal \GRLFPC20.R.FSR.NONSTD_0_0_G3_X\ : std_logic ;
  signal \GRLFPC20.R.A.MOV_0_0_G1\ : std_logic ;
  signal \GRLFPC20.R.X.LD_0_0_G1_X\ : std_logic ;
  signal \GRLFPC20.R.X.FPOP_0_0_G1_X\ : std_logic ;
  signal \GRLFPC20.R.X.AFSR_0_0_G1_X\ : std_logic ;
  signal \GRLFPC20.R.X.AFQ_0_0_G1_X\ : std_logic ;
  signal \GRLFPC20.R.M.LD_0_0_G1_X\ : std_logic ;
  signal \GRLFPC20.R.M.FPOP_0_0_G1_X\ : std_logic ;
  signal \GRLFPC20.R.M.AFSR_0_0_G1_X\ : std_logic ;
  signal \GRLFPC20.R.M.AFQ_0_0_G1_X\ : std_logic ;
  signal \GRLFPC20.R.E.LD_0_0_G1_X\ : std_logic ;
  signal \GRLFPC20.R.E.FPOP_0_0_G1_X\ : std_logic ;
  signal \GRLFPC20.R.E.AFSR_0_0_G1_X\ : std_logic ;
  signal \GRLFPC20.R.E.AFQ_0_0_G1_X\ : std_logic ;
  signal \GRLFPC20.R.I.CC_0_0_0__G4\ : std_logic ;
  signal \GRLFPC20.R.I.CC_0_0_1__G4\ : std_logic ;
  signal \GRLFPC20.R.E.STDATA_1_0_0__G2\ : std_logic ;
  signal \GRLFPC20.R.E.STDATA_1_0_0__G3_X\ : std_logic ;
  signal \GRLFPC20.R.E.STDATA_1_0_1__G2\ : std_logic ;
  signal \GRLFPC20.R.E.STDATA_1_0_1__G3_X\ : std_logic ;
  signal \GRLFPC20.R.E.STDATA_1_0_12__G2\ : std_logic ;
  signal \GRLFPC20.R.E.STDATA_1_0_12__G3_X\ : std_logic ;
  signal \GRLFPC20.R.E.STDATA_1_0_17__G2\ : std_logic ;
  signal \GRLFPC20.R.E.STDATA_1_0_17__G3_X\ : std_logic ;
  signal \GRLFPC20.R.E.STDATA_1_0_18__G2\ : std_logic ;
  signal \GRLFPC20.R.E.STDATA_1_0_18__G3_X\ : std_logic ;
  signal \GRLFPC20.R.E.STDATA_1_0_19__G2\ : std_logic ;
  signal \GRLFPC20.R.E.STDATA_1_0_19__G3_X\ : std_logic ;
  signal \GRLFPC20.R.E.STDATA_1_0_20__G2\ : std_logic ;
  signal \GRLFPC20.R.E.STDATA_1_0_20__G3_X\ : std_logic ;
  signal \GRLFPC20.R.E.STDATA_1_0_21__G2\ : std_logic ;
  signal \GRLFPC20.R.E.STDATA_1_0_21__G3_X\ : std_logic ;
  signal \GRLFPC20.R.E.STDATA_1_0_28__G2\ : std_logic ;
  signal \GRLFPC20.R.E.STDATA_1_0_28__G3_X\ : std_logic ;
  signal \GRLFPC20.R.E.STDATA_1_0_29__G2\ : std_logic ;
  signal \GRLFPC20.R.E.STDATA_1_0_29__G3_X\ : std_logic ;
  signal \GRLFPC20.R.FSR.RD_0_0_0__G3_X\ : std_logic ;
  signal \GRLFPC20.R.FSR.RD_0_0_1__G3_X\ : std_logic ;
  signal \GRLFPC20.R.FSR.TEM_1_0_0__G3_X\ : std_logic ;
  signal \GRLFPC20.R.FSR.TEM_1_0_1__G3_X\ : std_logic ;
  signal \GRLFPC20.R.FSR.TEM_1_0_2__G3_X\ : std_logic ;
  signal \GRLFPC20.R.FSR.TEM_1_0_3__G3_X\ : std_logic ;
  signal \GRLFPC20.R.FSR.TEM_1_0_4__G3_X\ : std_logic ;
  signal \GRLFPC20.R.STATE_0_0_0__G1\ : std_logic ;
  signal \GRLFPC20.R.STATE_0_0_1__G1\ : std_logic ;
  signal \GRLFPC20.R.FSR.FTT_1_0_2__G2\ : std_logic ;
  signal \GRLFPC20.R.FSR.AEXC_1_0_0__G1\ : std_logic ;
  signal \GRLFPC20.R.FSR.AEXC_1_0_1__G1\ : std_logic ;
  signal \GRLFPC20.R.FSR.AEXC_1_0_2__G1\ : std_logic ;
  signal \GRLFPC20.R.FSR.AEXC_1_0_3__G1\ : std_logic ;
  signal \GRLFPC20.R.FSR.AEXC_1_0_4__G1\ : std_logic ;
  signal \GRLFPC20.R.I.EXC_2_0_4__G3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SXC.RNDMODESELECT.UN17_U_RDN_I_0_503_I_A2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SXC.RNDMODESELECT.U_RDN_1_520\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.PCTRL_NEW_11_0_69__G2_0_529\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SXC.UN53_SCTRL_NEW\ : std_logic ;
  signal \GRLFPC20.R.I.EXEC_0_0_G1_0_549_I\ : std_logic ;
  signal \GRLFPC20.R.I.RDD_0_0_G1_0_574_I\ : std_logic ;
  signal \GRLFPC20.R.FSR.FTT_1_0_0__G2_0_600_I\ : std_logic ;
  signal \GRLFPC20.R.FSR.FTT_1_0_1__G2_0_624_I\ : std_logic ;
  signal \GRLFPC20.COMB.V.A.RF1REN_1_670_I\ : std_logic ;
  signal \GRLFPC20.COMB.V.A.RF2REN_1_0_701_I\ : std_logic ;
  signal \GRLFPC20.COMB.V.A.RF2REN_1_734_I\ : std_logic ;
  signal RST_INTERNAL : std_logic ;
  signal \GRLFPC20.R.I.V_1_0_G0_0\ : std_logic ;
  signal \GRLFPC20.G_884\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.26.TRFWWBASICCELL.TEMP2_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.25.TRFWWBASICCELL.TEMP2_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.26.TRFWWBASICCELL.TEMP2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.25.TRFWWBASICCELL.TEMP2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.52.TRFWWBASICCELL.TEMP2_3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.51.TRFWWBASICCELL.TEMP2_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.27.TRFWWBASICCELL.TEMP2_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.26.TRFWWBASICCELL.TEMP2_3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_M2_7\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRONEMORE\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.CI_2_SUM2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.54.SI_61_1.CO0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_1299_SUM3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.54.SI_117_SUM0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.53.SI_118_1.CO0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_1299_ANC3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.CI_114_1.CO0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.TRFWWBASICCELL.TEMP2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_0_259__G5\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.UN23_EXPXBUS_NE\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.0.TRFWWBASICCELL.TEMP2_3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.0.TRFWWBASICCELL.CIN_1\ : std_logic ;
  signal \GRLFPC20.COMB.WREN129\ : std_logic ;
  signal \GRLFPC20.WREN1_0_SQMUXA_1_X\ : std_logic ;
  signal \GRLFPC20.COMB.RS1_1_SN_M2_X\ : std_logic ;
  signal \GRLFPC20.R.I.V_EN_1\ : std_logic ;
  signal \GRLFPC20.COMB.V.FSR.FCC10\ : std_logic ;
  signal \GRLFPC20.COMB.UN1_FPCI_0_X\ : std_logic ;
  signal \GRLFPC20.COMB.UN1_R.I.V_0\ : std_logic ;
  signal \GRLFPC20.WRADDR_0_SQMUXA_X\ : std_logic ;
  signal \GRLFPC20.WREN2_1_SQMUXA_1_1_X\ : std_logic ;
  signal \GRLFPC20.WREN2_2_SQMUXA_1\ : std_logic ;
  signal \GRLFPC20.WREN2_1_SQMUXA_1\ : std_logic ;
  signal \GRLFPC20.COMB.WREN2_11_IV\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.21.TRFWWBASICCELL.TEMP2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.20.TRFWWBASICCELL.TEMP2_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.20.TRFWWBASICCELL.TEMP2_3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.UN15_XZROUNDOUT\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.UN23_XZROUNDOUT\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN26_XZYBUSLSBS\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.UN38_SHDVAR_3\ : std_logic ;
  signal \GRLFPC20.COMB.V.STATE14\ : std_logic ;
  signal \GRLFPC20.R.I.EXC_2_0_0__G4\ : std_logic ;
  signal \GRLFPC20.R.I.EXC_2_0_2__G3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN13_NOTXZYFROMD\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.INEXACTSIG.NOTAM2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.ENTRYSHFT.S_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.ENTRYSHFT.S_CMP_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.ENTRYSHFT.S_CMP\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.ENTRYSHFT.UN10_S_MOV\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.CHECKOVANDDENORM.UN13_NOTPOSSIBLEOV\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.ENTRYSHFT.UN3_S\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.ENTRYSHFT.UN6_S_0_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.ENTRYSHFT.UN1_S\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.ENTRYSHFT.UN1_ENTRYPOINT\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.BUSYMULXFF.UN2_TEMP\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.BUSYMULXFF.UN2_TEMP_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.PCTRL_NEW_11_0_69__G2_0_529_A3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.UN14_CONDITIONAL\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.OPREXCSHFT.UN3_OPREXC\ : std_logic ;
  signal \GRLFPC20.V.FSR.AEXC_2_SQMUXA\ : std_logic ;
  signal \GRLFPC20.V.FSR.AEXC_1_SQMUXA\ : std_logic ;
  signal \GRLFPC20.COMB.V.FSR.FCC10_1\ : std_logic ;
  signal \GRLFPC20.COMB.ISFPOP2_1_X\ : std_logic ;
  signal \GRLFPC20.R.STATE_0_0_0__G3\ : std_logic ;
  signal \GRLFPC20.COMB.UN1_R.I.V\ : std_logic ;
  signal \GRLFPC20.COMB.V.STATE\ : std_logic ;
  signal \GRLFPC20.UN1_FPCI_2\ : std_logic ;
  signal \GRLFPC20.R.FSR.FTT_1_0_2__G2_490\ : std_logic ;
  signal \GRLFPC20.UN1_FPCI_13\ : std_logic ;
  signal \GRLFPC20.V.STATE_1_SQMUXA_1_X\ : std_logic ;
  signal \GRLFPC20.COMB.UN7_RS1V_X\ : std_logic ;
  signal \GRLFPC20.COMB.UN1_RS1V_X\ : std_logic ;
  signal \GRLFPC20.COMB.RDD_1.M14_0_A2_1\ : std_logic ;
  signal \GRLFPC20.R.A.RDD_0_0_0__G2\ : std_logic ;
  signal \GRLFPC20.COMB.RDD_1.M14_0_O2\ : std_logic ;
  signal \GRLFPC20.R.A.AFSR_0_0_G1_1\ : std_logic ;
  signal \GRLFPC20.COMB.QNE2\ : std_logic ;
  signal \GRLFPC20.COMB.SEQERR.UN7_OP_0_A2_X\ : std_logic ;
  signal \GRLFPC20.COMB.V.A.LD_1_0_O2\ : std_logic ;
  signal \GRLFPC20.COMB.V.A.AFSR_1_5_0_O2\ : std_logic ;
  signal \GRLFPC20.UN1_MOV_1_SQMUXA\ : std_logic ;
  signal \GRLFPC20.COMB.FPDECODE.ST_0_A2\ : std_logic ;
  signal \GRLFPC20.COMB.FPDECODE.FPOP8_I_O3_X\ : std_logic ;
  signal \GRLFPC20.COMB.FPDECODE.ST3_1\ : std_logic ;
  signal \GRLFPC20.COMB.V.A.AFSR_1_5_0_O2_1\ : std_logic ;
  signal \GRLFPC20.COMB.FPDECODE.FPOP2_0_O2_X\ : std_logic ;
  signal \GRLFPC20.COMB.LOCKGEN.LOCKI_I_0_0_A2_0\ : std_logic ;
  signal \GRLFPC20.R.A.SEQERR_0_0_0__G3\ : std_logic ;
  signal \GRLFPC20.RS1D_CNST_0_A2_2_X\ : std_logic ;
  signal \GRLFPC20.COMB.RS1V_1_IV\ : std_logic ;
  signal \GRLFPC20.COMB.V.A.RF1REN_1_0_650_A2_3_X\ : std_logic ;
  signal \GRLFPC20.COMB.FPDECODE.FPOP2_0_A2\ : std_logic ;
  signal \GRLFPC20.COMB.RDD_1.M10_2_0_A2_X\ : std_logic ;
  signal \GRLFPC20.COMB.UN1_MEXC_1\ : std_logic ;
  signal \GRLFPC20.COMB.V.I.EXEC_5_IV\ : std_logic ;
  signal \GRLFPC20.R.I.EXC_2_0_3__G3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DECODESTATUS.UN7_STATUS\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.INEXACTSIG.UN13_INEXACT\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.INEXACTSIG.UN3_INEXACT\ : std_logic ;
  signal \GRLFPC20.COMB.ANNULRES_1_IV_454\ : std_logic ;
  signal \GRLFPC20.R.I.EXEC_0_0_G1_0_I_A8_0\ : std_logic ;
  signal \GRLFPC20.COMB.UN3_HOLDN_X\ : std_logic ;
  signal \GRLFPC20.ANNULFPU_0_SQMUXA_2_X\ : std_logic ;
  signal \GRLFPC20.COMB.V.E.STDATA2_X\ : std_logic ;
  signal \GRLFPC20.COMB.FPDECODE.RDD5_3_0_A2_X\ : std_logic ;
  signal \GRLFPC20.FPI.LDOP_2\ : std_logic ;
  signal \GRLFPC20.R.MK.BUSY2_0_0_G3\ : std_logic ;
  signal \GRLFPC20.ANNULRES_1_SQMUXA\ : std_logic ;
  signal \GRLFPC20.ANNULRES_0_SQMUXA_12_1\ : std_logic ;
  signal \GRLFPC20.ANNULFPU_0_SQMUXA_X\ : std_logic ;
  signal \GRLFPC20.COMB.V.A.LD_1_0_A2_0\ : std_logic ;
  signal \GRLFPC20.COMB.RSDECODE.RS1V_X\ : std_logic ;
  signal \GRLFPC20.COMB.LOCKGEN.DEPCHECK\ : std_logic ;
  signal \GRLFPC20.ANNULFPU_0_SQMUXA_1_X\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.36.TRFWWBASICCELL.TEMP2_3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.35.TRFWWBASICCELL.TEMP2_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.UN30_CONDITIONAL_M5\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.G_36\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SXC.SFTLFT.AREGXORBREG\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.FEEDBACKMULXFF.UN7_FEEDBACK_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_PCTRL_NEW_43_2_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.OPREXCSHFT.UN13_EXMIPTRLSBS_M\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.AEBEEXC.UN3_NOTBZERODENORM\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SXC.SFTLFT.UN1_GRFPUS\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.CTRLAREGXZ.UN5_XZAREGLOADEN\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.CTRLAREGEXP.EXPAREGLOADEN_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.AEBEEXC.UN4_NOTAINFNAN\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SXC.SFTLFT.UN4_TEMP\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL_SN_M3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.COMPUTECONST.UN25_RESVEC_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.COUNTSUCCESSIVEZERO_M5S2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_COUNTSUCCESSIVEZERO18\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.NORMDETECT.NOTSLFROMNORM_17_3_0_.M4\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.NORMDETECT.NOTSLFROMNORM_17_3_0_.M3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.NORMDETECT.NOTSLFROMNORM_17_3_0_.M2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.UN7_SHDVAR\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.UN23_EXPXBUS_10\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.UN23_EXPXBUS_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.COUNTSUCCESSIVEZERO_M8S2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.UN23_EXPXBUS_12\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.NOTABORTNULLEXC\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.OPREXC\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.WAITMULXFF.UN2_TEMP\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.TEMP_20\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_SN_M2_0\ : std_logic ;
  signal NN_1 : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.UN29_GRFPUSX_M_381\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN2_AREGSIGN_SEL_30\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.SIGNRESULT_I_M\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.TEMP\ : std_logic ;
  signal \GRLFPC20.UN1_FPCI_22_X\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SXC.RNDMODESELECT.UN17_U_RDN\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.13.TRFWWBASICCELL.TEMP2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.12.TRFWWBASICCELL.TEMP2_3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.14.TRFWWBASICCELL.TEMP2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.13.TRFWWBASICCELL.TEMP2_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.12.TRFWWBASICCELL.TEMP2_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.11.TRFWWBASICCELL.TEMP2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.22.TRFWWBASICCELL.TEMP2_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.12.TRFWWBASICCELL.TEMP2_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.12.TRFWWBASICCELL.TEMP2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_M1_E_3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.13.TRFWWBASICCELL.TEMP2_3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_M5_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.CI_58_2.ANC1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.CI_2_C0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7356\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.CI_2_BNC4\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.55.TRFWWBASICCELL.CIN_9\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.CI_2_C2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_0_261__G5\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.CO0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.54.TRFWWBASICCELL.CIN\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.CO2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULLSBLOGIC.STCKYPAIR.UN6_NOTPROP\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.CI_57_SUM0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.ROMXZSL2FROMC\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULLSBLOGIC.STCKYPAIR.UN36_STKGEN\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULLSBLOGIC.STCKYPAIR.UN18_STKGEN\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULLSBLOGIC.STCKYPAIR.UN27_STKGEN\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.CI_57_C1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULLSBLOGIC.STCKYPAIR.UN16_NOTPROP_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.2.CI_56_C1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULLSBLOGIC.STCKYPAIR.UN20_STKOUT\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULLSBLOGIC.STCKYPAIR.UN12_STKOUT\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULLSBLOGIC.STCKYPAIR.UN4_STKOUT\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULLSBLOGIC.STCKYPAIR.UN22_NOTPROP\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULLSBLOGIC.STCKYPAIR.UN16_NOTPROP\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULLSBLOGIC.STCKYPAIR.UN10_NOTPROP_0_0_A3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULLSBLOGIC.STCKYPAIR.UN1_NOTPROP_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULLSBLOGIC.STCKYPAIR.GEN_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULLSBLOGIC.STCKYPAIR.GEN_3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULLSBLOGIC.STCKYPAIR.GEN_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.2.CI_56_SUM4\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.CI_57_SUM3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULLSBLOGIC.STCKYPAIR.UN19_GEN\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULLSBLOGIC.TEMP_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULLSBLOGIC.STCKYPAIR.UN10_NOTPROP_0_2_I_O3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.CI_57_C1_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.0.TRFWWBASICCELL.CIN\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.CI_57_C0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.0.TRFWWBASICCELL.TEMP2_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.0.TRFWWBASICCELL.TEMP2_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.0.TRFWWBASICCELL.TEMP2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.48.TRFWWBASICCELL.TEMP2_3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.32.TRFWWBASICCELL.TEMP2_3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.48.TRFWWBASICCELL.TEMP2_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.47.TRFWWBASICCELL.TEMP2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.53.TRFWWBASICCELL.CIN\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN18_XZXBUS_43\ : std_logic ;
  signal \GRLFPC20.COMB.FPDECODE.RDD3_TZ\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.MAPMULXFF.UN4_UNIMPMAP_1_X\ : std_logic ;
  signal \GRLFPC20.COMB.FPDECODE.RDD4_0_A2_0_X\ : std_logic ;
  signal \GRLFPC20.COMB.FPDECODE.RDD4_0_A2_X\ : std_logic ;
  signal \GRLFPC20.R.A.RS1D_0_0_G4\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.1.TRFWWBASICCELL.CIN_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.2.CI_56_SUM0\ : std_logic ;
  signal \GRLFPC20.COMB.FPDECODE.RDD5_0_A3\ : std_logic ;
  signal \GRLFPC20.MOV_7_SQMUXA\ : std_logic ;
  signal \GRLFPC20.COMB.V.A.RF1REN_1_670_I_M4\ : std_logic ;
  signal \GRLFPC20.COMB.V.I.V_1_F1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.3.TRFWWBASICCELL.TEMP2_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.2.TRFWWBASICCELL.TEMP2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.1.TRFWWBASICCELL.TEMP2_3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.CTRLCREGXZ.UN1_INFORCREGDB\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_172__G0_0_M3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.55.TRFWWBASICCELL.TEMP2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.53.TRFWWBASICCELL.TEMP2_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.54.TRFWWBASICCELL.TEMP2_3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.TRFWWBASICCELL.TEMP2_3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.55.TRFWWBASICCELL.TEMP2_3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.54.TRFWWBASICCELL.TEMP2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.55.TRFWWBASICCELL.TEMP2_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.TRFWWBASICCELL.TEMP2_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.TRFWWBASICCELL.TEMP2_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_1299_SUM2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.54.TRFWWBASICCELL.TEMP2_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.55.TRFWWBASICCELL.CIN_10\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_1299_AXB0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.UN17_SHDVAR\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.UN40_SHDVAR\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.NOTSTICKYINFORSR_0\ : std_logic ;
  signal \GRLFPC20.COMB.WREN1_11_IV\ : std_logic ;
  signal \GRLFPC20.WREN1_1_SQMUXA\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.AEBEEXC.UN4_NOTBINFNAN\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.UN38_SHDVAR_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN18_XZXBUS_31\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.2.CI_56_C0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN18_XZXBUS_57\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN18_XZXBUS_42\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN18_XZXBUS_38\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN18_XZXBUS_37\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN18_XZXBUS_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN18_XZXBUS_35\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN18_XZXBUS_3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.50.TRFWWBASICCELL.TEMP2_3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.4.TRFWWBASICCELL.TEMP2_3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.17.TRFWWBASICCELL.TEMP2_3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.15.TRFWWBASICCELL.TEMP2_3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.33.TRFWWBASICCELL.TEMP2_3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.43.TRFWWBASICCELL.TEMP2_3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.22.TRFWWBASICCELL.TEMP2_3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.5.TRFWWBASICCELL.TEMP2_3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.46.TRFWWBASICCELL.TEMP2_3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.45.TRFWWBASICCELL.TEMP2_3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.28.TRFWWBASICCELL.TEMP2_3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.21.TRFWWBASICCELL.TEMP2_3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.44.TRFWWBASICCELL.TEMP2_3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.43.TRFWWBASICCELL.TEMP2_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.49.TRFWWBASICCELL.TEMP2_3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.7.TRFWWBASICCELL.TEMP2_3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.15.TRFWWBASICCELL.TEMP2_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.33.TRFWWBASICCELL.TEMP2_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.21.TRFWWBASICCELL.TEMP2_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.16.TRFWWBASICCELL.TEMP2_3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.31.TRFWWBASICCELL.TEMP2_3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.46.TRFWWBASICCELL.TEMP2_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.31.TRFWWBASICCELL.TEMP2_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.30.TRFWWBASICCELL.TEMP2_3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.29.TRFWWBASICCELL.TEMP2_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.53.TRFWWBASICCELL.TEMP2_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.46.TRFWWBASICCELL.TEMP2_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.11.TRFWWBASICCELL.TEMP2_3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.10.TRFWWBASICCELL.TEMP2_3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.42.TRFWWBASICCELL.TEMP2_3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.41.TRFWWBASICCELL.TEMP2_3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.40.TRFWWBASICCELL.TEMP2_3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.45.TRFWWBASICCELL.TEMP2_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.44.TRFWWBASICCELL.TEMP2_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.34.TRFWWBASICCELL.TEMP2_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.18.TRFWWBASICCELL.TEMP2_3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.14.TRFWWBASICCELL.TEMP2_3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.24.TRFWWBASICCELL.TEMP2_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.5.TRFWWBASICCELL.TEMP2_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.14.TRFWWBASICCELL.TEMP2_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.30.TRFWWBASICCELL.TEMP2_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.39.TRFWWBASICCELL.TEMP2_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.9.TRFWWBASICCELL.TEMP2_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.13.TRFWWBASICCELL.TEMP2_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.6.TRFWWBASICCELL.TEMP2_3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.42.TRFWWBASICCELL.TEMP2_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.41.TRFWWBASICCELL.TEMP2_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.23.TRFWWBASICCELL.TEMP2_3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.28.TRFWWBASICCELL.TEMP2_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.38.TRFWWBASICCELL.TEMP2_3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.30.TRFWWBASICCELL.TEMP2_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.23.TRFWWBASICCELL.TEMP2_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.31.TRFWWBASICCELL.TEMP2_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.40.TRFWWBASICCELL.TEMP2_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.15.TRFWWBASICCELL.TEMP2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.17.TRFWWBASICCELL.TEMP2_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.19.TRFWWBASICCELL.TEMP2_3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.39.TRFWWBASICCELL.TEMP2_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.38.TRFWWBASICCELL.TEMP2_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.1.TRFWWBASICCELL.TEMP2_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.11.TRFWWBASICCELL.TEMP2_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.38.TRFWWBASICCELL.TEMP2_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.2.TRFWWBASICCELL.TEMP2_3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.49.TRFWWBASICCELL.TEMP2_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.23.TRFWWBASICCELL.TEMP2_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.45.TRFWWBASICCELL.TEMP2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.44.TRFWWBASICCELL.TEMP2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.3.TRFWWBASICCELL.TEMP2_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.2.TRFWWBASICCELL.TEMP2_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.1.TRFWWBASICCELL.TEMP2_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.32.TRFWWBASICCELL.TEMP2_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.41.TRFWWBASICCELL.TEMP2_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.27.TRFWWBASICCELL.TEMP2_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.39.TRFWWBASICCELL.TEMP2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.51.TRFWWBASICCELL.TEMP2_3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.47.TRFWWBASICCELL.TEMP2_3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.50.TRFWWBASICCELL.TEMP2_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.37.TRFWWBASICCELL.TEMP2_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.27.TRFWWBASICCELL.TEMP2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.9.TRFWWBASICCELL.TEMP2_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.34.TRFWWBASICCELL.TEMP2_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.7.TRFWWBASICCELL.TEMP2_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.16.TRFWWBASICCELL.TEMP2_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.49.TRFWWBASICCELL.TEMP2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.3.TRFWWBASICCELL.TEMP2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.42.TRFWWBASICCELL.TEMP2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.5.TRFWWBASICCELL.TEMP2_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.4.TRFWWBASICCELL.TEMP2_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.7.TRFWWBASICCELL.TEMP2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.6.TRFWWBASICCELL.TEMP2_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.16.TRFWWBASICCELL.TEMP2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.54.TRFWWBASICCELL.TEMP2_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.40.TRFWWBASICCELL.TEMP2_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.52.TRFWWBASICCELL.TEMP2_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.55.TRFWWBASICCELL.TEMP2_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.8.TRFWWBASICCELL.TEMP2_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.29.TRFWWBASICCELL.TEMP2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.6.TRFWWBASICCELL.TEMP2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.35.TRFWWBASICCELL.TEMP2_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.22.TRFWWBASICCELL.TEMP2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.51.TRFWWBASICCELL.TEMP2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.50.TRFWWBASICCELL.TEMP2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.37.TRFWWBASICCELL.TEMP2_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.4.TRFWWBASICCELL.TEMP2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.47.TRFWWBASICCELL.TEMP2_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.48.TRFWWBASICCELL.TEMP2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.9.TRFWWBASICCELL.TEMP2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.35.TRFWWBASICCELL.TEMP2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.36.TRFWWBASICCELL.TEMP2_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.19.TRFWWBASICCELL.TEMP2_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.19.TRFWWBASICCELL.TEMP2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.8.TRFWWBASICCELL.TEMP2_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.32.TRFWWBASICCELL.TEMP2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.33.TRFWWBASICCELL.TEMP2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.18.TRFWWBASICCELL.TEMP2_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.52.TRFWWBASICCELL.TEMP2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.34.TRFWWBASICCELL.TEMP2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.37.TRFWWBASICCELL.TEMP2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.53.TRFWWBASICCELL.TEMP2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.10.TRFWWBASICCELL.TEMP2_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.20.TRFWWBASICCELL.TEMP2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.10.TRFWWBASICCELL.TEMP2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.24.TRFWWBASICCELL.TEMP2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.17.TRFWWBASICCELL.TEMP2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.18.TRFWWBASICCELL.TEMP2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.8.TRFWWBASICCELL.TEMP2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.29.TRFWWBASICCELL.TEMP2_3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.43.TRFWWBASICCELL.TEMP2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.25.TRFWWBASICCELL.TEMP2_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.24.TRFWWBASICCELL.TEMP2_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.28.TRFWWBASICCELL.TEMP2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.36.TRFWWBASICCELL.TEMP2_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.33.TRFWWBASICCELL.TEMP2_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.34.TRFWWBASICCELL.TEMP2_3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.53.TRFWWBASICCELL.TEMP2_3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.26.TRFWWBASICCELL.TEMP2_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.25.TRFWWBASICCELL.TEMP2_3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.24.TRFWWBASICCELL.TEMP2_3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.9.TRFWWBASICCELL.TEMP2_3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.45.TRFWWBASICCELL.TEMP2_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.4.TRFWWBASICCELL.TEMP2_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.43.TRFWWBASICCELL.TEMP2_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.3.TRFWWBASICCELL.TEMP2_3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.39.TRFWWBASICCELL.TEMP2_3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.28.TRFWWBASICCELL.TEMP2_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.27.TRFWWBASICCELL.TEMP2_3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.49.TRFWWBASICCELL.TEMP2_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.44.TRFWWBASICCELL.TEMP2_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.37.TRFWWBASICCELL.TEMP2_3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.35.TRFWWBASICCELL.TEMP2_3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.52.TRFWWBASICCELL.TEMP2_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.8.TRFWWBASICCELL.TEMP2_3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.7.TRFWWBASICCELL.TEMP2_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.6.TRFWWBASICCELL.TEMP2_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.11.TRFWWBASICCELL.TEMP2_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.10.TRFWWBASICCELL.TEMP2_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.32.TRFWWBASICCELL.TEMP2_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.29.TRFWWBASICCELL.TEMP2_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.42.TRFWWBASICCELL.TEMP2_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.2.TRFWWBASICCELL.TEMP2_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.31.TRFWWBASICCELL.TEMP2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.18.TRFWWBASICCELL.TEMP2_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.19.TRFWWBASICCELL.TEMP2_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.48.TRFWWBASICCELL.TEMP2_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.47.TRFWWBASICCELL.TEMP2_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.46.TRFWWBASICCELL.TEMP2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.51.TRFWWBASICCELL.TEMP2_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.50.TRFWWBASICCELL.TEMP2_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.5.TRFWWBASICCELL.TEMP2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.1.TRFWWBASICCELL.TEMP2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.17.TRFWWBASICCELL.TEMP2_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.20.TRFWWBASICCELL.TEMP2_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.41.TRFWWBASICCELL.TEMP2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.30.TRFWWBASICCELL.TEMP2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.36.TRFWWBASICCELL.TEMP2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.38.TRFWWBASICCELL.TEMP2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.40.TRFWWBASICCELL.TEMP2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_M5_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_M5_4\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_M5_6\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_M1_E\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.22.TRFWWBASICCELL.TEMP2_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.21.TRFWWBASICCELL.TEMP2_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.15.TRFWWBASICCELL.TEMP2_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.14.TRFWWBASICCELL.TEMP2_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.23.TRFWWBASICCELL.TEMP2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.16.TRFWWBASICCELL.TEMP2_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_M5\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_M5_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_M5_3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_M5_5\ : std_logic ;
  signal \GRLFPC20.UN1_RS1V_0_SQMUXA\ : std_logic ;
  signal \GRLFPC20.RS1V_0_SQMUXA_1_X\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.UN20_NOTSLRES\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_MUX_3_3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_MUX_3_I_O2\ : std_logic ;
  signal \GRLFPC20.COMB.V.A.RF2REN_1_0_701_I_948_TZ\ : std_logic ;
  signal \GRLFPC20.COMB.RSDECODE.UN1_FPCI_0_X\ : std_logic ;
  signal \GRLFPC20.R.A.MOV_0_0_G1_0_X\ : std_logic ;
  signal \GRLFPC20.R.FSR.FTT_1_0_0__G2_0_600_I_0_X\ : std_logic ;
  signal \GRLFPC20.R.A.AFQ_0_0_G1_0\ : std_logic ;
  signal \GRLFPC20.V.FSR.AEXC_1_SQMUXA_0\ : std_logic ;
  signal \GRLFPC20.R.I.RDD_0_0_G1_0_574_I_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.DPATH_M2_E\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_PCTRL_NEW_43_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.MULTIPLEXORMULXFF.RESULT_M4_3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.MULTIPLEXORMULXFF.RESULT_M4_5\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.MULTIPLEXORMULXFF.RESULT_M4\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.MULTIPLEXORMULXFF.RESULT_M4_4\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.MULTIPLEXORMULXFF.RESULT_M4_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.MULTIPLEXORMULXFF.RESULT_M4_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_M1_0_A2_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_M4_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_M4_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_M4_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_M4_3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_M4_4\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_M4_5\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_M4_6\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_M3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.MULTIPLEXORMULXFF.RESULT_M1_0_A2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.MULTIPLEXORMULXFF.RESULT_M1_0_A2_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.MULTIPLEXORMULXFF.RESULT_M1_0_A2_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.MULTIPLEXORMULXFF.RESULT_M1_0_A2_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.MULTIPLEXORMULXFF.RESULT_M1_0_A2_3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.MULTIPLEXORMULXFF.RESULT_M1_0_A2_4\ : std_logic ;
  signal \GRLFPC20.COMB.RDD_1.M14_0_A2_0_0\ : std_logic ;
  signal \GRLFPC20.COMB.RDD_1.M14_0_A2_0_1\ : std_logic ;
  signal \GRLFPC20.R.A.AFQ_0_0_G1_0_3\ : std_logic ;
  signal \GRLFPC20.WREN1_1_SQMUXA_1\ : std_logic ;
  signal \GRLFPC20.COMB.WREN1_11_IV_1_X\ : std_logic ;
  signal \GRLFPC20.R.A.RS1D_0_0_G4_1_X\ : std_logic ;
  signal \GRLFPC20.RS2_0_SQMUXA_0_X\ : std_logic ;
  signal \GRLFPC20.UN1_MOV_1_SQMUXA_0\ : std_logic ;
  signal \GRLFPC20.COMB.LOCK_1_1_X\ : std_logic ;
  signal \GRLFPC20.MOV_2_SQMUXA_2\ : std_logic ;
  signal \GRLFPC20.RS1D_CNST_0_A2_0\ : std_logic ;
  signal \GRLFPC20.RS1D_CNST_0_A2_1_X\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SXC.SCTRL_NEW_6_0_0__G0_0_A3_0_X\ : std_logic ;
  signal \GRLFPC20.COMB.FPDECODE.FPOP3_0\ : std_logic ;
  signal \GRLFPC20.COMB.RSDECODE.RS1V2_0\ : std_logic ;
  signal \GRLFPC20.COMB.WREN2_11_IV_1_X\ : std_logic ;
  signal \GRLFPC20.COMB.FPDECODE.UN1_FPCI_7_1_X\ : std_logic ;
  signal \GRLFPC20.R.A.MOV_0_0_G1_1_X\ : std_logic ;
  signal \GRLFPC20.R.A.MOV_0_0_G1_3\ : std_logic ;
  signal \GRLFPC20.COMB.FPDECODE.UN1_FPCI_0_7_2\ : std_logic ;
  signal \GRLFPC20.COMB.UN9_CCV_0_0\ : std_logic ;
  signal \GRLFPC20.COMB.UN9_CCV_0_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.AEBEEXC.UN3_NOTAZERODENORM_0\ : std_logic ;
  signal \GRLFPC20.R.FSR.FTT_1_0_0__G2_0_600_I_A6_1_0\ : std_logic ;
  signal \GRLFPC20.COMB.UN1_FPCI_0_1_X\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.UN4_NOTSHIFTCOUNT1_0\ : std_logic ;
  signal \GRLFPC20.N_1243_I_0_A2_1_X\ : std_logic ;
  signal \GRLFPC20.V.FSR.FTT_1_SQMUXA_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.UN38_SHDVAR_2_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.AEBEEXC.UN26_NOTAINFNAN_4\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.AEBEEXC.UN26_NOTAINFNAN_5\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.AEBEEXC.UN26_NOTBINFNAN_4\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.AEBEEXC.UN26_NOTBINFNAN_5\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.UN23_EXPXBUS_11_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_COUNTSUCCESSIVEZERO18_8\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_COUNTSUCCESSIVEZERO18_9\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_COUNTSUCCESSIVEZERO18_10\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_COUNTSUCCESSIVEZERO18_11\ : std_logic ;
  signal \GRLFPC20.COMB.UN1_MEXC_1_0\ : std_logic ;
  signal \GRLFPC20.COMB.UN1_MEXC_1_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_M4_1_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.SELINITREMBIT_0\ : std_logic ;
  signal \GRLFPC20.R.FSR.FTT_1_0_1__G2_0_624_I_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.INEXACTSIG.UN13_INEXACT_10\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.INEXACTSIG.UN13_INEXACT_13\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.INEXACTSIG.UN13_INEXACT_14\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.INEXACTSIG.UN13_INEXACT_15\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.INEXACTSIG.UN13_INEXACT_16\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.INEXACTSIG.UN13_INEXACT_17\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.INEXACTSIG.UN13_INEXACT_18\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.INEXACTSIG.UN13_INEXACT_23\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.INEXACTSIG.UN13_INEXACT_24\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.INEXACTSIG.UN13_INEXACT_27\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_M3_E_0_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_M3_E_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_M3_E_1_2\ : std_logic ;
  signal \GRLFPC20.R.FSR.FTT_1_0_0__G2_0_600_I_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.UN12_SRTOSTICKY_3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_M1_E_3_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_M1_E_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.ENTRYSHFT.UN10_S_MOV_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.ENTRYSHFT.UN3_S_SQRT_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.ENTRYSHFT.UN3_S_SQRT_3\ : std_logic ;
  signal \GRLFPC20.R.A.AFSR_0_0_G1_1_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.UN17_SHDVAR_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.ENTRYSHFT.ENTRYPOINT_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.ENTRYSHFT.ENTRYPOINT_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.UN11_WQSTSETS_0\ : std_logic ;
  signal \GRLFPC20.R.STATE_0_0_0__G3_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULLSBLOGIC.STCKYPAIR.UN13_GEN_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.UN23_EXPXBUS_1_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.2.CI_56_SUM1_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.NOTSTICKYINFORSR_2_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOINSTANDNOEXC_41_2_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.UN23_EXPXBUS_NE_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.UN23_EXPXBUS_NE_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.UN23_EXPXBUS_NE_3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.UN23_EXPXBUS_NE_5\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.UN23_EXPXBUS_NE_6\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.UN23_EXPXBUS_NE_8\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.UN23_EXPXBUS_NE_10\ : std_logic ;
  signal \GRLFPC20.R.I.EXEC_0_0_G1_0_I_0_0\ : std_logic ;
  signal \GRLFPC20.R.I.V_1_0_G0_0_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_4\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_5\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_6\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_8\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_9\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_11\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_12\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_14\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_15\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_16\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_17\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_18\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_21\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_22\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_25\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_27\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_28\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_29\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_30\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_32\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_35\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_38\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_39\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_40\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_41\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_42\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_44\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_45\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_47\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_50\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_51\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_52\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_53\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_54\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.UN30_CONDITIONAL_M2_E_3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.UN30_CONDITIONAL_M2_E_4\ : std_logic ;
  signal \GRLFPC20.R.FSR.AEXC_1_0_0__G1_0\ : std_logic ;
  signal \GRLFPC20.R.FSR.AEXC_1_0_3__G1_0\ : std_logic ;
  signal \GRLFPC20.R.FSR.AEXC_1_0_1__G1_0\ : std_logic ;
  signal \GRLFPC20.R.FSR.AEXC_1_0_2__G1_0\ : std_logic ;
  signal \GRLFPC20.R.FSR.AEXC_1_0_4__G1_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULLSBLOGIC.STCKYPAIR.UN36_STKGEN_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.MULTIPLEXORMULXFF.RESULT_M1_0_A2_0_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.DPATH_M2_0_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.CHECKOVANDDENORM.UN13_NOTPOSSIBLEOV_3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.CHECKOVANDDENORM.UN13_NOTPOSSIBLEOV_4\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.SIGNRESULT_I_M_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_0_315__G3_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_0_315__G3_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_0_315__G3_4\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.UN30_CONDITIONAL_0_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.UN30_CONDITIONAL_0_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.DPATH_M2_0_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.SCTRL_38_IV_I_0_0__G0_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.DPATH_NEW_7_SQMUXA_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.MULTIPLEXORMULXFF.RESULT_1_IV_0_3__G0_0_A5_0_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.MULTIPLEXORMULXFF.RESULT_1_IV_0_3__G0_0_A5_0_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.MULTIPLEXORMULXFF.RESULT_1_IV_I_0_2__G0_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.MULTIPLEXORMULXFF.RESULT_1_IV_I_0_6__G0_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.MULTIPLEXORMULXFF.RESULT_1_IV_I_0_4__G0_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.MULTIPLEXORMULXFF.RESULT_1_IV_I_0_5__G0_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.MULTIPLEXORMULXFF.RESULT_1_IV_I_0_0__G0_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.MULTIPLEXORMULXFF.RESULT_1_IV_I_0_1__G0_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.MULTIPLEXORMULXFF.RESULT_1_IV_I_0_7__G0_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.BUSYMULXFF.UN2_TEMP_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.MULTIPLEXORMULXFF.RESULT_1_IV_0_3__G0_0_1\ : std_logic ;
  signal \GRLFPC20.R.MK.BUSY_0_0_G0_0_X\ : std_logic ;
  signal \GRLFPC20.COMB.V.MK.RST_1_0_G0_1_0_X\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_M1_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_PCTRL_NEW_43_2_C\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_PCTRL_NEW_43_2_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN15_NOTXZYFROMD_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOINSTANDNOEXC_41_2\ : std_logic ;
  signal \GRLFPC20.V.FSR.CEXC_3_SQMUXA\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN20_ZERO\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.COUNTSUCCESSIVEZERO_M14S2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.COUNTSUCCESSIVEZERO_M5S4\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.COUNTSUCCESSIVEZERO_M11S4\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_SN_M2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.EXPAREGLOADEN_1\ : std_logic ;
  signal \GRLFPC20.COMB.UN1_FPCI_4\ : std_logic ;
  signal \GRLFPC20.RS2_0_SQMUXA\ : std_logic ;
  signal \GRLFPC20.COMB.V.A.RF2REN_1_0_701_I_948_X\ : std_logic ;
  signal \GRLFPC20.V.FSR.NONSTD_0_SQMUXA_2_X\ : std_logic ;
  signal \GRLFPC20.COMB.UN1_R.A.RS1_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.G_37\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSAMPLEDWAIT\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN25_NOTXZYFROMD\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN3_NOTXZYFROMD\ : std_logic ;
  signal \GRLFPC20.COMB.V.FSR.CEXC_1_SN_M2\ : std_logic ;
  signal \GRLFPC20.COMB.UN1_R.I.EXC\ : std_logic ;
  signal \GRLFPC20.WRADDR_1_SQMUXA\ : std_logic ;
  signal \GRLFPC20.COMB.RDD_2\ : std_logic ;
  signal \GRLFPC20.WRADDR_0_SQMUXA_0_X\ : std_logic ;
  signal \GRLFPC20.RS1V_0_SQMUXA\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.DPATH_NEW_7_SQMUXA\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.XZBREGLOADEN\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_M2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRTOSTICKY\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.CTRLXERSHFT.SUMIN_5_SN_M1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN35_ZERO\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN50_ZERO\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN5_ZERO\ : std_logic ;
  signal \GRLFPC20.COMB.UN19_IUEXEC\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.G_778\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.WAITMULXFF.NOTSAMPLEDWAIT\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.XZAREGLOADEN\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.UN2_NOTABORTWB\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.DPATH_M2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.EXPBREGLOADEN\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.UPDATE_1\ : std_logic ;
  signal \GRLFPC20.COMB.UN2_HOLDN\ : std_logic ;
  signal \GRLFPC20.V.I.EXEC_0_SQMUXA\ : std_logic ;
  signal \GRLFPC20.FPI.LDOP\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN3_NOTXZYFROMD_A\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.UN17_SHDVAR_A\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_20__G2_A\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN5_ZERO_A\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.ENTRYSHFT.UN1_S_A\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.UN30_CONDITIONAL_M5_A\ : std_logic ;
  signal \GRLFPC20.COMB.FPDECODE.RDD3_TZ_A\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_M5_0_A\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_M5_1_A\ : std_logic ;
  signal \GRLFPC20.ANNULRES_1_SQMUXA_A\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.TEMP_20_A\ : std_logic ;
  signal \GRLFPC20.COMB.RDD_1.M14_0_A2_0_0_A\ : std_logic ;
  signal \GRLFPC20.COMB.RSDECODE.RS1V2_0_A\ : std_logic ;
  signal \GRLFPC20.RS1V_0_SQMUXA_A\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_0_375__G0_A\ : std_logic ;
  signal \GRLFPC20.R.MK.BUSY2_0_0_G3_A\ : std_logic ;
  signal \GRLFPC20.RS1D_CNST_0_A2_0_A\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.MULTIPLEXORMULXFF.RESULT_M4_5_A\ : std_logic ;
  signal \GRLFPC20.COMB.ANNULRES_1_IV_454_A\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_0_374__G0_0_A\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.UN23_EXPXBUS_NE_10_A\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.NOTSTICKYINFORSR_0_A\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_9_A\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_35_A\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULLSBLOGIC.STCKYPAIR.UN27_STKGEN_A\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.MULTIPLEXORMULXFF.RESULT_1_IV_I_0_0__G0_0_A\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_0_114__G0_A\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_0_315__G3_S\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.DPATH_M2_REP1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_M2_REP1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.XZBREGLOADEN_REP1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN15_NOTXZYFROMD_0_REP1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN15_NOTXZYFROMD_0_REP2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN13_NOTXZYFROMD_REP1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN13_NOTXZYFROMD_REP2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_M2_7_REP1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_M2S2_REP1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_SN_M3_0_I\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.PCTRL_NEW_6_0_67__G0_E_I\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_0_174__G2_I\ : std_logic ;
  signal \GRLFPC20.R.I.PC_1_0_2__G2_X_I\ : std_logic ;
  signal \GRLFPC20.R.FSR.FTT_1_0_0__G0_I_O4_I\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN13_NOTXZYFROMD_REP2_RETI\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN13_NOTXZYFROMD_RETI\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN13_NOTXZYFROMD_REP1_RETI\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.UN20_NOTSLRES_RETI\ : std_logic ;
  signal N_19146 : std_logic ;
  signal N_19147 : std_logic ;
  signal N_19148 : std_logic ;
  signal N_19149 : std_logic ;
  signal N_19200 : std_logic ;
  signal N_19201 : std_logic ;
  signal N_19202 : std_logic ;
  signal N_19203 : std_logic ;
  signal N_19204 : std_logic ;
  signal N_19205 : std_logic ;
  signal N_19206 : std_logic ;
  signal N_19207 : std_logic ;
  signal N_19208 : std_logic ;
  signal N_19209 : std_logic ;
  signal N_19210 : std_logic ;
  signal N_19211 : std_logic ;
  signal N_19212 : std_logic ;
  signal N_19213 : std_logic ;
  signal N_19214 : std_logic ;
  signal N_19215 : std_logic ;
  signal N_19216 : std_logic ;
  signal N_19217 : std_logic ;
  signal N_19218 : std_logic ;
  signal N_19219 : std_logic ;
  signal N_19220 : std_logic ;
  signal N_19221 : std_logic ;
  signal N_19222 : std_logic ;
  signal N_19223 : std_logic ;
  signal N_19224 : std_logic ;
  signal N_19225 : std_logic ;
  signal N_19226 : std_logic ;
  signal N_19227 : std_logic ;
  signal N_19228 : std_logic ;
  signal N_19229 : std_logic ;
  signal N_19230 : std_logic ;
  signal N_19231 : std_logic ;
  signal N_19232 : std_logic ;
  signal N_19233 : std_logic ;
  signal N_19234 : std_logic ;
  signal N_19235 : std_logic ;
  signal N_19236 : std_logic ;
  signal N_19237 : std_logic ;
  signal N_19238 : std_logic ;
  signal N_19239 : std_logic ;
  signal N_19240 : std_logic ;
  signal N_19241 : std_logic ;
  signal N_19242 : std_logic ;
  signal N_19243 : std_logic ;
  signal N_19244 : std_logic ;
  signal N_19245 : std_logic ;
  signal N_19246 : std_logic ;
  signal N_19247 : std_logic ;
  signal N_19248 : std_logic ;
  signal N_19249 : std_logic ;
  signal N_19250 : std_logic ;
  signal N_19251 : std_logic ;
  signal N_19252 : std_logic ;
  signal N_19253 : std_logic ;
  signal N_19254 : std_logic ;
  signal N_19255 : std_logic ;
  signal N_19256 : std_logic ;
  signal N_19257 : std_logic ;
  signal N_19258 : std_logic ;
  signal N_19259 : std_logic ;
  signal N_19260 : std_logic ;
  signal N_19261 : std_logic ;
  signal N_19262 : std_logic ;
  signal N_19263 : std_logic ;
  signal N_19264 : std_logic ;
  signal N_19265 : std_logic ;
  signal N_19266 : std_logic ;
  signal N_19267 : std_logic ;
  signal N_19268 : std_logic ;
  signal N_19269 : std_logic ;
  signal N_19270 : std_logic ;
  signal N_19271 : std_logic ;
  signal N_19272 : std_logic ;
  signal N_19273 : std_logic ;
  signal N_19274 : std_logic ;
  signal N_19275 : std_logic ;
  signal N_19276 : std_logic ;
  signal N_19277 : std_logic ;
  signal N_19278 : std_logic ;
  signal N_19279 : std_logic ;
  signal N_19280 : std_logic ;
  signal N_19281 : std_logic ;
  signal N_19282 : std_logic ;
  signal N_19283 : std_logic ;
  signal N_19284 : std_logic ;
  signal N_19285 : std_logic ;
  signal N_19286 : std_logic ;
  signal N_19287 : std_logic ;
  signal N_19288 : std_logic ;
  signal N_19289 : std_logic ;
  signal N_19290 : std_logic ;
  signal N_19291 : std_logic ;
  signal N_19292 : std_logic ;
  signal N_19293 : std_logic ;
  signal N_19294 : std_logic ;
  signal N_19295 : std_logic ;
  signal N_19296 : std_logic ;
  signal N_19297 : std_logic ;
  signal N_19298 : std_logic ;
  signal N_19299 : std_logic ;
  signal N_19300 : std_logic ;
  signal N_19301 : std_logic ;
  signal N_19302 : std_logic ;
  signal N_19303 : std_logic ;
  signal N_19304 : std_logic ;
  signal N_19305 : std_logic ;
  signal N_19306 : std_logic ;
  signal N_27907 : std_logic ;
  signal N_27908 : std_logic ;
  signal HOLDN_INTERNAL : std_logic ;
  signal CPI_DBG_FSR_INTERNAL : std_logic ;
  signal CPI_DBG_ADDR_INTERNAL : std_logic ;
  signal N_1 : std_logic ;
  signal N_2 : std_logic ;
  signal N_3 : std_logic ;
  signal N_4 : std_logic ;
  signal N_5 : std_logic ;
  signal N_6 : std_logic ;
  signal N_7 : std_logic ;
  signal N_8 : std_logic ;
  signal N_9 : std_logic ;
  signal N_10 : std_logic ;
  signal N_11 : std_logic ;
  signal N_12 : std_logic ;
  signal N_13 : std_logic ;
  signal N_14 : std_logic ;
  signal N_15 : std_logic ;
  signal N_16 : std_logic ;
  signal N_17 : std_logic ;
  signal N_18 : std_logic ;
  signal N_19 : std_logic ;
  signal N_20 : std_logic ;
  signal N_21 : std_logic ;
  signal N_22 : std_logic ;
  signal N_23 : std_logic ;
  signal N_24 : std_logic ;
  signal N_25 : std_logic ;
  signal N_26 : std_logic ;
  signal N_27 : std_logic ;
  signal N_28 : std_logic ;
  signal N_29 : std_logic ;
  signal N_30 : std_logic ;
  signal N_31 : std_logic ;
  signal N_32 : std_logic ;
  signal N_33 : std_logic ;
  signal N_34 : std_logic ;
  signal N_35 : std_logic ;
  signal N_36 : std_logic ;
  signal N_37 : std_logic ;
  signal N_38 : std_logic ;
  signal N_39 : std_logic ;
  signal N_40 : std_logic ;
  signal N_41 : std_logic ;
  signal N_42 : std_logic ;
  signal N_43 : std_logic ;
  signal N_44 : std_logic ;
  signal N_45 : std_logic ;
  signal N_46 : std_logic ;
  signal N_47 : std_logic ;
  signal N_48 : std_logic ;
  signal N_49 : std_logic ;
  signal N_50 : std_logic ;
  signal N_51 : std_logic ;
  signal N_52 : std_logic ;
  signal N_53 : std_logic ;
  signal N_54 : std_logic ;
  signal N_55 : std_logic ;
  signal N_56 : std_logic ;
  signal N_57 : std_logic ;
  signal N_58 : std_logic ;
  signal N_59 : std_logic ;
  signal N_60 : std_logic ;
  signal N_61 : std_logic ;
  signal N_62 : std_logic ;
  signal N_63 : std_logic ;
  signal N_64 : std_logic ;
  signal N_65 : std_logic ;
  signal N_66 : std_logic ;
  signal N_67 : std_logic ;
  signal N_68 : std_logic ;
  signal N_69 : std_logic ;
  signal N_70 : std_logic ;
  signal N_71 : std_logic ;
  signal N_72 : std_logic ;
  signal N_73 : std_logic ;
  signal N_74 : std_logic ;
  signal N_75 : std_logic ;
  signal N_76 : std_logic ;
  signal N_77 : std_logic ;
  signal N_78 : std_logic ;
  signal N_79 : std_logic ;
  signal N_80 : std_logic ;
  signal N_81 : std_logic ;
  signal N_82 : std_logic ;
  signal N_83 : std_logic ;
  signal N_84 : std_logic ;
  signal N_85 : std_logic ;
  signal N_86 : std_logic ;
  signal N_87 : std_logic ;
  signal N_88 : std_logic ;
  signal N_89 : std_logic ;
  signal N_90 : std_logic ;
  signal N_91 : std_logic ;
  signal N_92 : std_logic ;
  signal N_93 : std_logic ;
  signal N_94 : std_logic ;
  signal N_95 : std_logic ;
  signal N_96 : std_logic ;
  signal N_97 : std_logic ;
  signal N_98 : std_logic ;
  signal N_99 : std_logic ;
  signal N_100 : std_logic ;
  signal N_101 : std_logic ;
  signal N_102 : std_logic ;
  signal N_103 : std_logic ;
  signal N_104 : std_logic ;
  signal N_105 : std_logic ;
  signal N_106 : std_logic ;
  signal N_107 : std_logic ;
  signal N_108 : std_logic ;
  signal N_109 : std_logic ;
  signal N_110 : std_logic ;
  signal N_111 : std_logic ;
  signal N_112 : std_logic ;
  signal N_113 : std_logic ;
  signal N_114 : std_logic ;
  signal N_115 : std_logic ;
  signal N_116 : std_logic ;
  signal N_117 : std_logic ;
  signal N_118 : std_logic ;
  signal N_119 : std_logic ;
  signal N_120 : std_logic ;
  signal N_121 : std_logic ;
  signal N_122 : std_logic ;
  signal N_123 : std_logic ;
  signal N_124 : std_logic ;
  signal N_125 : std_logic ;
  signal N_126 : std_logic ;
  signal N_127 : std_logic ;
  signal N_128 : std_logic ;
  signal N_129 : std_logic ;
  signal N_130 : std_logic ;
  signal N_131 : std_logic ;
  signal N_132 : std_logic ;
  signal N_133 : std_logic ;
  signal N_134 : std_logic ;
  signal N_135 : std_logic ;
  signal N_136 : std_logic ;
  signal N_137 : std_logic ;
  signal N_138 : std_logic ;
  signal N_139 : std_logic ;
  signal N_140 : std_logic ;
  signal N_141 : std_logic ;
  signal N_142 : std_logic ;
  signal N_143 : std_logic ;
  signal N_144 : std_logic ;
  signal N_145 : std_logic ;
  signal N_146 : std_logic ;
  signal N_147 : std_logic ;
  signal N_148 : std_logic ;
  signal N_149 : std_logic ;
  signal N_150 : std_logic ;
  signal N_151 : std_logic ;
  signal N_152 : std_logic ;
  signal N_153 : std_logic ;
  signal N_154 : std_logic ;
  signal N_155 : std_logic ;
  signal N_156 : std_logic ;
  signal N_157 : std_logic ;
  signal N_158 : std_logic ;
  signal N_159 : std_logic ;
  signal N_160 : std_logic ;
  signal N_161 : std_logic ;
  signal N_162 : std_logic ;
  signal N_163 : std_logic ;
  signal N_164 : std_logic ;
  signal N_165 : std_logic ;
  signal N_166 : std_logic ;
  signal N_167 : std_logic ;
  signal N_168 : std_logic ;
  signal N_169 : std_logic ;
  signal N_170 : std_logic ;
  signal N_171 : std_logic ;
  signal N_172 : std_logic ;
  signal N_173 : std_logic ;
  signal N_174 : std_logic ;
  signal N_175 : std_logic ;
  signal N_176 : std_logic ;
  signal N_177 : std_logic ;
  signal N_178 : std_logic ;
  signal N_179 : std_logic ;
  signal N_180 : std_logic ;
  signal N_181 : std_logic ;
  signal N_182 : std_logic ;
  signal N_183 : std_logic ;
  signal N_184 : std_logic ;
  signal N_185 : std_logic ;
  signal N_186 : std_logic ;
  signal N_187 : std_logic ;
  signal N_188 : std_logic ;
  signal N_189 : std_logic ;
  signal N_190 : std_logic ;
  signal N_191 : std_logic ;
  signal N_192 : std_logic ;
  signal N_193 : std_logic ;
  signal N_194 : std_logic ;
  signal N_195 : std_logic ;
  signal N_196 : std_logic ;
  signal N_197 : std_logic ;
  signal N_198 : std_logic ;
  signal N_199 : std_logic ;
  signal N_200 : std_logic ;
  signal N_201 : std_logic ;
  signal N_202 : std_logic ;
  signal N_203 : std_logic ;
  signal N_204 : std_logic ;
  signal N_205 : std_logic ;
  signal N_206 : std_logic ;
  signal N_207 : std_logic ;
  signal N_208 : std_logic ;
  signal N_209 : std_logic ;
  signal N_210 : std_logic ;
  signal N_211 : std_logic ;
  signal N_212 : std_logic ;
  signal N_213 : std_logic ;
  signal N_214 : std_logic ;
  signal N_215 : std_logic ;
  signal N_216 : std_logic ;
  signal N_217 : std_logic ;
  signal N_218 : std_logic ;
  signal N_219 : std_logic ;
  signal N_220 : std_logic ;
  signal N_221 : std_logic ;
  signal N_222 : std_logic ;
  signal N_223 : std_logic ;
  signal N_224 : std_logic ;
  signal N_225 : std_logic ;
  signal N_226 : std_logic ;
  signal N_227 : std_logic ;
  signal N_228 : std_logic ;
  signal N_229 : std_logic ;
  signal N_230 : std_logic ;
  signal N_231 : std_logic ;
  signal N_232 : std_logic ;
  signal N_233 : std_logic ;
  signal N_234 : std_logic ;
  signal N_235 : std_logic ;
  signal N_236 : std_logic ;
  signal N_237 : std_logic ;
  signal N_238 : std_logic ;
  signal N_239 : std_logic ;
  signal N_240 : std_logic ;
  signal N_241 : std_logic ;
  signal N_242 : std_logic ;
  signal N_243 : std_logic ;
  signal N_244 : std_logic ;
  signal N_245 : std_logic ;
  signal N_246 : std_logic ;
  signal N_247 : std_logic ;
  signal N_248 : std_logic ;
  signal N_249 : std_logic ;
  signal N_250 : std_logic ;
  signal N_251 : std_logic ;
  signal N_252 : std_logic ;
  signal N_253 : std_logic ;
  signal N_254 : std_logic ;
  signal N_255 : std_logic ;
  signal N_256 : std_logic ;
  signal N_257 : std_logic ;
  signal N_258 : std_logic ;
  signal N_259 : std_logic ;
  signal N_260 : std_logic ;
  signal N_261 : std_logic ;
  signal N_262 : std_logic ;
  signal N_263 : std_logic ;
  signal N_264 : std_logic ;
  signal N_265 : std_logic ;
  signal N_266 : std_logic ;
  signal N_267 : std_logic ;
  signal N_268 : std_logic ;
  signal N_269 : std_logic ;
  signal N_270 : std_logic ;
  signal N_271 : std_logic ;
  signal N_272 : std_logic ;
  signal N_273 : std_logic ;
  signal N_274 : std_logic ;
  signal N_275 : std_logic ;
  signal N_276 : std_logic ;
  signal N_277 : std_logic ;
  signal N_278 : std_logic ;
  signal N_279 : std_logic ;
  signal N_280 : std_logic ;
  signal N_281 : std_logic ;
  signal N_282 : std_logic ;
  signal N_283 : std_logic ;
  signal N_284 : std_logic ;
  signal N_285 : std_logic ;
  signal N_286 : std_logic ;
  signal N_287 : std_logic ;
  signal N_288 : std_logic ;
  signal N_289 : std_logic ;
  signal N_290 : std_logic ;
  signal N_291 : std_logic ;
  signal N_292 : std_logic ;
  signal N_293 : std_logic ;
  signal N_294 : std_logic ;
  signal N_295 : std_logic ;
  signal N_296 : std_logic ;
  signal N_297 : std_logic ;
  signal N_298 : std_logic ;
  signal N_299 : std_logic ;
  signal N_300 : std_logic ;
  signal N_301 : std_logic ;
  signal N_302 : std_logic ;
  signal N_303 : std_logic ;
  signal N_304 : std_logic ;
  signal N_305 : std_logic ;
  signal N_306 : std_logic ;
  signal N_307 : std_logic ;
  signal N_308 : std_logic ;
  signal N_309 : std_logic ;
  signal N_310 : std_logic ;
  signal N_311 : std_logic ;
  signal N_312 : std_logic ;
  signal N_313 : std_logic ;
  signal N_314 : std_logic ;
  signal N_315 : std_logic ;
  signal N_316 : std_logic ;
  signal N_317 : std_logic ;
  signal N_318 : std_logic ;
  signal N_319 : std_logic ;
  signal N_320 : std_logic ;
  signal N_321 : std_logic ;
  signal N_322 : std_logic ;
  signal N_323 : std_logic ;
  signal N_324 : std_logic ;
  signal N_325 : std_logic ;
  signal N_326 : std_logic ;
  signal N_327 : std_logic ;
  signal N_328 : std_logic ;
  signal N_329 : std_logic ;
  signal N_330 : std_logic ;
  signal N_331 : std_logic ;
  signal N_332 : std_logic ;
  signal N_333 : std_logic ;
  signal N_334 : std_logic ;
  signal N_335 : std_logic ;
  signal N_336 : std_logic ;
  signal N_337 : std_logic ;
  signal N_338 : std_logic ;
  signal N_339 : std_logic ;
  signal N_340 : std_logic ;
  signal N_341 : std_logic ;
  signal N_342 : std_logic ;
  signal N_343 : std_logic ;
  signal N_344 : std_logic ;
  signal N_345 : std_logic ;
  signal N_346 : std_logic ;
  signal N_347 : std_logic ;
  signal N_348 : std_logic ;
  signal N_349 : std_logic ;
  signal N_350 : std_logic ;
  signal N_351 : std_logic ;
  signal N_352 : std_logic ;
  signal N_353 : std_logic ;
  signal N_354 : std_logic ;
  signal N_355 : std_logic ;
  signal N_356 : std_logic ;
  signal N_357 : std_logic ;
  signal N_358 : std_logic ;
  signal N_359 : std_logic ;
  signal N_360 : std_logic ;
  signal N_361 : std_logic ;
  signal N_362 : std_logic ;
  signal N_363 : std_logic ;
  signal N_364 : std_logic ;
  signal N_365 : std_logic ;
  signal N_366 : std_logic ;
  signal N_367 : std_logic ;
  signal N_368 : std_logic ;
  signal N_369 : std_logic ;
  signal N_370 : std_logic ;
  signal N_371 : std_logic ;
  signal N_372 : std_logic ;
  signal N_373 : std_logic ;
  signal N_374 : std_logic ;
  signal N_375 : std_logic ;
  signal N_376 : std_logic ;
  signal N_377 : std_logic ;
  signal N_378 : std_logic ;
  signal N_379 : std_logic ;
  signal N_380 : std_logic ;
  signal N_381 : std_logic ;
  signal N_382 : std_logic ;
  signal N_383 : std_logic ;
  signal N_384 : std_logic ;
  signal N_385 : std_logic ;
  signal N_386 : std_logic ;
  signal N_387 : std_logic ;
  signal N_388 : std_logic ;
  signal N_389 : std_logic ;
  signal N_390 : std_logic ;
  signal N_391 : std_logic ;
  signal N_392 : std_logic ;
  signal N_393 : std_logic ;
  signal N_394 : std_logic ;
  signal N_395 : std_logic ;
  signal N_396 : std_logic ;
  signal N_397 : std_logic ;
  signal N_398 : std_logic ;
  signal N_399 : std_logic ;
  signal N_400 : std_logic ;
  signal N_401 : std_logic ;
  signal N_402 : std_logic ;
  signal N_403 : std_logic ;
  signal N_404 : std_logic ;
  signal N_405 : std_logic ;
  signal N_406 : std_logic ;
  signal N_407 : std_logic ;
  signal N_408 : std_logic ;
  signal N_409 : std_logic ;
  signal N_410 : std_logic ;
  signal N_411 : std_logic ;
  signal N_412 : std_logic ;
  signal N_413 : std_logic ;
  signal N_414 : std_logic ;
  signal N_415 : std_logic ;
  signal N_416 : std_logic ;
  signal N_417 : std_logic ;
  signal N_418 : std_logic ;
  signal N_419 : std_logic ;
  signal N_420 : std_logic ;
  signal N_421 : std_logic ;
  signal N_422 : std_logic ;
  signal N_423 : std_logic ;
  signal N_424 : std_logic ;
  signal N_425 : std_logic ;
  signal N_426 : std_logic ;
  signal N_427 : std_logic ;
  signal N_0 : std_logic ;
  signal N_1_0 : std_logic ;
  signal N_2_0 : std_logic ;
  signal N_3_0 : std_logic ;
  signal N_4_0 : std_logic ;
  signal N_5_0 : std_logic ;
  signal N_6_0 : std_logic ;
  signal N_7_0 : std_logic ;
  signal N_8_0 : std_logic ;
  signal N_9_0 : std_logic ;
  signal N_10_0 : std_logic ;
  signal N_11_0 : std_logic ;
  signal N_12_0 : std_logic ;
  signal N_13_0 : std_logic ;
  signal N_14_0 : std_logic ;
  signal N_15_0 : std_logic ;
  signal N_16_0 : std_logic ;
  signal N_17_0 : std_logic ;
  signal N_18_0 : std_logic ;
  signal N_19_0 : std_logic ;
  signal N_20_0 : std_logic ;
  signal N_21_0 : std_logic ;
  signal N_22_0 : std_logic ;
  signal N_23_0 : std_logic ;
  signal N_24_0 : std_logic ;
  signal N_25_0 : std_logic ;
  signal N_26_0 : std_logic ;
  signal N_27_0 : std_logic ;
  signal N_28_0 : std_logic ;
  signal N_29_0 : std_logic ;
  signal N_30_0 : std_logic ;
  signal N_31_0 : std_logic ;
  signal N_32_0 : std_logic ;
  signal N_33_0 : std_logic ;
  signal N_34_0 : std_logic ;
  signal N_35_0 : std_logic ;
  signal N_36_0 : std_logic ;
  signal N_37_0 : std_logic ;
  signal N_38_0 : std_logic ;
  signal N_39_0 : std_logic ;
  signal N_40_0 : std_logic ;
  signal N_41_0 : std_logic ;
  signal N_42_0 : std_logic ;
  signal N_43_0 : std_logic ;
  signal N_44_0 : std_logic ;
  signal N_45_0 : std_logic ;
  signal N_46_0 : std_logic ;
  signal N_47_0 : std_logic ;
  signal N_48_0 : std_logic ;
  signal N_49_0 : std_logic ;
  signal N_50_0 : std_logic ;
  signal N_51_0 : std_logic ;
  signal N_52_0 : std_logic ;
  signal N_53_0 : std_logic ;
  signal N_54_0 : std_logic ;
  signal N_55_0 : std_logic ;
  signal N_56_0 : std_logic ;
  signal N_57_0 : std_logic ;
  signal N_58_0 : std_logic ;
  signal N_59_0 : std_logic ;
  signal N_60_0 : std_logic ;
  signal N_61_0 : std_logic ;
  signal N_62_0 : std_logic ;
  signal N_63_0 : std_logic ;
  signal N_64_0 : std_logic ;
  signal N_65_0 : std_logic ;
  signal N_66_0 : std_logic ;
  signal N_67_0 : std_logic ;
  signal N_68_0 : std_logic ;
  signal N_69_0 : std_logic ;
  signal N_70_0 : std_logic ;
  signal N_71_0 : std_logic ;
  signal N_72_0 : std_logic ;
  signal N_73_0 : std_logic ;
  signal N_74_0 : std_logic ;
  signal N_75_0 : std_logic ;
  signal N_76_0 : std_logic ;
  signal N_77_0 : std_logic ;
  signal N_78_0 : std_logic ;
  signal N_79_0 : std_logic ;
  signal N_80_0 : std_logic ;
  signal N_81_0 : std_logic ;
  signal N_82_0 : std_logic ;
  signal N_83_0 : std_logic ;
  signal N_84_0 : std_logic ;
  signal N_85_0 : std_logic ;
  signal N_86_0 : std_logic ;
  signal N_87_0 : std_logic ;
  signal N_88_0 : std_logic ;
  signal N_89_0 : std_logic ;
  signal N_90_0 : std_logic ;
  signal N_91_0 : std_logic ;
  signal N_92_0 : std_logic ;
  signal N_93_0 : std_logic ;
  signal N_94_0 : std_logic ;
  signal N_95_0 : std_logic ;
  signal N_96_0 : std_logic ;
  signal N_97_0 : std_logic ;
  signal N_98_0 : std_logic ;
  signal N_99_0 : std_logic ;
  signal N_100_0 : std_logic ;
  signal N_101_0 : std_logic ;
  signal N_102_0 : std_logic ;
  signal N_103_0 : std_logic ;
  signal N_104_0 : std_logic ;
  signal N_105_0 : std_logic ;
  signal N_106_0 : std_logic ;
  signal N_107_0 : std_logic ;
  signal N_108_0 : std_logic ;
  signal N_109_0 : std_logic ;
  signal N_110_0 : std_logic ;
  signal N_111_0 : std_logic ;
  signal N_112_0 : std_logic ;
  signal N_113_0 : std_logic ;
  signal N_114_0 : std_logic ;
  signal N_115_0 : std_logic ;
  signal N_116_0 : std_logic ;
  signal N_117_0 : std_logic ;
  signal N_118_0 : std_logic ;
  signal N_119_0 : std_logic ;
  signal N_120_0 : std_logic ;
  signal N_121_0 : std_logic ;
  signal N_122_0 : std_logic ;
  signal N_123_0 : std_logic ;
  signal N_124_0 : std_logic ;
  signal N_125_0 : std_logic ;
  signal N_126_0 : std_logic ;
  signal N_127_0 : std_logic ;
  signal N_128_0 : std_logic ;
  signal N_129_0 : std_logic ;
  signal N_130_0 : std_logic ;
  signal N_131_0 : std_logic ;
  signal N_132_0 : std_logic ;
  signal N_133_0 : std_logic ;
  signal N_134_0 : std_logic ;
  signal N_135_0 : std_logic ;
  signal N_136_0 : std_logic ;
  signal N_137_0 : std_logic ;
  signal N_138_0 : std_logic ;
  signal N_139_0 : std_logic ;
  signal N_140_0 : std_logic ;
  signal N_141_0 : std_logic ;
  signal N_142_0 : std_logic ;
  signal N_143_0 : std_logic ;
  signal N_144_0 : std_logic ;
  signal N_145_0 : std_logic ;
  signal N_146_0 : std_logic ;
  signal N_147_0 : std_logic ;
  signal N_148_0 : std_logic ;
  signal N_149_0 : std_logic ;
  signal N_150_0 : std_logic ;
  signal N_151_0 : std_logic ;
  signal N_152_0 : std_logic ;
  signal N_153_0 : std_logic ;
  signal N_154_0 : std_logic ;
  signal N_155_0 : std_logic ;
  signal N_156_0 : std_logic ;
  signal N_157_0 : std_logic ;
  signal N_158_0 : std_logic ;
  signal N_159_0 : std_logic ;
  signal N_160_0 : std_logic ;
  signal N_161_0 : std_logic ;
  signal N_162_0 : std_logic ;
  signal N_163_0 : std_logic ;
  signal N_592 : std_logic ;
  signal N_593 : std_logic ;
  signal N_594 : std_logic ;
  signal N_595 : std_logic ;
  signal N_596 : std_logic ;
  signal N_597 : std_logic ;
  signal N_598 : std_logic ;
  signal N_599 : std_logic ;
  signal N_600 : std_logic ;
  signal N_601 : std_logic ;
  signal N_602 : std_logic ;
  signal N_603 : std_logic ;
  signal N_604 : std_logic ;
  signal N_605 : std_logic ;
  signal N_606 : std_logic ;
  signal N_607 : std_logic ;
  signal N_608 : std_logic ;
  signal N_609 : std_logic ;
  signal N_610 : std_logic ;
  signal N_611 : std_logic ;
  signal N_612 : std_logic ;
  signal N_613 : std_logic ;
  signal N_614 : std_logic ;
  signal N_615 : std_logic ;
  signal N_616 : std_logic ;
  signal N_617 : std_logic ;
  signal N_618 : std_logic ;
  signal N_619 : std_logic ;
  signal N_620 : std_logic ;
  signal N_621 : std_logic ;
  signal N_622 : std_logic ;
  signal N_623 : std_logic ;
  signal N_624 : std_logic ;
  signal N_625 : std_logic ;
  signal N_626 : std_logic ;
  signal N_627 : std_logic ;
  signal N_628 : std_logic ;
  signal N_629 : std_logic ;
  signal N_630 : std_logic ;
  signal N_631 : std_logic ;
  signal N_632 : std_logic ;
  signal N_633 : std_logic ;
  signal N_634 : std_logic ;
  signal N_635 : std_logic ;
  signal N_636 : std_logic ;
  signal N_637 : std_logic ;
  signal N_638 : std_logic ;
  signal N_639 : std_logic ;
  signal N_640 : std_logic ;
  signal N_641 : std_logic ;
  signal N_642 : std_logic ;
  signal N_643 : std_logic ;
  signal N_644 : std_logic ;
  signal N_645 : std_logic ;
  signal N_646 : std_logic ;
  signal N_647 : std_logic ;
  signal N_648 : std_logic ;
  signal N_649 : std_logic ;
  signal N_650 : std_logic ;
  signal N_651 : std_logic ;
  signal N_652 : std_logic ;
  signal N_653 : std_logic ;
  signal N_654 : std_logic ;
  signal N_655 : std_logic ;
  signal N_656 : std_logic ;
  signal N_657 : std_logic ;
  signal N_658 : std_logic ;
  signal N_659 : std_logic ;
  signal N_660 : std_logic ;
  signal N_661 : std_logic ;
  signal N_662 : std_logic ;
  signal N_663 : std_logic ;
  signal N_664 : std_logic ;
  signal N_665 : std_logic ;
  signal N_666 : std_logic ;
  signal N_667 : std_logic ;
  signal N_668 : std_logic ;
  signal N_669 : std_logic ;
  signal N_670 : std_logic ;
  signal N_671 : std_logic ;
  signal N_672 : std_logic ;
  signal N_673 : std_logic ;
  signal N_674 : std_logic ;
  signal N_675 : std_logic ;
  signal N_676 : std_logic ;
  signal N_677 : std_logic ;
  signal N_678 : std_logic ;
  signal N_679 : std_logic ;
  signal N_680 : std_logic ;
  signal N_681 : std_logic ;
  signal N_682 : std_logic ;
  signal N_683 : std_logic ;
  signal N_684 : std_logic ;
  signal N_685 : std_logic ;
  signal N_686 : std_logic ;
  signal N_687 : std_logic ;
  signal N_688 : std_logic ;
  signal N_689 : std_logic ;
  signal N_690 : std_logic ;
  signal N_691 : std_logic ;
  signal N_692 : std_logic ;
  signal N_693 : std_logic ;
  signal N_694 : std_logic ;
  signal N_695 : std_logic ;
  signal N_696 : std_logic ;
  signal N_697 : std_logic ;
  signal N_698 : std_logic ;
  signal N_699 : std_logic ;
  signal N_700 : std_logic ;
  signal N_701 : std_logic ;
  signal N_702 : std_logic ;
  signal N_703 : std_logic ;
  signal N_704 : std_logic ;
  signal N_705 : std_logic ;
  signal N_706 : std_logic ;
  signal N_707 : std_logic ;
  signal N_708 : std_logic ;
  signal N_709 : std_logic ;
  signal N_710 : std_logic ;
  signal N_711 : std_logic ;
  signal N_712 : std_logic ;
  signal N_713 : std_logic ;
  signal N_714 : std_logic ;
  signal N_715 : std_logic ;
  signal N_716 : std_logic ;
  signal N_717 : std_logic ;
  signal N_718 : std_logic ;
  signal N_719 : std_logic ;
  signal N_1_I : std_logic ;
  signal \GRLFPC20.V.STATE_0_SQMUXA_1_X_I\ : std_logic ;
  signal \GRLFPC20.V.I.EXEC_0_SQMUXA_I\ : std_logic ;
  signal \GRLFPC20.R.A.AFQ_I\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_SN_M4_I\ : std_logic ;
  signal \GRLFPC20.FPI.LDOP_I\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_SN_M3_1_I\ : std_logic ;
  signal \GRLFPC20.COMB.UN2_HOLDN_I\ : std_logic ;
  signal CPO_EXCZ : std_logic ;
  signal CPO_CCVZ : std_logic ;
  signal CPO_LDLOCKZ : std_logic ;
  signal CPO_HOLDNZ : std_logic ;
  signal RFI1_REN1Z : std_logic ;
  signal RFI1_REN2Z : std_logic ;
  signal RFI1_WRENZ : std_logic ;
  signal RFI2_REN1Z : std_logic ;
  signal RFI2_REN2Z : std_logic ;
  signal RFI2_WRENZ : std_logic ;
begin
GND <= '0';
VCC <= '1';
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_CTRLXERSHFT_MIXOIN_3_RNID87_20_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "cin",
    lut_mask => "0000000010101010")
port map (
cout => N_19306,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.CTRLXERSHFT.MIXOIN_3\(20));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_14_TRFWWBASICCELL_TEMP2_RNIMEBFA_0: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "cin",
    lut_mask => "1111000011110000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(98),
cin => N_19305);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_CTRLXERSHFT_MIXOIN_3_RNILF6_19_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "cin",
    lut_mask => "0000000010101010")
port map (
cout => N_19304,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.CTRLXERSHFT.MIXOIN_3\(19));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_13_TRFWWBASICCELL_TEMP2_1_RNIN1F1A_0: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "cin",
    lut_mask => "1111000011110000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(99),
cin => N_19303);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_CTRLXERSHFT_MIXOIN_3_RNIKE6_18_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "cin",
    lut_mask => "0000000010101010")
port map (
cout => N_19302,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.CTRLXERSHFT.MIXOIN_3\(18));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_12_TRFWWBASICCELL_TEMP2_1_RNIF46C9_0: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "cin",
    lut_mask => "1111000011110000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(100),
cin => N_19301);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_CTRLXERSHFT_MIXOIN_3_RNIJD6_17_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "cin",
    lut_mask => "0000000010101010")
port map (
cout => N_19300,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.CTRLXERSHFT.MIXOIN_3\(17));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_11_TRFWWBASICCELL_TEMP2_RNI4J5P8_0: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "cin",
    lut_mask => "1111000011110000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(101),
cin => N_19299);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_CTRLXERSHFT_MIXOIN_3_RNIIC6_16_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "cin",
    lut_mask => "0000000010101010")
port map (
cout => N_19298,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.CTRLXERSHFT.MIXOIN_3\(16));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_10_TRFWWBASICCELL_TEMP2_RNINUSR8_0: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "cin",
    lut_mask => "1111000011110000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(102),
cin => N_19297);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_CTRLXERSHFT_MIXOIN_3_RNIHB6_15_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "cin",
    lut_mask => "0000000010101010")
port map (
cout => N_19296,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.CTRLXERSHFT.MIXOIN_3\(15));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_9_TRFWWBASICCELL_TEMP2_RNIV9EK8_0: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "cin",
    lut_mask => "1111000011110000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(103),
cin => N_19295);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_CTRLXERSHFT_MIXOIN_3_RNIGA6_14_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "cin",
    lut_mask => "0000000010101010")
port map (
cout => N_19294,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.CTRLXERSHFT.MIXOIN_3\(14));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_8_TRFWWBASICCELL_TEMP2_1_RNIB5F09_0: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "cin",
    lut_mask => "1111000011110000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(104),
cin => N_19293);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_CTRLXERSHFT_MIXOIN_3_RNIF96_13_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "cin",
    lut_mask => "0000000010101010")
port map (
cout => N_19292,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.CTRLXERSHFT.MIXOIN_3\(13));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_7_TRFWWBASICCELL_TEMP2_RNIMGO99_0: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "cin",
    lut_mask => "1111000011110000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(105),
cin => N_19291);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_CTRLXERSHFT_MIXOIN_3_RNIE86_12_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "cin",
    lut_mask => "0000000010101010")
port map (
cout => N_19290,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.CTRLXERSHFT.MIXOIN_3\(12));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_6_TRFWWBASICCELL_TEMP2_1_RNI6C739_0: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "cin",
    lut_mask => "1111000011110000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(106),
cin => N_19289);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_CTRLXERSHFT_MIXOIN_3_RNID76_11_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "cin",
    lut_mask => "0000000010101010")
port map (
cout => N_19288,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.CTRLXERSHFT.MIXOIN_3\(11));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_5_TRFWWBASICCELL_TEMP2_2_RNIR4PF8_0: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "cin",
    lut_mask => "1111000011110000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(107),
cin => N_19287);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_CTRLXERSHFT_MIXOIN_3_RNIC66_10_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "cin",
    lut_mask => "0000000010101010")
port map (
cout => N_19286,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.CTRLXERSHFT.MIXOIN_3\(10));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_4_TRFWWBASICCELL_TEMP2_RNIIBQE8_0: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "cin",
    lut_mask => "1111000011110000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(108),
cin => N_19285);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_CTRLXERSHFT_MIXOIN_3_RNI4UHE_9_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "cin",
    lut_mask => "0000000010101010")
port map (
cout => N_19284,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.CTRLXERSHFT.MIXOIN_3\(9));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_3_TRFWWBASICCELL_TEMP2_2_RNIBESB8_0: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "cin",
    lut_mask => "1111000011110000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(109),
cin => N_19283);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_CTRLXERSHFT_MIXOIN_3_RNI3THE_8_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "cin",
    lut_mask => "0000000010101010")
port map (
cout => N_19282,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.CTRLXERSHFT.MIXOIN_3\(8));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_2_TRFWWBASICCELL_TEMP2_RNIV6LT8_0: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "cin",
    lut_mask => "1111000011110000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(110),
cin => N_19281);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_CTRLXERSHFT_MIXOIN_3_RNI2SHE_7_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "cin",
    lut_mask => "0000000010101010")
port map (
cout => N_19280,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.CTRLXERSHFT.MIXOIN_3\(7));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_1_TRFWWBASICCELL_TEMP2_3_RNIS0B5A_0: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "cin",
    lut_mask => "1111000011110000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(111),
cin => N_19279);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_CTRLXERSHFT_MIXOIN_3_RNI1RHE_6_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "cin",
    lut_mask => "0000000010101010")
port map (
cout => N_19278,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.CTRLXERSHFT.MIXOIN_3\(6));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_0_TRFWWBASICCELL_TEMP2_2_RNIHPCSA_0: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "cin",
    lut_mask => "1111000011110000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(112),
cin => N_19277);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_CTRLXERSHFT_MIXOIN_3_RNIJF8_35_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "cin",
    lut_mask => "0000000010101010")
port map (
cout => N_19276,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.CTRLXERSHFT.MIXOIN_3\(35));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_29_TRFWWBASICCELL_TEMP2_RNI19488_0: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "cin",
    lut_mask => "1111000011110000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(83),
cin => N_19275);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_CTRLXERSHFT_MIXOIN_3_RNIIE8_34_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "cin",
    lut_mask => "0000000010101010")
port map (
cout => N_19274,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.CTRLXERSHFT.MIXOIN_3\(34));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_28_TRFWWBASICCELL_TEMP2_3_RNIUDDV8_0: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "cin",
    lut_mask => "1111000011110000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(84),
cin => N_19273);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_CTRLXERSHFT_MIXOIN_3_RNIHD8_33_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "cin",
    lut_mask => "0000000010101010")
port map (
cout => N_19272,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.CTRLXERSHFT.MIXOIN_3\(33));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_27_TRFWWBASICCELL_TEMP2_RNIED6P8_0: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "cin",
    lut_mask => "1111000011110000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(85),
cin => N_19271);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_CTRLXERSHFT_MIXOIN_3_RNIGC8_32_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "cin",
    lut_mask => "0000000010101010")
port map (
cout => N_19270,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.CTRLXERSHFT.MIXOIN_3\(32));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_26_TRFWWBASICCELL_TEMP2_RNIBDC59_0: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "cin",
    lut_mask => "1111000011110000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(86),
cin => N_19269);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_CTRLXERSHFT_MIXOIN_3_RNIFB8_31_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "cin",
    lut_mask => "0000000010101010")
port map (
cout => N_19268,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.CTRLXERSHFT.MIXOIN_3\(31));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_25_TRFWWBASICCELL_TEMP2_RNIK7719_0: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "cin",
    lut_mask => "1111000011110000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(87),
cin => N_19267);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_CTRLXERSHFT_MIXOIN_3_RNIEA8_30_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "cin",
    lut_mask => "0000000010101010")
port map (
cout => N_19266,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.CTRLXERSHFT.MIXOIN_3\(30));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_24_TRFWWBASICCELL_TEMP2_2_RNITT8G9_0: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "cin",
    lut_mask => "1111000011110000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(88),
cin => N_19265);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_CTRLXERSHFT_MIXOIN_3_RNIMH7_29_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "cin",
    lut_mask => "0000000010101010")
port map (
cout => N_19264,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.CTRLXERSHFT.MIXOIN_3\(29));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_23_TRFWWBASICCELL_TEMP2_1_RNIIIT0A_0: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "cin",
    lut_mask => "1111000011110000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(89),
cin => N_19263);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_CTRLXERSHFT_MIXOIN_3_RNILG7_28_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "cin",
    lut_mask => "0000000010101010")
port map (
cout => N_19262,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.CTRLXERSHFT.MIXOIN_3\(28));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_22_TRFWWBASICCELL_TEMP2_RNISAPE9_0: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "cin",
    lut_mask => "1111000011110000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(90),
cin => N_19261);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_CTRLXERSHFT_MIXOIN_3_RNIKF7_27_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "cin",
    lut_mask => "0000000010101010")
port map (
cout => N_19260,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.CTRLXERSHFT.MIXOIN_3\(27));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_21_TRFWWBASICCELL_TEMP2_3_RNI7TJD9_0: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "cin",
    lut_mask => "1111000011110000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(91),
cin => N_19259);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_CTRLXERSHFT_MIXOIN_3_RNIJE7_26_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "cin",
    lut_mask => "0000000010101010")
port map (
cout => N_19258,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.CTRLXERSHFT.MIXOIN_3\(26));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_20_TRFWWBASICCELL_TEMP2_RNIKVCQ9_0: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "cin",
    lut_mask => "1111000011110000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(92),
cin => N_19257);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_CTRLXERSHFT_MIXOIN_3_RNIID7_25_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "cin",
    lut_mask => "0000000010101010")
port map (
cout => N_19256,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.CTRLXERSHFT.MIXOIN_3\(25));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_19_TRFWWBASICCELL_TEMP2_1_RNIV0RCA_0: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "cin",
    lut_mask => "1111000011110000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(93),
cin => N_19255);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_CTRLXERSHFT_MIXOIN_3_RNIHC7_24_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "cin",
    lut_mask => "0000000010101010")
port map (
cout => N_19254,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.CTRLXERSHFT.MIXOIN_3\(24));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_18_TRFWWBASICCELL_TEMP2_1_RNIDGMNA_0: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "cin",
    lut_mask => "1111000011110000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(94),
cin => N_19253);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_CTRLXERSHFT_MIXOIN_3_RNIGB7_23_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "cin",
    lut_mask => "0000000010101010")
port map (
cout => N_19252,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.CTRLXERSHFT.MIXOIN_3\(23));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_17_TRFWWBASICCELL_TEMP2_RNI0404A_0: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "cin",
    lut_mask => "1111000011110000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(95),
cin => N_19251);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_CTRLXERSHFT_MIXOIN_3_RNIFA7_22_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "cin",
    lut_mask => "0000000010101010")
port map (
cout => N_19250,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.CTRLXERSHFT.MIXOIN_3\(22));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_16_TRFWWBASICCELL_TEMP2_3_RNIS09P9_0: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "cin",
    lut_mask => "1111000011110000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(96),
cin => N_19249);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_CTRLXERSHFT_MIXOIN_3_RNIE97_21_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "cin",
    lut_mask => "0000000010101010")
port map (
cout => N_19248,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.CTRLXERSHFT.MIXOIN_3\(21));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_15_TRFWWBASICCELL_TEMP2_2_RNIS4ES9_0: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "cin",
    lut_mask => "1111000011110000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(97),
cin => N_19247);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_CTRLXERSHFT_MIXOIN_3_RNIGEA_50_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "cin",
    lut_mask => "0000000010101010")
port map (
cout => N_19246,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.CTRLXERSHFT.MIXOIN_3\(50));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_44_TRFWWBASICCELL_TEMP2_2_RNI1SQT8_0: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "cin",
    lut_mask => "1111000011110000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(68),
cin => N_19245);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_CTRLXERSHFT_MIXOIN_3_RNIOL9_49_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "cin",
    lut_mask => "0000000010101010")
port map (
cout => N_19244,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.CTRLXERSHFT.MIXOIN_3\(49));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_43_TRFWWBASICCELL_TEMP2_3_RNIVTLE9_0: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "cin",
    lut_mask => "1111000011110000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(69),
cin => N_19243);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_CTRLXERSHFT_MIXOIN_3_RNINK9_48_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "cin",
    lut_mask => "0000000010101010")
port map (
cout => N_19242,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.CTRLXERSHFT.MIXOIN_3\(48));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_42_TRFWWBASICCELL_TEMP2_3_RNIC4DV9_0: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "cin",
    lut_mask => "1111000011110000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(70),
cin => N_19241);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_CTRLXERSHFT_MIXOIN_3_RNIMJ9_47_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "cin",
    lut_mask => "0000000010101010")
port map (
cout => N_19240,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.CTRLXERSHFT.MIXOIN_3\(47));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_41_TRFWWBASICCELL_TEMP2_3_RNIPU129_0: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "cin",
    lut_mask => "1111000011110000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(71),
cin => N_19239);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_CTRLXERSHFT_MIXOIN_3_RNILI9_46_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "cin",
    lut_mask => "0000000010101010")
port map (
cout => N_19238,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.CTRLXERSHFT.MIXOIN_3\(46));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_40_TRFWWBASICCELL_TEMP2_3_RNITQ8H8_0: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "cin",
    lut_mask => "1111000011110000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(72),
cin => N_19237);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_CTRLXERSHFT_MIXOIN_3_RNIKH9_45_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "cin",
    lut_mask => "0000000010101010")
port map (
cout => N_19236,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.CTRLXERSHFT.MIXOIN_3\(45));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_39_TRFWWBASICCELL_TEMP2_2_RNI2QIA8_0: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "cin",
    lut_mask => "1111000011110000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(73),
cin => N_19235);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_CTRLXERSHFT_MIXOIN_3_RNIJG9_44_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "cin",
    lut_mask => "0000000010101010")
port map (
cout => N_19234,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.CTRLXERSHFT.MIXOIN_3\(44));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_38_TRFWWBASICCELL_TEMP2_1_RNI4MR69_0: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "cin",
    lut_mask => "1111000011110000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(74),
cin => N_19233);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_CTRLXERSHFT_MIXOIN_3_RNIIF9_43_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "cin",
    lut_mask => "0000000010101010")
port map (
cout => N_19232,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.CTRLXERSHFT.MIXOIN_3\(43));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_37_TRFWWBASICCELL_TEMP2_2_RNIMAHU9_0: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "cin",
    lut_mask => "1111000011110000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(75),
cin => N_19231);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_CTRLXERSHFT_MIXOIN_3_RNIHE9_42_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "cin",
    lut_mask => "0000000010101010")
port map (
cout => N_19230,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.CTRLXERSHFT.MIXOIN_3\(42));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_36_TRFWWBASICCELL_TEMP2_3_RNI4RA0A_0: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "cin",
    lut_mask => "1111000011110000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(76),
cin => N_19229);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_CTRLXERSHFT_MIXOIN_3_RNIGD9_41_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "cin",
    lut_mask => "0000000010101010")
port map (
cout => N_19228,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.CTRLXERSHFT.MIXOIN_3\(41));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_35_TRFWWBASICCELL_TEMP2_1_RNIOGM2A_0: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "cin",
    lut_mask => "1111000011110000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(77),
cin => N_19227);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_CTRLXERSHFT_MIXOIN_3_RNIFC9_40_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "cin",
    lut_mask => "0000000010101010")
port map (
cout => N_19226,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.CTRLXERSHFT.MIXOIN_3\(40));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_34_TRFWWBASICCELL_TEMP2_1_RNIOP1MA_0: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "cin",
    lut_mask => "1111000011110000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(78),
cin => N_19225);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_CTRLXERSHFT_MIXOIN_3_RNINJ8_39_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "cin",
    lut_mask => "0000000010101010")
port map (
cout => N_19224,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.CTRLXERSHFT.MIXOIN_3\(39));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_33_TRFWWBASICCELL_TEMP2_1_RNI5SV2A_0: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "cin",
    lut_mask => "1111000011110000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(79),
cin => N_19223);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_CTRLXERSHFT_MIXOIN_3_RNIMI8_38_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "cin",
    lut_mask => "0000000010101010")
port map (
cout => N_19222,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.CTRLXERSHFT.MIXOIN_3\(38));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_32_TRFWWBASICCELL_TEMP2_3_RNIV0AK9_0: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "cin",
    lut_mask => "1111000011110000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(80),
cin => N_19221);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_CTRLXERSHFT_MIXOIN_3_RNILH8_37_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "cin",
    lut_mask => "0000000010101010")
port map (
cout => N_19220,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.CTRLXERSHFT.MIXOIN_3\(37));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_31_TRFWWBASICCELL_TEMP2_3_RNI86OH8_0: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "cin",
    lut_mask => "1111000011110000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(81),
cin => N_19219);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_CTRLXERSHFT_MIXOIN_3_RNIKG8_36_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "cin",
    lut_mask => "0000000010101010")
port map (
cout => N_19218,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.CTRLXERSHFT.MIXOIN_3\(36));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_30_TRFWWBASICCELL_TEMP2_2_RNI90IR7_0: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "cin",
    lut_mask => "1111000011110000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(82),
cin => N_19217);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_CTRLXERSHFT_MIXOIN_3_RNINLA_57_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "cin",
    lut_mask => "0000000010101010")
port map (
cout => N_19216,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.CTRLXERSHFT.MIXOIN_3\(57));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_51_TRFWWBASICCELL_TEMP2_RNIMIFAC_0: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "cin",
    lut_mask => "1111000011110000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(61),
cin => N_19215);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_CTRLXERSHFT_MIXOIN_3_RNIMKA_56_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "cin",
    lut_mask => "0000000010101010")
port map (
cout => N_19214,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.CTRLXERSHFT.MIXOIN_3\(56));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_50_TRFWWBASICCELL_TEMP2_RNIIMEO9_0: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "cin",
    lut_mask => "1111000011110000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(62),
cin => N_19213);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_CTRLXERSHFT_MIXOIN_3_RNILJA_55_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "cin",
    lut_mask => "0000000010101010")
port map (
cout => N_19212,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.CTRLXERSHFT.MIXOIN_3\(55));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_49_TRFWWBASICCELL_TEMP2_3_RNI067S8_0: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "cin",
    lut_mask => "1111000011110000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(63),
cin => N_19211);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_CTRLXERSHFT_MIXOIN_3_RNIKIA_54_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "cin",
    lut_mask => "0000000010101010")
port map (
cout => N_19210,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.CTRLXERSHFT.MIXOIN_3\(54));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_48_TRFWWBASICCELL_TEMP2_3_RNIOAK3A_0: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "cin",
    lut_mask => "1111000011110000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(64),
cin => N_19209);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_CTRLXERSHFT_MIXOIN_3_RNIJHA_53_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "cin",
    lut_mask => "0000000010101010")
port map (
cout => N_19208,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.CTRLXERSHFT.MIXOIN_3\(53));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_47_TRFWWBASICCELL_TEMP2_3_RNICTUGA_0: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "cin",
    lut_mask => "1111000011110000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(65),
cin => N_19207);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_CTRLXERSHFT_MIXOIN_3_RNIIGA_52_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "cin",
    lut_mask => "0000000010101010")
port map (
cout => N_19206,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.CTRLXERSHFT.MIXOIN_3\(52));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_46_TRFWWBASICCELL_TEMP2_2_RNI92KV9_0: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "cin",
    lut_mask => "1111000011110000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(66),
cin => N_19205);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_CTRLXERSHFT_MIXOIN_3_RNIHFA_51_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "cin",
    lut_mask => "0000000010101010")
port map (
cout => N_19204,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.CTRLXERSHFT.MIXOIN_3\(51));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_45_TRFWWBASICCELL_TEMP2_1_RNIOH979_0: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "cin",
    lut_mask => "1111000011110000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(67),
cin => N_19203);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUE_ADD0_START: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "cin",
    lut_mask => "0000000010101010")
port map (
cout => N_19202,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.MIXOIN\(0));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUF_ADD0_START: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "cin",
    lut_mask => "0000000010101010")
port map (
cout => N_19201,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN8_TEMP_U\(0));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_GRFPUE_ADD0_START: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "cin",
    lut_mask => "0000000010101010")
port map (
cout => N_19200,
dataa => VCC);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_LEFTSHIFTERBL_SLCONTROL_REP2_2_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000100000001101")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL_REP2\(2),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(31),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL_1\(2),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL_SN_M3\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.NORMDETECT.NOTSLFROMNORM_17_3_0_.M4\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_LEFTSHIFTERBL_SLCONTROL_REP1_2_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000100000001101")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL_REP1\(2),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(31),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL_1\(2),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL_SN_M3\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.NORMDETECT.NOTSLFROMNORM_17_3_0_.M4\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_246_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010111100100000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH\(246),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(246),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.EXPBREGLOADEN\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_SN_M3\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_2\(246));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_247_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0100111101000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH\(247),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(11),
datab => \GRLFPC20.FPI.OP1_X\(62),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_SN_M3\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_2\(247));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_248_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0100111101000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH\(248),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(11),
datab => \GRLFPC20.FPI.OP1_X\(61),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_SN_M3\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_2\(248));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_245_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010001011110000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH\(245),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(245),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.EXPBREGLOADEN\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_2\(245),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_SN_M3\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_249_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0100010011110000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH\(249),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(11),
datab => \GRLFPC20.FPI.OP1_X\(60),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_2\(249),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_SN_M3\);
\RETGRLFPC20_GRFPUL_GEN0_GRLFPU0_C_PXS_PCTRL_NEW_12_32_75_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1110111011101110")
port map (
combout => N_19149,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.PCTRL_NEW_12_32_0\(75),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.PCTRL_NEW_12_31\(75));
\RETGRLFPC20_GRFPUL_GEN0_GRLFPU0_C_SXC_SCTRL_NEW_10_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1100000011000101")
port map (
combout => N_19148,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(65),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(11),
datac => \GRLFPC20.FPI.LDOP\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SXC.SCTRL_NEW_A\(10));
\RETGRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_MUX_15_49_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1110010011100100")
port map (
combout => N_19147,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(78),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_MUX_7\(49),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_MUX_14\(49));
\RETGRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_MUX_15_51_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => N_19146,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(78),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_MUX_14\(51),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_MUX_7\(51));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_MUX_7_RNIBJRV_33_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1110010011100100")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_MUX_15\(33),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(78),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_MUX_7\(33),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_MUX_14\(33));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_MUX_7_RNI9HRV_32_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1110010011100100")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_MUX_15\(32),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(78),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_MUX_7\(32),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_MUX_14\(32));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_EXPADDERSHFT_EXPYBUS_2_6_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.EXPYBUS_2_RETI\(6),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_MUX_15\(33),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_MUX_15\(32));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_MUX_7_RNI7FRV_31_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_MUX_15\(31),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(78),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_MUX_14\(31),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_MUX_7\(31));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_MUX_7_RNI5DRV_30_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_MUX_15\(30),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(78),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_MUX_14\(30),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_MUX_7\(30));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_LEFTSHIFTERBL_UN20_NOTSLRES: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0100010001000100")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.UN20_NOTSLRES_RETI\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_MUX_15\(30),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_MUX_15\(31));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_UN13_NOTXZYFROMD_REP1: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN13_NOTXZYFROMD_REP1_RETI\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_MUX_15\(51),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_MUX_15\(49));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_UN13_NOTXZYFROMD: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN13_NOTXZYFROMD_RETI\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_MUX_15\(51),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_MUX_15\(49));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_MUX_7_RNIBNVV_51_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_MUX_15\(51),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(78),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_MUX_14\(51),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_MUX_7\(51));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_MUX_7_RNIP3UV_49_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1110010011100100")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_MUX_15\(49),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(78),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_MUX_7\(49),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_MUX_14\(49));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_UN13_NOTXZYFROMD_REP2: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN13_NOTXZYFROMD_REP2_RETI\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_MUX_15\(51),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_MUX_15\(49));
\GRLFPC20_R_FSR_CEXC_RNO_4_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010110010101100")
port map (
combout => \GRLFPC20.COMB.V.FSR.CEXC_1\(4),
dataa => \GRLFPC20.COMB.V.FSR.CEXC_1_2\(4),
datab => \GRLFPC20.COMB.V.FSR.CEXC_1_1_X\(4),
datac => \GRLFPC20.COMB.V.FSR.CEXC_1_SN_M3\);
\GRLFPC20_R_FSR_CEXC_RNO_3_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010110010101100")
port map (
combout => \GRLFPC20.COMB.V.FSR.CEXC_1\(3),
dataa => \GRLFPC20.COMB.V.FSR.CEXC_1_2\(3),
datab => \GRLFPC20.COMB.V.FSR.CEXC_1_1_X\(3),
datac => \GRLFPC20.COMB.V.FSR.CEXC_1_SN_M3\);
\GRLFPC20_R_FSR_CEXC_RNO_2_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010110010101100")
port map (
combout => \GRLFPC20.COMB.V.FSR.CEXC_1\(2),
dataa => \GRLFPC20.COMB.V.FSR.CEXC_1_2\(2),
datab => \GRLFPC20.COMB.V.FSR.CEXC_1_1_X\(2),
datac => \GRLFPC20.COMB.V.FSR.CEXC_1_SN_M3\);
\GRLFPC20_R_FSR_CEXC_RNO_1_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010110010101100")
port map (
combout => \GRLFPC20.COMB.V.FSR.CEXC_1\(1),
dataa => \GRLFPC20.COMB.V.FSR.CEXC_1_2\(1),
datab => \GRLFPC20.COMB.V.FSR.CEXC_1_1_X\(1),
datac => \GRLFPC20.COMB.V.FSR.CEXC_1_SN_M3\);
\GRLFPC20_R_FSR_CEXC_RNO_0_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010110010101100")
port map (
combout => \GRLFPC20.COMB.V.FSR.CEXC_1\(0),
dataa => \GRLFPC20.COMB.V.FSR.CEXC_1_2\(0),
datab => \GRLFPC20.COMB.V.FSR.CEXC_1_1_X\(0),
datac => \GRLFPC20.COMB.V.FSR.CEXC_1_SN_M3\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_237_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1100101011001010")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH\(237),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(3),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_2\(237),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_SN_M3_0_I\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_238_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1100101011001010")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH\(238),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(4),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_2\(238),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_SN_M3_0_I\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_239_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1100101011001010")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH\(239),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(5),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_2\(239),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_SN_M3_0_I\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_240_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1100101011001010")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH\(240),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(6),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_2\(240),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_SN_M3_0_I\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_241_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1100101011001010")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH\(241),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(7),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_2\(241),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_SN_M3_0_I\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_242_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1100101011001010")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH\(242),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(8),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_2\(242),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_SN_M3_0_I\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_243_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1100101011001010")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH\(243),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(9),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_2\(243),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_SN_M3_0_I\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_244_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1100101011001010")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH\(244),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(10),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_2\(244),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_SN_M3_0_I\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_257_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010110010101100")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH\(257),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_41\(257),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_2\(257),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_SN_M3\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_256_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010110010101100")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH\(256),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_41\(256),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_2\(256),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_SN_M3\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_255_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010110010101100")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH\(255),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_41\(255),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_2\(255),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_SN_M3\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_254_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010110010101100")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH\(254),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_41\(254),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_2\(254),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_SN_M3\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_253_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010110010101100")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH\(253),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_41\(253),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_2\(253),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_SN_M3\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_252_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010110010101100")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH\(252),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_41\(252),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_2\(252),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_SN_M3\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_251_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010110010101100")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH\(251),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_41\(251),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_2\(251),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_SN_M3\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_250_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010110010101100")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH\(250),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_41\(250),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_2\(250),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_SN_M3\);
\GRLFPC20_R_I_RES_RNO_63_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1110010011100100")
port map (
combout => \GRLFPC20.COMB.V.I.RES_1\(63),
dataa => \GRLFPC20.COMB.UN2_HOLDN\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.SIGNRESULT\,
datac => \GRLFPC20.COMB.V.I.RES_6_X\(63));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_M2S2_REP1: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1111111100000010")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_M2S2_REP1\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.DPATH_M2_0_0\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.WQSCTRL_1_0\(67),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.DPATH_M2_E\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.DPATH_M2_REP1\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_UN25_NOTXZYFROMD_RNIIJIB1_0: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0100010001000100")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_M2_7_REP1\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN25_NOTXZYFROMD\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_M1_0\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_UN15_NOTXZYFROMD_0_REP2: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000111110001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN15_NOTXZYFROMD_0_REP2\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(375),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(9),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(1),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(16));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_UN15_NOTXZYFROMD_0_REP1: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000111110001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN15_NOTXZYFROMD_0_REP1\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(375),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(9),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(1),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(16));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_XZBREGLOADEN_REP1: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000000000001110")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.XZBREGLOADEN_REP1\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(3),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(4),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.WQSCTRL_1_0\(67),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.DPATH_M2_E\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_UN3_NOTXZYFROMD_RNIUMVM_0: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000000000000100")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_M2_REP1\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN13_NOTXZYFROMD_REP2\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN25_NOTXZYFROMD\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN15_NOTXZYFROMD_0_REP2\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN3_NOTXZYFROMD\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_WQSCTRL_RNILHL93_68_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000101000000010")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.DPATH_M2_REP1\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.DPATH_M2_0_2\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.WQSCTRL\(68),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.WQSCTRL_1_0\(67),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_ADD57\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_4_57_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1001100000010000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_4\(57),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(6),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(7),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_ADD0\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_0_315__G3\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_MUX_14_48_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0001000000000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_MUX_14\(48),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(80),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(81),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_3_0__ROM_33\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_MULLSBLOGIC_STCKYPAIR_UN36_STKGEN_RNIJT6FH: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010011111110111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_0_315__G3_S\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULLSBLOGIC.STCKYPAIR.UN22_NOTPROP\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.2.CI_56_SUM4\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN2_MIXOIN_19_U\(0),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULLSBLOGIC.STCKYPAIR.UN36_STKGEN\);
\GRLFPC20_COMB_RS1_1_0_X_3_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1011100010111000")
port map (
combout => \GRLFPC20.COMB.RS1_1_0_X\(3),
dataa => N_60,
datab => N_3,
datac => \GRLFPC20.R.A.RS1\(3));
\GRLFPC20_COMB_RS1_1_0_X_4_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1011100010111000")
port map (
combout => \GRLFPC20.COMB.RS1_1_0_X\(4),
dataa => N_61,
datab => N_3,
datac => \GRLFPC20.R.A.RS1\(4));
\GRLFPC20_COMB_WRDATA_4_X_14_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.COMB.WRDATA_4_X\(14),
dataa => \GRLFPC20.COMB.RDD_2\,
datab => \GRLFPC20.R.I.RES\(14),
datac => \GRLFPC20.R.I.RES\(43));
\GRLFPC20_COMB_WRDATA_4_X_46_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.COMB.WRDATA_4_X\(46),
dataa => \GRLFPC20.COMB.RDD_2\,
datab => \GRLFPC20.R.I.RES\(46),
datac => \GRLFPC20.R.I.RES\(43));
\GRLFPC20_COMB_DBGDATA_4_0_X_10_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.COMB.DBGDATA_4_0_X\(10),
dataa => N_391,
datab => N_666,
datac => N_602);
\GRLFPC20_COMB_WRDATA_4_X_2_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.COMB.WRDATA_4_X\(2),
dataa => \GRLFPC20.COMB.RDD_2\,
datab => \GRLFPC20.R.I.RES\(2),
datac => \GRLFPC20.R.I.RES\(31));
\GRLFPC20_COMB_WRDATA_4_X_11_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.COMB.WRDATA_4_X\(11),
dataa => \GRLFPC20.COMB.RDD_2\,
datab => \GRLFPC20.R.I.RES\(11),
datac => \GRLFPC20.R.I.RES\(40));
\GRLFPC20_COMB_WRDATA_4_X_13_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.COMB.WRDATA_4_X\(13),
dataa => \GRLFPC20.COMB.RDD_2\,
datab => \GRLFPC20.R.I.RES\(13),
datac => \GRLFPC20.R.I.RES\(42));
\GRLFPC20_COMB_WRDATA_4_X_17_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.COMB.WRDATA_4_X\(17),
dataa => \GRLFPC20.COMB.RDD_2\,
datab => \GRLFPC20.R.I.RES\(17),
datac => \GRLFPC20.R.I.RES\(46));
\GRLFPC20_COMB_WRDATA_4_X_27_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.COMB.WRDATA_4_X\(27),
dataa => \GRLFPC20.COMB.RDD_2\,
datab => \GRLFPC20.R.I.RES\(27),
datac => \GRLFPC20.R.I.RES\(56));
\GRLFPC20_COMB_WRDATA_4_X_29_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.COMB.WRDATA_4_X\(29),
dataa => \GRLFPC20.COMB.RDD_2\,
datab => \GRLFPC20.R.I.RES\(29),
datac => \GRLFPC20.R.I.RES\(58));
\GRLFPC20_COMB_WRDATA_4_X_34_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.COMB.WRDATA_4_X\(34),
dataa => \GRLFPC20.COMB.RDD_2\,
datab => \GRLFPC20.R.I.RES\(34),
datac => \GRLFPC20.R.I.RES\(31));
\GRLFPC20_COMB_WRDATA_4_X_43_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.COMB.WRDATA_4_X\(43),
dataa => \GRLFPC20.COMB.RDD_2\,
datab => \GRLFPC20.R.I.RES\(43),
datac => \GRLFPC20.R.I.RES\(40));
\GRLFPC20_COMB_WRDATA_4_X_45_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.COMB.WRDATA_4_X\(45),
dataa => \GRLFPC20.COMB.RDD_2\,
datab => \GRLFPC20.R.I.RES\(45),
datac => \GRLFPC20.R.I.RES\(42));
\GRLFPC20_COMB_WRDATA_4_X_49_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.COMB.WRDATA_4_X\(49),
dataa => \GRLFPC20.COMB.RDD_2\,
datab => \GRLFPC20.R.I.RES\(49),
datac => \GRLFPC20.R.I.RES\(46));
\GRLFPC20_COMB_WRDATA_4_X_59_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.COMB.WRDATA_4_X\(59),
dataa => \GRLFPC20.COMB.RDD_2\,
datab => \GRLFPC20.R.I.RES\(59),
datac => \GRLFPC20.R.I.RES\(56));
\GRLFPC20_COMB_WRDATA_4_X_61_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.COMB.WRDATA_4_X\(61),
dataa => \GRLFPC20.COMB.RDD_2\,
datab => \GRLFPC20.R.I.RES\(61),
datac => \GRLFPC20.R.I.RES\(58));
\GRLFPC20_COMB_WRADDR_6_X_3_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1110010011100100")
port map (
combout => \GRLFPC20.COMB.WRADDR_6_X\(3),
dataa => \GRLFPC20.WRADDR_1_SQMUXA\,
datab => N_347,
datac => \GRLFPC20.R.I.INST\(28));
\GRLFPC20_COMB_WRADDR_6_X_4_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1110010011100100")
port map (
combout => \GRLFPC20.COMB.WRADDR_6_X\(4),
dataa => \GRLFPC20.WRADDR_1_SQMUXA\,
datab => N_348,
datac => \GRLFPC20.R.I.INST\(29));
\GRLFPC20_COMB_WRADDR_6_X_1_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1110010011100100")
port map (
combout => \GRLFPC20.COMB.WRADDR_6_X\(1),
dataa => \GRLFPC20.WRADDR_1_SQMUXA\,
datab => N_345,
datac => \GRLFPC20.R.I.INST\(26));
\GRLFPC20_COMB_WRADDR_6_X_2_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1110010011100100")
port map (
combout => \GRLFPC20.COMB.WRADDR_6_X\(2),
dataa => \GRLFPC20.WRADDR_1_SQMUXA\,
datab => N_346,
datac => \GRLFPC20.R.I.INST\(27));
\GRLFPC20_COMB_WRADDR_6_X_0_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1110010011100100")
port map (
combout => \GRLFPC20.COMB.WRADDR_6_X\(0),
dataa => \GRLFPC20.WRADDR_1_SQMUXA\,
datab => N_344,
datac => \GRLFPC20.R.I.INST\(25));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_102_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010001000100010")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_102__G2_X\,
dataa => N_666,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(11));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_92_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010001000100010")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_92__G2_X\,
dataa => N_676,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(11));
\GRLFPC20_COMB_DBGDATA_4_0_X_27_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.COMB.DBGDATA_4_0_X\(27),
dataa => N_391,
datab => N_683,
datac => N_619);
\GRLFPC20_COMB_WRDATA_4_X_21_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.COMB.WRDATA_4_X\(21),
dataa => \GRLFPC20.COMB.RDD_2\,
datab => \GRLFPC20.R.I.RES\(21),
datac => \GRLFPC20.R.I.RES\(50));
\GRLFPC20_COMB_WRDATA_4_X_19_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.COMB.WRDATA_4_X\(19),
dataa => \GRLFPC20.COMB.RDD_2\,
datab => \GRLFPC20.R.I.RES\(19),
datac => \GRLFPC20.R.I.RES\(48));
\GRLFPC20_COMB_WRDATA_4_X_18_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.COMB.WRDATA_4_X\(18),
dataa => \GRLFPC20.COMB.RDD_2\,
datab => \GRLFPC20.R.I.RES\(18),
datac => \GRLFPC20.R.I.RES\(47));
\GRLFPC20_COMB_WRDATA_4_X_9_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.COMB.WRDATA_4_X\(9),
dataa => \GRLFPC20.COMB.RDD_2\,
datab => \GRLFPC20.R.I.RES\(9),
datac => \GRLFPC20.R.I.RES\(38));
\GRLFPC20_COMB_WRDATA_4_X_38_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.COMB.WRDATA_4_X\(38),
dataa => \GRLFPC20.COMB.RDD_2\,
datab => \GRLFPC20.R.I.RES\(38),
datac => \GRLFPC20.R.I.RES\(35));
\GRLFPC20_COMB_WRDATA_4_X_41_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.COMB.WRDATA_4_X\(41),
dataa => \GRLFPC20.COMB.RDD_2\,
datab => \GRLFPC20.R.I.RES\(41),
datac => \GRLFPC20.R.I.RES\(38));
\GRLFPC20_COMB_WRDATA_4_X_12_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.COMB.WRDATA_4_X\(12),
dataa => \GRLFPC20.COMB.RDD_2\,
datab => \GRLFPC20.R.I.RES\(12),
datac => \GRLFPC20.R.I.RES\(41));
\GRLFPC20_COMB_WRDATA_4_X_15_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.COMB.WRDATA_4_X\(15),
dataa => \GRLFPC20.COMB.RDD_2\,
datab => \GRLFPC20.R.I.RES\(15),
datac => \GRLFPC20.R.I.RES\(44));
\GRLFPC20_COMB_WRDATA_4_X_20_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.COMB.WRDATA_4_X\(20),
dataa => \GRLFPC20.COMB.RDD_2\,
datab => \GRLFPC20.R.I.RES\(20),
datac => \GRLFPC20.R.I.RES\(49));
\GRLFPC20_COMB_WRDATA_4_X_23_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.COMB.WRDATA_4_X\(23),
dataa => \GRLFPC20.COMB.RDD_2\,
datab => \GRLFPC20.R.I.RES\(23),
datac => \GRLFPC20.R.I.RES\(52));
\GRLFPC20_COMB_WRDATA_4_X_44_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.COMB.WRDATA_4_X\(44),
dataa => \GRLFPC20.COMB.RDD_2\,
datab => \GRLFPC20.R.I.RES\(44),
datac => \GRLFPC20.R.I.RES\(41));
\GRLFPC20_COMB_WRDATA_4_X_47_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.COMB.WRDATA_4_X\(47),
dataa => \GRLFPC20.COMB.RDD_2\,
datab => \GRLFPC20.R.I.RES\(47),
datac => \GRLFPC20.R.I.RES\(44));
\GRLFPC20_COMB_WRDATA_4_X_52_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.COMB.WRDATA_4_X\(52),
dataa => \GRLFPC20.COMB.RDD_2\,
datab => \GRLFPC20.R.I.RES\(52),
datac => \GRLFPC20.R.I.RES\(49));
\GRLFPC20_COMB_WRDATA_4_X_55_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.COMB.WRDATA_4_X\(55),
dataa => \GRLFPC20.COMB.RDD_2\,
datab => \GRLFPC20.R.I.RES\(55),
datac => \GRLFPC20.R.I.RES\(52));
\GRLFPC20_FPI_OP1_X_44_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010110010101100")
port map (
combout => \GRLFPC20.FPI.OP1_X\(44),
dataa => N_668,
datab => N_604,
datac => \GRLFPC20.COMB.UN1_R.A.RS1_1\);
\GRLFPC20_FPI_OP1_X_47_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010110010101100")
port map (
combout => \GRLFPC20.FPI.OP1_X\(47),
dataa => N_671,
datab => N_607,
datac => \GRLFPC20.COMB.UN1_R.A.RS1_1\);
\GRLFPC20_COMB_DBGDATA_4_0_X_7_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.COMB.DBGDATA_4_0_X\(7),
dataa => N_391,
datab => N_663,
datac => N_599);
\GRLFPC20_COMB_DBGDATA_4_0_X_15_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.COMB.DBGDATA_4_0_X\(15),
dataa => N_391,
datab => N_671,
datac => N_607);
\GRLFPC20_COMB_V_FSR_FCC_1_1_X_0_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010110010101100")
port map (
combout => \GRLFPC20.COMB.V.FSR.FCC_1_1_X\(0),
dataa => N_366,
datab => CPO_CCZ(0),
datac => \GRLFPC20.V.FSR.NONSTD_0_SQMUXA_2_X\);
\GRLFPC20_COMB_V_FSR_FCC_1_1_X_1_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010110010101100")
port map (
combout => \GRLFPC20.COMB.V.FSR.FCC_1_1_X\(1),
dataa => N_367,
datab => CPO_CCZ(1),
datac => \GRLFPC20.V.FSR.NONSTD_0_SQMUXA_2_X\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_105_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010001000100010")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_105__G2_X\,
dataa => N_663,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(11));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_103_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010001000100010")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_103__G2_X\,
dataa => N_665,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(11));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_100_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010001000100010")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_100__G2_X\,
dataa => N_668,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(11));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_97_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010001000100010")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_97__G2_X\,
dataa => N_671,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(11));
\GRLFPC20_COMB_DBGDATA_4_0_X_9_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.COMB.DBGDATA_4_0_X\(9),
dataa => N_391,
datab => N_665,
datac => N_601);
\GRLFPC20_COMB_WRDATA_4_X_50_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.COMB.WRDATA_4_X\(50),
dataa => \GRLFPC20.COMB.RDD_2\,
datab => \GRLFPC20.R.I.RES\(50),
datac => \GRLFPC20.R.I.RES\(47));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_99_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010001000100010")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_99__G2_X\,
dataa => N_669,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(11));
\GRLFPC20_COMB_DBGDATA_4_0_X_13_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.COMB.DBGDATA_4_0_X\(13),
dataa => N_391,
datab => N_669,
datac => N_605);
GRLFPC20_COMB_FPDECODE_FPOP2_0_O2_X: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101110111011101")
port map (
combout => \GRLFPC20.COMB.FPDECODE.FPOP2_0_O2_X\,
dataa => N_67,
datab => N_65);
GRLFPC20_COMB_FPDECODE_FPOP8_I_O3_X: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0111011101110111")
port map (
combout => \GRLFPC20.COMB.FPDECODE.FPOP8_I_O3_X\,
dataa => N_74,
datab => N_73);
GRLFPC20_RS2_0_SQMUXA_RNI7CQD: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010001000100010")
port map (
combout => \GRLFPC20.COMB.RS1_1_SN_M2_X\,
dataa => N_3,
datab => \GRLFPC20.RS2_0_SQMUXA\);
GRLFPC20_COMB_V_A_RF1REN_1_0_650_A2_3_X: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0100010001000100")
port map (
combout => \GRLFPC20.COMB.V.A.RF1REN_1_0_650_A2_3_X\,
dataa => N_73,
datab => N_74);
\GRLFPC20_COMB_WRDATA_4_X_8_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.COMB.WRDATA_4_X\(8),
dataa => \GRLFPC20.COMB.RDD_2\,
datab => \GRLFPC20.R.I.RES\(8),
datac => \GRLFPC20.R.I.RES\(37));
\GRLFPC20_COMB_WRDATA_4_X_40_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.COMB.WRDATA_4_X\(40),
dataa => \GRLFPC20.COMB.RDD_2\,
datab => \GRLFPC20.R.I.RES\(40),
datac => \GRLFPC20.R.I.RES\(37));
\GRLFPC20_COMB_DBGDATA_4_0_X_23_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.COMB.DBGDATA_4_0_X\(23),
dataa => N_391,
datab => N_679,
datac => N_615);
\GRLFPC20_COMB_DBGDATA_4_0_X_25_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.COMB.DBGDATA_4_0_X\(25),
dataa => N_391,
datab => N_681,
datac => N_617);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_89_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010001000100010")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_89__G2_X\,
dataa => N_679,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(11));
GRLFPC20_COMB_UN3_HOLDN_X: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1110111011101110")
port map (
combout => \GRLFPC20.COMB.UN3_HOLDN_X\,
dataa => N_146,
datab => N_147);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_84_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010001000100010")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_84__G2_X\,
dataa => N_684,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(11));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_87_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010001000100010")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_87__G2_X\,
dataa => N_681,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(11));
\GRLFPC20_FPI_OP1_X_60_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010110010101100")
port map (
combout => \GRLFPC20.FPI.OP1_X\(60),
dataa => N_684,
datab => N_620,
datac => \GRLFPC20.COMB.UN1_R.A.RS1_1\);
GRLFPC20_COMB_V_E_STDATA2_X: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0100010001000100")
port map (
combout => \GRLFPC20.COMB.V.E.STDATA2_X\,
dataa => N_145,
datab => N_144);
GRLFPC20_COMB_RSDECODE_RS1V_X: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1110111011101110")
port map (
combout => \GRLFPC20.COMB.RSDECODE.RS1V_X\,
dataa => N_76,
datab => N_75);
GRLFPC20_R_MK_HOLDN1_RNO: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0111011101110111")
port map (
combout => \GRLFPC20.R.MK.HOLDN1_0_0_G0_X\,
dataa => N_1,
datab => \GRLFPC20.R.MK.RST2\);
\GRLFPC20_FPI_OP1_X_63_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010110010101100")
port map (
combout => \GRLFPC20.FPI.OP1_X\(63),
dataa => N_687,
datab => N_623,
datac => \GRLFPC20.COMB.UN1_R.A.RS1_1\);
\GRLFPC20_FPI_OP2_X_63_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010110010101100")
port map (
combout => \GRLFPC20.FPI.OP2_X\(63),
dataa => N_719,
datab => N_655,
datac => \GRLFPC20.COMB.UN1_FPCI_4\);
\GRLFPC20_COMB_WRDATA_4_X_7_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.COMB.WRDATA_4_X\(7),
dataa => \GRLFPC20.COMB.RDD_2\,
datab => \GRLFPC20.R.I.RES\(7),
datac => \GRLFPC20.R.I.RES\(36));
\GRLFPC20_COMB_WRDATA_4_X_10_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.COMB.WRDATA_4_X\(10),
dataa => \GRLFPC20.COMB.RDD_2\,
datab => \GRLFPC20.R.I.RES\(10),
datac => \GRLFPC20.R.I.RES\(39));
\GRLFPC20_COMB_WRDATA_4_X_24_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.COMB.WRDATA_4_X\(24),
dataa => \GRLFPC20.COMB.RDD_2\,
datab => \GRLFPC20.R.I.RES\(24),
datac => \GRLFPC20.R.I.RES\(53));
\GRLFPC20_COMB_WRDATA_4_X_31_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.COMB.WRDATA_4_X\(31),
dataa => \GRLFPC20.COMB.RDD_2\,
datab => \GRLFPC20.R.I.RES\(31),
datac => \GRLFPC20.R.I.RES\(63));
\GRLFPC20_COMB_WRDATA_4_X_36_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.COMB.WRDATA_4_X\(36),
dataa => \GRLFPC20.COMB.RDD_2\,
datab => \GRLFPC20.R.I.RES\(36),
datac => \GRLFPC20.R.I.RES\(33));
\GRLFPC20_COMB_WRDATA_4_X_39_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.COMB.WRDATA_4_X\(39),
dataa => \GRLFPC20.COMB.RDD_2\,
datab => \GRLFPC20.R.I.RES\(39),
datac => \GRLFPC20.R.I.RES\(36));
\GRLFPC20_COMB_WRDATA_4_X_42_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.COMB.WRDATA_4_X\(42),
dataa => \GRLFPC20.COMB.RDD_2\,
datab => \GRLFPC20.R.I.RES\(42),
datac => \GRLFPC20.R.I.RES\(39));
\GRLFPC20_COMB_WRDATA_4_X_56_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.COMB.WRDATA_4_X\(56),
dataa => \GRLFPC20.COMB.RDD_2\,
datab => \GRLFPC20.R.I.RES\(56),
datac => \GRLFPC20.R.I.RES\(53));
\GRLFPC20_FPI_OP1_X_38_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010110010101100")
port map (
combout => \GRLFPC20.FPI.OP1_X\(38),
dataa => N_662,
datab => N_598,
datac => \GRLFPC20.COMB.UN1_R.A.RS1_1\);
\GRLFPC20_COMB_DBGDATA_4_0_X_6_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.COMB.DBGDATA_4_0_X\(6),
dataa => N_391,
datab => N_662,
datac => N_598);
\GRLFPC20_COMB_DBGDATA_4_0_X_24_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.COMB.DBGDATA_4_0_X\(24),
dataa => N_391,
datab => N_680,
datac => N_616);
\GRLFPC20_WRDATA_0_X_63_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.WRDATA_0_X\(63),
dataa => \GRLFPC20.WRADDR_0_SQMUXA_0_X\,
datab => N_387,
datac => \GRLFPC20.R.I.RES\(63));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_85_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010001000100010")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_85__G2_X\,
dataa => N_683,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(11));
\GRLFPC20_COMB_WRDATA_4_X_62_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.COMB.WRDATA_4_X\(62),
dataa => \GRLFPC20.COMB.RDD_2\,
datab => \GRLFPC20.R.I.RES\(62),
datac => \GRLFPC20.R.I.RES\(59));
\GRLFPC20_COMB_WRDATA_4_X_33_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.COMB.WRDATA_4_X\(33),
dataa => \GRLFPC20.COMB.RDD_2\,
datab => \GRLFPC20.R.I.RES\(33),
datac => \GRLFPC20.R.I.RES\(30));
\GRLFPC20_COMB_WRDATA_4_X_30_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.COMB.WRDATA_4_X\(30),
dataa => \GRLFPC20.COMB.RDD_2\,
datab => \GRLFPC20.R.I.RES\(30),
datac => \GRLFPC20.R.I.RES\(59));
\GRLFPC20_COMB_WRDATA_4_X_60_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.COMB.WRDATA_4_X\(60),
dataa => \GRLFPC20.COMB.RDD_2\,
datab => \GRLFPC20.R.I.RES\(60),
datac => \GRLFPC20.R.I.RES\(57));
\GRLFPC20_COMB_WRDATA_4_X_53_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.COMB.WRDATA_4_X\(53),
dataa => \GRLFPC20.COMB.RDD_2\,
datab => \GRLFPC20.R.I.RES\(53),
datac => \GRLFPC20.R.I.RES\(50));
\GRLFPC20_COMB_WRDATA_4_X_28_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.COMB.WRDATA_4_X\(28),
dataa => \GRLFPC20.COMB.RDD_2\,
datab => \GRLFPC20.R.I.RES\(28),
datac => \GRLFPC20.R.I.RES\(57));
\GRLFPC20_COMB_WRDATA_4_X_22_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.COMB.WRDATA_4_X\(22),
dataa => \GRLFPC20.COMB.RDD_2\,
datab => \GRLFPC20.R.I.RES\(22),
datac => \GRLFPC20.R.I.RES\(51));
\GRLFPC20_COMB_WRDATA_4_X_51_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.COMB.WRDATA_4_X\(51),
dataa => \GRLFPC20.COMB.RDD_2\,
datab => \GRLFPC20.R.I.RES\(51),
datac => \GRLFPC20.R.I.RES\(48));
\GRLFPC20_COMB_WRDATA_4_X_54_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.COMB.WRDATA_4_X\(54),
dataa => \GRLFPC20.COMB.RDD_2\,
datab => \GRLFPC20.R.I.RES\(54),
datac => \GRLFPC20.R.I.RES\(51));
\GRLFPC20_FPI_OP1_X_51_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010110010101100")
port map (
combout => \GRLFPC20.FPI.OP1_X\(51),
dataa => N_675,
datab => N_611,
datac => \GRLFPC20.COMB.UN1_R.A.RS1_1\);
\GRLFPC20_FPI_OP1_X_54_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010110010101100")
port map (
combout => \GRLFPC20.FPI.OP1_X\(54),
dataa => N_678,
datab => N_614,
datac => \GRLFPC20.COMB.UN1_R.A.RS1_1\);
\GRLFPC20_FPI_OP1_X_57_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010110010101100")
port map (
combout => \GRLFPC20.FPI.OP1_X\(57),
dataa => N_681,
datab => N_617,
datac => \GRLFPC20.COMB.UN1_R.A.RS1_1\);
\GRLFPC20_COMB_DBGDATA_4_0_X_22_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.COMB.DBGDATA_4_0_X\(22),
dataa => N_391,
datab => N_678,
datac => N_614);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_90_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010001000100010")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_90__G2_X\,
dataa => N_678,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(11));
\GRLFPC20_FPI_OP1_X_59_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010110010101100")
port map (
combout => \GRLFPC20.FPI.OP1_X\(59),
dataa => N_683,
datab => N_619,
datac => \GRLFPC20.COMB.UN1_R.A.RS1_1\);
\GRLFPC20_FPI_OP1_X_62_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010110010101100")
port map (
combout => \GRLFPC20.FPI.OP1_X\(62),
dataa => N_686,
datab => N_622,
datac => \GRLFPC20.COMB.UN1_R.A.RS1_1\);
\GRLFPC20_COMB_DBGDATA_4_0_X_30_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.COMB.DBGDATA_4_0_X\(30),
dataa => N_391,
datab => N_686,
datac => N_622);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_108_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010001000100010")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_108__G2_X\,
dataa => N_660,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(11));
GRLFPC20_COMB_RDD_1_M10_2_0_A2_X: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0001000100010001")
port map (
combout => \GRLFPC20.COMB.RDD_1.M10_2_0_A2_X\,
dataa => N_63,
datab => N_62);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_PXS_MAPMULXFF_UN4_UNIMPMAP_1_X: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101110111011101")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.MAPMULXFF.UN4_UNIMPMAP_1_X\,
dataa => N_52,
datab => N_55);
\GRLFPC20_COMB_WRDATA_4_X_0_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.COMB.WRDATA_4_X\(0),
dataa => \GRLFPC20.COMB.RDD_2\,
datab => \GRLFPC20.R.I.RES\(0),
datac => \GRLFPC20.R.I.RES\(29));
\GRLFPC20_COMB_WRDATA_4_X_1_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.COMB.WRDATA_4_X\(1),
dataa => \GRLFPC20.COMB.RDD_2\,
datab => \GRLFPC20.R.I.RES\(1),
datac => \GRLFPC20.R.I.RES\(30));
\GRLFPC20_COMB_WRDATA_4_X_5_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.COMB.WRDATA_4_X\(5),
dataa => \GRLFPC20.COMB.RDD_2\,
datab => \GRLFPC20.R.I.RES\(5),
datac => \GRLFPC20.R.I.RES\(34));
\GRLFPC20_COMB_DBGDATA_4_0_X_5_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.COMB.DBGDATA_4_0_X\(5),
dataa => N_391,
datab => N_661,
datac => N_597);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_107_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010001000100010")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_107__G2_X\,
dataa => N_661,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(11));
GRLFPC20_RS1D_CNST_0_A2_2_X: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.RS1D_CNST_0_A2_2_X\,
dataa => N_67,
datab => N_64);
\GRLFPC20_COMB_RS1_1_0_X_2_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1011100010111000")
port map (
combout => \GRLFPC20.COMB.RS1_1_0_X\(2),
dataa => N_59,
datab => N_3,
datac => \GRLFPC20.R.A.RS1\(2));
\GRLFPC20_COMB_RS1_1_0_X_0_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1011100010111000")
port map (
combout => \GRLFPC20.COMB.RS1_1_0_X\(0),
dataa => N_57,
datab => N_3,
datac => \GRLFPC20.R.A.RS1\(0));
\GRLFPC20_FPI_OP1_X_45_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010110010101100")
port map (
combout => \GRLFPC20.FPI.OP1_X\(45),
dataa => N_669,
datab => N_605,
datac => \GRLFPC20.COMB.UN1_R.A.RS1_1\);
\GRLFPC20_COMB_DBGDATA_4_0_X_16_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.COMB.DBGDATA_4_0_X\(16),
dataa => N_391,
datab => N_672,
datac => N_608);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_96_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010001000100010")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_96__G2_X\,
dataa => N_672,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(11));
\GRLFPC20_COMB_DBGDATA_4_0_X_31_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.COMB.DBGDATA_4_0_X\(31),
dataa => N_391,
datab => N_687,
datac => N_623);
\GRLFPC20_R_FSR_TEM_RNO_4_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010110010101100")
port map (
combout => \GRLFPC20.R.FSR.TEM_1_0_4__G3_X\,
dataa => N_383,
datab => \GRLFPC20.R.FSR.TEM\(4),
datac => \GRLFPC20.V.FSR.NONSTD_0_SQMUXA_2_X\);
\GRLFPC20_R_FSR_TEM_RNO_3_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010110010101100")
port map (
combout => \GRLFPC20.R.FSR.TEM_1_0_3__G3_X\,
dataa => N_382,
datab => \GRLFPC20.R.FSR.TEM\(3),
datac => \GRLFPC20.V.FSR.NONSTD_0_SQMUXA_2_X\);
\GRLFPC20_R_FSR_TEM_RNO_2_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010110010101100")
port map (
combout => \GRLFPC20.R.FSR.TEM_1_0_2__G3_X\,
dataa => N_381,
datab => \GRLFPC20.R.FSR.TEM\(2),
datac => \GRLFPC20.V.FSR.NONSTD_0_SQMUXA_2_X\);
\GRLFPC20_R_FSR_TEM_RNO_1_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010110010101100")
port map (
combout => \GRLFPC20.R.FSR.TEM_1_0_1__G3_X\,
dataa => N_380,
datab => \GRLFPC20.R.FSR.TEM\(1),
datac => \GRLFPC20.V.FSR.NONSTD_0_SQMUXA_2_X\);
\GRLFPC20_R_FSR_TEM_RNO_0_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010110010101100")
port map (
combout => \GRLFPC20.R.FSR.TEM_1_0_0__G3_X\,
dataa => N_379,
datab => \GRLFPC20.R.FSR.TEM\(0),
datac => \GRLFPC20.V.FSR.NONSTD_0_SQMUXA_2_X\);
\GRLFPC20_R_FSR_RD_RNO_1_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010110010101100")
port map (
combout => \GRLFPC20.R.FSR.RD_0_0_1__G3_X\,
dataa => N_387,
datab => \GRLFPC20.R.FSR.RD\(1),
datac => \GRLFPC20.V.FSR.NONSTD_0_SQMUXA_2_X\);
\GRLFPC20_R_FSR_RD_RNO_0_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010110010101100")
port map (
combout => \GRLFPC20.R.FSR.RD_0_0_0__G3_X\,
dataa => N_386,
datab => \GRLFPC20.R.FSR.RD\(0),
datac => \GRLFPC20.V.FSR.NONSTD_0_SQMUXA_2_X\);
GRLFPC20_R_FSR_NONSTD_RNO: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010110010101100")
port map (
combout => \GRLFPC20.R.FSR.NONSTD_0_0_G3_X\,
dataa => N_378,
datab => \GRLFPC20.R.FSR.NONSTD\,
datac => \GRLFPC20.V.FSR.NONSTD_0_SQMUXA_2_X\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_86_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010001000100010")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_86__G2_X\,
dataa => N_682,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(11));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_88_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010001000100010")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_88__G2_X\,
dataa => N_680,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(11));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_91_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010001000100010")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_91__G2_X\,
dataa => N_677,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(11));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_93_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010001000100010")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_93__G2_X\,
dataa => N_675,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(11));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_94_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010001000100010")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_94__G2_X\,
dataa => N_674,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(11));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_95_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010001000100010")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_95__G2_X\,
dataa => N_673,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(11));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_98_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010001000100010")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_98__G2_X\,
dataa => N_670,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(11));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_101_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010001000100010")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_101__G2_X\,
dataa => N_667,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(11));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_104_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010001000100010")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_104__G2_X\,
dataa => N_664,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(11));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_106_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010001000100010")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_106__G2_X\,
dataa => N_662,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(11));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_109_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010001000100010")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_109__G2_X\,
dataa => N_659,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(11));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_110_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010001000100010")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_110__G2_X\,
dataa => N_658,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(11));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_111_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010001000100010")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_111__G2_X\,
dataa => N_657,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(11));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_112_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010001000100010")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_112__G2_X\,
dataa => N_656,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(11));
\GRLFPC20_FPI_OP2_X_32_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010110010101100")
port map (
combout => \GRLFPC20.FPI.OP2_X\(32),
dataa => N_688,
datab => N_624,
datac => \GRLFPC20.COMB.UN1_FPCI_4\);
\GRLFPC20_FPI_OP2_X_33_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010110010101100")
port map (
combout => \GRLFPC20.FPI.OP2_X\(33),
dataa => N_689,
datab => N_625,
datac => \GRLFPC20.COMB.UN1_FPCI_4\);
\GRLFPC20_FPI_OP2_X_34_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010110010101100")
port map (
combout => \GRLFPC20.FPI.OP2_X\(34),
dataa => N_690,
datab => N_626,
datac => \GRLFPC20.COMB.UN1_FPCI_4\);
\GRLFPC20_FPI_OP2_X_35_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010110010101100")
port map (
combout => \GRLFPC20.FPI.OP2_X\(35),
dataa => N_691,
datab => N_627,
datac => \GRLFPC20.COMB.UN1_FPCI_4\);
\GRLFPC20_FPI_OP2_X_36_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010110010101100")
port map (
combout => \GRLFPC20.FPI.OP2_X\(36),
dataa => N_692,
datab => N_628,
datac => \GRLFPC20.COMB.UN1_FPCI_4\);
\GRLFPC20_FPI_OP2_X_37_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010110010101100")
port map (
combout => \GRLFPC20.FPI.OP2_X\(37),
dataa => N_693,
datab => N_629,
datac => \GRLFPC20.COMB.UN1_FPCI_4\);
\GRLFPC20_FPI_OP2_X_38_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010110010101100")
port map (
combout => \GRLFPC20.FPI.OP2_X\(38),
dataa => N_694,
datab => N_630,
datac => \GRLFPC20.COMB.UN1_FPCI_4\);
\GRLFPC20_FPI_OP2_X_39_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010110010101100")
port map (
combout => \GRLFPC20.FPI.OP2_X\(39),
dataa => N_695,
datab => N_631,
datac => \GRLFPC20.COMB.UN1_FPCI_4\);
\GRLFPC20_FPI_OP2_X_40_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010110010101100")
port map (
combout => \GRLFPC20.FPI.OP2_X\(40),
dataa => N_696,
datab => N_632,
datac => \GRLFPC20.COMB.UN1_FPCI_4\);
\GRLFPC20_FPI_OP2_X_41_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010110010101100")
port map (
combout => \GRLFPC20.FPI.OP2_X\(41),
dataa => N_697,
datab => N_633,
datac => \GRLFPC20.COMB.UN1_FPCI_4\);
\GRLFPC20_FPI_OP2_X_42_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010110010101100")
port map (
combout => \GRLFPC20.FPI.OP2_X\(42),
dataa => N_698,
datab => N_634,
datac => \GRLFPC20.COMB.UN1_FPCI_4\);
\GRLFPC20_FPI_OP2_X_43_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010110010101100")
port map (
combout => \GRLFPC20.FPI.OP2_X\(43),
dataa => N_699,
datab => N_635,
datac => \GRLFPC20.COMB.UN1_FPCI_4\);
\GRLFPC20_FPI_OP2_X_44_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010110010101100")
port map (
combout => \GRLFPC20.FPI.OP2_X\(44),
dataa => N_700,
datab => N_636,
datac => \GRLFPC20.COMB.UN1_FPCI_4\);
\GRLFPC20_FPI_OP2_X_45_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010110010101100")
port map (
combout => \GRLFPC20.FPI.OP2_X\(45),
dataa => N_701,
datab => N_637,
datac => \GRLFPC20.COMB.UN1_FPCI_4\);
\GRLFPC20_FPI_OP2_X_46_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010110010101100")
port map (
combout => \GRLFPC20.FPI.OP2_X\(46),
dataa => N_702,
datab => N_638,
datac => \GRLFPC20.COMB.UN1_FPCI_4\);
\GRLFPC20_FPI_OP2_X_47_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010110010101100")
port map (
combout => \GRLFPC20.FPI.OP2_X\(47),
dataa => N_703,
datab => N_639,
datac => \GRLFPC20.COMB.UN1_FPCI_4\);
\GRLFPC20_FPI_OP2_X_48_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010110010101100")
port map (
combout => \GRLFPC20.FPI.OP2_X\(48),
dataa => N_704,
datab => N_640,
datac => \GRLFPC20.COMB.UN1_FPCI_4\);
\GRLFPC20_FPI_OP2_X_49_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010110010101100")
port map (
combout => \GRLFPC20.FPI.OP2_X\(49),
dataa => N_705,
datab => N_641,
datac => \GRLFPC20.COMB.UN1_FPCI_4\);
\GRLFPC20_FPI_OP2_X_50_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010110010101100")
port map (
combout => \GRLFPC20.FPI.OP2_X\(50),
dataa => N_706,
datab => N_642,
datac => \GRLFPC20.COMB.UN1_FPCI_4\);
\GRLFPC20_FPI_OP2_X_51_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010110010101100")
port map (
combout => \GRLFPC20.FPI.OP2_X\(51),
dataa => N_707,
datab => N_643,
datac => \GRLFPC20.COMB.UN1_FPCI_4\);
\GRLFPC20_FPI_OP2_X_52_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010110010101100")
port map (
combout => \GRLFPC20.FPI.OP2_X\(52),
dataa => N_708,
datab => N_644,
datac => \GRLFPC20.COMB.UN1_FPCI_4\);
\GRLFPC20_FPI_OP2_X_53_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010110010101100")
port map (
combout => \GRLFPC20.FPI.OP2_X\(53),
dataa => N_709,
datab => N_645,
datac => \GRLFPC20.COMB.UN1_FPCI_4\);
\GRLFPC20_FPI_OP2_X_54_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010110010101100")
port map (
combout => \GRLFPC20.FPI.OP2_X\(54),
dataa => N_710,
datab => N_646,
datac => \GRLFPC20.COMB.UN1_FPCI_4\);
\GRLFPC20_FPI_OP2_X_55_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010110010101100")
port map (
combout => \GRLFPC20.FPI.OP2_X\(55),
dataa => N_711,
datab => N_647,
datac => \GRLFPC20.COMB.UN1_FPCI_4\);
\GRLFPC20_FPI_OP2_X_56_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010110010101100")
port map (
combout => \GRLFPC20.FPI.OP2_X\(56),
dataa => N_712,
datab => N_648,
datac => \GRLFPC20.COMB.UN1_FPCI_4\);
\GRLFPC20_FPI_OP2_X_57_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010110010101100")
port map (
combout => \GRLFPC20.FPI.OP2_X\(57),
dataa => N_713,
datab => N_649,
datac => \GRLFPC20.COMB.UN1_FPCI_4\);
\GRLFPC20_FPI_OP2_X_58_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010110010101100")
port map (
combout => \GRLFPC20.FPI.OP2_X\(58),
dataa => N_714,
datab => N_650,
datac => \GRLFPC20.COMB.UN1_FPCI_4\);
\GRLFPC20_FPI_OP2_X_59_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010110010101100")
port map (
combout => \GRLFPC20.FPI.OP2_X\(59),
dataa => N_715,
datab => N_651,
datac => \GRLFPC20.COMB.UN1_FPCI_4\);
\GRLFPC20_FPI_OP2_X_60_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010110010101100")
port map (
combout => \GRLFPC20.FPI.OP2_X\(60),
dataa => N_716,
datab => N_652,
datac => \GRLFPC20.COMB.UN1_FPCI_4\);
\GRLFPC20_FPI_OP2_X_61_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010110010101100")
port map (
combout => \GRLFPC20.FPI.OP2_X\(61),
dataa => N_717,
datab => N_653,
datac => \GRLFPC20.COMB.UN1_FPCI_4\);
\GRLFPC20_FPI_OP2_X_62_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010110010101100")
port map (
combout => \GRLFPC20.FPI.OP2_X\(62),
dataa => N_718,
datab => N_654,
datac => \GRLFPC20.COMB.UN1_FPCI_4\);
\GRLFPC20_FPI_OP1_X_35_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010110010101100")
port map (
combout => \GRLFPC20.FPI.OP1_X\(35),
dataa => N_659,
datab => N_595,
datac => \GRLFPC20.COMB.UN1_R.A.RS1_1\);
\GRLFPC20_FPI_OP1_X_41_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010110010101100")
port map (
combout => \GRLFPC20.FPI.OP1_X\(41),
dataa => N_665,
datab => N_601,
datac => \GRLFPC20.COMB.UN1_R.A.RS1_1\);
\GRLFPC20_COMB_DBGDATA_4_0_X_3_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.COMB.DBGDATA_4_0_X\(3),
dataa => N_391,
datab => N_659,
datac => N_595);
\GRLFPC20_COMB_WRDATA_4_X_58_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.COMB.WRDATA_4_X\(58),
dataa => \GRLFPC20.COMB.RDD_2\,
datab => \GRLFPC20.R.I.RES\(58),
datac => \GRLFPC20.R.I.RES\(55));
\GRLFPC20_COMB_WRDATA_4_X_26_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.COMB.WRDATA_4_X\(26),
dataa => \GRLFPC20.COMB.RDD_2\,
datab => \GRLFPC20.R.I.RES\(26),
datac => \GRLFPC20.R.I.RES\(55));
\GRLFPC20_COMB_V_FSR_CEXC_1_1_X_4_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1100101011001010")
port map (
combout => \GRLFPC20.COMB.V.FSR.CEXC_1_1_X\(4),
dataa => N_360,
datab => \GRLFPC20.R.FSR.CEXC\(4),
datac => \GRLFPC20.V.FSR.CEXC_3_SQMUXA\);
\GRLFPC20_COMB_V_FSR_CEXC_1_1_X_3_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1100101011001010")
port map (
combout => \GRLFPC20.COMB.V.FSR.CEXC_1_1_X\(3),
dataa => N_359,
datab => \GRLFPC20.R.FSR.CEXC\(3),
datac => \GRLFPC20.V.FSR.CEXC_3_SQMUXA\);
\GRLFPC20_COMB_V_FSR_CEXC_1_1_X_2_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1100101011001010")
port map (
combout => \GRLFPC20.COMB.V.FSR.CEXC_1_1_X\(2),
dataa => N_358,
datab => \GRLFPC20.R.FSR.CEXC\(2),
datac => \GRLFPC20.V.FSR.CEXC_3_SQMUXA\);
\GRLFPC20_COMB_V_FSR_CEXC_1_1_X_1_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1100101011001010")
port map (
combout => \GRLFPC20.COMB.V.FSR.CEXC_1_1_X\(1),
dataa => N_357,
datab => \GRLFPC20.R.FSR.CEXC\(1),
datac => \GRLFPC20.V.FSR.CEXC_3_SQMUXA\);
\GRLFPC20_COMB_V_FSR_CEXC_1_1_X_0_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1100101011001010")
port map (
combout => \GRLFPC20.COMB.V.FSR.CEXC_1_1_X\(0),
dataa => N_356,
datab => \GRLFPC20.R.FSR.CEXC\(0),
datac => \GRLFPC20.V.FSR.CEXC_3_SQMUXA\);
\GRLFPC20_COMB_DBGDATA_4_0_X_26_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.COMB.DBGDATA_4_0_X\(26),
dataa => N_391,
datab => N_682,
datac => N_618);
\GRLFPC20_COMB_DBGDATA_4_0_X_14_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.COMB.DBGDATA_4_0_X\(14),
dataa => N_391,
datab => N_670,
datac => N_606);
\GRLFPC20_COMB_DBGDATA_4_0_X_11_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.COMB.DBGDATA_4_0_X\(11),
dataa => N_391,
datab => N_667,
datac => N_603);
\GRLFPC20_COMB_DBGDATA_4_0_X_8_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.COMB.DBGDATA_4_0_X\(8),
dataa => N_391,
datab => N_664,
datac => N_600);
\GRLFPC20_COMB_DBGDATA_4_0_X_4_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.COMB.DBGDATA_4_0_X\(4),
dataa => N_391,
datab => N_660,
datac => N_596);
\GRLFPC20_COMB_DBGDATA_4_0_X_2_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.COMB.DBGDATA_4_0_X\(2),
dataa => N_391,
datab => N_658,
datac => N_594);
\GRLFPC20_COMB_DBGDATA_4_0_X_1_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.COMB.DBGDATA_4_0_X\(1),
dataa => N_391,
datab => N_657,
datac => N_593);
\GRLFPC20_COMB_DBGDATA_4_0_X_0_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.COMB.DBGDATA_4_0_X\(0),
dataa => N_391,
datab => N_656,
datac => N_592);
\GRLFPC20_FPI_OP1_X_58_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010110010101100")
port map (
combout => \GRLFPC20.FPI.OP1_X\(58),
dataa => N_682,
datab => N_618,
datac => \GRLFPC20.COMB.UN1_R.A.RS1_1\);
\GRLFPC20_FPI_OP1_X_56_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010110010101100")
port map (
combout => \GRLFPC20.FPI.OP1_X\(56),
dataa => N_680,
datab => N_616,
datac => \GRLFPC20.COMB.UN1_R.A.RS1_1\);
\GRLFPC20_FPI_OP1_X_55_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010110010101100")
port map (
combout => \GRLFPC20.FPI.OP1_X\(55),
dataa => N_679,
datab => N_615,
datac => \GRLFPC20.COMB.UN1_R.A.RS1_1\);
\GRLFPC20_FPI_OP1_X_53_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010110010101100")
port map (
combout => \GRLFPC20.FPI.OP1_X\(53),
dataa => N_677,
datab => N_613,
datac => \GRLFPC20.COMB.UN1_R.A.RS1_1\);
\GRLFPC20_FPI_OP1_X_52_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010110010101100")
port map (
combout => \GRLFPC20.FPI.OP1_X\(52),
dataa => N_676,
datab => N_612,
datac => \GRLFPC20.COMB.UN1_R.A.RS1_1\);
\GRLFPC20_FPI_OP1_X_50_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010110010101100")
port map (
combout => \GRLFPC20.FPI.OP1_X\(50),
dataa => N_674,
datab => N_610,
datac => \GRLFPC20.COMB.UN1_R.A.RS1_1\);
\GRLFPC20_FPI_OP1_X_49_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010110010101100")
port map (
combout => \GRLFPC20.FPI.OP1_X\(49),
dataa => N_673,
datab => N_609,
datac => \GRLFPC20.COMB.UN1_R.A.RS1_1\);
\GRLFPC20_FPI_OP1_X_48_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010110010101100")
port map (
combout => \GRLFPC20.FPI.OP1_X\(48),
dataa => N_672,
datab => N_608,
datac => \GRLFPC20.COMB.UN1_R.A.RS1_1\);
\GRLFPC20_FPI_OP1_X_46_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010110010101100")
port map (
combout => \GRLFPC20.FPI.OP1_X\(46),
dataa => N_670,
datab => N_606,
datac => \GRLFPC20.COMB.UN1_R.A.RS1_1\);
\GRLFPC20_FPI_OP1_X_43_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010110010101100")
port map (
combout => \GRLFPC20.FPI.OP1_X\(43),
dataa => N_667,
datab => N_603,
datac => \GRLFPC20.COMB.UN1_R.A.RS1_1\);
\GRLFPC20_FPI_OP1_X_42_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010110010101100")
port map (
combout => \GRLFPC20.FPI.OP1_X\(42),
dataa => N_666,
datab => N_602,
datac => \GRLFPC20.COMB.UN1_R.A.RS1_1\);
\GRLFPC20_FPI_OP1_X_40_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010110010101100")
port map (
combout => \GRLFPC20.FPI.OP1_X\(40),
dataa => N_664,
datab => N_600,
datac => \GRLFPC20.COMB.UN1_R.A.RS1_1\);
\GRLFPC20_FPI_OP1_X_39_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010110010101100")
port map (
combout => \GRLFPC20.FPI.OP1_X\(39),
dataa => N_663,
datab => N_599,
datac => \GRLFPC20.COMB.UN1_R.A.RS1_1\);
\GRLFPC20_FPI_OP1_X_37_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010110010101100")
port map (
combout => \GRLFPC20.FPI.OP1_X\(37),
dataa => N_661,
datab => N_597,
datac => \GRLFPC20.COMB.UN1_R.A.RS1_1\);
\GRLFPC20_FPI_OP1_X_36_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010110010101100")
port map (
combout => \GRLFPC20.FPI.OP1_X\(36),
dataa => N_660,
datab => N_596,
datac => \GRLFPC20.COMB.UN1_R.A.RS1_1\);
\GRLFPC20_FPI_OP1_X_34_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010110010101100")
port map (
combout => \GRLFPC20.FPI.OP1_X\(34),
dataa => N_658,
datab => N_594,
datac => \GRLFPC20.COMB.UN1_R.A.RS1_1\);
\GRLFPC20_FPI_OP1_X_33_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010110010101100")
port map (
combout => \GRLFPC20.FPI.OP1_X\(33),
dataa => N_657,
datab => N_593,
datac => \GRLFPC20.COMB.UN1_R.A.RS1_1\);
\GRLFPC20_FPI_OP1_X_32_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010110010101100")
port map (
combout => \GRLFPC20.FPI.OP1_X\(32),
dataa => N_656,
datab => N_592,
datac => \GRLFPC20.COMB.UN1_R.A.RS1_1\);
\GRLFPC20_COMB_WRDATA_4_X_57_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.COMB.WRDATA_4_X\(57),
dataa => \GRLFPC20.COMB.RDD_2\,
datab => \GRLFPC20.R.I.RES\(57),
datac => \GRLFPC20.R.I.RES\(54));
\GRLFPC20_COMB_WRDATA_4_X_37_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.COMB.WRDATA_4_X\(37),
dataa => \GRLFPC20.COMB.RDD_2\,
datab => \GRLFPC20.R.I.RES\(37),
datac => \GRLFPC20.R.I.RES\(34));
\GRLFPC20_COMB_WRDATA_4_X_32_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.COMB.WRDATA_4_X\(32),
dataa => \GRLFPC20.COMB.RDD_2\,
datab => \GRLFPC20.R.I.RES\(32),
datac => \GRLFPC20.R.I.RES\(29));
\GRLFPC20_COMB_WRDATA_4_X_25_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.COMB.WRDATA_4_X\(25),
dataa => \GRLFPC20.COMB.RDD_2\,
datab => \GRLFPC20.R.I.RES\(25),
datac => \GRLFPC20.R.I.RES\(54));
\GRLFPC20_COMB_WRDATA_4_X_4_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.COMB.WRDATA_4_X\(4),
dataa => \GRLFPC20.COMB.RDD_2\,
datab => \GRLFPC20.R.I.RES\(4),
datac => \GRLFPC20.R.I.RES\(33));
\GRLFPC20_FPI_OP1_X_61_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010110010101100")
port map (
combout => \GRLFPC20.FPI.OP1_X\(61),
dataa => N_685,
datab => N_621,
datac => \GRLFPC20.COMB.UN1_R.A.RS1_1\);
\GRLFPC20_COMB_WRDATA_4_X_48_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.COMB.WRDATA_4_X\(48),
dataa => \GRLFPC20.COMB.RDD_2\,
datab => \GRLFPC20.R.I.RES\(48),
datac => \GRLFPC20.R.I.RES\(45));
\GRLFPC20_COMB_WRDATA_4_X_35_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.COMB.WRDATA_4_X\(35),
dataa => \GRLFPC20.COMB.RDD_2\,
datab => \GRLFPC20.R.I.RES\(35),
datac => \GRLFPC20.R.I.RES\(32));
\GRLFPC20_COMB_WRDATA_4_X_16_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.COMB.WRDATA_4_X\(16),
dataa => \GRLFPC20.COMB.RDD_2\,
datab => \GRLFPC20.R.I.RES\(16),
datac => \GRLFPC20.R.I.RES\(45));
\GRLFPC20_COMB_WRDATA_4_X_6_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.COMB.WRDATA_4_X\(6),
dataa => \GRLFPC20.COMB.RDD_2\,
datab => \GRLFPC20.R.I.RES\(6),
datac => \GRLFPC20.R.I.RES\(35));
\GRLFPC20_COMB_WRDATA_4_X_3_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.COMB.WRDATA_4_X\(3),
dataa => \GRLFPC20.COMB.RDD_2\,
datab => \GRLFPC20.R.I.RES\(3),
datac => \GRLFPC20.R.I.RES\(32));
\GRLFPC20_COMB_RS1_1_0_X_1_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1011100010111000")
port map (
combout => \GRLFPC20.COMB.RS1_1_0_X\(1),
dataa => N_58,
datab => N_3,
datac => \GRLFPC20.R.A.RS1\(1));
GRLFPC20_COMB_FPDECODE_RDD5_3_0_A2_X: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0001000100010001")
port map (
combout => \GRLFPC20.COMB.FPDECODE.RDD5_3_0_A2_X\,
dataa => N_53,
datab => N_52);
GRLFPC20_R_I_V_RNIKG6C: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.R.FSR.FTT_1_0_0__G2_0_600_I_0_X\,
dataa => N_1,
datab => \GRLFPC20.R.I.V\);
GRLFPC20_COMB_LOCK_1_1_X: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0001000100010001")
port map (
combout => \GRLFPC20.COMB.LOCK_1_1_X\,
dataa => N_78,
datab => \GRLFPC20.COMB.V.A.RF2REN_1_0_701_I_948_X\);
GRLFPC20_RS1D_CNST_0_A2_1_X: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0100010001000100")
port map (
combout => \GRLFPC20.RS1D_CNST_0_A2_1_X\,
dataa => N_65,
datab => N_74);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_SCTRL_RNO_0_0_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0001000100010001")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SXC.SCTRL_NEW_6_0_0__G0_0_A3_0_X\,
dataa => N_55,
datab => N_51);
GRLFPC20_COMB_UN1_FPCI_4_RNO: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.COMB.UN1_FPCI_0_1_X\,
dataa => N_145,
datab => \GRLFPC20.R.A.ST\);
GRLFPC20_WREN1_0_SQMUXA_1_X: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010000000100000")
port map (
combout => \GRLFPC20.WREN1_0_SQMUXA_1_X\,
dataa => N_339,
datab => \GRLFPC20.R.X.AFSR\,
datac => \GRLFPC20.R.X.LD\);
\GRLFPC20_COMB_DBGDATA_4_X_10_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1110010011100100")
port map (
combout => CPO_DBG_DATAZ(10),
dataa => N_390,
datab => \GRLFPC20.COMB.DBGDATA_4_0_X\(10),
datac => CPO_CCZ(0));
\GRLFPC20_WRDATA_0_X_14_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.WRDATA_0_X\(14),
dataa => \GRLFPC20.WRADDR_0_SQMUXA_0_X\,
datab => N_370,
datac => \GRLFPC20.COMB.WRDATA_4_X\(14));
\GRLFPC20_WRDATA_0_X_46_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.WRDATA_0_X\(46),
dataa => \GRLFPC20.WRADDR_0_SQMUXA_0_X\,
datab => N_370,
datac => \GRLFPC20.COMB.WRDATA_4_X\(46));
\GRLFPC20_WRDATA_0_X_2_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.WRDATA_0_X\(2),
dataa => \GRLFPC20.WRADDR_0_SQMUXA_0_X\,
datab => N_358,
datac => \GRLFPC20.COMB.WRDATA_4_X\(2));
\GRLFPC20_WRDATA_0_X_11_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.WRDATA_0_X\(11),
dataa => \GRLFPC20.WRADDR_0_SQMUXA_0_X\,
datab => N_367,
datac => \GRLFPC20.COMB.WRDATA_4_X\(11));
\GRLFPC20_WRDATA_0_X_13_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.WRDATA_0_X\(13),
dataa => \GRLFPC20.WRADDR_0_SQMUXA_0_X\,
datab => N_369,
datac => \GRLFPC20.COMB.WRDATA_4_X\(13));
\GRLFPC20_WRDATA_0_X_17_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.WRDATA_0_X\(17),
dataa => \GRLFPC20.WRADDR_0_SQMUXA_0_X\,
datab => N_373,
datac => \GRLFPC20.COMB.WRDATA_4_X\(17));
\GRLFPC20_WRDATA_0_X_27_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.WRDATA_0_X\(27),
dataa => \GRLFPC20.WRADDR_0_SQMUXA_0_X\,
datab => N_383,
datac => \GRLFPC20.COMB.WRDATA_4_X\(27));
\GRLFPC20_WRDATA_0_X_29_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.WRDATA_0_X\(29),
dataa => \GRLFPC20.WRADDR_0_SQMUXA_0_X\,
datab => N_385,
datac => \GRLFPC20.COMB.WRDATA_4_X\(29));
\GRLFPC20_WRDATA_0_X_34_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.WRDATA_0_X\(34),
dataa => \GRLFPC20.WRADDR_0_SQMUXA_0_X\,
datab => N_358,
datac => \GRLFPC20.COMB.WRDATA_4_X\(34));
\GRLFPC20_WRDATA_0_X_43_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.WRDATA_0_X\(43),
dataa => \GRLFPC20.WRADDR_0_SQMUXA_0_X\,
datab => N_367,
datac => \GRLFPC20.COMB.WRDATA_4_X\(43));
\GRLFPC20_WRDATA_0_X_45_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.WRDATA_0_X\(45),
dataa => \GRLFPC20.WRADDR_0_SQMUXA_0_X\,
datab => N_369,
datac => \GRLFPC20.COMB.WRDATA_4_X\(45));
\GRLFPC20_WRDATA_0_X_49_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.WRDATA_0_X\(49),
dataa => \GRLFPC20.WRADDR_0_SQMUXA_0_X\,
datab => N_373,
datac => \GRLFPC20.COMB.WRDATA_4_X\(49));
\GRLFPC20_WRDATA_0_X_59_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.WRDATA_0_X\(59),
dataa => \GRLFPC20.WRADDR_0_SQMUXA_0_X\,
datab => N_383,
datac => \GRLFPC20.COMB.WRDATA_4_X\(59));
\GRLFPC20_WRDATA_0_X_61_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.WRDATA_0_X\(61),
dataa => \GRLFPC20.WRADDR_0_SQMUXA_0_X\,
datab => N_385,
datac => \GRLFPC20.COMB.WRDATA_4_X\(61));
\GRLFPC20_COMB_DBGDATA_4_X_27_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1110010011100100")
port map (
combout => CPO_DBG_DATAZ(27),
dataa => N_390,
datab => \GRLFPC20.COMB.DBGDATA_4_0_X\(27),
datac => \GRLFPC20.R.FSR.TEM\(4));
\GRLFPC20_WRDATA_0_X_21_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.WRDATA_0_X\(21),
dataa => \GRLFPC20.WRADDR_0_SQMUXA_0_X\,
datab => N_377,
datac => \GRLFPC20.COMB.WRDATA_4_X\(21));
\GRLFPC20_WRDATA_0_X_19_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.WRDATA_0_X\(19),
dataa => \GRLFPC20.WRADDR_0_SQMUXA_0_X\,
datab => N_375,
datac => \GRLFPC20.COMB.WRDATA_4_X\(19));
\GRLFPC20_WRDATA_0_X_18_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.WRDATA_0_X\(18),
dataa => \GRLFPC20.WRADDR_0_SQMUXA_0_X\,
datab => N_374,
datac => \GRLFPC20.COMB.WRDATA_4_X\(18));
\GRLFPC20_WRDATA_0_X_9_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.WRDATA_0_X\(9),
dataa => \GRLFPC20.WRADDR_0_SQMUXA_0_X\,
datab => N_365,
datac => \GRLFPC20.COMB.WRDATA_4_X\(9));
\GRLFPC20_WRDATA_0_X_38_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.WRDATA_0_X\(38),
dataa => \GRLFPC20.WRADDR_0_SQMUXA_0_X\,
datab => N_362,
datac => \GRLFPC20.COMB.WRDATA_4_X\(38));
\GRLFPC20_WRDATA_0_X_41_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.WRDATA_0_X\(41),
dataa => \GRLFPC20.WRADDR_0_SQMUXA_0_X\,
datab => N_365,
datac => \GRLFPC20.COMB.WRDATA_4_X\(41));
\GRLFPC20_COMB_DBGDATA_4_X_7_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1110010011100100")
port map (
combout => CPO_DBG_DATAZ(7),
dataa => N_390,
datab => \GRLFPC20.COMB.DBGDATA_4_0_X\(7),
datac => \GRLFPC20.R.FSR.AEXC\(2));
\GRLFPC20_COMB_DBGDATA_4_X_15_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1110010011100100")
port map (
combout => CPO_DBG_DATAZ(15),
dataa => N_390,
datab => \GRLFPC20.COMB.DBGDATA_4_0_X\(15),
datac => \GRLFPC20.R.FSR.FTT\(1));
\GRLFPC20_WRDATA_0_X_12_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.WRDATA_0_X\(12),
dataa => \GRLFPC20.WRADDR_0_SQMUXA_0_X\,
datab => N_368,
datac => \GRLFPC20.COMB.WRDATA_4_X\(12));
\GRLFPC20_WRDATA_0_X_15_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.WRDATA_0_X\(15),
dataa => \GRLFPC20.WRADDR_0_SQMUXA_0_X\,
datab => N_371,
datac => \GRLFPC20.COMB.WRDATA_4_X\(15));
\GRLFPC20_WRDATA_0_X_20_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.WRDATA_0_X\(20),
dataa => \GRLFPC20.WRADDR_0_SQMUXA_0_X\,
datab => N_376,
datac => \GRLFPC20.COMB.WRDATA_4_X\(20));
\GRLFPC20_WRDATA_0_X_23_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.WRDATA_0_X\(23),
dataa => \GRLFPC20.WRADDR_0_SQMUXA_0_X\,
datab => N_379,
datac => \GRLFPC20.COMB.WRDATA_4_X\(23));
\GRLFPC20_WRDATA_0_X_44_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.WRDATA_0_X\(44),
dataa => \GRLFPC20.WRADDR_0_SQMUXA_0_X\,
datab => N_368,
datac => \GRLFPC20.COMB.WRDATA_4_X\(44));
\GRLFPC20_WRDATA_0_X_47_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.WRDATA_0_X\(47),
dataa => \GRLFPC20.WRADDR_0_SQMUXA_0_X\,
datab => N_371,
datac => \GRLFPC20.COMB.WRDATA_4_X\(47));
\GRLFPC20_WRDATA_0_X_52_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.WRDATA_0_X\(52),
dataa => \GRLFPC20.WRADDR_0_SQMUXA_0_X\,
datab => N_376,
datac => \GRLFPC20.COMB.WRDATA_4_X\(52));
\GRLFPC20_WRDATA_0_X_55_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.WRDATA_0_X\(55),
dataa => \GRLFPC20.WRADDR_0_SQMUXA_0_X\,
datab => N_379,
datac => \GRLFPC20.COMB.WRDATA_4_X\(55));
\GRLFPC20_COMB_DBGDATA_4_X_9_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1110010011100100")
port map (
combout => CPO_DBG_DATAZ(9),
dataa => N_390,
datab => \GRLFPC20.COMB.DBGDATA_4_0_X\(9),
datac => \GRLFPC20.R.FSR.AEXC\(4));
\GRLFPC20_WRDATA_0_X_50_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.WRDATA_0_X\(50),
dataa => \GRLFPC20.WRADDR_0_SQMUXA_0_X\,
datab => N_374,
datac => \GRLFPC20.COMB.WRDATA_4_X\(50));
GRLFPC20_WRADDR_0_SQMUXA_X: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0100000001000000")
port map (
combout => \GRLFPC20.WRADDR_0_SQMUXA_X\,
dataa => N_390,
datab => N_389,
datac => N_388);
\GRLFPC20_COMB_DBGDATA_4_X_23_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1110010011100100")
port map (
combout => CPO_DBG_DATAZ(23),
dataa => N_390,
datab => \GRLFPC20.COMB.DBGDATA_4_0_X\(23),
datac => \GRLFPC20.R.FSR.TEM\(0));
\GRLFPC20_COMB_DBGDATA_4_X_25_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1110010011100100")
port map (
combout => CPO_DBG_DATAZ(25),
dataa => N_390,
datab => \GRLFPC20.COMB.DBGDATA_4_0_X\(25),
datac => \GRLFPC20.R.FSR.TEM\(2));
\GRLFPC20_WRDATA_0_X_8_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.WRDATA_0_X\(8),
dataa => \GRLFPC20.WRADDR_0_SQMUXA_0_X\,
datab => N_364,
datac => \GRLFPC20.COMB.WRDATA_4_X\(8));
\GRLFPC20_WRDATA_0_X_40_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.WRDATA_0_X\(40),
dataa => \GRLFPC20.WRADDR_0_SQMUXA_0_X\,
datab => N_364,
datac => \GRLFPC20.COMB.WRDATA_4_X\(40));
GRLFPC20_R_E_AFQ_RNO: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0001000000010000")
port map (
combout => \GRLFPC20.R.E.AFQ_0_0_G1_X\,
dataa => N_147,
datab => N_146,
datac => \GRLFPC20.R.A.AFQ\);
GRLFPC20_R_E_AFSR_RNO: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0001000000010000")
port map (
combout => \GRLFPC20.R.E.AFSR_0_0_G1_X\,
dataa => N_147,
datab => N_146,
datac => \GRLFPC20.R.A.AFSR\);
GRLFPC20_R_E_FPOP_RNO: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0001000000010000")
port map (
combout => \GRLFPC20.R.E.FPOP_0_0_G1_X\,
dataa => N_147,
datab => N_146,
datac => \GRLFPC20.R.A.FPOP\);
GRLFPC20_R_E_LD_RNO: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0001000000010000")
port map (
combout => \GRLFPC20.R.E.LD_0_0_G1_X\,
dataa => N_147,
datab => N_146,
datac => \GRLFPC20.R.A.LD\);
GRLFPC20_ANNULFPU_0_SQMUXA_2_X: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1110000011100000")
port map (
combout => \GRLFPC20.ANNULFPU_0_SQMUXA_2_X\,
dataa => N_147,
datab => N_146,
datac => \GRLFPC20.R.A.FPOP\);
\GRLFPC20_COMB_V_E_STDATA_1_0_X_27_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.COMB.V.E.STDATA_1_0_X\(27),
dataa => \GRLFPC20.COMB.V.E.STDATA2_X\,
datab => \GRLFPC20.R.I.PC\(27),
datac => \GRLFPC20.R.I.INST\(27));
\GRLFPC20_COMB_V_E_STDATA_1_0_X_26_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.COMB.V.E.STDATA_1_0_X\(26),
dataa => \GRLFPC20.COMB.V.E.STDATA2_X\,
datab => \GRLFPC20.R.I.PC\(26),
datac => \GRLFPC20.R.I.INST\(26));
\GRLFPC20_COMB_V_E_STDATA_1_0_X_25_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.COMB.V.E.STDATA_1_0_X\(25),
dataa => \GRLFPC20.COMB.V.E.STDATA2_X\,
datab => \GRLFPC20.R.I.PC\(25),
datac => \GRLFPC20.R.I.INST\(25));
\GRLFPC20_COMB_V_E_STDATA_1_0_X_31_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.COMB.V.E.STDATA_1_0_X\(31),
dataa => \GRLFPC20.COMB.V.E.STDATA2_X\,
datab => \GRLFPC20.R.I.PC\(31),
datac => \GRLFPC20.R.I.INST\(31));
\GRLFPC20_COMB_V_E_STDATA_1_0_X_30_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.COMB.V.E.STDATA_1_0_X\(30),
dataa => \GRLFPC20.COMB.V.E.STDATA2_X\,
datab => \GRLFPC20.R.I.PC\(30),
datac => \GRLFPC20.R.I.INST\(30));
\GRLFPC20_COMB_V_E_STDATA_1_0_X_24_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.COMB.V.E.STDATA_1_0_X\(24),
dataa => \GRLFPC20.COMB.V.E.STDATA2_X\,
datab => \GRLFPC20.R.I.PC\(24),
datac => \GRLFPC20.R.I.INST\(24));
\GRLFPC20_COMB_V_E_STDATA_1_0_X_23_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.COMB.V.E.STDATA_1_0_X\(23),
dataa => \GRLFPC20.COMB.V.E.STDATA2_X\,
datab => \GRLFPC20.R.I.PC\(23),
datac => \GRLFPC20.R.I.INST\(23));
\GRLFPC20_COMB_V_E_STDATA_1_0_X_22_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.COMB.V.E.STDATA_1_0_X\(22),
dataa => \GRLFPC20.COMB.V.E.STDATA2_X\,
datab => \GRLFPC20.R.I.PC\(22),
datac => \GRLFPC20.R.I.INST\(22));
\GRLFPC20_COMB_V_E_STDATA_1_0_X_16_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.COMB.V.E.STDATA_1_0_X\(16),
dataa => \GRLFPC20.COMB.V.E.STDATA2_X\,
datab => \GRLFPC20.R.I.PC\(16),
datac => \GRLFPC20.R.I.INST\(16));
\GRLFPC20_COMB_V_E_STDATA_1_0_X_15_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.COMB.V.E.STDATA_1_0_X\(15),
dataa => \GRLFPC20.COMB.V.E.STDATA2_X\,
datab => \GRLFPC20.R.I.PC\(15),
datac => \GRLFPC20.R.I.INST\(15));
\GRLFPC20_COMB_V_E_STDATA_1_0_X_14_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.COMB.V.E.STDATA_1_0_X\(14),
dataa => \GRLFPC20.COMB.V.E.STDATA2_X\,
datab => \GRLFPC20.R.I.PC\(14),
datac => \GRLFPC20.R.I.INST\(14));
\GRLFPC20_COMB_V_E_STDATA_1_0_X_13_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.COMB.V.E.STDATA_1_0_X\(13),
dataa => \GRLFPC20.COMB.V.E.STDATA2_X\,
datab => \GRLFPC20.R.I.PC\(13),
datac => \GRLFPC20.R.I.INST\(13));
\GRLFPC20_COMB_V_E_STDATA_1_0_X_11_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.COMB.V.E.STDATA_1_0_X\(11),
dataa => \GRLFPC20.COMB.V.E.STDATA2_X\,
datab => \GRLFPC20.R.I.PC\(11),
datac => \GRLFPC20.R.I.INST\(11));
\GRLFPC20_COMB_V_E_STDATA_1_0_X_10_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.COMB.V.E.STDATA_1_0_X\(10),
dataa => \GRLFPC20.COMB.V.E.STDATA2_X\,
datab => \GRLFPC20.R.I.PC\(10),
datac => \GRLFPC20.R.I.INST\(10));
\GRLFPC20_COMB_V_E_STDATA_1_0_X_9_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.COMB.V.E.STDATA_1_0_X\(9),
dataa => \GRLFPC20.COMB.V.E.STDATA2_X\,
datab => \GRLFPC20.R.I.PC\(9),
datac => \GRLFPC20.R.I.INST\(9));
\GRLFPC20_COMB_V_E_STDATA_1_0_X_8_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.COMB.V.E.STDATA_1_0_X\(8),
dataa => \GRLFPC20.COMB.V.E.STDATA2_X\,
datab => \GRLFPC20.R.I.PC\(8),
datac => \GRLFPC20.R.I.INST\(8));
\GRLFPC20_COMB_V_E_STDATA_1_0_X_7_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.COMB.V.E.STDATA_1_0_X\(7),
dataa => \GRLFPC20.COMB.V.E.STDATA2_X\,
datab => \GRLFPC20.R.I.PC\(7),
datac => \GRLFPC20.R.I.INST\(7));
\GRLFPC20_COMB_V_E_STDATA_1_0_X_6_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.COMB.V.E.STDATA_1_0_X\(6),
dataa => \GRLFPC20.COMB.V.E.STDATA2_X\,
datab => \GRLFPC20.R.I.PC\(6),
datac => \GRLFPC20.R.I.INST\(6));
\GRLFPC20_COMB_V_E_STDATA_1_0_X_5_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.COMB.V.E.STDATA_1_0_X\(5),
dataa => \GRLFPC20.COMB.V.E.STDATA2_X\,
datab => \GRLFPC20.R.I.PC\(5),
datac => \GRLFPC20.R.I.INST\(5));
\GRLFPC20_COMB_V_E_STDATA_1_0_X_4_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.COMB.V.E.STDATA_1_0_X\(4),
dataa => \GRLFPC20.COMB.V.E.STDATA2_X\,
datab => \GRLFPC20.R.I.PC\(4),
datac => \GRLFPC20.R.I.INST\(4));
\GRLFPC20_COMB_V_E_STDATA_1_0_X_3_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.COMB.V.E.STDATA_1_0_X\(3),
dataa => \GRLFPC20.COMB.V.E.STDATA2_X\,
datab => \GRLFPC20.R.I.PC\(3),
datac => \GRLFPC20.R.I.INST\(3));
\GRLFPC20_COMB_V_E_STDATA_1_0_X_2_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.COMB.V.E.STDATA_1_0_X\(2),
dataa => \GRLFPC20.COMB.V.E.STDATA2_X\,
datab => \GRLFPC20.R.I.PC\(2),
datac => \GRLFPC20.R.I.INST\(2));
\GRLFPC20_R_E_STDATA_RNO_0_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101000011010000")
port map (
combout => \GRLFPC20.R.E.STDATA_1_0_0__G3_X\,
dataa => N_144,
datab => N_145,
datac => \GRLFPC20.R.I.INST\(0));
\GRLFPC20_R_E_STDATA_RNO_1_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101000011010000")
port map (
combout => \GRLFPC20.R.E.STDATA_1_0_1__G3_X\,
dataa => N_144,
datab => N_145,
datac => \GRLFPC20.R.I.INST\(1));
\GRLFPC20_R_E_STDATA_RNO_12_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.R.E.STDATA_1_0_12__G3_X\,
dataa => \GRLFPC20.COMB.V.E.STDATA2_X\,
datab => \GRLFPC20.R.I.PC\(12),
datac => \GRLFPC20.R.I.INST\(12));
\GRLFPC20_R_E_STDATA_RNO_17_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.R.E.STDATA_1_0_17__G3_X\,
dataa => \GRLFPC20.COMB.V.E.STDATA2_X\,
datab => \GRLFPC20.R.I.PC\(17),
datac => \GRLFPC20.R.I.INST\(17));
\GRLFPC20_R_E_STDATA_RNO_18_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.R.E.STDATA_1_0_18__G3_X\,
dataa => \GRLFPC20.COMB.V.E.STDATA2_X\,
datab => \GRLFPC20.R.I.PC\(18),
datac => \GRLFPC20.R.I.INST\(18));
\GRLFPC20_R_E_STDATA_RNO_19_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.R.E.STDATA_1_0_19__G3_X\,
dataa => \GRLFPC20.COMB.V.E.STDATA2_X\,
datab => \GRLFPC20.R.I.PC\(19),
datac => \GRLFPC20.R.I.INST\(19));
\GRLFPC20_R_E_STDATA_RNO_20_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.R.E.STDATA_1_0_20__G3_X\,
dataa => \GRLFPC20.COMB.V.E.STDATA2_X\,
datab => \GRLFPC20.R.I.PC\(20),
datac => \GRLFPC20.R.I.INST\(20));
\GRLFPC20_R_E_STDATA_RNO_21_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.R.E.STDATA_1_0_21__G3_X\,
dataa => \GRLFPC20.COMB.V.E.STDATA2_X\,
datab => \GRLFPC20.R.I.PC\(21),
datac => \GRLFPC20.R.I.INST\(21));
\GRLFPC20_R_E_STDATA_RNO_28_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.R.E.STDATA_1_0_28__G3_X\,
dataa => \GRLFPC20.COMB.V.E.STDATA2_X\,
datab => \GRLFPC20.R.I.PC\(28),
datac => \GRLFPC20.R.I.INST\(28));
\GRLFPC20_R_E_STDATA_RNO_29_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.R.E.STDATA_1_0_29__G3_X\,
dataa => \GRLFPC20.COMB.V.E.STDATA2_X\,
datab => \GRLFPC20.R.I.PC\(29),
datac => \GRLFPC20.R.I.INST\(29));
GRLFPC20_R_M_AFQ_RNO: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0001000000010000")
port map (
combout => \GRLFPC20.R.M.AFQ_0_0_G1_X\,
dataa => N_216,
datab => N_215,
datac => \GRLFPC20.R.E.AFQ\);
GRLFPC20_R_M_AFSR_RNO: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0001000000010000")
port map (
combout => \GRLFPC20.R.M.AFSR_0_0_G1_X\,
dataa => N_216,
datab => N_215,
datac => \GRLFPC20.R.E.AFSR\);
GRLFPC20_R_M_FPOP_RNO: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0001000000010000")
port map (
combout => \GRLFPC20.R.M.FPOP_0_0_G1_X\,
dataa => N_216,
datab => N_215,
datac => \GRLFPC20.R.E.FPOP\);
GRLFPC20_R_M_LD_RNO: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0001000000010000")
port map (
combout => \GRLFPC20.R.M.LD_0_0_G1_X\,
dataa => N_216,
datab => N_215,
datac => \GRLFPC20.R.E.LD\);
GRLFPC20_R_X_AFQ_RNO: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0001000000010000")
port map (
combout => \GRLFPC20.R.X.AFQ_0_0_G1_X\,
dataa => N_285,
datab => N_284,
datac => \GRLFPC20.R.M.AFQ\);
GRLFPC20_R_X_AFSR_RNO: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0001000000010000")
port map (
combout => \GRLFPC20.R.X.AFSR_0_0_G1_X\,
dataa => N_285,
datab => N_284,
datac => \GRLFPC20.R.M.AFSR\);
GRLFPC20_R_X_FPOP_RNO: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0001000000010000")
port map (
combout => \GRLFPC20.R.X.FPOP_0_0_G1_X\,
dataa => N_285,
datab => N_284,
datac => \GRLFPC20.R.M.FPOP\);
GRLFPC20_R_X_LD_RNO: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0001000000010000")
port map (
combout => \GRLFPC20.R.X.LD_0_0_G1_X\,
dataa => N_285,
datab => N_284,
datac => \GRLFPC20.R.M.LD\);
GRLFPC20_ANNULFPU_0_SQMUXA_1_X: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1110000011100000")
port map (
combout => \GRLFPC20.ANNULFPU_0_SQMUXA_1_X\,
dataa => N_216,
datab => N_215,
datac => \GRLFPC20.R.E.FPOP\);
GRLFPC20_ANNULFPU_0_SQMUXA_X: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1110000011100000")
port map (
combout => \GRLFPC20.ANNULFPU_0_SQMUXA_X\,
dataa => N_285,
datab => N_284,
datac => \GRLFPC20.R.M.FPOP\);
\GRLFPC20_COMB_DBGDATA_4_X_6_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1110010011100100")
port map (
combout => CPO_DBG_DATAZ(6),
dataa => N_390,
datab => \GRLFPC20.COMB.DBGDATA_4_0_X\(6),
datac => \GRLFPC20.R.FSR.AEXC\(1));
\GRLFPC20_COMB_DBGDATA_4_X_24_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1110010011100100")
port map (
combout => CPO_DBG_DATAZ(24),
dataa => N_390,
datab => \GRLFPC20.COMB.DBGDATA_4_0_X\(24),
datac => \GRLFPC20.R.FSR.TEM\(1));
\GRLFPC20_WRDATA_0_X_7_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.WRDATA_0_X\(7),
dataa => \GRLFPC20.WRADDR_0_SQMUXA_0_X\,
datab => N_363,
datac => \GRLFPC20.COMB.WRDATA_4_X\(7));
\GRLFPC20_WRDATA_0_X_10_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.WRDATA_0_X\(10),
dataa => \GRLFPC20.WRADDR_0_SQMUXA_0_X\,
datab => N_366,
datac => \GRLFPC20.COMB.WRDATA_4_X\(10));
\GRLFPC20_WRDATA_0_X_24_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.WRDATA_0_X\(24),
dataa => \GRLFPC20.WRADDR_0_SQMUXA_0_X\,
datab => N_380,
datac => \GRLFPC20.COMB.WRDATA_4_X\(24));
\GRLFPC20_WRDATA_0_X_31_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.WRDATA_0_X\(31),
dataa => \GRLFPC20.WRADDR_0_SQMUXA_0_X\,
datab => N_387,
datac => \GRLFPC20.COMB.WRDATA_4_X\(31));
\GRLFPC20_WRDATA_0_X_36_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.WRDATA_0_X\(36),
dataa => \GRLFPC20.WRADDR_0_SQMUXA_0_X\,
datab => N_360,
datac => \GRLFPC20.COMB.WRDATA_4_X\(36));
\GRLFPC20_WRDATA_0_X_39_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.WRDATA_0_X\(39),
dataa => \GRLFPC20.WRADDR_0_SQMUXA_0_X\,
datab => N_363,
datac => \GRLFPC20.COMB.WRDATA_4_X\(39));
\GRLFPC20_WRDATA_0_X_42_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.WRDATA_0_X\(42),
dataa => \GRLFPC20.WRADDR_0_SQMUXA_0_X\,
datab => N_366,
datac => \GRLFPC20.COMB.WRDATA_4_X\(42));
\GRLFPC20_WRDATA_0_X_56_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.WRDATA_0_X\(56),
dataa => \GRLFPC20.WRADDR_0_SQMUXA_0_X\,
datab => N_380,
datac => \GRLFPC20.COMB.WRDATA_4_X\(56));
\GRLFPC20_WRDATA_0_X_62_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.WRDATA_0_X\(62),
dataa => \GRLFPC20.WRADDR_0_SQMUXA_0_X\,
datab => N_386,
datac => \GRLFPC20.COMB.WRDATA_4_X\(62));
\GRLFPC20_WRDATA_0_X_33_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.WRDATA_0_X\(33),
dataa => \GRLFPC20.WRADDR_0_SQMUXA_0_X\,
datab => N_357,
datac => \GRLFPC20.COMB.WRDATA_4_X\(33));
\GRLFPC20_WRDATA_0_X_30_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.WRDATA_0_X\(30),
dataa => \GRLFPC20.WRADDR_0_SQMUXA_0_X\,
datab => N_386,
datac => \GRLFPC20.COMB.WRDATA_4_X\(30));
\GRLFPC20_WRDATA_0_X_60_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.WRDATA_0_X\(60),
dataa => \GRLFPC20.WRADDR_0_SQMUXA_0_X\,
datab => N_384,
datac => \GRLFPC20.COMB.WRDATA_4_X\(60));
\GRLFPC20_WRDATA_0_X_53_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.WRDATA_0_X\(53),
dataa => \GRLFPC20.WRADDR_0_SQMUXA_0_X\,
datab => N_377,
datac => \GRLFPC20.COMB.WRDATA_4_X\(53));
\GRLFPC20_WRDATA_0_X_28_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.WRDATA_0_X\(28),
dataa => \GRLFPC20.WRADDR_0_SQMUXA_0_X\,
datab => N_384,
datac => \GRLFPC20.COMB.WRDATA_4_X\(28));
\GRLFPC20_WRDATA_0_X_22_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.WRDATA_0_X\(22),
dataa => \GRLFPC20.WRADDR_0_SQMUXA_0_X\,
datab => N_378,
datac => \GRLFPC20.COMB.WRDATA_4_X\(22));
\GRLFPC20_COMB_DBGDATA_4_X_22_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1110010011100100")
port map (
combout => CPO_DBG_DATAZ(22),
dataa => N_390,
datab => \GRLFPC20.COMB.DBGDATA_4_0_X\(22),
datac => \GRLFPC20.R.FSR.NONSTD\);
\GRLFPC20_WRDATA_0_X_51_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.WRDATA_0_X\(51),
dataa => \GRLFPC20.WRADDR_0_SQMUXA_0_X\,
datab => N_375,
datac => \GRLFPC20.COMB.WRDATA_4_X\(51));
\GRLFPC20_WRDATA_0_X_54_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.WRDATA_0_X\(54),
dataa => \GRLFPC20.WRADDR_0_SQMUXA_0_X\,
datab => N_378,
datac => \GRLFPC20.COMB.WRDATA_4_X\(54));
\GRLFPC20_COMB_DBGDATA_4_X_30_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1110010011100100")
port map (
combout => CPO_DBG_DATAZ(30),
dataa => N_390,
datab => \GRLFPC20.COMB.DBGDATA_4_0_X\(30),
datac => \GRLFPC20.R.FSR.RD\(0));
\GRLFPC20_COMB_DBGDATA_4_X_5_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1110010011100100")
port map (
combout => CPO_DBG_DATAZ(5),
dataa => N_390,
datab => \GRLFPC20.COMB.DBGDATA_4_0_X\(5),
datac => \GRLFPC20.R.FSR.AEXC\(0));
\GRLFPC20_WRDATA_0_X_0_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.WRDATA_0_X\(0),
dataa => \GRLFPC20.WRADDR_0_SQMUXA_0_X\,
datab => N_356,
datac => \GRLFPC20.COMB.WRDATA_4_X\(0));
\GRLFPC20_WRDATA_0_X_1_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.WRDATA_0_X\(1),
dataa => \GRLFPC20.WRADDR_0_SQMUXA_0_X\,
datab => N_357,
datac => \GRLFPC20.COMB.WRDATA_4_X\(1));
\GRLFPC20_WRDATA_0_X_5_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.WRDATA_0_X\(5),
dataa => \GRLFPC20.WRADDR_0_SQMUXA_0_X\,
datab => N_361,
datac => \GRLFPC20.COMB.WRDATA_4_X\(5));
GRLFPC20_COMB_FPDECODE_RDD4_0_A2_0_X: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010000000100000")
port map (
combout => \GRLFPC20.COMB.FPDECODE.RDD4_0_A2_0_X\,
dataa => N_51,
datab => N_50,
datac => N_53);
\GRLFPC20_COMB_DBGDATA_4_X_16_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1110010011100100")
port map (
combout => CPO_DBG_DATAZ(16),
dataa => N_390,
datab => \GRLFPC20.COMB.DBGDATA_4_0_X\(16),
datac => \GRLFPC20.R.FSR.FTT\(2));
\GRLFPC20_COMB_DBGDATA_4_X_31_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1110010011100100")
port map (
combout => CPO_DBG_DATAZ(31),
dataa => N_390,
datab => \GRLFPC20.COMB.DBGDATA_4_0_X\(31),
datac => \GRLFPC20.R.FSR.RD\(1));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_DPATH_NEW_1_X_23_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1110001011100010")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_1_X\(23),
dataa => N_719,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(11),
datac => \GRLFPC20.FPI.OP2_X\(34));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_DPATH_NEW_1_X_25_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1110001011100010")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_1_X\(25),
dataa => N_717,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(11),
datac => \GRLFPC20.FPI.OP2_X\(32));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_DPATH_NEW_1_X_24_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1110001011100010")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_1_X\(24),
dataa => N_718,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(11),
datac => \GRLFPC20.FPI.OP2_X\(33));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_DPATH_NEW_19_X_81_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1110001011100010")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_X\(81),
dataa => N_687,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(11),
datac => \GRLFPC20.FPI.OP1_X\(34));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_DPATH_NEW_19_X_83_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1110001011100010")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_X\(83),
dataa => N_685,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(11),
datac => \GRLFPC20.FPI.OP1_X\(32));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_DPATH_NEW_19_X_82_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1110001011100010")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_X\(82),
dataa => N_686,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(11),
datac => \GRLFPC20.FPI.OP1_X\(33));
\GRLFPC20_WRDATA_0_X_58_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.WRDATA_0_X\(58),
dataa => \GRLFPC20.WRADDR_0_SQMUXA_0_X\,
datab => N_382,
datac => \GRLFPC20.COMB.WRDATA_4_X\(58));
\GRLFPC20_WRDATA_0_X_26_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.WRDATA_0_X\(26),
dataa => \GRLFPC20.WRADDR_0_SQMUXA_0_X\,
datab => N_382,
datac => \GRLFPC20.COMB.WRDATA_4_X\(26));
\GRLFPC20_COMB_DBGDATA_4_X_3_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1110010011100100")
port map (
combout => CPO_DBG_DATAZ(3),
dataa => N_390,
datab => \GRLFPC20.COMB.DBGDATA_4_0_X\(3),
datac => \GRLFPC20.R.FSR.CEXC\(3));
\GRLFPC20_WRDATA_0_X_57_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.WRDATA_0_X\(57),
dataa => \GRLFPC20.WRADDR_0_SQMUXA_0_X\,
datab => N_381,
datac => \GRLFPC20.COMB.WRDATA_4_X\(57));
\GRLFPC20_WRDATA_0_X_37_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.WRDATA_0_X\(37),
dataa => \GRLFPC20.WRADDR_0_SQMUXA_0_X\,
datab => N_361,
datac => \GRLFPC20.COMB.WRDATA_4_X\(37));
\GRLFPC20_WRDATA_0_X_32_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.WRDATA_0_X\(32),
dataa => \GRLFPC20.WRADDR_0_SQMUXA_0_X\,
datab => N_356,
datac => \GRLFPC20.COMB.WRDATA_4_X\(32));
\GRLFPC20_WRDATA_0_X_25_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.WRDATA_0_X\(25),
dataa => \GRLFPC20.WRADDR_0_SQMUXA_0_X\,
datab => N_381,
datac => \GRLFPC20.COMB.WRDATA_4_X\(25));
\GRLFPC20_WRDATA_0_X_4_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.WRDATA_0_X\(4),
dataa => \GRLFPC20.WRADDR_0_SQMUXA_0_X\,
datab => N_360,
datac => \GRLFPC20.COMB.WRDATA_4_X\(4));
\GRLFPC20_COMB_DBGDATA_4_X_26_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1110010011100100")
port map (
combout => CPO_DBG_DATAZ(26),
dataa => N_390,
datab => \GRLFPC20.COMB.DBGDATA_4_0_X\(26),
datac => \GRLFPC20.R.FSR.TEM\(3));
\GRLFPC20_COMB_DBGDATA_4_X_14_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1110010011100100")
port map (
combout => CPO_DBG_DATAZ(14),
dataa => N_390,
datab => \GRLFPC20.COMB.DBGDATA_4_0_X\(14),
datac => \GRLFPC20.R.FSR.FTT\(0));
\GRLFPC20_COMB_DBGDATA_4_X_11_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1110010011100100")
port map (
combout => CPO_DBG_DATAZ(11),
dataa => N_390,
datab => \GRLFPC20.COMB.DBGDATA_4_0_X\(11),
datac => CPO_CCZ(1));
\GRLFPC20_COMB_DBGDATA_4_X_8_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1110010011100100")
port map (
combout => CPO_DBG_DATAZ(8),
dataa => N_390,
datab => \GRLFPC20.COMB.DBGDATA_4_0_X\(8),
datac => \GRLFPC20.R.FSR.AEXC\(3));
\GRLFPC20_COMB_DBGDATA_4_X_4_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1110010011100100")
port map (
combout => CPO_DBG_DATAZ(4),
dataa => N_390,
datab => \GRLFPC20.COMB.DBGDATA_4_0_X\(4),
datac => \GRLFPC20.R.FSR.CEXC\(4));
\GRLFPC20_COMB_DBGDATA_4_X_2_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1110010011100100")
port map (
combout => CPO_DBG_DATAZ(2),
dataa => N_390,
datab => \GRLFPC20.COMB.DBGDATA_4_0_X\(2),
datac => \GRLFPC20.R.FSR.CEXC\(2));
\GRLFPC20_COMB_DBGDATA_4_X_1_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1110010011100100")
port map (
combout => CPO_DBG_DATAZ(1),
dataa => N_390,
datab => \GRLFPC20.COMB.DBGDATA_4_0_X\(1),
datac => \GRLFPC20.R.FSR.CEXC\(1));
\GRLFPC20_COMB_DBGDATA_4_X_0_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1110010011100100")
port map (
combout => CPO_DBG_DATAZ(0),
dataa => N_390,
datab => \GRLFPC20.COMB.DBGDATA_4_0_X\(0),
datac => \GRLFPC20.R.FSR.CEXC\(0));
\GRLFPC20_WRDATA_0_X_48_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.WRDATA_0_X\(48),
dataa => \GRLFPC20.WRADDR_0_SQMUXA_0_X\,
datab => N_372,
datac => \GRLFPC20.COMB.WRDATA_4_X\(48));
\GRLFPC20_WRDATA_0_X_35_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.WRDATA_0_X\(35),
dataa => \GRLFPC20.WRADDR_0_SQMUXA_0_X\,
datab => N_359,
datac => \GRLFPC20.COMB.WRDATA_4_X\(35));
\GRLFPC20_WRDATA_0_X_16_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.WRDATA_0_X\(16),
dataa => \GRLFPC20.WRADDR_0_SQMUXA_0_X\,
datab => N_372,
datac => \GRLFPC20.COMB.WRDATA_4_X\(16));
\GRLFPC20_WRDATA_0_X_6_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.WRDATA_0_X\(6),
dataa => \GRLFPC20.WRADDR_0_SQMUXA_0_X\,
datab => N_362,
datac => \GRLFPC20.COMB.WRDATA_4_X\(6));
\GRLFPC20_WRDATA_0_X_3_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.WRDATA_0_X\(3),
dataa => \GRLFPC20.WRADDR_0_SQMUXA_0_X\,
datab => N_359,
datac => \GRLFPC20.COMB.WRDATA_4_X\(3));
GRLFPC20_COMB_FPDECODE_RDD4_0_A2_X: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000001000000010")
port map (
combout => \GRLFPC20.COMB.FPDECODE.RDD4_0_A2_X\,
dataa => N_49,
datab => N_48,
datac => N_54);
GRLFPC20_COMB_RSDECODE_UN1_FPCI_0_X: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0001000000010000")
port map (
combout => \GRLFPC20.COMB.RSDECODE.UN1_FPCI_0_X\,
dataa => N_55,
datab => N_56,
datac => N_54);
GRLFPC20_V_STATE_0_SQMUXA_1_X: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0111111101111111")
port map (
combout => \GRLFPC20.V.STATE_0_SQMUXA_1_X\,
dataa => N_390,
datab => N_389,
datac => N_388);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_64_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1111110111111101")
port map (
combout => \GRLFPC20.FPI.RST_0_G0_X\,
dataa => N_1,
datab => \GRLFPC20.R.MK.RST2\,
datac => \GRLFPC20.R.MK.RST\);
GRLFPC20_COMB_UN1_FPCI_0_X: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1111111011111110")
port map (
combout => \GRLFPC20.COMB.UN1_FPCI_0_X\,
dataa => N_354,
datab => N_353,
datac => N_4);
GRLFPC20_R_A_RS1D_0_0_G4_1_X: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010000000100000")
port map (
combout => \GRLFPC20.R.A.RS1D_0_0_G4_1_X\,
dataa => N_49,
datab => N_48,
datac => N_52);
GRLFPC20_RS2_0_SQMUXA_0_X: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000000010000000")
port map (
combout => \GRLFPC20.RS2_0_SQMUXA_0_X\,
dataa => N_66,
datab => N_67,
datac => N_64);
GRLFPC20_COMB_FPDECODE_UN1_FPCI_7_1_X: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000000010000000")
port map (
combout => \GRLFPC20.COMB.FPDECODE.UN1_FPCI_7_1_X\,
dataa => N_54,
datab => N_55,
datac => N_52);
GRLFPC20_R_A_MOV_RNO_1: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000011100000111")
port map (
combout => \GRLFPC20.R.A.MOV_0_0_G1_1_X\,
dataa => N_50,
datab => N_51,
datac => N_54);
GRLFPC20_N_1243_I_0_A2_1_X: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000000100000001")
port map (
combout => \GRLFPC20.N_1243_I_0_A2_1_X\,
dataa => N_77,
datab => N_4,
datac => N_78);
GRLFPC20_R_MK_BUSY_RNO_0: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000000010000000")
port map (
combout => \GRLFPC20.R.MK.BUSY_0_0_G0_0_X\,
dataa => N_1,
datab => \GRLFPC20.R.MK.HOLDN1\,
datac => \GRLFPC20.R.MK.HOLDN2\);
GRLFPC20_R_MK_RST_RNO_0: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000001000000010")
port map (
combout => \GRLFPC20.COMB.V.MK.RST_1_0_G0_1_0_X\,
dataa => N_3,
datab => \GRLFPC20.R.MK.RST\,
datac => \GRLFPC20.R.MK.RST2\);
GRLFPC20_R_X_AFSR_RNISO6G: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0001000000010000")
port map (
combout => \GRLFPC20.WRADDR_0_SQMUXA_0_X\,
dataa => \GRLFPC20.COMB.UN1_FPCI_0_X\,
datab => \GRLFPC20.R.X.AFSR\,
datac => \GRLFPC20.R.X.LD\);
\GRLFPC20_WRDATA_X_14_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010110010101100")
port map (
combout => RFI2_WRDATAZ(14),
dataa => N_410,
datab => \GRLFPC20.WRDATA_0_X\(14),
datac => \GRLFPC20.WRADDR_0_SQMUXA_X\);
\GRLFPC20_WRDATA_X_46_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010110010101100")
port map (
combout => RFI1_WRDATAZ(14),
dataa => N_410,
datab => \GRLFPC20.WRDATA_0_X\(46),
datac => \GRLFPC20.WRADDR_0_SQMUXA_X\);
\GRLFPC20_RS1_1_X_3_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => RFI2_RD1ADDRZ(2),
dataa => N_388,
datab => N_394,
datac => \GRLFPC20.COMB.RS1_1\(3));
\GRLFPC20_RS1_1_X_4_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => RFI2_RD1ADDRZ(3),
dataa => N_388,
datab => N_395,
datac => \GRLFPC20.COMB.RS1_1\(4));
\GRLFPC20_RS2_1_X_4_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => RFI2_RD2ADDRZ(3),
dataa => N_388,
datab => N_395,
datac => \GRLFPC20.COMB.RS2_1\(4));
\GRLFPC20_WRADDR_1_X_3_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1011100010111000")
port map (
combout => RFI2_WRADDRZ(2),
dataa => N_394,
datab => \GRLFPC20.WRADDR_0_SQMUXA_X\,
datac => \GRLFPC20.COMB.WRADDR_6_X\(3));
\GRLFPC20_WRADDR_1_X_4_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1011100010111000")
port map (
combout => RFI2_WRADDRZ(3),
dataa => N_395,
datab => \GRLFPC20.WRADDR_0_SQMUXA_X\,
datac => \GRLFPC20.COMB.WRADDR_6_X\(4));
\GRLFPC20_WRDATA_X_2_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010110010101100")
port map (
combout => RFI2_WRDATAZ(2),
dataa => N_398,
datab => \GRLFPC20.WRDATA_0_X\(2),
datac => \GRLFPC20.WRADDR_0_SQMUXA_X\);
\GRLFPC20_WRDATA_X_11_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010110010101100")
port map (
combout => RFI2_WRDATAZ(11),
dataa => N_407,
datab => \GRLFPC20.WRDATA_0_X\(11),
datac => \GRLFPC20.WRADDR_0_SQMUXA_X\);
\GRLFPC20_WRDATA_X_13_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010110010101100")
port map (
combout => RFI2_WRDATAZ(13),
dataa => N_409,
datab => \GRLFPC20.WRDATA_0_X\(13),
datac => \GRLFPC20.WRADDR_0_SQMUXA_X\);
\GRLFPC20_WRDATA_X_17_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010110010101100")
port map (
combout => RFI2_WRDATAZ(17),
dataa => N_413,
datab => \GRLFPC20.WRDATA_0_X\(17),
datac => \GRLFPC20.WRADDR_0_SQMUXA_X\);
\GRLFPC20_WRDATA_X_27_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010110010101100")
port map (
combout => RFI2_WRDATAZ(27),
dataa => N_423,
datab => \GRLFPC20.WRDATA_0_X\(27),
datac => \GRLFPC20.WRADDR_0_SQMUXA_X\);
\GRLFPC20_WRDATA_X_29_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010110010101100")
port map (
combout => RFI2_WRDATAZ(29),
dataa => N_425,
datab => \GRLFPC20.WRDATA_0_X\(29),
datac => \GRLFPC20.WRADDR_0_SQMUXA_X\);
\GRLFPC20_WRDATA_X_34_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010110010101100")
port map (
combout => RFI1_WRDATAZ(2),
dataa => N_398,
datab => \GRLFPC20.WRDATA_0_X\(34),
datac => \GRLFPC20.WRADDR_0_SQMUXA_X\);
\GRLFPC20_WRDATA_X_43_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010110010101100")
port map (
combout => RFI1_WRDATAZ(11),
dataa => N_407,
datab => \GRLFPC20.WRDATA_0_X\(43),
datac => \GRLFPC20.WRADDR_0_SQMUXA_X\);
\GRLFPC20_WRDATA_X_45_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010110010101100")
port map (
combout => RFI1_WRDATAZ(13),
dataa => N_409,
datab => \GRLFPC20.WRDATA_0_X\(45),
datac => \GRLFPC20.WRADDR_0_SQMUXA_X\);
\GRLFPC20_WRDATA_X_49_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010110010101100")
port map (
combout => RFI1_WRDATAZ(17),
dataa => N_413,
datab => \GRLFPC20.WRDATA_0_X\(49),
datac => \GRLFPC20.WRADDR_0_SQMUXA_X\);
\GRLFPC20_WRDATA_X_59_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010110010101100")
port map (
combout => RFI1_WRDATAZ(27),
dataa => N_423,
datab => \GRLFPC20.WRDATA_0_X\(59),
datac => \GRLFPC20.WRADDR_0_SQMUXA_X\);
\GRLFPC20_WRDATA_X_61_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010110010101100")
port map (
combout => RFI1_WRDATAZ(29),
dataa => N_425,
datab => \GRLFPC20.WRDATA_0_X\(61),
datac => \GRLFPC20.WRADDR_0_SQMUXA_X\);
\GRLFPC20_WRADDR_1_X_1_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1011100010111000")
port map (
combout => RFI2_WRADDRZ(0),
dataa => N_392,
datab => \GRLFPC20.WRADDR_0_SQMUXA_X\,
datac => \GRLFPC20.COMB.WRADDR_6_X\(1));
\GRLFPC20_WRADDR_1_X_2_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1011100010111000")
port map (
combout => RFI2_WRADDRZ(1),
dataa => N_393,
datab => \GRLFPC20.WRADDR_0_SQMUXA_X\,
datac => \GRLFPC20.COMB.WRADDR_6_X\(2));
\GRLFPC20_RS2_1_X_1_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => RFI2_RD2ADDRZ(0),
dataa => N_388,
datab => N_392,
datac => \GRLFPC20.COMB.RS2_1\(1));
\GRLFPC20_WRDATA_X_21_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010110010101100")
port map (
combout => RFI2_WRDATAZ(21),
dataa => N_417,
datab => \GRLFPC20.WRDATA_0_X\(21),
datac => \GRLFPC20.WRADDR_0_SQMUXA_X\);
\GRLFPC20_WRDATA_X_19_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010110010101100")
port map (
combout => RFI2_WRDATAZ(19),
dataa => N_415,
datab => \GRLFPC20.WRDATA_0_X\(19),
datac => \GRLFPC20.WRADDR_0_SQMUXA_X\);
\GRLFPC20_WRDATA_X_18_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010110010101100")
port map (
combout => RFI2_WRDATAZ(18),
dataa => N_414,
datab => \GRLFPC20.WRDATA_0_X\(18),
datac => \GRLFPC20.WRADDR_0_SQMUXA_X\);
\GRLFPC20_WRDATA_X_9_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010110010101100")
port map (
combout => RFI2_WRDATAZ(9),
dataa => N_405,
datab => \GRLFPC20.WRDATA_0_X\(9),
datac => \GRLFPC20.WRADDR_0_SQMUXA_X\);
\GRLFPC20_WRDATA_X_38_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010110010101100")
port map (
combout => RFI1_WRDATAZ(6),
dataa => N_402,
datab => \GRLFPC20.WRDATA_0_X\(38),
datac => \GRLFPC20.WRADDR_0_SQMUXA_X\);
\GRLFPC20_WRDATA_X_41_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010110010101100")
port map (
combout => RFI1_WRDATAZ(9),
dataa => N_405,
datab => \GRLFPC20.WRDATA_0_X\(41),
datac => \GRLFPC20.WRADDR_0_SQMUXA_X\);
GRLFPC20_COMB_ISFPOP2_1_X: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010110010101100")
port map (
combout => \GRLFPC20.COMB.ISFPOP2_1_X\,
dataa => N_338,
datab => \GRLFPC20.R.I.INST\(19),
datac => \GRLFPC20.COMB.UN1_R.I.V_0\);
\GRLFPC20_WRDATA_X_12_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010110010101100")
port map (
combout => RFI2_WRDATAZ(12),
dataa => N_408,
datab => \GRLFPC20.WRDATA_0_X\(12),
datac => \GRLFPC20.WRADDR_0_SQMUXA_X\);
\GRLFPC20_WRDATA_X_15_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010110010101100")
port map (
combout => RFI2_WRDATAZ(15),
dataa => N_411,
datab => \GRLFPC20.WRDATA_0_X\(15),
datac => \GRLFPC20.WRADDR_0_SQMUXA_X\);
\GRLFPC20_WRDATA_X_20_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010110010101100")
port map (
combout => RFI2_WRDATAZ(20),
dataa => N_416,
datab => \GRLFPC20.WRDATA_0_X\(20),
datac => \GRLFPC20.WRADDR_0_SQMUXA_X\);
\GRLFPC20_WRDATA_X_23_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010110010101100")
port map (
combout => RFI2_WRDATAZ(23),
dataa => N_419,
datab => \GRLFPC20.WRDATA_0_X\(23),
datac => \GRLFPC20.WRADDR_0_SQMUXA_X\);
\GRLFPC20_WRDATA_X_44_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010110010101100")
port map (
combout => RFI1_WRDATAZ(12),
dataa => N_408,
datab => \GRLFPC20.WRDATA_0_X\(44),
datac => \GRLFPC20.WRADDR_0_SQMUXA_X\);
\GRLFPC20_WRDATA_X_47_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010110010101100")
port map (
combout => RFI1_WRDATAZ(15),
dataa => N_411,
datab => \GRLFPC20.WRDATA_0_X\(47),
datac => \GRLFPC20.WRADDR_0_SQMUXA_X\);
\GRLFPC20_WRDATA_X_52_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010110010101100")
port map (
combout => RFI1_WRDATAZ(20),
dataa => N_416,
datab => \GRLFPC20.WRDATA_0_X\(52),
datac => \GRLFPC20.WRADDR_0_SQMUXA_X\);
\GRLFPC20_WRDATA_X_55_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010110010101100")
port map (
combout => RFI1_WRDATAZ(23),
dataa => N_419,
datab => \GRLFPC20.WRDATA_0_X\(55),
datac => \GRLFPC20.WRADDR_0_SQMUXA_X\);
\GRLFPC20_COMB_V_FSR_FCC_1_0_X_0_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1110001011100010")
port map (
combout => \GRLFPC20.COMB.V.FSR.FCC_1_0_X\(0),
dataa => N_406,
datab => \GRLFPC20.V.STATE_0_SQMUXA_1_X\,
datac => \GRLFPC20.R.I.CC\(0));
\GRLFPC20_COMB_V_FSR_FCC_1_0_X_1_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1110001011100010")
port map (
combout => \GRLFPC20.COMB.V.FSR.FCC_1_0_X\(1),
dataa => N_407,
datab => \GRLFPC20.V.STATE_0_SQMUXA_1_X\,
datac => \GRLFPC20.R.I.CC\(1));
\GRLFPC20_WRDATA_X_50_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010110010101100")
port map (
combout => RFI1_WRDATAZ(18),
dataa => N_414,
datab => \GRLFPC20.WRDATA_0_X\(50),
datac => \GRLFPC20.WRADDR_0_SQMUXA_X\);
\GRLFPC20_RS2_1_X_3_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => RFI2_RD2ADDRZ(2),
dataa => N_388,
datab => N_394,
datac => \GRLFPC20.COMB.RS2_1\(3));
\GRLFPC20_RS2_1_X_2_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => RFI2_RD2ADDRZ(1),
dataa => N_388,
datab => N_393,
datac => \GRLFPC20.COMB.RS2_1\(2));
\GRLFPC20_WRDATA_X_8_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010110010101100")
port map (
combout => RFI2_WRDATAZ(8),
dataa => N_404,
datab => \GRLFPC20.WRDATA_0_X\(8),
datac => \GRLFPC20.WRADDR_0_SQMUXA_X\);
\GRLFPC20_WRDATA_X_40_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010110010101100")
port map (
combout => RFI1_WRDATAZ(8),
dataa => N_404,
datab => \GRLFPC20.WRDATA_0_X\(40),
datac => \GRLFPC20.WRADDR_0_SQMUXA_X\);
GRLFPC20_V_FSR_NONSTD_0_SQMUXA_2_X: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0100000001000000")
port map (
combout => \GRLFPC20.V.FSR.NONSTD_0_SQMUXA_2_X\,
dataa => \GRLFPC20.COMB.UN1_FPCI_0_X\,
datab => \GRLFPC20.R.X.AFSR\,
datac => \GRLFPC20.R.X.LD\);
\GRLFPC20_COMB_V_I_RES_6_X_63_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0001001000010010")
port map (
combout => \GRLFPC20.COMB.V.I.RES_6_X\(63),
dataa => N_119,
datab => N_120,
datac => \GRLFPC20.FPI.OP2_X\(63));
\GRLFPC20_WRDATA_X_7_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010110010101100")
port map (
combout => RFI2_WRDATAZ(7),
dataa => N_403,
datab => \GRLFPC20.WRDATA_0_X\(7),
datac => \GRLFPC20.WRADDR_0_SQMUXA_X\);
\GRLFPC20_WRDATA_X_10_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010110010101100")
port map (
combout => RFI2_WRDATAZ(10),
dataa => N_406,
datab => \GRLFPC20.WRDATA_0_X\(10),
datac => \GRLFPC20.WRADDR_0_SQMUXA_X\);
\GRLFPC20_WRDATA_X_24_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010110010101100")
port map (
combout => RFI2_WRDATAZ(24),
dataa => N_420,
datab => \GRLFPC20.WRDATA_0_X\(24),
datac => \GRLFPC20.WRADDR_0_SQMUXA_X\);
\GRLFPC20_WRDATA_X_31_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010110010101100")
port map (
combout => RFI2_WRDATAZ(31),
dataa => N_427,
datab => \GRLFPC20.WRDATA_0_X\(31),
datac => \GRLFPC20.WRADDR_0_SQMUXA_X\);
\GRLFPC20_WRDATA_X_36_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010110010101100")
port map (
combout => RFI1_WRDATAZ(4),
dataa => N_400,
datab => \GRLFPC20.WRDATA_0_X\(36),
datac => \GRLFPC20.WRADDR_0_SQMUXA_X\);
\GRLFPC20_WRDATA_X_39_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010110010101100")
port map (
combout => RFI1_WRDATAZ(7),
dataa => N_403,
datab => \GRLFPC20.WRDATA_0_X\(39),
datac => \GRLFPC20.WRADDR_0_SQMUXA_X\);
\GRLFPC20_WRDATA_X_42_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010110010101100")
port map (
combout => RFI1_WRDATAZ(10),
dataa => N_406,
datab => \GRLFPC20.WRDATA_0_X\(42),
datac => \GRLFPC20.WRADDR_0_SQMUXA_X\);
\GRLFPC20_WRDATA_X_56_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010110010101100")
port map (
combout => RFI1_WRDATAZ(24),
dataa => N_420,
datab => \GRLFPC20.WRDATA_0_X\(56),
datac => \GRLFPC20.WRADDR_0_SQMUXA_X\);
\GRLFPC20_WRDATA_X_63_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010110010101100")
port map (
combout => RFI1_WRDATAZ(31),
dataa => N_427,
datab => \GRLFPC20.WRDATA_0_X\(63),
datac => \GRLFPC20.WRADDR_0_SQMUXA_X\);
\GRLFPC20_R_X_SEQERR_RNIFJ4S_0_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010101110101011")
port map (
combout => \GRLFPC20.UN1_FPCI_22_X\,
dataa => \GRLFPC20.COMB.UN1_FPCI_0_X\,
datab => \GRLFPC20.R.X.FPOP\,
datac => \GRLFPC20.R.X.SEQERR\(0));
\GRLFPC20_WRDATA_X_62_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010110010101100")
port map (
combout => RFI1_WRDATAZ(30),
dataa => N_426,
datab => \GRLFPC20.WRDATA_0_X\(62),
datac => \GRLFPC20.WRADDR_0_SQMUXA_X\);
\GRLFPC20_WRDATA_X_33_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010110010101100")
port map (
combout => RFI1_WRDATAZ(1),
dataa => N_397,
datab => \GRLFPC20.WRDATA_0_X\(33),
datac => \GRLFPC20.WRADDR_0_SQMUXA_X\);
\GRLFPC20_WRDATA_X_30_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010110010101100")
port map (
combout => RFI2_WRDATAZ(30),
dataa => N_426,
datab => \GRLFPC20.WRDATA_0_X\(30),
datac => \GRLFPC20.WRADDR_0_SQMUXA_X\);
\GRLFPC20_WRDATA_X_60_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010110010101100")
port map (
combout => RFI1_WRDATAZ(28),
dataa => N_424,
datab => \GRLFPC20.WRDATA_0_X\(60),
datac => \GRLFPC20.WRADDR_0_SQMUXA_X\);
\GRLFPC20_WRDATA_X_53_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010110010101100")
port map (
combout => RFI1_WRDATAZ(21),
dataa => N_417,
datab => \GRLFPC20.WRDATA_0_X\(53),
datac => \GRLFPC20.WRADDR_0_SQMUXA_X\);
\GRLFPC20_WRDATA_X_28_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010110010101100")
port map (
combout => RFI2_WRDATAZ(28),
dataa => N_424,
datab => \GRLFPC20.WRDATA_0_X\(28),
datac => \GRLFPC20.WRADDR_0_SQMUXA_X\);
\GRLFPC20_WRDATA_X_22_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010110010101100")
port map (
combout => RFI2_WRDATAZ(22),
dataa => N_418,
datab => \GRLFPC20.WRDATA_0_X\(22),
datac => \GRLFPC20.WRADDR_0_SQMUXA_X\);
\GRLFPC20_WRDATA_X_51_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010110010101100")
port map (
combout => RFI1_WRDATAZ(19),
dataa => N_415,
datab => \GRLFPC20.WRDATA_0_X\(51),
datac => \GRLFPC20.WRADDR_0_SQMUXA_X\);
\GRLFPC20_WRDATA_X_54_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010110010101100")
port map (
combout => RFI1_WRDATAZ(22),
dataa => N_418,
datab => \GRLFPC20.WRDATA_0_X\(54),
datac => \GRLFPC20.WRADDR_0_SQMUXA_X\);
\GRLFPC20_WRDATA_X_0_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010110010101100")
port map (
combout => RFI2_WRDATAZ(0),
dataa => N_396,
datab => \GRLFPC20.WRDATA_0_X\(0),
datac => \GRLFPC20.WRADDR_0_SQMUXA_X\);
\GRLFPC20_WRDATA_X_1_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010110010101100")
port map (
combout => RFI2_WRDATAZ(1),
dataa => N_397,
datab => \GRLFPC20.WRDATA_0_X\(1),
datac => \GRLFPC20.WRADDR_0_SQMUXA_X\);
\GRLFPC20_WRDATA_X_5_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010110010101100")
port map (
combout => RFI2_WRDATAZ(5),
dataa => N_401,
datab => \GRLFPC20.WRDATA_0_X\(5),
datac => \GRLFPC20.WRADDR_0_SQMUXA_X\);
\GRLFPC20_RS1_1_X_2_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => RFI2_RD1ADDRZ(1),
dataa => N_388,
datab => N_393,
datac => \GRLFPC20.COMB.RS1_1\(2));
\GRLFPC20_WRDATA_X_58_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010110010101100")
port map (
combout => RFI1_WRDATAZ(26),
dataa => N_422,
datab => \GRLFPC20.WRDATA_0_X\(58),
datac => \GRLFPC20.WRADDR_0_SQMUXA_X\);
\GRLFPC20_WRDATA_X_26_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010110010101100")
port map (
combout => RFI2_WRDATAZ(26),
dataa => N_422,
datab => \GRLFPC20.WRDATA_0_X\(26),
datac => \GRLFPC20.WRADDR_0_SQMUXA_X\);
\GRLFPC20_WRDATA_X_57_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010110010101100")
port map (
combout => RFI1_WRDATAZ(25),
dataa => N_421,
datab => \GRLFPC20.WRDATA_0_X\(57),
datac => \GRLFPC20.WRADDR_0_SQMUXA_X\);
\GRLFPC20_WRDATA_X_37_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010110010101100")
port map (
combout => RFI1_WRDATAZ(5),
dataa => N_401,
datab => \GRLFPC20.WRDATA_0_X\(37),
datac => \GRLFPC20.WRADDR_0_SQMUXA_X\);
\GRLFPC20_WRDATA_X_32_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010110010101100")
port map (
combout => RFI1_WRDATAZ(0),
dataa => N_396,
datab => \GRLFPC20.WRDATA_0_X\(32),
datac => \GRLFPC20.WRADDR_0_SQMUXA_X\);
\GRLFPC20_WRDATA_X_25_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010110010101100")
port map (
combout => RFI2_WRDATAZ(25),
dataa => N_421,
datab => \GRLFPC20.WRDATA_0_X\(25),
datac => \GRLFPC20.WRADDR_0_SQMUXA_X\);
\GRLFPC20_WRDATA_X_4_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010110010101100")
port map (
combout => RFI2_WRDATAZ(4),
dataa => N_400,
datab => \GRLFPC20.WRDATA_0_X\(4),
datac => \GRLFPC20.WRADDR_0_SQMUXA_X\);
\GRLFPC20_RS1_1_X_1_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => RFI2_RD1ADDRZ(0),
dataa => N_388,
datab => N_392,
datac => \GRLFPC20.COMB.RS1_1\(1));
\GRLFPC20_WRDATA_X_48_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010110010101100")
port map (
combout => RFI1_WRDATAZ(16),
dataa => N_412,
datab => \GRLFPC20.WRDATA_0_X\(48),
datac => \GRLFPC20.WRADDR_0_SQMUXA_X\);
\GRLFPC20_WRDATA_X_35_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010110010101100")
port map (
combout => RFI1_WRDATAZ(3),
dataa => N_399,
datab => \GRLFPC20.WRDATA_0_X\(35),
datac => \GRLFPC20.WRADDR_0_SQMUXA_X\);
\GRLFPC20_WRDATA_X_16_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010110010101100")
port map (
combout => RFI2_WRDATAZ(16),
dataa => N_412,
datab => \GRLFPC20.WRDATA_0_X\(16),
datac => \GRLFPC20.WRADDR_0_SQMUXA_X\);
\GRLFPC20_WRDATA_X_6_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010110010101100")
port map (
combout => RFI2_WRDATAZ(6),
dataa => N_402,
datab => \GRLFPC20.WRDATA_0_X\(6),
datac => \GRLFPC20.WRADDR_0_SQMUXA_X\);
\GRLFPC20_WRDATA_X_3_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010110010101100")
port map (
combout => RFI2_WRDATAZ(3),
dataa => N_399,
datab => \GRLFPC20.WRDATA_0_X\(3),
datac => \GRLFPC20.WRADDR_0_SQMUXA_X\);
GRLFPC20_WREN2_1_SQMUXA_1_1_X: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000000100000001")
port map (
combout => \GRLFPC20.WREN2_1_SQMUXA_1_1_X\,
dataa => \GRLFPC20.COMB.UN1_FPCI_0_X\,
datab => \GRLFPC20.R.X.SEQERR\(0),
datac => \GRLFPC20.COMB.UN1_R.I.EXC\);
\GRLFPC20_COMB_V_FSR_CEXC_1_2_A_X_0_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0001110100011101")
port map (
combout => \GRLFPC20.COMB.V.FSR.CEXC_1_2_A_X\(0),
dataa => N_396,
datab => \GRLFPC20.V.STATE_0_SQMUXA_1_X\,
datac => \GRLFPC20.R.I.EXC\(0));
\GRLFPC20_COMB_V_FSR_CEXC_1_2_A_X_1_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0001110100011101")
port map (
combout => \GRLFPC20.COMB.V.FSR.CEXC_1_2_A_X\(1),
dataa => N_397,
datab => \GRLFPC20.V.STATE_0_SQMUXA_1_X\,
datac => \GRLFPC20.R.I.EXC\(1));
\GRLFPC20_COMB_V_FSR_CEXC_1_2_A_X_2_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0001110100011101")
port map (
combout => \GRLFPC20.COMB.V.FSR.CEXC_1_2_A_X\(2),
dataa => N_398,
datab => \GRLFPC20.V.STATE_0_SQMUXA_1_X\,
datac => \GRLFPC20.R.I.EXC\(2));
\GRLFPC20_COMB_V_FSR_CEXC_1_2_A_X_3_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0001110100011101")
port map (
combout => \GRLFPC20.COMB.V.FSR.CEXC_1_2_A_X\(3),
dataa => N_399,
datab => \GRLFPC20.V.STATE_0_SQMUXA_1_X\,
datac => \GRLFPC20.R.I.EXC\(3));
\GRLFPC20_COMB_V_FSR_CEXC_1_2_A_X_4_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0001110100011101")
port map (
combout => \GRLFPC20.COMB.V.FSR.CEXC_1_2_A_X\(4),
dataa => N_400,
datab => \GRLFPC20.V.STATE_0_SQMUXA_1_X\,
datac => \GRLFPC20.R.I.EXC\(4));
GRLFPC20_COMB_SEQERR_UN7_OP_0_A2_X: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1011000010110000")
port map (
combout => \GRLFPC20.COMB.SEQERR.UN7_OP_0_A2_X\,
dataa => N_62,
datab => N_63,
datac => \GRLFPC20.COMB.RDD_1.M14_0_A2_1\);
GRLFPC20_V_STATE_1_SQMUXA_1_X: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1100010011000100")
port map (
combout => \GRLFPC20.V.STATE_1_SQMUXA_1_X\,
dataa => N_424,
datab => N_1,
datac => \GRLFPC20.V.STATE_0_SQMUXA_1_X\);
GRLFPC20_COMB_FPDECODE_FPOP2_0_A2_RNISPI51: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010000000100000")
port map (
combout => \GRLFPC20.R.A.MOV_0_0_G1_0_X\,
dataa => N_74,
datab => N_73,
datac => \GRLFPC20.COMB.FPDECODE.FPOP2_0_A2\);
GRLFPC20_R_X_FPOP_RNIM15L: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010000000100000")
port map (
combout => \GRLFPC20.R.I.PC_1_0_2__G2_X_I\,
dataa => N_3,
datab => \GRLFPC20.COMB.UN1_FPCI_0_X\,
datac => \GRLFPC20.R.X.FPOP\);
GRLFPC20_RS1V_0_SQMUXA_1_X: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1110000011100000")
port map (
combout => \GRLFPC20.RS1V_0_SQMUXA_1_X\,
dataa => \GRLFPC20.COMB.RSDECODE.RS1V2_0\,
datab => \GRLFPC20.COMB.FPDECODE.RDD5_0_A3\,
datac => \GRLFPC20.COMB.FPDECODE.FPOP2_0_A2\);
GRLFPC20_COMB_V_A_LD_1_0_O2_RNIV4FL1: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1110111011101110")
port map (
combout => \GRLFPC20.COMB.V.A.RF2REN_1_0_701_I_948_X\,
dataa => \GRLFPC20.COMB.V.A.RF2REN_1_0_701_I_948_TZ\,
datab => \GRLFPC20.COMB.V.A.LD_1_0_O2\);
GRLFPC20_R_MK_BUSY2_RNO: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000000010000000")
port map (
combout => \GRLFPC20.R.MK.BUSY2_0_0_G0_X\,
dataa => N_1,
datab => \GRLFPC20.R.MK.BUSY\,
datac => \GRLFPC20.R.MK.BUSY2_0_0_G3\);
GRLFPC20_COMB_WREN2_11_IV_1_X: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1110110011101100")
port map (
combout => \GRLFPC20.COMB.WREN2_11_IV_1_X\,
dataa => N_344,
datab => \GRLFPC20.WREN2_1_SQMUXA_1\,
datac => \GRLFPC20.WREN2_2_SQMUXA_1\);
GRLFPC20_COMB_UN7_RS1V_X: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1110111011101110")
port map (
combout => \GRLFPC20.COMB.UN7_RS1V_X\,
dataa => \GRLFPC20.COMB.RS1D_1_U\,
datab => \GRLFPC20.COMB.RS1_1\(0));
GRLFPC20_COMB_UN1_RS1V_X: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1011101110111011")
port map (
combout => \GRLFPC20.COMB.UN1_RS1V_X\,
dataa => \GRLFPC20.COMB.RS1D_1_U\,
datab => \GRLFPC20.COMB.RS1_1\(0));
\GRLFPC20_COMB_V_A_RF1REN_1_1_X_1_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.COMB.V.A.RF1REN_1_1_X\(1),
dataa => \GRLFPC20.COMB.RS1V_1_IV\,
datab => \GRLFPC20.COMB.V.A.RF2REN_1_0_701_I_948_X\);
GRLFPC20_RIN_MK_LDOP_X: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000000010000000")
port map (
combout => \GRLFPC20.RIN.MK.LDOP_X\,
dataa => N_3,
datab => \GRLFPC20.RS2_0_SQMUXA\,
datac => \GRLFPC20.R.A.AFSR_0_0_G1_1\);
\GRLFPC20_COMB_RF2REN_1_0_X_2_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1110010011100100")
port map (
combout => \GRLFPC20.COMB.RF2REN_1_0_X\(2),
dataa => N_3,
datab => \GRLFPC20.R.A.RF2REN\(2),
datac => \GRLFPC20.COMB.V.A.RF2REN_1_0_701_I\);
\GRLFPC20_COMB_RF1REN_1_0_X_2_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1110010011100100")
port map (
combout => \GRLFPC20.COMB.RF1REN_1_0_X\(2),
dataa => N_3,
datab => \GRLFPC20.R.A.RF1REN\(2),
datac => \GRLFPC20.COMB.V.A.RF1REN_1\(2));
GRLFPC20_COMB_WREN1_11_IV_1_X: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1011000010110000")
port map (
combout => \GRLFPC20.COMB.WREN1_11_IV_1_X\,
dataa => \GRLFPC20.COMB.RDD_2\,
datab => \GRLFPC20.COMB.WRADDR_6_X\(0),
datac => \GRLFPC20.COMB.WREN129\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_SCTRL_RNO_7_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000001000100010")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SXC.SCTRL_NEW_0_7__G0\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SXC.SCTRL_NEW\(10),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SXC.SCTRL_NEW\(9),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SXC.SCTRL_NEW\(8),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.SCTRL_39_IV\(0));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_SCTRL_RNO_4_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000000000100000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SXC.SCTRL_NEW\(4),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SXC.SCTRL_NEW\(10),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SXC.SCTRL_NEW\(9),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SXC.SCTRL_NEW\(8),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.SCTRL_39_IV\(0));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_SCTRL_RNO_3_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000010010000100")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SXC.SCTRL_NEW\(3),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SXC.SCTRL_NEW\(9),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SXC.SCTRL_NEW\(8),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.SCTRL_39_IV\(0));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_PXS_PCTRL_NEW_12_31_75_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1111011110000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.PCTRL_NEW_12_31\(75),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.PCTRL_NEW_12_31_S_0\(75),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.PCTRL_NEW_12_30_S\(75),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.PCTRL_NEW_12_27\(75),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.PCTRL_NEW_12_31_D\(75));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_R_SCTRL_39_IV_0_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0001001100000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.SCTRL_39_IV\(0),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL_I_M_1\(13),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.SIGNRESULT_I_M\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.UN29_GRFPUSX_M_381\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.SCTRL_39_IV_0\(0));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_82_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1111111111001110")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.MULTIPLEXORMULXFF.RESULT_1_IV_0_3__G0_0\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.MULTIPLEXORMULXFF.RESULT_1_IV_0_3__G0_0_A5_0_1\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_PCTRL_NEW_43_2_1\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.PCTRL_NEW_12_32\(75),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.MULTIPLEXORMULXFF.RESULT_1_IV_0_3__G0_0_1\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_84_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1011111100000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.MULTIPLEXORMULXFF.RESULT_1_IV_I_0_1__G0\,
dataa => N_52,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOINSTANDNOEXC_41_2\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.PCTRL_NEW_12_32\(75),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.MULTIPLEXORMULXFF.RESULT_1_IV_I_0_1__G0_0\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_PXS_PCTRL_NEW_12_31_D_75_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1110010011100100")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.PCTRL_NEW_12_31_D\(75),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(52),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.PCTRL_NEW_12_15\(75),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.PCTRL_NEW_12_30_D_0\(75));
GRLFPC20_COMB_WREN1_1: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0011101000110000")
port map (
combout => RFI1_WRENZ,
dataa => N_3,
datab => N_391,
datac => \GRLFPC20.WRADDR_0_SQMUXA_X\,
datad => \GRLFPC20.COMB.WREN1_11_IV\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_114_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0100000001000101")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_0_114__G0\,
dataa => \GRLFPC20.FPI.LDOP\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN2_MIXOIN_25\(0),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.DPATH_NEW_7_SQMUXA\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_0_114__G0_A\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_0_114_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0100011101000111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_0_114__G0_A\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_M1\(114),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_M2S2\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_M0\(114));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_0_84_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101111100000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.MULTIPLEXORMULXFF.RESULT_1_IV_I_0_1__G0_0\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.WQSTSETS\(4),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.UN14_CONDITIONAL\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSAMPLEDWAIT\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.MULTIPLEXORMULXFF.RESULT_M4\);
\GRLFPC20_R_FSR_AEXC_RNO_0_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000000010001100")
port map (
combout => \GRLFPC20.R.FSR.AEXC_1_0_0__G1\,
dataa => \GRLFPC20.R.FSR.AEXC\(0),
datab => \GRLFPC20.R.FSR.AEXC_1_0_0__G1_0\,
datac => \GRLFPC20.V.FSR.AEXC_2_SQMUXA\,
datad => \GRLFPC20.COMB.V.FSR.AEXC_7_I_M\(0));
\GRLFPC20_R_FSR_AEXC_RNO_2_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000000010001100")
port map (
combout => \GRLFPC20.R.FSR.AEXC_1_0_2__G1\,
dataa => \GRLFPC20.R.FSR.AEXC\(2),
datab => \GRLFPC20.R.FSR.AEXC_1_0_2__G1_0\,
datac => \GRLFPC20.V.FSR.AEXC_2_SQMUXA\,
datad => \GRLFPC20.COMB.V.FSR.AEXC_7_I_M\(2));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_SCTRL_RNO_13_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1011111100000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.SCTRL_38_IV_I_0_0__G0\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(12),
datab => NN_1,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.UN29_GRFPUSX_M_381\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.SCTRL_38_IV_I_0_0__G0_0\);
\GRLFPC20_R_FSR_AEXC_RNO_3_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000000010001100")
port map (
combout => \GRLFPC20.R.FSR.AEXC_1_0_3__G1\,
dataa => \GRLFPC20.R.FSR.AEXC\(3),
datab => \GRLFPC20.R.FSR.AEXC_1_0_3__G1_0\,
datac => \GRLFPC20.V.FSR.AEXC_2_SQMUXA\,
datad => \GRLFPC20.COMB.V.FSR.AEXC_7_I_M\(3));
\GRLFPC20_R_FSR_AEXC_RNO_4_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000000010001100")
port map (
combout => \GRLFPC20.R.FSR.AEXC_1_0_4__G1\,
dataa => \GRLFPC20.R.FSR.AEXC\(4),
datab => \GRLFPC20.R.FSR.AEXC_1_0_4__G1_0\,
datac => \GRLFPC20.V.FSR.AEXC_2_SQMUXA\,
datad => \GRLFPC20.COMB.V.FSR.AEXC_7_I_M\(4));
\GRLFPC20_R_FSR_AEXC_RNO_1_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000000010001100")
port map (
combout => \GRLFPC20.R.FSR.AEXC_1_0_1__G1\,
dataa => \GRLFPC20.R.FSR.AEXC\(1),
datab => \GRLFPC20.R.FSR.AEXC_1_0_1__G1_0\,
datac => \GRLFPC20.V.FSR.AEXC_2_SQMUXA\,
datad => \GRLFPC20.COMB.V.FSR.AEXC_7_I_M\(1));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_PXS_PCTRL_NEW_12_15_75_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1111001011010000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.PCTRL_NEW_12_15\(75),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(51),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(50),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.PCTRL_NEW_12_15_D\(75),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.PCTRL_NEW_12_6\(75));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_PXS_PCTRL_NEW_12_30_D_0_75_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1111010010110000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.PCTRL_NEW_12_30_D_0\(75),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(50),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(51),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.PCTRL_NEW_12_30_D_0_D_0\(75),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.PCTRL_NEW_12_21\(75));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_60_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1110111111101010")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH\(60),
dataa => \GRLFPC20.FPI.LDOP\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_0_319__G3_0_X2\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.DPATH_NEW_7_SQMUXA\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_M2\(60));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_59_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0100010101000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH\(59),
dataa => \GRLFPC20.FPI.LDOP\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_0_318__G3_0_X2\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.DPATH_NEW_7_SQMUXA\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_M2\(59));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_4_56_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000110100000101")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_4\(56),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(6),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(7),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_4_A\(56),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN2_MIXOIN_25\(0));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_4_A_56_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010011100100111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_4_A\(56),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(7),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_ADD0\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_ADD1\);
GRLFPC20_COMB_WREN2_1: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1100101011000000")
port map (
combout => RFI2_WRENZ,
dataa => N_3,
datab => N_391,
datac => \GRLFPC20.WRADDR_0_SQMUXA_X\,
datad => \GRLFPC20.COMB.WREN2_11_IV\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_R_SCTRL_39_IV_0_0_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000000001111011")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.SCTRL_39_IV_0\(0),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(0),
datab => \GRLFPC20.FPI.LDOP\,
datac => \GRLFPC20.FPI.OP2_X\(63),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL_I_M_0\(12));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_SCTRL_RNO_0_13_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000101011001111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.SCTRL_38_IV_I_0_0__G0_0\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(13),
datab => \GRLFPC20.FPI.OP1_X\(63),
datac => \GRLFPC20.FPI.LDOP\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN2_AREGSIGN_SEL_30\);
GRLFPC20_COMB_WREN1_11_IV: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1111111111011100")
port map (
combout => \GRLFPC20.COMB.WREN1_11_IV\,
dataa => N_344,
datab => \GRLFPC20.WREN1_1_SQMUXA\,
datac => \GRLFPC20.WREN2_2_SQMUXA_1\,
datad => \GRLFPC20.COMB.WREN1_11_IV_1_X\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_MULLSBLOGIC_STCKYPAIR_UN20_STKOUT_RNIOBJES: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1111111011111110")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_0_315__G3\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULLSBLOGIC.STCKYPAIR.UN20_STKOUT\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_0_315__G3_4\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_0_315__G3_S\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_1_84_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000111100010011")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.MULTIPLEXORMULXFF.RESULT_M4\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_PCTRL_NEW_43_2_0\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.MULTIPLEXORMULXFF.RESULT_M1_0_A2\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.PCTRL_I_M_0\(2),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.PCTRL_NEW_12_31\(75));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_PXS_PCTRL_NEW_12_15_D_75_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.PCTRL_NEW_12_15_D\(75),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(50),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.PCTRL_NEW_12_14\(75),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.PCTRL_NEW_12_3\(75));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_PXS_PCTRL_NEW_12_30_D_0_D_0_75_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.PCTRL_NEW_12_30_D_0_D_0\(75),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(50),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.PCTRL_NEW_12_30_D_0_D\(75),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.PCTRL_NEW_12_18\(75));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_58_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0100010101000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH\(58),
dataa => \GRLFPC20.FPI.LDOP\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23_1.CO0\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.DPATH_NEW_7_SQMUXA\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_M2\(58));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_PXS_PCTRL_NEW_12_27_75_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0001101100010001")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.PCTRL_NEW_12_27\(75),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(49),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.UN14_CONDITIONAL\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.CHECKOVANDDENORM.UN13_NOTPOSSIBLEOV\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.UN30_CONDITIONAL_0_2\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_0_82_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000111000000010")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.MULTIPLEXORMULXFF.RESULT_1_IV_0_3__G0_0_A5_0_1\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(57),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.G_37\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.WAITMULXFF.NOTSAMPLEDWAIT\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1\);
\GRLFPC20_R_FSR_AEXC_RNO_0_4_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1100100011111010")
port map (
combout => \GRLFPC20.R.FSR.AEXC_1_0_4__G1_0\,
dataa => N_405,
datab => N_365,
datac => \GRLFPC20.V.STATE_0_SQMUXA_1_X\,
datad => \GRLFPC20.V.FSR.AEXC_1_SQMUXA\);
\GRLFPC20_R_FSR_AEXC_RNO_0_2_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1100100011111010")
port map (
combout => \GRLFPC20.R.FSR.AEXC_1_0_2__G1_0\,
dataa => N_403,
datab => N_363,
datac => \GRLFPC20.V.STATE_0_SQMUXA_1_X\,
datad => \GRLFPC20.V.FSR.AEXC_1_SQMUXA\);
\GRLFPC20_R_FSR_AEXC_RNO_0_1_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1100100011111010")
port map (
combout => \GRLFPC20.R.FSR.AEXC_1_0_1__G1_0\,
dataa => N_402,
datab => N_362,
datac => \GRLFPC20.V.STATE_0_SQMUXA_1_X\,
datad => \GRLFPC20.V.FSR.AEXC_1_SQMUXA\);
\GRLFPC20_R_FSR_AEXC_RNO_0_3_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1100100011111010")
port map (
combout => \GRLFPC20.R.FSR.AEXC_1_0_3__G1_0\,
dataa => N_404,
datab => N_364,
datac => \GRLFPC20.V.STATE_0_SQMUXA_1_X\,
datad => \GRLFPC20.V.FSR.AEXC_1_SQMUXA\);
\GRLFPC20_R_FSR_AEXC_RNO_0_0_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1100100011111010")
port map (
combout => \GRLFPC20.R.FSR.AEXC_1_0_0__G1_0\,
dataa => N_401,
datab => N_361,
datac => \GRLFPC20.V.STATE_0_SQMUXA_1_X\,
datad => \GRLFPC20.V.FSR.AEXC_1_SQMUXA\);
\GRLFPC20_R_FSR_AEXC_RNO_1_0_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000001000000000")
port map (
combout => \GRLFPC20.COMB.V.FSR.AEXC_7_I_M\(0),
dataa => \GRLFPC20.V.STATE_0_SQMUXA_1_X\,
datab => \GRLFPC20.R.FSR.AEXC\(0),
datac => \GRLFPC20.R.I.EXC\(0),
datad => \GRLFPC20.R.I.V_EN_1\);
\GRLFPC20_R_FSR_AEXC_RNO_1_2_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000001000000000")
port map (
combout => \GRLFPC20.COMB.V.FSR.AEXC_7_I_M\(2),
dataa => \GRLFPC20.V.STATE_0_SQMUXA_1_X\,
datab => \GRLFPC20.R.FSR.AEXC\(2),
datac => \GRLFPC20.R.I.EXC\(2),
datad => \GRLFPC20.R.I.V_EN_1\);
\GRLFPC20_R_FSR_AEXC_RNO_1_3_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000001000000000")
port map (
combout => \GRLFPC20.COMB.V.FSR.AEXC_7_I_M\(3),
dataa => \GRLFPC20.V.STATE_0_SQMUXA_1_X\,
datab => \GRLFPC20.R.FSR.AEXC\(3),
datac => \GRLFPC20.R.I.EXC\(3),
datad => \GRLFPC20.R.I.V_EN_1\);
\GRLFPC20_R_FSR_AEXC_RNO_1_4_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000001000000000")
port map (
combout => \GRLFPC20.COMB.V.FSR.AEXC_7_I_M\(4),
dataa => \GRLFPC20.V.STATE_0_SQMUXA_1_X\,
datab => \GRLFPC20.R.FSR.AEXC\(4),
datac => \GRLFPC20.R.I.EXC\(4),
datad => \GRLFPC20.R.I.V_EN_1\);
\GRLFPC20_R_FSR_AEXC_RNO_1_1_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000001000000000")
port map (
combout => \GRLFPC20.COMB.V.FSR.AEXC_7_I_M\(1),
dataa => \GRLFPC20.V.STATE_0_SQMUXA_1_X\,
datab => \GRLFPC20.R.FSR.AEXC\(1),
datac => \GRLFPC20.R.I.EXC\(1),
datad => \GRLFPC20.R.I.V_EN_1\);
GRLFPC20_COMB_WREN2_11_IV: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1111111011110000")
port map (
combout => \GRLFPC20.COMB.WREN2_11_IV\,
dataa => \GRLFPC20.COMB.RDD_2\,
datab => \GRLFPC20.COMB.WRADDR_6_X\(0),
datac => \GRLFPC20.COMB.WREN2_11_IV_1_X\,
datad => \GRLFPC20.COMB.WREN129\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_R_SCTRL_39_IV_0_RNO_0_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000010101000101")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL_I_M_0\(12),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(12),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.WQSCTRL\(68),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL_I_M_0_A\(12),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_ADD57\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_R_SCTRL_39_IV_0_RNO_0_0_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000000011111110")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL_I_M_0_A\(12),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(22),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SXC.SFTLFT.UN4_TEMP\,
datac => \GRLFPC20.FPI.LDOP\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.WQSCTRL_1_0\(67));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_M2S2: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1111111100000010")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_M2S2\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.DPATH_M2_0_0\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.WQSCTRL_1_0\(67),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.DPATH_M2_E\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.DPATH_M2_REP1\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_PXS_PCTRL_NEW_12_18_75_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1110101101000001")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.PCTRL_NEW_12_18\(75),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(49),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(48),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(10),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_4_0_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_4\(0),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(6),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_2\(0),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_1\(0));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_53_TRFWWBASICCELL_TEMP2_RNI2FG5C_0: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0111111011101000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_0_318__G3_0_X2\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.53.TRFWWBASICCELL.CIN\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.CO2\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.CI_114_1.SUM_0_A2\(0),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_0_261__G5\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_4_2_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_4\(2),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(6),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_2\(2),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_1\(2));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN2_MIXOIN_25_0_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0100110011101100")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN2_MIXOIN_25\(0),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULLSBLOGIC.STCKYPAIR.UN22_NOTPROP\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULLSBLOGIC.STCKYPAIR.GEN_3\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.2.CI_56_SUM4\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN2_MIXOIN_19_U\(0));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_316_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0111111011101000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_0_316__G3_0_X2\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.55.TRFWWBASICCELL.CIN_9\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.CI_2_BNC4\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_0_259__G5\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.SI_0_A2\(56));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_PXS_PCTRL_NEW_12_3_75_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0001101100011011")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.PCTRL_NEW_12_3\(75),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(49),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(48),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_4_1_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_4\(1),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(6),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_2\(1),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_1\(1));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_52_TRFWWBASICCELL_TEMP2_RNI0H7CE: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0111111011101000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_0_319__G3_0_X2\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_1299_V\(2),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_1299_ANC3\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.54.SI_117_SUM0\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.53.SI_118_1.CO0\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_UN30_CONDITIONAL_0_2: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000000010000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.UN30_CONDITIONAL_0_2\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.UN30_CONDITIONAL_0_0\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.UN30_CONDITIONAL_M5\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.WQSTSETS\(9));
GRLFPC20_R_I_V_RNO_0: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1111111111111110")
port map (
combout => \GRLFPC20.R.I.V_1_0_G0_0\,
dataa => \GRLFPC20.COMB.UN1_R.I.EXC\,
datab => \GRLFPC20.COMB.ANNULRES_1_IV_454\,
datac => \GRLFPC20.R.I.V_1_0_G0_0_1\,
datad => \GRLFPC20.R.I.V_EN_1\);
GRLFPC20_V_FSR_CEXC_3_SQMUXA: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000000000000010")
port map (
combout => \GRLFPC20.V.FSR.CEXC_3_SQMUXA\,
dataa => \GRLFPC20.V.STATE_0_SQMUXA_1_X\,
datab => \GRLFPC20.V.FSR.NONSTD_0_SQMUXA_2_X\,
datac => \GRLFPC20.COMB.V.STATE14\,
datad => \GRLFPC20.R.I.V_EN_1\);
GRLFPC20_R_I_EXEC_RNO: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000000000000010")
port map (
combout => \GRLFPC20.R.I.EXEC_0_0_G1_0_549_I\,
dataa => \GRLFPC20.R.I.EXEC_0_0_G1_0_I_0_0\,
datab => \GRLFPC20.R.I.EXEC_0_0_G1_0_I_A8_0\,
datac => \GRLFPC20.COMB.ANNULRES_1_IV_454\,
datad => \GRLFPC20.R.I.V_EN_1\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_WQSCTRL_RNILHL93_0_68_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000101000000010")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.DPATH_M2\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.DPATH_M2_0_2\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.WQSCTRL\(68),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.WQSCTRL_1_0\(67),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_ADD57\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_2_84_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0100000001110000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.MULTIPLEXORMULXFF.RESULT_M1_0_A2\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(59),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.G_36\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.MULTIPLEXORMULXFF.RESULT_M1_0_A2_0_1\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.RESULT_0\(1));
GRLFPC20_V_FSR_AEXC_2_SQMUXA: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000000000000010")
port map (
combout => \GRLFPC20.V.FSR.AEXC_2_SQMUXA\,
dataa => \GRLFPC20.V.STATE_0_SQMUXA_1_X\,
datab => \GRLFPC20.V.FSR.NONSTD_0_SQMUXA_2_X\,
datac => \GRLFPC20.COMB.V.FSR.FCC10\,
datad => \GRLFPC20.COMB.WREN129\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_XZBREGLOADEN: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000000000001110")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.XZBREGLOADEN\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(3),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(4),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.WQSCTRL_1_0\(67),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.DPATH_M2_E\);
GRLFPC20_V_FSR_AEXC_1_SQMUXA_0_RNIL956: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000000011111101")
port map (
combout => \GRLFPC20.COMB.V.FSR.CEXC_1_SN_M3\,
dataa => \GRLFPC20.V.FSR.AEXC_1_SQMUXA_0\,
datab => \GRLFPC20.COMB.V.STATE14\,
datac => \GRLFPC20.COMB.V.FSR.FCC10\,
datad => \GRLFPC20.V.FSR.CEXC_3_SQMUXA\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_4_3_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_4\(3),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(6),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_2\(3),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_1\(3));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_2_0_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1110001011100010")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_2\(0),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(1),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(7),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_8_1.SUM_0_A2\(0));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_2_2_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1110001011100010")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_2\(2),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(3),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(7),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.54.SI_117_SUM1\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_MULLSBLOGIC_STCKYPAIR_GEN_3: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1111111010000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULLSBLOGIC.STCKYPAIR.GEN_3\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.0.TRFWWBASICCELL.CIN_1\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.2.CI_56_C1\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.3.CI_55_ADD1\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.3.CI_55_ADD2\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_WQSCTRL_RNIENRC2_68_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000010100000001")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.UN29_GRFPUSX_M_381\,
dataa => \GRLFPC20.FPI.LDOP\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.WQSCTRL\(68),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.WQSCTRL_1_0\(67),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_ADD57\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN2_AREGSIGN_SEL_30: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1111111111110001")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN2_AREGSIGN_SEL_30\,
dataa => NN_1,
datab => \GRLFPC20.FPI.LDOP\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.WQSCTRL_1_0\(67),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.DPATH_M2_E\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_XZAREGLOADEN: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000101000000010")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.XZAREGLOADEN\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.CTRLAREGXZ.UN5_XZAREGLOADEN\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.WQSCTRL\(68),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.WQSCTRL_1_0\(67),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_ADD57\);
\GRLFPC20_COMB_RF1REN_1_2_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1011111110110000")
port map (
combout => RFI1_REN2Z,
dataa => N_390,
datab => N_389,
datac => N_388,
datad => \GRLFPC20.COMB.RF1REN_1_0_X\(2));
\GRLFPC20_COMB_V_FSR_FCC_1_1_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1100110011100100")
port map (
combout => \GRLFPC20.COMB.V.FSR.FCC_1\(1),
dataa => \GRLFPC20.V.STATE_0_SQMUXA_1_X\,
datab => \GRLFPC20.COMB.V.FSR.FCC_1_0_X\(1),
datac => \GRLFPC20.COMB.V.FSR.FCC_1_1_X\(1),
datad => \GRLFPC20.COMB.V.FSR.FCC10\);
\GRLFPC20_COMB_V_FSR_FCC_1_0_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1100110011100100")
port map (
combout => \GRLFPC20.COMB.V.FSR.FCC_1\(0),
dataa => \GRLFPC20.V.STATE_0_SQMUXA_1_X\,
datab => \GRLFPC20.COMB.V.FSR.FCC_1_0_X\(0),
datac => \GRLFPC20.COMB.V.FSR.FCC_1_1_X\(0),
datad => \GRLFPC20.COMB.V.FSR.FCC10\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_DPATH_NEW_23_1_CO0: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1111100010000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23_1.CO0\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.54.TRFWWBASICCELL.TEMP2\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN50_ZERO\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.CI_114_1.CO0\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.SI_0_A2\(56));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_2_1_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1110001011100010")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_2\(1),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(2),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(7),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23_1.SUM_0_A2\(0));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_XZZERO_1: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000000000000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_51\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_53\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_52\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_54\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_53_TRFWWBASICCELL_TEMP2_RNI2FG5C: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0110100110010110")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.54.SI_117_SUM1\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.53.TRFWWBASICCELL.CIN\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.CO2\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.CI_114_1.SUM_0_A2\(0),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_0_261__G5\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_MULLSBLOGIC_STCKYPAIR_UN36_STKGEN: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1110100000010111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULLSBLOGIC.STCKYPAIR.UN36_STKGEN\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.0.TRFWWBASICCELL.CIN_1\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.2.CI_56_C1\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.3.CI_55_ADD1\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULLSBLOGIC.STCKYPAIR.UN36_STKGEN_0\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_R_SCTRL_39_IV_RNO_0_0_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0100110001000100")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.SIGNRESULT_I_M\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.WQSCTRL\(68),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.SIGNRESULT_I_M_2\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.UN23_EXPXBUS_NE\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_ADD57\);
GRLFPC20_R_MK_BUSY_RNO: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000000000100000")
port map (
combout => \GRLFPC20.R.MK.BUSY_0_0_G0\,
dataa => \GRLFPC20.R.MK.BUSY_0_0_G0_0_X\,
datab => \GRLFPC20.FPI.LDOP_2\,
datac => \GRLFPC20.R.MK.BUSY2_0_0_G3\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.BUSYMULXFF.UN2_TEMP\);
GRLFPC20_R_MK_RST_RNO: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000000000001000")
port map (
combout => \GRLFPC20.COMB.V.MK.RST_1_0_G0\,
dataa => \GRLFPC20.COMB.V.MK.RST_1_0_G0_1_0_X\,
datab => CPO_HOLDNZ,
datac => \GRLFPC20.R.MK.BUSY2_0_0_G3\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.BUSYMULXFF.UN2_TEMP\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_DPATH_NEW_8_1_SUM_0_A2_0_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0110100110010110")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_8_1.SUM_0_A2\(0),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.55.TRFWWBASICCELL.CIN_9\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.CI_2_BNC4\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_0_259__G5\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.SI_0_A2\(56));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_DPATH_NEW_23_1_SUM_0_A2_0_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000011101111000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23_1.SUM_0_A2\(0),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.54.TRFWWBASICCELL.TEMP2\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN50_ZERO\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.CI_114_1.CO0\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.SI_0_A2\(56));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_258_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000011101111000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_0_258__G3\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.TRFWWBASICCELL.TEMP2\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN50_ZERO\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.CI_114_1.CO0\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.SI_0_A2\(56));
GRLFPC20_V_FSR_AEXC_1_SQMUXA: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000100010001000")
port map (
combout => \GRLFPC20.V.FSR.AEXC_1_SQMUXA\,
dataa => \GRLFPC20.V.STATE_0_SQMUXA_1_X\,
datab => \GRLFPC20.V.FSR.NONSTD_0_SQMUXA_2_X\,
datac => \GRLFPC20.COMB.ISFPOP2_1_X\,
datad => \GRLFPC20.COMB.V.FSR.FCC10_1\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_2_3_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1110001011100010")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_2\(3),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(4),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(7),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_8_1.SUM_0\(0));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_0_TRFWWBASICCELL_TEMP2_3_RNIK5TVA: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0001011111101000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.2.CI_56_SUM4\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.0.TRFWWBASICCELL.CIN_1\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.2.CI_56_C1\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.3.CI_55_ADD1\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.3.CI_55_ADD2\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_PXS_PCTRL_NEW_12_14_75_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010011010010101")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.PCTRL_NEW_12_14\(75),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(48),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(51),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.PCTRL_NEW_12_12\(75),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.PCTRL_NEW_12_9\(75));
\GRLFPC20_COMB_RF2REN_1_2_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1011111110110000")
port map (
combout => RFI2_REN2Z,
dataa => N_390,
datab => N_389,
datac => N_388,
datad => \GRLFPC20.COMB.RF2REN_1_0_X\(2));
\GRLFPC20_COMB_RF1REN_1_1_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1011111110110000")
port map (
combout => RFI1_REN1Z,
dataa => N_390,
datab => N_389,
datac => N_388,
datad => \GRLFPC20.COMB.RF1REN_1_0\(1));
\GRLFPC20_COMB_RF2REN_1_1_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1011111110110000")
port map (
combout => RFI2_REN1Z,
dataa => N_390,
datab => N_389,
datac => N_388,
datad => \GRLFPC20.COMB.RF2REN_1_0\(1));
GRLFPC20_COMB_V_FSR_FCC10_1_RNI2I2J: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101000011010000")
port map (
combout => \GRLFPC20.R.I.V_EN_1\,
dataa => \GRLFPC20.R.X.LD\,
datab => \GRLFPC20.COMB.ISFPOP2_1_X\,
datac => \GRLFPC20.COMB.V.FSR.FCC10_1\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_UN30_CONDITIONAL_0_0: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000000000110010")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.UN30_CONDITIONAL_0_0\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.UN23_EXPXBUS_NE_8\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUE_ADD11\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.UN23_EXPXBUS_NE_10\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUE_ADD12\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_MULLSBLOGIC_STCKYPAIR_UN12_STKOUT_RNIUR8UA: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1111111011111100")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_0_315__G3_4\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULLSBLOGIC.STCKYPAIR.UN16_NOTPROP\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULLSBLOGIC.STCKYPAIR.UN12_STKOUT\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_0_315__G3_2\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN2_MIXOIN_9\(0));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_85_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1011111100000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.MULTIPLEXORMULXFF.RESULT_1_IV_I_0_0__G0\,
dataa => N_53,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOINSTANDNOEXC_41_2\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.PCTRL_NEW_12_32\(75),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.MULTIPLEXORMULXFF.RESULT_1_IV_I_0_0__G0_0\);
\GRLFPC20_COMB_V_A_RF1REN_1_2_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1100010000000000")
port map (
combout => \GRLFPC20.COMB.V.A.RF1REN_1\(2),
dataa => N_43,
datab => \GRLFPC20.RS2_0_SQMUXA\,
datac => \GRLFPC20.COMB.RS2D_1_IV\,
datad => \GRLFPC20.COMB.V.A.AFSR_1_5_0_O2\);
GRLFPC20_COMB_WREN129: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0001000000010000")
port map (
combout => \GRLFPC20.COMB.WREN129\,
dataa => \GRLFPC20.R.X.LD\,
datab => \GRLFPC20.COMB.ISFPOP2_1_X\,
datac => \GRLFPC20.COMB.V.FSR.FCC10_1\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_BUSYMULXFF_UN2_TEMP: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1100000010000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.BUSYMULXFF.UN2_TEMP\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.PCTRL_NEW_12_32_0\(75),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.BUSYMULXFF.UN2_TEMP_1\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.BUSYMULXFF.UN2_TEMP_2\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.PCTRL_NEW_12_31\(75));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_DPATH_NEW_8_1_SUM_0_0_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0110100110010110")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_8_1.SUM_0\(0),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_1299_V\(2),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_1299_ANC3\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.54.SI_117_SUM0\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.53.SI_118_1.CO0\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_PCTRL_NEW_43_1_RNIJ1GT: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1110110011101100")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_PCTRL_NEW_43_2_0\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.PCTRL_NEW_12_32_0\(75),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.WAITMULXFF.NOTSAMPLEDWAIT\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_PCTRL_NEW_43_1\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_EXPADDERSHFT_UN23_EXPXBUS_NE_8_RNIIQ021: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010111110001111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.WQSCTRL_1_0\(67),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.WQSCTRL\(68),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.UN23_EXPXBUS_NE_8\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.UN2_NOTABORTWB\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.UN23_EXPXBUS_NE_10\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_5_57_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000111000000010")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_5\(57),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(173),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(6),
datac => \GRLFPC20.FPI.LDOP\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_0\(57));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_MULLSBLOGIC_STCKYPAIR_UN20_STKOUT: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0001101101011111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULLSBLOGIC.STCKYPAIR.UN20_STKOUT\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULLSBLOGIC.STCKYPAIR.UN16_NOTPROP\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULLSBLOGIC.STCKYPAIR.UN27_STKGEN\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.CI_57_SUM3\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN2_MIXOIN_9\(0));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN2_MIXOIN_19_U_0_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000000011110111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN2_MIXOIN_19_U\(0),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULLSBLOGIC.STCKYPAIR.UN16_NOTPROP\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.CI_57_SUM3\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN2_MIXOIN_9\(0),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULLSBLOGIC.STCKYPAIR.GEN_2\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_CI_114_1_CO0: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000000011111000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.CI_114_1.CO0\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.55.TRFWWBASICCELL.TEMP2_3\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN35_ZERO\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.CI_2_C2\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.SI_1_0_A2\(56));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_71_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0101000011011100")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.UN38_PCTRL_NEW_I_0_G0\,
dataa => \GRLFPC20.FPI.LDOP_2\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.TEMP_20\,
datac => \GRLFPC20.RIN.MK.LDOP_X\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.BUSYMULXFF.UN2_TEMP_1\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_0_67_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1100111011001100")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.PCTRL_NEW_6_0_67__G0_E_I\,
dataa => N_3,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(65),
datac => \GRLFPC20.FPI.LDOP_2\,
datad => \GRLFPC20.R.A.FPOP_0_0_G1\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_PXS_RESULT_0_1_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011101")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.RESULT_0\(1),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.FEEDBACKMULXFF.UN7_FEEDBACK_1\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SXC.SFTLFT.AREGXORBREG\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUE_ADD12\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.UN23_EXPXBUS_NE\);
\GRLFPC20_COMB_RF2REN_1_0_1_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1110010001000100")
port map (
combout => \GRLFPC20.COMB.RF2REN_1_0\(1),
dataa => N_3,
datab => \GRLFPC20.R.A.RF2REN\(1),
datac => \GRLFPC20.COMB.UN7_RS1V_X\,
datad => \GRLFPC20.COMB.V.A.RF1REN_1_1_X\(1));
\GRLFPC20_COMB_RF1REN_1_0_1_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1110010001000100")
port map (
combout => \GRLFPC20.COMB.RF1REN_1_0\(1),
dataa => N_3,
datab => \GRLFPC20.R.A.RF1REN\(1),
datac => \GRLFPC20.COMB.UN1_RS1V_X\,
datad => \GRLFPC20.COMB.V.A.RF1REN_1_1_X\(1));
GRLFPC20_COMB_V_FSR_FCC10: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000000000001000")
port map (
combout => \GRLFPC20.COMB.V.FSR.FCC10\,
dataa => \GRLFPC20.COMB.ISFPOP2_1_X\,
datab => \GRLFPC20.COMB.UN1_R.I.V\,
datac => \GRLFPC20.COMB.V.STATE\,
datad => \GRLFPC20.R.STATE_0_0_0__G3\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_2_82_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1110110000000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.MULTIPLEXORMULXFF.RESULT_1_IV_0_3__G0_0_1\,
dataa => N_54,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.MULTIPLEXORMULXFF.RESULT_1_IV_0_3__G0_0_A5_0_0\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOINSTANDNOEXC_41_2\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.PCTRL_NEW_12_32\(75));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_0_85_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000000001010001")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.MULTIPLEXORMULXFF.RESULT_1_IV_I_0_0__G0_0\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.OPREXCSHFT.UN13_EXMIPTRLSBS_M\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.MULTIPLEXORMULXFF.RESULT_M1_0_A2_2\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.PCTRL_NEW_12_31\(75),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.MULTIPLEXORMULXFF.RESULT_1_IV_I_0_0__G0_0_A\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_3_85_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0101000001000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.MULTIPLEXORMULXFF.RESULT_1_IV_I_0_0__G0_0_A\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.PCTRL\(1),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_PCTRL_NEW_43_2_0\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_PCTRL_NEW_43_2_C\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.PCTRL_NEW_12_31\(75));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_XZZERO_1_52: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000000000000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_52\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_11\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_9\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_12\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_35\);
\GRLFPC20_R_A_RF1REN_RNO_1_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000110000000000")
port map (
combout => \GRLFPC20.COMB.V.A.RF1REN_1_670_I\,
dataa => \GRLFPC20.COMB.RS1D_1_U\,
datab => \GRLFPC20.COMB.RS1V_1_IV\,
datac => \GRLFPC20.COMB.V.A.RF1REN_1_670_I_M4\,
datad => \GRLFPC20.COMB.V.A.RF2REN_1_0_701_I_948_X\);
\GRLFPC20_R_A_RF2REN_RNO_1_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1100100000000000")
port map (
combout => \GRLFPC20.COMB.V.A.RF2REN_1_734_I\,
dataa => \GRLFPC20.COMB.RS1D_1_U\,
datab => \GRLFPC20.COMB.RS1V_1_IV\,
datac => \GRLFPC20.COMB.V.A.RF1REN_1_670_I_M4\,
datad => \GRLFPC20.COMB.V.A.RF2REN_1_0_701_I_948_X\);
\GRLFPC20_R_STATE_RNO_0_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0100110000000000")
port map (
combout => \GRLFPC20.R.STATE_0_0_0__G1\,
dataa => N_5,
datab => \GRLFPC20.V.STATE_1_SQMUXA_1_X\,
datac => CPO_EXCZ,
datad => \GRLFPC20.R.STATE_0_0_0__G3\);
GRLFPC20_COMB_V_FSR_FCC10_1: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000001000000010")
port map (
combout => \GRLFPC20.COMB.V.FSR.FCC10_1\,
dataa => \GRLFPC20.COMB.UN1_R.I.V\,
datab => \GRLFPC20.COMB.V.STATE\,
datac => \GRLFPC20.R.STATE_0_0_0__G3\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_BUSYMULXFF_UN2_TEMP_1_RNIQG4O3: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1111111100000100")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_PCTRL_NEW_43_2_C\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.PCTRL_NEW\(77),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.STARTSHFT.UN3_NOTRESETORUNIMP\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.BUSYMULXFF.UN2_TEMP_1\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_PCTRL_NEW_43_2_0\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_55_TRFWWBASICCELL_CIN_10_RNI571R5: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0110000011110110")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_0_261__G5\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.54.TRFWWBASICCELL.CIN\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.CO0\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.CI_58_2.ANC1\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.SI_1_0_A2\(56));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_0_57_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010111000101110")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_0\(57),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(115),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(7),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES\(57));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_CI_114_1_SUM_0_A2_0_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0111100010000111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.CI_114_1.SUM_0_A2\(0),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.55.TRFWWBASICCELL.TEMP2_3\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN35_ZERO\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.CI_2_C2\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.SI_1_0_A2\(56));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_MULLSBLOGIC_TEMP_RNIVRVM5_0_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0110100110010110")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULLSBLOGIC.STCKYPAIR.UN22_NOTPROP\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULLSBLOGIC.TEMP\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.0.TRFWWBASICCELL.CIN_1\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.2.CI_56_C1\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.3.CI_55_ADD1\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_MULLSBLOGIC_STCKYPAIR_GEN_2: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1111111101100000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULLSBLOGIC.STCKYPAIR.GEN_2\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.2.CI_56_C0\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.2.CI_56_SUM1_0\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.CI_57_C1\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULLSBLOGIC.STCKYPAIR.UN19_GEN\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_55_TRFWWBASICCELL_TEMP2_3_RNIH2UH4: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000000001111000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_0_259__G5\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.55.TRFWWBASICCELL.TEMP2_3\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN35_ZERO\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.CI_2_C2\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.SI_1_0_A2\(56));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_PXS_PCTRL_NEW_12_9_75_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0100010001001110")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.PCTRL_NEW_12_9\(75),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(49),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(244),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.UN23_EXPXBUS_NE_8\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.UN23_EXPXBUS_NE_10\);
GRLFPC20_FPI_START: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000100000000000")
port map (
combout => \GRLFPC20.FPI.START\,
dataa => N_3,
datab => \GRLFPC20.RS2_0_SQMUXA\,
datac => \GRLFPC20.FPI.LDOP_2\,
datad => \GRLFPC20.R.A.AFSR_0_0_G1_1\);
GRLFPC20_COMB_RS2D_1_IV_RNIR8PB2: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1111100000000000")
port map (
combout => \GRLFPC20.COMB.V.A.RF2REN_1_0_701_I\,
dataa => N_43,
datab => \GRLFPC20.RS2_0_SQMUXA\,
datac => \GRLFPC20.COMB.RS2D_1_IV\,
datad => \GRLFPC20.COMB.V.A.RF2REN_1_0_701_I_948_X\);
\GRLFPC20_R_STATE_RNO_1_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1100110010000000")
port map (
combout => \GRLFPC20.R.STATE_0_0_1__G1\,
dataa => N_5,
datab => \GRLFPC20.V.STATE_1_SQMUXA_1_X\,
datac => CPO_EXCZ,
datad => \GRLFPC20.COMB.V.STATE\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_53_SI_118_1_CO0: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1110100011101000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.53.SI_118_1.CO0\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_1299_SUM3\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.CI_2_SUM2\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.54.SI_61_1.CO0\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_TRFWWBASICCELL_TEMP2_3_RNIPCSJ4: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0111100010000111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.SI_0_A2\(56),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.TRFWWBASICCELL.TEMP2_3\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN35_ZERO\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.CI_2_C2\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.SI_1_0_A2\(56));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_BUSYMULXFF_UN2_TEMP_2: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000100000000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.BUSYMULXFF.UN2_TEMP_2\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(68),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(70),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.PCTRL_NEW\(77),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.PCTRL_NEW_2_0_65__G3\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_MULLSBLOGIC_STCKYPAIR_UN4_STKOUT_RNIPBJK7: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1111110011111110")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_0_315__G3_2\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULLSBLOGIC.STCKYPAIR.UN10_NOTPROP_0_0_A3\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULLSBLOGIC.STCKYPAIR.UN4_STKOUT\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_0_315__G3_0\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULLSBLOGIC.STCKYPAIR.UN16_NOTPROP\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOINSTANDNOEXC_41_2: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010000000100000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOINSTANDNOEXC_41_2\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOINSTANDNOEXC_41_2_0\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.WAITMULXFF.NOTSAMPLEDWAIT\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.STARTSHFT.UN3_NOTRESETORUNIMP\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_PCTRL_NEW_43_1: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000010000000100")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_PCTRL_NEW_43_1\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.PCTRL_NEW\(77),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.STARTSHFT.UN3_NOTRESETORUNIMP\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.BUSYMULXFF.UN2_TEMP_1\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_MULLSBLOGIC_STCKYPAIR_UN27_STKGEN: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1001011001101001")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULLSBLOGIC.STCKYPAIR.UN27_STKGEN\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.2.CI_56_V\(1),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.3.CI_55_ADD0\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.2.CI_56_C0\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULLSBLOGIC.STCKYPAIR.UN27_STKGEN_A\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_MULLSBLOGIC_STCKYPAIR_UN27_STKGEN_A: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0111111011101000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULLSBLOGIC.STCKYPAIR.UN27_STKGEN_A\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULLSBLOGIC.TEMP_0\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.CI_57_C0\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.0.TRFWWBASICCELL.CIN\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.2.CI_56_SUM0\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_55_TRFWWBASICCELL_CIN_10_RNI571R5_0: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1001011001101001")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.54.SI_117_SUM0\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.54.TRFWWBASICCELL.CIN\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.CO0\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.CI_58_2.ANC1\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.SI_1_0_A2\(56));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSAMPLEDWAIT: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010000000100000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSAMPLEDWAIT\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.PCTRL_NEW\(77),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.WAITMULXFF.NOTSAMPLEDWAIT\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.STARTSHFT.UN3_NOTRESETORUNIMP\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_EXPADDERSHFT_UN23_EXPXBUS_NE: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1110111011101110")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.UN23_EXPXBUS_NE\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.UN23_EXPXBUS_NE_8\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.UN23_EXPXBUS_NE_10\);
\GRLFPC20_R_STATE_RNIES063_0_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1111100011110000")
port map (
combout => \GRLFPC20.R.STATE_0_0_0__G3\,
dataa => \GRLFPC20.R.STATE\(0),
datab => \GRLFPC20.UN1_FPCI_2\,
datac => \GRLFPC20.R.STATE_0_0_0__G3_0\,
datad => \GRLFPC20.R.FSR.FTT_1_0_2__G2_490\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_53_SI_118_1_SUM_0_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1001011010010110")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.53.SI_118_1.SUM\(0),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_1299_SUM3\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.CI_2_SUM2\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.54.SI_61_1.CO0\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_57_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1011000110100000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES\(57),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(45),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRTOSTICKY\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES_0\(57),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.NOTSTICKYINFORSR_0\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_MULLSBLOGIC_STCKYPAIR_UN19_GEN: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1111011000000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULLSBLOGIC.STCKYPAIR.UN19_GEN\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.2.CI_56_C0\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.2.CI_56_SUM1_0\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.CI_57_C1_1\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULLSBLOGIC.STCKYPAIR.UN16_NOTPROP_0\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_0_TRFWWBASICCELL_TEMP2_RNI486R4: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0110100110010110")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.CI_57_SUM3\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.2.CI_56_V\(1),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.3.CI_55_ADD0\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.2.CI_56_C0\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.CI_57_C1\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_55_TRFWWBASICCELL_TEMP2_3_RNI014I2: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000000010000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.CI_2_BNC4\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.55.TRFWWBASICCELL.TEMP2_3\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN35_ZERO\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.CI_2_C2\);
\GRLFPC20_R_I_EXC_RNO_2_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1111111000000010")
port map (
combout => \GRLFPC20.R.I.EXC_2_0_2__G0\,
dataa => \GRLFPC20.R.I.EXC\(2),
datab => \GRLFPC20.COMB.UN2_HOLDN\,
datac => \GRLFPC20.COMB.UN19_IUEXEC\,
datad => \GRLFPC20.R.I.EXC_2_0_2__G3\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_3_82_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000000000001110")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.MULTIPLEXORMULXFF.RESULT_1_IV_0_3__G0_0_A5_0_0\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(65),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(66),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.PCTRL_NEW_11_0_69__G2_0_529_A3\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.WAITMULXFF.NOTSAMPLEDWAIT\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_XZZERO_1_35: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000000010000100")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_35\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZXBUS\(45),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_6\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(45),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_35_A\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_XZZERO_1_35_A: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0111100011111111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_35_A\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(75),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(17),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(40),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_4\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_EXPADDERSHFT_UN23_EXPXBUS_NE_8: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1111111011111101")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.UN23_EXPXBUS_NE_8\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.UN23_EXPXBUS_1_0\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.UN23_EXPXBUS_NE_5\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.UN23_EXPXBUS_NE_6\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(1));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_81_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1011111100000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.MULTIPLEXORMULXFF.RESULT_1_IV_I_0_4__G0\,
dataa => N_49,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOINSTANDNOEXC_41_2\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.PCTRL_NEW_12_32\(75),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.MULTIPLEXORMULXFF.RESULT_1_IV_I_0_4__G0_0\);
GRLFPC20_R_A_AFSR_RNO: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000010000000000")
port map (
combout => \GRLFPC20.R.A.AFSR_0_0_G1\,
dataa => N_66,
datab => \GRLFPC20.R.A.AFSR_0_0_G1_1_0\,
datac => \GRLFPC20.COMB.FPDECODE.FPOP8_I_O3_X\,
datad => \GRLFPC20.R.A.AFSR_0_0_G1_1\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_83_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1011111100000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.MULTIPLEXORMULXFF.RESULT_1_IV_I_0_2__G0\,
dataa => N_50,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOINSTANDNOEXC_41_2\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.PCTRL_NEW_12_32\(75),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.MULTIPLEXORMULXFF.RESULT_1_IV_I_0_2__G0_0\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_65_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1011101111111011")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.PCTRL_NEW_2_0_65__G0\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(64),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(68),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(66),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.PCTRL_NEW_11_0_69__G2_0_529_A3\);
GRLFPC20_R_A_AFQ_RNO: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000100000000000")
port map (
combout => \GRLFPC20.R.A.AFQ_0_0_G1\,
dataa => \GRLFPC20.N_1243_I_0_A2_1_X\,
datab => \GRLFPC20.R.A.AFQ_0_0_G1_0\,
datac => CPO_EXCZ,
datad => \GRLFPC20.COMB.V.A.AFSR_1_5_0_O2\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_55_TRFWWBASICCELL_TEMP2_2_RNIANRT1: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1111100010000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.CI_2_C2\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.55.TRFWWBASICCELL.TEMP2_2\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN20_ZERO\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.CI_2_C0\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.CI_114_1.SUM_5_0_A2\(0));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_1_TRFWWBASICCELL_TEMP2_RNITGSH2: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1111100010000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.2.CI_56_C1\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.1.TRFWWBASICCELL.TEMP2\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN20_ZERO\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.3.CI_55_ADD0\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.2.CI_56_C0\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_5_10_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1111001011010000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_5\(10),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(6),
datab => \GRLFPC20.FPI.LDOP\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_3\(10),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_0\(10));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_5_12_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1111001011010000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_5\(12),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(6),
datab => \GRLFPC20.FPI.LDOP\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_3\(12),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_0\(12));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_5_13_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1111001011010000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_5\(13),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(6),
datab => \GRLFPC20.FPI.LDOP\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_3\(13),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_0\(13));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_5_16_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1111001011010000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_5\(16),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(6),
datab => \GRLFPC20.FPI.LDOP\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_3\(16),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_0\(16));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_5_40_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1111001011010000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_5\(40),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(6),
datab => \GRLFPC20.FPI.LDOP\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_3\(40),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_0\(40));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_5_42_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1111001011010000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_5\(42),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(6),
datab => \GRLFPC20.FPI.LDOP\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_3\(42),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_0\(42));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_5_44_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1111001011010000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_5\(44),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(6),
datab => \GRLFPC20.FPI.LDOP\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_3\(44),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_0\(44));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_5_48_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1111001011010000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_5\(48),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(6),
datab => \GRLFPC20.FPI.LDOP\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_3\(48),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_0\(48));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_5_50_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1111001011010000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_5\(50),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(6),
datab => \GRLFPC20.FPI.LDOP\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_3\(50),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_0\(50));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_5_49_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1111001011010000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_5\(49),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(6),
datab => \GRLFPC20.FPI.LDOP\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_3\(49),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_0\(49));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_5_51_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1111001011010000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_5\(51),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(6),
datab => \GRLFPC20.FPI.LDOP\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_3\(51),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_0\(51));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_5_56_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000111000000010")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_5\(56),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(172),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(6),
datac => \GRLFPC20.FPI.LDOP\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_0\(56));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_5_11_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1111001011010000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_5\(11),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(6),
datab => \GRLFPC20.FPI.LDOP\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_3\(11),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_0\(11));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_5_14_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1111001011010000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_5\(14),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(6),
datab => \GRLFPC20.FPI.LDOP\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_3\(14),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_0\(14));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_5_17_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1111001011010000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_5\(17),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(6),
datab => \GRLFPC20.FPI.LDOP\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_3\(17),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_0\(17));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_5_19_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1111001011010000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_5\(19),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(6),
datab => \GRLFPC20.FPI.LDOP\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_3\(19),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_0\(19));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_5_20_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1111001011010000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_5\(20),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(6),
datab => \GRLFPC20.FPI.LDOP\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_3\(20),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_0\(20));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_5_22_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1111001011010000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_5\(22),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(6),
datab => \GRLFPC20.FPI.LDOP\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_3\(22),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_0\(22));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_5_24_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1111001011010000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_5\(24),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(6),
datab => \GRLFPC20.FPI.LDOP\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_3\(24),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_0\(24));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_5_25_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1111001011010000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_5\(25),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(6),
datab => \GRLFPC20.FPI.LDOP\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_3\(25),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_0\(25));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_5_26_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1111001011010000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_5\(26),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(6),
datab => \GRLFPC20.FPI.LDOP\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_3\(26),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_0\(26));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_5_28_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1111001011010000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_5\(28),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(6),
datab => \GRLFPC20.FPI.LDOP\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_3\(28),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_0\(28));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_5_30_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1111001011010000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_5\(30),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(6),
datab => \GRLFPC20.FPI.LDOP\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_3\(30),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_0\(30));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_5_31_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1111001011010000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_5\(31),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(6),
datab => \GRLFPC20.FPI.LDOP\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_3\(31),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_0\(31));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_5_33_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1111001011010000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_5\(33),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(6),
datab => \GRLFPC20.FPI.LDOP\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_3\(33),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_0\(33));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_5_34_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1111001011010000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_5\(34),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(6),
datab => \GRLFPC20.FPI.LDOP\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_3\(34),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_0\(34));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_5_37_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1111001011010000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_5\(37),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(6),
datab => \GRLFPC20.FPI.LDOP\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_3\(37),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_0\(37));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_5_38_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1111001011010000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_5\(38),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(6),
datab => \GRLFPC20.FPI.LDOP\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_3\(38),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_0\(38));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_5_39_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1111001011010000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_5\(39),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(6),
datab => \GRLFPC20.FPI.LDOP\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_3\(39),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_0\(39));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_5_41_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1111001011010000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_5\(41),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(6),
datab => \GRLFPC20.FPI.LDOP\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_3\(41),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_0\(41));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_5_18_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1111001011010000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_5\(18),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(6),
datab => \GRLFPC20.FPI.LDOP\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_3\(18),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_0\(18));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_5_21_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1111001011010000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_5\(21),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(6),
datab => \GRLFPC20.FPI.LDOP\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_3\(21),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_0\(21));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_5_23_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1111001011010000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_5\(23),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(6),
datab => \GRLFPC20.FPI.LDOP\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_3\(23),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_0\(23));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_5_27_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1111001011010000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_5\(27),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(6),
datab => \GRLFPC20.FPI.LDOP\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_3\(27),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_0\(27));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_5_32_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1111001011010000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_5\(32),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(6),
datab => \GRLFPC20.FPI.LDOP\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_3\(32),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_0\(32));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_5_36_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1111001011010000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_5\(36),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(6),
datab => \GRLFPC20.FPI.LDOP\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_3\(36),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_0\(36));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_5_47_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1111001011010000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_5\(47),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(6),
datab => \GRLFPC20.FPI.LDOP\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_3\(47),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_0\(47));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_5_52_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1111001011010000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_5\(52),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(6),
datab => \GRLFPC20.FPI.LDOP\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_3\(52),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_0\(52));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_5_45_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1111001011010000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_5\(45),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(6),
datab => \GRLFPC20.FPI.LDOP\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_3\(45),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_0\(45));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_5_15_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1111001011010000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_5\(15),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(6),
datab => \GRLFPC20.FPI.LDOP\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_3\(15),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_0\(15));
GRLFPC20_R_I_V_RNO: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000010000000100")
port map (
combout => \GRLFPC20.R.I.V_1_0_G3\,
dataa => \GRLFPC20.COMB.UN1_R.I.EXC\,
datab => \GRLFPC20.COMB.V.I.V_1_F1\,
datac => \GRLFPC20.COMB.ANNULRES_1_IV_454\);
GRLFPC20_COMB_RS2D_1_IV: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1110101011000000")
port map (
combout => \GRLFPC20.COMB.RS2D_1_IV\,
dataa => \GRLFPC20.COMB.V.A.RF1REN_1_0_650_A2_3_X\,
datab => \GRLFPC20.MOV_7_SQMUXA\,
datac => \GRLFPC20.R.A.RS1D_0_0_G4\,
datad => \GRLFPC20.UN1_MOV_1_SQMUXA\);
GRLFPC20_COMB_RS1V_1_IV: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1111100010001000")
port map (
combout => \GRLFPC20.COMB.RS1V_1_IV\,
dataa => \GRLFPC20.RS1V_0_SQMUXA\,
datab => \GRLFPC20.COMB.RSDECODE.RS1V_X\,
datac => \GRLFPC20.COMB.V.A.RF1REN_1_0_650_A2_3_X\,
datad => \GRLFPC20.UN1_RS1V_0_SQMUXA\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_5_55_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000111000000010")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_5\(55),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(171),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(6),
datac => \GRLFPC20.FPI.LDOP\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_0\(55));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_0_TRFWWBASICCELL_TEMP2_RNI7N992: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1111100010000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.CI_57_C1\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.0.TRFWWBASICCELL.TEMP2\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN20_ZERO\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.CI_57_C0\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.2.CI_56_SUM0\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_MULLSBLOGIC_STCKYPAIR_UN12_STKOUT: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0101000111111011")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULLSBLOGIC.STCKYPAIR.UN12_STKOUT\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULLSBLOGIC.STCKYPAIR.UN10_NOTPROP_0_0_A3\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN2_MIXOIN\(0),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULLSBLOGIC.STCKYPAIR.UN18_STKGEN\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.SUM\(2));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN2_MIXOIN_9_0_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000000011011111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN2_MIXOIN_9\(0),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULLSBLOGIC.STCKYPAIR.UN10_NOTPROP_0_0_A3\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN2_MIXOIN\(0),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.SUM\(2),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULLSBLOGIC.STCKYPAIR.GEN_1\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_5_43_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1111001011010000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_5\(43),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(6),
datab => \GRLFPC20.FPI.LDOP\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_3\(43),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_0\(43));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_5_53_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1111001011010000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_5\(53),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(6),
datab => \GRLFPC20.FPI.LDOP\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_3\(53),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_0\(53));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_5_46_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1111001011010000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_5\(46),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(6),
datab => \GRLFPC20.FPI.LDOP\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_3\(46),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_0\(46));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_5_54_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1111001011010000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_5\(54),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(6),
datab => \GRLFPC20.FPI.LDOP\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_3\(54),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_0\(54));
GRLFPC20_COMB_V_A_AFSR_1_5_0_O2_RNIVSQN1: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000100000000000")
port map (
combout => \GRLFPC20.R.A.FPOP_0_0_G1\,
dataa => \GRLFPC20.N_1243_I_0_A2_1_X\,
datab => \GRLFPC20.RS2_0_SQMUXA\,
datac => CPO_EXCZ,
datad => \GRLFPC20.COMB.V.A.AFSR_1_5_0_O2\);
\GRLFPC20_R_A_RDD_RNO_0_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1111111110000000")
port map (
combout => \GRLFPC20.R.A.RDD_0_0_0__G1_0\,
dataa => N_62,
datab => N_63,
datac => \GRLFPC20.COMB.RDD_1.M14_0_A2_1\,
datad => \GRLFPC20.R.A.RDD_0_0_0__G2\);
GRLFPC20_V_FSR_FTT_1_SQMUXA_0_RNIPMDG2: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0100110011001100")
port map (
combout => \GRLFPC20.R.FSR.FTT_1_0_0__G0_I_O4_I\,
dataa => N_1,
datab => N_3,
datac => \GRLFPC20.UN1_FPCI_13\,
datad => \GRLFPC20.R.FSR.FTT_1_0_2__G2_490\);
GRLFPC20_COMB_V_STATE14_RNIBI0N1: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000000000001000")
port map (
combout => \GRLFPC20.COMB.V.STATE\,
dataa => \GRLFPC20.R.STATE\(1),
datab => \GRLFPC20.UN1_FPCI_2\,
datac => \GRLFPC20.COMB.V.STATE14\,
datad => \GRLFPC20.COMB.UN1_R.I.EXC\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNISM4Q1_64_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1111110111111101")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.PCTRL_NEW_2_0_65__G3\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(66),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(64),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.PCTRL_NEW_11_0_69__G2_0_529_A3\);
\GRLFPC20_R_I_EXC_RNO_0_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0011001000000010")
port map (
combout => \GRLFPC20.R.I.EXC_2_0_0__G0\,
dataa => \GRLFPC20.R.I.EXC\(0),
datab => \GRLFPC20.COMB.UN2_HOLDN\,
datac => \GRLFPC20.COMB.UN19_IUEXEC\,
datad => \GRLFPC20.R.I.EXC_2_0_0__G4\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_5_35_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1111001011010000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_5\(35),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(6),
datab => \GRLFPC20.FPI.LDOP\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_3\(35),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_0\(35));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_5_29_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1111001011010000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_5\(29),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(6),
datab => \GRLFPC20.FPI.LDOP\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_3\(29),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_0\(29));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_0_81_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1110111100000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.MULTIPLEXORMULXFF.RESULT_1_IV_I_0_4__G0_0\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(84),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSAMPLEDWAIT\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.MULTIPLEXORMULXFF.RESULT_M4_5\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_0_83_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0001111100000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.MULTIPLEXORMULXFF.RESULT_1_IV_I_0_2__G0_0\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.OPREXCSHFT.UN3_OPREXC\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.UN14_CONDITIONAL\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSAMPLEDWAIT\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.MULTIPLEXORMULXFF.RESULT_M4_3\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_XZZERO_1_54: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000000010000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_54\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_40\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_41\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_50\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_XZZERO_1_53: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000000010000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_53\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_38\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_39\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_47\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_XZZERO_1_12: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1001000010010000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_12\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZXBUS\(22),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(22),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_5\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_XZZERO_1_9: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1001000000000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_9\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZXBUS\(13),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(13),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_1\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_9_A\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_XZZERO_1_9_A: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000000000100001")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_9_A\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZXBUS\(10),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_SUB\(0),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(10),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN18_XZXBUS_2\);
GRLFPC20_R_I_V_RNO_1: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1111111111111101")
port map (
combout => \GRLFPC20.R.I.V_1_0_G0_0_1\,
dataa => N_1,
datab => \GRLFPC20.R.FSR.FTT_1_0_0__G2_0_600_I_A6_1_0\,
datac => \GRLFPC20.COMB.V.STATE14\,
datad => \GRLFPC20.G_884\);
GRLFPC20_COMB_V_STATE14_RNIKJ7T: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1111111111110100")
port map (
combout => \GRLFPC20.R.STATE_0_0_0__G3_0\,
dataa => \GRLFPC20.COMB.UN1_FPCI_0_X\,
datab => \GRLFPC20.R.X.SEQERR\(0),
datac => \GRLFPC20.COMB.V.STATE14\,
datad => \GRLFPC20.COMB.UN1_R.I.EXC\);
\GRLFPC20_R_I_EXC_RNO_0_2_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000001000000000")
port map (
combout => \GRLFPC20.R.I.EXC_2_0_2__G3\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(40),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(39),
datac => \GRLFPC20.COMB.UN2_HOLDN\,
datad => \GRLFPC20.R.I.EXC_2_0_0__G4\);
\GRLFPC20_R_A_SEQERR_RNO_0_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010000000000000")
port map (
combout => \GRLFPC20.R.A.SEQERR_0_0_0__G1\,
dataa => \GRLFPC20.N_1243_I_0_A2_1_X\,
datab => CPO_EXCZ,
datac => \GRLFPC20.R.A.SEQERR_0_0_0__G3\,
datad => \GRLFPC20.COMB.V.A.RF2REN_1_0_701_I_948_X\);
\GRLFPC20_R_A_RDD_RNO_0_0_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0001000000000000")
port map (
combout => \GRLFPC20.R.A.RDD_0_0_0__G2\,
dataa => N_56,
datab => N_52,
datac => \GRLFPC20.COMB.RDD_1.M14_0_O2\,
datad => \GRLFPC20.R.A.MOV_0_0_G1_0_X\);
\GRLFPC20_R_FSR_FTT_RNO_2_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000000000001000")
port map (
combout => \GRLFPC20.R.FSR.FTT_1_0_2__G2\,
dataa => N_1,
datab => \GRLFPC20.R.FSR.FTT_1_0_0__G2_0_600_I_A6_1_0\,
datac => \GRLFPC20.COMB.V.STATE14\,
datad => \GRLFPC20.COMB.UN1_R.I.EXC\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_2_85_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101000000010000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.MULTIPLEXORMULXFF.RESULT_M1_0_A2_2\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(60),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.G_37\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.MULTIPLEXORMULXFF.RESULT_M1_0_A2_0_1\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.WQSTSETS\(7));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_MULLSBLOGIC_STCKYPAIR_UN19_GEN_RNO: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1111100000000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.CI_57_C1_1\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.0.TRFWWBASICCELL.TEMP2\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN20_ZERO\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.CI_57_C0\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.2.CI_56_SUM0\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_0_10_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010111000101110")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_0\(10),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(68),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(7),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES\(10));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_0_12_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010111000101110")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_0\(12),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(70),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(7),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES\(12));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_0_13_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010111000101110")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_0\(13),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(71),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(7),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES\(13));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_0_16_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010111000101110")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_0\(16),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(74),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(7),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES\(16));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_5_4_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1111001011010000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_5\(4),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(6),
datab => \GRLFPC20.FPI.LDOP\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_3\(4),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_0\(4));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_5_6_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1111001011010000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_5\(6),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(6),
datab => \GRLFPC20.FPI.LDOP\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_3\(6),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_0\(6));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_0_40_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010111000101110")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_0\(40),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(98),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(7),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES\(40));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_0_42_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010111000101110")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_0\(42),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(100),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(7),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES\(42));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_0_44_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010111000101110")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_0\(44),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(102),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(7),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES\(44));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_0_48_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010111000101110")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_0\(48),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(106),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(7),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES\(48));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_0_50_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010111000101110")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_0\(50),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(108),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(7),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES\(50));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_0_49_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010111000101110")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_0\(49),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(107),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(7),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES\(49));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_0_51_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010111000101110")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_0\(51),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(109),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(7),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES\(51));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_0_56_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010111000101110")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_0\(56),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(114),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(7),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES\(56));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_5_1_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000111000000010")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_5\(1),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(117),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(6),
datac => \GRLFPC20.FPI.LDOP\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_0\(1));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_5_5_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1111001011010000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_5\(5),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(6),
datab => \GRLFPC20.FPI.LDOP\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_3\(5),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_0\(5));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_5_8_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1111001011010000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_5\(8),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(6),
datab => \GRLFPC20.FPI.LDOP\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_3\(8),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_0\(8));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_0_11_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010111000101110")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_0\(11),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(69),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(7),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES\(11));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_0_14_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010111000101110")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_0\(14),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(72),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(7),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES\(14));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_0_17_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010111000101110")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_0\(17),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(75),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(7),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES\(17));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_0_19_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010111000101110")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_0\(19),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(77),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(7),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES\(19));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_0_20_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010111000101110")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_0\(20),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(78),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(7),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES\(20));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_0_22_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010111000101110")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_0\(22),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(80),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(7),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES\(22));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_0_24_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010111000101110")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_0\(24),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(82),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(7),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES\(24));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_0_25_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010111000101110")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_0\(25),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(83),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(7),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES\(25));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_0_26_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010111000101110")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_0\(26),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(84),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(7),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES\(26));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_0_28_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010111000101110")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_0\(28),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(86),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(7),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES\(28));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_0_30_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010111000101110")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_0\(30),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(88),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(7),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES\(30));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_0_31_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010111000101110")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_0\(31),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(89),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(7),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES\(31));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_0_33_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010111000101110")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_0\(33),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(91),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(7),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES\(33));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_0_34_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010111000101110")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_0\(34),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(92),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(7),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES\(34));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_0_37_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010111000101110")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_0\(37),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(95),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(7),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES\(37));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_0_38_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010111000101110")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_0\(38),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(96),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(7),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES\(38));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_0_39_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010111000101110")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_0\(39),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(97),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(7),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES\(39));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_0_41_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010111000101110")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_0\(41),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(99),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(7),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES\(41));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_5_2_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1111111011110010")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_5\(2),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(118),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(6),
datac => \GRLFPC20.FPI.LDOP\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_0\(2));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_5_9_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1111001011010000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_5\(9),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(6),
datab => \GRLFPC20.FPI.LDOP\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_3\(9),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_0\(9));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_0_18_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010111000101110")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_0\(18),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(76),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(7),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES\(18));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_0_21_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010111000101110")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_0\(21),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(79),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(7),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES\(21));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_0_23_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010111000101110")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_0\(23),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(81),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(7),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES\(23));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_0_27_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010111000101110")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_0\(27),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(85),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(7),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES\(27));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_0_32_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010111000101110")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_0\(32),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(90),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(7),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES\(32));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_0_36_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010111000101110")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_0\(36),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(94),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(7),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES\(36));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_0_47_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010111000101110")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_0\(47),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(105),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(7),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES\(47));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_0_52_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010111000101110")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_0\(52),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(110),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(7),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES\(52));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_0_45_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010111000101110")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_0\(45),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(103),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(7),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES\(45));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_RIGHTSHIFTERBL_NOTSTICKYINFORSR_0: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101000001010000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.NOTSTICKYINFORSR_0\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(42),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.NOTSTICKYINFORSR_2_0\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_10\(57),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.NOTSTICKYINFORSR_0_A\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_RIGHTSHIFTERBL_NOTSTICKYINFORSR_0_A: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000001100000010")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.NOTSTICKYINFORSR_0_A\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRONEMORE\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.UN7_SHDVAR\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(57),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_10\(56));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_0_15_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010111000101110")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_0\(15),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(73),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(7),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES\(15));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_55_TRFWWBASICCELL_TEMP2_2_RNIANRT1_0: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000011101111000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.CI_2_SUM2\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.55.TRFWWBASICCELL.TEMP2_2\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN20_ZERO\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.CI_2_C0\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.CI_114_1.SUM_5_0_A2\(0));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_54_SI_61_1_CO0: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1111100010000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.54.SI_61_1.CO0\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.CTRLXERSHFT.MIXOIN_3\(57),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_1299_AXB0\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.CI_114_1.SUM_5_0_A2\(0),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_1299_SUM2\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_CI_58_2_ANC1: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0111100000000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.CI_58_2.ANC1\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.55.TRFWWBASICCELL.TEMP2_2\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN20_ZERO\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.CI_2_C0\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.CI_114_1.SUM_5_0_A2\(0));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_TRFWWBASICCELL_TEMP2_1_RNIH1QV1: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0111100010000111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.SI_1_0_A2\(56),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.TRFWWBASICCELL.TEMP2_1\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN20_ZERO\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.CI_2_C0\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.CI_114_1.SUM_5_0_A2\(0));
GRLFPC20_COMB_RS1D_1_U: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1110001011000000")
port map (
combout => \GRLFPC20.COMB.RS1D_1_U\,
dataa => \GRLFPC20.RS1D_CNST_0_A2_1_X\,
datab => \GRLFPC20.MOV_7_SQMUXA\,
datac => \GRLFPC20.R.A.RS1D_0_0_G4\,
datad => \GRLFPC20.RS1D_CNST_0_A2_0\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_MULLSBLOGIC_STCKYPAIR_UN19_GEN_RNO_0: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000001000101000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULLSBLOGIC.STCKYPAIR.UN16_NOTPROP_0\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULLSBLOGIC.TEMP_0\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.CI_57_C0\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.0.TRFWWBASICCELL.CIN\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.2.CI_56_SUM0\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_0_TRFWWBASICCELL_CIN_1_RNIIO8B2: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0110100110010110")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULLSBLOGIC.STCKYPAIR.UN16_NOTPROP\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULLSBLOGIC.TEMP_0\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.CI_57_C0\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.0.TRFWWBASICCELL.CIN\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.2.CI_56_SUM0\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_5_7_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1111001011010000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_5\(7),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(6),
datab => \GRLFPC20.FPI.LDOP\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_3\(7),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_0\(7));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_0_55_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010111000101110")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_0\(55),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(113),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(7),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES\(55));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_MULLSBLOGIC_STCKYPAIR_GEN_1: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1110110010100000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULLSBLOGIC.STCKYPAIR.GEN_1\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.CI_57_SUM0\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.SUM_I\(0),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.SUM\(1),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULLSBLOGIC.STCKYPAIR.UN13_GEN_0\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_55_TRFWWBASICCELL_TEMP2_2_RNIDECL1: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000000000000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.CO2\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.55.TRFWWBASICCELL.TEMP2_2\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN20_ZERO\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.54.TRFWWBASICCELL.CIN\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.CI_2_C0\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_0_43_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010111000101110")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_0\(43),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(101),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(7),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES\(43));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_0_53_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010111000101110")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_0\(53),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(111),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(7),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES\(53));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_0_46_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010111000101110")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_0\(46),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(104),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(7),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES\(46));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_0_54_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010111000101110")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_0\(54),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(112),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(7),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES\(54));
GRLFPC20_COMB_V_A_AFSR_1_5_0_O2_RNICIAC1: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010001000000000")
port map (
combout => \GRLFPC20.R.A.AFSR_0_0_G1_1\,
dataa => \GRLFPC20.N_1243_I_0_A2_1_X\,
datab => \GRLFPC20.R.STATE\(0),
datac => \GRLFPC20.R.STATE\(1),
datad => \GRLFPC20.COMB.V.A.AFSR_1_5_0_O2\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_STARTSHFT_UN3_NOTRESETORUNIMP: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1111000111110001")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.STARTSHFT.UN3_NOTRESETORUNIMP\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(65),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(66),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.PCTRL_NEW_11_0_69__G2_0_529_A3\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_69_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1110111011101110")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.PCTRL_NEW_11_0_69__G2_0_529\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(64),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.PCTRL_NEW_11_0_69__G2_0_529_A3\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_0_35_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010111000101110")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_0\(35),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(93),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(7),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES\(35));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_0_29_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010111000101110")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_0\(29),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(87),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(7),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES\(29));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_5_3_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1111001011010000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_5\(3),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(6),
datab => \GRLFPC20.FPI.LDOP\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_3\(3),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_0\(3));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_XZZERO_1_51: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_51\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_45\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_44\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_XZZERO_1_50: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000000010000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_50\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_28\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_29\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_42\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_XZZERO_1_47: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000000000000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_47\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_16\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_17\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_14\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_15\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_XZZERO_1_11: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000100100000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_11\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZXBUS\(5),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_M5_2\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN18_XZXBUS_3\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_8\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_XZZERO_1_5: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000001001000001")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_5\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZXBUS\(11),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZXBUS\(7),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_M5_4\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(11));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_XZZERO_1_4: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000010000100001")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_4\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZXBUS\(14),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZXBUS\(12),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(14),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(12));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_EXPADDERSHFT_UN23_EXPXBUS_NE_10: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1110101101111101")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.UN23_EXPXBUS_NE_10\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(36),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.EXPXBUS_3\(3),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(3),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.UN23_EXPXBUS_NE_10_A\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_EXPADDERSHFT_UN23_EXPXBUS_NE_10_A: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0011110010101010")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.UN23_EXPXBUS_NE_10_A\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(36),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.EXPXBUS_3\(0),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(0),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.UN23_EXPXBUS_2\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_EXPADDERSHFT_UN23_EXPXBUS_NE_6: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1111111111101101")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.UN23_EXPXBUS_NE_6\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.EXPXBUS_3\(9),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.UN23_EXPXBUS_NE_3\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.GRFPUELOC\(9),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.UN23_EXPXBUS_NE_2\);
GRLFPC20_UN1_MOV_1_SQMUXA: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1111111101000000")
port map (
combout => \GRLFPC20.UN1_MOV_1_SQMUXA\,
dataa => N_56,
datab => \GRLFPC20.COMB.FPDECODE.RDD3_TZ\,
datac => \GRLFPC20.COMB.FPDECODE.FPOP2_0_A2\,
datad => \GRLFPC20.UN1_MOV_1_SQMUXA_0\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_374_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1110011111000011")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_0_374__G0_0\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_GRFPUF_0\(2),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_GRFPUF_0\(1),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_GRFPUF_0\(0),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_0_374__G0_0_A\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_0_374_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0100000101000001")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_0_374__G0_0_A\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH_2\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_GRFPUF_0\(3),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_GRFPUF_0\(0));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_54_SI_61_1_SUM_0_A2_0_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000011101111000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.54.SI_61_1.SUM_0_A2\(0),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.CTRLXERSHFT.MIXOIN_3\(57),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_1299_AXB0\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.CI_114_1.SUM_5_0_A2\(0),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_1299_SUM2\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_MULLSBLOGIC_STCKYPAIR_UN18_STKGEN: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1001011010010110")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULLSBLOGIC.STCKYPAIR.UN18_STKGEN\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.CI_57_SUM0\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.SUM_I\(0),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.SUM\(1));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_OPREXC_RNIUUGR1: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1110000000000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.PCTRL_NEW\(77),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(72),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(76),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.PCTRL_NEW_1\(77),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.OPREXC\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_1_85_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1100010000000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.OPREXCSHFT.UN13_EXMIPTRLSBS_M\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.WQSTSETS\(5),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.WQSTSETS\(3),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.WQSTSETS\(4),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSAMPLEDWAIT\);
GRLFPC20_COMB_UN1_R_I_EXC_RNIH7PC3: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000111110011111")
port map (
combout => \GRLFPC20.COMB.ANNULRES_1_IV_454\,
dataa => \GRLFPC20.COMB.UN1_FPCI_0_X\,
datab => \GRLFPC20.COMB.ANNULRES_1_IV_454_A\,
datac => \GRLFPC20.ANNULRES_1_SQMUXA\,
datad => \GRLFPC20.COMB.UN1_R.I.EXC\);
\GRLFPC20_R_X_SEQERR_RNIPUP91_0_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010011100000101")
port map (
combout => \GRLFPC20.COMB.ANNULRES_1_IV_454_A\,
dataa => \GRLFPC20.COMB.UN1_FPCI_0_X\,
datab => \GRLFPC20.R.I.EXEC\,
datac => \GRLFPC20.R.X.SEQERR\(0),
datad => \GRLFPC20.R.X.FPOP\);
GRLFPC20_R_A_LD_RNO: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000100000000000")
port map (
combout => \GRLFPC20.R.A.LD_0_0_G1\,
dataa => \GRLFPC20.N_1243_I_0_A2_1_X\,
datab => \GRLFPC20.COMB.SEQERR.UN7_OP_0_A2_X\,
datac => CPO_EXCZ,
datad => \GRLFPC20.COMB.V.A.LD_1_0_O2\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_ENTRYSHFT_ENTRYPOINT_2_RNI6OD31: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010000000100010")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.PCTRL_NEW_11_0_69__G2_0_529_A3\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(67),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(65),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.ENTRYSHFT.UN1_ENTRYPOINT\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.ENTRYSHFT.ENTRYPOINT_2\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_1_81_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000000011111101")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.MULTIPLEXORMULXFF.RESULT_M4_5\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.MULTIPLEXORMULXFF.RESULT_M1_0_A2_0_1\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.RESULT\(4),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.PCTRL_NEW_12_31\(75),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.MULTIPLEXORMULXFF.RESULT_M4_5_A\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_3_81_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0101000001000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.MULTIPLEXORMULXFF.RESULT_M4_5_A\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.PCTRL\(5),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_PCTRL_NEW_43_2_0\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_PCTRL_NEW_43_2_C\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.PCTRL_NEW_12_31\(75));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_PXS_PCTRL_NEW_12_30_D_0_D_75_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1111110010101100")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.PCTRL_NEW_12_30_D_0_D\(75),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(49),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.PCTRL_NEW_12_25\(75),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.PCTRL_NEW_12_30_S\(75),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.UN14_CONDITIONAL\);
GRLFPC20_UN1_RS1V_0_SQMUXA: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1111111110000000")
port map (
combout => \GRLFPC20.UN1_RS1V_0_SQMUXA\,
dataa => N_62,
datab => N_64,
datac => \GRLFPC20.COMB.FPDECODE.FPOP3_0\,
datad => \GRLFPC20.RS1V_0_SQMUXA_1_X\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_10_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1110111101000101")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES\(10),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(45),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRTOSTICKY\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_16\(10),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES_0\(10));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_12_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1110111101000101")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES\(12),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(45),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRTOSTICKY\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_16\(12),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES_0\(12));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_13_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1110111101000101")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES\(13),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(45),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRTOSTICKY\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_16\(13),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES_0\(13));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_16_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1110111101000101")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES\(16),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(45),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRTOSTICKY\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_16\(16),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES_0\(16));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_0_4_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010111000101110")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_0\(4),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(62),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(7),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES\(4));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_0_6_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010111000101110")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_0\(6),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(64),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(7),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES\(6));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_40_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1110111101000101")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES\(40),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(45),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRTOSTICKY\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_16\(40),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES_0\(40));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_42_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1110111101000101")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES\(42),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(45),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRTOSTICKY\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_16\(42),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES_0\(42));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_44_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1110111101000101")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES\(44),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(45),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRTOSTICKY\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_16\(44),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES_0\(44));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_48_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1110111101000101")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES\(48),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(45),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRTOSTICKY\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_16\(48),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES_0\(48));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_50_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1110111101000101")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES\(50),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(45),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRTOSTICKY\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_16\(50),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES_0\(50));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_27_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1110111101000101")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES\(27),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(45),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRTOSTICKY\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_16\(27),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES_0\(27));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_49_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1110111101000101")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES\(49),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(45),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRTOSTICKY\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_16\(49),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES_0\(49));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_51_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1110111101000101")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES\(51),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(45),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRTOSTICKY\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_16\(51),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES_0\(51));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_56_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1110010011110101")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES\(56),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(45),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRTOSTICKY\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES_0\(56),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_16\(56));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_11_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1110111101000101")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES\(11),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(45),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRTOSTICKY\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_16\(11),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES_0\(11));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_14_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1110111101000101")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES\(14),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(45),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRTOSTICKY\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_16\(14),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES_0\(14));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_17_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1110111101000101")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES\(17),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(45),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRTOSTICKY\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_16\(17),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES_0\(17));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_19_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1110111101000101")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES\(19),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(45),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRTOSTICKY\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_16\(19),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES_0\(19));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_20_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1110111101000101")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES\(20),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(45),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRTOSTICKY\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_16\(20),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES_0\(20));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_22_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1110111101000101")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES\(22),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(45),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRTOSTICKY\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_16\(22),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES_0\(22));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_24_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1110111101000101")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES\(24),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(45),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRTOSTICKY\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_16\(24),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES_0\(24));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_25_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1110111101000101")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES\(25),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(45),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRTOSTICKY\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_16\(25),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES_0\(25));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_26_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1110111101000101")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES\(26),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(45),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRTOSTICKY\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_16\(26),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES_0\(26));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_28_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1110111101000101")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES\(28),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(45),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRTOSTICKY\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_16\(28),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES_0\(28));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_30_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1110111101000101")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES\(30),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(45),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRTOSTICKY\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_16\(30),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES_0\(30));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_31_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1110111101000101")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES\(31),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(45),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRTOSTICKY\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_16\(31),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES_0\(31));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_33_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1110111101000101")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES\(33),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(45),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRTOSTICKY\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_16\(33),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES_0\(33));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_34_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1110111101000101")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES\(34),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(45),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRTOSTICKY\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_16\(34),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES_0\(34));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_37_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1110111101000101")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES\(37),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(45),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRTOSTICKY\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_16\(37),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES_0\(37));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_38_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1110111101000101")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES\(38),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(45),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRTOSTICKY\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_16\(38),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES_0\(38));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_39_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1110111101000101")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES\(39),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(45),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRTOSTICKY\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_16\(39),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES_0\(39));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_41_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1110111101000101")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES\(41),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(45),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRTOSTICKY\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_16\(41),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES_0\(41));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_52_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1110111101000101")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES\(52),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(45),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRTOSTICKY\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_16\(52),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES_0\(52));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_0_1_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010111000101110")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_0\(1),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(59),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(7),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES\(1));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_0_5_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010111000101110")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_0\(5),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(63),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(7),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES\(5));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_0_8_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010111000101110")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_0\(8),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(66),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(7),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES\(8));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_18_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1110111101000101")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES\(18),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(45),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRTOSTICKY\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_16\(18),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES_0\(18));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_21_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1110111101000101")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES\(21),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(45),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRTOSTICKY\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_16\(21),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES_0\(21));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_23_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1110111101000101")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES\(23),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(45),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRTOSTICKY\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_16\(23),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES_0\(23));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_32_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1110111101000101")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES\(32),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(45),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRTOSTICKY\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_16\(32),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES_0\(32));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_36_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1110111101000101")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES\(36),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(45),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRTOSTICKY\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_16\(36),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES_0\(36));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_47_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1110111101000101")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES\(47),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(45),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRTOSTICKY\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_16\(47),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES_0\(47));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_0_2_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010111000101110")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_0\(2),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(60),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(7),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES\(2));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_0_9_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010111000101110")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_0\(9),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(67),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(7),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES\(9));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_45_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1110111101000101")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES\(45),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(45),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRTOSTICKY\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_16\(45),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES_0\(45));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_141_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1111100001110000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH\(141),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(1),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.UN2_NOTABORTWB\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_0\(141),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_14\(141));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_15_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1110111101000101")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES\(15),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(45),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRTOSTICKY\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_16\(15),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES_0\(15));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_55_TRFWWBASICCELL_CIN_10_RNILR0C1: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1110100000000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.CO0\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.CTRLXERSHFT.MIXOIN_3\(57),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.CTRLXERSHFT.SUMIN_5\(57),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.55.TRFWWBASICCELL.CIN_10\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7356\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_5_0_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000111000000010")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_5\(0),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(116),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(6),
datac => \GRLFPC20.FPI.LDOP\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_0\(0));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_0_7_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010111000101110")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_0\(7),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(65),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(7),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES\(7));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_55_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1110010011100100")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES\(55),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(45),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.NOTSRRES\(2),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES_0\(55));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_1_TRFWWBASICCELL_CIN_1_RNITIDS5: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0110100110010110")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.SUM\(2),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.CTRLXERSHFT.MIXOIN_3\(4),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.CTRLXERSHFT.SUMIN_5\(4),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.1.TRFWWBASICCELL.CIN_1\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.SUM\(1));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_43_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1110111101000101")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES\(43),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(45),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRTOSTICKY\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_16\(43),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES_0\(43));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_53_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1110111101000101")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES\(53),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(45),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRTOSTICKY\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_16\(53),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES_0\(53));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_46_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1110111101000101")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES\(46),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(45),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRTOSTICKY\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_16\(46),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES_0\(46));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_54_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1110111101000101")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES\(54),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(45),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRTOSTICKY\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_16\(54),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES_0\(54));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_INEXACTSIG_UN13_INEXACT_RNIKLT32: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000110010001100")
port map (
combout => \GRLFPC20.R.I.EXC_2_0_0__G4\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(10),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.STATUS\(6),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.INEXACTSIG.UN3_INEXACT\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.INEXACTSIG.UN13_INEXACT\);
GRLFPC20_COMB_V_A_AFSR_1_5_0_O2: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1111111100000010")
port map (
combout => \GRLFPC20.COMB.V.A.AFSR_1_5_0_O2\,
dataa => \GRLFPC20.COMB.V.A.AFSR_1_5_0_O2_1\,
datab => \GRLFPC20.COMB.FPDECODE.ST_0_A2\,
datac => \GRLFPC20.RS2_0_SQMUXA\,
datad => \GRLFPC20.COMB.V.A.LD_1_0_O2\);
GRLFPC20_COMB_V_I_EXEC_5_IV_RNIUB4S: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000000011011111")
port map (
combout => \GRLFPC20.R.FSR.FTT_1_0_2__G2_490\,
dataa => \GRLFPC20.R.I.V\,
datab => \GRLFPC20.COMB.UN1_MEXC_1\,
datac => \GRLFPC20.COMB.V.I.EXEC_5_IV\,
datad => \GRLFPC20.COMB.UN1_R.I.EXC\);
GRLFPC20_COMB_UN1_R_I_EXC: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000000000000000")
port map (
combout => \GRLFPC20.COMB.UN1_R.I.EXC\,
dataa => \GRLFPC20.R.I.V\,
datab => \GRLFPC20.R.I.EXC\(5),
datac => \GRLFPC20.COMB.UN1_MEXC_1\,
datad => \GRLFPC20.COMB.V.I.EXEC_5_IV\);
GRLFPC20_COMB_V_I_EXEC_5_IV_RNIUN111: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000100000000000")
port map (
combout => \GRLFPC20.COMB.V.FSR.CEXC_1_SN_M2\,
dataa => \GRLFPC20.V.STATE_0_SQMUXA_1_X\,
datab => \GRLFPC20.R.I.V\,
datac => \GRLFPC20.COMB.UN1_MEXC_1\,
datad => \GRLFPC20.COMB.V.I.EXEC_5_IV\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_35_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1110111101000101")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES\(35),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(45),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRTOSTICKY\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_16\(35),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES_0\(35));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_29_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1110111101000101")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES\(29),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(45),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRTOSTICKY\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_16\(29),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES_0\(29));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_0_3_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010111000101110")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_0\(3),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(61),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(7),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES\(3));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_R_SCTRL_39_IV_RNO_1_0_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000001000000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.SIGNRESULT_I_M_2\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(22),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.SIGNRESULT\,
datac => \GRLFPC20.FPI.LDOP\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.UN2_NOTABORTWB\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_XZZERO_1_45: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000100100000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_45\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZXBUS\(50),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(50),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN18_XZXBUS_42\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_32\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_XZZERO_1_44: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000100100000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_44\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZXBUS\(36),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(36),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN18_XZXBUS_35\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_30\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_XZZERO_1_42: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000100100000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_42\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZXBUS\(55),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(55),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN18_XZXBUS_57\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_27\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_XZZERO_1_41: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000100100000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_41\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZXBUS\(27),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(27),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN18_XZXBUS_31\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_25\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_XZZERO_1_40: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000100100000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_40\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZXBUS\(19),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(19),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN18_XZXBUS_43\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_22\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_XZZERO_1_39: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000100100000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_39\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZXBUS\(49),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(49),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN18_XZXBUS_37\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_21\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_XZZERO_1_38: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000100100000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_38\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZXBUS\(29),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(29),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN18_XZXBUS_38\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_18\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_XZZERO_1_8: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000010000100001")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_8\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZXBUS\(8),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZXBUS\(6),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_M5_5\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_M5_3\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_XZZERO_1_6: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000010000100001")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_6\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZXBUS\(9),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZXBUS\(4),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_M5_6\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_M5_1\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_XZZERO_1_1: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000001001000001")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_1\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZXBUS\(1),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZXBUS\(0),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.EXTEND.TEMP\(0),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.EXTEND.TEMP\(1));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_EXPADDERSHFT_UN23_EXPXBUS_NE_5: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1110110110110111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.UN23_EXPXBUS_NE_5\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.EXPXBUS_3\(7),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.EXPXBUS_3\(8),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.GRFPUELOC\(7),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.GRFPUELOC\(8));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOINSTANDNOEXC_41_2_0: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000000000101111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOINSTANDNOEXC_41_2_0\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(63),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.NOTABORTNULLEXC\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.TEMP_20\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.PCTRL_NEW\(77));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_MULLSBLOGIC_STCKYPAIR_UN13_GEN_0: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010100010101000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULLSBLOGIC.STCKYPAIR.UN13_GEN_0\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULLSBLOGIC.TEMP_2\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULLSBLOGIC.TEMP_1\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.CI_57_SUM0\);
GRLFPC20_RS1D_CNST_0_A2_0: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1100000010000000")
port map (
combout => \GRLFPC20.RS1D_CNST_0_A2_0\,
dataa => N_73,
datab => \GRLFPC20.RS1D_CNST_0_A2_0_A\,
datac => \GRLFPC20.RS1D_CNST_0_A2_2_X\,
datad => \GRLFPC20.COMB.FPDECODE.RDD5_0_A3\);
GRLFPC20_RS1D_CNST_0_A2_0_A: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010000000001100")
port map (
combout => \GRLFPC20.RS1D_CNST_0_A2_0_A\,
dataa => N_62,
datab => N_66,
datac => N_63,
datad => N_73);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_WAITMULXFF_NOTSAMPLEDWAIT: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0001000000000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.WAITMULXFF.NOTSAMPLEDWAIT\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(65),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.NOTABORTNULLEXC\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.WAITMULXFF.UN2_TEMP\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_WQSTSETS\(0));
GRLFPC20_COMB_V_I_EXEC_5_IV_RNINBKI: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000000010000000")
port map (
combout => \GRLFPC20.COMB.UN1_R.I.V\,
dataa => \GRLFPC20.R.I.V\,
datab => \GRLFPC20.COMB.UN1_MEXC_1\,
datac => \GRLFPC20.COMB.V.I.EXEC_5_IV\);
GRLFPC20_COMB_FPDECODE_ST3_1_RNI0EBA1: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0101000001010001")
port map (
combout => \GRLFPC20.COMB.V.A.RF2REN_1_0_701_I_948_TZ\,
dataa => \GRLFPC20.RS2_0_SQMUXA\,
datab => \GRLFPC20.COMB.FPDECODE.ST3_1\,
datac => \GRLFPC20.COMB.FPDECODE.FPOP8_I_O3_X\,
datad => \GRLFPC20.COMB.SEQERR.UN7_OP_0_A2_X\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_CTRLXERSHFT_SUMIN_5_RNI16741_4_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1110101010000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.CI_57_C0\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.CTRLXERSHFT.MIXOIN_3\(4),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.1.TRFWWBASICCELL.TEMP2_2\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN5_ZERO\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.CTRLXERSHFT.SUMIN_5\(4));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_55_TRFWWBASICCELL_TEMP2_1_RNI9HRN: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1110101010000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.CI_2_C0\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.CTRLXERSHFT.MIXOIN_3\(57),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.55.TRFWWBASICCELL.TEMP2_1\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN5_ZERO\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.CTRLXERSHFT.SUMIN_5\(57));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNI2TFQ_0_368_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1111001000100000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.2.CI_56_C0\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(368),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.CTRLXERSHFT.SUMIN_5\(5),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.2.CI_56_V\(0));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_2_13_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010111011010001")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_2\(13),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(19),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(8),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(58),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(13));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_2_12_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010111011010001")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_2\(12),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(19),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(8),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(58),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(12));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_2_11_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010111011010001")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_2\(11),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(19),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(8),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(58),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(11));
GRLFPC20_COMB_RDD_1_M14_0_O2: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0111001101010000")
port map (
combout => \GRLFPC20.COMB.RDD_1.M14_0_O2\,
dataa => N_53,
datab => N_55,
datac => \GRLFPC20.COMB.RDD_1.M14_0_A2_0_0\,
datad => \GRLFPC20.COMB.RDD_1.M14_0_A2_0_1\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_4_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1111111001010100")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES\(4),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(45),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRTOSTICKY\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_10\(4),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES_0\(4));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_6_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1111111001010100")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES\(6),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(45),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRTOSTICKY\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_10\(6),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES_0\(6));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_1_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1111111001010100")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES\(1),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(45),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRTOSTICKY\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_10\(1),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES_0\(1));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_5_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1111111001010100")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES\(5),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(45),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRTOSTICKY\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_10\(5),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES_0\(5));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_8_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1111111001010100")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES\(8),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(45),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRTOSTICKY\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_10\(8),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES_0\(8));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_2_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1111111001010100")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES\(2),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(45),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRTOSTICKY\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_10\(2),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES_0\(2));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_9_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1111111001010100")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES\(9),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(45),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRTOSTICKY\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_10\(9),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES_0\(9));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_DPATH_NEW_14_141_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010110000001100")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_14\(141),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(2),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(143),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(10),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_T_3\(0));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_0_0_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010111000101110")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_0\(0),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(58),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(7),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES\(0));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_171_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1110001011000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH\(171),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.CTRLCREGXZ.UN1_INFORCREGDB\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_SN_M3_1\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_0\(171),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_T_3\(0));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_7_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1111111001010100")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES\(7),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(45),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRTOSTICKY\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_10\(7),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES_0\(7));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_RIGHTSHIFTERBL_NOTSRRES_2_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1111111011011100")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.NOTSRRES\(2),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRONEMORE\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRTOSTICKY\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_10\(54),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_10\(55));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNIGAOS4_370_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101001011110000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.SUM\(1),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(370),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULLSBLOGIC.TEMP_1\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULLSBLOGIC.STCKYPAIR.UN10_NOTPROP_0_2_I_O3\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_55_TRFWWBASICCELL_CIN_10_RNIEA5N1_0: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0111100011110000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_1299_SUM3\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.CTRLXERSHFT.SUMIN_5\(57),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.55.TRFWWBASICCELL.CIN_10\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_1299_V\(1),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_1299_V\(0));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_55_TRFWWBASICCELL_CIN_10_RNIEA5N1: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000000000000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_1299_ANC3\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.CTRLXERSHFT.SUMIN_5\(57),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.55.TRFWWBASICCELL.CIN_10\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_1299_V\(1),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_1299_V\(0));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_BUSYMULXFF_UN2_TEMP_1: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000000000101111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.BUSYMULXFF.UN2_TEMP_1\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(63),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.NOTABORTNULLEXC\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.TEMP_20\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.WAITMULXFF.NOTSAMPLEDWAIT\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_OPREXC: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0111111101111111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.OPREXC\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.WQSTSETS\(5),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.WQSTSETS\(3),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.OPREXCSHFT.UN3_OPREXC\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_LEFTSHIFTERBL_SLCONTROL_3_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1100000011100010")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(3),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(32),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(31),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL_1\(3),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL_A\(3));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_LEFTSHIFTERBL_SLCONTROL_A_3_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0100010000000101")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL_A\(3),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(43),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(2),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_COUNTSUCCESSIVEZERO18\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.COUNTSUCCESSIVEZERO_M14\(3));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_LEFTSHIFTERBL_SLCONTROL_2_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000100000001101")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(2),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(31),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL_1\(2),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL_SN_M3\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.NORMDETECT.NOTSLFROMNORM_17_3_0_.M4\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_LEFTSHIFTERBL_SLCONTROL_1_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010000000110001")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(1),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(31),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL_SN_M3\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL_1\(1),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.NORMDETECT.NOTSLFROMNORM_17_3_0_.M3\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_LEFTSHIFTERBL_SLCONTROL_0_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010000000110001")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(0),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(31),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL_SN_M3\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL_1\(0),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.NORMDETECT.NOTSLFROMNORM_17_3_0_.M2\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_4_85_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101110011011100")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.WQSTSETS\(7),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUE_ADD11\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUE_ADD12\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.UN30_CONDITIONAL_M5\);
GRLFPC20_COMB_V_A_LD_1_0_O2: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010101011111110")
port map (
combout => \GRLFPC20.COMB.V.A.LD_1_0_O2\,
dataa => \GRLFPC20.COMB.RSDECODE.RS1V_X\,
datab => \GRLFPC20.COMB.LOCKGEN.LOCKI_I_0_0_A2_0\,
datac => \GRLFPC20.COMB.V.A.LD_1_0_A2_0\,
datad => \GRLFPC20.COMB.LOCKGEN.DEPCHECK\);
GRLFPC20_ANNULFPU_0_SQMUXA_1_X_RNI8NJG1: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000000000010000")
port map (
combout => \GRLFPC20.R.MK.BUSY2_0_0_G3\,
dataa => \GRLFPC20.ANNULFPU_0_SQMUXA_1_X\,
datab => \GRLFPC20.ANNULFPU_0_SQMUXA_2_X\,
datac => \GRLFPC20.R.MK.BUSY2_0_0_G3_A\,
datad => \GRLFPC20.COMB.UN1_R.I.EXC\);
GRLFPC20_ANNULFPU_0_SQMUXA_X_RNIACM31: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000000000100111")
port map (
combout => \GRLFPC20.R.MK.BUSY2_0_0_G3_A\,
dataa => \GRLFPC20.COMB.UN1_FPCI_0_X\,
datab => \GRLFPC20.R.X.FPOP\,
datac => \GRLFPC20.R.X.SEQERR\(0),
datad => \GRLFPC20.ANNULFPU_0_SQMUXA_X\);
GRLFPC20_COMB_V_STATE14: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010000000100000")
port map (
combout => \GRLFPC20.COMB.V.STATE14\,
dataa => \GRLFPC20.R.I.V\,
datab => \GRLFPC20.COMB.UN1_MEXC_1\,
datac => \GRLFPC20.COMB.V.I.EXEC_5_IV\);
\GRLFPC20_R_A_SEQERR_RNO_0_0_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1111101011001100")
port map (
combout => \GRLFPC20.R.A.SEQERR_0_0_0__G3\,
dataa => \GRLFPC20.RS2_0_SQMUXA\,
datab => \GRLFPC20.R.A.AFQ_0_0_G1_0\,
datac => \GRLFPC20.COMB.SEQERR.UN7_OP_0_A2_X\,
datad => \GRLFPC20.COMB.QNE2\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_3_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1111111001010100")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES\(3),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(45),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRTOSTICKY\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_10\(3),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES_0\(3));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_XZZERO_1_32: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000010000100001")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_32\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZXBUS\(46),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZXBUS\(18),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(46),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(18));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_XZZERO_1_30: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000010000100001")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_30\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZXBUS\(23),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZXBUS\(17),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(23),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(17));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_XZZERO_1_29: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000010000100001")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_29\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZXBUS\(26),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZXBUS\(21),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(26),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(21));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_XZZERO_1_28: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000010000100001")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_28\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZXBUS\(24),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZXBUS\(16),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(24),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(16));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_XZZERO_1_27: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000010000100001")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_27\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZXBUS\(47),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZXBUS\(34),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(47),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(34));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_XZZERO_1_25: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000010000100001")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_25\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZXBUS\(32),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZXBUS\(28),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(32),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(28));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_XZZERO_1_22: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000010000100001")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_22\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZXBUS\(56),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZXBUS\(48),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(56),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(48));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_XZZERO_1_21: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000010000100001")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_21\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZXBUS\(54),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZXBUS\(53),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(54),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(53));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_XZZERO_1_18: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000010000100001")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_18\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZXBUS\(39),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZXBUS\(33),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(39),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(33));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_XZZERO_1_17: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000010000100001")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_17\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZXBUS\(52),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZXBUS\(30),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(52),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(30));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_XZZERO_1_16: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000010000100001")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_16\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZXBUS\(44),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZXBUS\(20),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(44),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(20));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_XZZERO_1_15: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000010000100001")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_15\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZXBUS\(51),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZXBUS\(41),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(51),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(41));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_XZZERO_1_14: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000010000100001")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_14\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZXBUS\(25),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZXBUS\(15),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(25),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(15));
GRLFPC20_R_I_EXEC_RNO_0: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1111000010000000")
port map (
combout => \GRLFPC20.R.I.EXEC_0_0_G1_0_I_0_0\,
dataa => \GRLFPC20.R.I.EXEC\,
datab => \GRLFPC20.UN1_FPCI_22_X\,
datac => \GRLFPC20.R.I.RDD_0_0_G1_0_574_I_0\,
datad => \GRLFPC20.V.I.EXEC_0_SQMUXA\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_EXPADDERSHFT_UN23_EXPXBUS_NE_3: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1110110110110111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.UN23_EXPXBUS_NE_3\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.EXPXBUS_3\(5),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.EXPXBUS_3\(6),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.GRFPUELOC\(5),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.GRFPUELOC\(6));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_EXPADDERSHFT_UN23_EXPXBUS_NE_2: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1111111110011111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.UN23_EXPXBUS_NE_2\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.EXPXBUS_3\(4),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.GRFPUELOC\(4),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.UN23_EXPXBUS_10\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.UN23_EXPXBUS_NE_0\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_ENTRYSHFT_ENTRYPOINT_2: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000011100000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.ENTRYSHFT.ENTRYPOINT_2\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.ENTRYSHFT.S_CMP_2\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.ENTRYSHFT.UN3_S_SQRT_3\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.ENTRYSHFT.UN10_S_MOV\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.ENTRYSHFT.ENTRYPOINT_0\);
GRLFPC20_UN1_MOV_1_SQMUXA_0: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1111000010000000")
port map (
combout => \GRLFPC20.UN1_MOV_1_SQMUXA_0\,
dataa => \GRLFPC20.COMB.FPDECODE.RDD4_0_A2_0_X\,
datab => \GRLFPC20.MOV_2_SQMUXA_2\,
datac => \GRLFPC20.COMB.FPDECODE.FPOP2_0_A2\,
datad => \GRLFPC20.COMB.FPDECODE.RDD5_0_A3\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_EXPBREGLOADEN: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1111111011110000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.EXPBREGLOADEN\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(25),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(26),
datac => \GRLFPC20.FPI.LDOP\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.CTRLAREGEXP.EXPAREGLOADEN_1\);
GRLFPC20_R_A_MOV_RNO: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010000000000000")
port map (
combout => \GRLFPC20.R.A.MOV_0_0_G1\,
dataa => N_48,
datab => N_49,
datac => \GRLFPC20.R.A.MOV_0_0_G1_3\,
datad => \GRLFPC20.R.A.MOV_0_0_G1_0_X\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_79_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1011111100000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.MULTIPLEXORMULXFF.RESULT_1_IV_I_0_6__G0\,
dataa => N_51,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOINSTANDNOEXC_41_2\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.PCTRL_NEW_12_32\(75),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.MULTIPLEXORMULXFF.RESULT_1_IV_I_0_6__G0_0\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_80_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1011111100000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.MULTIPLEXORMULXFF.RESULT_1_IV_I_0_5__G0\,
dataa => N_48,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOINSTANDNOEXC_41_2\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.PCTRL_NEW_12_32\(75),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.MULTIPLEXORMULXFF.RESULT_1_IV_I_0_5__G0_0\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNIS3A83_370_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010110111010010")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULLSBLOGIC.STCKYPAIR.UN10_NOTPROP_0_0_A3\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(370),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULLSBLOGIC.TEMP_2\(0),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULLSBLOGIC.STCKYPAIR.UN10_NOTPROP_0_2_I_O3\);
\GRLFPC20_R_FSR_FTT_RNO_1_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1011000000000000")
port map (
combout => \GRLFPC20.R.FSR.FTT_1_0_1__G2_0_624_I\,
dataa => \GRLFPC20.R.X.FPOP\,
datab => \GRLFPC20.R.FSR.FTT_1_0_0__G2_0_600_I_A6_1_0\,
datac => \GRLFPC20.R.FSR.FTT_1_0_1__G2_0_624_I_1\,
datad => \GRLFPC20.COMB.UN1_MEXC_1\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_INEXACTSIG_UN13_INEXACT: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000000000000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.INEXACTSIG.UN13_INEXACT\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.INEXACTSIG.UN13_INEXACT_14\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.INEXACTSIG.UN13_INEXACT_15\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.INEXACTSIG.NOTAM2\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.INEXACTSIG.UN13_INEXACT_27\);
\GRLFPC20_R_FSR_FTT_RNO_0_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000110010001100")
port map (
combout => \GRLFPC20.R.FSR.FTT_1_0_0__G2_0_600_I\,
dataa => \GRLFPC20.R.I.EXC\(5),
datab => \GRLFPC20.R.FSR.FTT_1_0_0__G2_0_600_I_1\,
datac => \GRLFPC20.COMB.UN1_MEXC_1\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_78_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1011111100000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.MULTIPLEXORMULXFF.RESULT_1_IV_I_0_7__G0\,
dataa => N_55,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOINSTANDNOEXC_41_2\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.PCTRL_NEW_12_32\(75),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.MULTIPLEXORMULXFF.RESULT_1_IV_I_0_7__G0_0\);
GRLFPC20_WREN2_1_SQMUXA_1: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1110000000000000")
port map (
combout => \GRLFPC20.WREN2_1_SQMUXA_1\,
dataa => N_351,
datab => N_352,
datac => \GRLFPC20.WREN1_0_SQMUXA_1_X\,
datad => \GRLFPC20.WREN2_1_SQMUXA_1_1_X\);
GRLFPC20_WREN2_2_SQMUXA_1: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0001000000000000")
port map (
combout => \GRLFPC20.WREN2_2_SQMUXA_1\,
dataa => N_339,
datab => \GRLFPC20.R.X.AFSR\,
datac => \GRLFPC20.R.X.LD\,
datad => \GRLFPC20.WREN2_1_SQMUXA_1_1_X\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_1_83_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0011001100000111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.MULTIPLEXORMULXFF.RESULT_M4_3\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_PCTRL_NEW_43_2_0\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.PCTRL_I_M_0\(3),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.MULTIPLEXORMULXFF.RESULT_M1_0_A2_3\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.PCTRL_NEW_12_31\(75));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_UN18_XZXBUS_3: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0110011001100110")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN18_XZXBUS_3\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZXBUS\(3),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_M5_0\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_2_9_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010111011010001")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_2\(9),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(19),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(8),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(58),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_M5_6\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_2_8_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010111011010001")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_2\(8),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(19),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(8),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(58),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_M5_5\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_2_7_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010111011010001")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_2\(7),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(19),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(8),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(58),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_M5_4\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_2_6_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010111011010001")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_2\(6),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(19),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(8),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(58),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_M5_3\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_2_5_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010111011010001")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_2\(5),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(19),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(8),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(58),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_M5_2\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_2_4_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010111011010001")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_2\(4),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(19),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(8),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(58),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_M5_1\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_2_3_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010111011010001")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_2\(3),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(19),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(8),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(58),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_M5_0\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_2_1_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010111011010001")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_2\(1),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(19),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(8),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(58),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.EXTEND.TEMP\(1));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_UN18_XZXBUS_2: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0110011001100110")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN18_XZXBUS_2\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZXBUS\(2),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_M5\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_2_2_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010111011010001")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_2\(2),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(19),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(8),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(58),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_M5\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_16_12_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000101101001111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_16\(12),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(15),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(42),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_10\(12),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_10\(11));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_16_13_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000101101001111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_16\(13),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(15),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(42),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_10\(13),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_10\(12));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_16_14_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000101101001111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_16\(14),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(15),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(42),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_10\(14),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_10\(13));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_16_16_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000101101001111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_16\(16),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(15),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(42),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_10\(16),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_10\(15));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_16_56_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000101101001111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_16\(56),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(15),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(42),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_10\(56),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_10\(55));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_16_27_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000101101001111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_16\(27),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(15),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(42),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_10\(27),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_10\(26));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_16_40_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000101101001111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_16\(40),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(15),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(42),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_10\(40),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_10\(39));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_16_42_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000101101001111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_16\(42),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(15),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(42),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_10\(42),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_10\(41));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_16_44_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000101101001111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_16\(44),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(15),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(42),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_10\(44),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_10\(43));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_16_48_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000101101001111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_16\(48),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(15),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(42),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_10\(48),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_10\(47));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_16_50_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000101101001111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_16\(50),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(15),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(42),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_10\(50),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_10\(49));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_16_51_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000101101001111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_16\(51),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(15),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(42),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_10\(51),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_10\(50));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_16_49_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000101101001111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_16\(49),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(15),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(42),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_10\(49),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_10\(48));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_16_10_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000101101001111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_16\(10),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(15),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(42),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_10\(10),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_10\(9));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_16_11_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000101101001111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_16\(11),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(15),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(42),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_10\(11),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_10\(10));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_16_22_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000010010111111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_16\(22),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(15),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(42),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_10\(21),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_10\(22));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_16_23_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000101101001111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_16\(23),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(15),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(42),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_10\(23),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_10\(22));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_16_24_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000101101001111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_16\(24),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(15),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(42),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_10\(24),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_10\(23));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_16_25_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000101101001111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_16\(25),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(15),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(42),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_10\(25),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_10\(24));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_16_26_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000101101001111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_16\(26),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(15),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(42),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_10\(26),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_10\(25));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_16_28_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000101101001111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_16\(28),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(15),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(42),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_10\(28),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_10\(27));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_16_30_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000010010111111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_16\(30),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(15),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(42),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_10\(29),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_10\(30));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_16_31_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000101101001111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_16\(31),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(15),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(42),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_10\(31),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_10\(30));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_16_37_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000101101001111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_16\(37),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(15),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(42),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_10\(37),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_10\(36));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_16_38_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000101101001111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_16\(38),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(15),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(42),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_10\(38),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_10\(37));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_16_39_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000101101001111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_16\(39),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(15),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(42),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_10\(39),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_10\(38));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_16_41_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000101101001111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_16\(41),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(15),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(42),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_10\(41),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_10\(40));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_16_18_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000010010111111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_16\(18),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(15),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(42),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_10\(17),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_10\(18));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_16_19_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000010010111111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_16\(19),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(15),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(42),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_10\(18),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_10\(19));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_16_20_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000101101001111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_16\(20),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(15),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(42),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_10\(20),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_10\(19));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_16_21_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0100000011111011")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_16\(21),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(15),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(42),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(19),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_16_A\(21));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_16_A_21_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000011110001111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_16_A\(21),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(42),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.GRFPUE_ADD0\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(21),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(20));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_16_35_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0100000011111011")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_16\(35),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(15),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(42),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(33),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_16_A\(35));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_16_A_35_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000011110001111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_16_A\(35),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(42),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.GRFPUE_ADD0\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(35),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(34));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_16_36_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0100000011111011")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_16\(36),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(15),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(42),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(34),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_16_A\(36));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_16_A_36_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000011110001111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_16_A\(36),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(42),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.GRFPUE_ADD0\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(36),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(35));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_16_47_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000101101001111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_16\(47),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(15),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(42),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_10\(47),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_10\(46));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_16_52_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000010010111111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_16\(52),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(15),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(42),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_10\(51),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_10\(52));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_16_32_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0100000011111011")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_16\(32),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(15),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(42),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(30),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_16_A\(32));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_16_A_32_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000011110001111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_16_A\(32),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(42),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.GRFPUE_ADD0\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(32),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(31));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_16_33_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000010010111111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_16\(33),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(15),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(42),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_10\(32),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_10\(33));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_16_34_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000101101001111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_16\(34),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(15),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(42),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_10\(34),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_10\(33));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_16_45_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000101101001111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_16\(45),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(15),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(42),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_10\(45),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_10\(44));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_16_17_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000010010111111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_16\(17),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(15),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(42),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_10\(16),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_10\(17));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_375_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000000000100100")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_0_375__G0\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_GRFPUF_0\(2),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_GRFPUF_0\(1),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_GRFPUF_0\(0),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_0_375__G0_A\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_0_375_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0001010000010100")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_0_375__G0_A\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH_2\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_GRFPUF_0\(3),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_GRFPUF_0\(1));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_16_54_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0100000011111011")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_16\(54),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(15),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(42),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(52),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_16_A\(54));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_16_A_54_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000011110001111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_16_A\(54),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(42),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.GRFPUE_ADD0\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(54),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(53));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_16_15_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000101101001111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_16\(15),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(15),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(42),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_10\(15),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_10\(14));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_54_TRFWWBASICCELL_TEMP2_1_RNISEO81: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0111100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_1299_SUM2\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.54.TRFWWBASICCELL.TEMP2_1\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN20_ZERO\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.CTRLXERSHFT.SUMIN_5\(57),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.55.TRFWWBASICCELL.CIN_10\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_0_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1111111001010100")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES\(0),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(45),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.S_8\(57),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRTOSTICKY\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES_0\(0));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_16_53_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000101101001111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_16\(53),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(15),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(42),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_10\(53),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_10\(52));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_113_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0100000001000101")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH\(113),
dataa => \GRLFPC20.FPI.LDOP\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(113),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.DPATH_NEW_7_SQMUXA\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_A\(113));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_A_113_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0100011101000111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_A\(113),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_M1\(113),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_M2S2\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_M0\(113));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_1_11_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1100110001010000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(11),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN3_NOTXZYFROMD\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_0\(11),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_M3_E_2\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_M2_7\);
GRLFPC20_RS1V_0_SQMUXA: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000000000000000")
port map (
combout => \GRLFPC20.RS1V_0_SQMUXA\,
dataa => N_74,
datab => N_73,
datac => \GRLFPC20.RS1V_0_SQMUXA_A\,
datad => \GRLFPC20.RS1D_CNST_0_A2_2_X\);
GRLFPC20_RS1V_0_SQMUXA_A: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0001000000000001")
port map (
combout => \GRLFPC20.RS1V_0_SQMUXA_A\,
dataa => N_65,
datab => N_66,
datac => N_62,
datad => N_63);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNI3UAN2_370_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101001011010010")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.SUM_I\(0),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(370),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULLSBLOGIC.STCKYPAIR.UN10_NOTPROP_0_2_I_O3\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_MULLSBLOGIC_STCKYPAIR_UN4_STKOUT: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000010111111110")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULLSBLOGIC.STCKYPAIR.UN4_STKOUT\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.CTRLXERSHFT.MIXOIN_3\(1),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.CTRLXERSHFT.MIXOIN_3\(0),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.CTRLXERSHFT.SUMIN_5\(1),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULLSBLOGIC.STCKYPAIR.UN6_NOTPROP\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN2_MIXOIN_0_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101111100001101")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN2_MIXOIN\(0),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(371),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.CTRLXERSHFT.SUMIN_5\(2),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN2_MIXOIN_A\(0));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN2_MIXOIN_A_0_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0001011100010111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN2_MIXOIN_A\(0),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.CTRLXERSHFT.MIXOIN_3\(1),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.CTRLXERSHFT.MIXOIN_3\(0),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.CTRLXERSHFT.SUMIN_5\(1));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_16_43_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000101101001111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_16\(43),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(15),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(42),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_10\(43),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_10\(42));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_1_12_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1100110001010000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(12),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN3_NOTXZYFROMD\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_0\(12),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_M3_E_0_2\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_M2_7\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_1_13_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1100110001010000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(13),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN3_NOTXZYFROMD\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_0\(13),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_M3_E_1_2\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_M2_7\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_SCTRL_RNO_6_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000001000000010")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SXC.SCTRL_NEW\(6),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SXC.SCTRL_NEW\(10),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SXC.SCTRL_NEW\(9),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SXC.SCTRL_NEW\(8));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_WQSTSETS_0_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100011011000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_WQSTSETS\(0),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(45),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_COUNTSUCCESSIVEZERO18\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.UN11_WQSTSETS_0\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRTOSTICKY\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_16_46_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000101101001111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_16\(46),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(15),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(42),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_10\(46),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_10\(45));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_CTRLAREGEXP_EXPAREGLOADEN_1_RNICMUB1: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0011001100100000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_SN_M2\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(27),
datab => \GRLFPC20.FPI.LDOP\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.CTRLAREGEXP.EXPAREGLOADEN_1\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.EXPAREGLOADEN_1\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_UN14_CONDITIONAL: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.UN14_CONDITIONAL\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.WQSTSETS\(5),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.WQSTSETS\(3));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_OPREXCSHFT_UN3_OPREXC: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1111111000000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.OPREXCSHFT.UN3_OPREXC\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.WQSTSETS_4\(6),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.WQSTSETS_5\(6),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.AEBEEXC.UN3_NOTBZERODENORM\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.WQSTSETS\(4));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN2_DIVMULTV_0_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000001001000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN2_DIVMULTV\(0),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_GRFPUF_0\(3),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_GRFPUF_0\(2),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_GRFPUF_0\(1),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_GRFPUF_0\(0));
GRLFPC20_R_I_EXEC_RNO_1: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000110010001100")
port map (
combout => \GRLFPC20.R.I.EXEC_0_0_G1_0_I_A8_0\,
dataa => \GRLFPC20.R.I.EXC\(5),
datab => \GRLFPC20.R.I.V\,
datac => \GRLFPC20.COMB.UN1_MEXC_1\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_16_29_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000101101001111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_16\(29),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(15),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(42),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_10\(29),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_10\(28));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_0_78_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1011000010110000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.MULTIPLEXORMULXFF.RESULT_1_IV_I_0_7__G0_0\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(84),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSAMPLEDWAIT\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.MULTIPLEXORMULXFF.RESULT_M4_4\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_0_80_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1011000010110000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.MULTIPLEXORMULXFF.RESULT_1_IV_I_0_5__G0_0\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSAMPLEDWAIT\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.MULTIPLEXORMULXFF.RESULT_M4_0\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_0_79_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101111100000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.MULTIPLEXORMULXFF.RESULT_1_IV_I_0_6__G0_0\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(83),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSAMPLEDWAIT\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.MULTIPLEXORMULXFF.RESULT_M4_1\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNIIEAL1_315_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1111110100001100")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_0_315__G3_0\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(373),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(315),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULLSBLOGIC.STCKYPAIR.UN1_NOTPROP_0\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_EXPADDERSHFT_UN23_EXPXBUS_NE_0: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000011111111111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.UN23_EXPXBUS_NE_0\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(233),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.UN20_NOTSLRES\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.UN23_EXPXBUS_11_0\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.UN23_EXPXBUS_12\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_RIGHTSHIFTERBL_NOTSTICKYINFORSR_2_0: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0011000100110001")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.NOTSTICKYINFORSR_2_0\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(2),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.UN40_SHDVAR\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.UN17_SHDVAR\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_1_TRFWWBASICCELL_TEMP2_RNIRJCN1: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0111100001111000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.2.CI_56_SUM1_0\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.1.TRFWWBASICCELL.TEMP2\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN20_ZERO\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.3.CI_55_ADD0\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_EXPADDERSHFT_UN23_EXPXBUS_1_0: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0110011001100110")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.UN23_EXPXBUS_1_0\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(36),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.EXPXBUS_3\(1));
\GRLFPC20_R_FSR_FTT_RNO_0_0_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1100000011100000")
port map (
combout => \GRLFPC20.R.FSR.FTT_1_0_0__G2_0_600_I_1\,
dataa => \GRLFPC20.R.I.EXEC\,
datab => \GRLFPC20.R.X.FPOP\,
datac => \GRLFPC20.R.FSR.FTT_1_0_0__G2_0_600_I_0_X\,
datad => \GRLFPC20.R.FSR.FTT_1_0_0__G2_0_600_I_A6_1_0\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_INEXACTSIG_UN13_INEXACT_27: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000000000000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.INEXACTSIG.UN13_INEXACT_27\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.INEXACTSIG.UN13_INEXACT_16\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.INEXACTSIG.UN13_INEXACT_17\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.INEXACTSIG.UN13_INEXACT_23\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.INEXACTSIG.UN13_INEXACT_24\);
GRLFPC20_COMB_RSDECODE_RS1V2_0: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0001000000000000")
port map (
combout => \GRLFPC20.COMB.RSDECODE.RS1V2_0\,
dataa => N_52,
datab => N_49,
datac => \GRLFPC20.COMB.RSDECODE.RS1V2_0_A\,
datad => \GRLFPC20.COMB.RSDECODE.UN1_FPCI_0_X\);
GRLFPC20_COMB_RSDECODE_RS1V2_0_A: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010111100000000")
port map (
combout => \GRLFPC20.COMB.RSDECODE.RS1V2_0_A\,
dataa => N_51,
datab => N_50,
datac => N_53,
datad => N_48);
GRLFPC20_COMB_RDD_1_M14_0_A2_0_0: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010100000000000")
port map (
combout => \GRLFPC20.COMB.RDD_1.M14_0_A2_0_0\,
dataa => N_54,
datab => N_55,
datac => N_49,
datad => \GRLFPC20.COMB.RDD_1.M14_0_A2_0_0_A\);
GRLFPC20_COMB_RDD_1_M14_0_A2_0_0_A: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000111100100010")
port map (
combout => \GRLFPC20.COMB.RDD_1.M14_0_A2_0_0_A\,
dataa => N_51,
datab => N_50,
datac => N_48,
datad => N_49);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_115_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1011100000000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH\(115),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_M1\(115),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_M2S2\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_M0\(115),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_0\(115));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNI2TFQ_368_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010110111010010")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.2.CI_56_SUM0\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(368),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.CTRLXERSHFT.SUMIN_5\(5),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.2.CI_56_V\(0));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_EXTEND_TEMP_1_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1111111110101000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.EXTEND.TEMP\(1),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(56),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN13_NOTXZYFROMD\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN15_NOTXZYFROMD_0\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.EXTEND.TEMP_1\(1));
GRLFPC20_WREN1_1_SQMUXA: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000100000001000")
port map (
combout => \GRLFPC20.WREN1_1_SQMUXA\,
dataa => \GRLFPC20.WREN1_1_SQMUXA_1\,
datab => \GRLFPC20.WREN1_0_SQMUXA_1_X\,
datac => \GRLFPC20.COMB.UN1_R.I.EXC\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_EXPADDERSHFT_UN23_EXPXBUS_2: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1001011010010110")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.UN23_EXPXBUS_2\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(36),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.EXPXBUS_3\(2),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(2));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_CTRLXERSHFT_SUMIN_5_RNI16741_0_4_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1001010101101010")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.CI_57_SUM0\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.CTRLXERSHFT.MIXOIN_3\(4),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.1.TRFWWBASICCELL.TEMP2_2\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN5_ZERO\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.CTRLXERSHFT.SUMIN_5\(4));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_AEBEEXC_UN26_NOTBINFNAN_4_RNID14F1: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1111011100000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.WQSTSETS\(4),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.AEBEEXC.UN26_NOTBINFNAN_4\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.AEBEEXC.UN26_NOTBINFNAN_5\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.AEBEEXC.UN4_NOTBINFNAN\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.WQSTSETS_0\(4));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNIA2JO1_65_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1100000011000101")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SXC.SCTRL_NEW\(10),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(65),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(11),
datac => \GRLFPC20.FPI.LDOP\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SXC.SCTRL_NEW_A\(10));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNIGPIQ_20_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1001001110010011")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SXC.SCTRL_NEW_A\(10),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(20),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(10),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.UN2_NOTABORTWB\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNI1GSQ1_73_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000001000000010")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.TEMP_20\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(73),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.TEMP_20_A\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.ENTRYSHFT.UN10_S_MOV\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNI7RGD1_74_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0001000111110000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.TEMP_20_A\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(65),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(71),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(74),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(72));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_AEBEEXC_UN4_NOTAINFNAN_RNIQ7TU1: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1111011100000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.WQSTSETS\(3),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.AEBEEXC.UN26_NOTAINFNAN_4\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.AEBEEXC.UN26_NOTAINFNAN_5\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.AEBEEXC.UN4_NOTAINFNAN\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.WQSTSETS_0\(3));
GRLFPC20_ANNULFPU_0_SQMUXA_X_RNIPKTE1: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1110111011101111")
port map (
combout => \GRLFPC20.ANNULRES_1_SQMUXA\,
dataa => \GRLFPC20.R.X.FPOP\,
datab => \GRLFPC20.R.I.EXEC\,
datac => \GRLFPC20.ANNULFPU_0_SQMUXA_X\,
datad => \GRLFPC20.ANNULRES_1_SQMUXA_A\);
GRLFPC20_ANNULFPU_0_SQMUXA_1_X_RNIBSDG: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0011001100010000")
port map (
combout => \GRLFPC20.ANNULRES_1_SQMUXA_A\,
dataa => \GRLFPC20.R.E.FPOP\,
datab => \GRLFPC20.R.M.FPOP\,
datac => \GRLFPC20.ANNULFPU_0_SQMUXA_2_X\,
datad => \GRLFPC20.ANNULFPU_0_SQMUXA_1_X\);
GRLFPC20_R_A_ST_RNO: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000100000000000")
port map (
combout => \GRLFPC20.R.A.ST_0_0_G1\,
dataa => \GRLFPC20.N_1243_I_0_A2_1_X\,
datab => \GRLFPC20.COMB.FPDECODE.ST_0_A2\,
datac => CPO_EXCZ,
datad => \GRLFPC20.COMB.V.A.RF2REN_1_0_701_I_948_X\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_ENTRYSHFT_UN1_ENTRYPOINT: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000000000100000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.ENTRYSHFT.UN1_ENTRYPOINT\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(78),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(85),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(82),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.ENTRYSHFT.UN1_S\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_1_0_RNIRCSB2_9_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1110010010100000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_M5_6\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN25_NOTXZYFROMD\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_0\(9),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_M4_6\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_M1_0\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_1_0_RNIRCSB2_8_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1110010010100000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_M5_5\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN25_NOTXZYFROMD\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_0\(8),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_M4_5\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_M1_0\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_1_0_RNIRCSB2_7_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1110010010100000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_M5_4\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN25_NOTXZYFROMD\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_0\(7),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_M4_4\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_M1_0\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_1_0_RNIRCSB2_6_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1110010010100000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_M5_3\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN25_NOTXZYFROMD\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_0\(6),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_M4_3\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_M1_0\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_1_0_RNIRCSB2_5_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1110010010100000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_M5_2\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN25_NOTXZYFROMD\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_0\(5),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_M4_2\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_M1_0\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_UN25_NOTXZYFROMD_RNIM5803: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1011000110100000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_M5_1\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN25_NOTXZYFROMD\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_M5_1_A\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_M4_1\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_M1_0\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNITOR11_52_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0011001100110101")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_M5_1_A\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(52),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(53),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN13_NOTXZYFROMD_REP2\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN15_NOTXZYFROMD_0_REP2\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_UN25_NOTXZYFROMD_RNIP8803: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1011000110100000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_M5_0\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN25_NOTXZYFROMD\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_M5_0_A\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_M4_0\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_M1_0\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNIVQR11_53_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0011001100110101")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_M5_0_A\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(53),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(54),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN13_NOTXZYFROMD_REP2\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN15_NOTXZYFROMD_0_REP2\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_UN3_NOTXZYFROMD_RNIQ9CH3: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010000001110101")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_M5\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN25_NOTXZYFROMD\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN3_NOTXZYFROMD\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_M4_1_0\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_M3\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_CI_114_1_SUM_5_0_A2_0_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1001010101101010")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.CI_114_1.SUM_5_0_A2\(0),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.CTRLXERSHFT.MIXOIN_3\(57),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.TRFWWBASICCELL.TEMP2_2\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN5_ZERO\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.CTRLXERSHFT.SUMIN_5\(57));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_55_TRFWWBASICCELL_TEMP2_1_RNI9HRN_0: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1001010101101010")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.CI_2_SUM0\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.CTRLXERSHFT.MIXOIN_3\(57),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.55.TRFWWBASICCELL.TEMP2_1\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN5_ZERO\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.CTRLXERSHFT.SUMIN_5\(57));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_RIGHTSHIFTERBL_UN7_SHDVAR: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010101000101010")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.UN7_SHDVAR\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(1),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_0\(56),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_0\(57));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_UN18_XZXBUS_38: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0111100001111000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN18_XZXBUS_38\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(77),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(17),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(38));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_UN18_XZXBUS_37: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0111100001111000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN18_XZXBUS_37\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(78),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(17),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(37));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_UN18_XZXBUS_35: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0111100001111000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN18_XZXBUS_35\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(80),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(17),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(35));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_2_56_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010111011010001")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_2\(56),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(19),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(8),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(58),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(56));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_2_55_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010111011010001")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_2\(55),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(19),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(8),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(58),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(55));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_2_54_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010111011010001")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_2\(54),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(19),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(8),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(58),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(54));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_2_53_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010111011010001")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_2\(53),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(19),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(8),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(58),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(53));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_2_52_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010111011010001")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_2\(52),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(19),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(8),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(58),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(52));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_2_51_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010111011010001")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_2\(51),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(19),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(8),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(58),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(51));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_2_50_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010111011010001")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_2\(50),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(19),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(8),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(58),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(50));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_2_49_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010111011010001")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_2\(49),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(19),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(8),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(58),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(49));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_2_48_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010111011010001")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_2\(48),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(19),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(8),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(58),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(48));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_2_47_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010111011010001")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_2\(47),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(19),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(8),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(58),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(47));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_2_46_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010111011010001")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_2\(46),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(19),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(8),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(58),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(46));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_2_45_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010111011010001")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_2\(45),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(19),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(8),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(58),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(45));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_2_44_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010111011010001")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_2\(44),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(19),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(8),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(58),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(44));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_2_41_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010111011010001")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_2\(41),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(19),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(8),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(58),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(41));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_2_40_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010111011010001")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_2\(40),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(19),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(8),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(58),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(40));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_2_39_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010111011010001")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_2\(39),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(19),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(8),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(58),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(39));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_2_38_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010111011010001")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_2\(38),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(19),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(8),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(58),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(38));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_2_37_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010111011010001")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_2\(37),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(19),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(8),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(58),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(37));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_2_36_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010111011010001")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_2\(36),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(19),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(8),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(58),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(36));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_2_35_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010111011010001")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_2\(35),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(19),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(8),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(58),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(35));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_2_34_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010111011010001")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_2\(34),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(19),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(8),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(58),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(34));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_2_33_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010111011010001")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_2\(33),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(19),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(8),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(58),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(33));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_2_32_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010111011010001")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_2\(32),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(19),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(8),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(58),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(32));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_2_30_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010111011010001")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_2\(30),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(19),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(8),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(58),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(30));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_2_29_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010111011010001")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_2\(29),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(19),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(8),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(58),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(29));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_2_28_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010111011010001")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_2\(28),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(19),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(8),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(58),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(28));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_2_27_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010111011010001")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_2\(27),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(19),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(8),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(58),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(27));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_2_25_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010111011010001")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_2\(25),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(19),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(8),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(58),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(25));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_2_24_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010111011010001")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_2\(24),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(19),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(8),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(58),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(24));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_2_23_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010111011010001")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_2\(23),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(19),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(8),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(58),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(23));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_2_22_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010111011010001")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_2\(22),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(19),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(8),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(58),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(22));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_2_21_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010111011010001")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_2\(21),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(19),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(8),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(58),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(21));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_2_20_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010111011010001")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_2\(20),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(19),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(8),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(58),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(20));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_2_19_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010111011010001")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_2\(19),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(19),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(8),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(58),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(19));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_2_17_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010111011010001")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_2\(17),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(19),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(8),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(58),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(17));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_2_16_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010111011010001")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_2\(16),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(19),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(8),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(58),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(16));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_2_15_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010111011010001")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_2\(15),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(19),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(8),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(58),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(15));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_2_14_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0110011001011010")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_2\(14),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_SUB\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_0\(14),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_M1_E_3\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_M2_7_REP1\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_2_0_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010111011010001")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_2\(0),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(19),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(8),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(58),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.EXTEND.TEMP\(0));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_UN18_XZXBUS_42: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0111100001111000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN18_XZXBUS_42\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(73),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(17),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(42));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_2_42_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010111011010001")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_2\(42),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(19),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(8),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(58),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(42));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_2_26_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010111011010001")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_2\(26),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(19),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(8),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(58),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(26));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_2_18_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010111011010001")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_2\(18),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(19),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(8),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(58),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(18));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_2_10_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0110011001011010")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_2\(10),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_SUB\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_0\(10),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_M1_E\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_M2_7_REP1\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_10_5_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010011100100111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_10\(5),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(4),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(5));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_10_4_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010011100100111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_10\(4),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(3),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(4));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_10_6_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010011100100111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_10\(6),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(5),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(6));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_10_41_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0001101100011011")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_10\(41),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(41),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(40));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_10_11_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010011100100111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_10\(11),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(10),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(11));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_10_12_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0001101100011011")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_10\(12),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(12),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(11));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_10_13_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010011100100111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_10\(13),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(12),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(13));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_10_14_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0001101100011011")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_10\(14),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(14),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(13));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_10_15_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0001101100011011")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_10\(15),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(15),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(14));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_10_16_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010011100100111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_10\(16),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(15),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(16));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_10_17_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010011100100111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_10\(17),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(16),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(17));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_10_22_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0001101100011011")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_10\(22),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(22),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(21));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_10_23_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010011100100111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_10\(23),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(22),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(23));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_10_24_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010011100100111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_10\(24),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(23),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(24));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_10_25_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010011100100111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_10\(25),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(24),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(25));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_10_26_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010011100100111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_10\(26),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(25),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(26));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_10_27_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010011100100111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_10\(27),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(26),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(27));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_10_28_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010011100100111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_10\(28),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(27),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(28));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_10_29_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010011100100111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_10\(29),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(28),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(29));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_10_36_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0001101100011011")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_10\(36),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(36),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(35));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_10_37_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010011100100111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_10\(37),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(36),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(37));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_10_38_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010011100100111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_10\(38),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(37),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(38));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_10_39_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0001101100011011")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_10\(39),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(39),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(38));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_10_40_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010011100100111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_10\(40),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(39),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(40));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_10_42_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010011100100111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_10\(42),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(41),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(42));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_10_43_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0001101100011011")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_10\(43),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(43),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(42));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_10_44_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010011100100111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_10\(44),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(43),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(44));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_10_45_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0001101100011011")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_10\(45),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(45),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(44));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_10_46_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010011100100111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_10\(46),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(45),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(46));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_10_47_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0001101100011011")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_10\(47),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(47),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(46));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_10_18_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010011100100111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_10\(18),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(17),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(18));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_10_19_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010011100100111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_10\(19),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(18),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(19));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_10_20_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010011100100111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_10\(20),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(19),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(20));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_10_21_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010011100100111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_10\(21),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(20),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(21));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_10_52_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010011100100111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_10\(52),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(51),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(52));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_10_53_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010011100100111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_10\(53),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(52),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(53));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_10_54_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010011100100111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_10\(54),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(53),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(54));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_10_30_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010011100100111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_10\(30),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(29),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(30));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_10_31_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010011100100111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_10\(31),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(30),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(31));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_10_32_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010011100100111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_10\(32),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(31),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(32));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_10_33_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0001101100011011")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_10\(33),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(33),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(32));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_10_34_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010011100100111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_10\(34),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(33),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(34));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_10_48_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010011100100111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_10\(48),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(47),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(48));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_10_49_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010011100100111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_10\(49),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(48),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(49));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_10_50_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010011100100111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_10\(50),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(49),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(50));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_10_51_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010011100100111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_10\(51),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(50),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(51));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_10_57_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010011100100111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_10\(57),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(56),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(57));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_0_1_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010011100100111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES_0\(1),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26\(2),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26\(1));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_10_1_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1111000111100000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_10\(1),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(1),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.S_8\(57),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_0\(1));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_10_8_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010011100100111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_10\(8),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(7),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(8));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_0_2_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0001101100011011")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES_0\(2),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26\(2),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26\(3));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_10_2_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010011100100111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_10\(2),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(1),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(2));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_10_9_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010011100100111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_10\(9),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(8),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(9));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_10_10_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0001101100011011")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_10\(10),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(10),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(9));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_142_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1111100001110000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH\(142),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(1),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.UN2_NOTABORTWB\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_0\(142),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_14\(142));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_55_TRFWWBASICCELL_TEMP2_1_RNIIRGN: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0111100001111000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_1299_AXB0\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.55.TRFWWBASICCELL.TEMP2_1\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN5_ZERO\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.CTRLXERSHFT.SUMIN_5\(57));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_0_0_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0001101100011011")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES_0\(0),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26\(0),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26\(1));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_172_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1100000011100010")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_172__G0_0\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.CTRLCREGXZ.UN1_INFORCREGDB\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_SN_M3_1\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_172__G0_0_M3\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.SELECTQUOBITS.QUOBITS\(0));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_T_3_0_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0100011001110110")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_T_3\(0),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(377),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.SELECTQUOBITS.NOTDIVC\(1),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.SELECTQUOBITS.NOTDIVC\(0),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_ADD57\);
\GRLFPC20_R_I_EXC_RNO_3_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1111000011100010")
port map (
combout => \GRLFPC20.R.I.EXC_2_0_3__G0\,
dataa => \GRLFPC20.R.I.EXC\(3),
datab => \GRLFPC20.COMB.UN2_HOLDN\,
datac => \GRLFPC20.R.I.EXC_2_0_3__G3\,
datad => \GRLFPC20.COMB.UN19_IUEXEC\);
GRLFPC20_COMB_FPDECODE_RDD3_TZ: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000000000000010")
port map (
combout => \GRLFPC20.COMB.FPDECODE.RDD3_TZ\,
dataa => N_49,
datab => N_48,
datac => N_51,
datad => \GRLFPC20.COMB.FPDECODE.RDD3_TZ_A\);
GRLFPC20_COMB_FPDECODE_RDD3_TZ_A: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010001111101111")
port map (
combout => \GRLFPC20.COMB.FPDECODE.RDD3_TZ_A\,
dataa => N_53,
datab => N_50,
datac => \GRLFPC20.COMB.FPDECODE.UN1_FPCI_7_1_X\,
datad => \GRLFPC20.COMB.FPDECODE.UN1_FPCI_0_7_2\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_10_56_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0001101100011011")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_10\(56),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(56),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(55));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_10_55_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0001101100011011")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_10\(55),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(55),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(54));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_2_43_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010111011010001")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_2\(43),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(19),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(8),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(58),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(43));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_UN18_XZXBUS_43: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0111100001111000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN18_XZXBUS_43\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(72),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(17),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(43));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_10_7_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0001101100011011")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_10\(7),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(7),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(6));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_CTRLXERSHFT_SUMIN_5_0_RNIDCD52_0_3_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010000000000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULLSBLOGIC.TEMP_1\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.CTRLXERSHFT.SUMIN_5_0\(3),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.CTRLXERSHFT.SUMIN_5_SN_M1\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.0.TRFWWBASICCELL.TEMP2_1\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN5_ZERO\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_CTRLXERSHFT_SUMIN_5_0_RNIDCD52_3_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101001000100010")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULLSBLOGIC.STCKYPAIR.UN10_NOTPROP_0_2_I_O3\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.CTRLXERSHFT.SUMIN_5_0\(3),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.CTRLXERSHFT.SUMIN_5_SN_M1\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.0.TRFWWBASICCELL.TEMP2_1\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN5_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_SXC_UN53_SCTRL_NEW: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000000011000101")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SXC.UN53_SCTRL_NEW\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(9),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SXC.RNDMODESELECT.UN17_U_RDN\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SXC.RNDMODESELECT.TEMP\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SXC.SCTRL_NEW\(8));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_EXPADDERSHFT_NORMDETECT_NOTSLFROMNORM_17_3_0__M3\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010001110100011")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.NORMDETECT.NOTSLFROMNORM_17_3_0_.M3\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(2),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_COUNTSUCCESSIVEZERO18\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.COUNTSUCCESSIVEZERO_M14\(1));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_UN30_CONDITIONAL_M5: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0111111100010101")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.UN30_CONDITIONAL_M5\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(10),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.UN30_CONDITIONAL_M2_E_4\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.UN30_CONDITIONAL_M2_E_3\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.UN30_CONDITIONAL_M5_A\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_UN30_CONDITIONAL_M5_A: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0001010101010111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.UN30_CONDITIONAL_M5_A\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(10),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUE_ADD8\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUE_ADD9\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUE_ADD10\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_EXPADDERSHFT_NORMDETECT_NOTSLFROMNORM_17_3_0__M2\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010001110100011")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.NORMDETECT.NOTSLFROMNORM_17_3_0_.M2\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(2),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_COUNTSUCCESSIVEZERO18\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.COUNTSUCCESSIVEZERO_M14\(0));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_EXPADDERSHFT_NORMDETECT_NOTSLFROMNORM_17_3_0__M4\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010001110100011")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.NORMDETECT.NOTSLFROMNORM_17_3_0_.M4\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(2),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_COUNTSUCCESSIVEZERO18\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.COUNTSUCCESSIVEZERO_M14\(2));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_EXPADDERSHFT_GRFPUELOC_8_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0110011001100110")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.GRFPUELOC\(8),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(36),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.EXPYBUS\(8));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_235_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010000011001100")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH\(235),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(27),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_0\(235),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1\(235),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_SN_M2\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_EXPAREGLOADEN_1: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1100111011001100")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.EXPAREGLOADEN_1\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(28),
datab => \GRLFPC20.FPI.LDOP\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.WQSCTRL\(68),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.UN2_NOTABORTWB\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_234_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010000011001100")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH\(234),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(27),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_0\(234),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1\(234),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_SN_M2\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_236_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100011110000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH\(236),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(27),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1\(236),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_0\(236),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_SN_M2\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_EXPADDERSHFT_GRFPUELOC_9_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0110011001100110")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.GRFPUELOC\(9),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(36),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.EXPYBUS\(9));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_EXPADDERSHFT_GRFPUELOC_7_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0110011001100110")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.GRFPUELOC\(7),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(36),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.EXPYBUS\(7));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_2_81_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1110001011100010")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.RESULT\(4),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(56),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.G_37\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.CHECKOVANDDENORM.UN13_NOTPOSSIBLEOV\);
GRLFPC20_COMB_V_I_EXEC_5_IV: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1111100011111000")
port map (
combout => \GRLFPC20.COMB.V.I.EXEC_5_IV\,
dataa => \GRLFPC20.R.I.EXEC\,
datab => \GRLFPC20.UN1_FPCI_22_X\,
datac => \GRLFPC20.V.I.EXEC_0_SQMUXA\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_10_3_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010011100100111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_10\(3),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(2),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(3));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_MULLSBLOGIC_STCKYPAIR_UN36_STKGEN_0: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000111101110000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULLSBLOGIC.STCKYPAIR.UN36_STKGEN_0\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH_0\(3),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH_125\(4),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH_134\(2),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.3.CI_55_ADD2\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_UN11_WQSTSETS_0: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1111110001010101")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.UN11_WQSTSETS_0\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.UN4_NOTSHIFTCOUNT1_0\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.GRFPUE_ADD4\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.GRFPUE_ADD5\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.TEMP\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_ENTRYSHFT_ENTRYPOINT_0: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000000011011111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.ENTRYSHFT.ENTRYPOINT_0\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(82),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.ENTRYSHFT.UN3_S\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.ENTRYSHFT.S_1\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.ENTRYSHFT.S_CMP\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_EXTEND_TEMP_1_1_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000000011111111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.EXTEND.TEMP_1\(1),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(11),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(8),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(58),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.EXTEND.TEMP_1_A\(1));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_EXTEND_TEMP_1_A_1_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0001001101011111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.EXTEND.TEMP_1_A\(1),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(230),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(55),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN25_NOTXZYFROMD\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN3_NOTXZYFROMD\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_1_RNO_13_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000000000100000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_M3_E_1_2\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(218),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN13_NOTXZYFROMD_REP2\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN25_NOTXZYFROMD\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN15_NOTXZYFROMD_0_REP2\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_1_RNO_11_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000000000100000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_M3_E_2\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(220),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN13_NOTXZYFROMD_REP2\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN25_NOTXZYFROMD\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN15_NOTXZYFROMD_0_REP2\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_1_RNO_12_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000000000100000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_M3_E_0_2\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(219),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN13_NOTXZYFROMD_REP2\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN25_NOTXZYFROMD\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN15_NOTXZYFROMD_0_REP2\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_AEBEEXC_UN3_NOTBZERODENORM_RNI8BNJ: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0001010100010101")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.WQSTSETS_0\(4),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(246),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(10),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.AEBEEXC.UN3_NOTBZERODENORM\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_AEBEEXC_UN3_NOTAZERODENORM_0_RNIO7OP: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000001100010011")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.WQSTSETS_0\(3),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(235),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(233),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(10),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.AEBEEXC.UN3_NOTAZERODENORM_0\);
GRLFPC20_WREN1_1_SQMUXA_1: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000000000000001")
port map (
combout => \GRLFPC20.WREN1_1_SQMUXA_1\,
dataa => N_351,
datab => N_352,
datac => \GRLFPC20.COMB.UN1_FPCI_0_X\,
datad => \GRLFPC20.R.X.SEQERR\(0));
GRLFPC20_COMB_RDD_1_M14_0_A2_0_1: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0100001000000000")
port map (
combout => \GRLFPC20.COMB.RDD_1.M14_0_A2_0_1\,
dataa => N_49,
datab => N_48,
datac => N_54,
datad => \GRLFPC20.COMB.FPDECODE.RDD4_0_A2_0_X\);
GRLFPC20_COMB_FPDECODE_FPOP8_I_O3_X_RNI8EF33: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0001000000000000")
port map (
combout => \GRLFPC20.R.A.AFQ_0_0_G1_0\,
dataa => N_65,
datab => N_66,
datac => N_63,
datad => \GRLFPC20.R.A.AFQ_0_0_G1_0_3\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_COUNTSUCCESSIVEZERO_M14S2: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1111111111111110")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.COUNTSUCCESSIVEZERO_M14S2\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(9),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(10),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.COUNTSUCCESSIVEZERO_M8S2\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.COUNTSUCCESSIVEZERO_M11S4\);
GRLFPC20_COMB_RSDECODE_UN1_FPCI_0_X_RNIGOBD1: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0001000000000000")
port map (
combout => \GRLFPC20.R.A.RS1D_0_0_G4\,
dataa => N_51,
datab => N_53,
datac => \GRLFPC20.R.A.RS1D_0_0_G4_1_X\,
datad => \GRLFPC20.COMB.RSDECODE.UN1_FPCI_0_X\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_DPATH_NEW_7_SQMUXA: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000100000000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.DPATH_NEW_7_SQMUXA\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(7),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.DPATH_NEW_7_SQMUXA_0\,
datac => \GRLFPC20.FPI.LDOP\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.XZAREGLOADEN\);
GRLFPC20_RS2_0_SQMUXA: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0001000000000000")
port map (
combout => \GRLFPC20.RS2_0_SQMUXA\,
dataa => N_65,
datab => N_63,
datac => \GRLFPC20.RS2_0_SQMUXA_0_X\,
datad => \GRLFPC20.COMB.V.A.RF1REN_1_0_650_A2_3_X\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_COUNTSUCCESSIVEZERO18: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000000000000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_COUNTSUCCESSIVEZERO18\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_COUNTSUCCESSIVEZERO18_10\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_COUNTSUCCESSIVEZERO18_11\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_COUNTSUCCESSIVEZERO18_8\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_COUNTSUCCESSIVEZERO18_9\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_EXPADDERSHFT_UN23_EXPXBUS_12: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000011101111000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.UN23_EXPXBUS_12\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(232),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.UN20_NOTSLRES\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(36),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.EXPXBUS_3\(12));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_EXPADDERSHFT_UN23_EXPXBUS_10: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000011101111000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.UN23_EXPXBUS_10\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(234),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.UN20_NOTSLRES\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(36),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.EXPXBUS_3\(10));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_AEBEEXC_UN3_NOTAZERODENORM_0_RNIVK541: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1111111111111110")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.WQSTSETS\(5),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(235),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.WQSTSETS_4\(5),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.WQSTSETS_5\(5),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.AEBEEXC.UN3_NOTAZERODENORM_0\);
GRLFPC20_COMB_UN9_CCV_0: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000000000000111")
port map (
combout => CPO_CCVZ,
dataa => N_269,
datab => \GRLFPC20.R.M.FPOP\,
datac => \GRLFPC20.COMB.UN9_CCV_0_0\,
datad => \GRLFPC20.COMB.UN9_CCV_0_1\);
GRLFPC20_COMB_UN19_IUEXEC: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000001000000000")
port map (
combout => \GRLFPC20.COMB.UN19_IUEXEC\,
dataa => \GRLFPC20.R.MK.BUSY2\,
datab => \GRLFPC20.R.MK.BUSY\,
datac => \GRLFPC20.FPI.LDOP_2\,
datad => \GRLFPC20.COMB.LOCKGEN.DEPCHECK\);
\GRLFPC20_R_I_EXC_RNO_4_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000000010101000")
port map (
combout => \GRLFPC20.R.I.EXC_2_0_4__G3\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(41),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.STATUS\(0),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DECODESTATUS.UN7_STATUS\,
datad => \GRLFPC20.COMB.UN2_HOLDN\);
GRLFPC20_COMB_UN1_MEXC_1: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0111000000000000")
port map (
combout => \GRLFPC20.COMB.UN1_MEXC_1\,
dataa => \GRLFPC20.R.FSR.TEM\(1),
datab => \GRLFPC20.R.I.EXC\(1),
datac => \GRLFPC20.COMB.UN1_MEXC_1_0\,
datad => \GRLFPC20.COMB.UN1_MEXC_1_1\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_ENTRYSHFT_UN10_S_MOV: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000000001110000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.ENTRYSHFT.UN10_S_MOV\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(83),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.ENTRYSHFT.UN10_S_MOV_1\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.ENTRYSHFT.UN3_S\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_ENTRYSHFT_UN1_ENTRYPOINT_RNO: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1110100111111111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.ENTRYSHFT.UN1_S\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(83),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(84),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.ENTRYSHFT.UN1_S_A\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_ENTRYSHFT_UN1_ENTRYPOINT_RNO_0: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000001101100101")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.ENTRYSHFT.UN1_S_A\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(80),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(81),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(84),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_CHECKOVANDDENORM_UN13_NOTPOSSIBLEOV: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000000000000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.CHECKOVANDDENORM.UN13_NOTPOSSIBLEOV\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_ADD51\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_ADD52\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.CHECKOVANDDENORM.UN13_NOTPOSSIBLEOV_3\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.CHECKOVANDDENORM.UN13_NOTPOSSIBLEOV_4\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_EXTEND_TEMP_0_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1111111110101000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.EXTEND.TEMP\(0),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(57),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN13_NOTXZYFROMD\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN15_NOTXZYFROMD_0\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.EXTEND.TEMP_1\(0));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNI8QPI_228_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000000000000010")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_M4_0\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(228),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN13_NOTXZYFROMD_REP2\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN15_NOTXZYFROMD_0_REP2\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN3_NOTXZYFROMD\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNI7PPI_227_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000000000000010")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_M4_1\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(227),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN13_NOTXZYFROMD_REP2\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN15_NOTXZYFROMD_0_REP2\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN3_NOTXZYFROMD\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNI6OPI_226_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000000000000010")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_M4_2\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(226),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN13_NOTXZYFROMD_REP2\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN15_NOTXZYFROMD_0_REP2\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN3_NOTXZYFROMD\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNI5NPI_225_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000000000000010")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_M4_3\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(225),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN13_NOTXZYFROMD_REP2\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN15_NOTXZYFROMD_0_REP2\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN3_NOTXZYFROMD\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNI4MPI_224_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000000000000010")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_M4_4\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(224),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN13_NOTXZYFROMD_REP2\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN15_NOTXZYFROMD_0_REP2\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN3_NOTXZYFROMD\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNI3LPI_223_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000000000000010")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_M4_5\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(223),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN13_NOTXZYFROMD_REP2\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN15_NOTXZYFROMD_0_REP2\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN3_NOTXZYFROMD\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNI2KPI_222_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000000000000010")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_M4_6\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(222),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN13_NOTXZYFROMD_REP2\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN15_NOTXZYFROMD_0_REP2\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN3_NOTXZYFROMD\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_3_83_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101000000010000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.MULTIPLEXORMULXFF.RESULT_M1_0_A2_3\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(58),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.G_37\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.MULTIPLEXORMULXFF.RESULT_M1_0_A2_0_1\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.WQSTSETS\(9));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_1_78_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000111100010101")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.MULTIPLEXORMULXFF.RESULT_M4_4\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.MULTIPLEXORMULXFF.RESULT_M1_0_A2_4\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_PCTRL_NEW_43_2_0\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.PCTRL_I_M_0\(8),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.PCTRL_NEW_12_31\(75));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_1_79_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000111100010101")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.MULTIPLEXORMULXFF.RESULT_M4_1\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.MULTIPLEXORMULXFF.RESULT_M1_0_A2_1\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_PCTRL_NEW_43_2_0\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.PCTRL_I_M_0\(7),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.PCTRL_NEW_12_31\(75));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_1_80_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000111100010101")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.MULTIPLEXORMULXFF.RESULT_M4_0\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.MULTIPLEXORMULXFF.RESULT_M1_0_A2_0\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_PCTRL_NEW_43_2_0\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.PCTRL_I_M_0\(6),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.PCTRL_NEW_12_31\(75));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNIV1H32_55_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0101111111110011")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_M3\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(54),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(55),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN3_NOTXZYFROMD\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_M1_0_A2_0\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_PXS_PCTRL_NEW_12_32_0_75_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1111111011111110")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.PCTRL_NEW_12_32_0\(75),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(65),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.NOTABORTNULLEXC\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.PCTRL_NEW\(77));
GRLFPC20_R_I_RDD_RNO: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1100000010100000")
port map (
combout => \GRLFPC20.R.I.RDD_0_0_G1_0_574_I\,
dataa => \GRLFPC20.R.I.RDD\,
datab => \GRLFPC20.R.X.RDD\(0),
datac => \GRLFPC20.R.I.RDD_0_0_G1_0_574_I_0\,
datad => \GRLFPC20.V.I.EXEC_0_SQMUXA\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_SIGNRESULT: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0110000001011010")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.SIGNRESULT\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(12),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(13),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(23),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SXC.SFTLFT.UN1_GRFPUS\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_54_TRFWWBASICCELL_TEMP2_2_RNI1EP4: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.54.CI_4_V\(0),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.54.TRFWWBASICCELL.TEMP2_2\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN5_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_53_TRFWWBASICCELL_TEMP2_2_RNI0NR1: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.53.CI_5_V\(0),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.53.TRFWWBASICCELL.TEMP2_2\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN5_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_52_TRFWWBASICCELL_TEMP2_1_RNIUVTE: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.52.CI_6_V\(0),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.52.TRFWWBASICCELL.TEMP2_1\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN5_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_51_TRFWWBASICCELL_TEMP2_3_RNIV80C: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.51.CI_7_V\(0),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.51.TRFWWBASICCELL.TEMP2_3\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN5_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_50_TRFWWBASICCELL_TEMP2_2_RNITH29: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.50.CI_8_V\(0),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.50.TRFWWBASICCELL.TEMP2_2\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN5_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_49_TRFWWBASICCELL_TEMP2_1_RNI49P2: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.49.CI_9_V\(0),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.49.TRFWWBASICCELL.TEMP2_1\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN5_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_48_TRFWWBASICCELL_TEMP2_RNIJIT: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.48.CI_10_V\(0),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.48.TRFWWBASICCELL.TEMP2\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN5_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_47_TRFWWBASICCELL_TEMP2_1_RNI2RTC: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.47.CI_11_V\(0),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.47.TRFWWBASICCELL.TEMP2_1\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN5_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_46_TRFWWBASICCELL_TEMP2_3_RNI340A: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.46.CI_12_V\(0),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.46.TRFWWBASICCELL.TEMP2_3\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN5_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_45_TRFWWBASICCELL_TEMP2_3_RNI2D27: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.45.CI_13_V\(0),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.45.TRFWWBASICCELL.TEMP2_3\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN5_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_44_TRFWWBASICCELL_TEMP2_3_RNI1M44: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.44.CI_14_V\(0),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.44.TRFWWBASICCELL.TEMP2_3\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN5_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_43_TRFWWBASICCELL_TEMP2_2_RNIVU61: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.43.CI_15_V\(0),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.43.TRFWWBASICCELL.TEMP2_2\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN5_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_42_TRFWWBASICCELL_TEMP2_RNIDKDD: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.42.CI_16_V\(0),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.42.TRFWWBASICCELL.TEMP2\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN5_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_41_TRFWWBASICCELL_TEMP2_1_RNISGBB: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.41.CI_17_V\(0),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.41.TRFWWBASICCELL.TEMP2_1\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN5_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_40_TRFWWBASICCELL_TEMP2_1_RNIRPD8: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.40.CI_18_V\(0),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.40.TRFWWBASICCELL.TEMP2_1\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN5_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_39_TRFWWBASICCELL_TEMP2_RNIJH8E: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.39.CI_19_V\(0),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.39.TRFWWBASICCELL.TEMP2\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN5_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_38_TRFWWBASICCELL_TEMP2_3_RNI4Q6F: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.38.CI_20_V\(0),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.38.TRFWWBASICCELL.TEMP2_3\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN5_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_37_TRFWWBASICCELL_TEMP2_1_RNI139C: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.37.CI_21_V\(0),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.37.TRFWWBASICCELL.TEMP2_1\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN5_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_35_TRFWWBASICCELL_TEMP2_2_RNI0LD6: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.35.CI_23_V\(0),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.35.TRFWWBASICCELL.TEMP2_2\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN5_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_34_TRFWWBASICCELL_TEMP2_2_RNIVTF3: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.34.CI_24_V\(0),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.34.TRFWWBASICCELL.TEMP2_2\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN5_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_33_TRFWWBASICCELL_TEMP2_3_RNIV6I: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.33.CI_25_V\(0),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.33.TRFWWBASICCELL.TEMP2_3\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN5_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_32_TRFWWBASICCELL_TEMP2_2_RNITFKD: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.32.CI_26_V\(0),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.32.TRFWWBASICCELL.TEMP2_2\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN5_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_31_TRFWWBASICCELL_TEMP2_2_RNISOMA: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.31.CI_27_V\(0),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.31.TRFWWBASICCELL.TEMP2_2\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN5_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_30_TRFWWBASICCELL_TEMP2_3_RNIS1P7: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.30.CI_28_V\(0),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.30.TRFWWBASICCELL.TEMP2_3\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN5_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_29_TRFWWBASICCELL_TEMP2_2_RNI3PF1: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.29.CI_29_V\(0),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.29.TRFWWBASICCELL.TEMP2_2\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN5_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_28_TRFWWBASICCELL_TEMP2_1_RNI12IE: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.28.CI_30_V\(0),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.28.TRFWWBASICCELL.TEMP2_1\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN5_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_27_TRFWWBASICCELL_TEMP2_1_RNI0BKB: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.27.CI_31_V\(0),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.27.TRFWWBASICCELL.TEMP2_1\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN5_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_24_TRFWWBASICCELL_TEMP2_RNIDI38: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.24.CI_34_V\(0),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.24.TRFWWBASICCELL.TEMP2\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN5_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_23_TRFWWBASICCELL_TEMP2_2_RNITETF: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.23.CI_35_V\(0),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.23.TRFWWBASICCELL.TEMP2_2\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN5_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_22_TRFWWBASICCELL_TEMP2_3_RNITNVC: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.22.CI_36_V\(0),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.22.TRFWWBASICCELL.TEMP2_3\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN5_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_19_TRFWWBASICCELL_TEMP2_RNIH5P7: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.19.CI_39_V\(0),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.19.TRFWWBASICCELL.TEMP2\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN5_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_18_TRFWWBASICCELL_TEMP2_RNIGG6F: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.18.CI_40_V\(0),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.18.TRFWWBASICCELL.TEMP2\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN5_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_17_TRFWWBASICCELL_TEMP2_3_RNI1JVA: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.17.CI_41_V\(0),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.17.TRFWWBASICCELL.TEMP2_3\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN5_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_16_TRFWWBASICCELL_TEMP2_2_RNIVR18: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.16.CI_42_V\(0),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.16.TRFWWBASICCELL.TEMP2_2\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN5_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_15_TRFWWBASICCELL_TEMP2_RNIDHE5: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.15.CI_43_V\(0),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.15.TRFWWBASICCELL.TEMP2\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN5_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_14_TRFWWBASICCELL_TEMP2_2_RNITD62: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.14.CI_44_V\(0),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.14.TRFWWBASICCELL.TEMP2_2\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN5_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_11_TRFWWBASICCELL_TEMP2_3_RNIR8D9: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.11.CI_47_V\(0),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.11.TRFWWBASICCELL.TEMP2_3\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN5_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_10_TRFWWBASICCELL_TEMP2_3_RNIQHF6: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.10.CI_48_V\(0),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.10.TRFWWBASICCELL.TEMP2_3\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN5_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_9_TRFWWBASICCELL_TEMP2_2_RNIH597: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.9.CI_49_V\(0),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.9.TRFWWBASICCELL.TEMP2_2\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN5_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_8_TRFWWBASICCELL_TEMP2_2_RNIGEB4: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.8.CI_50_V\(0),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.8.TRFWWBASICCELL.TEMP2_2\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN5_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_7_TRFWWBASICCELL_TEMP2_3_RNIGND1: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.7.CI_51_V\(0),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.7.TRFWWBASICCELL.TEMP2_3\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN5_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_6_TRFWWBASICCELL_TEMP2_RNITCJ9: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.6.CI_52_V\(0),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.6.TRFWWBASICCELL.TEMP2\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN5_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_5_TRFWWBASICCELL_TEMP2_3_RNIE9IB: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.5.CI_53_V\(0),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.5.TRFWWBASICCELL.TEMP2_3\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN5_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_4_TRFWWBASICCELL_TEMP2_3_RNIDIK8: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.4.CI_54_V\(0),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.4.TRFWWBASICCELL.TEMP2_3\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN5_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_3_TRFWWBASICCELL_TEMP2_RNIQDRF: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.3.CI_55_V\(0),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.3.TRFWWBASICCELL.TEMP2\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN5_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_2_TRFWWBASICCELL_TEMP2_3_RNIB4P2: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.2.CI_56_V\(0),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.2.TRFWWBASICCELL.TEMP2_3\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN5_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_55_TRFWWBASICCELL_CIN_10: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.55.TRFWWBASICCELL.CIN_10\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.55.TRFWWBASICCELL.TEMP2_1\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN5_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_1_TRFWWBASICCELL_CIN_1: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.1.TRFWWBASICCELL.CIN_1\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.1.TRFWWBASICCELL.TEMP2_2\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN5_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_52_TRFWWBASICCELL_TEMP2_RNIU1IA: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_1299_V\(2),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.52.TRFWWBASICCELL.TEMP2\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN50_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_51_TRFWWBASICCELL_TEMP2_RNITCVH: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.54.CI_4_V\(3),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.51.TRFWWBASICCELL.TEMP2\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN50_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_50_TRFWWBASICCELL_TEMP2_RNISNC9: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.53.CI_5_V\(3),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.50.TRFWWBASICCELL.TEMP2\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN50_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_49_TRFWWBASICCELL_TEMP2_3_RNIM0M4: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.52.CI_6_V\(3),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.49.TRFWWBASICCELL.TEMP2_3\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN50_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_47_TRFWWBASICCELL_TEMP2_3_RNIKIQE: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.50.CI_8_V\(3),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.47.TRFWWBASICCELL.TEMP2_3\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN50_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_46_TRFWWBASICCELL_TEMP2_2_RNIIRSB: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.49.CI_9_V\(3),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.46.TRFWWBASICCELL.TEMP2_2\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN50_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_45_TRFWWBASICCELL_TEMP2_1_RNIG4V8: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.48.CI_10_V\(3),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.45.TRFWWBASICCELL.TEMP2_1\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN50_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_44_TRFWWBASICCELL_TEMP2_2_RNIGD16: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.47.CI_11_V\(3),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.44.TRFWWBASICCELL.TEMP2_2\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN50_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_43_TRFWWBASICCELL_TEMP2_3_RNIGM33: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.46.CI_12_V\(3),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.43.TRFWWBASICCELL.TEMP2_3\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN50_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_42_TRFWWBASICCELL_TEMP2_3_RNIFV5G: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.45.CI_13_V\(3),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.42.TRFWWBASICCELL.TEMP2_3\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN50_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_41_TRFWWBASICCELL_TEMP2_3_RNIE88D: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.44.CI_14_V\(3),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.41.TRFWWBASICCELL.TEMP2_3\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN50_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_40_TRFWWBASICCELL_TEMP2_3_RNIDHAA: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.43.CI_15_V\(3),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.40.TRFWWBASICCELL.TEMP2_3\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN50_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_39_TRFWWBASICCELL_TEMP2_2_RNIK814: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.42.CI_16_V\(3),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.39.TRFWWBASICCELL.TEMP2_2\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN50_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_38_TRFWWBASICCELL_TEMP2_1_RNIIH3H: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.41.CI_17_V\(3),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.38.TRFWWBASICCELL.TEMP2_1\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN50_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_37_TRFWWBASICCELL_TEMP2_2_RNIIQ5E: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.40.CI_18_V\(3),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.37.TRFWWBASICCELL.TEMP2_2\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN50_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_34_TRFWWBASICCELL_TEMP2_1_RNIELC5: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.37.CI_21_V\(3),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.34.TRFWWBASICCELL.TEMP2_1\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN50_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_33_TRFWWBASICCELL_TEMP2_1_RNIDUE2: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.36.CI_22_V\(3),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.33.TRFWWBASICCELL.TEMP2_1\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN50_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_31_TRFWWBASICCELL_TEMP2_3_RNIDGJC: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.34.CI_24_V\(3),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.31.TRFWWBASICCELL.TEMP2_3\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN50_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_30_TRFWWBASICCELL_TEMP2_2_RNIBPL9: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.33.CI_25_V\(3),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.30.TRFWWBASICCELL.TEMP2_2\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN50_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_29_TRFWWBASICCELL_TEMP2_RNI2JT4: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.32.CI_26_V\(3),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.29.TRFWWBASICCELL.TEMP2\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN50_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_28_TRFWWBASICCELL_TEMP2_3_RNIJPEG: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.31.CI_27_V\(3),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.28.TRFWWBASICCELL.TEMP2_3\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN50_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_27_TRFWWBASICCELL_TEMP2_RNI09O3: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.30.CI_28_V\(3),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.27.TRFWWBASICCELL.TEMP2\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN50_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_24_TRFWWBASICCELL_TEMP2_2_RNIETN4: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.27.CI_31_V\(3),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.24.TRFWWBASICCELL.TEMP2_2\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN50_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_23_TRFWWBASICCELL_TEMP2_1_RNIC6QH: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.26.CI_32_V\(3),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.23.TRFWWBASICCELL.TEMP2_1\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN50_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_22_TRFWWBASICCELL_TEMP2_RNIRVQ8: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.25.CI_33_V\(3),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.22.TRFWWBASICCELL.TEMP2\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN50_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_21_TRFWWBASICCELL_TEMP2_3_RNICOUB: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.24.CI_34_V\(3),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.21.TRFWWBASICCELL.TEMP2_3\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN50_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_20_TRFWWBASICCELL_TEMP2_RNIPLL7: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.23.CI_35_V\(3),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.20.TRFWWBASICCELL.TEMP2\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN50_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_19_TRFWWBASICCELL_TEMP2_1_RNIHON2: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.22.CI_36_V\(3),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.19.TRFWWBASICCELL.TEMP2_1\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN50_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_18_TRFWWBASICCELL_TEMP2_1_RNIG1QF: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.21.CI_37_V\(3),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.18.TRFWWBASICCELL.TEMP2_1\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN50_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_17_TRFWWBASICCELL_TEMP2_RNIVIG8: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.20.CI_38_V\(3),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.17.TRFWWBASICCELL.TEMP2\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN50_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_16_TRFWWBASICCELL_TEMP2_3_RNIGJU9: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.19.CI_39_V\(3),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.16.TRFWWBASICCELL.TEMP2_3\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN50_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_15_TRFWWBASICCELL_TEMP2_2_RNIES07: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.18.CI_40_V\(3),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.15.TRFWWBASICCELL.TEMP2_2\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN50_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_10_TRFWWBASICCELL_TEMP2_RNIOVDC: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.13.CI_45_V\(3),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.10.TRFWWBASICCELL.TEMP2\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN50_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_9_TRFWWBASICCELL_TEMP2_RNIG385: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.12.CI_46_V\(3),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.9.TRFWWBASICCELL.TEMP2\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN50_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_8_TRFWWBASICCELL_TEMP2_1_RNIV586: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.11.CI_47_V\(3),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.8.TRFWWBASICCELL.TEMP2_1\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN50_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_7_TRFWWBASICCELL_TEMP2_RNIEP24: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.10.CI_48_V\(3),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.7.TRFWWBASICCELL.TEMP2\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN50_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_6_TRFWWBASICCELL_TEMP2_1_RNITNCG: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.9.CI_49_V\(3),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.6.TRFWWBASICCELL.TEMP2_1\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN50_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_5_TRFWWBASICCELL_TEMP2_2_RNIT0FD: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.8.CI_50_V\(3),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.5.TRFWWBASICCELL.TEMP2_2\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN50_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_4_TRFWWBASICCELL_TEMP2_RNIBQAA: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.7.CI_51_V\(3),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.4.TRFWWBASICCELL.TEMP2\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN50_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_50_TRFWWBASICCELL_TEMP2_3_RNIHMJL: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.52.CI_6_V\(2),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.50.TRFWWBASICCELL.TEMP2_3\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN35_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_49_TRFWWBASICCELL_TEMP2_RNI7C1M: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.51.CI_7_V\(2),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.49.TRFWWBASICCELL.TEMP2\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN35_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_46_TRFWWBASICCELL_TEMP2_1_RNIK8HM: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.48.CI_10_V\(2),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.46.TRFWWBASICCELL.TEMP2_1\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN35_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_45_TRFWWBASICCELL_TEMP2_RNI3OMJ: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.47.CI_11_V\(2),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.45.TRFWWBASICCELL.TEMP2\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN35_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_44_TRFWWBASICCELL_TEMP2_RNI234R: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.46.CI_12_V\(2),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.44.TRFWWBASICCELL.TEMP2\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN35_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_42_TRFWWBASICCELL_TEMP2_2_RNIHCQQ: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.44.CI_14_V\(2),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.42.TRFWWBASICCELL.TEMP2_2\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN35_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_41_TRFWWBASICCELL_TEMP2_2_RNIGLSN: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.43.CI_15_V\(2),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.41.TRFWWBASICCELL.TEMP2_2\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN35_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_40_TRFWWBASICCELL_TEMP2_2_RNIFUUK: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.42.CI_16_V\(2),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.40.TRFWWBASICCELL.TEMP2_2\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN35_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_39_TRFWWBASICCELL_TEMP2_1_RNIMLLE: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.41.CI_17_V\(2),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.39.TRFWWBASICCELL.TEMP2_1\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN35_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_38_TRFWWBASICCELL_TEMP2_2_RNIMUNR: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.40.CI_18_V\(2),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.38.TRFWWBASICCELL.TEMP2_2\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN35_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_37_TRFWWBASICCELL_TEMP2_RNI4CKP: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.39.CI_19_V\(2),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.37.TRFWWBASICCELL.TEMP2\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN35_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_36_TRFWWBASICCELL_TEMP2_1_RNIJGSL: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.38.CI_20_V\(2),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.36.TRFWWBASICCELL.TEMP2_1\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN35_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_35_TRFWWBASICCELL_TEMP2_RNI22FO: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.37.CI_21_V\(2),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.35.TRFWWBASICCELL.TEMP2\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN35_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_34_TRFWWBASICCELL_TEMP2_RNI1DSF: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.36.CI_22_V\(2),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.34.TRFWWBASICCELL.TEMP2\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN35_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_33_TRFWWBASICCELL_TEMP2_RNI0O9N: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.35.CI_23_V\(2),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.33.TRFWWBASICCELL.TEMP2\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN35_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_32_TRFWWBASICCELL_TEMP2_RNIV2NE: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.34.CI_24_V\(2),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.32.TRFWWBASICCELL.TEMP2\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN35_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_31_TRFWWBASICCELL_TEMP2_1_RNIET7N: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.33.CI_25_V\(2),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.31.TRFWWBASICCELL.TEMP2_1\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN35_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_30_TRFWWBASICCELL_TEMP2_1_RNID6AK: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.32.CI_26_V\(2),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.30.TRFWWBASICCELL.TEMP2_1\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN35_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_23_TRFWWBASICCELL_TEMP2_3_RNIHJES: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.25.CI_33_V\(2),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.23.TRFWWBASICCELL.TEMP2_3\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN35_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_21_TRFWWBASICCELL_TEMP2_2_RNIE5JM: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.23.CI_35_V\(2),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.21.TRFWWBASICCELL.TEMP2_2\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN35_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_19_TRFWWBASICCELL_TEMP2_3_RNIM5CD: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.21.CI_37_V\(2),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.19.TRFWWBASICCELL.TEMP2_3\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN35_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_18_TRFWWBASICCELL_TEMP2_3_RNILEEQ: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.20.CI_38_V\(2),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.18.TRFWWBASICCELL.TEMP2_3\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN35_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_17_TRFWWBASICCELL_TEMP2_2_RNIJNGN: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.19.CI_39_V\(2),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.17.TRFWWBASICCELL.TEMP2_2\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN35_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_16_TRFWWBASICCELL_TEMP2_RNI1BIQ: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.18.CI_40_V\(2),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.16.TRFWWBASICCELL.TEMP2\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN35_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_15_TRFWWBASICCELL_TEMP2_3_RNII9LH: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.17.CI_41_V\(2),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.15.TRFWWBASICCELL.TEMP2_3\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN35_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_14_TRFWWBASICCELL_TEMP2_3_RNIHINE: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.16.CI_42_V\(2),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.14.TRFWWBASICCELL.TEMP2_3\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN35_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_13_TRFWWBASICCELL_TEMP2_2_RNIFRPR: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.15.CI_43_V\(2),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.13.TRFWWBASICCELL.TEMP2_2\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN35_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_11_TRFWWBASICCELL_TEMP2_2_RNIDDUL: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.13.CI_45_V\(2),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.11.TRFWWBASICCELL.TEMP2_2\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN35_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_10_TRFWWBASICCELL_TEMP2_1_RNIBM0J: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.12.CI_46_V\(2),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.10.TRFWWBASICCELL.TEMP2_1\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN35_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_9_TRFWWBASICCELL_TEMP2_1_RNI3AQJ: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.11.CI_47_V\(2),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.9.TRFWWBASICCELL.TEMP2_1\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN35_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_8_TRFWWBASICCELL_TEMP2_RNIIR9N: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.10.CI_48_V\(2),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.8.TRFWWBASICCELL.TEMP2\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN35_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_7_TRFWWBASICCELL_TEMP2_1_RNI1SUD: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.9.CI_49_V\(2),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.7.TRFWWBASICCELL.TEMP2_1\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN35_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_6_TRFWWBASICCELL_TEMP2_3_RNI251R: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.8.CI_50_V\(2),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.6.TRFWWBASICCELL.TEMP2_3\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN35_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_5_TRFWWBASICCELL_TEMP2_1_RNIVD3O: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.7.CI_51_V\(2),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.5.TRFWWBASICCELL.TEMP2_1\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN35_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_4_TRFWWBASICCELL_TEMP2_1_RNIUM5L: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.6.CI_52_V\(2),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.4.TRFWWBASICCELL.TEMP2_1\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN35_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_3_TRFWWBASICCELL_TEMP2_1_RNITV7I: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.5.CI_53_V\(2),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.3.TRFWWBASICCELL.TEMP2_1\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN35_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_2_TRFWWBASICCELL_TEMP2_2_RNIT8AF: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.4.CI_54_V\(2),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.2.TRFWWBASICCELL.TEMP2_2\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN35_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_1_TRFWWBASICCELL_TEMP2_1_RNIRHCS: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.3.CI_55_V\(2),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.1.TRFWWBASICCELL.TEMP2_1\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN35_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_53_TRFWWBASICCELL_TEMP2_RNIVM43: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.53.TRFWWBASICCELL.CIN\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.53.TRFWWBASICCELL.TEMP2\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN50_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_MULTIPLELOGIC_UN35_ZERO: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0111111001111110")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN35_ZERO\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH_0\(3),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH_125\(4),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH_134\(2));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_36_TRFWWBASICCELL_TEMP2_2_RNI1CB9: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.36.CI_22_V\(0),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.36.TRFWWBASICCELL.TEMP2_2\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN5_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_43_TRFWWBASICCELL_TEMP2_RNI1EHI: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.45.CI_13_V\(2),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.43.TRFWWBASICCELL.TEMP2\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN35_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_29_TRFWWBASICCELL_TEMP2_3_RNINT0E: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.31.CI_27_V\(2),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.29.TRFWWBASICCELL.TEMP2_3\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN35_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_28_TRFWWBASICCELL_TEMP2_RNI4BVM: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.30.CI_28_V\(2),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.28.TRFWWBASICCELL.TEMP2\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN35_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_25_TRFWWBASICCELL_TEMP2_1_RNIH1AI: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.27.CI_31_V\(2),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.25.TRFWWBASICCELL.TEMP2_1\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN35_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_24_TRFWWBASICCELL_TEMP2_1_RNIGACF: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.26.CI_32_V\(2),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.24.TRFWWBASICCELL.TEMP2_1\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN35_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_MULTIPLELOGIC_UN5_ZERO: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1110111101110000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN5_ZERO\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(23),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(25),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(10),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN5_ZERO_A\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_MULTIPLELOGIC_UN5_ZERO_A: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000011111111110")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN5_ZERO_A\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(57),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(55),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(10),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH_0\(7));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_DPATH_NEW_14_142_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000110010101100")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_14\(142),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(2),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(144),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(10),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.SELECTQUOBITS.QUOBITS\(0));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_53_TRFWWBASICCELL_TEMP2_3_RNIESA6: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.54.CI_4_V\(1),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.53.TRFWWBASICCELL.TEMP2_3\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN20_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_52_TRFWWBASICCELL_TEMP2_2_RNIC5DJ: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.53.CI_5_V\(1),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.52.TRFWWBASICCELL.TEMP2_2\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN20_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_51_TRFWWBASICCELL_TEMP2_1_RNIAEFG: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.52.CI_6_V\(1),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.51.TRFWWBASICCELL.TEMP2_1\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN20_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_50_TRFWWBASICCELL_TEMP2_1_RNI9NHD: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.51.CI_7_V\(1),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.50.TRFWWBASICCELL.TEMP2_1\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN20_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_49_TRFWWBASICCELL_TEMP2_2_RNIIE87: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.50.CI_8_V\(1),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.49.TRFWWBASICCELL.TEMP2_2\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN20_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_48_TRFWWBASICCELL_TEMP2_1_RNIGNAK: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.49.CI_9_V\(1),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.48.TRFWWBASICCELL.TEMP2_1\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN20_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_47_TRFWWBASICCELL_TEMP2_2_RNIG0DH: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.48.CI_10_V\(1),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.47.TRFWWBASICCELL.TEMP2_2\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN20_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_46_TRFWWBASICCELL_TEMP2_RNIUD7K: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.47.CI_11_V\(1),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.46.TRFWWBASICCELL.TEMP2\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN20_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_45_TRFWWBASICCELL_TEMP2_2_RNIEIHB: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.46.CI_12_V\(1),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.45.TRFWWBASICCELL.TEMP2_2\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN20_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_44_TRFWWBASICCELL_TEMP2_1_RNICRJ8: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.45.CI_13_V\(1),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.44.TRFWWBASICCELL.TEMP2_1\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN20_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_43_TRFWWBASICCELL_TEMP2_1_RNIB4M5: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.44.CI_14_V\(1),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.43.TRFWWBASICCELL.TEMP2_1\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN20_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_42_TRFWWBASICCELL_TEMP2_1_RNIADOI: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.43.CI_15_V\(1),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.42.TRFWWBASICCELL.TEMP2_1\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN20_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_41_TRFWWBASICCELL_TEMP2_RNIP4A9: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.42.CI_16_V\(1),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.41.TRFWWBASICCELL.TEMP2\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN20_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_40_TRFWWBASICCELL_TEMP2_RNIOFNG: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.41.CI_17_V\(1),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.40.TRFWWBASICCELL.TEMP2\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN20_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_39_TRFWWBASICCELL_TEMP2_3_RNIIMJ6: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.40.CI_18_V\(1),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.39.TRFWWBASICCELL.TEMP2_3\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN20_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_38_TRFWWBASICCELL_TEMP2_RNIV15A: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.39.CI_19_V\(1),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.38.TRFWWBASICCELL.TEMP2\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN20_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_37_TRFWWBASICCELL_TEMP2_3_RNIG8OG: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.38.CI_20_V\(1),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.37.TRFWWBASICCELL.TEMP2_3\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN20_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_36_TRFWWBASICCELL_TEMP2_RNITNV8: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.37.CI_21_V\(1),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.36.TRFWWBASICCELL.TEMP2\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN20_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_35_TRFWWBASICCELL_TEMP2_3_RNIEQSA: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.36.CI_22_V\(1),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.35.TRFWWBASICCELL.TEMP2_3\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN20_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_34_TRFWWBASICCELL_TEMP2_3_RNID3V7: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.35.CI_23_V\(1),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.34.TRFWWBASICCELL.TEMP2_3\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN20_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_33_TRFWWBASICCELL_TEMP2_2_RNIBC15: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.34.CI_24_V\(1),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.33.TRFWWBASICCELL.TEMP2_2\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN20_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_32_TRFWWBASICCELL_TEMP2_1_RNI9L3I: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.33.CI_25_V\(1),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.32.TRFWWBASICCELL.TEMP2_1\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN20_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_31_TRFWWBASICCELL_TEMP2_RNIOE2E: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.32.CI_26_V\(1),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.31.TRFWWBASICCELL.TEMP2\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN20_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_30_TRFWWBASICCELL_TEMP2_RNINPF5: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.31.CI_27_V\(1),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.30.TRFWWBASICCELL.TEMP2\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN20_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_29_TRFWWBASICCELL_TEMP2_1_RNIFUU5: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.30.CI_28_V\(1),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.29.TRFWWBASICCELL.TEMP2_1\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN20_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_28_TRFWWBASICCELL_TEMP2_2_RNIF71J: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.29.CI_29_V\(1),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.28.TRFWWBASICCELL.TEMP2_2\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN20_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_27_TRFWWBASICCELL_TEMP2_3_RNIFG3G: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.28.CI_30_V\(1),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.27.TRFWWBASICCELL.TEMP2_3\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN20_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_26_TRFWWBASICCELL_TEMP2_2_RNIDP5D: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.27.CI_31_V\(1),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.26.TRFWWBASICCELL.TEMP2_2\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN20_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_25_TRFWWBASICCELL_TEMP2_3_RNID28A: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.26.CI_32_V\(1),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.25.TRFWWBASICCELL.TEMP2_3\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN20_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_24_TRFWWBASICCELL_TEMP2_3_RNICBA7: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.25.CI_33_V\(1),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.24.TRFWWBASICCELL.TEMP2_3\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN20_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_20_TRFWWBASICCELL_TEMP2_1_RNI6FJB: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.21.CI_37_V\(1),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.20.TRFWWBASICCELL.TEMP2_1\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN20_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_19_TRFWWBASICCELL_TEMP2_2_RNIF6A5: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.20.CI_38_V\(1),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.19.TRFWWBASICCELL.TEMP2_2\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN20_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_18_TRFWWBASICCELL_TEMP2_2_RNIEFCI: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.19.CI_39_V\(1),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.18.TRFWWBASICCELL.TEMP2_2\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN20_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_17_TRFWWBASICCELL_TEMP2_1_RNICOEF: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.18.CI_40_V\(1),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.17.TRFWWBASICCELL.TEMP2_1\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN20_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_11_TRFWWBASICCELL_TEMP2_1_RNI6ESD: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.12.CI_46_V\(1),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.11.TRFWWBASICCELL.TEMP2_1\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN20_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_10_TRFWWBASICCELL_TEMP2_2_RNI6NUA: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.11.CI_47_V\(1),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.10.TRFWWBASICCELL.TEMP2_2\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN20_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_9_TRFWWBASICCELL_TEMP2_3_RNIVAOB: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.10.CI_48_V\(1),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.9.TRFWWBASICCELL.TEMP2_3\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN20_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_8_TRFWWBASICCELL_TEMP2_3_RNIUJQ8: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.9.CI_49_V\(1),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.8.TRFWWBASICCELL.TEMP2_3\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN20_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_7_TRFWWBASICCELL_TEMP2_2_RNISSS5: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.8.CI_50_V\(1),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.7.TRFWWBASICCELL.TEMP2_2\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN20_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_6_TRFWWBASICCELL_TEMP2_2_RNIR5VI: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.7.CI_51_V\(1),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.6.TRFWWBASICCELL.TEMP2_2\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN20_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_5_TRFWWBASICCELL_TEMP2_RNI9TF5: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.6.CI_52_V\(1),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.5.TRFWWBASICCELL.TEMP2\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN20_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_4_TRFWWBASICCELL_TEMP2_2_RNIPN3D: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.5.CI_53_V\(1),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.4.TRFWWBASICCELL.TEMP2_2\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN20_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_3_TRFWWBASICCELL_TEMP2_3_RNIP06A: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.4.CI_54_V\(1),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.3.TRFWWBASICCELL.TEMP2_3\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN20_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_2_TRFWWBASICCELL_TEMP2_1_RNIM987: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.3.CI_55_V\(1),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.2.TRFWWBASICCELL.TEMP2_1\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN20_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_1_TRFWWBASICCELL_TEMP2_RNI595J: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.2.CI_56_V\(1),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.1.TRFWWBASICCELL.TEMP2\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN20_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_MULTIPLELOGIC_UN20_ZERO: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0111111001111110")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN20_ZERO\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH_0\(5),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH_118\(6),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH_125\(4));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_23_TRFWWBASICCELL_TEMP2_RNIP20K: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.24.CI_34_V\(1),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.23.TRFWWBASICCELL.TEMP2\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN20_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_22_TRFWWBASICCELL_TEMP2_1_RNI8TEH: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.23.CI_35_V\(1),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.22.TRFWWBASICCELL.TEMP2_1\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN20_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_21_TRFWWBASICCELL_TEMP2_1_RNI76HE: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.22.CI_36_V\(1),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.21.TRFWWBASICCELL.TEMP2_1\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN20_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_16_TRFWWBASICCELL_TEMP2_1_RNIB1HC: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.17.CI_41_V\(1),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.16.TRFWWBASICCELL.TEMP2_1\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN20_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_15_TRFWWBASICCELL_TEMP2_1_RNIAAJ9: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.16.CI_42_V\(1),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.15.TRFWWBASICCELL.TEMP2_1\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN20_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_14_TRFWWBASICCELL_TEMP2_1_RNI9JL6: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.15.CI_43_V\(1),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.14.TRFWWBASICCELL.TEMP2_1\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN20_ZERO\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_0_10_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010011100100111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES_0\(10),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26\(11),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26\(10));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_0_12_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010011100100111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES_0\(12),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26\(13),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26\(12));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_0_13_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0001101100011011")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES_0\(13),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26\(13),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26\(14));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_0_16_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010011100100111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES_0\(16),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26\(17),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26\(16));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_1_46_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1100110010100000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(46),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(185),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_0\(46),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_M2_REP1\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_M2_7_REP1\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_1_39_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1100110010100000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(39),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(192),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_0\(39),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_M2_REP1\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_M2_7_REP1\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_1_29_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1100110010100000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(29),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(202),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_0\(29),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_M2\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_M2_7\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_1_26_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1100110010100000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(26),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(205),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_0\(26),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_M2\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_M2_7\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_1_25_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1100110010100000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(25),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(206),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_0\(25),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_M2\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_M2_7\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_1_23_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1100110010100000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(23),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(208),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_0\(23),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_M2\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_M2_7\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_1_18_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1100110010100000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(18),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(213),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_0\(18),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_M2\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_M2_7\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_1_17_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1100110010100000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(17),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(214),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_0\(17),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_M2\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_M2_7\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_6_1_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000000111101111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(1),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(1),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(2),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.S_8\(56),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.S_8\(57));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_6_2_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000000111101111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(2),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(1),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(2),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.S_8\(55),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.S_8\(57));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_6_3_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010011100100111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(3),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(1),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_0\(1),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8\(3));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_6_4_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010011100100111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(4),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(1),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8\(2),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8\(4));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_6_5_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0001101100011011")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(5),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(1),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8\(5),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8\(3));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_6_6_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0001101100011011")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(6),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(1),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8\(6),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8\(4));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_6_7_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0001101100011011")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(7),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(1),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8\(7),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8\(5));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_6_8_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0001101100011011")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(8),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(1),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8\(8),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8\(6));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_6_9_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010011100100111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(9),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(1),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8\(7),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8\(9));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_6_10_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010011100100111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(10),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(1),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8\(8),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8\(10));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_6_11_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010011100100111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(11),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(1),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8\(9),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8\(11));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_6_12_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010011100100111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(12),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(1),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8\(10),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8\(12));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_6_13_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0001101100011011")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(13),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(1),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8\(13),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8\(11));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_6_14_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010011100100111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(14),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(1),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8\(12),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8\(14));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_6_15_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1011101100000101")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(15),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(1),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.S_8\(42),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.S_8\(46),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6_A\(15));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_6_A_15_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0001001110011011")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6_A\(15),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(1),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(2),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.S_8\(44),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.S_8\(48));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_6_16_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010011100100111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(16),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(1),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8\(14),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8\(16));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_6_17_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010011100100111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(17),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(1),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8\(15),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8\(17));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_6_18_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010011100100111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(18),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(1),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8\(16),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8\(18));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_6_19_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010011100100111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(19),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(1),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8\(17),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8\(19));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_6_20_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0001101100011011")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(20),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(1),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8\(20),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8\(18));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_6_22_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010011100100111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(22),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(1),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8\(20),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8\(22));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_6_24_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010011100100111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(24),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(1),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8\(22),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8\(24));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_6_26_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0001101100011011")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(26),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(1),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8\(26),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8\(24));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_6_27_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010011100100111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(27),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(1),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8\(25),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8\(27));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_6_31_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010011100100111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(31),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(1),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8\(29),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8\(31));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_6_33_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010011100100111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(33),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(1),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8\(31),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8\(33));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_6_35_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010011100100111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(35),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(1),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8\(33),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8\(35));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_6_37_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010011100100111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(37),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(1),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8\(35),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8\(37));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_6_39_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010011100100111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(39),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(1),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8\(37),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8\(39));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_6_40_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0001101100011011")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(40),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(1),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8\(40),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8\(38));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_6_41_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010011100100111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(41),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(1),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8\(39),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8\(41));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_6_42_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010011100100111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(42),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(1),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8\(40),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8\(42));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_6_43_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010011100100111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(43),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(1),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8\(41),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8\(43));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_6_44_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0001101100011011")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(44),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(1),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8\(44),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8\(42));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_6_45_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010011100100111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(45),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(1),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8\(43),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8\(45));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_6_46_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010011100100111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(46),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(1),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8\(44),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8\(46));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_6_48_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010011100100111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(48),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(1),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8\(46),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8\(48));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_6_50_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010011100100111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(50),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(1),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8\(48),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8\(50));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_6_57_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010011100100111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(57),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(1),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8\(55),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_0\(57));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_6_52_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010011100100111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(52),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(1),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8\(50),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8\(52));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_6_56_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010011100100111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(56),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(1),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8\(54),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_0\(56));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_0_4_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0001101100011011")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES_0\(4),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26\(4),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26\(5));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_1_56_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1100110010100000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(56),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(175),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_0\(56),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_M2_REP1\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_M2_7_REP1\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_1_54_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1100110010100000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(54),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(177),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_0\(54),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_M2_REP1\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_M2_7_REP1\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_1_53_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1100110010100000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(53),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(178),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_0\(53),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_M2_REP1\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_M2_7_REP1\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_1_50_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1100110010100000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(50),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(181),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_0\(50),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_M2_REP1\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_M2_7_REP1\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_1_49_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1100110010100000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(49),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(182),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_0\(49),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_M2_REP1\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_M2_7_REP1\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_1_48_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1100110010100000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(48),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(183),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_0\(48),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_M2_REP1\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_M2_7_REP1\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_1_47_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1100110010100000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(47),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(184),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_0\(47),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_M2_REP1\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_M2_7_REP1\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_1_45_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1100110010100000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(45),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(186),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_0\(45),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_M2_REP1\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_M2_7_REP1\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_1_44_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1100110010100000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(44),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(187),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_0\(44),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_M2_REP1\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_M2_7_REP1\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_1_42_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1100110010100000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(42),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(189),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_0\(42),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_M2_REP1\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_M2_7_REP1\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_1_40_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1100110010100000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(40),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(191),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_0\(40),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_M2_REP1\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_M2_7_REP1\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_1_38_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1100110010100000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(38),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(193),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_0\(38),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_M2_REP1\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_M2_7_REP1\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_1_37_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1100110010100000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(37),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(194),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_0\(37),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_M2_REP1\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_M2_7_REP1\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_1_35_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1100110010100000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(35),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(196),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_0\(35),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_M2\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_M2_7\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_1_34_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1100110010100000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(34),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(197),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_0\(34),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_M2\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_M2_7\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_1_33_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1100110010100000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(33),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(198),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_0\(33),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_M2\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_M2_7\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_1_32_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1100110010100000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(32),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(199),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_0\(32),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_M2\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_M2_7\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_1_30_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1100110010100000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(30),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(201),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_0\(30),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_M2\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_M2_7\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_1_28_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1100110010100000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(28),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(203),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_0\(28),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_M2\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_M2_7\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_1_24_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1100110010100000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(24),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(207),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_0\(24),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_M2\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_M2_7\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_1_22_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1100110010100000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(22),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(209),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_0\(22),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_M2\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_M2_7\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_1_21_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1100110010100000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(21),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(210),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_0\(21),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_M2\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_M2_7\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_1_19_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1100110010100000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(19),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(212),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_0\(19),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_M2\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_M2_7\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_1_16_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1100110010100000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(16),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(215),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_0\(16),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_M2\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_M2_7\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_1_15_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1100110010100000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(15),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(216),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_0\(15),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_M2\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_M2_7\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_1_10_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1110010011110000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(10),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN25_NOTXZYFROMD\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_0\(10),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_M1_E\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_M1_0\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_6_21_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0001101100011011")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(21),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(1),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8\(21),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8\(19));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_6_23_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010011100100111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(23),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(1),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8\(21),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8\(23));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_6_25_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0001101100011011")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(25),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(1),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8\(25),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8\(23));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_6_36_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010011100100111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(36),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(1),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8\(34),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8\(36));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_6_38_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010011100100111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(38),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(1),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8\(36),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8\(38));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_6_34_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0001101100011011")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(34),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(1),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8\(34),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8\(32));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_6_30_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0001101100011011")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(30),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(1),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8\(30),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8\(28));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_6_32_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010011100100111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(32),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(1),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8\(30),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8\(32));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_0_56_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1111101111101010")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES_0\(56),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(1),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(0),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_20\(57),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_20\(56));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_0_48_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010011100100111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES_0\(48),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26\(49),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26\(48));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_0_50_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010011100100111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES_0\(50),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26\(51),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26\(50));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_0_52_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010011100100111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES_0\(52),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26\(53),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26\(52));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_EXPADDERSHFT_EXPXBUS_3_1_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000111100001110")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.EXPXBUS_3\(1),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(33),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(29),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.EXPXBUS_3_A\(1),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.COMPUTECONST.UN25_RESVEC_1\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_EXPADDERSHFT_EXPXBUS_3_A_1_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0011010100001111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.EXPXBUS_3_A\(1),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(243),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(256),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(34),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(33));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_26_1_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0001101100011011")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26\(1),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(1),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_20\(1),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_20\(3));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_26_2_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0001101100011011")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26\(2),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(1),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_20\(2),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_20\(4));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_0_27_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010011100100111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES_0\(27),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26\(28),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26\(27));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_0_49_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010011100100111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES_0\(49),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26\(50),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26\(49));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_0_51_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010011100100111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES_0\(51),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26\(52),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26\(51));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_0_45_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010011100100111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES_0\(45),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26\(46),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26\(45));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_0_5_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010011100100111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES_0\(5),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26\(6),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26\(5));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_0_8_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010011100100111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES_0\(8),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26\(9),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26\(8));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_0_11_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0001101100011011")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES_0\(11),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26\(11),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26\(12));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_0_14_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010011100100111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES_0\(14),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26\(15),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26\(14));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_0_17_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0001101100011011")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES_0\(17),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26\(17),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26\(18));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_0_19_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0001101100011011")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES_0\(19),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26\(19),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26\(20));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_0_20_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010011100100111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES_0\(20),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26\(21),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26\(20));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_0_22_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010011100100111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES_0\(22),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26\(23),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26\(22));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_0_24_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0001101100011011")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES_0\(24),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26\(24),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26\(25));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_0_25_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010011100100111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES_0\(25),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26\(26),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26\(25));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_0_26_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0001101100011011")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES_0\(26),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26\(26),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26\(27));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_0_28_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010011100100111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES_0\(28),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26\(29),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26\(28));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_0_30_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0100010011111010")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES_0\(30),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_20\(30),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_20\(32),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES_0_A\(30));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_0_A_30_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0001010110011101")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES_0_A\(30),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(1),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(0),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_20\(31),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_20\(33));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_0_31_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0101000011101110")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES_0\(31),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_20\(33),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_20\(31),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES_0_A\(31));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_0_A_31_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0001100101011101")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES_0_A\(31),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(1),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(0),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_20\(34),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_20\(32));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_0_33_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010011100100111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES_0\(33),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26\(34),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26\(33));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_0_34_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010011100100111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES_0\(34),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26\(35),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26\(34));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_0_37_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010011100100111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES_0\(37),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26\(38),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26\(37));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_0_38_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010011100100111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES_0\(38),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26\(39),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26\(38));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_0_39_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010011100100111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES_0\(39),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26\(40),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26\(39));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_0_40_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010011100100111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES_0\(40),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26\(41),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26\(40));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_0_41_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010011100100111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES_0\(41),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26\(42),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26\(41));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_0_42_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010011100100111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES_0\(42),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26\(43),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26\(42));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_0_44_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010011100100111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES_0\(44),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26\(45),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26\(44));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_0_6_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0001101100011011")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES_0\(6),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26\(6),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26\(7));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_0_7_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0001101100011011")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES_0\(7),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26\(7),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26\(8));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_0_9_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0001101100011011")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES_0\(9),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26\(9),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26\(10));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_0_18_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010011100100111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES_0\(18),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26\(19),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26\(18));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_0_21_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010011100100111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES_0\(21),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26\(22),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26\(21));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_0_23_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010011100100111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES_0\(23),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26\(24),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26\(23));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_0_32_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0101000011101110")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES_0\(32),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_20\(34),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_20\(32),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES_0_A\(32));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_0_A_32_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0001100101011101")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES_0_A\(32),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(1),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(0),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_20\(35),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_20\(33));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_0_36_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010011100100111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES_0\(36),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26\(37),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26\(36));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_0_47_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010011100100111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES_0\(47),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26\(48),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26\(47));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_46_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0001010000000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_46__G2\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(78),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(80),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(81),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_MUX_2\(17));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_21_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010100000100000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_21__G2\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(78),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(80),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_MUX_10\(41),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_MUX_13\(41));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_20_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1001000110000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_20__G2\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(81),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_20__G2_A\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_9_0__ROM_41\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_9_0__ROM_15\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_0_20_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000010100101111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_20__G2_A\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(78),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(80),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(81),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_GRFPUE_ADD10_RNIED4Q: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010101010101000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRTOSTICKY\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.TEMP\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.GRFPUE_ADD10\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.GRFPUE_ADD11\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.UN12_SRTOSTICKY_3\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_1_41_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1100110010100000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(41),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(190),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_0\(41),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_M2_REP1\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_M2_7_REP1\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_1_51_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1100110010100000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(51),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(180),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_0\(51),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_M2_REP1\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_M2_7_REP1\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_1_52_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1100110010100000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(52),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(179),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_0\(52),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_M2_REP1\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_M2_7_REP1\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_1_55_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1100110010100000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(55),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(176),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_0\(55),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_M2_REP1\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_M2_7_REP1\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_0_15_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0001101100011011")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES_0\(15),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26\(15),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26\(16));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_0_57_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1111111011111110")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES_0\(57),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(1),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(0),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_20\(57));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_RIGHTSHIFTERBL_UN40_SHDVAR: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1111111000000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.UN40_SHDVAR\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.UN38_SHDVAR_2_0\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.UN38_SHDVAR_3\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.UN38_SHDVAR_2\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(3));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_54_TRFWWBASICCELL_TEMP2_1_RNIDJ89: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_1299_V\(0),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.54.TRFWWBASICCELL.TEMP2_1\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN20_ZERO\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_26_0_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0001101100011011")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26\(0),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(1),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_20\(0),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_20\(2));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_55_TRFWWBASICCELL_TEMP2_2_RNIFA6C: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7356\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.55.TRFWWBASICCELL.TEMP2_2\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN20_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_54_TRFWWBASICCELL_TEMP2_3_RNILIAH: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.54.TRFWWBASICCELL.CIN\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.54.TRFWWBASICCELL.TEMP2_3\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN35_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_53_TRFWWBASICCELL_TEMP2_1_RNIIRCE: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_1299_V\(1),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.53.TRFWWBASICCELL.TEMP2_1\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN35_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_55_TRFWWBASICCELL_TEMP2_RNI11A4: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.55.TRFWWBASICCELL.CIN_9\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.55.TRFWWBASICCELL.TEMP2\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN50_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_1_TRFWWBASICCELL_TEMP2_3_RNIQ4OH: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.4.CI_54_V\(3),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.1.TRFWWBASICCELL.TEMP2_3\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN50_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_2_TRFWWBASICCELL_TEMP2_RNI9G59: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.5.CI_53_V\(3),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.2.TRFWWBASICCELL.TEMP2\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN50_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_3_TRFWWBASICCELL_TEMP2_2_RNIRIJ7: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.6.CI_52_V\(3),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.3.TRFWWBASICCELL.TEMP2_2\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN50_ZERO\);
GRLFPC20_MOV_7_SQMUXA: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000000000000000")
port map (
combout => \GRLFPC20.MOV_7_SQMUXA\,
dataa => N_62,
datab => N_64,
datac => \GRLFPC20.COMB.FPDECODE.FPOP3_0\,
datad => \GRLFPC20.COMB.V.A.RF1REN_1_0_650_A2_3_X\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_6_54_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010011100100111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(54),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(1),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8\(52),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8\(54));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_6_55_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0001101100011011")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(55),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(1),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8\(55),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8\(53));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_6_53_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010011100100111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(53),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(1),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8\(51),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8\(53));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_6_29_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0001101100011011")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(29),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(1),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8\(29),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8\(27));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_6_28_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010011100100111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(28),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(1),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8\(26),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8\(28));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_1_43_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1100110010100000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(43),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(188),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_0\(43),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_M2_REP1\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_M2_7_REP1\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_47_TRFWWBASICCELL_TEMP2_RNI52SK: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.49.CI_9_V\(2),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.47.TRFWWBASICCELL.TEMP2\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN35_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_48_TRFWWBASICCELL_TEMP2_2_RNINMCS: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.50.CI_8_V\(2),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.48.TRFWWBASICCELL.TEMP2_2\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN35_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_32_TRFWWBASICCELL_TEMP2_3_RNIE7HF: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.35.CI_23_V\(3),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.32.TRFWWBASICCELL.TEMP2_3\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN50_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_48_TRFWWBASICCELL_TEMP2_3_RNIL9OH: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.51.CI_7_V\(3),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.48.TRFWWBASICCELL.TEMP2_3\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN50_ZERO\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_173_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1100101000000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_173__G0_I\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(173),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_ADD0\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_SN_M2_0\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_SN_M3_1\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_0_55_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1100100011111011")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES_0\(55),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(1),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(0),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_20\(56),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26\(55));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_0_TRFWWBASICCELL_CIN_1: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.0.TRFWWBASICCELL.CIN\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.0.TRFWWBASICCELL.TEMP2\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN20_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_0_TRFWWBASICCELL_TEMP2_2_RNIODQE: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.0.TRFWWBASICCELL.CIN_4\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.0.TRFWWBASICCELL.TEMP2_2\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN50_ZERO\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_0_43_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010011100100111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES_0\(43),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26\(44),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26\(43));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_1_14_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1110010011110000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(14),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN25_NOTXZYFROMD\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_0\(14),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_M1_E_3\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_M1_0\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_13_TRFWWBASICCELL_TEMP2_3_RNIASNJ: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.14.CI_44_V\(1),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.13.TRFWWBASICCELL.TEMP2_3\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN20_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_12_TRFWWBASICCELL_TEMP2_RNINN5G: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.13.CI_45_V\(1),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.12.TRFWWBASICCELL.TEMP2\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN20_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_MULTIPLELOGIC_UN50_ZERO: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0111111001111110")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN50_ZERO\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH_0\(1),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH_0\(0),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH_134\(2));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_12_TRFWWBASICCELL_TEMP2_2_RNIE4SO: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.14.CI_44_V\(2),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.12.TRFWWBASICCELL.TEMP2_2\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN35_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_22_TRFWWBASICCELL_TEMP2_2_RNIFSGP: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.24.CI_34_V\(2),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.22.TRFWWBASICCELL.TEMP2_2\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN35_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_11_TRFWWBASICCELL_TEMP2_RNIPK05: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.14.CI_44_V\(3),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.11.TRFWWBASICCELL.TEMP2\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN50_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_12_TRFWWBASICCELL_TEMP2_1_RNIAN7E: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.15.CI_43_V\(3),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.12.TRFWWBASICCELL.TEMP2_1\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN50_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_13_TRFWWBASICCELL_TEMP2_1_RNIBE5H: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.16.CI_42_V\(3),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.13.TRFWWBASICCELL.TEMP2_1\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN50_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_14_TRFWWBASICCELL_TEMP2_RNISJOE: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.17.CI_41_V\(3),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.14.TRFWWBASICCELL.TEMP2\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN50_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_12_TRFWWBASICCELL_TEMP2_3_RNISVAC: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.12.CI_46_V\(0),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.12.TRFWWBASICCELL.TEMP2_3\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN5_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_13_TRFWWBASICCELL_TEMP2_RNIB794: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.13.CI_45_V\(0),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.13.TRFWWBASICCELL.TEMP2\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN5_ZERO\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_SXC_SCTRL_NEW_8_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1111110010101010")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SXC.SCTRL_NEW\(8),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(8),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(1),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SXC.SCTRL_NEW_A\(8),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SXC.RNDMODESELECT.TEMP\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_SXC_SCTRL_NEW_A_8_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1111010001000100")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SXC.SCTRL_NEW_A\(8),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(2),
datab => \GRLFPC20.R.FSR.RD\(1),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(21),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.UN2_NOTABORTWB\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_0_53_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0001101100011011")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES_0\(53),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26\(53),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26\(54));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_UN2_NOTABORTWB: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1100110111001101")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.UN2_NOTABORTWB\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.NOTABORTNULLEXC\,
datab => \GRLFPC20.FPI.LDOP\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.PCTRL_NEW\(77));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_0_46_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010011100100111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES_0\(46),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26\(47),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26\(46));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_COUNTSUCCESSIVEZERO_M14_1_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1100101011001010")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.COUNTSUCCESSIVEZERO_M14\(1),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.COUNTSUCCESSIVEZERO_M12\(1),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.COUNTSUCCESSIVEZERO_M13\(1),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.COUNTSUCCESSIVEZERO_M14S2\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_COUNTSUCCESSIVEZERO_M14_0_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1100101011001010")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.COUNTSUCCESSIVEZERO_M14\(0),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.COUNTSUCCESSIVEZERO_M12\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.COUNTSUCCESSIVEZERO_M13\(0),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.COUNTSUCCESSIVEZERO_M14S2\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_0_54_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010011100100111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES_0\(54),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26\(55),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26\(54));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_COUNTSUCCESSIVEZERO_M14_2_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1100101011001010")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.COUNTSUCCESSIVEZERO_M14\(2),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.COUNTSUCCESSIVEZERO_M12\(2),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.COUNTSUCCESSIVEZERO_M13\(2),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.COUNTSUCCESSIVEZERO_M14S2\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_COUNTSUCCESSIVEZERO_M14_3_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1111000011101110")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.COUNTSUCCESSIVEZERO_M14\(3),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.COUNTSUCCESSIVEZERO_M2\(2),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.COUNTSUCCESSIVEZERO_M5S4\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.COUNTSUCCESSIVEZERO_M13\(3),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.COUNTSUCCESSIVEZERO_M14S2\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_EXPADDERSHFT_EXPXBUS_3_0_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000111000001111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.EXPXBUS_3\(0),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(33),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(29),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.EXPXBUS_3_A\(0),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.COMPUTECONST.UN25_RESVEC_1\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_EXPADDERSHFT_EXPXBUS_3_A_0_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0011010100001111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.EXPXBUS_3_A\(0),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(244),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(257),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(34),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(33));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_EXPADDERSHFT_EXPXBUS_3_3_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000111100001110")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.EXPXBUS_3\(3),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(33),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(29),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.EXPXBUS_3_A\(3),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.EXPYBUS_2_1\(9));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_EXPADDERSHFT_EXPXBUS_3_A_3_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0011010100001111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.EXPXBUS_3_A\(3),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(241),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(254),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(34),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(33));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_EXPADDERSHFT_EXPXBUS_3_7_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1110001011000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.EXPXBUS_3\(7),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(34),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(33),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.EXPXBUS_2\(7),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.EXPYBUS_2\(9));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_EXPADDERSHFT_EXPXBUS_3_8_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1110001011000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.EXPXBUS_3\(8),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(34),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(33),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.EXPXBUS_2\(8),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.EXPYBUS_2\(9));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_EXPADDERSHFT_EXPXBUS_3_9_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1110001011000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.EXPXBUS_3\(9),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(34),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(33),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.EXPXBUS_2\(9),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.EXPYBUS_2\(9));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_EXPADDERSHFT_GRFPUELOC_6_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0110011001100110")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.GRFPUELOC\(6),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(36),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.EXPYBUS\(6));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_EXPYBUS_9_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1110000000100000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.EXPYBUS\(9),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(235),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(32),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(31),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.EXPYBUS_2\(9));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_EXPYBUS_7_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1110000000100000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.EXPYBUS\(7),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(237),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(32),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(31),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.EXPYBUS_2\(9));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_EXPYBUS_8_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1110000000100000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.EXPYBUS\(8),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(236),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(32),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(31),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.EXPYBUS_2\(9));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_2_240_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010110010101100")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_2\(240),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1\(240),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_0\(240),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_SN_M2\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_2_241_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010110010101100")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_2\(241),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1\(241),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_0\(241),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_SN_M2\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_2_242_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010110010101100")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_2\(242),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1\(242),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_0\(242),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_SN_M2\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_2_238_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010110010101100")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_2\(238),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1\(238),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_0\(238),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_SN_M2\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_2_244_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010110010101100")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_2\(244),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1\(244),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_0\(244),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_SN_M2\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_2_243_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010110010101100")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_2\(243),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1\(243),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_0\(243),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_SN_M2\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_2_239_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010110010101100")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_2\(239),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1\(239),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_0\(239),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_SN_M2\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_2_237_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010110010101100")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_2\(237),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1\(237),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_0\(237),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_SN_M2\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_EXPADDERSHFT_GRFPUELOC_5_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0110011001100110")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.GRFPUELOC\(5),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(36),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.EXPYBUS\(5));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_1_36_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1100110010100000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(36),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(195),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_0\(36),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_M2\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_M2_7_REP1\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_35_TRFWWBASICCELL_TEMP2_1_RNIFCA8: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.38.CI_20_V\(3),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.35.TRFWWBASICCELL.TEMP2_1\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN50_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_36_TRFWWBASICCELL_TEMP2_3_RNII38B: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.39.CI_19_V\(3),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.36.TRFWWBASICCELL.TEMP2_3\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN50_ZERO\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_67_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000001100001001")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.PCTRL_NEW_6_0_67__G3\,
dataa => N_54,
datab => N_62,
datac => N_56,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.MAPMULXFF.UN4_UNIMPMAP_1_X\);
GRLFPC20_COMB_LOCKGEN_LOCKI_I_0_0_A2_0: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000011100001111")
port map (
combout => \GRLFPC20.COMB.LOCKGEN.LOCKI_I_0_0_A2_0\,
dataa => N_73,
datab => N_74,
datac => \GRLFPC20.RS2_0_SQMUXA\,
datad => \GRLFPC20.COMB.FPDECODE.ST3_1\);
GRLFPC20_V_FSR_FTT_1_SQMUXA_0_RNIDF1F1: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1011101011111010")
port map (
combout => \GRLFPC20.UN1_FPCI_13\,
dataa => \GRLFPC20.COMB.UN1_FPCI_0_X\,
datab => \GRLFPC20.R.X.AFQ\,
datac => \GRLFPC20.V.FSR.FTT_1_SQMUXA_0\,
datad => \GRLFPC20.COMB.QNE2\);
GRLFPC20_R_X_AFQ_RNI5DJ81: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010101110101111")
port map (
combout => \GRLFPC20.UN1_FPCI_2\,
dataa => \GRLFPC20.COMB.UN1_FPCI_0_X\,
datab => \GRLFPC20.R.X.AFQ\,
datac => \GRLFPC20.R.X.SEQERR\(0),
datad => \GRLFPC20.COMB.QNE2\);
GRLFPC20_COMB_RDD_2: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1110010011110000")
port map (
combout => \GRLFPC20.COMB.RDD_2\,
dataa => \GRLFPC20.COMB.UN1_FPCI_0_X\,
datab => \GRLFPC20.R.X.RDD\(0),
datac => \GRLFPC20.R.I.RDD\,
datad => \GRLFPC20.COMB.UN1_R.I.V_0\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_0_35_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010011100100111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES_0\(35),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26\(36),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26\(35));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_6_51_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010011100100111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(51),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(1),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8\(49),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8\(51));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_6_49_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010011100100111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(49),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(1),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8\(47),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8\(49));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_6_47_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010011100100111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(47),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(1),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8\(45),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8\(47));
\GRLFPC20_COMB_V_FSR_CEXC_1_2_4_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100000001111")
port map (
combout => \GRLFPC20.COMB.V.FSR.CEXC_1_2\(4),
dataa => \GRLFPC20.R.I.EXC\(4),
datab => \GRLFPC20.R.FSR.TEM\(4),
datac => \GRLFPC20.COMB.V.FSR.CEXC_1_2_A_X\(4),
datad => \GRLFPC20.COMB.V.FSR.CEXC_1_SN_M2\);
\GRLFPC20_COMB_V_FSR_CEXC_1_2_3_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100000001111")
port map (
combout => \GRLFPC20.COMB.V.FSR.CEXC_1_2\(3),
dataa => \GRLFPC20.R.I.EXC\(3),
datab => \GRLFPC20.R.FSR.TEM\(3),
datac => \GRLFPC20.COMB.V.FSR.CEXC_1_2_A_X\(3),
datad => \GRLFPC20.COMB.V.FSR.CEXC_1_SN_M2\);
\GRLFPC20_COMB_V_FSR_CEXC_1_2_2_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100000001111")
port map (
combout => \GRLFPC20.COMB.V.FSR.CEXC_1_2\(2),
dataa => \GRLFPC20.R.I.EXC\(2),
datab => \GRLFPC20.R.FSR.TEM\(2),
datac => \GRLFPC20.COMB.V.FSR.CEXC_1_2_A_X\(2),
datad => \GRLFPC20.COMB.V.FSR.CEXC_1_SN_M2\);
\GRLFPC20_COMB_V_FSR_CEXC_1_2_1_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100000001111")
port map (
combout => \GRLFPC20.COMB.V.FSR.CEXC_1_2\(1),
dataa => \GRLFPC20.R.I.EXC\(1),
datab => \GRLFPC20.R.FSR.TEM\(1),
datac => \GRLFPC20.COMB.V.FSR.CEXC_1_2_A_X\(1),
datad => \GRLFPC20.COMB.V.FSR.CEXC_1_SN_M2\);
\GRLFPC20_COMB_V_FSR_CEXC_1_2_0_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100000001111")
port map (
combout => \GRLFPC20.COMB.V.FSR.CEXC_1_2\(0),
dataa => \GRLFPC20.R.I.EXC\(0),
datab => \GRLFPC20.R.FSR.TEM\(0),
datac => \GRLFPC20.COMB.V.FSR.CEXC_1_2_A_X\(0),
datad => \GRLFPC20.COMB.V.FSR.CEXC_1_SN_M2\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_20_TRFWWBASICCELL_TEMP2_3_RNIEELJ: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.22.CI_36_V\(2),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.20.TRFWWBASICCELL.TEMP2_3\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN35_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_20_TRFWWBASICCELL_TEMP2_2_RNIQ947: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.20.CI_38_V\(0),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.20.TRFWWBASICCELL.TEMP2_2\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN5_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_21_TRFWWBASICCELL_TEMP2_RNIAJBE: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.21.CI_37_V\(0),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.21.TRFWWBASICCELL.TEMP2\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN5_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_0_TRFWWBASICCELL_TEMP2_3_RNISQEP: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.0.TRFWWBASICCELL.CIN_1\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.0.TRFWWBASICCELL.TEMP2_3\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN35_ZERO\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_0_29_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0100010011111010")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES_0\(29),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_20\(29),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_20\(31),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES_0_A\(29));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_0_A_29_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0001010110011101")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES_0_A\(29),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(1),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(0),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_20\(30),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_20\(32));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_1_20_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1100110010100000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(20),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(211),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_0\(20),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_M2\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_M2_7\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_1_27_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1100110010100000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(27),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(204),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_0\(27),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_M2\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_M2_7\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_0_3_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010011100100111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSRRES_0\(3),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26\(4),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26\(3));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_26_TRFWWBASICCELL_TEMP2_3_RNIKO7L: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.28.CI_30_V\(2),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.26.TRFWWBASICCELL.TEMP2_3\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN35_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_27_TRFWWBASICCELL_TEMP2_2_RNIKF5O: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.29.CI_29_V\(2),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.27.TRFWWBASICCELL.TEMP2_2\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN35_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_51_TRFWWBASICCELL_TEMP2_2_RNIHDHO: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.53.CI_5_V\(2),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.51.TRFWWBASICCELL.TEMP2_2\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN35_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_52_TRFWWBASICCELL_TEMP2_3_RNIJ4FR: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.54.CI_4_V\(2),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.52.TRFWWBASICCELL.TEMP2_3\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN35_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_25_TRFWWBASICCELL_TEMP2_RNIUUI2: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.28.CI_30_V\(3),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.25.TRFWWBASICCELL.TEMP2\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN50_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_26_TRFWWBASICCELL_TEMP2_RNIVJ5B: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.29.CI_29_V\(3),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.26.TRFWWBASICCELL.TEMP2\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN50_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_25_TRFWWBASICCELL_TEMP2_2_RNIVSO5: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.25.CI_33_V\(0),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.25.TRFWWBASICCELL.TEMP2_2\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN5_ZERO\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_26_TRFWWBASICCELL_TEMP2_1_RNIVJM8: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000100010001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.26.CI_32_V\(0),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.26.TRFWWBASICCELL.TEMP2_1\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.UN5_ZERO\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_R_SCTRL_39_IV_RNO_0_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0001000000010000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL_I_M_1\(13),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(22),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(13),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SXC.SFTLFT.UN4_TEMP\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_EXTEND_TEMP_1_0_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1111111111101010")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.EXTEND.TEMP_1\(0),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(15),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.UN38_SHDVAR_3\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN3_NOTXZYFROMD\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN26_XZYBUSLSBS\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_ENTRYSHFT_UN3_S_SQRT_3: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010000000000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.ENTRYSHFT.UN3_S_SQRT_3\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(85),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(83),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.ENTRYSHFT.UN3_S_SQRT_1\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_INEXACTSIG_UN13_INEXACT_24: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000000000010000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.INEXACTSIG.UN13_INEXACT_24\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(37),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(52),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.INEXACTSIG.UN13_INEXACT_13\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.UN38_SHDVAR_2\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_INEXACTSIG_UN13_INEXACT_23: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0001000000000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.INEXACTSIG.UN13_INEXACT_23\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(39),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(54),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.INEXACTSIG.UN13_INEXACT_10\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.INEXACTSIG.UN13_INEXACT_18\);
\GRLFPC20_R_FSR_FTT_RNO_0_1_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1110000000000000")
port map (
combout => \GRLFPC20.R.FSR.FTT_1_0_1__G2_0_624_I_1\,
dataa => \GRLFPC20.R.I.EXEC\,
datab => \GRLFPC20.R.X.FPOP\,
datac => \GRLFPC20.R.I.EXC\(5),
datad => \GRLFPC20.R.FSR.FTT_1_0_0__G2_0_600_I_0_X\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNIJFAQ_229_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000000001110000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_M4_1_0\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(11),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(13),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(229),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN15_NOTXZYFROMD_0_REP2\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_EXPADDERSHFT_UN23_EXPXBUS_11_0: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0110011001100110")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.UN23_EXPXBUS_11_0\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(36),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.EXPXBUS_3\(11));
\GRLFPC20_R_X_SEQERR_RNI435M_0_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000000100000000")
port map (
combout => \GRLFPC20.R.FSR.FTT_1_0_0__G2_0_600_I_A6_1_0\,
dataa => N_354,
datab => N_353,
datac => N_4,
datad => \GRLFPC20.R.X.SEQERR\(0));
GRLFPC20_R_A_MOV_RNO_0: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0001000000000000")
port map (
combout => \GRLFPC20.R.A.MOV_0_0_G1_3\,
dataa => N_55,
datab => N_56,
datac => \GRLFPC20.R.A.MOV_0_0_G1_1_X\,
datad => \GRLFPC20.COMB.FPDECODE.RDD5_3_0_A2_X\);
GRLFPC20_MOV_2_SQMUXA_2: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000000100000000")
port map (
combout => \GRLFPC20.MOV_2_SQMUXA_2\,
dataa => N_55,
datab => N_56,
datac => N_52,
datad => \GRLFPC20.COMB.FPDECODE.RDD4_0_A2_X\);
GRLFPC20_COMB_FPDECODE_FPOP8_I_O3_X_RNI13GO1: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000000000100000")
port map (
combout => \GRLFPC20.R.A.AFQ_0_0_G1_0_3\,
dataa => N_64,
datab => N_62,
datac => N_67,
datad => \GRLFPC20.COMB.FPDECODE.FPOP8_I_O3_X\);
GRLFPC20_COMB_FPDECODE_RDD5_0_A3: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010000000000000")
port map (
combout => \GRLFPC20.COMB.FPDECODE.RDD5_0_A3\,
dataa => N_49,
datab => N_48,
datac => \GRLFPC20.COMB.FPDECODE.RDD5_3_0_A2_X\,
datad => \GRLFPC20.COMB.RSDECODE.UN1_FPCI_0_X\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_8_0__ROM_52_RNIJOM31\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000000100000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_9__G4\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(80),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(81),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_8_0__ROM_52\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_RIGHTSHIFTERBL_UN17_SHDVAR: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0111000000000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.UN17_SHDVAR\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(48),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(3),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.UN17_SHDVAR_A\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.UN17_SHDVAR_0\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_RIGHTSHIFTERBL_UN17_SHDVAR_A: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0011001100000101")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.UN17_SHDVAR_A\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(57),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(49),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(56),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(3));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_UN3_NOTXZYFROMD: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000111110001111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN3_NOTXZYFROMD\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(1),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(16),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN3_NOTXZYFROMD_A\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_UN3_NOTXZYFROMD_A: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000011101110111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN3_NOTXZYFROMD_A\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(11),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(14),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(376),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(9));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_76_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1111111100011111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.UN33_PCTRL_NEW_I_0_G0\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(72),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(76),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(61),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.WAITMULXFF.NOTSAMPLEDWAIT\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_COUNTSUCCESSIVEZERO_M13_3_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000000000000001")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.COUNTSUCCESSIVEZERO_M13\(3),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(7),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(8),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(9),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.COUNTSUCCESSIVEZERO_M11S4\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_CTRLAREGXZ_UN5_XZAREGLOADEN: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1111111111111110")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.CTRLAREGXZ.UN5_XZAREGLOADEN\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(5),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(6),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(7),
datad => \GRLFPC20.FPI.LDOP\);
GRLFPC20_COMB_LOCKGEN_DEPCHECK: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1111111011111111")
port map (
combout => \GRLFPC20.COMB.LOCKGEN.DEPCHECK\,
dataa => \GRLFPC20.R.M.FPOP\,
datab => \GRLFPC20.R.X.FPOP\,
datac => \GRLFPC20.R.A.FPOP\,
datad => \GRLFPC20.ANNULRES_0_SQMUXA_12_1\);
GRLFPC20_COMB_UN2_HOLDN: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0100000000000000")
port map (
combout => \GRLFPC20.COMB.UN2_HOLDN\,
dataa => \GRLFPC20.COMB.UN3_HOLDN_X\,
datab => N_3,
datac => \GRLFPC20.R.A.FPOP\,
datad => \GRLFPC20.R.A.MOV\);
\GRLFPC20_R_I_EXC_RNO_1_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000000000010000")
port map (
combout => \GRLFPC20.R.I.EXC_0\(1),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(40),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(41),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DECODESTATUS.UN7_STATUS\,
datad => \GRLFPC20.COMB.UN2_HOLDN\);
\GRLFPC20_R_I_EXC_RNO_0_3_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000000000000010")
port map (
combout => \GRLFPC20.R.I.EXC_2_0_3__G3\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(38),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(39),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(40),
datad => \GRLFPC20.COMB.UN2_HOLDN\);
GRLFPC20_COMB_FPDECODE_FPOP2_0_A2: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000000010000000")
port map (
combout => \GRLFPC20.COMB.FPDECODE.FPOP2_0_A2\,
dataa => N_64,
datab => N_66,
datac => \GRLFPC20.COMB.RDD_1.M10_2_0_A2_X\,
datad => \GRLFPC20.COMB.FPDECODE.FPOP2_0_O2_X\);
GRLFPC20_COMB_LOCK_1: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000000100000000")
port map (
combout => CPO_LDLOCKZ,
dataa => N_77,
datab => \GRLFPC20.R.STATE\(0),
datac => \GRLFPC20.R.STATE\(1),
datad => \GRLFPC20.COMB.LOCK_1_1_X\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_ENTRYSHFT_S_CMP: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000001000000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.ENTRYSHFT.S_CMP\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(82),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(85),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.ENTRYSHFT.S_CMP_2\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_UN3_NOTXZYFROMD_RNIUMVM: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000000000000100")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_M2\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN13_NOTXZYFROMD_REP2\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN25_NOTXZYFROMD\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN15_NOTXZYFROMD_0_REP2\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN3_NOTXZYFROMD\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_UN3_NOTXZYFROMD_RNIV28P: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000000100000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_M1_E\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN13_NOTXZYFROMD_REP2\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN15_NOTXZYFROMD_0_REP2\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN3_NOTXZYFROMD\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_M1_E_0\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_UN3_NOTXZYFROMD_RNI477P: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000000100000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_M1_E_3\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN13_NOTXZYFROMD_REP2\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN15_NOTXZYFROMD_0_REP2\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN3_NOTXZYFROMD\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_M1_E_3_0\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNIK3451_13_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000011111111000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_M1_0\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(11),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(13),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN15_NOTXZYFROMD_0_REP2\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN3_NOTXZYFROMD\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_GRFPUE_ADD12_RNI5OTA1: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000000000000010")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.DPATH_M2_E\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(47),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.GRFPUE_ADD12\,
datac => \GRLFPC20.FPI.LDOP\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_ADD57\);
GRLFPC20_R_A_MOV_RNIOME21: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1000101010101010")
port map (
combout => \GRLFPC20.R.I.RDD_0_0_G1_0_574_I_0\,
dataa => N_1,
datab => \GRLFPC20.COMB.UN3_HOLDN_X\,
datac => \GRLFPC20.R.A.FPOP\,
datad => \GRLFPC20.R.A.MOV\);
GRLFPC20_V_FSR_AEXC_1_SQMUXA_0: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0111111100000000")
port map (
combout => \GRLFPC20.V.FSR.AEXC_1_SQMUXA_0\,
dataa => N_389,
datab => N_388,
datac => N_390,
datad => \GRLFPC20.V.FSR.NONSTD_0_SQMUXA_2_X\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_MUX_7_0_A2_19_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0001000000000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_MUX_7_0_A2\(19),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(80),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(81),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_3_0__ROM_47\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_0_41_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0001000000000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_41__G3\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(80),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(81),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_4_0__ROM_21\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_MUX_14_59_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0100010001000100")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_MUX_14\(59),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(80),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_MUX_10\(59));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_MUX_14_54_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0100010001000100")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_MUX_14\(54),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(80),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_MUX_10\(54));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_MUX_14_39_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0100010001000100")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_MUX_14\(39),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(80),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_MUX_10\(39));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_MUX_14_16_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0100010001000100")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_MUX_14\(16),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(80),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_MUX_10\(16));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_MUX_7_47_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0100010001000100")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_MUX_7\(47),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(80),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_MUX_3\(47));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_MUX_7_46_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000000001010001")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_MUX_7\(46),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(80),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_4_0__ROM_46\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_MUX_7_A\(46));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_MUX_7_A_46_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0100011001010111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_MUX_7_A\(46),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(81),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_1_0__ROM_45\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_0__ROM_22\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_MUX_7_27_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0100010001000100")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_MUX_7\(27),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(80),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_MUX_3\(27));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_R_DPATH_0_RNIRQQ9_5_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0111000001110000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULLSBLOGIC.TEMP_0\(0),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH_0\(5),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH_118\(6),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH_125\(4));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_MULLSBLOGIC_TEMP_0_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0111000001110000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULLSBLOGIC.TEMP\(0),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH_0\(3),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH_125\(4),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH_134\(2));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_R_DPATH_0_RNIP5VG_7_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0111000001110000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULLSBLOGIC.TEMP_2\(0),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH_0\(7),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH_0\(8),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH_118\(6));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_EXPADDERSHFT_GRFPUELOC_4_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0110110001101100")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.GRFPUELOC\(4),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(31),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(36),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.EXPYBUS_0\(4));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_UN18_XZXBUS_57: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0111100001111000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN18_XZXBUS_57\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(17),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(58),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(57));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_UN18_XZXBUS_31: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0110011001100110")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN18_XZXBUS_31\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZXBUS\(31),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(31));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_2_57_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010111011010001")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_2\(57),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(19),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(8),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(58),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(57));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_2_31_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0010111011010001")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_2\(31),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(19),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(8),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(58),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(31));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_AEBEEXC_UN4_NOTBINFNAN: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0000000001111111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.AEBEEXC.UN4_NOTBINFNAN\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(247),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(249),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(248),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(10));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_M0_115_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010000011001100")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_M0\(115),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(118),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(115),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.ROMXZSL2FROMC\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.XZBREGLOADEN_REP1\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_M3_61_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1011100010111000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_M3\(61),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(61),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.DPATH_NEW_7_SQMUXA\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_M2\(61));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_M3_62_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1011100010111000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_M3\(62),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(62),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.DPATH_NEW_7_SQMUXA\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_M2\(62));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_M3_63_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1011100010111000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_M3\(63),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(63),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.DPATH_NEW_7_SQMUXA\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_M2\(63));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_M3_64_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1011100010111000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_M3\(64),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(64),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.DPATH_NEW_7_SQMUXA\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_M2\(64));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_M3_65_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1011100010111000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_M3\(65),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(65),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.DPATH_NEW_7_SQMUXA\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_M2\(65));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_M3_66_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1011100010111000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_M3\(66),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(66),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.DPATH_NEW_7_SQMUXA\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_M2\(66));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_M3_67_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1011100010111000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_M3\(67),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(67),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.DPATH_NEW_7_SQMUXA\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_M2\(67));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_M3_68_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1011100010111000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_M3\(68),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(68),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.DPATH_NEW_7_SQMUXA\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_M2\(68));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_M3_69_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1011100010111000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_M3\(69),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(69),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.DPATH_NEW_7_SQMUXA\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_M2\(69));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_M3_70_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1011100010111000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_M3\(70),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(70),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.DPATH_NEW_7_SQMUXA\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_M2\(70));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_M3_71_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1011100010111000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_M3\(71),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(71),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.DPATH_NEW_7_SQMUXA\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_M2\(71));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_M3_72_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1011100010111000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_M3\(72),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(72),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.DPATH_NEW_7_SQMUXA\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_M2\(72));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_M3_73_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1011100010111000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_M3\(73),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(73),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.DPATH_NEW_7_SQMUXA\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_M2\(73));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_M3_74_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1011100010111000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_M3\(74),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(74),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.DPATH_NEW_7_SQMUXA\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_M2\(74));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_M3_75_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1011100010111000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_M3\(75),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(75),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.DPATH_NEW_7_SQMUXA\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_M2\(75));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_M3_76_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1011100010111000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_M3\(76),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(76),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.DPATH_NEW_7_SQMUXA\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_M2\(76));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_M3_77_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1011100010111000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_M3\(77),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(77),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.DPATH_NEW_7_SQMUXA\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_M2\(77));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_M3_78_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1011100010111000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_M3\(78),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(78),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.DPATH_NEW_7_SQMUXA\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_M2\(78));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_M3_79_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1011100010111000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_M3\(79),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(79),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.DPATH_NEW_7_SQMUXA\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_M2\(79));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_M3_80_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1011100010111000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_M3\(80),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(80),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.DPATH_NEW_7_SQMUXA\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_M2\(80));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_M3_81_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1011100010111000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_M3\(81),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(81),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.DPATH_NEW_7_SQMUXA\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_M2\(81));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_M3_82_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1011100010111000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_M3\(82),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(82),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.DPATH_NEW_7_SQMUXA\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_M2\(82));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_1_0_46_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010101010101100")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_0\(46),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(11),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(10),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN13_NOTXZYFROMD_REP1\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN15_NOTXZYFROMD_0_REP1\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_1_0_39_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010101010101100")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_0\(39),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(18),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(17),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN13_NOTXZYFROMD_REP1\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN15_NOTXZYFROMD_0_REP1\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_1_0_29_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010101010101100")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_0\(29),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(28),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(27),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN13_NOTXZYFROMD_REP1\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN15_NOTXZYFROMD_0_REP1\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_1_0_26_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010101010101100")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_0\(26),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(31),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(30),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN13_NOTXZYFROMD_REP1\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN15_NOTXZYFROMD_0\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_1_0_25_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010101010101100")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_0\(25),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(32),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(31),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN13_NOTXZYFROMD\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN15_NOTXZYFROMD_0\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_1_0_23_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010101010101100")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_0\(23),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(34),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(33),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN13_NOTXZYFROMD\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN15_NOTXZYFROMD_0\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_1_0_18_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010101010101100")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_0\(18),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(39),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(38),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN13_NOTXZYFROMD\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN15_NOTXZYFROMD_0\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_1_0_17_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010101010101100")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_0\(17),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(40),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(39),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN13_NOTXZYFROMD\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN15_NOTXZYFROMD_0\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_1_0_8_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010101010101100")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_0\(8),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(49),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(48),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN13_NOTXZYFROMD\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN15_NOTXZYFROMD_0\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_1_0_6_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1010101010101100")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_0\(6),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(51),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(50),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN13_NOTXZYFROMD\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN15_NOTXZYFROMD_0\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_3_10_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1110001011100010")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_3\(10),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(126),
datab => \GRLFPC20.FPI.LDOP\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_1\(10));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_3_12_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1110001011100010")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_3\(12),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(128),
datab => \GRLFPC20.FPI.LDOP\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_1\(12));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_3_13_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1110001011100010")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_3\(13),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(129),
datab => \GRLFPC20.FPI.LDOP\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_1\(13));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_3_16_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1110001011100010")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_3\(16),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(132),
datab => \GRLFPC20.FPI.LDOP\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_1\(16));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_16_TRFWWBASICCELL_TEMP2_1: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0101101000111100")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.16.TRFWWBASICCELL.TEMP2_1\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(97),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(98),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH_125\(4),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_2\(1));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_23_TRFWWBASICCELL_TEMP2: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0101101000111100")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.23.TRFWWBASICCELL.TEMP2\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(90),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(91),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH_125\(4),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_2\(1));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_14_TRFWWBASICCELL_TEMP2_1: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0101101000111100")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.14.TRFWWBASICCELL.TEMP2_1\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(99),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(100),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH_125\(4),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_2\(1));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_15_TRFWWBASICCELL_TEMP2_1: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0101101000111100")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.15.TRFWWBASICCELL.TEMP2_1\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(98),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(99),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH_125\(4),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_2\(1));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_21_TRFWWBASICCELL_TEMP2_1: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0101101000111100")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.21.TRFWWBASICCELL.TEMP2_1\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(92),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(93),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH_125\(4),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_2\(1));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_22_TRFWWBASICCELL_TEMP2_1: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0101101000111100")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.22.TRFWWBASICCELL.TEMP2_1\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(91),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(92),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH_125\(4),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_2\(1));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_0_1_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1110010011100100")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_0\(1),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(2),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.S_8\(56),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.S_8\(57));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_2_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1110010011100100")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8\(2),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(2),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.S_8\(55),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.S_8\(57));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_3_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1110010011100100")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8\(3),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(2),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.S_8\(54),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.S_8\(57));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_4_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1110010011100100")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8\(4),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(2),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.S_8\(53),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.S_8\(57));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_5_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1110010011100100")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8\(5),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(2),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.S_8\(52),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.S_8\(56));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_6_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1110010011100100")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8\(6),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(2),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.S_8\(51),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.S_8\(55));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_7_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8\(7),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(2),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.S_8\(54),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.S_8\(50));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_8_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8\(8),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(2),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.S_8\(53),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.S_8\(49));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_9_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8\(9),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(2),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.S_8\(52),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.S_8\(48));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_10_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8\(10),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(2),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.S_8\(51),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.S_8\(47));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_11_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8\(11),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(2),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.S_8\(50),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.S_8\(46));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_12_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8\(12),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(2),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.S_8\(49),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.S_8\(45));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_13_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8\(13),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(2),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.S_8\(48),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.S_8\(44));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_14_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1110010011100100")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8\(14),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(2),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.S_8\(43),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.S_8\(47));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_15_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1110010011100100")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8\(15),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(2),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.S_8\(42),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.S_8\(46));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_16_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8\(16),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(2),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.S_8\(45),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.S_8\(41));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_17_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1110010011100100")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8\(17),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(2),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.S_8\(40),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.S_8\(44));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_18_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1111001100000101")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8\(18),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(10),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(18),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(2),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_A\(18));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_A_18_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0011010100001111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_A\(18),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(14),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(6),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(3),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(2));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_20_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1110010011100100")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8\(20),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(2),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.S_8\(37),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.S_8\(41));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_21_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8\(21),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(2),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.S_8\(40),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.S_8\(36));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_22_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8\(22),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(2),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.S_8\(39),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.S_8\(35));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_24_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1111001100000101")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8\(24),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(16),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(24),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(2),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_A\(24));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_A_24_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0011010100001111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_A\(24),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(20),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(12),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(3),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(2));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_25_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8\(25),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(2),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.S_8\(36),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.S_8\(32));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_26_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1101100011011000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8\(26),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(2),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.S_8\(35),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.S_8\(31));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_27_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1111001100000101")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8\(27),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(19),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(27),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(2),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_A\(27));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_A_27_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0011010100001111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_A\(27),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(23),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(15),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(3),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(2));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_28_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1111001100000101")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8\(28),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(20),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(28),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(2),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_A\(28));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_A_28_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0011010100001111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_A\(28),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(24),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(16),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(3),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(2));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_29_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1110010011100100")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8\(29),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(2),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.S_8\(28),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.S_8\(32));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_31_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "1111001100000101")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8\(31),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(23),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(31),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(2),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_A\(31));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_A_31_\: cycloneiii_lcell_comb generic map (
     sum_lutc_input => "datac",
    lut_mask => "0011010100001111")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_A\(31),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(27),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(19),
da